/*+-----------------------------------------------------------------------
	ecu.c - Extended Calling Unit/Call Utility/Call UNIX/whatever
	wht@n4hgf.Mt-Park.GA.US

  Defined functions:
	main(argc,argv,envp)
	xmtr()

   "Now tell me, old man, what's your name?"
   "Holloway, sir. Charles William Holloway."
   "Oh yes, the town's librarian."
   "I have the honor, sir, and have had for many years."
   "I believe all that time spent living through other men's lives,
other men's dreams, what a waste."
   "Sometimes, a man can learn more from other men's dreams than he
can from his own.  Come visit me sir, if you wish to improve your
education and I may improve yours."  -- Something Wicked This Way Comes

------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:12-20-1992-12:08-wht@n4hgf-continue -l=Devices support */
/*:12-04-1992-20:57-wht@n4hgf-add -l=Devices support */
/*:09-10-1992-13:58-wht@n4hgf-ECU release 3.20 */
/*:08-22-1992-15:38-wht@n4hgf-ECU release 3.20 BETA */
/*:08-16-1992-03:43-wht@n4hgf-add -F funckeytype */
/*:08-16-1992-03:08-wht@n4hgf-head off another POSIX plot */
/*:04-30-1992-00:49-wht@n4hgf-remove obsolete -c */
/*:04-24-1992-21:59-wht@n4hgf-more SCO tty name normalizing */
/*:04-17-1992-18:19-wht@n4hgf-"default" keyset read if present */
/*:02-16-1992-02:39-wht@n4hgf-add -P phonedir switch for rll@sco */
/*:02-16-1992-01:41-wht@n4hgf-turn off xterm_title */
/*:08-11-1991-19:56-wht@n4hgf-soup up -l for ISC vs. SCO */
/*:08-06-1991-13:02-wht@n4hgf-jpm@logixwi fix: HZ getenv test wrong sense */
/*:07-29-1991-17:57-wht@n4hgf-add memstat */
/*:07-25-1991-12:55-wht@n4hgf-ECU release 3.10 */
/*:07-17-1991-07:04-wht@n4hgf-avoid SCO UNIX nap bug */
/*:04-27-1991-01:52-wht@n4hgf-overhaul revision numbers */
/*:03-17-1991-13:44-wht@n4hgf-nice and uid revision */
/*:01-09-1991-22:31-wht@n4hgf-ISC port */
/*:11-30-1990-19:04-wht@n4hgf-new ttyinit parameter - see TTYINIT_... */
/*:11-28-1990-15:58-wht@n4hgf-add non-ansi terminal support */
/*:08-14-1990-20:39-wht@n4hgf-ecu3.00-flush old edit history */

#if !defined(XECU)
#include "ecu.h"
#include "dvent.h"
#include "esd.h"
#include "proc.h"
#include "ecukey.h"
#include "ecuxkey.h"
#include "termecu.h"

char *getenv();
void xmtr_SIGINT_handler();

extern char *makedate;			/* temporary make date */
extern char *revstr;	/* ecunumrev.c */
extern char *revision_modifier; /* ecunumrev.c */
extern ESD *icmd_prompt;
extern char kbdeof;			/* current input EOF */
extern char kbdeol2;		/* current secondary input EOL */
extern char kbdeol;			/* current input EOL */
extern char kbderase;		/* current input ERASE */
extern char kbdintr;		/* current input INTR */
extern char kbdkill;		/* current input KILL */
extern char kbdquit;		/* current input QUIT */
extern uint tcap_LINES;
extern uint tcap_COLS;
extern ulong colors_current;
extern int there_is_hdb_on_this_machine;
extern char lopen_err_str[];
extern char phonedir_name[PHONEDIR_NAME_SIZE];

char *eculibdir = ECULIBDIR;
char *dash_f_funckeytype;
char curr_dir[CURR_DIRSIZ];		/* current working directory of process */
char hello_str[128];		/* msg printed upon BOJ */
char errmsg[128];
char initial_procedure[128] = "";
char *default_tty = DEFAULT_TTY;	/* configurable default tty name */
int init_proc_argc = 0;
char *init_proc_argv[MAX_PARGV];
PID_T rcvr_pid = -1;		/* pid for rcvr process (-1 == no proc active) */
	/* ... -2 == special flag for modem control/timed-read procedures */
PID_T xmtr_pid = 0;
int quit_on_init_proc_fail = 0;
int quit_on_init_proc_done = 0;
int rc_ep_has_run = 0;
struct timeb starting_timeb;

int hz;					/* HZ from environ or sys/param.h */
ulong hzmsec;			/* clock period in msec rounded up */


#ifdef MALLOC_3X
char *sbrk();
char *startbrk;
char *startsp;
#endif

char *_rc = "_rc";	/* _rc.ep */

ushort geteuid();
ushort getuid();
ushort euid;
ushort uid;

/*+-----------------------------------------------------------------------
	xmtr() --  copy stdin to comm line

  THE INITIAL PROCESS EXECUTES THIS PROCESS UNTIL PROGRAM TERMINATION

  TTY input lines beginning with % have special significance
  (see ecuicmd.c)
------------------------------------------------------------------------*/
void
xmtr()
{
uchar xmtr_char;
uchar nlchar = NL;

	ttymode(1);
	xmtr_signals();
	while(1)
	{

#if 0
/* bug somewhere ... may be SIGINT too rapidly causing SIG_IGN ????? */
		signal(SIGINT,xmtr_SIGINT_handler);	/* so make sure */
#endif

		xmtr_char = ttygetc(1);

		if(xmtr_char & 0x80)
		{
			kbd_escape(xmtr_char);
			continue;
		}

		lputc(xmtr_char);
		if(shm->Lfull_duplex == 0)		/* echo character if asked */
			write(TTYERR,(char *)&xmtr_char,1);

		if(xmtr_char == CRET)
		{
			if(shm->Ladd_nl_outgoing)
				lputc('\n');
			if(shm->Lfull_duplex == 0)
				write(TTYERR,(char *)&nlchar,1);
		}
	}
	/*NOTREACHED*/

}	/* end of xmtr */

/*+-------------------------------------------------------------------------
	main(argc,argv,envp)

  main() program forks to create rcvr process; then main()
  becomes the xmtr process
------------------------------------------------------------------------*/
int
main(argc,argv,envp)
int argc;
char **argv;
char **envp;
{
int swchar;
int itmp;
ulong colors_save;
char *get_ttyname();
extern char *optarg;
extern int optind;

#ifdef MALLOC_3X
	startbrk = sbrk(0);			/* initial break */
	startsp = (char *)&swchar;	/* initial sp */
	(void)mallopt(M_MXFAST,256+4);
	(void)mallopt(M_NLBLKS,64);
	(void)mallopt(M_GRAIN,sizeof(ESD) + 8);
#endif

	setbuf(stderr,NULL);
	xmtr_signals();			/* catch xmtr signals */

	ftime(&starting_timeb);	/* get startup time */
	xmtr_pid = (PID_T)getpid();

	/*
	 * get this off quick, cause we'll be busy for a little while on 286
	 */
	build_revision_string();
	sprintf(hello_str,"ecu %s",revstr);
	ff(se,"%s\n",hello_str);

	/*
	 * initialize 'hz'/'hzmsec' and  Nap() implimentation
	 */
	init_Nap();

	/*
	 * if we are root (or setuid to root as we should be on 286 versions),
	 * nice to very bad
	 */
	uid = getuid();
	euid = geteuid();
	if((euid == 0) || (uid == 0))	/* if root running or prog text ... */
	{								/* ... sets to root, then grab gusto */
	int nice_value = 3;				/* go for hi priority */
	int old_nice = nice(0) + 20;
		nice(-old_nice + nice_value);
	}

	/*
	 * set uid to real uid
	 */
	if(uid != euid)				/* if user not really who he say he is ... */
	{
		if(setuid(uid))			/* ... make him so */
		{
			ff(se,"\r\n");
			perror("setuid failed");
			ff(se,"\r\n");
			exit(-1);
		}
	}

	/*
	 * Initialize shared memory segment.
	 * This must be done before any uses are made of the Lermio variable
	 * see ecushm.c and ecu.h.
	 */
	shm_init();				/* open shared segment */

	keyset_init();			/* intialize keyset */
	keyset_read("default");

	make_ecu_subdir();		/* needs to be very early before lots of init */

	get_curr_dir(curr_dir,sizeof(curr_dir));
	cd_array_init();		/* read %cd directory list */

	hdb_init();

	var_init();				/* initialize procedure variables */
	poutput_init();			/* initialize procedure output */

	icmd_prompt = esdalloc(64);
	set_default_escape_prompt();

	/*
	 * init line variables
	 */
	memset(shm->Lline,0,sizeof(shm->Lline));
	shm->Liofd = -1;				/* no line open now */
	shm->Lbaud = DEFAULT_BAUD_RATE;	/* from config.c run */
	shm->Lparity = DEFAULT_PARITY;	/* from config.c run */
	if(shm->Lparity == 'n')
		shm->Lparity = 0;
	shm->Ltelno[0] = 0;				/* no telephone number for remote yet */
	shm->Llogical[0] = 0;			/* no logical name for remote yet */
	shm->Lrname[0] = 0;				/* no logical name for remote yet */
	shm->Ldescr[0] = 0;				/* no description for remote yet */
	shm->Lconnected = 0;			/* not connected */
	shm->Ladd_nl_incoming = 0;		/* dont add nl to incoming cr */
	shm->Ladd_nl_outgoing = 0;		/* dont add nl to outgoing cr */
	shm->Lfull_duplex = 1;			/* assume full duplex */
	shm->Lmodem_already_init = 0;	/* modem has not been initialized */
	shm->Lxonxoff = IXON | IXOFF;	/* default to xon/xoff protocol */
	shm->xmtr_pid = (PID_T)getpid();
	shm->xmtr_ppid = (PID_T)getppid();
	shm->xmtr_pgrp = (PID_T)getpgrp(0);
	strcpy(shm->tty_name,get_ttyname());
	shm->shm_revision = SHM_REV;
	shm->ttyuse = TTYUSE_NORMAL;
	shm->terminating = 0;

	while((swchar = getopt(argc,argv,"DF:HNP:T:b:defhl:o:p:t")) != -1)
	{
		switch(swchar)
		{
			case 'b':
				if(valid_baud_rate(shm->Lbaud = atoi(optarg)) < 0)
				{
					ff(se,"invalid baud rate %u\n",shm->Lbaud);
					usage();
				}
				break;
			case 'l':
				shm->Lline[0] = 0;
				if(*optarg != '=')
				{
					strcpy(shm->Lline,"/dev/");
#if defined(M_SYSV)
					if(strncmp(optarg,"tty",4))     /* for backward compatibility */
						strcat(shm->Lline,"tty"); /* folks Should say "ttyxx" */
#endif /* M_SYSV */
				}
				strncat(shm->Lline,optarg,
					sizeof(shm->Lline) - strlen(shm->Lline) -
					strlen(optarg) - 1);
				shm->Lline[sizeof(shm->Lline) - 1] = 0;
				break;
			case 'p':
				strncpy(initial_procedure,optarg,sizeof(initial_procedure));
					initial_procedure[sizeof(initial_procedure) - 1] = 0;
				break;
			case 'h': shm->Lfull_duplex = 0; break;
			case 'f': shm->Lfull_duplex = 1; break;
			case 'd': quit_on_init_proc_fail = 1; break;
			case 'D': quit_on_init_proc_done = 1; break;
			case 't': shm->Ladd_nl_incoming = 1;
					  shm->Ladd_nl_outgoing = 1; break;
			case 'e': shm->Lparity = 'e'; break;
			case 'o': shm->Lparity = 'o'; break;
			case 'N': shm->ttyuse = TTYUSE_FORCE_SIMPLE; break;
			case 'T': proctrace = atoi(optarg); break;
			case 'P':
				strncpy(phonedir_name,optarg,PHONEDIR_NAME_SIZE);
				phonedir_name[PHONEDIR_NAME_SIZE - 1] = 0;
				break;
			case 'F':
				dash_f_funckeytype = optarg;
				break;
			case '?': usage();
		}
	}

	/*
	 * check a few options for validity
	 */
	if(!initial_procedure[0] &&
		(quit_on_init_proc_done || quit_on_init_proc_fail))
	{
		ff(se,"no -D/-d without -p\n");
		usage();
	}

	ttyinit(shm->ttyuse);	/* init console tty mode handler */
	ttymode(3);		/* put user console in `raw' mode but SIGINT terms prog */
	tcap_clear_screen();
#if defined(WHT2) || defined(XTERM_FRIEND)
	/*
	 * if xterm, put notice in title bar
	 * but this really should be done in _rc.ep
	 */
	xterm_title("ECU",0);
#endif
	ff(se,"%s\r\n",hello_str);

	/*
	 * do the _rc.ep execution
	 */
	if(find_procedure(_rc))
	{
		if(do_proc(1,&_rc))
		{
			if(quit_on_init_proc_fail || quit_on_init_proc_done)
				termecu(TERMECU_INIT_PROC_ERROR);
		}
	}
	rc_ep_has_run = 1;

	/*
	 * check out line
	 */
	if(!shm->Lline[0])
	{
		if(!there_is_hdb_on_this_machine)
			strcpy(shm->Lline,default_tty);
		else
		{
			DVE *tdve;
			if(tdve = hdb_choose_Any(shm->Lbaud))
				sprintf(shm->Lline,"/dev/%s",tdve->line);
			else
			{
#if 0
				ff(se,"\r\n\n");
				tcap_stand_out();
				ff(se,"[no available Devices line at %u baud]",shm->Lbaud);
				tcap_stand_end();
				ff(se,"\r\n");
				Nap(1000L);
#endif
				strcpy(shm->Lline,default_tty);
			}
		}
	}
	else if(shm->Lline[0] == '=')   /* Devices lookup */
	{
		DVE *tdve = 0;
		char acutype[128];
		if(!there_is_hdb_on_this_machine)
		{
			ff(se,"\r\n\n");
			tcap_stand_out();
			ff(se,"[cannot use -l=Devices ... HDB not available]");
			tcap_stand_end();
			ff(se,"\r\n");
			usage();
		}
		strncpy(acutype,shm->Lline + 1,sizeof(acutype));
		acutype[sizeof(acutype) - 1] = 0;
		if(!(tdve = getdvtype(shm->Lline + 1)))
		{
			ff(se,"\r\n\n");
			tcap_stand_out();
			ff(se,"[no Devices line of type '%s']",acutype);
			tcap_stand_end();
			ff(se,"\r\n");
			termecu(TERMECU_SVC_NOT_AVAIL);
		}
		shm->Lline[0] = 0;
		shm->Lbaud = tdve->high_baud;
		setdvent();     /* rewind for assured passthru/enddvent by hdb_choose */
		if(!(tdve = hdb_choose_Device(acutype,shm->Lbaud)))
		{
			ff(se,"\r\n\n");
			tcap_stand_out();
			ff(se,"[no idle Devices line of type '%s' at %u baud]",
				acutype,shm->Lbaud);
			tcap_stand_end();
			ff(se,"\r\n");
			termecu(TERMECU_SVC_NOT_AVAIL);
		}
		strcpy(shm->Lline,"/dev/");
		strncat(shm->Lline,tdve->line,sizeof(shm->Lline) - strlen(shm->Lline));
		shm->Lline[sizeof(shm->Lline) - 1] = 0;
	}

	/*
	 * either present startup screen or run initial procedure or both
	 */
	if(initial_procedure[0])
	{
		init_proc_argv[0] = initial_procedure;
		init_proc_argc = 1;
		for(itmp = optind; itmp < argc; itmp++)
		{
			if(*argv[itmp] != '-')
			{
				if(init_proc_argc == MAX_PARGV)
				{
					ff(se,"too many arguments to initial procedure\r\n");
					termecu(TERMECU_USAGE);
				}
				init_proc_argv[init_proc_argc++] = argv[itmp];
			}
		}

		if(tty_not_char_special)
			quit_on_init_proc_done = 1;
		else	/* rattle curses once - fixes quirk/bug I can't find */
		{
			windows_start();
			windows_end(0);
			fflush(so);
		}

		if(do_proc(init_proc_argc,init_proc_argv))
		{
			if(quit_on_init_proc_fail || quit_on_init_proc_done)
				termecu(TERMECU_INIT_PROC_ERROR);
		}
		proc_file_reset();
		colors_save = colors_current;
		setcolor(colors_notify);
		fputs("[procedure finished]",se);
		setcolor(colors_save);
		ff(se,"\r\n");
		if(quit_on_init_proc_done)
			termecu(0);
		if(shm->Liofd < 0)
		{
			ff(se,"\r\n\n");
			tcap_stand_out();
			ff(se,"[no line attached by initial procedure]");
			tcap_stand_end();
			ff(se,"\r\n");
			if(quit_on_init_proc_fail)
				termecu(TERMECU_INIT_PROC_ERROR);
			tcap_stand_out();
			ff(se,"[press ESC to exit or SPACE for setup menu]");
			tcap_stand_end();
			itmp = ttygetc(0);
			ff(se,"\r\n");
			if(itmp == ESC)
				termecu(1);
			shm->Llogical[0] = 0;
			shm->Ltelno[0] = 0;
			shm->Ldescr[0] = 0;
			setup_screen((char *)0);
		}
		else
			start_rcvr_process(0);
	}
	else		/* no initial procedure */
		setup_screen((optind < argc) ? argv[optind] : (char *)0);

	/* enter xmtr operation */
	xmtr();
	termecu(0);
	return(0); /* never get here, but keep gcc optim from complaining */
	/*NOTREACHED*/
}	/* end of main */

#endif /* XECU */
/* end of ecu.c */
/* vi: set tabstop=4 shiftwidth=4: */

