/* CHK=0xD40E */
char *rev = "3.20";
/* #define FORCE_DASH_G */

/*+-------------------------------------------------------------------------
	config.c - Makefile configuration program for ECU
	wht@n4hgf.Mt-Park.GA.US

This must be compiled with the *NATIVE* cc or else you must fake all
of the predefines the native compiler supplies.  The Configure
script can pass stuff in CFLAGS to tickle config a bit.

There are a few tricks in here for SCO multi-target development
system.  If you compile this on a UNIX system, but specify the
target for a XENIX system, you get the cc -xenix switch.  You
also get -Dconst= to avoid banging into some problems with the
XENIX stuff in the header files.

To paraphrase Henry Spencer:
"Those who do not understand imake are doomed to reinvent it - poorly."
If this gets much more complicated, I'll make some imake rules.
Very soon, most of the systems ECU gets used on will have imake already.
We cannot assume that yet.

  Defined functions:
	gen_cc_cflags()
	gen_gcc_cflags()
	gen_isc_ldflags()
	gen_sco_ldflags()
	gen_sun_ldflags()
	gen_svr4_ldflags()
	generate_config(mdir)
	goodbye(sig)
	main(argc,argv)
	tgetc()
	tgetopt(prompt,choices,deflt)
	tgets(buf)
	tputstrs(strs)
	tputstrsfp(strs)
	type (or the 'nearest equivalent')

--------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:09-10-1992-13:58-wht@n4hgf-ECU release 3.20 */
/*:09-10-1992-04:39-wht@n4hgf-admonition about SunOS IPC config */
/*:08-22-1992-15:38-wht@n4hgf-ECU release 3.20 BETA */
/*:08-21-1992-13:46-wht@n4hgf-don't configure ecuungetty if not used on a sys */
/*:08-11-1992-06:04-wht@n4hgf-FORCE_DASH_G and 3.2v4 LNG353 warnings */
/*:07-12-1992-07:17-wht@n4hgf-3.2v4 has a fully functional nap and select */
/*:07-02-1992-20:41-wht@n4hgf-rework for more options + 3.2v4 PID_T */
/*:06-18-1992-11:19-root@n4hgf-SCO 3.2v4 gcc CFLAG additions */
/*:04-23-1992-14:04-wht@n4hgf-had XENIX curses lib paths wrong */
/*:04-19-1992-21:55-wht@n4hgf-pressing return or enter gets tgeopt default */
/*:04-19-1992-21:43-wht@n4hgf-add default for tgetopt */
/*:04-19-1992-02:55-wht@n4hgf-add ESIX SVR4 config */
/*:04-17-1992-20:08-wht@n4hgf-add tty, baud and parity questions */
/*:03-20-1992-03:08-wht@n4hgf-correct XENIX tcap/tlib test thanks to tbetz */
/*:03-01-1992-13:36-wht@n4hgf-add -Wswitch to gcc compiles */
/*:02-06-1992-15:23-wht@n4hgf-depressing ... SCO keeps chging their minds */
/*:10-17-1991-14:51-wht@n4hgf-add can_pipe code */
/*:09-03-1991-12:53-wht@n4hgf2-iron out sun gcc options */
/*:09-01-1991-16:32-wht@n4hgf2-show package and config versions */
/*:09-01-1991-15:59-wht@n4hgf2-generalize HDB Devices, etc. files location */
/*:08-28-1991-14:07-wht@n4hgf2-SVR4 cleanup by aega84!lh */
/*:08-25-1991-14:39-wht@n4hgf-SVR4 port thanks to aega84!lh */
/*:08-23-1991-01:37-wht@n4hgf-sun port */
/*:07-25-1991-12:55-wht@n4hgf-ECU release 3.10 */
/*:07-12-1991-14:02-wht@n4hgf-GCC140 update */
/*:05-02-1991-02:46-wht@n4hgf-take out M_TERMCAP in favor of ecucurses.h */
/*:04-28-1991-03:44-wht@n4hgf-add -Dconst= for X286 under UNIX */
/*:04-20-1991-17:26-wht@n4hgf-creation */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <termio.h>
#include "ecu_types.h"
#include "ecu_stat.h"
#include "patchlevel.h"

#define S_SCO		0
#define S_ISC		1
#define S_SUN		2
#define S_ISCSVR4	3
#define S_ESIXSVR4	4

#define X_X286		0
#define X_X386		1
#define X_UNIX		2
#define X_32v4		3

#define C_CC		0
#define C_GCC		1

struct termio tty0;
struct termio tty1;
#define setty(arg) ioctl(0,TCSETAW,(arg) ? (char *)&tty1 : (char *)&tty0)

char *makedirs[] = {
	".",
	"./ecufriend",
	"./ecuungetty",
	"./gendial",
	"./help",
	"./sea",
	"./z",
	(char *)0
};

char *strs_intro1[] = {
	"\n",
	".-------------------.\n",
	"| ECU configuration |\n",
	"`-------------------'\n",
	(char *)0
};
char *strs_intro2[] = {
#ifdef WHT
	"WHT features enabled.  ",
#endif
#if defined(FORCE_DASH_G)
	"-g compilation will be forced.",
#endif
	"\n",
	"\n",
	"Please answer these questions so that I can configure ECU.\n",
	"There are two types of answers, single character and string.\n",
	"Single character questions have the choices in () followed by a ?\n",
	"String questions are followed by a :\n",
	"Default answers appearing in [] are guesses.  If you wish to use\n",
	"the default answer for a question, just press CR\n",
	"\n",
	"Abort (DEL, ^C, etc.) now if you do not wish to continue\n",
	(char *)0
};

char *strs_lng353[] = {
	"\n",
	"I see you have installed LNG353 for the development system.\n",
	"This fixed many things but introduced a new warning I cannot readily do\n",
	"anything about.  Expect loads of \"warning C4200: previous declarator\n",
	"is not compatible with default argument promotion\" messages.\n",
	"They reflect little more than ECU isn't compliant with the latest\n",
	"ANSI throathold tightening.\n",
	(char *)0
};

char *strs_nolng353[] = {
	"\n",
	"You MUST use the 3.2v4 (or ODT 2.0) development system and you ought to\n",
	"LNG353 installed.  If you have only an older DS, rerun ./config and\n",
	"specify 'u'.  No promises. (This message may be obsolete after 1992).\n",
	(char *)0
};

char *strs_mkdep[] = {
	"\n",
	"You are ready to make the program. It make take a while (now is a good\n",
	"time to Read The Fine Manual).\n",
	"\n",
	"You MAY wish to make depend first.  It is not necessary to do this\n",
	"until you make source modifications or apply patches.\n",
	(char *)0
};

char *sco_cc_opts[] = {
	"\t-M2let128 -LARGE \\\n",			/* XENIX/286 */
	"\t-M3e \\\n",						/* XENIX/386 */
	"\t-M3e \\\n",						/* UNIX/386 3.2.0-3.2v2*/
	"\t-M3e \\\n"						/* UNIX/386 3.2v4 */
};

char *sco_cc_optim[] = {
#ifdef FORCE_DASH_G
	"\t-Ot \\\n",						/* XENIX/286 */
	"\t-Oct -CSON \\\n",				/* XENIX/386 */
	"\t-g \\\n",						/* UNIX/386 3.2.0-3.2v2 */
	"\t-g \\\n"							/* UNIX/386 3.2v4 */
#else
	"\t-Ot \\\n",						/* XENIX/286 */
	"\t-Oct -CSON \\\n",				/* XENIX/386 */
	"\t-Oct -CSON \\\n",				/* UNIX/386 3.2.0-3.2v2 */
	"\t-Oct -CSON \\\n"					/* UNIX/386 3.2v4 */
#endif
};

char *sco_sigtype[] = {
	"int",			/* XENIX/286 */
	"void",			/* XENIX/386 */
	"void",			/* UNIX/386 3.2.0-3.2v2 */
	"void"			/* UNIX/386 32v4 */
};

char *pid_type = "\t-DPID_T=int \\\n";

/*
 * GCC CFLAGS
 */
char *gcc_opts[] = {
#ifdef PEDANTIC
	"\t-pedantic -ansi -O \\\n",		/* UH OH: see ecu README */
#else
	"\t-traditional -O \\\n",
#endif
#if defined(WHT) || defined(FORCE_DASH_G)
	"\t-g \\\n",
#endif
	"\t-fstrength-reduce -fpcc-struct-return -fwritable-strings \\\n",
	"\t-finline-functions -fforce-mem -fforce-addr \\\n",
	"\t-W -Wunused -Wpointer-arith -Wcast-qual -Wshadow -Wcomment -Wswitch\\\n",
	(char *)0
};

char *i86_gcc_opts[] = {
#if 0
	"\t-fcall-used-bx \\\n",
#endif
	(char *)0
};

char *sco_gcc_opts[] = {
	/*
	 * XENIX/286
	 */
	"\t........what-goes-here?......... \\\n",

	/*
	 * XENIX/386
	 */
	"\t-DM_XENIX -DM_SYSV -DM_SYS5 -DM_I386 \\\n\
\t-DM_BITFIELDS -DM_COFF -DM_I386 -DM_I86 -DM_I86SM \\\n\
\t-DM_INTERNAT -DM_SDATA -DM_STEXT -DM_SYS3 \\\n\
\t-DM_SYSIII -DM_WORDSWAP -Di386\\\n",

	/*
	 * UNIX/386 3.20..3.2v2
	 */
	"\t-DM_BITFIELDS -DM_COFF -DM_I386 -DM_I86 -DM_I86SM \\\n\
\t-DM_INTERNAT -DM_SDATA -DM_STEXT -DM_SYS3 -DM_SYS5 \\\n\
\t-DM_SYSIII -DM_SYSV -DM_UNIX -DM_WORDSWAP -DM_XENIX -Dunix -Di386\\\n",

	/*
	 * UNIX/386 3.2v4
	 */
"\t-D_NO_PROTOTYPE -D_SVID -D_KR \\\n\
\t-DM_BITFIELDS -DM_COFF -DM_I386 -DM_I86 -DM_I86SM \\\n\
\t-DM_INTERNAT -DM_SDATA -DM_STEXT -DM_SYS3 -DM_SYS5 \\\n\
\t-DM_SYSIII -DM_SYSV -DM_UNIX -DM_WORDSWAP -DM_XENIX -Dunix -Di386\\\n",
};


char *isc_cc_opts  = "\t-O -DISC -DISC22 -DSYSV \\\n";
char *isc_gcc_opts = "\t-DISC -DISC22 -DSYSV -Di386\\\n";
char *isc_sigtype = "void";

char *sun_cc_opts  = "\t-O \\\n";
char *sun_gcc_opts  = "\t-O -Dsun=1 \\\n"; /* ansi gets __sun__ only */
char *sun_sigtype = "void";

char *svr4_cc_opts  = "\t-O -DSVR4 -DSYSV \\\n";
char *svr4_gcc_opts = "\t-DSVR4 -DSYSV \\\n";
char *svr4_sigtype = "void";

/*
 * LIBS
 */
char *_sco_libs[] = {
	"-ltcap -ltermlib -lx",
	"-ltcap -ltermlib -lx",
	"-ltcap -ltermlib -lmalloc -lc_s -lc -lx",
	"-ltcap -ltermlib -lmalloc -lc_s -lc -lx"
};
char *_sco2_libs[] = {
	"-ltcap -ltermcap -lx",
	"-ltcap -ltermcap -lx",
	"-ltcap -ltermcap -lmalloc -lc_s -lc -lx",
	"-ltcap -ltermcap -lmalloc -lc_s -lc -lx"
};
char **sco_libs = _sco_libs;

char *isc_libs = "-lcurses -linet -lx -lmalloc";

char *sun_libs = "-lcurses -ltermcap";

char *svr4_libs = "-lcurses -lx -lmalloc";

char *sco_system[] = {
	"XENIX/286",
	"XENIX/386",
	"UNIX/386",
	"UNIX/386 3.2v4"
};

char *malloc_3x = "\t-DMALLOC_3X \\\n";

char *tty = "tty1a";
char *baud = "9600";
int parity = 0;
char *bindir = "/usr/local/bin";
char *libdir = "/usr/local/lib/ecu";
char *symbolic = "";
char *use_ecuungetty = "yes";

int sys = -1;
int compiler = -1;
int have_gcc_140 = 0;
int sco_type = -1;
int debug = 0;
int can_pipe = 0;

FILE *fpmake;

void
goodbye(sig)
int sig;
{
	setty(0);
	printf("\n");
	exit(sig);
}

void
tputstrs(strs)
char **strs;
{
	while(*strs)
		fputs(*strs++,stdout);
}

void
tputstrsfp(strs)
char **strs;
{
	while(*strs)
		fputs(*strs++,fpmake);
}

char
tgetc()
{
char rtn;

	setty(1);
	read(0,&rtn,1);
	rtn &= 0x7F;
	setty(0);
	if(rtn != 0x0A)
		printf("\n",rtn);
	return(rtn);
}

void
tgets(buf)
char *buf;
{
	if(!gets(buf))
		goodbye(1);
}

char
tgetopt(prompt,choices,deflt)
char *prompt;
char *choices;
char deflt;
{
	char rtn = 0;
	char response;
	char *cptr;

	printf("\n%s (",prompt);
	while(!rtn)
	{
		cptr = choices;
		while(*cptr)
		{
			if(cptr - choices)
				putchar(',');
			if(*cptr == deflt)
				putchar('[');
			putchar(*cptr);
			if(*cptr == deflt)
				putchar(']');
			cptr++;
		}
		printf(")? ");
		response = tgetc();
		if(strchr(choices,response))
			rtn = response;
		else if((response == 0x0D) || (response == 0x0A))
			rtn = deflt;
		else
			printf("Please answer with one of (");
	}
	return(rtn);
}

void
gen_cc_cflags()
{

	fputs("CFLAGS = \\\n",fpmake);
	switch(sys)
	{
		case S_SCO:
#ifdef M_UNIX
			fputs("\t-nointl \\\n",fpmake);
			if((sco_type != X_UNIX) && (sco_type != X_32v4))
				fputs("\t-xenix -Dconst= \\\n",fpmake);
#endif
			fputs("\t-DLINT_ARGS \\\n",fpmake);
			fputs(sco_cc_optim[sco_type],fpmake);
			fputs(sco_cc_opts[sco_type],fpmake);
			if((sco_type == X_UNIX) || (sco_type == X_32v4))
				fputs(malloc_3x,fpmake);
			fputs("\t-DUSE_ECUUNGETTY \\\n",fpmake);
			if(sco_type == X_32v4)
				fputs("\t-DWORKING_SELECT -DSCO32v4 \\\n",fpmake);
			fputs("\t-DSIGTYPE=$(SIGTYPE) \\\n",fpmake);
			fputs("\t-DLOCK_DIR_NAME='\"/usr/spool/uucp\"' \\\n",fpmake);
			break;
		case S_ISC:
			fputs(isc_cc_opts,fpmake);
			fputs(malloc_3x,fpmake);
			fputs("\t-DUSE_ECUUNGETTY \\\n",fpmake);
			fputs("\t-DWORKING_SELECT \\\n",fpmake);
			fputs("\t-DSIGTYPE=$(SIGTYPE) \\\n",fpmake);
			fputs("\t-DLOCK_DIR_NAME='\"/usr/spool/locks\"' \\\n",fpmake);
			break;
		case S_SUN:
			fputs(sun_cc_opts,fpmake);
			fputs(malloc_3x,fpmake);
			fputs("\t-DWORKING_SELECT \\\n",fpmake);
			fputs("\t-DSIGTYPE=$(SIGTYPE) \\\n",fpmake);
			fputs("\t-DLOCK_DIR_NAME='\"/var/spool/locks\"' \\\n",fpmake);
			break;
		case S_ISCSVR4:
		case S_ESIXSVR4:
			fputs(svr4_cc_opts,fpmake);
			if(sys == S_ISCSVR4)
				fputs("\t-DISCSVR4 \\\n",fpmake);
			else
				fputs("\t-DESIXSVR4 \\\n",fpmake);
			fputs(malloc_3x,fpmake);
			fputs("\t-DWORKING_SELECT \\\n",fpmake);
			fputs("\t-DSIGTYPE=$(SIGTYPE) \\\n",fpmake);
			fputs("\t-DLOCK_DIR_NAME='\"/var/spool/locks\"' \\\n",fpmake);
			break;
	}
	fprintf(fpmake,"\t-DDEFAULT_TTY='\"/dev/%s\"' \\\n",tty);
	fprintf(fpmake,"\t-DDEFAULT_BAUD_RATE=%s \\\n",baud);
	fprintf(fpmake,"\t-DDEFAULT_PARITY=\"'%c'\" \\\n",parity);
	fputs("\t-DHDBLIBDIR='\"$(HDBLIBDIR)\"' \\\n",fpmake);
	fputs("\t-DECULIBDIR='\"$(ECULIBDIR)\"' -DECUUNGETTY_CHOWN \\\n",fpmake);
	fputs(pid_type,fpmake);
	fputs(
"\t$(SYMBOLIC) $(CFLAGS_EXTRA) $(CC_CFLAGS_EXTRA) $(LOCAL_CFLAGS)\n\n",fpmake);
}

void
gen_gcc_cflags()
{
	fputs("CFLAGS = \\\n",fpmake);
	tputstrsfp(gcc_opts);
	if(can_pipe)
		fputs("\t-pipe \\\n",fpmake);
	switch(sys)
	{
		case S_SCO:
			fputs(sco_gcc_opts[sco_type],fpmake);
			tputstrsfp(i86_gcc_opts);
			if((sco_type == X_UNIX) || (sco_type == X_32v4))
				fputs(malloc_3x,fpmake);
			fputs("\t-DUSE_ECUUNGETTY \\\n",fpmake);
			fputs("\t-DSIGTYPE=$(SIGTYPE) \\\n",fpmake);
			if(sco_type == X_32v4)
				fputs("\t-DWORKING_SELECT -DSCO32v4 \\\n",fpmake);
			fputs("\t-DLOCK_DIR_NAME='\"/usr/spool/uucp\"' \\\n",fpmake);
			break;
		case S_ISC:
			fputs(isc_gcc_opts,fpmake);
			tputstrsfp(i86_gcc_opts);
			fputs(malloc_3x,fpmake);
			fputs("\t-DUSE_ECUUNGETTY \\\n",fpmake);
			fputs("\t-DWORKING_SELECT \\\n",fpmake);
			fputs("\t-DSIGTYPE=$(SIGTYPE) \\\n",fpmake);
			fputs("\t-DLOCK_DIR_NAME='\"/usr/spool/locks\"' \\\n",fpmake);
			break;
		case S_SUN:
			fputs(sun_gcc_opts,fpmake);
			fputs(malloc_3x,fpmake);
			fputs("\t-DWORKING_SELECT \\\n",fpmake);
			fputs("\t-DSIGTYPE=$(SIGTYPE) \\\n",fpmake);
			fputs("\t-DLOCK_DIR_NAME='\"/var/spool/locks\"' \\\n",fpmake);
			break;
		case S_ISCSVR4:
		case S_ESIXSVR4:
			fputs(svr4_gcc_opts,fpmake);
#if defined(i386)
			tputstrsfp(i86_gcc_opts);
#endif
			if(sys == S_ISCSVR4)
				fputs("\t-DISCSVR4 \\\n",fpmake);
			else
				fputs("\t-DESIXSVR4 \\\n",fpmake);
			fputs(malloc_3x,fpmake);
			fputs("\t-DWORKING_SELECT \\\n",fpmake);
			fputs("\t-DSIGTYPE=$(SIGTYPE) \\\n",fpmake);
			fputs("\t-DLOCK_DIR_NAME='\"/var/spool/locks\"' \\\n",fpmake);
			break;
	}
	if(have_gcc_140)
		fputs("\t-DGCC140 \\\n",fpmake);
	fprintf(fpmake,"\t-DDEFAULT_TTY='\"/dev/%s\"' \\\n",tty);
	fprintf(fpmake,"\t-DDEFAULT_BAUD_RATE=%s \\\n",baud);
	fprintf(fpmake,"\t-DDEFAULT_PARITY=\"'%c'\" \\\n",parity);
	fputs("\t-DHDBLIBDIR='\"$(HDBLIBDIR)\"' \\\n",fpmake);
	fputs("\t-DECULIBDIR='\"$(ECULIBDIR)\"' -DECUUNGETTY_CHOWN \\\n",fpmake);
	fputs(pid_type,fpmake);
	fputs(
"\t$(SYMBOLIC) $(CFLAGS_EXTRA) $(GCC_CFLAGS_EXTRA) $(LOCAL_CFLAGS)\n\n",fpmake);
}

void
gen_sco_ldflags()
{
	fputs("LDFLAGS = \\\n",fpmake);
#if defined(WHT) || defined(FORCE_DASH_G)
	fputs("\t-g \\\n",fpmake);
#endif
	if(compiler == C_CC)
	{
#ifdef M_UNIX
		fputs("\t-nointl \\\n",fpmake);
		if((sco_type != X_UNIX) && (sco_type != X_32v4))
			fputs("\t-xenix \\\n",fpmake);
#endif
		fputs(sco_cc_opts[sco_type],fpmake);
		if(sco_type == X_X286)
			fputs("\t-SEG 512 -F 5000 \\\n",fpmake);
	}
	fputs("\t$(SYMBOLIC) $(LDFLAGS_EXTRA)\n\n",fpmake);

	fprintf(fpmake,"LIBS = %s\n\n",sco_libs[sco_type]);
}

void
gen_isc_ldflags()
{
	fputs("LDFLAGS = \\\n",fpmake);
	fputs("\t$(SYMBOLIC) $(LDFLAGS_EXTRA)\n\n",fpmake);

	fprintf(fpmake,"LIBS = %s\n\n",isc_libs);
}

void
gen_sun_ldflags()
{
	fputs("LDFLAGS = \\\n",fpmake);
	fputs("\t$(SYMBOLIC) $(LDFLAGS_EXTRA)\n\n",fpmake);

	fprintf(fpmake,"LIBS = %s\n\n",sun_libs);
}

void
gen_svr4_ldflags()
{
	fputs("LDFLAGS = \\\n",fpmake);
	fputs("\t$(SYMBOLIC) $(LDFLAGS_EXTRA)\n\n",fpmake);

	fprintf(fpmake,"LIBS = %s\n\n",svr4_libs);
}

void
generate_config(mdir)
char *mdir;
{
	char mksrc[128];
	char mkfl[128];
	char s128[128];
	FILE *fpsrc;
	FILE *local = fopen("config.local","r");
	static int reported_config_local = 0;

	sprintf(mksrc,"%s/Make.src",mdir);
	sprintf(mkfl,"%s/Makefile",mdir);

	printf("Configuring %s from %s\n",mkfl,mksrc);

	if(!(fpsrc = fopen(mksrc,"r")))
	{
		perror(mksrc);
		return;
	}

	if(debug)
		fpmake = stdout;
	else
	{
		if(!(fpmake = fopen(mkfl,"w")))
		{
			perror(mkfl);
			fclose(fpsrc);
			if(local)
				fclose(local);
			return;
		}
	}

	fprintf(fpmake,"#---- configured by Configure revision %s for ECU 3.%02d\n",
		rev,PATCHLEVEL);
	fprintf(fpmake,"#---- edit %s and rerun Configure to produce this file\n\n",
		mksrc);

	if(local)
	{
		fprintf(fpmake,"# config.local inclusions\n");
		fprintf(fpmake,"# -----------------------\n");
		if(!reported_config_local)
			fputs("found config.local:\n",stdout);
		while(fgets(s128,sizeof(s128),local))
		{
			if(!reported_config_local)
				fputs(s128,stdout);
			fputs(s128,fpmake);
		}
		if(!reported_config_local)
			fputs("\n",stdout);
		reported_config_local = 1;
		fclose(local);
		fprintf(fpmake,"# -----------------------\n");
		fputs("\n",fpmake);
	}

	switch(sys)
	{
		case S_SCO:
			fprintf(fpmake,"SIGTYPE = %s\n\n",sco_sigtype[sco_type]);
			break;
		case S_ISC:
			fprintf(fpmake,"SIGTYPE = %s\n\n",isc_sigtype);
			break;
		case S_SUN:
			fprintf(fpmake,"SIGTYPE = %s\n\n",sun_sigtype);
			break;
		case S_ISCSVR4:
		case S_ESIXSVR4:
			fprintf(fpmake,"SIGTYPE = %s\n\n",svr4_sigtype);
			break;
	}

	switch(compiler)
	{
		case C_CC:
			fputs("CC = cc\n",fpmake);
			gen_cc_cflags();
			break;
		case C_GCC:
			fputs("CC = gcc\n",fpmake);
			gen_gcc_cflags();
			break;
	}

	switch(sys)
	{
		case S_SCO:
			gen_sco_ldflags();
			break;
		case S_ISC:
			gen_isc_ldflags();
			break;
		case S_SUN:
			gen_sun_ldflags();
			break;
		case S_ISCSVR4:
		case S_ESIXSVR4:
			gen_svr4_ldflags();
			break;
	}

	fprintf(fpmake,"LBIN = %s\n",bindir);
	fprintf(fpmake,"ECULIBDIR = %s\n",libdir);
	/*
	 * we need this info in Makefiles, so it is put here rather
	 * than ecu.h; must also have this passed thru in CFLAGS
	 */
	switch(sys)
	{
		case S_SCO:
			fprintf(fpmake,"SYSTEM = %s\n",sco_system[sco_type]);
			fputs("HDBLIBDIR = /usr/lib/uucp\n",fpmake);
			use_ecuungetty = "yes";
			break;
		case S_ISC:
			fputs("SYSTEM = ISC-SVR3\n",fpmake);
			fputs("HDBLIBDIR = /usr/lib/uucp\n",fpmake);
			use_ecuungetty = "yes";
			break;
		case S_SUN:
			fputs("SYSTEM = SunOS-4.1\n",fpmake);
			fputs("HDBLIBDIR = /etc/uucp\n",fpmake);
			use_ecuungetty = "no";
			break;
		case S_ISCSVR4:
		case S_ESIXSVR4:
			if(sys == S_ISCSVR4)
				fputs("SYSTEM = ISC-SVR4\n",fpmake);
			else
				fputs("SYSTEM = ESIX-SVR4\n",fpmake);
			fputs("HDBLIBDIR = /etc/uucp\n",fpmake);
			use_ecuungetty = "no";
			break;
	}


	fprintf(fpmake,"USE_ECUUNGETTY = %s\n",use_ecuungetty);
#if !defined(WHT)
	fputs("#",fpmake);
#endif
	fputs("BINTIME = /bin/time\n",fpmake);

	fprintf(fpmake,"\n#---- end of configured make variables\n");

	while(!debug && fgets(s128,sizeof(s128),fpsrc))
		fputs(s128,fpmake);

	fclose(fpsrc);
	if(!debug)
		fclose(fpmake);

}

main(argc,argv)
int argc;
char **argv;
{
	int itmp;
	int getopt_libdir = 0;
	int getopt_bindir = 0;
	int getopt_tty = 0;
	int getopt_baud = 0;
	int getopt_parity = 0;
	int have_lng353 = 0;
	char s128[128];
	char **makedir;
	char *tlib;
	char *tcap;
	struct stat fst;
	extern int optind;
	extern char *optarg;

	setbuf(stdin,NULL);
	setbuf(stdout,NULL);

	while((itmp = getopt(argc,argv,"dsiS234ugcT:B:P:b:l:")) != -1)
	{
		switch(itmp)
		{
			case 'd': debug = 1; break;

			case 's': sys = S_SCO; break;
			case 'i': sys = S_ISC; break;
			case 'S': sys = S_SUN; break;
			case 'I': sys = S_ISCSVR4; break;
			case 'E': sys = S_ESIXSVR4; break;

			case '2': sco_type = X_X286; break;
			case '3': sco_type = X_X386; break;
			case 'u':
				sco_type = X_UNIX;
				break;
			case 'v':
				sco_type = X_32v4;
				pid_type = "\t-DPID_T=short \\\n";
				have_lng353 = !stat("/etc/perms/ccsls",&fst);
				break;

			case 'g': compiler = C_GCC; break;
			case 'c': compiler = C_CC; break;

			case 'T':
				tty = optarg;
				getopt_tty = 1;
				break;

			case 'B':
				baud = optarg;
				getopt_baud = 1;
				break;

			case 'P':
				parity = *optarg;
				if(isupper(parity))
					parity = tolower(parity);
				getopt_parity = 1;
				break;

			case 'b':
				bindir = optarg;
				getopt_bindir = 1;
				break;

			case 'l':
				libdir = optarg;
				getopt_libdir = 1;
				break;
		}
	}

	/*
	 * set up raw/cooked tty setty() macro
	 */
	ioctl(0,TCGETA,&tty0);
	tty1 = tty0;
	tty1.c_lflag &= ~(ICANON);
	tty1.c_cc[VMIN] = 1;
	tty1.c_cc[VTIME] = 0;

	for(itmp = 1; itmp < 32; itmp++)
		signal(itmp,goodbye);

	if(!debug)
	{
		tputstrs(strs_intro1);
		printf("ECU 3.%02d, config version %s\n",PATCHLEVEL,rev);
		tputstrs(strs_intro2);
	}

	/*
	 * try to make a stab at default
	 * two vendor compilers have thoughtfully provided a reliable built-in
	 * default to ISC if not one of those two
	 */
	itmp = 'i';
#ifdef M_SYSV
	itmp = 's';
#endif
#ifdef sun
	itmp = 'S';
#endif

	if(sys < 0)
	{
		switch(tgetopt("\
Choose your system type (or the 'nearest equivalent') \n\
                s  SCO,\n\
                i  ISC,\n\
                S  SunOS 4.1,\n\
                I  ISC SVR4 or\n\
                E  ESIX SVR4 system\n\
",
			"siSIE",itmp))
		{
			case 's':  
				sys = S_SCO; 
				tty = "tty1a";
				break;
			case 'i':  
				sys = S_ISC; 
				tty = "acu00";
				break;
			case 'S':  
				sys = S_SUN; 
				tty = "ttya";
				printf(
"You need System V IPC configured in your kernel. I didn't check for it.\n");
				break;
			case 'I':  
				sys = S_ISCSVR4; 
				tty = "tty00";
				break;
			case 'E':  
				sys = S_ESIXSVR4; 
				tty = "tty00";
				break;
		}
	}

	if((sys == S_SCO) && (sco_type < 0))
	{
		switch(tgetopt("\
Choose between 2  XENIX/286,\n\
               3  XENIX/386,\n\
               u  ODT 1.0.x, ODT 1.1, UNIX 3.20-3.2v2 or\n\
               v  ODT 2.0, UNIX 3.2v4\n\
(The choice between 'u' and 'v' is for the Development System you have.\n\
Using the 3.2v2DS with 3.2v4OS will \"work\" but erratic behavior is most\n\
certain to occur (e.g., long filenames will confuse the 3.2v2 library).\n\
 ","23uv",
#ifdef M_UNIX
'u'
#else
#ifdef M_I286
'2'
#else
#ifdef M_I286
'3'
#else
#ifdef sun
'S'
#else
'i'
#endif
#endif
#endif
#endif
	))
		{
			case '2':  
				sco_type = X_X286; 
				tlib = "/lib/Llibtermlib.a";
				tcap = "/lib/Llibtermcap.a";
				break;
			case '3':  
				sco_type = X_X386; 
				tlib = "/lib/386/Slibtermlib.a";
				tcap = "/lib/386/Slibtermcap.a";
				break;
			case 'u':  
				sco_type = X_UNIX; 
				tlib = "/usr/lib/libtermlib.a";
				tcap = "/usr/lib/libtermcap.a";
#ifdef S_IFLNK /* 3.2v2 DS with 3.2v4 OS */
				fputs("OK, we will try to make for 3.2v4 with a 3.2v2 DS\n",
					stdout);
#endif
				break;
			case 'v':  
				sco_type = X_32v4; 
				pid_type = "\t-DPID_T=short\\\n";
				tlib = "/usr/lib/libtermlib.a";
				tcap = "/usr/lib/libtermcap.a";
				have_lng353 = !stat("/etc/perms/ccsls",&fst);
				break;
		}

		/*
		 * Some of the following may have minor flaws making it
		 * open to political nitpicking (this is 1992 :-!), but
		 * here is truth:
		 *
		 * With the advent of terminfo curses in XENIX 2.?.?,
		 * SCO until 3.2v2 had a question at install time asking what
		 * kind of curses installation you want.  It was somebody's
		 * bright idea to settle the differences between XENIX V7/BSD
		 * -lcurses+-ltermcap curses vs. the System V -lcurses terminfo
		 * method.  Well, bright people go on to other things and
		 * continutity gets lost.  The hard link driven, logical ld time
		 * -lcurses = (XENIX/BSD/V7) ? -ltcap : -ltinfo
		 * -ltermlib = (XENIX/BSD/V7) ? -ltermcap : -ltinfo
		 * stuff appears to have disappeared in 3.2v2.  I hope it is not
		 * too late to get it back into 3.2v4, but the degenerate 3.2v2
		 * case adds yet another variation on the "ever-improved-but-
		 * multivariate" SCO development environment.
		 */
		if(!access(tcap,0))
			sco_libs = _sco2_libs;
		else if(!access(tlib,0))
			sco_libs = _sco_libs;
		else
		{
			sleep(1);	/* psychological */
			printf("\nI find neither %s nor %s.\n",tcap,tlib);
			printf("Do you have curses support installed? I cannot proceed.\n");
			goodbye(1);
		}

	}

	if((sys == S_SCO) && (sco_type == X_X286))
	{
		/* don't know about gcc on 286 systems */
		compiler = C_CC;
	}
	else
	{
		if(compiler < 0)
		{
			switch(tgetopt("Do you wish to use cc or gcc","cg",'c'))
			{
				case 'c':
					compiler = C_CC;
					if(sco_type == X_32v4)
					{
						if(have_lng353)
							tputstrs(strs_lng353);
						else
							tputstrs(strs_nolng353);
					}
					break;

				case 'g':
					compiler = C_GCC;
#ifdef PEDANTIC
					printf("I see we are being brave, er pedantic.\n");
#endif
					switch(tgetopt("Answer no if you are not sure.\n\
WARNING: The default answer for this question is now YES\n\
Do you have gcc 1.40 or later","yn",'y'))
					{
						case 'y': have_gcc_140 = 1; break;
					}
					switch(sys)
					{
						case S_SUN:
						case S_ISCSVR4:
						case S_ESIXSVR4:
							can_pipe = 1; /* native as reads from stdin ok */
							break;
						default:
							switch(tgetopt("Answer no if you are not sure.\n\
Can I use -pipe (do you have gas?)","yn",'n'))
							{
								case 'y': can_pipe = 1; break;
							}
							break;
					}
					break;
			}
		}
	}

	if(!debug)
	{
		if(!getopt_tty)
		{
			printf("\nWhat do you want for a default tty? [%s]\n:",tty);
			tgets(s128);
			if(s128[0])
				tty = strdup(s128);
		}

		if(!getopt_baud)
		{
			printf("\nWhat do you want for a default baud rate? [%s]\n:",baud);
			tgets(s128);
			if(s128[0])
				baud = strdup(s128);
		}

		if(!getopt_parity)
		{
			parity = tgetopt( "What do you want for default parity","neo",'n');
		}

		if(!getopt_bindir)
		{
			printf(
			"\nWhere do you want the public executables placed? [%s]\n: ",
				bindir);
			tgets(s128);
			if(s128[0])
				bindir = strdup(s128);
		}

		if(!getopt_libdir)
		{
			printf(
			"\nWhere do you want the ECU library placed? [%s]\n: ",libdir);
			tgets(s128);
			if(s128[0])
				libdir = strdup(s128);
		}
	}

	printf("\nThank you.\n\n");

	makedir = makedirs;
	while(*makedir)
	{
		if(!strcmp(*makedir,"./ecuungetty") && (*use_ecuungetty == 'n'))
		{
			makedir++;
			continue;
		}
		generate_config(*makedir++);
	}

	if(!debug)
		tputstrs(strs_mkdep);

#ifdef WHT
	printf("\7Doing it anyway for WHT\n");
	sleep(2);
	system("make depend");
#endif

	goodbye(0);
}

/* vi: set tabstop=4 shiftwidth=4: */
/* end of config.c */
