






				      ECU

			    (Extended Call Utility)






			    Research and Engineering
		      Asynchronous Communications Package
		      for SCO UNIX 3.2 and XENIX System	V,
			   ISC 386/ix 2.2 (or later),
		       SunOS 4.1, ISC System V Release 4
			  and ESIX System V Release 4












		Warren H. Tucker, III <wht@n4hgf.Mt-Park.GA.US>






			       Procedure Language
				 Revision 3.20
				    9/10/92






    NOTE: Many sections	of the manual are likely to be obsolete	at any given
    time until the writer get lots of free time.  Much of it was written
    when the program was supported only	on SCO XENIX and UNIX.








    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				       2



    1.	Introduction


    Procedures are "programs" or "scripts" written in an addled	but adequate
    language which ECU executes	upon demand.  The documentation	refers to
    procedures as files	on the disk or as in-memory copies under execution.

    An "initial	procedure" may be executed when	ECU starts up (see the
    description	of the -p command line switch).	 Certain special procedures
    are	executed automatically as described below in the section "Special
    Procedures."

    The	procedures themselves are source files consisting of the procedure
    "name" with	an extension of	".ep".	When executing a procedure by name,

	 do name       interactive
	 -or-
	 do 'name'     from inside a procedure

    is sufficient if the procedure is in the current directory,	the user's
    ~/.ecu directory or	in the ECU library subdirectory	"ep" (normally
    /usr/local/lib/ecu/ep).  Procedure files are searched for in the above
    order, so you may have a system default in the lib directory, a user
    default in the ~/.ecu directory and	a specific version in the current
    directory all by the same name.

    You	may execute a procedure	by specifying it's full	pathname (minus	the
    .ep	extension).  For example:

	 do /tmp/doit	    interactive	invocation of /tmp/doit.ep
	 -or-
	 do '/tmp/doit'	    from inside	a procedure


    Many example procedures, some quite	useful,	some not so, are found in
    the	models subdirectory of the release.  There are also many fragments
    used as examples throughout	the following sections.

















    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				       3



    2.	Line Syntax (Labels, Commands and Comments)

    Lines in a procedure consist of an optional	label, followed	by optional
    commands and arguments.  Anything on a line	after an octothorpe (#)
    outside of quote marks is ignored (read "# is the comment character").


    Example:
    ----------------------------------------------------------------------
    # example procedure
	echo 'Hello.  Please tell me your name.'
	$s0 = %cgets  #	read string from console into string variable $s0
	ifs $s0	== 'foo' goto label
	echo 'Hello there, '+$s0
	return

    label echo 'You must be kidding.'
    ----------------------------------------------------------------------


    Labels must	begin in column	one.  A	label may appear on a line by itself
    or with a comment appended.	 A common mistake I make (from writing too
    much C) is to append a colon to a label declaration; this does not work
    unless you also "goto label:". Labels are not allowed inside braces
    (inside of compound	statements); you may get away with it sometimes
    because the	procedure language processor is	written	for speed, not
    political correctness.

    Commands must have white space before them and white space before each
    argument.
























    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				       4



    3.	Arguments


    There are five types of arguments to procedure commands:

	 Switch
	 Alphabetic Token
	 Integer
	 String
	 Relational Operators

    This section describes the syntax and construction of each type in turn.
    There are separate groups of valid of relational operators for integers
    and	strings; thus, they are	described under	the appropriate	sections.


    3.1	 Switches


    Switch arguments begin with	a hyphen (minus, '-').	The switch argument
    must be the	first argument after the command.  Only	one switch argument
    is allowed on the command line.  If	switches '-a', '-b' and	'-c', are
    available and '-a' and '-b'	are desired, '-ab' or '-ba' is entered.


    3.2	 Alphabetic Tokens


    Alphabetic tokens, for lack	of a better term, are non-integer, non-
    quoted terms used as arguments for certain commands, such as:

	 plog off

    Such argument types	are fairly simple to understand	and use; they are
    described here for completeness.


    3.3	 Integers


    Integer values are 32-bit quantities ranging between -2147483647 and
    2147483647.

    In one case, an integer is used to store a 32-bit color mask as
    described by the color command and the %colors integer function.


    3.3.1  Constants

    Integer constants are numeric strings, optionally with an initial minus
    sign, the absolute value of	which must be less than	2147483648.  If	the



    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				       5



    constant begins with the string "0x", it is	interpreted as hexadecimal.
    Octal, like	FORTRAN	and COBOL will be dead soon (heh heh); until then,
    however, octal constants may be denoted by a leading "0o".	This differs
    from the usual convention so as to allow decimal strings with leading
    zeroes to be correctly interpreted.


    Examples:
	    123	  --> 123(10)
	    0123  --> 123(10)
	    0x123 --> 291(10)
	    0o123 -->  83(10)



    3.3.2  Variables

    There are 50 numbered, permanent integer variables referenced by the
    terms '$i0'	through	'$i49'.	 When ECU is started, the value	of each
    variable is	zero.  Variables retain	their value until changed, even
    between procedure executions.  The integer variable	number may be
    expressed as an expression by enclosing an integer expression in
    brackets.  For instance:

	 $i[4+5]      refers to	$i9

	 $i2=5
	 $i[20+$i2]   refers to	$i25


    Integer variables may be created for use as	"local"	variables or to
    promote code readability.  Refer to	the mkvar command.


    3.3.3  Functions

    ECU	has many built-in functions which return the value of ecu- or
    system-related information.	 A list	of the functions appears in a later
    section.


    3.3.4  Expressions

    In almost any place	an integer argument is allowed,	an expression may be
    supplied.  Expressions are composed	of two or more integer constants or
    variables separated	by operators from the group:








    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				       6



	+     addition
	-     subtraction
	*     multiplication
	/     division
	|     OR
	@     MOD
	^     XOR
	&     AND

    Evaluation of expressions is left-to-right.	 Parentheses are not
    allowed.


    3.3.5  Relational Operators

    Integer relational operators are chosen from the following group:

	 =	 "is equal to"
	 ==	 "is equal to"
	 !=	 "is not equal to"
	 <>	 "is not equal to"
	 >	 "is greater than"
	 <	 "is greater than"
	 >=	 "is greater than or equal to"
	 <=	 "is less than or equal	to"



    3.4	 Strings


    Strings are	classic	concatenations of zero or more eight-bit characters.
    In general,	the maximum size of a string used by ECU is 256	characters.
    The	absolute maximum size is 16384 characters.

    Null in strings are	poorly handled.	 You may be able to get	away with
    using them,	but it is not recommended.


    3.4.1  Constants

    String constants are formed	by placing alphanumeric	characters between
    single quote characters (apostrophes).  The	backslash ('\')	character is
    used to "escape" certains characters:

	\\	       one backslash
	\n	       newline
	\t	       tab
	\'	       apostrophe





    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				       7



    NOTE: ecu converts every tab in a procedure	line to	one space when the
    procedure file is read in.	Therefore, IF YOU WISH TO PLACE	A TAB IN A
    STRING CONSTANT, you must place it there with the \t escape	sequence.


    3.4.2  Variables

    There are 50 numbered, permanent string variables referenced by the
    terms '$s0'	through	'$s49',	each possessing	a maximum length of 256
    characters When ECU	is started, the	value of each variable is null (zero
    length).  Variables	retain their value until changed, even between
    procedure executions.  The string variable number may be expressed as an
    expression by enclosing an string expression in brackets.  For instance:

	 $s[4+5]      refers to	$s9

	 $s2=5
	 $s[20+$s2]   refers to	$s25


    String variables may be created for	use as "local" variables or to
    promote code readability.  Refer to	the mkvar command. Created variables
    have a life	equal to the duration of the procedure which created them.
    Regardless of the declared size of a created string	variable, ECU will
    automatically grow it to a maximum of 16384	characters as necessary.
    Numbered (permanent) string	variables have a maximum size of 256 bytes.


    3.4.3  Functions

    ECU	has many built-in functions which return the value of ecu- or
    system-related information.	 A list	of the functions appears in a later
    section.


    3.4.4  Expressions

    String expressions are formed by the concatenation of string constants,
    variables and function return values using the '+' operator:

    Example:
       'The quick brown	fox jumped over	the '+$s0'+' dog at '+%time



    3.4.5  Relational Operators

    String relational operators	are chosen from	the following group:






    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				       8



	 =	 "is equal to"
	 ==	 "is equal to"
	 !=	 "is not equal to"
	 <>	 "is not equal to"


















































    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				       9



    4.	Integer	Functions



    4.1	 %argc


    This function returns the number of	arguments passes to the	current
    procedure.


    4.2	 %baud


    This function returns the baud rate	of the communications line.  If	no
    line is currently attached,	the baud rate returned is the value of the
    last line attached.	 If no line has	been attached during the current
    session, the default baud rate is returned.


    4.3	 %colors


    This function returns the state of the normal and reverse video
    foreground and background colors in	the 32-bit value:

	 00000000001111111111222222222233
	 01234567890123456789012345678901
	 0000|--|0000|--|0000|--|0000|--|
	      fg      bk      fg      bk
	       reverse		normal


    The	color values are obtained from the following lists:




















    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      10



	Alphabetic Order
	black	     0
	blue	     1
	brown	     6
	cyan	     3
	gray	     8
	green	     2
	hi_white    15
	lt_blue	     9
	lt_cyan	    11
	lt_green    10
	lt_magenta  13
	lt_red	    12
	magenta	     5
	red	     4
	white	     7
	yellow	    14



	Numeric	Order
	black	     0
	blue	     1
	green	     2
	cyan	     3
	red	     4
	magenta	     5
	brown	     6
	white	     7
	gray	     8
	lt_blue	     9
	lt_green    10
	lt_cyan	    11
	lt_red	    12
	lt_magenta  13
	yellow	    14
	hi_white    15



    4.4	 %cols


    This function returns the screen width in columns.	If running non-
    interactively, the value will always be 80.









    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      11



    4.5	 %conn


    This function returns the (positive) communications	line file descriptor
    if a connection is in effect.  If there is no connection, but there	is a
    line opened, 0 is returned.	 If no line is open (as	may be the case	in
    an _rc.ep procedure), -1 is	returned.  NOTE:  if carrier is	lost
    abnormally,	%conn will return a positive number incorrectly	if the DCD
    watcher is disabled	or if a	procedure was being executed at	the time of
    carrier loss. (See the sections on the dcdwatch interactive	and
    procedure commands).


    4.6	 %curx


    This function returns the display cursor column position last set by the
    remote system.  This value does not	reflect	the actual hardware cursor.


    4.7	 %cury


    This function returns the display cursor row position last set by the
    remote system.  This value does not	reflect	the actual hardware cursor.


    4.8	 %csec


    This function returns the number of	seconds	ECU has	been connected to a
    remote system.  If ECU is not connected, zero is returned.


    4.9	 %ctoi


    usage: %ctoi(str0)

    This function returns the integer value of the first character in string
    str0.  If str0 is non-empty, the return value will be between 0 and	255,
    inclusive.	if str0	is empty, then -1 is returned.


    4.10  %esecs


    usage: %esecs

    This function, "Epoch SECondS," returns the	number of seconds since
    January 1, 1970 00:00 UTC (GMT).



    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      12



    4.11  %fatime

    usage: %fatime(int0)
	   %fatime(str0)


    This function returns the time of last access of the file referenced by
    the	argument.  If the argument is an integer, the file referenced is the
    file opened	by that	number with the	fopen command.	If the argument	is a
    string, it is the literal filename.

    If int0 does not refer to an open file, the	procedure terminates with an
    error.  If the file	specified by str0 does not exist, -1 is	returned.

    The	return value is	the number of seconds since January 1, 1970 at 0000
    UTC.  The %edate string function may be used to convert the	integer
    value to a string representation of	the date and time expressed relative
    to the current time	zone.


    4.12  %fmode

    usage: %fmode(int0)
	   %fmode(str0)


    This function returns the file mode	value ("rwxrwx---" == 077) of the
    file referenced by the argument.  If the argument is an integer, the
    file referenced is the file	opened by that number with the fopen
    command.  If the argument is a string, it is the literal filename.

    If int0 does not refer to an open file, the	procedure terminates with an
    error.  If the file	specified by str0 does not exist, -1 is	returned.


    4.13  %fmtime

    usage: %fmtime(int0)
	   %fmtime(str0)


    This function returns the time of last modified of the file	referenced
    by the argument.  If the argument is an integer, the file referenced is
    the	file opened by that number with	the fopen command.  If the argument
    is a string, it is the literal filename.

    If int0 does not refer to an open file, the	procedure terminates with an
    error.  If the file	specified by str0 does not exist, -1 is	returned.

    The	return value is	the number of seconds since January 1, 1970 at 0000
    UTC.  The %edate string function may be used to convert the	integer



    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      13



    value to a string representation of	the date and time expressed relative
    to the current time	zone.


    4.14  %fmode

    usage: %fmode(int0)
	   %fmode(str0)


    This function returns the size of the file referenced by the argument.
    If the argument is an integer, the file referenced is the file opened by
    that number	with the fopen command.	 If the	argument is a string, it is
    the	literal	filename.

    If int0 does not refer to an open file, the	procedure terminates with an
    error.  If the file	specified by str0 does not exist, -1 is	returned.


    4.15  %ftell


    usage: ftell(int0)

    This function returns the current file position of the the file opened
    by int0 with the fopen command.

    If int0 does not refer to an open file, the	procedure terminates with an
    error.


    4.16  %instr


    usage: %instr(str0,str1)

    This function returns the leftmost column position withing str0 that
    str1 is found (zero	relative).  If str1 cannot be found in string str0,
    -1 is returned.  However, if str1 is null and str0 is not, zero will be
    returned (i.e., the	null string matches at the left).

    The	comparison is made without regard to case. See also %instr.












    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      14



	 Examples:

		     00000000001111111
		     01234567890123456
	 Assume	$s0='abcdefghijklmnabc'
		$s1='abc'
		$s2='gHi'
		$s3='cat'

		%instr($s0,$s1)	       returns 0
		%instr($s0,$s2)	       returns 6
		%instr($s0,$s3)	       returns -1
		%instr($s0,'bcd')      returns 2
		%instr($s0,'bad')      returns -1



    4.17  %ischr

    usage: %ischr(int0)
	   %ischr(str0)


    This function returns 1 if the file	referenced by the argument is a
    character special file, else 0.  If	the argument is	an integer, the	file
    referenced is the file opened by that number with the fopen	command.  If
    the	argument is a string, it is the	literal	filename.

    If int0 does not refer to an open file, the	procedure terminates with an
    error.  If the file	specified by str0 does not exist, -1 is	returned.

    Examples:


	 %ischr('/dev/tty')    returns 1
	 %ischr('/usr/bin')    returns 0
	 %ischr('/xenix')      returns 0



    4.18  %isdir

    usage: %isdir(int0)
	   %isdir(str0)


    This function returns 1 if the file	referenced by the argument is a
    directory file, else 0.  If	the argument is	an integer, the	file
    referenced is the file opened by that number with the fopen	command.  If
    the	argument is a string, it is the	literal	filename.




    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      15



    If int0 does not refer to an open file, the	procedure terminates with an
    error.  If the file	specified by str0 does not exist, -1 is	returned.

    Examples:


	 %isdir('/dev/tty')    returns 0
	 %isdir('/usr/bin')    returns 1
	 %isdir('/xenix')      returns 0



    4.19  %isreg

    usage: %isreg(int0)
	   %isreg(str0)


    This function returns 1 if the file	referenced by the argument is a
    regular file, else 0.  If the argument is an integer, the file
    referenced is the file opened by that number with the fopen	command.  If
    the	argument is a string, it is the	literal	filename.

    If int0 does not refer to an open file, the	procedure terminates with an
    error.  If the file	specified by str0 does not exist, -1 is	returned.

    Examples:


	 %isreg('/dev/tty')    returns 0
	 %isreg('/usr/bin')    returns 0
	 %isreg('/xenix')      returns 1



    4.20  %len


    usage: %len(str0)

    This function returns the length of	str0.

	 Example:

	 set str0='abcdef',i0=%len(str0),i1=%len('1234')
	 str00 = 'abcdef'
	 int00 = 6
	 int01 = 4






    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      16



    4.21  %lgetc


    usage: %lgetc(int0)

    Reads a character from the line and	returns	it.  Argument int0 is the
    number of milliseconds to wait for a character.  Use a large positive
    number if you want to wait "forever."  The function	returns	the
    character value between 0 and 255 or -1 if the timeout period is
    exceeded.


    4.22  %lines


    This function returns the screen height in lines.  If running non-
    interactively, the value will always be 25.


    4.23  %nice


    usage: %nice

    This function returns the nice value of the	ECU process.


    4.24  %pid


    This function returns the process id (pid) of ECU.


    4.25  %match


    usage: %match(str0,str1)

    This function searches string str0 for a match with	the regular
    expression in str1 (for information	on regular expressions,	refer to the
    ed(C) manual pages).  The function returns the index into str0 where the
    match is found or -1 if no match can be found.  The	matching process is
    case sensitive.

    The	variable $i0 receives the length of the	matching string	in str0	if a
    match is found.  For this reason, it is not	advisable that $i0 otherwise
    be involved	in the operation.  Specifically	to be avoided is:

	 set $i0=%instr(...)





    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      17



    Examples:

		00000000001111111
		01234567890123456
    Assume $s0='abcdefghijklmnabc'
	   $s1='abc'
	   $s2='n.*'

	   %match($s0,$s1)	  returns 0   $i0=3
	   %match($s0,$s2)	  returns 16  $i0=4
	   %match($s0,$s3)	  returns -1  $i0 unchanged
	   %match($s0,'de..h')	  returns 3   $i0=5
	   %match($s0,'de..H')	  returns -1  $i0 unchanged



    4.26  %mhack


    usage: %mhack

    This function ("Millisecond	time HACK") returns the	number of
    milliseconds since ecu was started.	 It isn't a very useful	value by
    itself, but	differences between the	values returned	by two calls to	the
    function may be used to determine the time between two events with the
    maximum accuracy the operating system can deliver (1/HZ resolution with
    a bit of latency).


    Examples:
	$i10 = %mhack
	send 'test'
	lookfor	-e %chr(0x0A) 100
	ifi $i0	== 0 echo 'no response in 10 seconds'
	else echo 'response time '+%itos(%mhack	- $i10)+' msec'



    4.27  %rchr


    This function returns the number of	characters received by ECU since the
    program starrted.


    4.28  %rchrc


    This function returns the number of	characters received by ECU during
    the	current	connection.




    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      18



    4.29  %rinstr


    usage: %rinstr(str0,str1)

    This function returns the rightmost	column position	withing	str0 that
    str1 is found (zero	relative).  If str1 cannot be found in string str0,
    -1 is returned.  However, if str1 is null and str0 is not, zero will be
    returned (i.e., the	null string matches at the left).

    The	comparison is made without regard to case. See also %instr.


	 Examples:

		     00000000001111111
		     01234567890123456
	 Assume	$s0='abcdefghijklmnabc'
		$s1='abc'
		$s2='gHi'
		$s3='cat'

		%instr($s0,$s1)	       returns 14
		%instr($s0,$s2)	       returns 6
		%instr($s0,$s3)	       returns -1



    4.30  %shmid


    This function returns the integer shared memory segment id for the
    current ECU	process.  It may be used to pass the id	to a "friend"
    process so that it may access the shared memory segment (described in
    header file	ecushm.h).  For	more details, refer to an earlier section
    entitled "Shared Memory 'Friend' Interface."


    Example:

	 system	'ecufriend '+%itos(%shmid)



    4.31  %stoi


    usage: %stoi(str0)

    This function converts the contents	of str0	to an integer and returns
    the	value.



    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      19



    4.32  %uid


    usage: %uid

    This function returns the uid of the user.


    4.33  %xchr


    This function returns the number of	characters transmitted by ECU since
    the	program	starrted.


    4.34  %xchrc


    This function returns the number of	characters transmitted by ECU during
    the	current	connection.


































    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      20



    5.	String Functions



    5.1	 %argv


    usage: %argv(int0)

    This function returns the string value of an argument passed to the
    procedure by the 'do' command.  Argument 0 is the name of the procedure
    itself.  The integer function %argc	may be used to determine the number
    of arguments passed	to the procedure.  Specifying an argument number
    greater than the number of arguments passed	returns	a null string (if
    procedure tracing is enabled with the 'ptrace' comand, a warning will be
    displayed in this case).

	 Example:
	     invocation	from shell:
	     ecu -p test Quick Brown Fox

	     invocation	from interactive command line:
	     do	test Quick Brown Fox

	     invocation	from procedure:
	     do	'test' 'Quick' 'Brown' 'Fox'

	     results in:
	     %argv(0) =	'test'
	     %argv(1) =	'Quick'
	     %argv(2) =	'Brown'
	     %argv(3) =	'Fox'
	     %argv(4) =	''


    NOTE: the interactive dial command,	the dialing directory menu and the
    initial setup menu all can automatically execute a procedure which
    matches a dialed logical telephone number.	There two arguments passed
    to these procedures, %argv(0) being	the procedure name as always.
    %argv(1) is	set according to the following table:

	  invoker	       %argv(1)
	 -------------------  -------------
	 initial setup menu   !INITIAL
	 interactive dial     !INTERACTIVE
	 dialing menu	      !MENU

    Thus it is possible	for the	invoked	procedure to determine that it has
    been automatically executed	by testing %argv(1) for	an exclamation
    point, or possibly the entire argument.




    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      21



    5.2	 %basename


    Usage: %basename(str0,str1)

    This function is similar to	the UNIX basename(1) utility in	that it
    returns a filename minus a supplied	suffix,	if it is present.  Unlike
    the	UNIX basename(C) program, %basename does not remove the	directory
    part of the	filename.  See also %dirpart and %filepart.


    Examples:

	%basename('/u1/src/ecu/ecu.c','.c') = /u1/src/ecu/ecu
	%basename('ecu.c','.c')	= ecu
	%basename('ecu.c','.x')	= ecu.c



    5.3	 %cgetc


    usage: %cgetc

    This  function reads one character from the	console	keyboard and returns
    it.	 The character is not echoed.


    5.4	 %cgets


    usage: %cgets

    This function reads	a string from the console keyboard and returns it.
    Each character is echoed as	it is typed and	the user's normal erase	and
    kill character is available	to edit	the input before terminating the
    read with ENTER.


    5.5	 %chr


    usage: %chr(int0)

    This function returns the character	value whose ASCII value	is supplied
    in int0.








    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      22



    Example:

	set $s0	= %chr(4)  places a ^D (EOT) character into $s0



    5.6	 %date


    usage: %date

    This function returns the current date in the form 'mm-dd-yyyy' in the
    local time zone (daylight time if it applies).


    5.7	 %datez


    usage: %datez

    This function returns the current date in the form 'mm-dd-yyyy' in the
    UTC	(Z) time zone.


    5.8	 %day


    usage: %day

    This function returns the current day of the week as a three character
    abbreviation: 'Sun', 'Mon',	'Tue', 'Wed', 'Thu', 'Fri', 'Sat' in the
    local time zone (daylight time if it applies).


    5.9	 %dayz


    usage: %dayz

    This function returns the current day of the week as a three character
    abbreviation: 'Sun', 'Mon',	'Tue', 'Wed', 'Thu', 'Fri', 'Sat' in the UTC
    (Z)	time zone.


    5.10  %dir


    usage: %dir

    This function returns the full pathname of the current working
    directory.



    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      23



    5.11  %dirpart


    usage: %dirpart(str0)

    This function returns the directory	portion	of the pathname	supplied in
    str0.  See also %basename and %filepart.



    Examples:

    %dirpart('/u1/src/src/foo.c') = "/u1/src/src"
    %dirpart('foo.c') =	"foo.c"
    %dirpart('/usr') = ""



    5.12  %edate


    usage: %edate(int0)

    The	value in int0 is expected to be	a number of seconds since January 1,
    1970 00:00 UTC (Universal Coordinated Time)	as returned by the integer
    functions %fatime and %fmtime.  This function converts the value into a
    string representing	the equivalent local time in the form 'mm-dd-yyyy
    hh:mm:ss'.

    Example:

    set	$i0=%fmtime('/xenix')
    $i00 = 601178971 (0x23d5435b,04365241533)

    set	$s0=%edate($i0)
    $s00 = '01-18-1989 21:09:31'



    5.13  %envvar


    usage: %envvar()

    This function returns the string value of an environment variable.


    Example:

	set $s0=%envvar('HOME')	might set $s0 '/usr/user'




    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      24



    Typical Environment	Variables:

	HOME	      pathname of home directory
	EDITOR	      user's preferred editor
	PATH	      program execution	searchlist
	TERM	      terminal type
	SHELL	      user's preferred shell
	MAIL	      user's mail box file
	ECUPROMPT     ECU interactive command prompt
		      at beginning of execution



    5.14  %errstr


    usage: %errstr(int0)

    This function returns the system error message, given int0 as an errno
    as returned	by a file-related command.  fopen.


    Example:

	echo %errstr(1)
	Not owner



    5.15  %etime


    usage: %etime(int0)

    This function returns a string representation of elapsed time in the
    format 'hh:mm:ss' for the integer parameter	int0, a	number of seconds.


    Example:

	echo %etime(62)
	00:01:02



    5.16  %filepart


    usage: %filepart(str0)

    This function returns the filename portion of the pathname supplied	in



    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      25



    str0.  See also %basename and %dirpart.


    Examples:

    %filepart('/u1/src/src/foo.c') = "foo.c"
    %filepart('foo.c') = "foo.c"



    5.17  %fmodestr


    usage: %fmodestr(int0)

    This function returns a string representation of the familiar file mode
    string given the file mode integer int0.


    Example:

	echo %fmodestr(0100755)
	-rwxr-xr-x

	echo %fmodestr(%fmode('/usr/lib'))
	drwxr-xr-x



    5.18  %itos


    usage: %itos(int0[,format])

    This function converts integer int0	to a string, optionally	controlling
    the	format of the conversion.

    If the format parameter is missing,	the conversion is to a minimum
    number of decimal characters necessary to hold the result.

    If the format parameter is present,	it must	of consist of a	non-null
    string made	of one or both optional	parts:












    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      26



	decimal	number of digits to be part of result string
	(a leading zero	indicates leading zeroes are to
	appear in the string; no leading zero pads with
	leading	spaces

	a lower	case letter from the following list:
	    d -	decimal	conversion
	    x -	hexadecimal conversion
	    o -	octal conversion

    Example:

	%itos(33)	    '33'
	%itos(33,d)	    '33'
	%itos(33,x)	    '21'
	%itos(33,5d)	    '	33'
	%itos(33,010d)	    '0000000033'
	%itos(33,10d)	    '	     33'
	%itos(33,x)	    '21'
	%itos(33,04x)	    '0021'
	%itos(33,4x)	    '  21'
	%itos(33,o)	    '41'
	%itos(33,4o)	    '	 41'



    5.19  %left


    usage: %left(str0,int0)

    This function returns the leftmost int0 characters of str0.	 If the
    length of the string is less than int0, the	entire str0 is returned.

    Example:

	if $s0 == 'abcdefg'
	%left($s0,3) returns 'abc'



    5.20  %line


    usage: %line

    This function returns the name of the attached communications line in
    the	form "/dev/ttyxx".  If no line is currently attached, the function
    returns null.





    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      27



    5.21  %logname


    usage: %logname

    This function returns the login name of the	user executing ECU.  Note:
    the	name returned is the name supplied to a	login prompt, not any
    current su(C) username that	may be in effect.


    5.22  %mid


    usage: %mid(str0,int0[,int1])

    This function returns the middle portion of	a string str0 beginning	with
    the	character at position int0 and for a length of int1 characters.	 If
    int0 is greater than or equal to the length	of stro, a null	string is
    returned.  If the optional argument	int1 is	not supplied, or if the
    length of the string is less than int1, the	entire str0 is returned.

    Example:

	if $s0 == '0123456789abc'
	%mid($s0,3,4)  returns '3456'
	%mid($s0,3)    returns '3456789abc'
	%mid($s0,10,2) returns 'ab'
	%mid($s0,10,5) returns 'abc'



    5.23  %month


    usage: %month

    This function returns the current month as a three character
    abbreviation: 'Jan', 'Feb',	'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug',
    'Sep', 'Oct', 'Nov', 'Dec'.


    5.24  %rdesc


    usage: %rdesc

    This function returns the description portion of the dialing directory
    entry for the currently connected remote.  If no connection	exists,	the
    function returns null.





    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      28



    5.25  %right


    usage: %right(str0,int0)

    This function returns the rightmost	int0 characters	of str0.  If the
    length of the string is less than int0, the	entire str0 is returned.

    Example:

	if $s0 == 'abcdefg'
	%right($s0,3) returns 'efg'



    5.26  %rname


    usage: %rname

    This function returns the logical name portion of the dialing directory
    entry for the currently connected remote.  If the remote was dialed
    directly, as in dial 5551212, the returned value is	the phone number.
    If no connection exists, the function returns null.

    The	value returned by this command may be overridden by use	of the rname
    procedure command.


    5.27  %rtelno

    usage: %rtelno

    This function returns the telephone	number portion of the dialing
    directory entry for	the currently connected	remote.	 If no connection
    exists, the	function returns null.


    5.28  %time


    usage: %time

    This function returns the current time in the form 'hh:mm' in the local
    time zone (daylight	time if	it applies).









    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      29



    5.29  %times


    usage: %times

    This function returns the current time in the form 'hh:mm:ss' in the
    local time zone (daylight time if it applies).


    5.30  %timez


    usage: %timez

    This function returns the current time in the form 'hh:mm' in the UTC
    (Z)	time zone.


    5.31  %timezs


    usage: %timezs

    This function returns the current time in the form 'hh:mm:ss' in the UTC
    (Z)	time zone.


    5.32  %tty


    usage: %tty

    This function returns the console tty name in the form "/dev/ttynn".


    5.33  %uname


    usage: %uname

    This function returns the system name you are executing ECU	on as
    reported by	uname(2)/uname(S).  On SCO systems, if /etc/systemid exists
    and	is readable, the name in that file isused in place of the name from
    uname.










    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      30



    6.	Commands



    6.1	 autorz


    usage: autorz [off | on]

    ECU	in the interactive mode	(no procedure executing) can interpret a
    SUB, 'B', '0', '0' receive data sequence as	a ZMODEM ZRQINIT frame and
    automatically begin	a ZMODEM receive operation.  This command controls
    this feature.  By default, this feature is turned on.


    6.2	 baud


    usage: baud	<baud-int>

    This command sets the baud rate for	the attached line.  The	integer
    argument <baud-int>	must be	one of 110, 300, 600, 1200, 2400, 4800,
    9600, 19200	and 38400.

    Using the 'baud' procedure command in the ECU initialization procedure
    "_rc.ep" serves as an exact	analog of the -b command.  The baud command
    with the setline command gives you programatic control over	the actual
    choice of the line and rate	or the defaults	for the	setup screen,
    depending upon other options.  NOTE: using the baud	command	in _rc.ep
    will override any command line -b specification.


    Example:
	baud 9600
	set $i0=2400; baud $i0



    6.3	 break


    usage: break

    This command is used inside	a whilei or whiles compound statement to
    exit the loop.

    This is not	to be confused with the	interactive command "break" when
    sends an asynchronous BREAK	signal.	 Use the procedure command lbreak
    for	this purpose.





    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      31



    Example:

	whilei 1=1 #forever unless break command executed
	{
	    echo -n 'Answer yes	or no: '
	    set	$s0=%cgets # get answer
	    ifi	%instr($s0,'y')	== 0 set $i0 = 1; break
	    ifi	%instr($s0,'n')	== 0 set $i0 = 0; break
	    # got neither 'y' nor 'n' ... keep trying
	}
	# now $i0 = 1 if yes, 0	if no


    NOTE: further examples of break usage may be found in the example for
    the	else command.


    6.4	 cd


    usage: cd <directory-path>

    This command changes ECU's current working directory.  The string
    argument <directory-path> may contain any directory	pathname
    specification legal	to be submitted	to the shell csh.  Wild	card
    characters may be used, provided the expansion produces only one
    pathname.


    Example:

	cd '~user/bin'
	cd %envvar('HOME')+'/bin'



    6.5	 clrx


    usage: clrx

    This command clears	 the attached line's transmitter XOFF state.
    Issuing the	command	is the equivalent to receiving an XON from the
    remote system.










    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      32



    6.6	 cls


    usage: cls

    This command clears	the screen.


    6.7	 color



    usage: color <normal-foreground> [<normal-background>]
    usage: color -r <reverse-foreground> [<reverse-background>]


    This command changes the current normal or reverse video colors in a
    manner similar to the setcolor(C) command.	It has no effect on systems
    using other	than an	SCO multiscreen	color monitor. If the second
    (background) color is omitted, it is assumed to be black.

    The	command	also forces normal video mode.	Refer to the vidnorm and
    vidrev commands.  Refer also to the	vidcolor command.


    Color names
       blue	 magenta      brown	 black
       lt_blue	 lt_magenta   yellow	 gray
       cyan	 white	      green	 red
       lt_cyan	 hi_white     lt_green	 lt_red

    Example:

	color lt_green	# normal video light green on black
	color -r red white # reverse video red on white



    6.8	 continue


    usage: continue

    This command is used inside	a whilei or whiles compound statement to
    skip the remainder of any commands in the loop and continue	execution at
    the	first command in the loop.








    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      33



    Example:

	send ''	# send ENTER to	get prompt
	whilei 1=1 # forever unless break command executed
	{
	    lookfor -e 'login: ' # look	for login prompt
	    ifi	$i0 == 0	 # if we dont get prompt ...
	    {
		send ''		 # send	ENTER again
		continue	 # and look for	login prompt
	    }
	    send $s_name	 # send	username
	    lookfor -e 'Password:'
	    send $s_password
	    get	-e 0 50		 # wait	10 seconds for response

	    # if incorrect not found in	response, ...
	    if %instr($s0,'incorrect') < 0 # ... must have won
		break

	    # garbled line?: system will send another 'login: '
	}



    NOTE: further examples of continue usage may be found in the example for
    the	else command.


    6.9	 cursor


    usage: cursor <row>	[<col>]

    This command places	the cursor at a	specified position on the video
    screen.  The top left of the scrren	is row 0, column 0.  If	<col> is not
    specified, it is assumed 0 (left margin).

    Example:

	cls
	$i0 = 5
	whilei $i5 < 12
	{
	    cursor $i5
	    echo 'This is line '+%itos($i5,2d)+' of the	display'
	}







    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      34



    6.10  dcdwatch


    usage: dcdwatch [<dcdwatch-param>]

    This command controls the DCD watcher.  The	optional argument may be:

       y or yes		enable DCD watcher
       n or no		disable	DCD watcher
       t or terminate	terminate ECU on loss of DCD


    The	DCD watcher when enabled causes	ECU to monitor the DCD line (within
    the	limits imposed by the OS with its CLOCAL=0 functionality).  When the
    watcher is on and DCD drops, ecu automatically performs the	action of
    the	interactive or procedure hangup	command.  If the 't'erminate option
    is chosen, then after hangup processing is complete, the ECU program
    will terminate.

    The	state of the watcher may be changed by the use of the dial command
    which uses a directory entry which changes the DCD watcher status.

    The	DCD watcher depends upon the tty driver	to return zero characters on
    a read when	DCD is low when	the termio flag	CLOCAL is reset.  The tty
    driver must	ignore DCD if CLOCAL is	set.  If your system offers a
    "modem" and	"direct" choice	(by choice of filename), you probably need
    to use the "modem" choice for this to work properly.  This decision	is
    made properly for you on SCO if you	are using SCO "standard" tty line
    naming conventions.	 This is true even though ECU appears to force a tty
    name with trailing upper case characters (modem) to	one with a lower
    case character (direct).


    6.11  delline


    usage: delline

    This command deletes the current line from the video display.


    6.12  dial


    usage: dial	<remote>

    This command causes	an outgoing call to be placed.	The string argument
    <remote> can take one of two forms:	a numeric telephone number or an
    alphanumeric "logical" number or system name.

    A numeric phone number ('1(800)555-1212' or	'2345678') must	begin with a



    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      35



    digit and must consist entirely of digits, parentheses or hyphens.	If a
    telephone number is	supplied, the phone number is dialed; you must first
    have set the desired baud rate and parity using the	'baud' and 'parity'
    commands.  (If the last character of a telephone number is a dollar
    sign, it is	removed	and is replaced	with the contents of the first line
    in ~/.ecu/credit.  See the description of the dialing directory.)

    If a logical name is entered, the phone directory (managed by the
    interactive	dial command) is searched; if the entry	is found, the baud
    rate and parity is automatically set from values in	the directory entry;
    then, the number in	the directory entry is dialed.

    Using the dial command with	a directory entry may change the DCD watcher
    (dcdwatch) status.	See the	section	on the dcdwatch	command	and the
    section titled "Choosing a Dialout Line" for more information.

    When the dial command returns, integer variable $i0	is set to a status
    code and string variable $s0 has a text message (the modem verbal result
    code if the	ECU dialer is used, a representation of	the return status
    code if a uucp dialer is used [see below]).

    Dial Command $i0 Status Codes

	0  successful connect
	1  failed to connect (call progress)
	2  dial	interrupted by signal
	3  modem error (non responsive or commands rejected)

    Dial Command $s0 Status Messages (uucp dialer)

	CONNECT	####	       #### = baud rate
	BUSY		       only some modems
	NO ANSWER	       only some modems
	NO CARRIER	       most generic "fail to connect"
	NO DIAL	TONE	       only some modems
	!Connect bad baud rate modem reported different	rate
	!Interrupted	       call interrupted	by signal
	!Invalid arguments     ECU error
	!Invalid phone number  too long	or bad characters
	!Ioctl error	       should not be reported here
	!Line in use	       should not be reported here
	!Line open error       should not be reported here
	!Modem Error	       modem did not respond

    Note: if the ECU dialer is used, the actual	modem result code
    is returned	in $s0 or one of the following two strings:

	!Interrupted	       call interrupted	by signal
	!Modem Error	       modem did not respond





    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      36



    6.13  do


    usage: do <procname> [<arg>	...]

    This command executes a procedure whose name appears as the	command's
    first (string) argument.  One or more arguments (up	to 19) may be passed
    to the called procedure; an	argument may consist of	any valid string
    expression,	provided, that,	when expanded,	the argument does not exceed
    256	characters in length.

    The	called procedure may read its arguments	using the %argv	string
    function.  %argv(0)	is the name of the procedure.  The quantity of
    arguments may be obtained using the	%argc integer function.


    Example:

	do 'proc' %rname %date+' '+%time %argv(0)

    Note: in this example, the called procedure	is passed the name
    of the calling procedure as	the last argument.



    6.14  duplex



    usage: duplex full | half
	   duplex 'full' | 'half'


    This command specifies whether or not ECU is to locally echo characters
    typed by you at the	keyboard.  The overwhelming majority of	remote
    systems provide the	echo function, in which	case full duplex must be
    used.  For the rare	occasions when the remote system does not echo your
    keyboard input, setting half duplex	will allow you to see what you are
    typing.

    When communicating with another terminal in	a "teletype conversation",
    setting half duplex	is generally required.	In such	cases, use of the
    interactive	nl, nlin and nlout commands may	also be	required.

    Example:

	duplex full
	$s0 = 'full'; duplex $s0






    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      37



    6.15  echo


    usage: echo	[-n] <string>

    This command prints	the contents of	the string argument <string> on	the
    screen.  If	the -n switch is not present, a	newline	follows	the output
    of <string>.

    Example:

	echo 'Procedure	'+%argv(0)+' executing at '+%time
	echo -n	'Enter your first name:	'; $s0 = %cgets



    6.16  eeol


    usage: eeol

    This command erases	the video display to the end of	the line.


    6.17  else



    usage: else	<statement>

	   else
	       <statement>

	   else
	   {
		any kind and number of statements
	   }

	   else	<if> <statement>

	   else	<if>
	   {
		any kind and number of statements
	   }



    This statement may follow an ifi or	ifs command to specify one or more
    statements to be executed if the if-type command condition is false.
    Else commands may be chained together in the traditional structured
    language manner.



    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      38



    For	the purposes of	describing this	command, <statement> is	any single
    or compound	statement NOT containing a whilei or whiles command.  If you
    wish to have a while-type command executed as part of an else condition,
    the	while must occur within	braces ("{}").

    <if> is an ifi or ifs command followed by an <if-condition>	(see the
    description	of the ifi or ifs commands below).

    Example:

    #+------------------------------------------------------
    # finger.ep	- procedure to send 'finger' to	remote
    # BSD Unix system; print resulting lines in	different
    # colors: uucp logins green, root red, others cyan
    #-------------------------------------------------------

	mkvar $icolor; $icolor = %colors
	mkvar $itimeout
	$itimeout = 50	   # timeout for first line 5 secs
	send 'ps -aux'	   # send command, but do not echo
	lookfor	'\n' 40	   # swallow command
	whilei 1==1	   # forever, or until break
	{
	    lgets 0 $itimeout 1	'\n' #get a line
	    ifi	$i0 = 0	break #if no chaacters read
	    $itimeout =	10 #wait 1 sec for later lines

	    ifi	%instr($s0,'% ') >= 0 #	if csh prompt seen
		break		      #	exit while loop
	    else ifi %instr($s0,'Login') >= 0
		color gray
	    else ifi %instr($s0,'root')	>= 0
		color red
	    else ifi %instr($s0,'uucp')	>= 0
		color green
	    else color cyan
	    echo $s0
	}
	icolor $icolor #restore	entry colors
	send ''	       #force a	new prompt from	remote




    6.18  exec


    usage: exec	<string>

    This function executes a string as a procedure statement.  Argument
    <string> must contain an ecu statement exactly as might appear on a



    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      39



    procedure line, with a few exceptions.


    1. There may be no label: the first	command	may
       start in	column one.
    2. You should not execute a	goto, gosub or return.
    3. You should not code if, while or	compound statement
       brackets.


    You	are on your honor with regard to items 2 and 3 above.  If you
    stretch it,	it will	break.


    Example:

	$s20 = 'Home';	 $s30 =	'^H'
	$s21 = 'End';	 $s31 =	'^E'
	$s22 = 'F1';	 $s32 =	'^A'
	$s23 = 'F2';	 $s33 =	'^B'
	$i10 = 0
	whilei $i0 < 4
	{
	    $s0	= 'fkmap '+$s[20+$i10]+' '+$s[30+$i10]
	    exec $s0
	    $i10 = $i10	+ 1
	}



    6.19  exit


    usage: exit	[<status>]

    This command causes	an abrupt termination of the ECU program.  Any
    existing connection	with a remote system is	terminated immediately.	 If
    no integer argument	<status> is found, ECU exits with a program exit
    status of 0.  If <status> is found and the value is	zero, then ECU exits
    with a program exit	status of 0.  If <status> non-zero,its value must be
    in the range of 1 to 31, and ECU exits with	a program exit status of 192
    plus <status>.  This feature allows	batch executions of ECU	by shell
    script to detect user-determined ECU execution status.  See	the section
    titled "Exit Codes".










    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      40



    6.20  expresp


    usage: expresp [-v[v...]] <exp-resp-str> [<timeout_msecs>]

    This command emulates the uuchat function as described in the SCO HDB
    UUCP documentation and in the /usr/lib/uucp/Dialers	file.

    -v causes the expect-respond conversation between ECU and the remote
    system to be displayed on the screen.  This	switch is automatically
    enabled if procdedure tracing is enabled.

    Multiple v's (e.g.,	-vv, -vvv) up to 3 'v's	produce	more verbose debug
    output. -vv	causes each base level expect and respond string to be
    displayed. -vvv causes a hexadecimal dump of each  interpreted expect
    string to be displayed.

    The	majority of procedure tracing features use the current trace state
    (from the ptrace command setting) as a binary condition.  That is,
    either tracing is done or not.  However, expresp adds the tracing level
    to the number of -v	switches to determine its verbosity level.

    Escape sequences allow you to insert special or variable information in
    your expect	and respond strings.  Escape sequences begin with either the
    backslash or the tilde.  NOTE: remember to use two backslashes inside a
    literal string constant to get one backslash in the	resulting string.
    The	procedure language's string parser has it's own	use for	a single
    backslash followed by another character.  For instance:


	set $s0='\\M' sets $s00	to '\M'


    Some of the	escape sequnces	have meaning in	both expect and	respond
    tokens while others	have a use in only of of the two types.



















    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      41



       Meaning of the escape sequences:
       \D - current phone number
       \E - turn on echo checking when sending (for slow devices)
       \K - send a BREAK
       \M - turn on line CLOCAL
       \N - null byte (same as \000)
       \T - current phone number with Dialcodes	and
	     character translation
       \c - append no new-line to send string (must be last
		"character" in a send string)
       \d - delay (2 seconds)
       \e - turn off echo checking when	sending
       \m - turn off line CLOCAL
       \n - send or expect new-line
       \p - pause (approximately 1/4-1/2 second	delay)
       \r - send or expect carriage return
       \\ - send or expect backslash (same as \134)
       \~ - send or expect tilde (same as \176)
       \### - send or expect character respresenting three
	       character octal value ### (*MUST* be three digits
	       with leading zeroes as necessary)
       ~m[##] -	set expect timeout to ## milliseconds (NOT
		SUPPORTED BY DIALERS; SEE BELOW)
       ~n[##] -	nap ## milliseconds (NOT SUPPORTED BY DIALERS;
	       SEE BELOW)
       ~t[##] -	set expect timeout to ## seconds (NOT SUPPORTED
		BY DIALERS; SEE	BELOW)
       Speed - Hayes-style CONNECT handler (as sole contents of
	       an expect string, equivalent to using CONNECT)


    <timeout_msecs> specifies an optional timeout in milliseconds for
    waiting on expect strings;	it defaults to 10,000 milliseconds (10
    seconds).  The resolution for timeouts is limited to the basic tick	time
    of your system (HZ,	10 msec	for UNIX/386 3.2.0, 16 (1000/60) msec for
    3.2.1 (ODT 1.0) and	3.2v2 (ODT 1.1), back to 10 msec for 3.2v4 (ODT	2.0)
    and	20 msec	for XENIX/386 and XENIX/286). Whew!  The timeout for 'Speed'
    expects is fixed at	90 seconds.

    ~t[##] and ~m[##] may appear at the	beginning of an	expect portion of a
    script.  They set the expect timeout delay in seconds and milliseconds,
    respectively.  The ## is a decimal number; if it is	specified <= 0,
    there will be no delay.  The initial timeout set for each execution	of
    the	expresp	command	is 10 seconds.	The timeout period remains as you
    set	it for the remainder of	the script unless you change it	again.









    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      42



    Examples:

	~t[20]gin:	look for "gin:"	for 20 seconds
	~m[500]	01     look for	STX for	500 milliseconds
	"" ~t[3]gin:--gin: uname ~t[10]word: secret


    ~n[##] may appear anywhere in a respond portion of a script. It causes
    ECU	to nap the number of milliseconds specified by the decimal ##
    argument.  This function was served	by \m prior to ECU 3.20.  Addition
    of SVR4 \M and \m necessitated the change.


    Example:

	a~n[20]b~n[20]c	  send "abc" with 20 msec between each
			  character



    Integer variable $i0 is set	to one if the expect-respond script fails,
    else it is set to 0.


    6.21  fchmod


    usage: fchmod <mode> <filenum>

    This command sets the mode of <filenum> to <mode>.	The <mode> argument
    takes one of two forms, a nine-character mode string (e.g.,	'rwxr-xr-x')
    or an integer value	(0755).	 The <filenum> argument	is either a string
    value forming a filename or	an integer file	number representing a file
    opened with	the fopen command.

    The	command	sets $i0 = 0 if	successful, else to the	errno from the
    associated system call (refer to the %errstr string	function and/or
    /usr/include/sys/errno.h).


    Example:

	fopen 1	'/tmp/123'; fchmod 'rwxrwxrwx' 1
	fchmod 'rwxrwxrwx' '/tmp/123'
	fopen 1	'/tmp/123'; fchmod 0777	1
	$i0 = 0777; fchmod $i0 '/tmp/123'

    All	of the above example result in the same	result.






    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      43



    6.22  fclose


    usage: fclose <filenum>

    This command closes	<filenum>.  The	<filenum> argument is an integer
    file number	representing a file opened with	the fopen command.

    The	command	is ignored if <filenum>	is not open.  No integer variable is
    modified by	fclose.


    Example:

	fclose 1



    6.23  fdel


    usage: fdel	<filenum>

    This command removes a file.

    The	command	sets $i0 = 0 if	successful, else to the	errno from the
    associated system call (refer to the %errstr string	function and/or
    /usr/include/sys/errno.h).


    Example:

	fdel '/tmp/123'



    6.24  fgetc


    usage: fgetc <filenum> <destination>

    This command reads a character from	<filenum>.  The	<filenum> argument
    is an integer file number representing a file opened with the fopen
    command.

    The	argument <destination> is either a string variable or an integer
    variable.  If the file has reached end of file: an integer variable
    receives -1; a string variable is returned null.  Otherwise, the
    character's	numeric	value (0-255) is placed	in an integer variable or a
    string variable is returned	with a length of one with the file character
    as its only	character.



    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      44



    Example:

	fgetc 1	$s0
	fgetc 1	$i_input



    6.25  fgets


    usage: fgets <filenum> <strvar>

    This command reads a character from	<filenum>.  The	<filenum> argument
    is an integer file number representing a file opened with the fopen
    command.

    The	argument <strvar> is a string variable.	 If the	file has reached end
    of file, <strvar> is returned null and integer variable $i0	is set to 1.
    Otherwise, the <strvar> receives input from	the file minus the trailing
    newline and	$i0 is returned	zero.


    Example:

	fgets 1	$s0



    6.26  fkey



    usage: fkey	<str>
	   fkey	-r


    This command selects a function key	definition from	the ~/.ecu/keys
    file.  The -r version resets to the	original defaults, plust loads any
    entry in keys named	"default".


    6.27  fkmap

    usage: fkmap
	   fkmap <keyname>
	   fkmap <keyname> <keylist>
	   fkmap -r
	   fkmap -s <file>


    This command manages the mechanism ECU uses	to recognize function keys



    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      45



    when they are entered at the console.  Entering the	command	with no
    arguments displays the current mapping in funckeymap format.

    If supplied, the first argument to the command must	be the recognized
    name of a function key from	the list:

     F1	F2 F3 F4 F5 F6 F7 F8 F9	F10 F11	F12
     Home End PgUp PgDn	CUP CUL	CU5 CUR	CUD

    The	case of	the entered argument is	unimportant.

    If only one	argument is supplied, the mapping for the specified key	is
    displayed.	If more	than one argument is supplied, the keyboard mapping
    is changed.	 Arguments 2-n are character code specifiers in	the format
    used to define a funckeymap	entry.	WARNING: If found to be
    syntactically correct, a mapping change is installed immediately.  If
    incorrect mapping of the HOME key is requested, you	may lose control of
    ECU.

    The	-r form	rereads	the original funckeymap	definition (as at program
    invocation), reseting the mapping.	The -s switch saves the	current
    mapping to <file>.

    Note: the fkmap command line must contain literal text.  No	variable or
    expression expansions are not done.


    Examples:

	fkmap f10	display	F10 mapping
	fkmap Home ^Z	map Home to ^Z
			after this command, type ^Z for	Home



    6.28  flush


    usage: flush

    This command causes	any characters received	by the system from the line,
    but	not yet	read by	the procedure to be "forgotten"	or flushed.


    6.29  fopen


    usage: fopen [-<mode>] <filenum> <filename>

    This command opens a file named by the string argument <filename> and
    associates it with the user-chosen file number <filenum> (which must be



    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      46



    an integer value between 0 and 4, inclusive).

    The	argument switches govern how a file is opened and must be chosen
    from this list:

	-r	   The file is opened read-only; if it does not	exist, an
		   error occurs.

	-r+	   The file is opened for reading and writing; if it does
		   not exist, an error occurs.

	-w	   The file is opened for writing (any previous	contents of
		   the file are	lost); if it does not exist, it	is created.

	-w+	   The file is opened for reading and writing (any previous
		   contents of the file	are lost); if it does not exist, it
		   is created.

	-a	   The file is opened for appending (writes to the file	are
		   added to the	previous file contents); if it does not
		   exist, it is	created.  All writes are appended to the
		   file	(the fseek command has no effect).

    The	switches argument may be omitted; in such cases, the file is opened
    as though '-r' had been supplied.  However,	if procedure tracing is
    enabled (see the description of the	interactive and	procedure command
    ptrace), a warning message will be issued.

    The	command	sets $i0 = 0 if	successful, else to the	errno from the
    associated system call (refer to the %errstr string	function and/or
    /usr/include/sys/errno.h).

    Example:

	fopen 0	-r '/etc/passwd'
	fopen 1	-w+ '/tmp/123'
	fopen 2	-a 'tranact.log'



    6.30  fputc


    usage: fputc <filenum> <char>

    This command writes	character <char> into <filenum>.  The <filenum>
    argument is	an integer file	number representing a file opened with the
    fopen command.  Argument <char> is a integer value of which	the lower
    eight bits are used	or a string value of which the first character is
    used.




    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      47



    If a write error occurs, procedure execution is terminated.

    Example:

	$s0='abc'; fputc 1 $s0	      writes 'a'
	$i0=0x30 ; fputc 1 $i0	      writes '0'



    6.31  fputs


    usage: fputs [-n] <filenum>	<str>

    This command writes	the string <str> into <filenum>.  The <filenum>
    argument is	an integer file	number representing a file opened with the
    fopen command.

    If the switch '-n' is omitted, a newline is	appended after <str> in	the
    file; if present, no newline is written.

    If a write error occurs, procedure execution is terminated.

    Example:

	$s0='abc'; fputc 1 $s0	      writes 'a'



    6.32  fseek


    usage: fseek <filenum> <position>

    This command sets the file position	of <filenum> to	<position>, an
    integer value.  The	corresponding integer function %ftell may be used to
    determine the current file position.

    Note: if <filenum> is open for append ('-a'), then the fseek command
    will have no effect.


    6.33  getf











    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      48



    usage: getf	-x <int-var-spec> <offset>

    where: -x ==
       -b byte
       -w word (little-endian)
       -W word (big-endian)
       -l 32-bits (little-endian)
       -L 32-bits (big-endian)



    6.34  gosub


    usage: gosub <label>

    This command transfers control of procedure	to a statement other than
    the	one immediately	following.  The	<label>	argument may be	literal	text
    or may be a	string,	allowing a "computed gosub" feature.

    When the next return statement is executed,	control	is returned to the
    next statement after the gosub.


    Example:

	gosub GET_NEXT
	gosub 'GET_NEXT'
	gosub 'GET'+'_NEXT'
	$s0 = 'GET_NEXT'; gosub	$s0
	$s0 = 'NEXT'; gosub 'GET_'+$s0

    Note: all the above	examples cause transfer	to the label GET_NEXT.





















    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      49



    A switch or	case function of sorts may be implemented by something like:

	#$i0 has been set to the "switch" value
	ifi $i0	< 0 || $i0 > 2	# avoid	gosub label not	found
	{
	    echo 'bad my_case state value'+%itos($i0)
	    DO SOMETHING LIKE DIE OR DUMP VARS AND DIE
	}
	$s0 = 'my_case_'+%itos($i0,03)
	gosub $s0

    my_case_000
	echo 'handle case 0'
	return

    my_case_001
	echo 'handle case 1'
	return

    my_case_002
	ifi $i_already_did_002
	{
	    echo 'whoops'
	    return
	}
	echo 'handle case 2'
	$i_already_did_002 = 1
	return



    6.35  gosubb


    usage: gosubb <label>

    This command serves	the same function as the gosub command except the
    programmer is signifying that the label is behind the current statement,
    resulting in slightly faster execution.  (The label	is not REQUIRED	to
    be at any specific location	in the procedure relative to the gosubb
    statement.)


    6.36  goto


    usage: goto	<label>

    This command transfers control of procedure	to a statement other than
    the	one immediately	following.  The	<label>	argument may be	literal	text
    or may be a	string,	allowing a "computed goto" feature.



    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      50



    Example:

	goto GET_NEXT
	goto 'GET_NEXT'
	goto 'GET'+'_NEXT'
	$s0 = 'GET_NEXT'; goto $s0
	$s0 = 'NEXT'; goto 'GET_'+$s0

    Note: all the above	examples cause transfer	to the label GET_NEXT.


    6.37  gotob


    usage: gotob <label>

    This command serves	the same function as the goto command except the
    programmer is signifying that the label is behind the current statement,
    resulting in slightly faster execution.  (The label	is not REQUIRED	to
    be at any specific location	in the procedure relative to the gotob
    statement.)


    6.38  hangup


    usage: hangup

    This command causes	Data Terminal Ready (DTR) to be	dropped	momentarily,
    causing (hopefully)	the termination	of any current connection to a
    remote system. This	command	is only	effective if the attached Data
    Communications Equipment is	configured to terminate	its connection on
    loss of DTR.

    If no line is attached, the	command	is ignored (a warning is generated
    if procedure tracing is enabled).


    6.39  hexdump



    usage: hexdump [-s]	<str>
	   hexdump -t[s] <str1>	<str>

    <str> buf to dump
    <str1> title (if -t)
    -s short (terse) dump


    This command prints	a hexadecimal dump of <str> on the screen (and to



    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      51



    the	procedure log file, if logging enabled with the	ptrace command).

    The	switch '-t' signifies that <str1> is a title to	be printed

    Example:

	$s0='The quick brown fox jumped	over the lazy dog\'s back'
	hexdump	-t 'Example hex	dump' $s0
    ---------------------------- Example hex dump ----------------------------
    0000  54 68	65 20 71 75 69 63 6B 20	62 72 6F 77 6E 20 | The	quick brown  |
    0010  66 6F	78 20 6A 75 6D 70 65 64	20 6F 76 65 72 20 | fox	jumped over  |
    0020  74 68	65 20 6C 61 7A 79 20 64	6F 67 27 73 20 62 | the	lazy dog's b |
    0030  61 63	6B					  | ack		     |

	hexdump	%left($s0,9)
    0000  54 68	65 20 71 75 69 63 6B			  | The	quick	     |

	hexdump	-ts 'Example hex dump' %left($s0,9)
    Example hex	dump
    0000  54 68	65 20 71 75 69 63 6B | The quick |

	hexdump	-s %left($s0,9)
    0000  54 68	65 20 71 75 69 63 6B | The quick |



    6.40  home


    usage: home

    This command homes the video cursor.


    6.41  icolor


    usage: icolor <int-colors>

    This command sets the normal and reverse foreground	and background
    colors according to	<int-colors>, an integer value in the format as	that
    returned by	the %colors integer function.

    This command is provided primarily to be able to save the color state,
    modify it temporarily and then restore it.









    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      52



    Example:

	mkvar $icolor_save; $icolor_save = %colors
	color red; echo	'Connection seems to be	dead'
	icolor $icolor_save # restore previous colors



    6.42  ifi



    usage: ifi <int> <rel-op> <int> <statement>
	   ifi <int> <rel-op> <int>
	       <statement>
	   ifi <int> <rel-op> <int>
	   {
	       any kind	or number of statements
	   }


    This command selectively executes one or more statements based on a	test
    of two integer quantities.	See the	description of the break, continue,
    and	else commmands for examples of how the command is used.


    6.43  ifs



    usage: ifs <str> <rel-op> <str> <statement>
	   ifs <int> <rel-op> <int>
	       <statement>
	   ifs <int> <rel-op> <int>
	   {
	       any kind	or number of statements
	   }


    This command selectively executes one or more statements based on a	test
    of two string values.  See the description of the break, continue, and
    else commmands and many other examples throughout the document, for
    examples of	how the	command	is used.


    6.44  insline


    usage: insline

    This command inserts a line	onto the video screen at the current line.



    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      53



    6.45  lbreak


    usage: lbreak

    This command transmits a break to the remote system.  It is	the
    procedure command analogous	to the break interactive command.


    6.46  lgets



    usage: lgets [-er] <strvar>	<t1-int> <t2-int> [<stop-str>]

    -e echo received characters	to screen
    -r raw read	(retain	carriage returns)


    This command reads a string	from the attached communications line.
    <t1-int> is	the number of tenths of	seconds	before timing out waiting
    for	the first character to be received.  <t2-int> is the number of
    tenths of seconds before timing out	on later characters.  <stop-str> is
    an optional	argument, which	if received, immediately terminates the
    read.  Integer variable $i0	is set to the count of characters received.

    If the specified string variable is	filled with characters before the
    <stop-str> has been	encountered or before a	timeout	occurs,	then the
    command returns with $i0 set to the	maximum	size of	the variable.

    Most procedure commands will increase the size of an unumbered string
    variable as	needed until the maximum string	size is	reached.  The lgets
    command does not.  You must	start with the command with a string
    variable whose maximum size	is already the desired value.  Refer to	the
    section on string variables	above and the section describing the mkvar
    command below for information on the size of string	variables.


    6.47  logevent



    usage: logevent <str>


    This command writes	a log item to ~/.ecu/log.








    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      54



    Example:

	$s0='/tmp/alm.log'
	log 'appending alarm info to '+$s0

    writes:
    10-02-1989-17:39-01261-PROC	appending alarm	info to	/tmp/alm.log

    assuming the transmitter process pid is 1261 and you are living in 1989.

    6.48  lookfor



    lookfor [-e] [quiet	| <str>] [<timeout-int>]

    -e echo to screen while "looking"

    This command is used to read from the attached commuications line until
    one	of two user-specified conditions occurs.

    The	'quiet'	option waits for the line to become quiet for the number of
    tenths of seconds specified	 by <timeout-int>.

    The	other option reads the line until <str>	is read	from the line or
    until <timeout-int>	tenths of seconds elapses.  With this option,
    integer variable $i0 is set	to 1 if	<str> is found within the timeout
    period or 0	if not.


    Examples:

	lookfor	-e quiet 20   wait for quiet line for 2	secs
	lookfor	'word:'	50    wait for 'word:' for up to 5 secs

    6.49  mkvar



    usage: mkvar [$]i<name>
	   mkvar [$]s<name>(<size>)


    This command creates one or	more named (temporary) integer or string
    variables.	The variable type is determines	by the first character of
    the	variable, which	must be	'i' or 's'.  The size of a string variable
    must be specified via the <size> argument.	An optional '$'	may be
    supplies for neatness, but may be omitted if desired.






    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      55



    6.49.1  Variable Names

    The	names for created (named, temporary) variables consist of a dollar
    sign ('$'),	an 'i' for integer or 's' for string and up to fifteen
    characters from the	set [A-Za-z0-9_].

    The	first character	after the 'i' or 's' in	<name> must be non-numeric.
    '$sxyz' and	'$s_3xyz' are legal, but '$s3xyz' is not (it would be
    interpreted	as '$s3' followed by the illegal command sequence 'xyz').

    The	<name> space for integer and string variables are separate.  It	is
    possible to	have an	integer	variable named '$ixyz' and a string variable
    named '$sxyz'.


    6.49.2  Variable Life and Scope

    The	life and scope of created variables is for the duration	of the
    execution of the creating procedure.  Procedures called by the creating
    procedure (by 'do')	can reference temporary	variables declared by a
    previous procedure.	 When created, integer variables are set to zero and
    string variables are set to	zero length.  These features differ from
    numbered variables which retain their scope	and values at all times,
    even when procedure	execution terminates and ECU returns to	interactive
    mode.

    Variables may be created by	the same name more than	once.  The latest
    mkvar execution specifies the variable referenced.	Thus if	proc1
    declares '$ixx' and	calls proc2 which also declares	'$ixx',	proc2's
    variable is	distinct from proc1's and disappears when proc2	terminates,
    thus making	proc1's	available to it	again, containing the same value as
    it had at the time proc2 was called.


    6.49.3  String Variable Size

    The	maximum	value for <size> is 16384.  Regardless of the size specified
    in the creation of a string	variable, ECU will usually expand it's size
    as necessary up to the maximum.  Check the documentation for the
    operation you are performing; if there is no exception noted, ECU will
    expand the string maximum size as necessary.  For instance,	the set
    command will grow a	string as part of assignment.  However,	the lgets
    command will not.


    Examples:

	mkvar i_count
	mkvar $i_count
	mkvar s_20(20),s_80(80),i_timeout,$i_colors




    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      56



    6.50  nap


    usage: nap <int>
	   nap -m <int>

    This command suspends procedure execution for <int>	tenths of seconds if
    -m is not specified.  If -m	is used, execution is suspended	for <int>
    milliseconds.  Note: the actual period execution is	suspended depends,
    as usual, on the scheduling	load of	the system.  For small -m values, be
    aware that the granularity of the nap duration is set by the system, 20
    milliseconds for XENIX 286 and 386,	10 milliseconds	for UNIX.

    If you need	to know	the frequency of the system clock, something like

	  $i0 =	%stoi(%getenv("HZ"))

    will obtain	the value for you (provided HZ is in the process'
    environment).

    Examples:

	nap 30
	nap $i0*$i2
	    nap	-m 50



    6.51  nice


    usage: nice	<int>

    This command sets the nice value of	the process.  It behaves exactly
    like the nice(S) or	nice(2)	system call. The <int> argument	must be	in
    the	range 0	through	39, inclusive.	If the call fails, a warning is
    printed and	the procedure continues	to execute.  The current nice value
    may	be obtained using the %nice integer function.  See also	the
    description	of the nice interactive	command.


    6.52  parity



    usage: parity [even	| odd |	none]
	   parity <str>


    This command sets the parity for the attached communications line.	If
    <str> is supplied, the first character must	be 'e',	'o' or 'n'.



    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      57



    Uppercase equivalents are also accepted.


    Examples:

	parity even
	parity 'e'
	parity 'Even now as we speak'



    6.53  pclose


    usage: pclose <filenum>

    This command should	be issued when a command started by the	interactive
    popen commandf completes.


    6.54  plog



    usage: plog
	   plog	<str>
	   plog	off


    This command controls logging to a file of the screen output during
    procedure execution.  With no argument, the	command	displays the status
    of logging.	 <str> specifies a log file pathname, while the	'off'
    argument turns logging off.

    If procedure execution terminates due to an	error, procedure logging is
    turned off.	 However, if procedure execution terminates normally while
    logging is active, erratic and unpredictable portions of interactive
    mode screen	output will continue to	be logged to the current log file.

    The	interactive mode command plog may also be used to control procedure
    logging.

    Example:

	mkvar s_logname(128)
	$s_logname = %dir+'logname'
	plog $s_logname
	echo 'Test'
	plog off;cd 'somewhere_else';plog $s_logname
	echo 'Test'




    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      58



    6.55  popd



    usage: popd	[ | <#>	| all]


    This command returns to a previous directory after a pushd command has
    been previously executed.

    If no argument is supplied,	the directory at the immediately previous
    level is restored.

    If a numeric argument is supplied, the directory at	the specified level
    is restored; the level numbers may be obtained by issuing a	pushd
    command with no arguments.

    If the 'all' argument is supplied, it is treated as	a numeric argument
    of 0; that is the directory	stack is cleared and the directory at level
    0 is restored.

    The	directory stack	is shared between interactive and procedure
    commands.  Neither beginning nor ending a procedure	affects	the
    directory stack level.


    Examples:
       popd
       popd 3
       popd all



    6.56  popen


    usage: popen [-switches] <filenum> <command>

    This command executes a shell command defined by the string	argument
    <command> and associates it	with the user-chosen file number <filenum>
    (which must	be an integer value between 0 and 4, inclusive).

    The	argument switches govern whether the command is	to receive input
    from ECU or	output to ECU and must be chosen from this list:

	-r	   The command will output to ECU.

	-w	   The command will receive input from ECU.

    The	switches argument may be omitted; in such cases, the file is opened
    as though '-r' had been supplied.  However,	if procedure tracing is



    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      59



    enabled (see the description of the	interactive and	procedure command
    ptrace), a warning message will be issued.

    The	command	sets $i0 = 0 if	successful, else to the	errno from the
    associated system call (refer to the %errstr string	function and/or
    /usr/include/sys/errno.h).

    Example:

	popen 0	-r 'ls -l *.log'
	popen 1	-w 'cat	| sort > /tmp/sorted'




    6.57  prompt


    usage: prompt <str>

    This command allows	selection of an	alternate prompt to the	interactive
    mode HOME command trigger.	Refer to the section titled "ECUPROMPT"	for
    more information on	the interactive	mode prompt.

    Note: the interactive and procedure	hangup commands	both cause the
    default prompt to be reestablished.


    Example:

	 prompt	%rname+' >'    use remote name in prompt



    6.58  ptrace



    usage: ptrace [ <str> | off	]


    This command controls procedure execution tracing.	Trace output is
    written to the screen and varys in its nature depending upon the command
    being traced.  Specifically, any change to a string	or integer variable
    is noted.  If tracing is enabled, the output will also be written to any
    active procedure log file (see the plog interactive	and procedure
    commands).

    The	majority of procedure tracing features use the current trace state
    as a binary	condition.  That is, either tracing is done or not.
    However, the procedure command expresp emits varying levels	of debugging



    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      60



    output in a	manner similar to the uucico -x	flag.


    6.59  pushd



    usage: pushd [ | <dir>]


    This command either	1) saves the current directory pathname	on a stack
    and	establishes a new current directory or 2) displays the current stack
    and	current	directory.  The	stack size is 10.

    If no argument is supplied,	the directory stack is displayed.

    The	directory stack	is shared between interactive and procedure
    commands.  Neither beginning nor ending a procedure	affects	the
    directory stack level.


    Examples:
       pushd
       pushd '/tmp'



    6.60  putf


    Not	yet implemented.


    6.61  return


    usage: return [<int>]

    This command serves	two functions: to return from a	gosub to or return
    from a procedure execution.	 If <int> is supplied, it must be in the
    range 0 to 255.  Other values result in a return value of 255.

    If no gosub	is active, return causes the currently executing procedure
    to terminate, returning either to a	calling	procedure or to	the
    interactive	mode.  If <int>	is supplied and	it's value is nonzero, then
    all	procedure execution is terminated and the integer status is printed
    on the screen along	with the name of the executing procedure.

    If a gosub is active, return or return 0 causes control to return to the
    statement immediately following the	gosub which invoked the	subroutine.
    If <int> is	supplied and it's value	is nonzero, then all procedure



    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      61



    execution is terminated and	the integer status is printed on the screen
    along with the name	of the executing procedure.

    It is not possible to terminate a procedure	with normal status from
    within a subroutine.


    Example:

    #---------------------
    # gosub.ep
    #---------------------
	echo 'main'; gosub SUB;	echo 'back to main'
	return

    SUB
	echo 'sub'
	gosub SUB2
	echo 'back to sub'
	return


    SUB2
	echo 'sub2'
	return




    6.62  rk


    usage: rk [-a]

    This command invokes C-Kermit to receive files. ECU	searches the PATH
    list for 'kermit' or 'ckermit', expecting to find Columbia University
    C-Kermit version 5A(173) or	later.	The file ~/.kermrc must	be set up to
    have any desired initialization parameters you desire (refer to C-Kermit
    documentation for more information).  The remote protocol must have	been
    started prior to the execution of this command.

    WARNING: until further notice, avoid suspending Kermit with	^Z.  ECU is
    totally unprepared to act as a job control process group leader.

    If switch '-a' is omitted, the received files are stored as	received;
    otherwise carriage return/linefeed pairs are converted to newlines.








    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      62



    6.63  rlog



    usage: rlog	[-srf] <str>
	   rlog	'off'


    This command controls receiver logging.  It's function is the same as
    the	interactive log	command.

    The	first form of the command enables logging. The -
    sswitchcausesthefiletobe scratched when it is opened (otherwise the	file
    is opened for append).  The	-r switch causes raw logging, else filter
    logging is performed.  The -f switch causes	the log	file to	be flushed
    each time it is written to (unbuffered I/O); this switch is	useful if
    you	are logging to a terminal or hard copy device and wish to see output
    as soon as it is produced.


    6.64  rname


    usage: rname <str>

    Normally, the %rname string	function returns the same string as the
    logical dialing directory entry.  This command allows the default value
    to be overridden with a user-selected value	(63-character maximum).

    This feature is useful in situations where one system is initially
    dialed, but	a connection is	made to	yet another system from	the dialed
    system via networking.


    6.65  rs


    usage: rs

    This command invokes the SEAlink file receive protocol.  There is no
    provision in the SEAlink protocol to convert carriage return/linefeed
    pairs to newlines, so the received files are stored	as received.  The
    remote sender must have been started prior to the execution	of this
    command.










    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      63



    6.66  rtscts

    usage: rtscts [ off	| on | no | yes	| 0..7 ]


    This command controls the RTS/CTS flow control feature of the line
    driver (which may or may not work).	 This is a very	confusing area
    though it should not be.

    If no argument is supplied,	the current setting is displayed.
    Specifying 0 or n disables the facility; 1 or y causes RTS/CTS flow
    control to be enabled.

    What the command does is to	manipulate the RTSFLOW and CTSFLOW bits	of
    the	termio c_cflag word (see termio(S)).

    SCO's sio driver before UNIX 3.2v4/ODT 2.0 does half duplex	flow
    control.  FAS does hardware	flow control based on the device magic
    number, but	if you use a device number specifying no hardware flow
    control, RTSFLOW and CTSFLOW can be	used to	specify	SCO-style flow
    control.  CRTSFL offers full duplex	line control on	3.2v4 and later	ONLY
    for	SCO's sio driver.


	  arg |	RTSFLOW	| CTSFLOW    arg | RTSFLOW | CTSFLOW | CRTSFL
	 -----+---------+---------  -----+---------+---------+--------
	  off |	  0	|   0	      0	 |   0	   |   0     |
	  on  |	  0	|   1	      1	 |   0	   |   1     |
	  no  |	  0	|   0	      2	 |   1	   |   0     |
	  yes |	  0	|   1	      3	 |   1	   |   1     |
				      4	 |   0	   |   0     |	 1

    Choice 4 only works	on SCO 3.2v4 and ODT 2.0.  As you can see, numeric
    values are masks.  If the 4	bit is present in the numeric value, it
    overrides the lower-order bits:  Specifying	7 as an	argument specifies
    CRTSFL is to be used if it is supported, otherwise RTSFLOW and CTSFLOW.

    Under System V Release 4, an TCGETX/TCSETX manipulation is performed,
    modifying the x_hflag bits as follows:

	 argument | RTSXOFF | CTSXON	argument | RTSXOFF | CTSXON
	 ---------+---------+---------	---------+---------+---------
	   off	  |   0	    |	0	  0	 |   0	   |   0
	   on	  |   0	    |	1	  1	 |   0	   |   1
	   no	  |   0	    |	0	  2	 |   1	   |   0
	   yes	  |   0	    |	1	  3	 |   1	   |   1

    Under SunOS	4.1, only CTS support is provided.  You	should read the
    termio and zs man pages.  Arguments	result in the stated manipulations
    of the termio element c_cflag:




    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      64



	 argument | CRTSCTS    argument	| CRTSCTS
	 ---------+---------  ----------+---------
	   off	  |   0		  0	|   0
	   on	  |   1		  1	|   1
	   no	  |   0
	   yes	  |   1



    Examples:

	    ifi	%baud >= 9600
	    rtscts 7 | use CRTSFL if available,	otherwise whatever



    6.67  rx


    usage: rx [-a] <str>

    This command invokes the XMODEM file receive protocol to receive file
    <str>.  If switch '-a' is omitted, the received file is stored as
    received; otherwise	carriage return/linefeed pairs are converted to
    newlines.  The remote sender must have been	started	prior to the
    execution of this command.


    6.68  ry


    usage: ry

    This command invokes the YMODEM Batch (not to be confused with XMODEM-
    1K)	protocol to receive files from a remote	system.	 The remote sender
    must have been started prior to the	execution of this command.


    6.69  rz


    usage: rz

    This command receives files	with ZMODEM/CRC-32.  The remote	sender must
    have been started prior to the execution of	this command. Automatic
    ZMODEM frame detection is NOT supported during procedure execution.








    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      65



    6.70  scrdump


    usage: scrdump [<str>]

    This command causes	the current screen contents to be stored in a file.
    If <str> is	supplied, it is	used as	a pathname.  If	<str> is not
    supplied, "~/.ecu/screen.dump".  The actions of the	interactive sdname
    command have no effect on the execution of this command.

    See	the section titled "Screen Dump" for more information.	The
    subsection titled "Multiscreen and Non-Multiscreen"	will be	of
    particular interest	when using screen dumps	in an automated	environment.


    6.71  send


    usage: send	[-n] <str>

    This command sends <str> to	the communications line.  If the '-n' switch
    is omitted,	a carriage return (0x0D) is transmitted	after <str>.  If '-
    n' is supplied, no carriage	return is transmitted.


    Examples:

	send 'ps -au'
	send -n	%chr(0x02)+'START'+%chr(0x03)



    6.72  set



    usage: set [$]i<name>=<int-expression>[, ...]
	   set [$]s<name>=<str-expression>[, ...]


    This command sets an integer or string variable to an expression.  The
    'set' verb may be omitted provided the otherwise optional '$' is
    supplied.  There are many examples of how the set statement	is performed
    throughout this document.  The examples here are to	further	clarify	the
    statement's	syntax.

    If the '=<expression>' is omitted, the value of the	variable is
    displayed (useful when debugging).	 If procedure tracing is enabled
    with the ptrace command, all variables referenced by the set command,
    whether a value is assigned	or not,	are displayed.




    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      66



    Examples:

	set i0=0
	set $s0='brown',s1='The	quick '+$s0+' fox'
	set $S0		     with no '=', displays contents
	set i0,$i1,s0='abc',s1
	$s0 = 'abc'	     legal
	set s0='abc'	     legal
	s0 = 'abc'	     illegal

    6.73  setline



    usage: setline <filename>

    This command is an exact analog of the -l command line switch.
    <filename> is used on the setup screen (if it is presented)	as the
    default filename. If you do	not edit this name, ECU	will attempt to	open
    the	line when you press End	or ^D. <filename> has the format of a
    complete pathanme in /dev or simple	tty name.

    setline may	only be	used in	_rc.ep.	 Using the setline command with	the
    baud command gives you programatic control over the	actual choice of the
    line and rate or the defaults for the setup	screen,	depending upon other
    options.

    NOTE: using	the setline command will override any command line -l
    specification.

    NOTE: For important	considerations on line choice, see the ECU manual
    sections titled "Choosing a	Dialout	Line" and "DCDwatch".


    Example:
      setline '/dev/tty1a'
      setline 'tty1a'
      setline 'cua0'

    6.74  sk


    usage: sk [-a] <str>

    This command invokes C-Kermit to send files. ECU searches the PATH list
    for	'kermit' or 'ckermit', expecting to find Columbia University C-
    Kermit version 5A(173) or later.  The file ~/.kermrc must be set up	to
    have any desired initialization parameters you desire (refer to C-Kermit
    documentation for more information).  The remote protocol must have	been
    started prior to the execution of this command.




    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      67



    WARNING: until further notice, avoid suspending Kermit with	^Z.  ECU is
    totally unprepared to act as a job control process group leader.

    If switch '-a' is supplied,	newlines are converted to carriage
    return/linefeed pairs.  If '-a' is omitted,	the file(s) are	transmitted
    without modification.

    Integer variable $i0 receives the exit status from the transfer.  If 0,
    transfer was normal.  Note:	procedure execution IS terminated by a
    SIGINT to the spawned file transfer	process.  This is different than for
    versions prior to 3.10.  If	$i0 is set to -1, the file transfer program
    did	not begin.


    6.75  ss


    usage: ss <str>

    This command invokes the SEAlink file transfer protocol to send one	or
    more files.	 There is no provision in the SEAlink protocol to convert
    newlines to	carriage return/linefeed pairs.	 so the	received files are
    stored as received.

    Integer variable $i0 receives the exit status from the transfer. If	0,
    transfer was normal.  Note:	procedure execution IS terminated by a
    SIGINT to the spawned file transfer	process.  This is different than for
    versions prior to 3.10.  If	$i0 is set to -1, the file transfer program
    did	not begin.


    6.76  sx


    usage: sx [-ak[l]] [<label-str>] <filename-str>

    This command invokes the XMODEM or XMODEM-1K file transfer protocol	to
    send a file.  If '-k' is supplied, XMODEM-1K is used, else XMODEM.	If
    switch '-a'	is supplied, newlines are converted to carriage
    return/linefeed pairs.  If '-a' is omitted,	the file(s) are	transmitted
    without modification.  If '-l' is supplied,	then <label-str> specifies a
    string to display on the bottom of the file	transfer screen.  If '-l' is
    omitted, then <label_str> must also	be omitted.

    Integer variable $i0 receives the exit status from the transfer. If	0,
    transfer was normal.  Note:	procedure execution IS terminated by a
    SIGINT to the spawned file transfer	process.  This is different than for
    versions prior to 3.10.  If	$i0 is set to -1, the file transfer program
    did	not begin.





    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      68



    Examples:

	sx -al 'sending	log file' '/tmp/log.file'
	sx -



    6.77  sy


    usage: sy [-a[l]] [<label-str>] <filelist-str>

    This command invokes the YMODEM Batch (not to be confused with XMODEM-
    1K)	file transfer protocol to send one or more files.

    If switch '-a' is supplied,	newlines are converted to carriage
    return/linefeed pairs.  If '-a' is omitted,	the file(s) are	transmitted
    without modification.  If '-l' is supplied,	then <label-str> specifies a
    string to display on the bottom of the file	transfer screen.  If '-l' is
    omitted, then <label_str> must also	be omitted.

    Integer variable $i0 receives the exit status from the transfer. If	0,
    transfer was normal.  Note:	procedure execution IS terminated by a
    SIGINT to the spawned file transfer	process.  This is different than for
    versions prior to 3.10.  If	$i0 is set to -1, the file transfer program
    did	not begin.


    6.78  system


    usage: system [-ls]	<cmdstr>

    <cmdstr> is	passed to the Bourne shell.

    If switch '-l', is supplied, the attached communications line becomes
    the	stdin and stdout for the command.

    If switch '-s', is supplied, all ECU file descriptors remain open.	The
    -s option is important to include if you pass the ECU line file
    descriptor to another process.

    Integer variable $i0 is set	to the spawned process'	exit status if the
    process exits "normally", or 0x100 if the process is killed, dumps core
    or interrupted.

    Note:  procedure execution is NOT terminated by a SIGINT to	the spawned
    process.  It is the	responsibility of the procedure	to process the exit
    status returned in $i0.  If	$i0 is set to -1, the file transfer program
    did	not begin.




    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      69



    Examples:

	    $s2	= '/tmp/ecu'+%itos(%pid,05)
	system ' fgrep foo bar > '+$s2

	system -s '/etc/NBSsetclk -i '+%itos(%conn)



    6.79  sz


    usage: sz [-anf[l]r] [<label-str>] <filelist-str>

    This command sends files using ZMODEM/CRC-32.  The remote protocol must
    have been started prior to the execution of	this command unless the
    remote has automatic ZMODEM	frame detection.

    Switch '-a'	specifies an ASCII transfer; the default is binary.

    Switch '-f'	 causes	the full pathname of each file to be sent;
    otherwise, the simple filename is transmitted.

    Switch '-l'	with the <label-str> argument specifies	a string to display
    on the bottom of the file transfer screen.	If '-l'	is omitted, then
    <label_str>	must also be omitted.

    Switch '-n'	causes the receiver to accept files with do not	already
    exist at the remote	system or which	have older times of  last access
    that at the	sending	system.	 Not all remote	protocol software will
    accept or obey this	option.

    Switch '-r'	causes an interrupted file transfer to be resumed.  if the
    remote receiver supports the ZMODEM	protocol feature.

    Integer variable $i0 receives the exit status from the transfer. If	0,
    transfer was normal.  Other	$i0 values possible:

      1-126:   count of	files not transmitted (see ~/.ecu/log)
      127:     127 or more files not transmitted (see ~/.ecu/log)

    Other ecusz	error codes are	shown here for refernce, but they are
    converted by ECU to	printed	messages and result in procedure
    termination.

      128-192: process terminated with signal==code-128
	       signal 0	== program logic error
      253:     could not open any files
      254:     protocol	failed (bad line conditions,brain dead remote)
      255:     usage




    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      70



    Note: procedure execution IS terminated by a SIGINT	to the spawned file
    transfer process.  This is different than for versions prior to 3.10.
    If $i0 is set to -1, the file transfer program did not begin.


    6.80  vidcolor


    usage: vidcolor <type> <fcolor> [<bcolor>]

    This command allows	control	over the internal color	choices	ECU makes.
    <type> must	be one of the following:


	 normal	  - normal video color
	 reverse  - reverse video color
	 notify	  - color used for low key notifications such as
		    "[interactive mode]" and "[procedure finished]"
	 success  - color used for modem CONNECT messages and other
		    "success" notifications
	 alert	  - color used to alert	user for warning or caution
		    purposes
	 error	  - color used to display error	status or messages


    <fcolor> and <bcolor> are color names as described in the description of
    the	color command. <fcolor>	choses the foreground color and	must be
    supplied.  <bcolor>	choses the background color and	is optional; if	not
    supplied, the background color is black.

    Note: The vidcolor normal and reverse options are analogs of the color
    and	color -r command.


    Examples:  (showing	ECU default internal color list)

	vidcolor normal	lt_green
	vidcolor reverse red white
	vidcolor notify	gray
	vidcolor success lt_green
	vidcolor alert yellow
	vidcolor error red



    6.81  vidnorm


    usage: vidnorm

    This command causes	later screen output to appear in the normal, as



    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      71



    opposed to reverse video mode.  The	color command forces normal video
    mode.


    6.82  vidrev


    usage: vidrev

    This command causes	later screen output to appear in the reverse, as
    opposed to normal video mode.  The color command forces normal video
    mode.


    6.83  whilei



    usage: whilei <int>	<rel-op> <int> <statement>
	   whilei <int>	<rel-op> <int>
	       <statement>
	   whilei <int>	<rel-op> <int>
	   {
	       any kind	or number of statements
	       (labels are not allowed inside braces)
	   }


    This command executes a loop one or	more statements	based on a test	of
    two	integer	quantities.  The <rel-op> argument is descibed in a earlier
    subsection titled "Relational Operators." See the description of the
    break, continue, and else commmands	and many other examples	throughout
    the	document, for examples of how the command is used.

    6.84  whiles



    usage: whiles <str>	<rel-op> <str> <statement>
	   whiles <int>	<rel-op> <int>
	       <statement>
	   whiles <int>	<rel-op> <int>
	   {
	       any kind	or number of statements
	       (labels are not allowed inside braces)
	   }


    This command executes a loop of one	or more	statements based on a test
    of two string values. The <rel-op> argument	is descibed in a earlier
    subsection titled "Relational Operators." See the description of the



    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      72



    break, continue, and else commmands	and many other examples	throughout
    the	document, for examples of how the command is used.

    6.85  xon



    usage: xon <arg>
    where <arg>	is on	 input and output flow control
		   off	 no flow control
		   in	 input flow control
		   out	 output	flow control


    This command enables or disables xon/xoff flow control.


    Examples:

	hangup
	dial 'mysys'
	ifi %conn != 0 parity none;xon on
































    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      73



    7.	Special	Procedures


    ECU	provides for special "hook" procedures to be executed at certain
    times.  Their use is encouraged, but you must take precautions not to
    excecute any unreasoable commands in them, for the are rather "raw"
    hooks and it is easily possible to confuse ECU by performing illogical
    operations in them.	Judicious use can, however, be quite productive.

    They are searched for in the same manner as	any other procedure, so	you
    can	have a customised version of them in a working directory and a
    default in your ~/.ecu subdirectory.  No error is reported if they are
    not	found.


    7.1	 _rc.ep


    Afer ECU is	initialized, but before	it presents the	setup screen or
    executes a -p initial procedure, procedure '_rc' is	executed with no
    arguments.	(It is named in	the tradition of /etc/rc, .mailrc, etc..)
    This procedure can be used to customize the	ecu environment	prior to
    beginning the usual	operation.  This is not	a place	to do any dialing or
    long-lived operations, nor is it possible to bypass	the setup screen:
    for	this, use the -p initial procedure.

    The	%getenv() function may be useful in here (Am I running on an xterm?
    Do I want to change	the prompt string from the default environment
    variable $ECUPROMPT?).

    Procedure commands likely to be of interest	here:

	   autorz
	 * baud
	   color
	   dcdwatch
	 * duplex
	   prompt
	   rtscts
	 * setline


    Commands marked with an asterisk affect the	initial	(default) values
    presented on the setup screen.

    If _rc.ep returns a	non-zero status	or fails (due to syntax	or other
    error), ecu	terminates immediately.







    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      74



    7.2	 _connect.ep


    This procedure is executed after every connection success after the
    CONNECT message ("result code") is printed.	 It is passed one argument,
    the	"result	code" string generated by the dialer function (e.g.,
    "CONNECT 19200").

    You	may use	%rname and other functions and features	to customize this
    function based on the particular system just reached.  Note	that integer
    variable $i0 and string variable $s0 set zero prior	to executing the
    function.  This function may modify	the behavior of	coorperating dialer
    functions by setting the value of numbered string or integer variables.
    In particular, the dialer function will inherit the	values of $i0 and
    $s0	when this special function terminates.	Be careful of what you do in
    here since MANY ecu	procedure commands affect $i0 and $s0 as a side
    effect of their operation.	Even if	you know what you do in	_connect.ep
    does not modify $i0	or $s0,	use of the preservation	technique shown	in
    the	example	below may save you headaches if	you add	to the function	in
    the	future (long after you have forgotten this pedantic admonition).

    If this procedure fails (abnormal procedure	termination or non-zero
    return code), ECU hangs up on the line and proceeds	as if the connection
    failed.






























    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      75



    Example:
    #+------------------------------------------------------------------
    #  _connect.ep - post-CONNECT special "hook" procedure
    #-------------------------------------------------------------------
    #+:EDITS:*/
    #:09-10-1992-13:58-wht@n4hgf-ECU release 3.20
    #:08-22-1992-15:38-wht@n4hgf-ECU release 3.20 BETA
    #:07-13-1991-14:47-wht@n4hgf-creation

      $iv0_save	= $i0  # it is a VERY good idea	to save	the dialer
      $sv0_save	= $s0  # function return status
		       # since gobs of functions and commands modify $i0
		       # and/or	$s0 as a side effect of	their operation

      $s30 = '_connect '+%rname+' ('+%argv(1)+')'
      echo $s30	       # this still will also live to be visible by
		       # the dialer function

      ifi %baud	> 2400
      {
	 xon	off    # turn XON/XOFF off first, then ...
	 rtscts	on     # turn on RTS/CTS
      }
      else
      {
	 rtscts	off    # turn off RTS/CTS, then	...
	 xon	on     # turn XON/XOFF on
      }

      $i0 = $iv0_save  # restore dialer	return status
      $s0 = $sv0_save



    7.3	 _connfail.ep


    This procedure is executed after every connection failure after the
    failure message ("result code") is printed.	 It is passed two arguments,
    the	logical	system name (the dial directory	entry name or the phone
    number) and	the "result code" string generated by the dialer function
    (e.g., "BUSY").  The function is called after $i0 has been set to 1	and
    $s0	has been set to	the result code.  This function	may modify the
    behavior of	coorperating dialer functions by setting the value of
    numbered string or integer variables.  In particular, the dialer
    function will inherit the values of	$i0 and	$s0 when this special
    function terminates.  Be careful of	what you do in here since MANY ecu
    procedure commands affect $i0 and/or $s0 as	a side effect of their
    operation.	See _connect.ep	above for further screams and moans.

    ]If	you get	very involved with using this procedure, you'll	sooner or



    Public Domain by wht@n4hgf				 9/10/92







    ECU	Procedure Language				      76



    later run into some	undocumented $so values.  You'll have to take a	look
    at ecuDCE.c	and hdbintf.c for an authoritative reference, but perhaps
    you	can get	along by knowing that result codes with	an exclamation point
    as their first character are generated by ECU.

    ECU	ignores	any failure (abnormal procedure	termination or non-zero
    return code) resulting from	the execution of this procedure.


    7.4	 _hangup.ep


    This procedure is executed after every connection termination.  It is
    passed one argument, a string representation of the	number of seconds
    you	were connected.	 You may use %rname and	other functions	and features
    to customize this function based on	the particular system just reached.
    ECU	ignores	any error returned by the procedure.  ECU ignores any
    failure (abnormal procedure	termination or non-zero	return code)
    resulting from the execution of this procedure.



































    Public Domain by wht@n4hgf				 9/10/92











				    CONTENTS


    1.	Introduction........................................   2

    2.	Line Syntax (Labels, Commands and Comments).........   3

    3.	Arguments...........................................   4
	3.1   Switches......................................   4
	3.2   Alphabetic Tokens.............................   4
	3.3   Integers......................................   4
	      3.3.1   Constants.............................   4
	      3.3.2   Variables.............................   5
	      3.3.3   Functions.............................   5
	      3.3.4   Expressions...........................   5
	      3.3.5   Relational Operators..................   6
	3.4   Strings.......................................   6
	      3.4.1   Constants.............................   6
	      3.4.2   Variables.............................   7
	      3.4.3   Functions.............................   7
	      3.4.4   Expressions...........................   7
	      3.4.5   Relational Operators..................   7

    4.	Integer	Functions...................................   9
	4.1   %argc.........................................   9
	4.2   %baud.........................................   9
	4.3   %colors.......................................   9
	4.4   %cols.........................................  10
	4.5   %conn.........................................  11
	4.6   %curx.........................................  11
	4.7   %cury.........................................  11
	4.8   %csec.........................................  11
	4.9   %ctoi.........................................  11
	4.10  %esecs........................................  11
	4.11  %fatime.......................................  12
	4.12  %fmode........................................  12
	4.13  %fmtime.......................................  12
	4.14  %fmode........................................  13
	4.15  %ftell........................................  13
	4.16  %instr........................................  13
	4.17  %ischr........................................  14
	4.18  %isdir........................................  14
	4.19  %isreg........................................  15
	4.20  %len..........................................  15
	4.21  %lgetc........................................  16
	4.22  %lines........................................  16
	4.23  %nice.........................................  16
	4.24  %pid..........................................  16
	4.25  %match........................................  16
	4.26  %mhack........................................  17
	4.27  %rchr.........................................  17



			       - i -











	4.28  %rchrc........................................  17
	4.29  %rinstr.......................................  18
	4.30  %shmid........................................  18
	4.31  %stoi.........................................  18
	4.32  %uid..........................................  19
	4.33  %xchr.........................................  19
	4.34  %xchrc........................................  19

    5.	String Functions....................................  20
	5.1   %argv.........................................  20
	5.2   %basename.....................................  21
	5.3   %cgetc........................................  21
	5.4   %cgets........................................  21
	5.5   %chr..........................................  21
	5.6   %date.........................................  22
	5.7   %datez........................................  22
	5.8   %day..........................................  22
	5.9   %dayz.........................................  22
	5.10  %dir..........................................  22
	5.11  %dirpart......................................  23
	5.12  %edate........................................  23
	5.13  %envvar.......................................  23
	5.14  %errstr.......................................  24
	5.15  %etime........................................  24
	5.16  %filepart.....................................  24
	5.17  %fmodestr.....................................  25
	5.18  %itos.........................................  25
	5.19  %left.........................................  26
	5.20  %line.........................................  26
	5.21  %logname......................................  27
	5.22  %mid..........................................  27
	5.23  %month........................................  27
	5.24  %rdesc........................................  27
	5.25  %right........................................  28
	5.26  %rname........................................  28
	5.27  %rtelno.......................................  28
	5.28  %time.........................................  28
	5.29  %times........................................  29
	5.30  %timez........................................  29
	5.31  %timezs.......................................  29
	5.32  %tty..........................................  29
	5.33  %uname........................................  29

    6.	Commands............................................  30
	6.1   autorz........................................  30
	6.2   baud..........................................  30
	6.3   break.........................................  30
	6.4   cd............................................  31
	6.5   clrx..........................................  31
	6.6   cls...........................................  32
	6.7   color.........................................  32



			       - ii -











	6.8   continue......................................  32
	6.9   cursor........................................  33
	6.10  dcdwatch......................................  34
	6.11  delline.......................................  34
	6.12  dial..........................................  34
	6.13  do............................................  36
	6.14  duplex........................................  36
	6.15  echo..........................................  37
	6.16  eeol..........................................  37
	6.17  else..........................................  37
	6.18  exec..........................................  38
	6.19  exit..........................................  39
	6.20  expresp.......................................  40
	6.21  fchmod........................................  42
	6.22  fclose........................................  43
	6.23  fdel..........................................  43
	6.24  fgetc.........................................  43
	6.25  fgets.........................................  44
	6.26  fkey..........................................  44
	6.27  fkmap.........................................  44
	6.28  flush.........................................  45
	6.29  fopen.........................................  45
	6.30  fputc.........................................  46
	6.31  fputs.........................................  47
	6.32  fseek.........................................  47
	6.33  getf..........................................  47
	6.34  gosub.........................................  48
	6.35  gosubb........................................  49
	6.36  goto..........................................  49
	6.37  gotob.........................................  50
	6.38  hangup........................................  50
	6.39  hexdump.......................................  50
	6.40  home..........................................  51
	6.41  icolor........................................  51
	6.42  ifi...........................................  52
	6.43  ifs...........................................  52
	6.44  insline.......................................  52
	6.45  lbreak........................................  53
	6.46  lgets.........................................  53
	6.47  logevent......................................  53
	6.48  lookfor.......................................  54
	6.49  mkvar.........................................  54
	      6.49.1  Variable Names........................  55
	      6.49.2  Variable Life and	Scope...............  55
	      6.49.3  String Variable Size..................  55
	6.50  nap...........................................  56
	6.51  nice..........................................  56
	6.52  parity........................................  56
	6.53  pclose........................................  57
	6.54  plog..........................................  57
	6.55  popd..........................................  58



			      -	iii -











	6.56  popen.........................................  58
	6.57  prompt........................................  59
	6.58  ptrace........................................  59
	6.59  pushd.........................................  60
	6.60  putf..........................................  60
	6.61  return........................................  60
	6.62  rk............................................  61
	6.63  rlog..........................................  62
	6.64  rname.........................................  62
	6.65  rs............................................  62
	6.66  rtscts........................................  63
	6.67  rx............................................  64
	6.68  ry............................................  64
	6.69  rz............................................  64
	6.70  scrdump.......................................  65
	6.71  send..........................................  65
	6.72  set...........................................  65
	6.73  setline.......................................  66
	6.74  sk............................................  66
	6.75  ss............................................  67
	6.76  sx............................................  67
	6.77  sy............................................  68
	6.78  system........................................  68
	6.79  sz............................................  69
	6.80  vidcolor......................................  70
	6.81  vidnorm.......................................  70
	6.82  vidrev........................................  71
	6.83  whilei........................................  71
	6.84  whiles........................................  71
	6.85  xon...........................................  72

    7.	Special	Procedures..................................  73
	7.1   _rc.ep........................................  73
	7.2   _connect.ep...................................  74
	7.3   _connfail.ep..................................  75
	7.4   _hangup.ep....................................  76


















			       - iv -




