






				      ECU

			    (Extended Call Utility)






			    Research and Engineering
		      Asynchronous Communications Package
		      for SCO UNIX 3.2 and XENIX System	V,
			   ISC 386/ix 2.2 (or later),
		       SunOS 4.1, ISC System V Release 4
			  and ESIX System V Release 4






		Warren H. Tucker, III <wht@n4hgf.Mt-Park.GA.US>



			     Technical Description
				 Revision 3.20
				     9/7/92






    NOTE: Many sections	of the manual are likely to be inaccurate or
    obsolete at	any given time until the writer	get lots of free time.	Much
    of it was written when the program was supported only on SCO XENIX and
    UNIX.  Usually, I took the extra time to throw -something- in the manual
    and	online help.  I	did not	always go back and indicate which features
    are	not supported by a later` port.

    Many of the	features of ECU	were written under extreme time	pressure.
    While the program code is usually reliable,	the manual is a	joke from
    many points	of view, organization, consistency, content -- you name	it.
    You'll see comma splices, incomplete sentences or even incorrect
    information.  You may find the correct information in a README or in
    RELEASENOTES, or in	another	part of	the manual.  Of	course,	there is the
    code!  If you find information that	seems incorrect, PLEASE	mail a
    report to the author.





    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				       2



    1.	Introduction


    ECU	(Extended Call Utility)	is a personal and research communications
    program originally written for users of SCO	UNIX V.3.2/386 and XENIX V
    on 80286 and 80386 systems.	 Support for other systems has been added
    and	further	porting	is possible with "minor" effort	to other systems
    based on or	similar	to UNIX	System V.  This	preliminary document
    describes ECU functionality	and implementation from	a technical point of
    view and provides at least rudimentary documentation for its features
    and	commands.

    ECU	provides the classic terminal communications facility of passing
    keyboard data to a serial line and incoming	data to	the computer video
    display.  In addition, a dialing directory,	a function key mapping
    feature, and session logging are available.

    A very flexible procedure (script) language	is also	incorporated to
    automate many communications tasks.	 In addition to	augmenting
    interactive	tasks, by using	shell scripts and ECU procedures, ECU can
    perform batch-style	communications sessions	in an entirely "unattended"
    fashion.  Because of limitations of	my nroff program, the procedure
    language is	described in a separate	document.

    ECU	presents to the	host a flexible	"ANSI" terminal	type, accepting	any
    valid video	control	sequences from MS-DOS or SCO documentation as of
    late 1990.	It also	fares well, though imperfectly,	with Sun and VT-100
    in-band video control sequences.  Standards	are great: everybody should
    have one, especially if they call it "ANSI." For more information, refer
    to the section below titled	"ANSI Filter."

    The	program	supports almost	any local terminal (console) which can be
    described in a termcap database entry.  For	more information, refer	to
    "Supported Terminals."

    ECU	supports numerous file transfer	protocols: as of this writing,
    XMODEM, XMODEM/CRC,	XMODEM-1K, YMODEM/CRC Batch, ZMODEM/CRC-16,
    ZMODEM/CRC-32, Kermit and SEAlink are supported.  For more information,
    refer to the sections describing the individual interactive	and
    procedure file transfer commands.

    This document is better than that supplied with ECU	2.0, but is still
    rough in many places.  It attempts to get across to	the inquiring mind
    how	ECU works.  In places, an understanding	of the UNIX programming
    model, UNIX, XENIX and UUCP	constructs and asynchronous communications
    techniques is assumed.  In other places, the document goes into tedious
    detail about the simplest of concepts.  A great deal of attention has
    been placed	in accurate and	robust coding of the program.  Perhaps,	time
    permitting,	one day	I can say the same for this document.





    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				       3



    2.	Basic Organization


    ECU	forks to run as	two separate processes,	a transmitter (XMTR) and a
    receiver (RCVR).  The two processes	communicate via	signals	and a System
    V shared memory segment.  XMTR controls RCVR and terminates	it under
    certain circumstances, called here auxiliary operations.  After an
    auxiliary operation	completes, XMTR	forks again to recreate	RCVR.


    2.1	 Transmitter Process (XMTR)


    XMTR accepts user input from the computer keyboard;	input is recognized
    as belonging to one	of two types: 1) transmit data and 2) ECU commands.
    Keyboard input is passed to	the serial line	driver until an	ECU command
    is detected.  Commands are prefixed	with a HOME key	which causes ECU to
    accept keyboard data up to the next	ENTER key as command text.  After a
    command has	been processed,	keyed data is again routed to the serial
    line.


    2.1.1  Keyboard Interface

    The	keyboard driver	is set into the	raw mode.  XMTR	reads characters one
    at a time from the driver.	Normally, characters read from the keyboard
    are	passed directly	to the serial line driver.  The	ASCII ESC ("escape")
    character is handled as a special case.  When a function key is pressed,
    the	keyboard generates to XMTR an ESC character, followed by more
    characters describing which	function key has been pressed.	Pressing the
    ESC	key also causes	XMTR to	see an ESC character, but with no subsequent
    function key "suffix".

    When an ESC	character is read, XMTR	delays transmission of the character
    to the line	for a short period to determine	whether	the ESC	key has	been
    pressed or a function key has been pressed.	 If no "suffix"	is detected,
    the	ESC is passed to the line, having suffered an insignificant delay
    given human	typing speeds.

    If a function key "suffix" is detected, the	function key type is
    decoded.  The HOME key indicates an	ECU command follows.  Any other
    function key is passed to the function key mapping feature (described
    later).


    2.1.2  ECU Command Assembly

    After HOME has been	pressed, XMTR presents a reverse video prompt on the
    display, indicating	its readiness to accept	a command.  During input,
    the	command	may be edited using the	same control keys specified with
    stty(C).  Additonal	editing	using the left and right arrow keys and	the



    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				       4



    Ins(ert) key are usually available.	 Command input may be aborted by
    pressing ESC.  When	a command string has been assembled, it	is passed to
    the	command	processor, which breaks	the command arguments into a token
    array similar to the argc/argv array.  When	the command handler returns,
    XMTR returns to its	normal mode of copying keyboard	data to	the serial
    line.

    Further information	on XMTR	command	line processing	may be found in
    later sections titled Line Editing and Interactive Command History.


    2.1.3  Function Key	Mapping

    While in tty-to-line mode, function	keys other than	HOME are available
    to be mapped to transmit short keystroke sequences on a connection by
    connection basis.  Under control of	the dialing command ("Dial"
    described below)  or the function key control command ("FK"), predefined
    function key maps may be loaded.

    Function keys which	may be mapped are F1 through F12, PgUp,	PgDn, End,
    Ins, Del, and the cursor control keys.

    The	unshifted keypad '5' key is permanently	mapped to produce a screen
    snapshot when it is	pressed	and XMTR is reading from the keyboard.

    The	BackTab	(shift Tab) key	is permanently mapped to a screen redisplay
    feature.


    2.1.4  Auxiliary Operation Control

    Certain commands cause ECU to perform what is called an auxiliary
    operation, requiring temporary termination of the RCVR process.  Such
    operations are not as useful with cu(C), because cu	does NOT kill its
    receiver process at	any time.  As a	result,	it impossible to run a
    modern file	transfer protocol since	the cu receiver	process	eats some of
    the	characters sent	by the remote protocol program.

    There are two types	of auxiliary operations: 1) internal interactive
    command or procedure execution and 2) external program execution.
    Certain internal commands require tight control over the serial line.
    For	instance, the dial command requires transmitting modem command
    strings and	receiving modem	response codes.	 Such functions	are best
    accomplished by single-process control of the line.	 External program
    execution is of two	kinds, file transfer invocation	and local
    shell/command execution.

    The	RCVR process is	terminated in any of these cases either	to avoid the
    RCVR swallowing characters intended	for other targets (the modem handler
    in XMTR or the file	transfer protocol) or to avoid having remote data
    interspersed with the output of local programs.



    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				       5



    2.2	 Receiver Process (RCVR)


    The	receiver process reads the incoming serial data	stream and passes it
    to the user	terminal driver	through	a filter which scans for events	such
    as the occurrence of ASCII BEL (bell) characters or	terminal control
    sequences.	RCVR also handles the session logging and ANSI filter
    functions.


    2.2.1  ANSI	Filter

    Since the term "ANSI" is used to describe many variations on the ANSI
    X3.64 recommendations for terminal control (read "IBM pseudo-ANSI"), the
    ECU	receiver process has an	"ANSI filter" which attempts to	translate
    incompatible (read "MSDOS")	ANSI-like control sequences to sequences
    acceptable to the console terminal in use.	This includes support for
    the	MS-DOS "save cursor" and "restore cursor" sequences.  More
    information	may be found later in "Supported Terminals."


    2.2.2  Session Logging

    When directed by the user, the RCVR	process	logs incoming serial data to
    a file named on the	log command line.  The default operation is to
    filter unprintable characters (other than TAB and NL) from the log,	but
    raw	logging	is available with a command option.  In	a like manner, the
    default is for appending to	an existing file, but a	command	option may
    specify scratching any previous contents.

    Log	files receive header lines each	time the file is opened, stating the
    logical system name, the telephone number and the date/time.






















    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				       6



    3.	Features

    3.1	 Supported Terminals


    ECU	supports many terminals	with geometries	between	20 and 43 lines,
    inclusive.	The column width must be 80.  The termcap entry	for a
    console (user tty rather than the line) MUST contain a valid entry for
    the	database entries listed	below.

    ECU	does not attempt to support terminal emulation in the classic sense
    of the word.  It presents to the remote host an "ANSI-like"	terminal
    type as described earlier in the introduction and in the section titled
    "ANSI Filter." However, it does support, with limitations, any LOCAL
    terminal (console) for which a valid termcap description exists. You MAY
    be able to use ECU with a remote terminal (calling into UNIX/XENIX over
    a network or modem), but you may get unfavorable results with function
    key	usage if your modem is a "packetizing" type, such as a Telebit or if
    ethernet or	other networking chops up your keystroke sequences.  ECU
    allows approximately 100 milliseconds after	receiving an ASCII ESC
    character for later	characters of a	function key sequence to arrive.  If
    at least one character of the sequence has not been	received in that
    time, ECU treats the key as	an ESCape, not a function key.	This typical
    problem of detecting ESC vs. function key is unfortunate, but we must
    live with it until paradigms change	(say, in about 2010?).

    The	termcap	entry for a console MUST contain a valid entry for the
    following database entries:


    cl	    clear screen
    kl	    cursor left
    kr	    cursor right
    dc	    delete character
    dl	    delete line
    cd	    clear to end of display
    ce	    clear to end of line
    ic	    insert character
    al	    insert line	("add" a "line")
    cm	    cursor motion
    so	    stand out (terminal	specific attention getter)
    se	    stand end


    The	above sequences	MUST be	present, valid and reasonably efficient.
    ECU	does not use curses during it's	primary	mode of	operation (keyboard
    send-receive). Unlike curses, ECU makes no attempt to emulate missing
    terminal functionality.  Failure to	provide	valid entries will result in
    strange behavior with no warning.

    Note that the formal termcap description of	"kl" and "kr" state these



    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				       7



    are	sequences generated by the terminal keyboard, but ECU expects that
    these sequences also cause the desired effects when	sent to	the screen.

    Additionally, the following, optional, sequences will be used if they
    are	detected.


    mb	    bold on ("XENIX" extension)
    me	    bold off ("XENIX" extension)
    us	    underscrore	on
    ue	    underscrore	off
    vb	    visual bell


    On SCO, termcap terminal contrtol is used.	Other versions use terminfo.
    A future SCO version of ECU	may use	terminfo instead of termcap.
    Problems with terminfo prevent its use at the present time.	 In
    addition, early versions of	XENIX do not support terminfo.

    On SCO multiscreens, SCO "extensions" to "ANSI" are	supported as
    described below in "Multiscreen Local Terminals."


    3.2	 Host Video Control Sequences



    3.2.1  All Local Consoles (Terminals)

    The	following sequences are	recieved over the line by ECU and properly
    interpreted	for all	local terminal types (multiscreen, rlogin/xterm
    pseudotty, serial).






















    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				       8



    Sequence  |	Description
    ----------+-------------------------------
    ESC	[ @   |	ICH
    ESC	[ A   |	CUU
    ESC	[ B   |	CUD
    ESC	[ C   |	CUF
    ESC	[ D   |	CUB
    ESC	[ E   |	CNL	  See ANSI X3.64,
    ESC	[ F   |	CPL	  screen(HW) and/or
    ESC	[ H   |	CUP	  MS-DOS Technical
    ESC	[ J   |	ED	  Reference Manual
    ESC	[ K   |	EL
    ESC	[ L   |	IL
    ESC	[ M   |	DL
    ESC	[ P   |	DCH
    ESC	[ S   |	SU
    ESC	[ T   |	SD
    ESC	[ X   |	ECH
    ESC	[ `   |	HPA
    ESC	[ a   |	HPR
    ESC	[ d   |	VPA
    ESC	[ e   |	VPR
    ESC	[ f   |	HVP
    ESC	[ ? m |	SGR
    ESC	[ n   |	DSR
    ESC	[ s   |	save cursor MS-DOSism
    ESC	[ u   |	restore	cursor MS-DOSism

    SGR	Sequences for ALL TERMINALS
    Sequence  |	Description   |	 Maps to termcap
    ----------+---------------+-------------------------------
    ESC	[ 0 m |	normal	      |	 "se"+"me"+"ue"
    ESC	[ 1 m |	bold	      |	 "so"
    ESC	[ 4 m |	underscore    |	 "us"
    ESC	[ 5 m |	blink	      |	 "mb" (XENIX extension)
    ESC	[ 7 m |	reverse	video |	 "so"



    3.2.2  Multiscreen Local Terminals

    In addition	to the above, if you are operating from	an SCO color
    multiscreen, additional (SCO and MS-DOS/ANSI.SYS) sequences	are
    supported (see screen(HW)):










    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				       9



    Additional Multiscreen SGR Sequences
    Sequence	| Description  (no termcap mapping)
    ------------+-----------------------------------------------
    ESC	[ 8 m	| non-display
    ESC	[ 1 0 m	| select primary font
    ESC	[ 1 1 m	| select first alternate font (0x00-0x1F)
    ESC	[ 1 2 m	| select second	alternate font (0x80-0xFF)
    ESC	[ 3 0 m	| black	foreground
    ESC	[ 3 1 m	| red foreground
    ESC	[ 3 2 m	| green	foreground
    ESC	[ 3 3 m	| brown	foreground
    ESC	[ 3 4 m	| blue foreground
    ESC	[ 3 5 m	| magenta foreground
    ESC	[ 3 6 m	| cyan foreground
    ESC	[ 3 7 m	| white	foreground
    ESC	[ 3 8 m	| enables underline option
    ESC	[ 3 9 m	| disables underline option
    ESC	[ 4 0 m	| black	background
    ESC	[ 4 1 m	| red background
    ESC	[ 4 2 m	| green	background
    ESC	[ 4 3 m	| brown	background
    ESC	[ 4 4 m	| blue background
    ESC	[ 4 5 m	| magenta background
    ESC	[ 4 6 m	| cyan background
    ESC	[ 4 7 m	| white	background



    ECU	also does it's best to interpret MS-DOS	"SGR gaggles" such as

	 ESC [ 5 ; 3 4 ; 4 7 m

    which means	"set the terminal to white background with blue	blinking
    foreground."


    3.2.3  Character Mapping

    Most versions of ECU running on an AT style	machine	attempt	to use the
    ruling characters in the video display adapter's ROM per:














    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      10



    Mapped Characters (see pc_scr.h):
    Hex	 | Description
    -----+---------------------------
    0xDA | top left single rule
    0xBF | top right single rule
    0xC0 | bottom left single rule
    0xD9 | bottom right	single rule
    0xC3 | left	hand T
    0xB4 | right hand T
    0xB3 | vertical rule
    0xC4 | horizontal rule

    On non-AT machines (or in such environments	as X11), the PC	ROM single
    ruling characters from the following table are mapped after	the fashion
    of:

	   .-----+--------.
	   |	 |	  |
	   |	 +--------+
	   |	 |	  |
	   +-----+	  |
	   |	 |	  |
	   `-----+--------'


    (Due to laziness on	the part of the	author,	double ruling characters
    will appear	as random druk,	unless your terminal has joined	the Church
    of the True-Blue ROM.  One day an X	version	of this	program	may appear
    and	you can	choose to no longer accomplish real work, but may spend	your
    days editing 42Kb resource files which will	give you TAC, Total Anal
    Control, over all this.)


    3.3	 Function Key Mapping (Recognition)


    (This section reflects the changes in keyboard management made in
    version 3.20.)

    ECU	recognizes 23 function keys as having special significance to its
    operation.	They are:













    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      11



	 Name	   Description
	 --------  ------------
	 F1	   F1
	 F2	   F2
	 F3	   F3
	 F4	   F4
	 F5	   F5
	 F6	   F6
	 F7	   F7
	 F8	   F8
	 F9	   F9
	 F10	   F10
	 F11	   F11
	 F12	   F12
	 Home	   Home
	 End	   End
	 PgUp	   Page	up
	 PgDn	   Page	down
	 CUU	   Up arrow
	 CUD	   Down	arrow
	 CUL	   Left	arrow
	 CUR	   Right arrow
	 CU5	   "Cursor 5"
	 Ins	   Insert
	 BkTab	   Back	Tab


    ECU	matches	a function key sequence	to an internal function	key
    representation by testing all keystroke sequences against an internal
    table loaded at the	beginning of execution from the	file
    ~/.ecu/funckeymap.	A default funckeymap file placed in the	ECU library
    directory (normally	/usr/local/lib/ecu) by the software installation
    process. If	there is no funckeys in	the user's home	directory, the
    default file is used.

    NOTE that supported	terminals MUST employ function keys which generate
    sequences less than	32 characters in length.

    X11	xterms and X terminals usually require special attention with
    VT100.Translations overrides.  Sometimes an	xmodmap	must also be
    employed.  Experimentation is the best teacher, but	the supplied
    funckeymap file and	various	READMEs	offer some hints.  In particular,
    README.KEYBRD contains information that is kept current.

    Several predefined entries are supplied with the program distribution in
    models/funckeymap.	If you have a terminal or console with a keyboard
    not	already	in this	file, you must construct one using the terminal's
    reference manual or	by direct discovery (typing the	key and	empricially
    noting its generated sequence).  The program kbdtest3 (the source is
    provided in	the distribution) can assist you in building funckeymap
    entries.  certain keys are pressed.	 kbdtest.c is a	more primitive



    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      12



    version of the same	program.

    Normally, the TERM environment variable is used to determine the
    funckeymap entry to	be used.  Sometimes, the TERM variable is not
    adequate for identifying your keyboard arrangement.	 For instance,
    suppose you	use an xterm on	the console at times and an X terminal at
    other times.  The choice of	function keys and the character	sequences
    they emit are not likely to	match.	Rather than make herculean efforts
    with xmodmap and translations, you can define two different	funckeymap
    entries, say "xterm-sco" and "xterm-ncd".  The environment variable
    ECUFUNCKEY,	if found, overrides the	TERM variable for funckeymap
    keyboard management	only. TERM is always used for identifying the
    display.  Thus, you	can set	TERM to	"xterm"	and ECUFUNCKEY to "xterm-
    sco" OR "xterm-ncd".  Also,	the -F command line switch may be used
    (which overrides $ECUFUNCKEY).

    The	format of an file entry	is shown below.	 Lines beginning with '#'
    are	comments.


	 #+------------------------------
	 # SCO
	 #-------------------------------
	 ansi
	 ansi43
	 sco
	     F1:F1:	     esc [ M
	     F2:F2:	     esc [ N
	     F3:F3:	     esc [ O
	     F4:F4:	     esc [ P
	     F5:F5:	     esc [ Q
	     F6:F6:	     esc [ R
	     F7:F7:	     esc [ S
	     F8:F8:	     esc [ T
	     F9:F9:	     esc [ U
	     F10:F10:	     esc [ V
	     F11:F11:	     esc [ W
	     F12:F12:	     esc [ X
	     Home:Home:	     esc [ H
	     End:End:	     esc [ F
	     PgUp:PgUp:	     esc [ I
	     PgDn:PgDn:	     esc [ G
	     CUU:CUU:	     esc [ A
	     CUL:CUL:	     esc [ D
	     CU5:CU5:	     esc [ E
	     CUR:CUR:	     esc [ C
	     CUD:CUD:	     esc [ B
	     Ins:Ins:	     esc [ L
	     BkTab:BackTab:  esc [ Z





    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      13



    The	first line(s) in a terminal keyboard description begin in column 1
    and	contain	the terminal types (a la $TERM)	for which the keyboard
    description	are valid.  The	example	entry contains several references to
    terminal types containing the substring description	servicing multiple
    terminal types.

    Following the "first lines"	are key	definition entries, each preceded by
    at least one tab or	space.	Each entry is composed of three	fields
    delimited by commas.  The first field of an	entry is the internal ECU
    function key name and must be chosen from the following strings (with no
    regard to case): "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9",
    "F10", "F11", "F12", "Home", "End",	"PgUp",	"PgDn",	"CUU" (cursor up),
    "CUL" (cursor left), "CU5" (unshifted cursor pad 5), "CUR" (cursor
    right) and "CUD" (cursor down). The	second field contains the name of
    the	key as it appears on the keyboard (such	as "F16" for End on the	Wyse
    60).  The third field is a description of the character sequence
    generated by the keyboard when the chosen key is pressed; it is a string
    of one or more tokens separated by spaces or tabs.

    In addition, function key sequences	may not	exceed 31 characters in
    length.

    PLEASE NOTE: ECU does not have a reasonable	way for	you to terminate it
    if there are no Home and End keys defined, so it refuses to	proceed	if
    no definitions are found.  Even so,	if you have incorrect definitions,
    you	may not	be able	to get out of ECU without a kill -1 <pid> from
    another terminal or	hanging	up your	connection with	UNIX/XENIX if using
    ECU	from remote.


    3.4	 Function Key Actions


    This section deals with how	ECU behaves once a function key	has been
    recognized as having been entered at the keyboard.


    3.4.1  Standard Function Keys

    All	function keys with the exception of the	Home, BkTab (shift TAB), and
    keypad unshifted 5 key can be programmed to	transmit preselected
    character sequences	when the key is	pressed.

    The	default	values for these sequences is shown below.










    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      14



    Identifier Description    Default Sequence
    --------   ------------   ----------------
    F1	       F1		 ESC [ M
    F2	       F2		 ESC [ N
    F3	       F3		 ESC [ O
    F4	       F4		 ESC [ P
    F5	       F5		 ESC [ Q
    F6	       F6		 ESC [ R
    F7	       F7		 ESC [ S
    F8	       F8		 ESC [ T
    F9	       F9		 ESC [ U
    F10	       F10		 ESC [ V
    F11	       F11		 ESC [ W
    F12	       F12		 ESC [ X
    Home       Home	     <-- intercepted (not an input key)
    End	       End		 ESC [ F
    PgUp       Page up		 ESC [ I
    PgDn       Page down	 ESC [ G
    CUU	       Up arrow		 ESC [ A
    CUD	       Down arrow	 ESC [ B
    CUL	       Left arrow	 ESC [ D
    CUR	       Right arrow	 ESC [ C
    CU5	       "Cursor 5"    <-- intercepted (not an input key)
    Ins	       Insert		 ESC [ L


    This results in the	following interactive "fkey" command display:

     F1	  SCO F1    F2	 SCO F2	   Home	 ecu cmd       PgUp  SCO PgUp
     F3	  SCO F3    F4	 SCO F4	   End	 SCO End       PgDn  SCO PgDn
     F5	  SCO F5    F6	 SCO F6	   Ins	 local shell   CUR5  screen dump
     F7	  SCO F7    F8	 SCO F8	   BkTab redisplay
     F9	  SCO F9    F10	 SCO F10   CUR^	 SCO CUU       CUR>  SCO CUR
     F11  SCO F11   F12	 SCO F12   CUR<	 SCO CUL       CURv  SCO CUD


    You	may override the default setting by using the interactive or
    procedure command "fkey" to	specify	a new keyset definition	from
    ~/.ecu/keys.

    Function keyset definitions	are appended one after another to
    ~/.ecu/keys.  The keyset name appears on a line by itself and the
    choices making up a	set appear on subsequent lines of a special format.

    A keyset is	loaded explicitly using	"fkey" and implicitly when
    connecting to a remote system and a	keyset name matches the	dialing
    directory entry name.

    Consider the example:





    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      15



    stratus
	F1:F1:esc O q
	F2:F2:esc O r
	F3:F3:esc O s
	F4:F4:esc O t
	F5:F5:esc O u
	F6:F6:esc O v
	F7:F7:esc O w
	F8:status:dc4
	F9:no status:nl
	F10:redisp:esc O y
	F11:redisp:syn
	PGDN:cancel:esc	O Q
	END:enter:esc O	M
	PGUP:dispform:esc O R
	CUU:^:dle
	CUD:v:so
	CUL:<:stx
	CUR:>:ack


    The	key definition lines are made up of three fields.  In addition,
    there must be a blank or a space in	the first column of the	line.  The
    first field	is the ECU key identifier from the table above.	 The second
    field is a 12-character max	string to display when the display option of
    the	fkey command is	used.  The last	field is a character sequence to be
    transmitted	when the key is	pressed.

    The	resulting fkey display for the stratus example looks similar to:


     F1	 F1	F2  F2	       Home ecu	cmd	PgUp  dispform
     F3	 F3	F4  F4	       End  enter	PgDn  cancel
     F5	 F5	F6  F6	       Ins  local shell	CUR5  Screen dump
     F7	 status	F8  no status  BkTab restore receiver display
     F9		F10 redisp     CUR^ ^		CUR>  >
     F11	F12	       CUR< <		CURv  v


    Pressing F1, causes	the three characters ESC, 'O' and 'q' to be
    transmitted.


    3.4.2  SCO ALT-[a-z] Function Keys

    If you are on an SCO machine and you have installed	the custom ECU
    mapkey file	(as described in the release directory in mapkeys/README),
    then ALT-a through ALT-z causes the	"silent" execution of procedures
    'alt_a.ep' for ALT-a, 'alt_b.ep' for ALT-b,	etc.  The models
    subdirectory contains an example alt_h.ep which will home the cursor
    when ALT-h is pressed.  This facility allows the execution of 26



    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      16



    procedures without ECU itself changing the video display at	all.  Any
    changes to the display (short of procedure errors) will result solely
    from the action of the invoked procedure.  If the procedure	matching the
    ALT-[a-z] key pressed cannot be found, a short error message is printed
    and	the terminal bell is rung.  (Using back	tab may	be used	to refresh
    the	display	in this	event.)

    NOTE: ECU 3.10 CHANGES TO THE SINGLE KEY PROCEDURE FUNCTIONALITY MAKE IT
    NECESSARY FOR YOU TO REVIEW	mapkeys/README IF YOU HAVE USED	THIS FEATURE
    IN PREVIOUS	REVISIONS.

    The	strings	used to	represent "non-printable" characters are identical
    to the formal ASCII	names given them (without regard to case), viz:

	       NUL may not appear in a function	key definition

	 0x00 nul    0x10 dle
	 0x01 soh    0x11 dc1
	 0x02 stx    0x12 dc2
	 0x03 etx    0x13 dc3
	 0x04 eot    0x14 dc4
	 0x05 enq    0x15 nak
	 0x06 ack    0x16 syn
	 0x07 bel    0x17 etb
	 0x08 bs     0x18 can
	 0x09 ht     0x19 em
	 0x0A nl     0x1A sub
	 0x0B vt     0x1B esc
	 0x0C np     0x1C fs
	 0x0D cr     0x1D gs
	 0x0E so     0x1E rs
	 0x0F si     0x1F us
		     0x20 sp
		     0x7F del



    3.5	 Line Editing


    When you are entering a line of text for an	ecu command or in a field on
    a screen, you may edit it in a number of ways at any time prior to
    pressing Enter.  Cursor Left moves the cursor left by one character
    position, nondestructively.	 Cursor	Right moves to the right.  Insert
    toggles insert mode.  Backspace (your erase	key as specified to stty in
    commands, the actual backspace key in screens) deletes the character to
    the	left of	the cursor.  Your line kill key	(as specified to stty) in
    command mode or the	^U character in	screen mode erases the entire line.
    Esc	in command mode	cancels	the command.  Esc in screen mode usually
    cancels the	screen or subfunction in a screen.  ^L or ^R in	interactive
    command mode shows the current state of Insert mode	and redisplays the



    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      17



    edited string.


    3.6	 Screen	Dump

    When the "cursor 5"	key is pressed,	the screen contents are	dumped to a
    file.  By default, this file is named '~/.ecu/screen.dump'.	 The sdname
    interactive	command	either displays	or changes the current screen dump
    file name, depending upon whether or not an	argument is supplied.  The
    scrdump procedure command can initiate a dump.

    Note that from an SCO multiscreen, screen dump produces a dump of the
    actual screen contents (it is obtained from	the video driver), including
    ecu-generated output.  When	using a	non-multiscreen	terminal, screen
    dump dumps only the	shared memory virtual screen as	received from the
    host.

    If,	at a multiscreen, you wish a screen dump free of ecu output
    "pollution," use Shift-Tab (BkTab) to redraw the screen, then perform
    the	screen dump.  If you are not on	a multiscreen, then the	screen dump
    comes from the (sometimes inexact) screen memory representation and	this
    step is not	necessary.


    3.6.1  Multiscreen and Non-Multiscreen
    Note that from multiscreens, screen	dump produces a	dump of	the actual
    screen contents, including ECU-generated output.  When using a non-
    multiscreen	terminal, screen dump dumps only the shared memory virtual
    screen as received from the	host.  If standard input is not	a serial
    line (xterm	or /dev/null), screen dumps will be of the non-multiscreen
    type.

    If,	at a multiscreen, you wish a screen dump free of ECU output
    "pollution," use Shift-Tab (BkTab) to redraw the screen, then perform
    the	screen dump.


    3.6.2  Multiscreen Bug
    There has been a bug in the	multiscreen driver for some time wherein a
    MEDIA COPY (screen dump) sequence ("ESC [ 2	i") leaves the "ESC [ 2"
    part "active".  When a screen dump (Cursor 5) command is given, I do the
    screen dump, then send a "l" to the	screen to work around the bug ("ESC
    2 [	l" unlocks the keyboard, essentially a no-op).	If and when it gets
    fixed, you'll see an "l" show up on	your screen after a screen dump
    sequence.  To fix this, comment out	the

	 #define MULTISCREEN_DUMP_BUG

    at the top of ecuscrdump.c.





    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      18



    3.7	 Interactive Command History


    After pressing the Home key, pressing it again invokes the interactive
    command history function.  After the second	Home key is pressed, the
    last interactive command is	redisplayed. Line editing may be performed
    on the command as described	in the previous	section.

    Additionally, using	the Cursor Up key accesses less	recent commands.
    The	Cursor Down key	accesses more recent commands.	Pressing Enter
    causes the command to be executed.	Pressing Esc aborts command entry.


    3.8	 Dialing Directory


    ECU	provides an on-line editable dialing directory.	 Remote	systems	are
    defined as records using alphanumeric identifiers as keys.	Other record
    fields include telephone number, baud rate,	parity and textual
    description.

    Other features include changing to alternate dialing directory and a
    multi-number redial	cycle function.	Refer below to the description of
    the	interactive dial command.

    While a long entry in a field may be truncated on the display, when	the
    entry is edited, it's full contents	will be	dispalyed on the edit
    subform.

    Entering or	editing	a dialing directory entry is for the most part
    straightforward.  A	note on	the use	of the "tty" field is useful,
    however.  When prompted for	a tty, you may choose

       + "Any" line  (deprecated, for compatibility only)

       + a tty line matching a Devices type

       + a specific tty	line

    A specific line is chosen by using the base	name of	the tty	(e.g.,
    "tty1a" or "acu0").	 On SCO, since ttys are	all named consistently
    according to the "/dev/ttyxx" form,	you may	omit the "tty" (e.g., "1a"
    or "4g").  This latter feature is for compatibility	with earlier
    revisions of ECU.  It is good practice to fully specify the	tty name.

    "Any" matches any tty line in the /usr/lib/Devices file supporting the
    specified baud rate	and whose Devices type begins with the characters
    (case independent) "ACU".  This choice is provided to be compatible	with
    earlier versions of	ECU (prior to 3.10). Use of this argument is
    discouraged.  It's equivalent in current practice is "/ACU", as you	can
    see	next.



    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      19



    A more general choice for choosing a tty line based	on Devices type	is
    the	"Devices type matching"	choice,	invoked	by prefixing the tty field
    with a slash or equals sign.


       + / prefix searches for a Devices type matching a regular expression
	 (a la sed or ed)

       + = prefix searches for an exact	match on a Devices type


    Examples:

       =ACU	   matches "ACU", fails	on "acu" and "ACUx"
       /.*tbit.*   matches "ACUtbit1", "tbit"


    A specific tty line	may also be specified.	This is	the only means of
    attaching a	line not mentioned in the Devices file.

    NOTE:  If the bell rings and you are not allowed to	leave a	field, it is
    because you	MUST enter acceptible data before you can leave	a field
    using other	than the ESCape	key.

    The	"debug level" parameter	allows you to specify a	number between 0 and
    9 for passing to a UUCP dialer program with	the -x switch.

    The	"DCD watch" parameter allows you to modify the DCD watcher upon
    successful connection to a remote.	The values allowed are:

       1    enable DCD watcher
       0    disable DCD	watcher
       t    terminate ECU on loss of DCD
       n    no change of dcdwatch state

    Specifying 'n' leaves the dcdwatch state unaffected.  See the
    description	of the dcdwatch	interactive command for	more information.

    The	following sample dialing directory screen shows	an edit	in progress.















    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      20



     .--[ dialing directory ]--	/u1/wht/.ecu/phone --------- modified ---.
     | entry name | telephone number | tty | baud P | description	 |
     | ......	  | ........	     |Any  | 2400 N | ...............	 |
     | li.--[ entry: new ]--------------------------------------------.	 |
     | ..|							      |	 |
     | ..| telephone number  1(800)555-1212			      |	 |
     | ..| device	     =ACUtbit				      |..|
     | ..| baud	rate	     19200				      |..|
     | ..| parity	     N					      |	 |
     | ..| description	     don't call	this_________________________ |..|
     | ..| debug level	     0	(dialer	-x value 0-9)		      |	 |
     | ..| DCD watch	     n					      |	 |
     | ..| Enter description					      |..|
     | ..| ESC:	abort  End: finish  ^U:	erase ^B: back	TAB: fwd      |	 |
     | ..`------------------------------------------------------------'	 |
     | .....	  | ..........	     |2b   | 9600 N | ...................|
     | sco19	  | 1(408)426-9525p  |2b   | 9600 N | SCO Tech Services	 |
     | sco24	  | 1(408)426-9495   |2b   | 2400 N | SCO Tech Services	 |
     +-------------------------------------------------------------------+
     |down up edit add remove save find	change dial dir	ENTER:dial quit	 |
     |redial: mark unMark Unmark all wait between dial			 |
     `-------------------------------------------------------------------'


    You	may use	the vi conventions of 'j' for down and 'k' for up.  You	may
    also use the up and	down arrow keys	if you are on an SCO multiscreen or
    if the function keys have been properly defined with funckeymap.


    3.9	 Online	Interactive Command Help


    The	ECU help command presents a display of interactive commands.  The
    user is then prompted to enter a command name for further, Unix-style
    "usage" information.


    3.10  Multiscreen Event Alarm


    On an SCO machine, by using	the BN (bell notify) interactive command, an
    audible alert is sent to all multiscreens when an ASCII BEL	(bell) is
    received or	when a file transfer completes.	 An additional option causes
    an alert when ANY data is received from the	line.  This makes it simple
    to do work on other	multiscreen consoles and be alerted when attention
    to the communications session is required.

    For	instance, the Berkeley 4.x Unix	utility	"talk" rings the bell when
    another user wishes	an interactive chat mode.  BSD "biff" rings the	bell
    when incoming mail is received.  Scripts or	commands at remote sites can
    be configured to ring the bell as in:



    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      21



	 make foo bar; bell; make more_stuff; bell;

    to call attention to the ECU user when work	is being done on other
    multiscreen	consoles.

    This feature is only available when	you are	running	ECU from a
    multiscreen.


    3.11  Built-in Modem Dialer


    The	built-in ECU dialer supports modems which use the Hayes-style AT
    command set	or most	variants thereof.  It is used when HoneyDanBer UUCP
    is not installed or	when there is no entry in the /usr/lib/uucp/Devices
    file for the selected outgoing line.  (For more information, see the
    later section titled "HoneyDanBer UUCP Interface".)

    The	built-in dialer	uses files in the ecu library directory	which
    contains modem initialization information.	Modem initialization
    filenames are made from concatenating the tty name with ".mi".  For
    instance, tty1a's initialization file is named "tty1a.mi".

    Commands for initializing the modem	and for	dialing	may be specified in
    a very flexible manner.  Separate init and dial strings for	each legal
    baud rate, a single	pair of	strings	for all	baud rates or a	combination
    may	be specified.

		 Sample	Modem Initialization Files

    #+-----------------------------------------------------------
    #  tty1a.mi	- Microcom AX/9624c
    #------------------------------------------------------------
    init_>2400:ATS11=47X4S0=0S7=30\Q1\X1\N3   #	baud rates > 2400
    init_default:ATS11=47X4S0=0S7=30\Q0\X0\N0 #	other baud rates
    dial_default:ATDT

    #+-----------------------------------------------------------
    #  tty2d.mi	- USR Courier 2400
    #------------------------------------------------------------
    init_default:ATS11=47 X4 S0=0 S7=32
    dial_default:ATDT












    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      22



    3.12  File Transfer


    ECU	supports numerous file transfer	protocols: as of this writing,
    XMODEM, XMODEM/CRC,	XMODEM-1K, YMODEM/CRC Batch, ZMODEM/CRC-16,
    ZMODEM/CRC-32, C-Kermit and	SEAlink	are supported.	` Although a
    seamless interface (there's	some yuppie marketing newspeak)	is provided
    to the user, transfer is facilitated by executing external programs.

    Kermit support requires you	to obtain C-Kermit version 5A or later.	 You
    may	also patch C-Kermit 4E to work with ECU	(The patch information is
    available in the ckermit subdirectory of the ECU release).	C-Kermit 5
    is in beta release as of this writing and supports ECU without
    modification.

    XMODEM, YMODEM and ZMODEM transfers	(thanks	to modified public domain
    programs by	Chuck Forsberg)	present	dynamic	status displays	similar	to
    the	following:

     .-[ ecusz 3.20 ]--	/tmp -------------------------------.
     |	ZMODEM/CRC32   data rate ~= 900	ch/sec (94%)	 T  |
     |	File 1	 of 1  : /t/ecu320cpio.Z		    |
     |	File position:	617472 length: 915263  -rw-r--r--   |
     |	Total transaction 915263 bytes (xfer time ~= 17:29) |
     |	tx: D32	ZCRCG 1024	    rx:	HEX ZACK  605184    |
     |	Comm I/O: rx 917       tx 650041   bytes	    |
     |	Baud rate: 9600	BINARY blklen: 1024 comm mode: RAW  |
     |	Time: started: 13:39:34	this file: 13:39:35 window: |
     |	13:51:34 elapsed: 00:12:00	   00:11:59 +12288  |
     |	Errors:	this file: 2   total: 2	 files skipped:	0   |
     |							    |
     |	This file 67%, transaction 67% complete		    |
     |	Remote:	CRC32 y	 duplex	y  continuous stream y	    |
     `-	Connected to tridom --------------------------------'


    During file	transfer, data rates are displayed from	time to	time.  While
    the	figures	may vary significantly during the transfer, bear in mind the
    calculations are for actual	data throughput, measured as total DATA
    characters transferred from	the time the file is opened until it is
    closed.  So, if the	data rate appears to be	low at the start of the
    transfer and increase over time, perhaps it	took a significant amount of
    time for the receiver to open it's file or to respond to protocol
    startup stimuli.  If the data rate appears to be higher at the beginning
    and	become lower over time,	perhaps	flow control is	being invoked.	A
    sudden reduction in	the "last file"	or "transaction" data rate over	the
    in progress	rate reflects the time required	to close files,	operate	the
    protocol or	to skip	files (in the case of ZMODEM).	If any files are
    skipped in a session, you may be sure the transaction rate will be
    (perhaps much) lower than the per-file rate.




    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      23



    On some systems and	driver options,	sundry driver statistics are
    displayed during X/Y/ZMODEM	transfers.  For	instance, in the above
    display from a Sun session.	 the driver's current output and input queue
    depths and input queue space available are displayed along with the
    current status of RTS and CTS.  While such gay banter is rightly
    relegated to the "bell and whistle"	category, it does provide a rare
    insight into driver	operation.  The	ECU FAS/i driver for 386 systems
    (after Uwe Doering's FAS driver) provides other information.


	    |  Output queue depth	0  RTS T  CTS T		       |
	    |  Input queue depth       10  Input queue avail	490    |




    3.13  Automatic ZMODEM Receive

    ECU	in the interactive mode	(no procedure executing) can interpret a
    SUB, 'B', '0', '0' receive data sequence as	a ZMODEM ZRQINIT frame and
    automatically begin	a ZMODEM receive operation.  The autorz	interactive
    and	procedure commands control this	feature.  By default, this feature
    is turned on.


    3.14  Procedures (Scripts)

    A powerful,	language-style procedure language is incorporated into ECU.
    The	language is described in the companion "Procedure Language" manual.

    Procedures are files of programmatic instructions written in the ECU
    procedure language invoked explicitly by the do interactive	command	or
    automatically by ECU functions described below.  Procedures	are invoked
    by name, and result	in execution of	the file name.ep.

    The	file is	searched for in	the current directory.	If not found there,
    ECU	checks your personal .ecu subdirectory.	 If not	there, the ECU
    library "ep" subdirectory is searched (e.g., /usr/local/lib/ecu/ep).


    3.14.1  Initial (Startup) Procedure
    An initial procedure may be	be specified to	ECU either to initialize an
    interactive	session	or to execute an entirely unattended or	"batch"
    communication session.  Refer to the section on command switches ("-p").


    3.14.2  Dialing Procedure
    When a named dialing entry is selected for calling,	if a procedure can
    be located using the above mentioned search	sequence whose name matches
    the	name of	the directory, then all	of the usual ECU built-in dialing
    procedure is bypassed and the procedure is used.  For details, refer to



    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      24



    other sections related to dialing.

    3.14.3  Other Special Procedures
    Other special procedures may be invoked when

       + ecu starts up (_rc.ep)

       + a connection is established (_connect.ep)

       + an attempted connection fails (_connfail.ep)

       + a connection is terminated with the hangup command (_hangup.ep)
    See	the ECU	procedure manual for details.


    3.15  DCD (Carrier)	Watcher

    ECU	can be instructed to monitor DCD (carrier) status on any tty line
    whose driver honors	dynamic	manipulation of	the CLOCAL control bit.	ECU
    may	be instructed to ignore	DCD (the default state).  In such a state,
    if carrier is lost after a connection has been made, ECU is	unaware	the
    connection has been	lost.  An interactive stat command will	show the
    connection still active.

    When the DCD watcher is enabled, loss of carrier will cause	the hangup
    command processing to automatically	be executed (including execution of
    the	special	procedure _hangup.ep if	any can	be found).

    An additional mode is available which, in addition to the hangup
    processing,	 causes	ecu to terminate execution.

    The	dcdwatch interactive and procedure commands control this feature.
    In addition, each dialing directory	entry has a field specifying whether
    or not the DCD watcher status is to	be changed upon	connecting to the
    remote system and if so, to	what state.  Refer to the description of the
    dcdwatch and dial commands for details.


    3.16  Home Directory Files

    ECU	control	files reside in	the .ecu subdirectory of each user's home
    directory.	For example, in	home directory /usr/wht:

	    /usr/wht/.ecu/dir	       CD interactive command history file
	 *  /usr/wht/.ecu/keys	       function	key mapping
	 *  /usr/wht/.ecu/funckeymap  function key mapping
	    /usr/wht/.ecu/log	       connect,	file transfer history
	    /usr/wht/.ecu/phone	       default dialing directory
	 *% /usr/wht/.ecu/colors       colors used by ECU





    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      25



    * The ecu library directory	(normally /usr/local/lib/ecu) is searched
    for	the "keys", "colors" and "funckeymap" file if a	personal version
    cannot be found.

    % The "colors" file	does not apply to systems on which color is not	yet
    supported.

    The	.ecu directory is searched for an ECU procedure	file (having the
    '.ep' extension) if	the procedure file cannot be found in the current
    working directory.


    3.17  Lock Files


    ECU	maintains lock files in	the standard directory in accordance with
    the	HoneyDanBer UUCP conventions (ASCII pids as 10-character strings
    followed by	a newline).  If	porting	to a machine with old-style integer
    pids, grep for HONEYDANBER in the sources for hints	on where changes are
    needed.

    Standard lock directories for versions supported as	of this	writing:

	    SCO		      /usr/spool/uucp
	    ISC		      /usr/spool/locks
	    SunOS, SVR4	      /var/spool/locks


    World write	access to this directory must be in effect.

    See	the later section titled "HoneyDanBer UUCP Interface".


    3.18  Dial-In/Dial-Out Line	Support


    On SCO XENIX and UNIX 3.2 systems, ECU works with the SCO getty to
    support dialing out	on a line enabled for login.  After use	of the line
    is complete, ECU signals the system	to restore incoming call status	to
    the	line.  See the later section titled "HoneyDanBer UUCP Interface".

    This facility is not supported in other environments as of this writing.
    Scan the distribution README.* files for any updates.


    3.19  Tools


    Commands are provided for conversion of hexadecimal	or decimal numbers
    to and from	ASCII equivalents.  For	example, 26(10)	== 0x1a	== ^Z ==
    SUB.  For details, refer to	the description	of the XA and AX interactive



    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      26



    commands.


    3.20  Shared Memory	'Friend' Interface


    ECU	maintains a copy of the	received screen	image (80 x 43 maximum)	and
    other information in its shared memory segment.  Normally, this
    information	is used	only by	the transmitter	and receiver process.
    However,  ECU supports the concept of a friend process which may access
    the	shared memory segment, perform arbitrary auxiliary operations, read
    from and write to the attached communications line and communicate
    resulting information or status to an ECU procedure	via a 1024-byte
    "friend" data area in the shared memory segment.

    The	procedure language supports the	friend process concept through
    commands and functions which allow

       + passing the ECU shared	memory segment id (%shmid) to a	called
	 program,

       + reading a single character or string of characters from screen
	 memory,

       + reading cursor	position information and

       + reading and writing of	characters, short or long integers and
	 strings in the	1024-byte "friend" shared memory data area.

    The	algorithm for obtaining	the shared memory segment key is

    0xEC000000L	+ transmitter process id

    Thus a "friend" process may	either use a %shmid shared memory key passed
    as an argument or obtain the shared	memory key by using:

    key_t shmkey = 0xEC000000L | getppid();


    This facility allows batch and interactive applications to be developed
    with C programs which would	be tedious or impractical to implement with
    procedure language alone.

    For	more information, refer	to the shared memory header file ecushm.h,
    the	ecufriend subdirectory of the software release and to the
    description	of the %shmid, %cury and %curx procedure functions and the
    getf and putf procedure commands.







    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      27



    4.	Starting the Program



    4.1	 Simple	Startup	- Initial Setup	Menu


    ECU	may be started in a number of ways through use of command line
    switches, but the easiest is to enter

	 ecu

    by itself.	In this	case, the screen is cleared and	the following
    screen, called the setup screen, will be presented.

	    .--[ ecu 3.20-386u wht@n4hgf ]---------------------------------.
	    |								   |
	    |  Destination   ________________________________________	   |
	    |								   |
	    |								   |
	    |								   |
	    |  tty: /dev/tty2b						   |
	    |								   |
	    |  duplex: F  baud:	9600   parity:N	 (data bits 8)		   |
	    |  add NL to transmitted CR: N				   |
	    |  add NL to received CR:	 N				   |
	    |								   |
	    |								   |
	    |	TAB:next ^B:prev END:proceed ^D:phone dir  ESC:quit ecu	   |
	    `- logical phone directory entry, phone number or empty -------'


    Several choices may	be made	by navigating the setup	screen.	 When you
    position to	a field, helpful text is displayed on the bottom line of the
    form.

    It is important to note that you may not exit this screen into ECU
    operation without opening a	communications line.

    The	initial	(default) values for some of the fields	may be modified	by
    command line switches or by	the special procedure "_rc.ep".	 Also,
    entering a dialing directory entry name in the 'Destination' field and
    pressing Return will override the defaults with the	values in the
    directory entry.  See the sections related to dialing and the section in
    the	Procedure Language manual titled "_rc.ep".


    4.1.1  Destination

    If a dialing directory has been configured,	a literal phone	number need
    not	be entered.  However, on your first invocation,	 you'll	very likely



    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      28



    have no directory.	Therefore, you have three options:


	 1.  Enter a literal telephone number, (e.g. 18005551212).
	     Hyphens and open and close	parentheses may	also
	     be	entered.

	 2.  Press ENTER to skip the 'Destination' field and enter
	     ^D	to enter the telephone directory to enter your
	     first directory entry.

	 3.  Press END to enter	interactive mode to communicate
	     directly with the attached	DCE (modem).



    4.1.2  Other Fields

    The	'tty' field may	be used	to select an outgoing line other than the
    default.  For important considerations on line choice, see the sections
    titled "Choosing a Dialout Line" and "DCDwatch".

    The	'duplex' field may be used to select a duplex value other than the
    default 'F'	(full).

    The	'baud' field may be used to select a baud rate value other than	the
    default selected at	Configure time.

    The	'parity' field may be used to select a parity value other than the
    default selected at	Configure time.


    The	'Add NL	to transmitted CR' and 'Add NL to received CR' fields are
    usually left defaulted to 'N' (no).	 If you	will be	communicating with a
    terminal (as in a chat with	a human), you will usually need	to set both
    of these fields to 'Y' as well as to select	'H'alf duplex.


    4.1.3  Keyboard Functions

    Special keyboard characters	while filling in the startup screen are:













    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      29



	  Enter	       terminate entry in a field (or skip to
		       the next	field if you do	not modify it)

	  ^B	       back up to previous field

	  Cursor Up    same as ^B (if the key is available on
		       your terminal and environment).

	  TAB	       move to next field ... if nothing typed in
		       the field, do not disturb contents

	  Cursor Down  same as TAB (if the key is available on
		       your terminal and environment).

	  END	       proceed with session, dialing remote if
		       logical directory entry name or literal
		       telephone number	enetered

	  ^D	       enter phone directory

	  ESC	       quit ecu	without	starting a session


    When editing a multicharacter field, such as "tty",	you may	use the
    backspace key in the traditional fashion.  Depending on the	terminal,
    ECU	version	in use (OS in use), and	configuration, you may also be able
    to use the cursor left and right keys and the insert key (to toggle
    insert mode).


    4.2	 Command Line Switches and Arguments


    ECU	can be started in a number of ways:




















    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      30



	 o  with no switches or	arguments
		select options interactively; manual command to	begin
		connection

	 o  with switches (excluding -p) and no	arguments
		override some defaults for options but still enter
		interactive option selection; manual command to	begin
		connection

	 o  zero or more switches (excluding -p) and one argument
		fully automatic	startup	to connect to the remote
		specified by the argument (a telephone number
		or dialing directory entry)

	 o  zero or more switches, with	-p the last switch
		fully automatic	startup	by executing procedure whose
		name is	specified by the first argument; the initial
		procedure receives the remainder of the	command	line
		arguments



    4.2.1  Usage Summary


	 usage:	ecu [-l	<ttyname>] [-b <baud_rate>] [-eon]
		    [-h] [-t] [-P <phonedir>]
		    [-F	name] [-T <trace-level>]
		    [-p	<initial_proc> [-d] [-D] | <phone_number>]
	 -D unconditionally stop execution when	-p initial
	    procedure is done
	 -F sets an alternate funckeymap name for the *keyboard*
	 -P choose alternate phone directory (<phonedir> must be
	    a full pathname)
	 -T set	procedure tracing to level: 0=none, 1=standard,
	    2=ECU-debugging
	 -b choose baud	rate (any UNIX rate 110-38400)
	 -d stop execution if -p initial procedure fails
	 -e even parity	  -o odd parity	  -n no	parity
	 -h half duplex	... default is full duplex
	 -l choose line	(/dev/<ttyname>)
	 -p execute an initial procedure
	 -t append NL to incoming and outgoing CR characters
	 <phone_number>	is either an actual number or a	dialing
	    directory entry name



    4.2.2  Switches

    Many switches are used to override defaults	specified at the time the



    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      31



    Confifgure procedure was used.  Note these defaults	may also be
    overriden interactively if the command does	not specify automatic
    startup option (-p or dialing argument).  Also, the	value chosen by	a
    dialing directory entry or an initial procedure will override the
    Configured default and/or the value	specified by this switch.


    4.2.2.1  -b	<baud>

    This switch	overrides the default baud rate.  Any valid UNIX rate may be
    chosen. ECU	chooses	the number of stop bits	based on the baud rate.
    Rates below	300 baud get 2 stop bits.  Rates 300 baud and above get	one
    stop bit.


    4.2.2.2  -d

    The	-d switch instructs ECU	to "die" (terminate with error status) if an
    initial procedure (-p) fails.  This	switch ensures a batch ECU execution
    will hang up any connection	and terminate if a procedure error occurs.
    See	also -D	below.

    Absence of the -d and -D switches causes ecu (upon any completion of the
    initial procedure) to enter	the 1) interactive mode	if a line was
    successfully attached by the procedure or 2) the setup screen if no	line
    was	attached.


    4.2.2.3  -e, -o, -n

    Normally, ECU starts up with data bits and parity chosen at	Configure
    time.  The -e, -o and -n switches allow you	to override the	default.

    Since combinations like eight data bit and even parity or seven data
    bits and no	parity are not in  ECU's capability to use, the	parity
    selection also dictates the	choice of data bits. Even or odd parity
    implies seven data bits.  No parity	implies	eight data bits.


    4.2.2.4  -h

    Normally, ECU starts up in the full	duplex mode.  If half duplex is
    desired, the -h switch is used.


    4.2.2.5  -l	ttyspec

    When ECU starts up,	it normally chooses a line as described	later in the
    section titled "Choosing a Dialout Line".  Specifying the -l switch
    overrides the default tty specified	at Configure time.  Depending upon
    other command line options,	this switch may	be nothing more	than a hint.



    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      32



    The	argument to the	switch is the base name	of the tty (e.g., "tty1a" or
    "acu0").  On SCO, since ttys are all named consistently according to the
    "/dev/ttyxx" form, you may omit the	"tty" (e.g., "1a" or "4g").

    For	important considerations on line choice, see the sections titled
    "Choosing a	Dialout	Line" and "DCDwatch".


    4.2.2.6  -p	<proc>

    The	-p switch causes ECU to	execute	the procedure <proc> ("<proc>.ep")
    immediately	upon startup.  Such a procedure	is termed the initial
    procedure.	It is recommended that,	when used, -p be the last switch on
    the	command	line.  All non-switch arguments	after <proc> are passed	as
    arguments to the initial procedure (see the	descriptions of	the integer
    function %argc and the string function %argv in the	Procedure Manual).

    For	example,

	ecu -p batchjob	remsys 22
    automatically executes the procedure command equivalent
	do 'batchjob' 'remsys' '22'


    The	initial	procedure may read command line	options	with functions like
    %line, %baud and %parity.  It is also free to override any of these
    values it wishes.  See the procedure manual	for more information.


    4.2.2.7  -t

    The	-t switch instructs ECU	to map incoming	and outgoing carriage
    returns to carriage	return/line feed pairs.	 This is helpful if the
    remote connection will be to a display terminal rather than	a computer.
    Use	of the -h switch may also be necessary.

    The	interactive commands nlin and nlout also control this feature.


    4.2.2.8  -D

    The	-D switch instructs ECU	to unconditionally terminate when an initial
    procedure finishes.	 Contrast with the -d switch.


    4.2.2.9  -F	name

    Normally, the TERM environment variable is used to determine the
    funckeymap entry (keyboard configuration) to be used.  Sometimes, the
    TERM variable is not adequate for identifying your keyboard	arrangement.
    The	-F switch switch, like the $ECUFUNCKEY environment variable, allows



    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      33



    you	to use override	the funckeymap entry used.  For	more information,
    see	the section titled "Function Key Mapping (Recognition)".


    4.2.2.10  -P phonedir

    The	-P switch causes ECU to	begin execution	using an alternate phone
    directory.	The default is ~/.ecu/phone.  You should specify a full
    pathname if	you anticipate using the change	directory command once ecu
    starts.


    4.2.2.11  -T level

    The	-T switch sets the procedure language trace level.  <level> is a
    decimal digit.  0 is for no	tracing	(the default) and 1 is for tracing.
    Values higher than 1 are for debugging ECU and have	varying	effects	from
    revision to	revision.


    4.2.3  Non-Switch Arguments

    Aguments are optional.  <tel-number> or <logical> may appear when the -p
    switch is absent.  One or more <arg> arguments may appear when the -p
    switch is used.  These arguments are handled as described by "-p" above.


    4.2.3.1  <tel-number>

    This type of argument has a	digit as its initial character and
    represents an actual telephone number to be	passed to a modem dialer
    program or Dialers chat script.  The string	may contain non-numeric
    characters if appropriate for a dialer program, such as dialTBIT or
    dialgT2500 (see the	gendial	subdirectory).	For example:

	ecu -ltty2a -b 19200 -e	5551212C

    uses tty2a (assumed	to be connected	to a Trailblazer modem because of
    the	dialer-specific	telephone number) and establishes a 19200 baud,	even
    parity PEP Compressed connection after dialing 5551212.


    4.2.3.2  <logical>

    This type of argument has an alphabetic initial character and causes the
    dialing directory entry by that name to be dialed.	The line may be
    specified by '-l', but if the dialing directory specifies a	line (tty
    field contains other than 'Any'), the dialing directory entry will
    override it.  The '-b', '-e' and '-o' switches are ignored;	the values
    specified by the dialing directory entry are used.	The '-t' and '-h'
    switches are valid and honored if present.



    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      34



    4.2.3.3  <arg>

    This type of argument is passed to an initial procedure when the -p
    switch is present.


    ecu	-p unixlogin user pwd ansi43

    executes unixlogin.ep with arguments 'user'	'pwd' 'ansi43'

    For	more detail, refer to the description of -p, -d	and -D below.


    4.3	 Environment Variables


    Prior to starting ECU, it is useful, but not necessary, to establish two
    environment	variables, ECUPROMPT and ECUHELP.


    4.3.1  ECUPROMPT

    The	ECUPROMPT environment variable determines the prompt printed by	ECU
    when the interactive command key ("HOME") is pressed.  When	you first
    run	ECU, try setting it to your name, e. g.,

	 setenv	ECUPROMPT Ralph	   if you use csh

	 ECUPROMPT=Ralph	   if you use sh, ksh, etc.
	 export	ECUPROMPT

    Then, when you see how it used, you	may wish to establish a	more
    permanent choice in	your .login or .profile.


    4.3.2  ECUHELP

    Ordinarily,	ECU looks for interactive command help information in
    "ecuhelp.data" (in the ecu library directory, normally
    /usr/local/lib/ecu).  The ECUHELP environment may be set to	the complete
    pathname of	the ecu	help file if an	alternate file is to be	used.

    The	help file is explained later in	the section titled "Online Command
    Dictionary".


    4.3.3  ECUFUNCKEY

    See	the description	of the -F command line switch and the section titled
    "Function Key Mapping (Recognition)".




    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      35



    5.	Interactive Mode Commands


    The	following is a partial list of commands	available in the interactive
    (non-procedure) mode.  It is not necessary to enter	the entire command
    in most cases.  The	portion	of each	command	which must be entered is
    capitalized	in the following section headers.

    Refer to the sections titled Interactive Command History and Line
    Editing for	more information.


    5.1	 AUTORZ	: Automatic ZMODEM Receive

    Usage: autorz [off | on | ]

    ECU	in the interactive mode	(no procedure executing) can interpret a
    SUB, 'B', '0', '0' receive data sequence as	a ZMODEM ZRQINIT frame and
    automatically begin	a ZMODEM receive operation.  This command controls
    or displays	this feature.  By default, this	feature	is turned on.


    5.2	 AX : ascii char to hex/oct/dec

    usage: ax [<param>]


    <param> may	be a single ASCII character, a standard	ASCII identifier
    (such as ETX), or a	two-character control character	identifier (such as
    ^C,	typed as a caret followed by a C).

    If no argument is supplied,	a table	of control characters is printed
    containing decimal,	octal, hex, ASCII identifiers and two-character
    control character identifier.



    5.3	 BAud :	set/display line baud rate

    usage: baud	[<baud-rate>]


    <baud-rate>, if specified, must be taken from the values 110, 300, 600,
    1200, 2400,	4800, 9600, 19200 and 38400.  On some systems, 19200 and
    38400 may not be supported.	 If a baud rate	less than 300 is selected, 2
    stop bits are automatically	specified; other baud rates set	1 stop bit.
    If <baud-rate> is not supplied, the	current	baud rate is displayed.

    The	setting	may be automatically changed as	the result of a	'dial'
    command.  See also the dial	and parity command descriptions.




    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      36



    5.4	 BN : all console event	alarm

    Usage: bn [	off | on | alert ]
	   bn [	0 | 1 |	2 ]


    "bell notify": If no parameter is supplied,	the current setting is
    displayed.	Specifying 0 or	off disables the facility; 1 or	on causes an
    audible alarm to be	sounded	upon receipt of	a bell (0x07) character	from
    the	remote system; 2 or alert causes an audible alarm upon receipt of
    ANY	characters.  This command may not be functional	in the version for
    your system.

    On SCO, different alarm styles are sent depending upon the type of event
    causing the	alarms.	 The alarms consist of Morse characters.  Even if
    you	do not understand Morse, the patterns of the alarm tones are
    distinct enough to be distinguishable.

    Additionally on SCO, if you	are running ECU	from a multiscreen, the
    alarms will	be signalled even if you have temporarily switched to
    another screen.

    BN is set to 1 (on)	when ECU begins	executing.


    5.5	 BReak : send break to remote

    usage: break


    This command sends a break signal to the remote system.



    5.6	 CD : change current directory

    usage: cd [<dir-path>]


    This command allows	you to change the working directory of the ECU
    process.  If <dir-path> is supplied, the previous working directory	is
    displayed, and <dir-path> is made the new working directory.  A history
    of previous	directory changes is maintained.  Entering the cd command
    shows the numbered history list and	allows you to select a new directory
    by entering	the number.  Other commands allow deletion of directories
    from the list or saving the	list to	file ~/.ecu/dir.  This file is
    automatically read at ECU startup, providing a convenient list of
    directories	available for quick selection.	If you edit this file by
    hand, you may force	ECU to re-read the file	using the %read	option.

    The	%xmitcd	option transmits "cd "+current_directory+CR to the remote, a



    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      37



    convenience	to set the remote current directory to the same	as your
    local one.

    The	%pushd # option	pushes the current directory onto the same stack
    used by the	pushd interactive command and changes the current directory
    to the numbered directory specified	by #.  Use the popd interactive
    command to return to the previous directory.

    Other %options have	usage information by entering them with	no
    arguments.

    5.7	 DA : decimal to ascii char

    usage: da [<decimal-val>]


    <decimal-val> is a decimal value between 0 and 256;	the parity (sign)
    bit	is stripped and	the equivalent ASCII character value is	displayed.

    If no argument is supplied,	a table	of control characters is printed
    containing decimal,	octal, hex, ASCII identifiers and two-character
    control character identifier.


    5.8	 DCDwatch

    usage: dcdwatch [<dcdwatch-param>]


    This command controls the DCD watcher.  The	optional parameter may be:

       y  yes -	enable DCD watcher
       n  no - disable DCD watcher
       t  terminate - terminate	ECU on loss of DCD

    Entering the command without an argument shows the current status.

    The	DCD watcher when enabled causes	ECU to monitor the DCD line (within
    the	limits imposed by the OS with its CLOCAL=0 functionality).  When the
    watcher is on and DCD drops, ecu automatically performs the	action of
    the	interactive or procedure hangup	command.  If the 't'erminate option
    is chosen, then after hangup processing is complete, the ECU program
    will terminate.

    The	state of the watcher may be changed by the use of the dial command
    which uses a directory entry that changes the DCD watcher status.

    The	DCD watcher depends upon the tty driver	to return zero on a read
    when DCD is	low when the termio flag CLOCAL	is reset.  The tty driver
    must ignore	DCD if CLOCAL is set.  If your system offers a "modem" and
    "direct" choice (by	choice of filename), you probably need to use the



    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      38



    "modem" choice for this to work properly.  However,	the choice depends
    upon the needs of the underlying driver you	are using.  For	instance, if
    you	are using FAS in a shared modem	application, your getty	should use
    the	"modem"	choice and ECU should use the "direct" choice.	Some
    experimentation may	be required.


    5.9	 Dial :	dial remote destination

    usage: dial	[<dial-param>]


    <dial-param> may take one of two forms, a telephone	number to dial
    (initial digit) or a logical name (initial letter) which can be found in
    the	user phone directory (in file ~/.ecu/phone).

    If a telephone number is supplied, the phone number	is dialed; you must
    first have set the desired baud rate and parity using the baud and
    parity commands.  (If the last character of	a telephone number is a
    dollar sign, it is removed and is replaced with the	contents of the
    first line in ~/.ecu/credit.  See the description of the dialing
    directory.)

    If a logical name is entered, the phone directory is searched; if the
    entry is found, the	baud rate and parity is	automatically set.  if a
    procedure file can be found	in the current directory, the user's home
    .ecu subdirectory or the ECU library directory "ep"	(normally
    /usr/local/lib/ecu/ep) whose name matches the logical name,	then the
    procedure is executed with the argument '!INTERACTIVE'.

    If <dial-param> is not supplied, then a screen-oriented self-documenting
    <:-)> directory manager is executed; you may scan the directory to
    select a number to dial, as	well as	add, remove and	edit entries.

    5.9.1  Alternate Dialing Directory

    The	default	dialing	directory is ~/.ecu/phone.  You	may change to
    another directory by issuing the interactive dial command with no
    arguments to enter the dialing directory menu, selecting 'c'hange dial
    directory, and entering the	name of	a new directory.  The specified
    pathname must either be a fully qualified pathname or a pathname
    relative to	the current working directory.	Once an	alternate directory
    has	been selected, it will be used by both the interactive command 'dial
    <logical>' and the dialing directory menu.

    Using the dial command with	a directory entry may change the DCD watcher
    (dcdwatch) status.	See the	section	on the dcdwatch	command	for more
    information.

    See	the section below titled "Choosing a Dialout Line" for more
    information	on using "Any" in the "tty" field of a directory entry.



    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      39



    5.9.2  Multi-Number	Redial Cycle

    While in the  dialing directory, you may "mark" one	or more	entries	for
    a cyclical redial attempt.	When any entry is marked, typing ENTER
    (carriage return or	line feed/newline) causes each marked entry to be
    dialed in turn until one of	the remote systems is successfully
    connected.	When a successful connection occurs, ECU unmarks the
    associated entry, leaving the others marked.  Thus,	you may	mark several
    entries and	merely reenter the dialing directory after each	connection
    is finished	and press ENTER	to reenter the redial cycle.  If a single
    entry is marked, ECU pauses	15 seconds between each	dialing	attempt,
    otherwise 5	seconds.  Pressing 'c' will cause the pause to be
    prematurely	terminated and the next	attempt	to be made.  Pressing your
    interrupt key (DEL,	^C or whatever)	aborts the cycle.  If you interrupt
    an active dialing attempt, you will	be prompted as to whether or not you
    wish to cycle to the next entry or abort the cycle.

    If no entries are marked for redial, the current, highlighted directory
    entry is used for dialing.

    To unmark a	single entry, press 'M'	(uppercase M).	To unmark all
    entries, press 'U'.


    5.9.3  Automatic Dialing/Login Procedure

    Upon dialing from the menu,	if a procedure file can	be found in the
    current directory, the user's home .ecu subdirectory or the	ECU library
    subdirectory "ep" (normally	/usr/local/lib/ecu/ep) whose name matches
    the	logical	name, then the procedure is executed with the argument
    '!MENU'.  It is the	responsibility of the automatically executed
    procedure to establish connection with the remote system (by using the
    procedure dial command).  An example of an automatic login procedure can
    be found in	the distribution subdirectory 'models' named 'sysname.ep'.
    A companion	procedure is 'unixlogin.ep'.

    For	example,

    | entry name | telephone number | tty | baud P | ...
    | sysname	 | 555-1234	    | Any | 2400 N | ...














    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      40



    #-----------------------------------------------------------
    # sysname.ep - procedure to	call UNIX-like system 'sysname'
    #
    # CONFIDENTIAL - This function should be chmod 0600	because
    # it contains a password which you probably	don't want to be
    # common knowledge.
    #
    # This procedure calls 'unixlogin.ep' to do	the hard work.
    #-----------------------------------------------------------

	mkvar $s_pwd(20)    # local variable preserves password
	$s_pwd = 'password' # security by disappearing when the
			    # procedure	terminates

    #	also, by keeping the password text off the following line,
    #	the password will not be displayed if you abort	(interrupt)
    #	the procedure

	do 'unixlogin' %argv(0)	'username' $s_pwd 'ansi-or-whatever'



    5.10  DO : perform procedure

    usage: do <procname> [<arg>	... ]


    Perform ECU	procedure.  Ecu	searches for <procname>.ep in the current
    directory.	If the file is not found, the program looks for	the file in
    the	~/.ecu directory and in	the ep subdirectory of the library directory
    (usually /usr/local/lib/ecu/ep).  One or more arguments may	be passed to
    the	procedure.  Arguments are made available in the	called procedure by
    use	of the %argc integer function and %argv	string function.

    Unlike arguments to	the do procedure command, arguments to the do
    interactive	command	are not	quoted and may not contain embedded spaces
    or tabs.



    5.11  DUplex : set/display duplex

    usage: duplex [ Full | Half	]


    This command specifies whether or not ECU is to locally echo characters
    typed by you at the	keyboard.  The overwhelming majority of	remote
    systems provide the	echo function, in which	case full duplex must be
    used.  For the rare	occasions when the remote system does not echo your
    keyboard input, setting half duplex	will allow you to see what you are
    typing.



    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      41



    When communicating with another terminal in	a "teletype conversation",
    setting half duplex	is generally required.	In such	cases, use of the
    nl,	nlin and nlout commands	may also be required.

    The	default	setting	for duplex is full.



    5.12  EXit : drop carrier, exit program

    usage: exit


    This command terminates ECU	promptly.  If your modem does not drop
    carrier upon loss of Data Terminal Ready (DTR), the	command	will
    terminate ECU, but may leave the communications line off hook.  It is
    strongly recommended that you configure your modem to hang up the phone
    line when DTR drops.  A shorthand version of this command exists: '.' is
    equivalent to exit.



    5.13  FI : send text file to line

    usage: fi [<filename>]  [ |	f | e |	s]
			    f full speed transmission
			    e echo pacing
			    s single line transmission



    "file insert": This	command	causes file characters to be inserted into
    the	transmit data stream as	though they had	been entered at	the
    keyboard.  No error	correction is provided,	although XON/XOFF flow
    control is obeyed.

    If <filename> is not entered on the	command	line, a	prompt for the
    filename is	made.  Once the	filename has been entered and file has been
    opened, you	are asked whether the file should be transmitted at full
    speed, by "echo pacing" or by a single line	at a time.  You	may also
    append an 'f', 'e' or 's' argument to the command line.

    If your remote can tolerate	it, full speed transmission is the fastest.
    Some systems are not capable of receiving large amount of data
    ("streaming	data") without pauses.	Even with "full" speed transmission,
    some "pacing" (inter-character delay) is introduced	to ease	loading	on
    the	remote system.	Pressing the interrupt key (DEL) stops a full speed
    transmission.

    By specifying echo pacing, it is possible to increase the likelihood of
    proper receipt.  Echo pacing reads the return data stream to attempt to



    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      42



    keep from overloading the remote.  Pressing	the interrupt key (DEL)
    stops an echo paced	transmission.

    As a last resort, if echo pacing is	not working for	you, (i.e., you	are
    using the command in an environment	where the remote does not echo your
    characters), single	line at	a time transmission is available.  With
    "single" line transmission,	you must press the space key to	initiate
    sending each line.	Pressing the 'ESC' or 's' key stops the	transfer.


    5.14  FKEy : function key definition

    usage: fkey	[<keyset_name>]
	   fkey	-r


    This command allows	the mapping of function	keys F1-F12, PgUp, PgDn, End
    and	Ins and	the cursor up, down, left and right keys to emit a desired
    sequence of	characters when	a function key is pressed.  <keyset_name>
    specifies which key	set in ~/.ecu/keys is to be selected. Sample entry:

	 hayes
	     F1:escape:+ + +
	     F2:autoans:A T S 0	= 1 cr
	     F3:dial:A T D T
	 bbs
	     F1:cancel:^K
	     F2:yes:y cr


    -r resets the key handler to the same state	as when	ECU was	started.
    See	the section above titled "Standard Function Keys".

    If a keyset_name matches a logical dial directory name, it is loaded
    after a connection is established.

    The	characters in the mapped string	may be any printable character or
    one	of the following:
















    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      43



	 map ->	character	map -> character
	 ---	-----------	---    ------------
	 nul	0 000 00 ^@  |	dle    16 020 10 ^P
	 soh	1 001 01 ^A  |	dc1    17 021 11 ^Q
	 stx	2 002 02 ^B  |	dc2    18 022 12 ^R
	 etx	3 003 03 ^C  |	dc3    19 023 13 ^S
	 eot	4 004 04 ^D  |	dc4    20 024 14 ^T
	 enq	5 005 05 ^E  |	nak    21 025 15 ^U
	 ack	6 006 06 ^F  |	syn    22 026 16 ^V
	 bel	7 007 07 ^G  |	etb    23 027 17 ^W
	 bs	8 010 08 ^H  |	can    24 030 18 ^X
	 ht	9 011 09 ^I  |	em     25 031 19 ^Y
	 nl    10 012 0a ^J  |	sub    26 032 1a ^Z
	 vt    11 013 0b ^K  |	esc    27 033 1b ^[
	 ff    12 014 0c ^L  |	fs     28 034 1c ^\
	 cr    13 015 0d ^M  |	gs     29 035 1d ^]
	 so    14 016 0e ^N  |	rs     30 036 1e ^^
	 si    15 017 0f ^O  |	us     31 037 1f ^_



    5.15  FKMap	: funckeymap (function key recognition)	management

    usage: fkmap
	   fkmap <keyname>
	   fkmap <keyname> <keylist>
	   fkmap -r
	   fkmap -s <file>


    This command manages the mechanism ECU uses	to recognize function keys
    when they are entered at the console.  Entering the	command	with no
    arguments displays the current mapping in funckeymap format.

    If supplied, the first argument to the command must	be the recognized
    name of a function key from	the list:

     F1	F2 F3 F4 F5 F6 F7 F8 F9	F10 F11	F12
     Home End PgUp PgDn	CUP CUL	CU5 CUR	CUD

    The	case of	the entered argument is	unimportant.

    If only one	argument is supplied, the mapping for the specified key	is
    displayed.	If more	than one argument is supplied, the keyboard mapping
    is changed.	 Arguments 2-n are character code specifiers in	the format
    used to define a funckeymap	entry.

    WARNING: If	found to be syntactically correct, a mapping change is
    installed immediately.  If incorrect mapping of the	HOME key is
    requested, you may lose control of ECU.




    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      44



    The	-r form	rereads	the original funckeymap	definition (as at program
    invocation), reseting the mapping.	The -s switch saves the	current
    mapping to <file>.


    Examples:

	fkmap f10	display	F10 mapping
	fkmap Home ^Z	map Home to ^Z
			after this command, type ^Z for	Home



    5.16  HAngup : hang	up modem

    usage: hangup


    This causes	DTR to be momentarily interrupted, terminating any
    outstanding	connection.  Your DCE (modem) must be able to drop carrier
    upon loss of DTR.


    5.17  HElp : invoke	help

    usage: help	[<cmd-name>]


    Issuing this command with no argument displays a list of commands
    followed by	a request for a	command	for further information.


    5.18  KBDTest : test keyboard mapping

    usage: kbdtest


    This command runs a	keyboard test which asks you to	press function keys
    (e.g., F1).	 For each key pressed, ECU gives you the actual	character
    sequence generated by the key.  It also tells you which function key it
    recognizes (if any).  mapping of keyboard generated	character sequences
    to ECU internal key	codes.	The command is useful for verifying and
    debugging a	"funckeymap" entry.  To	exit the test at any time, press the
    escape key.










    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      45



    5.19  LLp :	set session log	to /dev/lp

    usage: llp


    This command is a shorthand	version	of 'log	/dev/lp'.  /dev/lp must	not
    be under the control of a print spooler.



    5.20  LOFf : turn off session logging

    usage: loff


    This command is shorthand for 'log off'.  If session logging is active,
    it is turned off.


    5.21  LOG :	session	logging	control

    usage: log [-s] [-r] [ | off | filename ]
	-s "scratch" previous file contents; otherwise append
	-r "raw" logging; otherwise non-printable characters
	    other than tab and newline are omitted from	the log


    This command controls session logging; issuing the command with no
    argument causes the	status of session logging to be	displayed.  The
    special argument 'off' causes active logging to be terminated.  Other
    argument values cause logging to start using the argument as a filename.
    Issuing a log command with a filename when logging is already active
    causes the previous	file to	be closed and the new file to be opened.
    Switches are meaningful only when used in conjunction with a filename to
    start logging.



    5.22  NL : display CR/LF mapping

    usage: nl


    Display the	current	setting	of CR/LF mapping.  For more information,
    refer to the nlin and nlout	command	descriptions.









    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      46



    5.23  NLIn : set receive CR/LF mapping

    usage: nlin	[<y-n>]


    This command controls whether or not a newline (NL/LF) character is	sent
    to the screen upon receipt of a carriage return (CR) from the remote
    system.  Most remote computers supply a NL after CR.  When communicating
    with another terminal in a "teletype conversation",	this is	generally
    not	the case (see also the duplex command).

    Issuing the	command	without	<y-n> causes the current setting to be
    displayed.	The format of <y-n> is flexible: 'y' or	'1' enables
    appending NL to CR,	'n' or '0' causes the feature to be disabled.



    5.24  NLOut	: set transmit CR/LF mapping

    usage: nlout [<y-n>]


    This command controls whether or not a newline (NL/LF) character is	sent
    to the remote system upon transmission of a	carriage return	(CR) entered
    by the keyboard.  Most remote computers do not require (indeed
    "dislike") a NL after CR.  When communicating with another terminal	in a
    "teletype conversation", this is generally not the case (see also the
    duplex command).

    Issuing the	command	without	<y-n> causes the current setting to be
    displayed.	The format of <y-n> is flexible: 'y' or	'1' enables
    appending NL to CR,	'n' or '0' causes the feature to be disabled.



    5.25  OA : octal to	ascii char

    usage: oa [<octal-val>]


    <octal-val>	is a octal value between 0 and 0377; the parity	(sign) bit
    is stripped	and the	equivalent ASCII character value is displayed.

    If no argument is supplied,	a table	of control characters is printed
    containing decimal,	octal, hex, ASCII identifiers and two-character
    control character identifier.








    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      47



    5.26  PARity : set/display line parity

    usage: parity [ None | Even	| Odd ]


    This command controls the parity of	characters transmitted by the
    keyboard.  Issuing the command with	no argument displays the current
    setting.  When the argument	is supplied, only the first character is
    required.  Even or odd parity implies seven	data bits; no parity implies
    eight data bits.  Parity of	incoming characters is not checked.

    The	setting	may be automatically changed as	the result of an interactive
    or procedure dial command.	See the	baud and dial command descriptions.



    5.27  PId :	display	process	ids

    usage: pid


    This command displays the process id of the	ECU transmitter	process, the
    ECU	receiver process and the process ids of	ECU's parent and group.


    5.28  PLog : procedure logging

    usage: plog	[ <filename> | off]


    This command enables or disables procedure logging.


    5.29  POpd : pop to	previous directory

    usage: popd	[ | <#>	| all]


    This command returns to a previous directory after a pushd command has
    been previously executed.

    If no argument is supplied,	the directory at the immediately previous
    level is restored.

    If a numeric argument is supplied, the directory at	the specified level
    is restored; the level numbers may be obtained by issuing a	pushd
    command with no arguments.

    If the 'all' argument is supplied, it is treated as	a numeric argument
    of 0; that is the directory	stack is cleared and the directory at level
    0 is restored.



    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      48



    The	directory stack	is shared between interactive and procedure
    commands.  Neither beginning nor ending a procedure	affects	the
    directory stack level.


    Examples:
       popd
       popd 3
       popd all



    5.30  PTrace : control procedure trace

    usage: ptrace [ on | off | #]
	 on  - set trace state to 1
	 off - set trace state to 0
	 #   - set trace to numeric value #


    This command controls whether or not procedure execution is	to be
    traced. Trace output is written to the screen and varies in	its nature
    depending upon the command being traced.  Specifically, any	change to a
    string or integer variable is noted.  If tracing is	enabled, the output
    will also be written to the	procedure log file (see	the interactive	and
    procedure commands).

    The	majority of procedure tracing features use the current trace state
    as a binary	condition.  That is, either tracing is done or not.
    However, the procedure command expresp emits varying levels	of debugging
    output in a	manner similar to the uucico -x	flag.

    Issuing the	command	with no	argument shows current status.


    5.31  PUshd	: push to new directory

    usage: pushd [ | <dir>]


    This command either	1) saves the current directory pathname	on a stack
    and	establishes a new current directory or 2) displays the current stack
    and	current	directory.  The	stack size is 10.

    If no argument is supplied,	the directory stack is displayed.

    The	directory stack	is shared between interactive and procedure
    commands.  Neither beginning nor ending a procedure	affects	the
    directory stack level.





    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      49



    Examples:
       pushd
       pushd /tmp



    5.32  PWd :	print working directory

    usage: pwd


    This command prints	the current working directory of the ECU process.



    5.33  REDial : redial last number

    usage: redial [<retry-count> [<pause-interval>]]


    This command redials a number previously dialed with the 'dial' command.
    Modem status is tested and multiple	retries	may be made.  <retry-count>
    specifies how many retries are to be made.	<pause-interval> specifies
    how	many seconds the program pauses	after a	failure	to connect.  You
    must specify <retry-count> in order	to specify <pause-interval>.  The
    default value for <retry-count> is 10, for <pause-interval>	is 60.

    You	should know that in some jurisdictions,	it is ILLEGAL to dial the
    same telephone number more than a specified	number of times	during some
    interval of	time.  In any case, a <pause-interval> less than 15 seconds
    is silently	changed	to 15 seconds.


    5.34  REV :	ECU revision/make date

    usage: rev


    This command displays ECU's	revision, the transmitter process id' and
    the	date and time ECU was made.


    5.35  RK : receive via C-Kermit

    usage: rk


    This command invokes C-Kermit to receive files. ECU	searches the PATH
    list for 'kermit' or 'ckermit', expecting to find Columbia University
    C-Kermit version 5A(173) or	later.	The file ~/.kermrc must	be set up to
    have any desired initialization parameters you desire (refer to C-Kermit



    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      50



    documentation for more information).  The remote protocol must have	been
    started prior to the execution of this command.

    WARNING: until further notice, avoid suspending Kermit with	^Z.  ECU is
    totally unprepared to act as a job control process group leader.


    5.36  RS : receive via SEAlink

    usage: rs


    This command invokes a SEAlink receive protocol.


    5.37  RTScts : control RTS/CTS flow	control

    usage: rtscts [ off	| on | no | yes	| 0..7 ]


    This command controls the RTS/CTS flow control feature of the line
    driver (which may or may not work).	 This is a very	confusing area
    though it should not be.

    If no argument is supplied,	the current setting is displayed.
    Specifying 0 or n disables the facility; 1 or y causes RTS/CTS flow
    control to be enabled.

    What the command does is to	manipulate the RTSFLOW and CTSFLOW bits	of
    the	termio c_cflag word (see termio(S)).

    SCO's sio driver before UNIX 3.2v4/ODT 2.0 does half duplex	flow
    control.  FAS does hardware	flow control based on the device magic
    number, but	if you use a device number specifying no hardware flow
    control, RTSFLOW and CTSFLOW can be	used to	specify	SCO-style flow
    control.  CRTSFL offers full duplex	line control on	3.2v4 and later	ONLY
    for	SCO's sio driver.


	  arg |	RTSFLOW	| CTSFLOW    arg | RTSFLOW | CTSFLOW | CRTSFL
	 -----+---------+---------  -----+---------+---------+--------
	  off |	  0	|   0	      0	 |   0	   |   0     |
	  on  |	  0	|   1	      1	 |   0	   |   1     |
	  no  |	  0	|   0	      2	 |   1	   |   0     |
	  yes |	  0	|   1	      3	 |   1	   |   1     |
				      4	 |   0	   |   0     |	 1

    Choice 4 only works	on SCO 3.2v4 and ODT 2.0.  As you can see, numeric
    values are masks.  If the 4	bit is present in the numeric value, it
    overrides the lower-order bits:  Specifying	7 as an	argument specifies
    CRTSFL is to be used if it is supported, otherwise RTSFLOW and CTSFLOW.



    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      51



    Under System V Release 4, an TCGETX/TCSETX manipulation is performed,
    modifying the x_hflag bits as follows:

	 argument | RTSXOFF | CTSXON	argument | RTSXOFF | CTSXON
	 ---------+---------+---------	---------+---------+---------
	   off	  |   0	    |	0	  0	 |   0	   |   0
	   on	  |   0	    |	1	  1	 |   0	   |   1
	   no	  |   0	    |	0	  2	 |   1	   |   0
	   yes	  |   0	    |	1	  3	 |   1	   |   1

    Under SunOS	4.1, only CTS support is provided.  You	should read the
    termio and zs man pages.  Arguments	result in the stated manipulations
    of the termio element c_cflag:

	 argument | CRTSCTS    argument	| CRTSCTS
	 ---------+---------  ----------+---------
	   off	  |   0		  0	|   0
	   on	  |   1		  1	|   1
	   no	  |   0
	   yes	  |   1



    5.38  RX : receive via XMODEM/CRC

    usage: rx


    This command invokes ecurz to receive files	from the remote	system using
    XMODEM/CRC.

    After entering the command,	you are	prompted as to whether or not file
    CR/LF characters are to be converted to newlines.  If you are
    transferring text files from a system which	contain	CR/LF line
    terminators, you must answer yes to	this question.	You should answer no
    when transferring binary files, such as executables, .arc files and	the
    like.  File	transfer progress is presented on a visual display.  To
    abort the transfer,	press your interrupt key (usually DEL unless reset
    with stty(C)).



    5.39  RY : receive via YMODEM Batch

    usage: ry


    This command invokes ecurz to receive files	from the remote	system using
    YMODEM batch with CRC-16 error correction.	The YMODEM is "true YMODEM",
    not	XMODEM-1k.  File transfer progress is presented	on a visual display.
    To abort the transfer, press your interrupt	key (usually DEL unless



    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      52



    reset with stty(C)).



    5.40  RZ : receive via ZMODEM/CRC32

    usage: rz


    This command invokes ecurz to receive files	from the remote	system using
    ZMODEM/CRC32. The remote sender must have been started prior to the
    execution of this command.	File transfer progress is presented on a
    visual display. To abort the transfer, press your interrupt	key (usually
    DEL	unless reset with stty(C)).

    If automatic ZMODEM	frame detection	is enabled and ECU is in the
    interactive	mode, this command is executed automatically.  Automatic
    ZMODEM frame detection is NOT supported during procedure execution.



    5.41  SDNAME : select screen dump file name

    usage: sdname [<filename>]


    When the "cursor 5"	key is pressed,	the screen contents are	dumped to a
    file.  By default, this file is named '~/.ecu/screen.dump'.	 This
    command either displays or changes the current screen dump file name,
    depending upon whether or not a argument is	supplied.

    The	actions	of this	command	have no	effect on the operation	of the
    procedure command.

    See	the section titled "Screen Dump" for more information.


    5.42  SK : send via	C-Kermit

    usage: sk [<file-list>]


    This command invokes C-Kermit to send files. ECU searches the PATH list
    for	'kermit' or 'ckermit', expecting to find Columbia University C-
    Kermit version 5A(173) or later.  The file ~/.kermrc must be set up	to
    have any desired initialization parameters you desire (refer to C-Kermit
    documentation for more information).  The remote protocol must have	been
    started prior to the execution of this command.

    WARNING: until further notice, avoid suspending Kermit with	^Z.  ECU is
    totally unprepared to act as a job control process group leader.



    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      53



    After entering the command,	you are	prompted as to whether or not file
    newline characters are to be converted to CR/LF.  If you are
    transferring text files to a system	which requires CR/LF line
    terminators, you must answer yes to	this question.	You should answer no
    when transferring binary files, such as executables, .arc files and	the
    like.  You are prompted to enter a list of files to	send, which may
    contain one	or more	wildcard specifications.


    5.43  SS : send via	SEAlink

    usage: ss [<file-list>]


    This command invokes a SEAlink file	transmission protocol.


     .--[ Send SEAlink ]-------- dir: /u1/src/ecu ------------------.
     |								    |
     |	File(s)	to send:					    |
     |	___________________________________________________________ |
     |								    |
     |	  TAB:next  ^B:prev  END:perform transfer  ESC:abort	    |
     `-- enter file(s) to send -------------------------------------'



    5.44  STat : verbose status	summary

    usage: stat


    This command displays comprehensive	status and statistics.	Example
    display:




















    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      54



     % stat
    Date: 08-17-1992 05:47:49 (UTC 09:47)
    Communications line: /dev/tty2b 9600-N-1
    XON/XOFF input on output on
    Hardware flow control configuration:
    RTSFLOW off	CTSFLOW	off CRTSFL off
    Not	connected to a remote
    Duplex: full  DCD watcher: off
    Console: /dev/ttyp7	80x43 <pty>
    Acquired by	ecuungetty: /dev/tty2b
    Current directory: /u1/src/ecu
    Total chars	transmitted: 234 (since	CONNECT	142)
    Total chars	received:    2278 (since CONNECT 1478)
    No function	key set	loaded
    Session logging not	active
    Bell notify	is ON
    CR conversion:  incoming CR	 outgoing CR
    Keyboard ESC/funckey time constant = 300 msec
    Pids: xmtr=20878 rcvr=20882	parent=19476 pgrp=19476



    5.45  SX : send via	XMODEM/CRC

    usage: sx [<file-name>]


    This command invokes ecusz to send a file to the remote system using
    XMODEM/CRC.

    After entering the command,	you are	prompted as to whether or not file
    CR/LF characters are to be converted to newlines.  If you are
    transferring text files from a system which	contain	CR/LF line
    terminators, you must answer yes to	this question.	You should answer no
    when transferring binary files, such as executables, .arc files and	the
    like.

    You	are prompted to	enter a	filename to send.  File	transfer progress is
    presented on a visual display.  To abort the transfer, press your
    interrupt key (usually DEL unless reset with stty(C)).

     .--[ Send XMODEM/CRC ]----- dir: /u1/src/ecu -----------.
     |							     |
     |	File to	send:					     |
     |	____________________________________________________ |
     |							     |
     |	Binary:	Y (no NL-CR/LF translation)		     |
     |							     |
     |	 TAB:next  ^B:prev  END:perform	transfer  ESC:abort  |
     `-- enter file(s) to send ------------------------------'




    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      55



    5.46  SY : send via	YMODEM Batch

    usage: sy [<file-list>]


    This command invokes ecusz to send file(s) to the remote system using
    YMODEM/CRC.

    You	are prompted to	enter filename(s) to send, which may consist of	one
    or more wildcard specifications.  File transfer progress is	presented on
    a visual display.  To abort	the transfer, press your interrupt key
    (usually DEL unless	reset with stty(C)).

     .--[ Send YMODEM/CRC ]----- dir: /u1/src/ecu -----------.
     |							     |
     |	File to	send:					     |
     |	____________________________________________________ |
     |							     |
     |	Binary:	Y (no NL-CR/LF translation)		     |
     |							     |
     |	 TAB:next  ^B:prev  END:perform	transfer  ESC:abort  |
     `-- enter file(s) to send ------------------------------'



    5.47  SZ : send via	ZMODEM/CRC32

    usage: sz [<file-list>]


    This command sends files to	the remote system using	ZMODEM/CRC32.  The
    remote receiver must have been started prior to the	execution of this
    command unless the remote has automatic ZMODEM frame detection.

    You	are prompted to	enter filename(s) to send, which may consist of	one
    or more wildcard specifications.  File transfer progress is	presented on
    a visual display.  To abort	the transfer, press your interrupt key
    (usually DEL unless	reset with stty(C)).

    Note: not all ZMODEM receiving software supports transfer of only newer
    files or of	resuming interrupted transfers.	 If the	remote receiver	does
    not	support	the feature, it	may skip (reject) all your files.  Retry the
    transfer specifying	'N' to 'Transfer only newer files' and/or 'Resume
    interrupted	transfer'.










    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      56



    |								     |
    |  File(s) to send:						     |
    |  ckermit-5a-130						     |
    |								     |
    |  Binary: Y (no NL-CR/LF translation)			     |
    |  Overwrite destination files: Y				     |
    |  Send full pathames:  N					     |
    |  Transfer	only newer files:   N				     |
    |  Resume interrupted transfer: N				     |
    |  Window size: 0						     |
    |								     |
    |	  TAB:next  ^B:prev  END:perform transfer  ESC:abort	     |
    `--	enter file(s) to send ---------------------------------------'
    `--	Y: no conversion, N: NLs converted to CR/LF -----------------'
    `--	Y: overwrite, N: protect destination files ------------------'
    `--	Y: full	pathnames, N: strip directory portion from names ----'
    `--	Y: resume transfer at remote file EOF, N send all -----------'
    `--	Y: send	only if	source newer than destination, N send all ---'
    `--	window size (max bytes sent before ACK required) 0 = stream -'



    5.48  TIme : time of day

    usage: time


    This command displays the local date and time as well as the current
    UTC.


    5.49  TTy :	console	tty name

    usage: tty


    This command displays the current console tty name.



    5.50  XA : hex to ascii char

    usage: xa [<hex-val>]


    <hex-val> is a hexadecimal value between 0 and FF; the parity (sign) bit
    is stripped	and the	equivalent ASCII character value is displayed.

    If no argument is supplied,	a table	of control characters is printed
    containing decimal,	octal, hex, ASCII identifiers and two-character
    control character identifier.



    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      57



    5.51  XON :	xon/xoff flow control

    usage: xon [<arg>]
    where <arg>	is on	 input and output flow control
		   off	 no flow control
		   in	 input flow control
		   out	 output	flow control


    This command enables or disables xon/xoff flow control.  If	the argument
    is omitted,	the current flow control state is displayed.


    5.52  ! : execute shell

    usage: !
	   !<command>


    The	'!' command is a shell escape.	The environment	variable SHELL is
    read to determine what shell program to execute (e.g., /bin/sh, etc).
    If '!' is entered by itself, an interactive	shell is started; press	^D
    to exit back to ECU.  If <command> is supplied, it is executed by the
    shell with an immediate return to ECU.






























    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      58



    6.	HoneyDanBer UUCP Interface



    6.1	 Control Files


    This section describes how ecu uses	verious	HDB UUCP control files found
    in the UUCP	library	directory (e.g., /usr/lib/uucp on SCO and ISC or
    /etc/uucp on SunOS and SVR4).


    6.1.1  Devices

    ECU	reads this file	to determine what tty devices are available for
    outgoing calls. The	fourth field must contain a baud rate or range of
    baud rates acceptable for the line.	 The fifth field of each entry must
    contain either the full pathname of	an (SCO) modem dialer program (with
    leading slash) or the name of an entry in the HDB Dialers file (no
    leading slash).  For more information, consult the UUCP documentation
    for	your system and	see "Dialers" and "Choosing a Dialout Line" below.


    6.1.2  Dialers

    Dialers entries may	be specified in	the Devices entry. ECU provides
    Dialers support that is largely compatible with most System	V HDB uucico
    programs.  Refer to	your system's UUCP documentation for general usage
    instructions.  Refer to the	procedure command expresp for a	precise	list
    of escape sequences	supported by ECU.


    6.1.3  Sysfiles

    Sysfiles support is	not yet	provided.  The Devices and Dialers files
    must have their default names.


    6.1.4  Systems

    No use is made of the Systems file at this time.  ECU provides the
    equivalent function	with its dialing directory.


    6.2	 Choosing a Dialout Line


    When using the interactive dial command, or	when dialing from the
    initial menu, if a logical or system name is specified, the	directory
    entry is fetched and examined.  If the tty field specifies a value other
    than "Any",	the specific line requested is opened, if available, and



    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      59



    dialing commences. If the specified	line is	not available, the dial
    attempt fails.

    If "Any" is	found in the dialing directory entry tty field,	then ECU
    finds an available Devices line which matches the baud rate	specified in
    the	entry.

    Other special tty field entries allow regular expression or	literal
    matching of	Devices	types.	See the	description of the  dialing
    directory for more details.

    A line is selected only if its class begins	with the three characters
    "ACU."  UUCP will only select a line whose Devices entry class matches
    the	active Systems entry class (usually "ACU"), so usually you may make
    a modem accessible to ECU, but not to UUCP,	by setting it's	class to
    ACUECU.

    On systems employing ecuungetty, if	a line being considered	for
    selectionis	found to be a line enabled for login, but currently idle,
    the	ecuungetty interface, described	below, is used to acquire the line
    for	outgoing use.

    The	DCD watcher (see the interactive and procedure commands	dcdwatch)
    depends upon the tty driver	to return zero on a read when DCD is low
    when the termio flag CLOCAL	is reset.  The tty driver must ignore DCD if
    CLOCAL is set.  If your system offers a "modem" and	"direct" choice	(by
    choice of filename), you probably need to use the "modem" choice for
    this to work properly.  However, the choice	depends	upon the needs of
    the	underlying driver you are using.  For instance,	if you are using FAS
    in a shared	modem application, your	getty should use the "modem" choice
    and	ECU should use the "direct" choice.  Some experimentation may be
    required.

    One	of the symptoms	of an incorrect	line choice is ECU hangs, line
    errors such	as EIO and EBUSY.  These problems may be caused	by other
    problems, but incorrect line choice	is the most frequent cause.



    6.3	 SCO Tty Naming


    On SCO, TTY	devices	must be	named in the style of:

	 /dev/tty#N
		 ^^
		 ||
		 |`------ uppercase letter for modem control
		 |	  lowercase for	non-modem control
		 `--------digit	(1-4)




    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      60



    If you are using FAS or other third-party driver, you may use ECU with
    ports not normally named in	the /dev/tty#N style in	one of two ways
    under UNIX and one way under XENIX:


	 1.  Under XENIX or UNIX, create a link	to the port
	     with a compatible name:

		   ln /dev/ttyF00 /dev/tty1a
		   ln /dev/ttyFM00 /dev/tty1A

	 2.  Under UNIX, add additional	lines to the
	     /etc/conf/node.d file and rebuild the kernel
	     environment (this is the recommended approach
	     for UNIX):

	 fas ttyF00  c	 48
	 fas tty1a   c	 48
	 fas ttyF01  c	 49
	 fas tty1b   c	 49
	 fas ttyFM00 c	 208
	 fas tty1A   c	 208
	 fas ttyFM01 c	 209
	 fas tty1B   c	 209


    Note the device numbers are	examples only.	Consult	the driver
    documentation for proper choices.

    If you cannot live within this restriction,	search for the #define
    SCO_TTY_NAMING in ecu.h (that depends on SCO's M_SYSV) and disable it.


    6.4	 Ecuungetty (Getty Interface)


    This section applies to the	SCO version of the program.  It	may also
    apply to others in part.  Specifically, as of this writing,	this section
    does not apply to the SunOS	version	due to the differences in utmp
    arrangement.  In some versions, the	mechanism may execute and do no
    harm, yet essentially be a no-op.

    When an idle dialin	(enabled) line is chosen for dialout, ECU makes	use
    of ecuungetty (in the ecu library directory, normally
    /usr/local/lib/ecu)	to signal the line's getty to release the line (via
    SIGUSR1).  Ecuungetty is again employed to signal the getty	to reacquire
    the	line when outgoing communication is complete (via SIGUSR2).

    Ecuungetty is a privileged program,	which must be owned by root and	have
    the	setuid-on-execute bit set.  An encrypted id is passed by ecu to
    ecuungetty to validate requests and	to prevent abuse of ecuungetty by



    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      61



    crackers, malcontents and other twentieth-century phenomena.


    6.5	 SCO Dialer Programs


    The	concept	of a dialer program (an	executable binary as opposed to	a
    Dialers entry) is an SCO enhancement and is	unlikely to be of benefit to
    users of other versions (too bad!).	 ECU will support dialer programs
    under any version, but other users of the Devices file (read "your
    vendor-supplied uucico") will most likely barf on non-SCO systems.

    If the Devices file	can be found in	/usr/lib/uucp, and a valid entry for
    the	attached line can be found, ECU	will use the Dialers script or
    dialer program specified in	the Devices entry.


    6.6	 Gendial Dialer	Package


    Sample SCO-style modem dialer program sources may be found in the
    gendial/ subdirectory of the distribution.	Some of	them, particularly
    dialgHA24 and dialgT2500, are very robust and succeed where	other
    programs may fail.	They retry modem initialization	and reset/hangup
    commands .

    The	code is	divided	into one general module	and several modem- and DCE-
    specific modules.  A program is built by combining the gendial.o with
    the	appropriate dceFOO.o module to produce a dialgFOO executable.

    To write a dialer for a modem not already in the gendial package, copy
    template.c to dceMYMODEM.c and edit	it to contain the necessary variable
    assignments	and initialization, dialing and	hangup code.  The existing
    dce*.c modules provide examples.  Edit the gendial/Make.src	file to	add
    rule lines for your	program.  (Do not modify Makefile alone	since a
    "Configure"	will overwrite Makefile.)


    dialgMYMODEM: gendial.o dceMYMODEM.o
	$(CC) $(LDFLAGS) gendial.o dceMYMODEM.o	$(LIBS)	-o $@


    To be "correct," you should	run the	Configure procedure in the main	ecu
    directory to make a	new Makefile, but this has the unfortunate side
    effect of rebuilding all of	the Makefiles which are	built from Make.src
    files.  If this happens, the next make will	rebuild	all of the objects.

    In this case, it is	"OK" to	cheat and copy the new Make.src	lines to
    Makefile.  A later Configure will not cause	loss of	the new	lines.





    Public Domain by wht@n4hgf				  9/7/92







    ECU	Technical Description				      62



    7.	Exit Codes


    When ECU exits (terminates execution), it uses a code from the following
    table:

    OK			 0    no error
    SIG1		 1    SIGHUP (signal 1)
    SIGN		 64   signal 64	- see below
    LINE_READ_ERROR	 129  could not	read from attached line
    XMTR_WRITE_ERROR	 130  could not	write to attached line
    XMTR_LOGIC_ERROR	 131  software logic error
    BSD4_IOCTL		 132  not currently used
    SHM_ABL		 133  not currently used
    SHM_RTL		 134  not currently used
    NO_FORK_FOR_RCVR	 135  could not	fork receiver process
    TTYIN_READ_ERROR	 136  could not	read from console
    LINE_OPEN_ERROR	 137  could not	attach (open) requested	line
    PWENT_ERROR		 138  error in /etc/passwd processing
    USAGE		 139  command line syntax error
    CONFIG_ERROR	 140  missing or erroroenous configuration file
    CURSES_ERROR	 141  error in curses use
    RCVR_FATAL_ERROR	 142  receiver died unexpectedly
    MALLOC		 143  critical memory allocation failure
    LOGIC_ERROR		 144  internal logic error
    GEOMETRY		 145  unsupported screen geometry
    INIT_PROC_ERROR	 192  initial procedure	terminated in error
    USER1		 193  exit procedure command called with 1
    USERN		 223  exit procedure command called with 31


    The	logical	names 'SIG1' and 'SIGN'	refer to a range of error codes
    signifying ecu termination due to a	signal.	 A larger range	(64) is
    reserved than is necessary to handle reasonable expansion of SIG values
    in the OS. Not all signals will be reported	in this	manner.	ECU will
    never report status	9 (signal 9, SIGKILL), for instance.

    The	logical	names 'USER1' and 'USERN' refer	to a range of error exits
    codes reserved for use by the 'exit' procedure command.  See the
    description	of this	command	for more information.

    For	ecu friend code, formal	C #define identifiers for exit codes may be
    found in termecu.h and consist of the above	logical	names prefixed with
    'TERMECU_'.










    Public Domain by wht@n4hgf				  9/7/92











				    CONTENTS


    1.	Introduction........................................   2

    2.	Basic Organization..................................   3
	2.1   Transmitter Process (XMTR)....................   3
	      2.1.1   Keyboard Interface....................   3
	      2.1.2   ECU Command Assembly..................   3
	      2.1.3   Function Key Mapping..................   4
	      2.1.4   Auxiliary	Operation Control...........   4
	2.2   Receiver Process (RCVR).......................   5
	      2.2.1   ANSI Filter...........................   5
	      2.2.2   Session Logging.......................   5

    3.	Features............................................   6
	3.1   Supported	Terminals...........................   6
	3.2   Host Video Control Sequences..................   7
	      3.2.1   All Local	Consoles (Terminals)........   7
	      3.2.2   Multiscreen Local	Terminals...........   8
	      3.2.3   Character	Mapping.....................   9
	3.3   Function Key Mapping (Recognition)............  10
	3.4   Function Key Actions..........................  13
	      3.4.1   Standard Function	Keys................  13
	      3.4.2   SCO ALT-[a-z] Function Keys...........  15
	3.5   Line Editing..................................  16
	3.6   Screen Dump...................................  17
	      3.6.1   Multiscreen and Non-Multiscreen.......  17
	      3.6.2   Multiscreen Bug.......................  17
	3.7   Interactive Command History...................  18
	3.8   Dialing Directory.............................  18
	3.9   Online Interactive Command Help...............  20
	3.10  Multiscreen Event	Alarm.......................  20
	3.11  Built-in Modem Dialer.........................  21
	3.12  File Transfer.................................  22
	3.13  Automatic	ZMODEM Receive......................  23
	3.14  Procedures (Scripts)..........................  23
	      3.14.1  Initial (Startup)	Procedure...........  23
	      3.14.2  Dialing Procedure.....................  23
	      3.14.3  Other Special Procedures..............  24
	3.15  DCD (Carrier) Watcher.........................  24
	3.16  Home Directory Files..........................  24
	3.17  Lock Files....................................  25
	3.18  Dial-In/Dial-Out Line Support.................  25
	3.19  Tools.........................................  25
	3.20  Shared Memory 'Friend' Interface..............  26

    4.	Starting the Program................................  27
	4.1   Simple Startup - Initial Setup Menu...........  27
	      4.1.1   Destination...........................  27
	      4.1.2   Other Fields..........................  28



			       - i -











	      4.1.3   Keyboard Functions....................  28
	4.2   Command Line Switches and	Arguments...........  29
	      4.2.1   Usage Summary.........................  30
	      4.2.2   Switches..............................  30
		      4.2.2.1	-b <baud>  31
		      4.2.2.2	-d  31
		      4.2.2.3	-e, -o,	-n  31
		      4.2.2.4	-h  31
		      4.2.2.5	-l ttyspec  31
		      4.2.2.6	-p <proc>  32
		      4.2.2.7	-t  32
		      4.2.2.8	-D  32
		      4.2.2.9	-F name	 32
		      4.2.2.10	-P phonedir  33
		      4.2.2.11	-T level  33
	      4.2.3   Non-Switch Arguments..................  33
		      4.2.3.1	<tel-number>  33
		      4.2.3.2	<logical>  33
		      4.2.3.3	<arg>  34
	4.3   Environment Variables.........................  34
	      4.3.1   ECUPROMPT.............................  34
	      4.3.2   ECUHELP...............................  34
	      4.3.3   ECUFUNCKEY............................  34

    5.	Interactive Mode Commands...........................  35
	5.1   AUTORZ : Automatic ZMODEM	Receive.............  35
	5.2   AX : ascii char to hex/oct/dec................  35
	5.3   BAud : set/display line baud rate.............  35
	5.4   BN : all console event alarm..................  36
	5.5   BReak : send break to remote..................  36
	5.6   CD : change current directory.................  36
	5.7   DA : decimal to ascii char....................  37
	5.8   DCDwatch......................................  37
	5.9   Dial : dial remote destination................  38
	      5.9.1   Alternate	Dialing	Directory...........  38
	      5.9.2   Multi-Number Redial Cycle.............  39
	      5.9.3   Automatic	Dialing/Login Procedure.....  39
	5.10  DO : perform procedure........................  40
	5.11  DUplex : set/display duplex...................  40
	5.12  EXit : drop carrier, exit	program.............  41
	5.13  FI : send	text file to line...................  41
	5.14  FKEy : function key definition................  42
	5.15  FKMap : funckeymap (function key recognition)
	      management....................................  43
	5.16  HAngup : hang up modem........................  44
	5.17  HElp : invoke help............................  44
	5.18  KBDTest :	test keyboard mapping...............  44
	5.19  LLp : set	session	log to /dev/lp..............  45
	5.20  LOFf : turn off session logging...............  45
	5.21  LOG : session logging control.................  45
	5.22  NL : display CR/LF mapping....................  45



			       - ii -











	5.23  NLIn : set receive CR/LF mapping..............  46
	5.24  NLOut : set transmit CR/LF mapping............  46
	5.25  OA : octal to ascii char......................  46
	5.26  PARity : set/display line	parity..............  47
	5.27  PId : display process ids.....................  47
	5.28  PLog : procedure logging......................  47
	5.29  POpd : pop to previous directory..............  47
	5.30  PTrace : control procedure trace..............  48
	5.31  PUshd : push to new directory.................  48
	5.32  PWd : print working directory.................  49
	5.33  REDial : redial last number...................  49
	5.34  REV : ECU	revision/make date..................  49
	5.35  RK : receive via C-Kermit.....................  49
	5.36  RS : receive via SEAlink......................  50
	5.37  RTScts : control RTS/CTS flow control.........  50
	5.38  RX : receive via XMODEM/CRC...................  51
	5.39  RY : receive via YMODEM Batch.................  51
	5.40  RZ : receive via ZMODEM/CRC32.................  52
	5.41  SDNAME : select screen dump file name.........  52
	5.42  SK : send	via C-Kermit........................  52
	5.43  SS : send	via SEAlink.........................  53
	5.44  STat : verbose status summary.................  53
	5.45  SX : send	via XMODEM/CRC......................  54
	5.46  SY : send	via YMODEM Batch....................  55
	5.47  SZ : send	via ZMODEM/CRC32....................  55
	5.48  TIme : time of day............................  56
	5.49  TTy : console tty	name........................  56
	5.50  XA : hex to ascii	char........................  56
	5.51  XON : xon/xoff flow control...................  57
	5.52  !	: execute shell.............................  57

    6.	HoneyDanBer UUCP Interface..........................  58
	6.1   Control Files.................................  58
	      6.1.1   Devices...............................  58
	      6.1.2   Dialers...............................  58
	      6.1.3   Sysfiles..............................  58
	      6.1.4   Systems...............................  58
	6.2   Choosing a Dialout Line.......................  58
	6.3   SCO Tty Naming................................  59
	6.4   Ecuungetty (Getty	Interface)..................  60
	6.5   SCO Dialer Programs...........................  61
	6.6   Gendial Dialer Package........................  61

    7.	Exit Codes..........................................  62










			      -	iii -




