/*
 * lsmcheck.c -- check validity of LSM database
 *
 * Lars Wirzenius
 * "@(#)lsmtool:lsmcheck.c,v 1.1.1.1 1994/07/24 16:36:03 liw Exp"
 */

 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <publib.h>
#include "lsm.h"

int main(int argc, char **argv) {
	static struct lsm_database db;
	size_t i;
	FILE *f;

	__set_liberror(__exit_on_error | __complain_on_error);
	set_progname(argv[0], "lsmtool");

	if (lsm_read_database(stdin, &db) == -1)
		errormsg(1, 0, "error in database");

	f = xfopen("bad-entries", "w");

	for (i = 0; i < db.nentries; ++i) {
		if (lsm_check_entry(&db.entries[i]) == -1) {
			lsm_write_one_entry(f, &db.entries[i]);
		}
	}

	return 0;
}
