/*
 * cnvt-2-to-3.c -- convert a version 2 database to a version 3 database
 *
 * Lars Wirzenius
 * "@(#)lsmtool:cnvt-2-to-3.c,v 1.1.1.1 1994/07/24 16:36:03 liw Exp"
 */

 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <publib.h>
#include "lsm.h"


/* The database and the current location in it */
static struct lsm_database db;


static void convert(struct lsm_entry *);


int main(int argc, char **argv) {
	size_t i;
	FILE *f;

	__set_liberror(__exit_on_error | __complain_on_error);
	set_progname(argv[0], "lsmtool");

	if (lsm_read_database(stdin, &db) == -1)
		errormsg(1, 0, "error in database");

	for (i = 0; i < db.nentries; ++i) {
		printf("\r%lu / %lu", (unsigned long) i,
			(unsigned long) db.nentries);
		fflush(stdout);
		convert(&db.entries[i]);
	}
	printf("\n");

	f = xfopen("xxx", "w");
	lsm_write_database(f, &db);
	xfclose(f);

	return 0;
}



static char *field(struct lsm_entry *e, const char *name) {
	char *p;

	p = e->fields[lsm_field_to_index(name)];
	if (p == NULL)
		return "";
	return p;
}


static void delete(struct lsm_entry *e, const char *name) {
	size_t i;
	i = lsm_field_to_index(name);
	free(e->fields[i]);
	e->fields[i] = NULL;
}


static void set(struct lsm_entry *e, const char *name, const char *val) {
	size_t i;
	i = lsm_field_to_index(name);
	free(e->fields[i]);
	e->fields[i] = xstrdup(val);
}


static void convert(struct lsm_entry *e) {
	char *p, buf[10240];

	if (strstr(field(e, "AuthorEmail"), "No address") == NULL) {
		sprintf(buf, "%s (%s)", field(e, "AuthorEmail"),
			field(e, "Author"));
		strgsub(buf, "\n", "", sizeof(buf));
		strcat(buf, "\n");
		set(e, "Author", buf);
	} else
		delete(e, "Author");
	delete(e, "AuthorEmail");

	if (strstr(field(e, "MaintEmail"), "No address") == NULL) {
		sprintf(buf, "%s (%s)", field(e, "MaintEmail"),
			field(e, "Maintainer"));
		strgsub(buf, "\n", "", sizeof(buf));
		strcat(buf, "\n");
		set(e, "Maintained-by", buf);
	}
	delete(e, "MaintEmail");
	delete(e, "Maintainer");

	if (field(e, "Comments")[0] != '\0') {
		sprintf(buf, "%s\n\t%s\n", field(e, "Description"),
			field(e, "Comments"));
		strrtrim(buf);
		strcat(buf, "\n");
		set(e, "Description", buf);
		delete(e, "Comments");
	}

	if (field(e, "CopyPolicy")[0] != '\0')
		set(e, "Copying-policy", field(e, "CopyPolicy"));
	delete(e, "CopyPolicy");

	p = field(e, "Location1");
	if (*p != '\0') {
		char *site = strtok(p, " \t\n:");
		char *file = strtok(NULL, " \t\n(");
		char *size = strtok(NULL, " \t\n()");
		if (site == NULL)
			site = "unknown.site";
		if (file == NULL)
			file = "/unknown/file";
		if (size == NULL || strcmp(size, "0") == 0)
			size = "";
		sprintf(buf, "%s\n\t%s %s\n", site, size, file);
		set(e, "Primary-site", buf);
	}

	delete(e, "DateEntered");
	delete(e, "EmailEntered");
	delete(e, "Location1");
	delete(e, "Location2");
	delete(e, "Location3");
	delete(e, "Location4");
	delete(e, "Location5");
	delete(e, "Location6");
	delete(e, "Location7");
	delete(e, "Location8");
	delete(e, "RelatedFiles");
	delete(e, "Required");
	delete(e, "WhoEntered");

	if (field(e, "Title")[0] == '\0')
		set(e, "Title", "?\n");
	if (field(e, "Version")[0] == '\0')
		set(e, "Version", "?\n");
	if (field(e, "Primary-site")[0] == '\0')
		set(e, "Primary-site", "?\n\t?\n");
	if (field(e, "Description")[0] == '\0')
		set(e, "Description", "?\n");
}
