/* -*- c -*- */

/* Modified on Sat, Aug 26 1995 */
/*   by Leander Jedamus (jedamus@Worms.Fh-Rpl.DE). */

%{

#include <malloc.h>
#include <stdio.h>
#include <string.h>

/* #define DEBUG */

FILE *out = stdout;

char buf[2048], sectname[256], labeltxt[256];
char firstname[256], outname[256];
char ssectname[256], Tmp1[4096], Tmp2[256], headname[256];
char urlname[256], Headbuf[4096], refname[256];

int filenum = 1;
int filecount = 1;
int tmpfn;
int secnr = 0;
int ssecnr;
int current;
int skipnewline = 0;

#define CHAPTER 1
#define SECTION 2
#define SUBSECT 3

int getstr( char *str, int n )
  {
    int i;
#ifdef DEBUG
    fprintf( stderr, "DEBUG: yytext: <<%s>>\n", yytext );
#endif
    if( strlen( yytext ) == n )
      return 0;
    strncpy( str, yytext+n, yyleng-n);
    str[ yyleng-n ] = 0;
    return 1;
  }

struct lprec
  {
    char *label;
    int fileno;
    struct lprec *next;
  };

typedef struct lprec lprec;

lprec *putlp();
lprec *getlp();

lprec *lp_table = (lprec *)0;
lprec *tmplp;

lprec *
putlp( char *lbl, int fn )
  {
    lprec *ptr;
    ptr = (lprec *) malloc (sizeof (lprec));
    ptr->label = (char *) malloc (strlen (lbl) +1 );
    strcpy( ptr->label, lbl );
    ptr->fileno = fn;
    ptr->next = (struct lprec *)lp_table;
    lp_table = ptr;
    return ptr;
  }

lprec *
getlp( char *lbl )
  {
    lprec *ptr;
    for (ptr = lp_table; ptr != (lprec *) 0;
	 ptr = (lprec *)ptr->next)
      if (strcmp (ptr->label,lbl) == 0)
	return ptr;
    return 0;
  }

void heading( FILE *out, char *titlename )
  {
    fprintf( out, "<HTML>\n<HEAD>\n<TITLE>%s</TITLE>\n", titlename );
    fprintf( out, "</HEAD>\n<BODY>\n" );
  }

void footing( FILE *out )
  {
    fprintf( out, "</BODY>\n</HTML>\n" );
  }

%}

%s SECT

%%

^"<@@url>".*$		{

    skipnewline=1;
    getstr( urlname, 7 ); 
    sprintf( Headbuf, "<A HREF=\"%s\">", urlname);
}

^"<@@urlnam>".*$	{
    sprintf( Tmp1, "%s</A>", urlname);
    strcat (Headbuf, Tmp1);
}

^"<@@endurl>".*$	{

    skipnewline=0;
    fprintf( out, "%s", Headbuf);
    strcpy (Headbuf,"");
}

^"<@@title>".*$ 	{

    strcpy( sectname, yytext+9 );
    heading( stdout, sectname );
    printf( "<H1>%s</H1>\n", sectname );
}

^"<@@head>".*$		{

    skipnewline=1;
    getstr( headname, 8 ); 
    sprintf( Headbuf, "<H3>%s", headname);
}

^"<@@endhead>".*$	{

  fprintf( out, "%s", Headbuf );
  strcpy(Headbuf, "");
  switch (current){
  case CHAPTER:
      current=0;
      break;
  case SECTION:
      current=0;
      fprintf( out, "</H1>\n<P>\n<A HREF=\"%s.html#toc%d\">Contents of this section</A></P>\n",firstname,secnr);
      break;
  case SUBSECT:
      current=0;
      fprintf( out, "</H2>\n");
      break;
  default:
      current=0;
      fprintf( out, "</H3>\n");
      break;
  }
  skipnewline=0;
}

^"<@@sect>".*$		{ 

    skipnewline=1;
    getstr( sectname, 8 ) ;
    if( out != stdout ) 
      {
        footing( out );
	fclose( out );
      }
    current=SECTION;
    secnr++;
    ssecnr=0;
    sprintf( outname, "%s-%d.html", firstname, filenum++ );
    out = fopen( outname, "w" );
    heading( out, sectname );
    sprintf( Headbuf, "<H1>%d. <A NAME=\"s%d\"></A>%s",secnr, secnr, sectname );
    fprintf( stdout, "<P>\n<H2><A NAME=\"toc%d\"></A>",secnr);
    fprintf( stdout, "%d. <A HREF=\"%s\">%s</A></H2>\n<UL>\n", secnr, outname,
	    sectname );
}

^"<@@ssect>".*$          { 

    skipnewline=1;
    getstr( ssectname, 9 ) ;
    current=SUBSECT;
    ssecnr++;
    sprintf( Headbuf, "<H2>%d.%d <A NAME=\"ss%d.%d\"></A> %s",secnr, ssecnr, secnr, ssecnr, ssectname );
    fprintf( stdout, "<LI><A HREF=\"%s#ss%d.%d\">%d.%d %s</A>\n", outname, secnr, ssecnr, secnr, ssecnr,
            ssectname );
}

^"<@@chapt>".*$		{

getstr( sectname, 9 );
sectname[ yyleng-14 ] = 0;
printf( "<H1>%s</H1>\n", sectname );
}

^"<@@endchapt>".*$	;

^"<@@endsect>".*$	{

fprintf(out,"<HR>\n");
if (filenum<filecount) {
  sprintf(Tmp2,"%s-%d.html",firstname, (filenum ));
  fprintf(out, "<P>\n<A HREF=\"%s\">Next</A> Chapter", Tmp2 );
}
if (filenum>=3) {
  if(filenum<filecount)
  {
    fprintf(out, ",\n");
  }
  else {
    fprintf(out, "<P>\n");
  }
  sprintf(Tmp1,"%s-%d.html",firstname, (filenum - 2));
  fprintf(out, "<A HREF=\"%s\">Previous</A> Chapter\n", Tmp1 );
}

sprintf(Tmp2,"%s.html",firstname);
fprintf(out, "<P>\nTable of contents of <A HREF=\"%s#toc%d\">this chapter</A>,\n",Tmp2, filenum-1 );
fprintf(out, " General <A HREF=\"%s#toc\">table of contents</A></P>\n",Tmp2);
fprintf(out, "<P>\n<A HREF=\"%s\">Top</A> of the document,\n <A HREF=\"#0\"> Beginning of this Chapter</A></P>\n",
                   Tmp2);
fprintf(stdout,"</UL>\n");
footing( out );
fclose(out); out = stdout;
}

^"<@@endssect>".*$       {
}

^"<@@enddoc>".*$      ;

^"<@@sectcount>".*$   {

  if (sscanf( yytext, "<@@sectcount>%d", &filecount ) != 1)
  {
    fprintf( stderr, "Problem with @@sectcount!\n");
  }
  else
  {
    filecount++;
  };
};


<SECT>^"<@@label>".*$	{
  
  strcpy( sectname, yytext+9 );
  if (!getlp( sectname ))
    {
      fprintf( stderr, "Problem with @@label!\n" );
    } 
  else
    {
      strcpy( labeltxt, sectname );
    }
}

^"<@@label>".*$		{
  
  strcpy( sectname, yytext+9 );
  if (!getlp( sectname ))
    {
      fprintf( stderr, "Problem with @@label!\n" );
    } 
  else
    {
      if( skipnewline ) {
        sprintf( Tmp1, "<A NAME=\"%s\"></A> %s", sectname, Headbuf);
	strcpy (Headbuf, Tmp1);
	strcpy (Tmp1,"");
      } else {
        fprintf( out, "<A NAME=\"%s\"></A> ", sectname );
      }
    }
}


^"<@@labelp>".*$	{

#ifdef DEBUG
fprintf( stderr, "DEBUG: yytext = <<%s>>\n", yytext );
#endif
if (sscanf( yytext, "<@@labelp>%[^#]#%d", sectname, &tmpfn ) != 2)
{
  fprintf( stderr, "Problem with @@labelp!\n" );
#ifdef DEBUG
fprintf( stderr, "DEBUG: sectname = <<%s>>\n", sectname );
fprintf( stderr, "DEBUG: tmpfn = <<%d>>\n", tmpfn );
#endif
} else
putlp( sectname, tmpfn );

}

^"<@@ref>".*$           {

strcpy( refname, yytext+7 );
if (!(tmplp = getlp( refname )))
{
  fprintf( stderr, "Problem with @@ref!\n" );
  skipnewline++;
} else {
  
  if(tmplp->fileno==secnr) {
    sprintf( Tmp1, "<A HREF=\"#%s\">", refname );
  } else if(tmplp->fileno==0) {
    sprintf( Tmp1, "<A HREF=\"%s.html#%s\">", firstname, refname );
  } else { 
    sprintf( Tmp1, "<A HREF=\"%s-%d.html#%s\">", firstname, tmplp->fileno,
              refname );
  }

  if(skipnewline) {
     strcat( Headbuf, Tmp1);
  } else {
     strcpy( Headbuf, Tmp1);
  }
  skipnewline++ ;
}
}

^"<@@refnam>".*$	{

   sprintf( Tmp1,"%s</A>", refname );
   strcat ( Headbuf, Tmp1);
}

^"<@@endref>".*$	{

   switch (skipnewline) {
   case 1:
     fprintf( out, "%s", Headbuf );
     break;
   case 2:
     break;
   default:
     fprintf( stderr, "Problem with @@endref!\n" );
     break;
   }
   skipnewline--;
}

<SECT>^.*$		{ 

getstr( sectname, 0 );

if( out != stdout ) 
{
  footing( out );
  fclose( out );
}
sprintf( outname, "%s-%d.html", firstname, filenum++ );
out = fopen( outname, "w" );
heading( out, sectname );
if( strlen( labeltxt ))
{
  fprintf( out, "<A NAME=\"%s\"></A>\n", labeltxt );
  labeltxt[0] = 0;
}
fprintf( out, "<H1>%s</H1>", sectname );
fprintf( stdout, "<H2> <A HREF=\"%s\">%s</A></H2>\n", outname,
	sectname );

BEGIN(0);
}

.*			{

if (skipnewline) {
    strcat(Headbuf, yytext );
  } else if( out != stdout ) {
    fprintf( out, "%s", yytext );
  } else {
    ECHO;
  }
}

\n			{

if(!skipnewline) {
  if( out != stdout )
  {
    fprintf( out, "%s", yytext );
  }
  else
  {
    ECHO;
  }
}
}


%%

void
main( int argc, char **argv )
{
  if( argc >= 2 )
    {
      strncpy( firstname, argv[1], 256 );
    }
  else
    {
      strcpy( firstname, "$$" );
    }

  secnr=0;
  yylex();
  footing( stdout );

  if( out != stdout )
    {
      footing( out );
      fclose( out );      
    }

  exit( 0 );
}
