;#########################################################################################
; Procedure: ExpandResource
;
; About:  This procedure is designed to decompress *.qck files that were compiled
;	into the resource script as RC_DATA.  In order to use this function you
;	need to pass two parameters. 
;
;		1 - A handle to a resource's locked memory
;		2 - The address of dest filename including path
;		3 - Size of the resource data
;
;			EXAMPLE:
;				invoke FindResource,hInst,ADDR szFileName,RT_RCDATA
;				mov	hRes, eax
;			
;				invoke ExpandResource, hRes, ADDR szDestName, Src_Size			
;
;				.if eax == 0
;					jmp	err
;				.endif
;
;
;		This procedure does the rest of the work for you.
;#########################################################################################
;#########################################################################################
;########################################################################
; ExpandFile Function
;########################################################################
ExpandResource proc hSrcMemory:DWORD, lpDestName:DWORD, Src_Size:DWORD
	
	;=========================================
	; Code to decompress the chosen resource
	;=========================================

	;=====================================
	; define all of the local variables
	;=====================================
	LOCAL	Char_In:BYTE
	LOCAL Char_Out:BYTE
	LOCAL Prev_Char1:BYTE
	LOCAL Prev_Char2:BYTE
	LOCAL Bit_Mask:BYTE
	LOCAL pcTable:DWORD
	LOCAL Num_In_Mask:BYTE
	LOCAL	hDest_Memory:DWORD
	LOCAL	Spot:DWORD
	LOCAL Dest_index:DWORD
	LOCAL hRFile:DWORD


	;==============================================
	; Allocate worst case scenario memory
	; for compression program
	;==============================================
	mov	eax, Src_Size
	shl	eax, 4
	invoke GlobalAlloc, GMEM_FIXED, eax
	mov	hDest_Memory, eax
	mov	Dest_index, 0

	;===============================
	; test for an error
	;===============================
	.if eax == 0
		jmp	err
	.endif

	;======================================
	; Allocate memory for our table
	;======================================
	invoke GlobalAlloc, GMEM_FIXED,  32768
	mov	pcTable, eax

	;========================================
	; Set to ascii 32 because it's most used
	;=========================================
	invoke RtlFillMemory, pcTable, 32768, 20h

	;=====================================
	; Initialize file vars just in case
	;=====================================
	mov	Dest_index, 0
	mov	Spot, 0
	mov	Bit_Mask, 0
	mov	Prev_Char1, 0
	mov	Prev_Char2, 0
	mov	Num_In_Mask, 0

	;======================================
	; get the byte from file
	;======================================
	jmp	tstEOF
top:	mov	eax, Spot
	.if eax <= Src_Size
		mov	ebx, hSrc_Memory
		add	ebx, Spot
		mov	al, BYTE PTR [ebx]
		mov	Char_In, al
		inc	Spot
		
	.endif

	;==================================
	; Put it into the mask for the loop
	;===================================
	mov	Bit_Mask, al

	;====================================
	; Loop for every bit in the mask
	;====================================
	mov	Num_In_Mask, 0
msk:
	cmp	Num_In_Mask, 8
	je	StopFor

	;====================================
	; Find out if we predicted this char
	;====================================
	mov	al, Bit_Mask
	mov	dx, 1
	mov	cl, Num_In_Mask
	mov	ah, 0
	shl	dx, cl
	test	ax,dx
	je	notpred

	;===================================
	; Yes, we predicted it, so process
	;===================================
	mov	bl, Prev_Char1
	mov	bh, 0
	mov	dl, Prev_Char2
	mov	dh, 0
	shl	bx, 7
	xor	bx, dx
	push	bx
	xor	ebx, ebx
	pop	bx
	mov	eax, pcTable
	add	eax, ebx
	mov	cl, BYTE PTR [eax]
	mov	Char_Out, cl

	;=============================
	; Jump over not pred
	;=============================
	jmp	donepred		


	;===============================
	; We didn't predict this one
	;===============================
notpred:
	;=============================
	; Read in the character we
	; will write out
	;=============================
	mov	eax, Spot
	.if eax <= Src_Size
		mov	ebx, hSrc_Memory
		add	ebx, Spot
		mov	cl, BYTE PTR [ebx]
		mov	Char_Out, cl
		inc	Spot

	.endif
		
	;============================
	; Update the table
	;============================	
	mov	bl, Prev_Char1
	mov	bh, 0
	mov	dl, Prev_Char2
	mov	dh, 0
	shl	bx, 7
	xor	bx, dx
	push	bx
	xor	ebx, ebx
	pop	bx
	mov	eax, pcTable
	add	eax, ebx
	mov	cl, Char_Out
	mov	BYTE PTR [eax], cl
	
donepred:
	;=============================
	; Write the character out to
	; our destination memory
	;=============================
	mov	ebx, hDest_Memory
	add	ebx, Dest_index
	mov	cl, Char_Out
	mov	BYTE PTR [ebx], cl
	inc	Dest_index

	;=============================
	; Shift the characters over
	;=============================
	mov	al, Prev_Char2
	mov	bl, Char_Out
	mov	Prev_Char2, bl
	mov	Prev_Char1, al

	;==========================
	; Inc and go back to mask
	; processing
	;==========================
	inc	Num_In_Mask
	jmp	msk	

	;===========================
	; Get another byte and do 
	; it again
	;===========================
StopFor:

	;=============================
	; Test to see if we are over
	; limit for source
	;=============================
tstEOF:
	mov	eax, Spot
	.if eax > Src_Size
		jmp	done
	.endif

	;===============
	; Do it again
	;===============
	jmp	top

done:
	;======================================
	; Create the file to write to
	;======================================
	invoke CreateFile, lpDestName, GENERIC_READ or GENERIC_WRITE, \
		FILE_SHARE_READ, NULL,OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL,NULL
	mov	hRFile, eax

	;===============================
	; Test for an error
	;===============================
	.if eax == INVALID_HANDLE_VALUE
		jmp err
	.endif

	;======================================
	; Write to the file
	;======================================
	invoke WriteFile, hRFile, hDest_Memory, Dest_index, hRes, NULL

	;======================================
	; Tets for an error
	;======================================
	.if eax == 0
		;=========================
		; Jump to error
		;=========================
		jmp	err

	.endif

	;======================================
	; Close the handle to the file
	;======================================
	invoke CloseHandle, hRFile

	;===============================
	; Release the allocated memory
	;===============================
	invoke GlobalFree, hDest_Memory
	invoke GlobalFree, pcTable

	return 1

err:
	return 0	
         
ExpandResource endp
;########################################################################
; END of ExpandResource				    
;########################################################################

