	.XLIST
	PAGE	60,132
	TITLE	CDLANFIX: (SYS) - MSCDEX file sharing patch, v1.0 [06/01/89]
	SUBTTL	Copyright (c) 1989 Software Research ... All Rights Reserved
	.LIST


	NAME	CDLANFIX

	COMMENT	\

        Tech-notes for: Software Research "CDLANFIX", Version 1.0 - Beta
          Release date: May, 31st, 1989

        To rebuild "CDLANFIX.SYS" enter the following command line.  Note
        that Microsoft MASM level 5.1 is required!

            MAKE [OPT={optional MASM Switches (i.e. /L /C)}] CDLANFIX


                                   -----------
                                   Description
                                   -----------

	CDLANFIX's purpose is to translate DOS file open  calls (03DH) of
	the "Deny None" mode into "Compatibility" mode when  accessing an
	"MSCDEX" supported CD-ROM device which is being Redirected by the
	Lantastic Network extensions.

	DOS Function 3DH:
   	Entry:
		AH = 03DH	- INT 21 Function call.
		DS:DX = ASCIIZ	- Path/Name for DOS file handle open.
		AL = Open mode	- Bit decoded (see below):

		 7   6 5 4  3  2 1 0  - bit position
		<I>  <-S-> <R> <-A->  - field definition (see below):

		    I - Inheritance flag:
			0 = file is inherited by child processes.
			1 = file is private to the current process.

		    S - Sharing mode:
			000 = Compatibility mode.
			001 = Deny Read/Write mode (exclusive).
			010 = Deny Write mode.
			011 = Deny Read mode.
			100 = Deny None mode.

		    R - Reserved (should always be 0).

		    A - Access:
			000 = Read access.
			001 = Write access.
			010 = Read/Write access.



                                   ------------
                                     So What?
                                   ------------

	The  reason  for  using  CDLANFIX is  that shared-mode file opens
	issued  by  Microsoft's  Basics  actually   perform  several  DOS
	function  calls;  the 3DH function being only the first of these.
	The open is  followed by a get  "File Date"  call (057H),  then a
	"I/O Control: Get Info" call (044H), then (and here's the clinker
	under the LAN) two "LSeek" calls (042H).  These are done by Basic
	to determine the actual size of the file being opened in  "Random
	Read" mode.  The first call moves the file Read/Write pointer all
	the  way to  the  end of  the open  file  handle  and returns the
	location in  AX:DX - this  value is  recorded by Basic for future
	reference.  The second call places the  pointer back to the files
	beginning.


                                  -------------
                                  Configuration
                                  -------------

	CDLANFIX  is  placed  into the DOS environment via  the "DEVICE="
	statement of the  CONFIG.SYS  system  options  file.  The options
	contained in this statement (syntax) are as follows:

		DEVICE=CDLANFIX.SYS DriveList

        where: (DriveList) designates a comma delimited list of the redi-
	       rected CD-ROM drive letters.

	CAUTION! CDLANFIX  does not do a  check on  the  specified drives
		 to  verify that  they  are  actually redirected "MSCDEX"
		 supported devices.  (Be  sure  to  specify  the  correct
		 drives when invoking)


                                    --------
                                    Examples
                                    --------

	1) MSCDEX Driver installed for one CD-ROM device whose local drive
	   letter assignment is E:. Lantastic is being used to redirect it
	   as P:

		DEVICE=CDLANFIX.SYS P:


	1) MSCDEX Driver installed for two CD-ROM devices whose local drive
	   letter assignments are D: and E:. Lantastic is redirecting these
	   as H: and L:

		DEVICE=CDLANFIX.SYS H:,L:
	\
PAGE
; Setup environment for MASM.

CODE	Segment	Public 'Code'
	Assume	CS:Code,DS:Code,ES:Code
	Org	0

	; General equates.

CR	EQU	 13			; ASCII carriage return.
LF	EQU	 10			; ASCII line feed.
EOM	EQU	 36			; MS-DOS end of string print '$'.

	; DOS open call (03DH) mode bit definitions (Reg AL).

A_BITS	EQU	111B SHL 0		; Access   bits (fielded position).
R_BIT	EQU	  1B SHL 3		; Reserved bit  (fielded position).
S_BITS	EQU	111B SHL 4		; Share    bits (fielded position).
I_BIT	EQU	  1B SHL 7		; Inherit  bit  (fielded position).

	; Device driver header.

HEADER	DD	-1			; SEG:OFF (thread) to next driver, -1 is end.
	DW	0A000H			; attribute word.
	DW	S_ENTRY			; device "strategy" entry point.
	DW	I_ENTRY			; device "Interrupt" entry point.
	DB	'CdLanFIX'		; device ID.
PAGE
; Device Driver "Strategy Routine"

; Each time a request is made for this device, the BDOS
; first calls "Strategy routine",  then immediately calls
; the "Interrupt routine".  

	; The Strategy routine is passed the address of the
	; Request Header in ES:BX, which it saves in a local
	; variable and then returns to the BDOS.

S_ENTRY	Proc	Far			; save Request Header address.
	MOV	Word Ptr CS:[RQH_PTR.0],BX
	MOV	Word Ptr CS:[RQH_PTR.2],ES
	RET				; back to BDOS.
S_ENTRY	Endp

; Device Driver "Interrupt Routine"

; This entry point is called by the BDOS immediately after 
; the call to the "Strategy Routine", which saved the long
; address of the Request Header in the local variable "RQH_Ptr".

	; The "Interrupt Routine" uses the Command Code passed in
	; the Request Header to transfer to the appropriate device
	; handling routine.  Each command code routine is responsible
	; for any necessary return information into the Request Header,
	; then transfers to Error or Exit to set the Return Status code.

I_ENTRY	Proc	Far
	PUSH	ES			  ; Save registers.
	PUSH	DI
	LES	DI,[RQH_PTR]		  ; ES:DI = Request Header addr.
	CMP	Byte Ptr ES:[DI.2],0	  ;    00 = Command Code?
        JG	UNKCMD			  ; too big, exit with error code
	JMP	Near Ptr INIT		  ; go perform initialization.

UNKCMD:	MOV	Word Ptr ES:[DI.3],8103H  ; set "Unknown" command error.
	POP	DI			  ; Restore registers.
	POP	ES
	RET				  ; Back to BDOS.
I_ENTRY	Endp

	; Local storage used by the Strat/Int DOS thread.

RQH_PTR		DD	?		; R.Q.H. pointer passed to SENTRY.

	; This is the beginning of the free memory region if the patch
	; extensions must be removed (the Header/Strat/Int must remain).

EXT_NOT_REQ	Equ	$

	; Local storage used by the resident patch.

DOS_MANAGER	DD	?		; intercepted DOS INT 21 Handler.

	; The  following  two words (32 bits)  map the 26 possible letter
	; assignments to which the  CDROM may be  redirected via the LAN.
	; The Correspondence of these individual bits being:
	; Bit_0 = A:, Bit_1 = B:, ... Bit_25 = Z:.
	; A bit in the on state (Boolean True) indicates that the associ-
	; ated  drive  is a  redirected  CDROM device requiring file open
	; testing by this patch for possible sharing-mode/LAN problems.

DRIVE_MASK_LO	DW	?		; drive map A: - P:
DRIVE_MASK_HI	DW	?		; drive map Q: - Z:
PAGE
; Dos INT 21 Extension handler:
; ------------------------------------
; The augmented function is:
;   3D - Open handle.
;-------------------------------------
	; Called with:
	; -----------
	; AH = FUNCTION number (03DH).
	; AL = Open mode.
	; DS:DX = Asciiz path\filename string.

	; Output:
	; ------
	; AX = Error codes if carry set, 16bit file handle if not.

FILE_EXTENSIONS	Proc	Far
	CMP	AH,03DH			; open handle call?
	JNE	NORMAL_HANDLER
	TEST	AL,A_BITS		; open for read?
	JNZ	NORMAL_HANDLER
	TEST	AL,S_BITS		; shared mode call?
	JZ	NORMAL_HANDLER
	XCHG	BX,DX			; get a valid memory pointer.
	CMP	Byte Ptr DS:[BX.1],':'	; drive letter spec'ed?
	XCHG	BX,DX			; restore registers.
	JNE	NORMAL_HANDLER

	; ... CD-ROM file access test ...

TEST_FOR_CDROM:
	PUSH	CX			; save caller's register state.
	PUSH	AX

	XCHG	BX,DX			; get a valid memory pointer.
	MOV	CL,[BX]			; get letter to check.
	XCHG	BX,DX			; restore registers.
	AND	CL,05FH			; uppercase conversion.
	SUB	CL,'A'			; convert to binary 0-25.
	MOV	AX,1			; initialize bit mask.
	ROL	AX,CL			; build bit mask.
	CMP	CL,15			; fit in bits 0-15?
	JA	TEST_HI_BITS		; no, goes in high-word (Q:-Z:).
	TEST	CS:DRIVE_MASK_LO,AX	; check drive (A: - P:).
	JMP	Short BRANCH_TEST	; proceed based on results.

TEST_HI_BITS:
	TEST	CS:DRIVE_MASK_HI,AX	; check drive (Q: - Z:).

BRANCH_TEST:
	POP	AX			; restore caller's state.
	POP	CX			; ... ready for possible alteration.
	JZ	NORMAL_HANDLER		; mode translation not needed.

	; ... modify open request for compatibility mode ...

	AND	AL,NOT S_BITS		; clear all Share bits.

	; ... exit TSR and proceed to DOS BIOS with request ...

NORMAL_HANDLER:
	JMP	CS:DOS_MANAGER		; service provided by normal handler.
FILE_EXTENSIONS	Endp

	; This is the beginning of the free memory region if the patch
	; extensions are to remain resident.

EXT_IS_REQ	Equ	$
PAGE
; Device Driver "Initialization Routine"

; The following initialization code is called only once when the driver is
; loaded.  It is responsible for initializing the hardware, setting up any
; necessary interrupt vectors, and it must return the address of the first
; free memory after the driver to the BDOS.

	; Called with:
	; ------------
	; Request Header + 18 - DWORD: pointer to the first character following
	;			the "=" character on the CONFIG.SYS line which
	;			loaded this driver.
	;			This parameter string is Read Only.
	;			If it ends in a CR, then parameters are present.
	;			If it ends in a LF, no parameters are present.
	;		 + 22 - BYTE: drive letter for the first unit number of
	;			next available block device that DOS will be
	;			using, i.e. 0=A, 1=B, etc., (block devices only)
	;			Note: Parm only present in DOS ver 3.0 or later!
	; Returns:
	; --------
	; Request Header +  3 - WORD: Results of initialization operation.
	;		 + 13 - BYTE: Number of units (block devices only).
	;		 + 14 - DWORD: Address of first free memory above driver.
	;		 + 18 - DWORD: B.P.B. pointer array (block devices only).
	;

	; General messages ...

SIGNON	DB	CR,LF,"CDLANFIX: (SYS) - MSCDEX file sharing patch, v1.0 [May 1st, 1989]"
	DB	CR,LF,"Copyright (c) 1988 Software Research ........ All Rights Reserved"
	DB	CR,LF,LF,"  ",EOM

NOPRMS	DB	CR,LF, 7,"ERROR: No installation parameters were specified!"
	DB	CR,LF,LF,"  Example case:"
	DB	CR,LF,LF,"      MSCDEX Driver installed for two CD-ROM  devices whose local drive"
	DB	CR,LF,   "      letter assignments are D: and E:.  Lantastic is redirecting these"
	DB	CR,LF,   "      as H: and L:"
	DB	CR,LF,LF,"  Syntax for case:"
	DB	CR,LF,LF,"      DEVICE=CDLANFIX.SYS H:,L:"
	DB	CR,LF,LF,EOM

DVLTR	DB	"x: ",EOM

DVMSG	DB	"- placed under CDLANFIX management ..."
	DB	CR,LF,LF,EOM
PAGE
	; Sign-on before processing for environment.

INIT	Proc	Far
	PUSH	DS			; save BDOS's environment.
	PUSH	AX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	BP
	PUSH	BX

	PUSH	CS			; localize the Data Segment.
	POP	DS
	CLD				; all string opps are ascending.

	PUSH	ES			; save Request Header address.
	PUSH	DI
	MOV	BP,SP

	MOV	AH,9			; print the sign-on message.
	MOV	DX,Offset SIGNON
	INT	21H

	; Parse the command line for parameters.

	MOV	ES,[BP.2]		; restore the RQH address.
	MOV	DI,[BP.0]
	LES	DI,Dword Ptr ES:[DI.18] ; get pointer to command line.
	XOR	CH,CH			; init string length counter.
	MOV	SI,DI			; save start address.

	; ... scan the entire parm string for the termination character ...

FND_TERM_CHR:
	CMP	Byte Ptr ES:[DI],CR	; end of string?
	JE	FIND_PARMS		; yes, retrieve parameters.
	CMP	Byte Ptr ES:[DI],LF	; any parms present?
	JNE	NOT_CERTIN		; not sure, keep looking. 
	JMP	Short NO_PARMS_FOUND	; ERROR: No parms on the command line, abort.

NOT_CERTIN:
	INC	DI			; bump string index.
	INC	CH			; inc total char count.
	JMP	Short FND_TERM_CHR	; loop till EOS.

FIND_PARMS:
	CMP	Byte Ptr ES:[SI],'.'	; look for period in CDLANFIX.SYS name.
	JE	GET_PARMS		; found, go look for the drive parms.
	INC	SI			; adjust pointer.
	DEC	CH			; decrement string length counter.
	JNZ	FIND_PARMS		; loop until end of string.
	JMP	Short NO_PARMS_FOUND	; ERROR: driver name changed, abort.

	; ... examine CH count chars for valid drive parms ...
	; ... valid parms are of the form "x:" ...

GET_PARMS:
	CMP	Byte Ptr ES:[SI],':'	; look for next parm flag.
	JNE	NEXT_CHAR		; scan thru the entire string.

	; ... found a drive letter designator, range check the letter ...

	MOV	CL,ES:[SI-1]		; get drive letter.
	AND	CL,05FH			; uppercase conversion.
	MOV	DVLTR,CL		; save for display.
	SUB	CL,'A'			; convert to binary 0-25.
	JC	GET_PARMS		; failed to convert: => 'A'.
	CMP	CL,25			; must also be <= 'Z'.
	JA	GET_PARMS
	MOV	AX,1			; initialize bit mask.
	ROL	AX,CL			; build bit mask.
	CMP	CL,15			; fit in bits 0-15?
	JA	SET_HI_BIT		; no, goes in high-word (Q:-Z:).
	OR	DRIVE_MASK_LO,AX	; set drive (A: - P:).
	JMP	Short ECHO_LTR		; continue drive scan.

SET_HI_BIT:
	OR	DRIVE_MASK_HI,AX	; set drive (Q: - Z:).

ECHO_LTR:
	MOV	AH,9			; the message.
	MOV	DX,Offset DVLTR		; good drive on the command line.
	INT	21H

NEXT_CHAR:
	INC	SI			; adjust pointer.
	DEC	CH			; decrement string length counter.
	JNZ	GET_PARMS		; loop until end of string.

	; Parameter scanning completed, see what we ended up with ...

	MOV	AX,DRIVE_MASK_LO	; any valid
	OR	AX,DRIVE_MASK_HI	; ... drives specified?
	JZ	NO_PARMS_FOUND		; no: error out, don't stay resident.

	MOV	AH,9			; the message.
	MOV	DX,Offset DVMSG		; good parms on the command line.
	INT	21H

	; ... tie into the DOS Int 21H service handler ...

	MOV	AX,3521H		; DOS Get Vector function.
	INT	21H
	MOV	Word Ptr CS:[DOS_MANAGER.0],BX
	MOV	Word Ptr CS:[DOS_MANAGER.2],ES

	MOV	AX,2521H		; DOS Set Vector function.
	MOV	DX,Offset FILE_EXTENSIONS
	INT	21H
	MOV	AX,Offset EXT_IS_REQ	; set next free mem address.
	JMP	Short ALL_DONE

	; Unable to find any valid command-line parameters, abort ...

NO_PARMS_FOUND:
	MOV	AH,9			; print the error message.
	MOV	DX,Offset NOPRMS	; no parms on the command line.
	INT	21H
	MOV	AX,Offset EXT_NOT_REQ	; set next free mem address.

	; Exit back to DOS BDOS ...
ALL_DONE:
	POP	DI			; restore RQH pointer.
	POP	ES

	MOV	ES:[DI.14],AX		; set Dword - next free memory value.
	MOV	ES:[DI.16],CS
	MOV	Word Ptr ES:[DI.3],100H

	POP	BX			; restore BDOS's environment.
	POP	BP
	POP	SI
	POP	DX
	POP	CX
	POP	AX
	POP	DS
	POP	DI
	POP	ES
	RET				; Back to BDOS.

INIT	Endp

CODE	Ends
	End
