dosseg
.model tiny
.stack 256
.code
	 org     100h
start:  jmp     reset
boot:   dd 0ffff0000h
del:    push    dx
	push    bx
	call    dly_set
@@:     call    dly_test
	jc      @b
	pop     bx
	pop     dx
	ret
dly_set:
	sti
	mov     ah,0
	push    cx
	int     1ah
	mov     bx,dx
	pop     cx
	ret
dly_test:
	push    cx
	mov     ah,0
	int     1ah
	pop     cx
	mov     ax,bx
	sub     ax,dx
	jnc     @f
	neg     ax
@@:     cmp     ax,cx
	ret
;System-Boot
reset:  mov     ah,0dh        ;Flush all Buffer
	int     21h
	mov     cx,45
	call    del
@@:     in      al,64h       ;try hardreset
	test    al,2
	jz      @f
	loop    @b
@@:     mov     al,0feh
	out     64h,al
	mov     cx,45
	call    del
	sub     ax,ax
	mov     es,ax
	mov     es:[72h],1234h
	call    cs:[boot]    ;If fails, try softreset
	mov     ax,4cffh     ;if nothing works, return to dos
	int     21h
	end start

