dosseg
.model tiny
.stack 256
.code
		org     100h
start:  jmp     install
copyright       db "SLIPLOG (c) 020894 by khweis@mvmpc9.ciw.uni-karlsruhe.de$"
pid  equ $
pwdf            db "sliplog.pwd",0,0             ;passwordfile
logf            db "sliplog.log",0,0             ;session log
welcome         db "sliplog.msg",0,0             ;welcome message
plzwait         db "Please wait for call-back!",13,10,0
auto_on         db "autodial is on",13,10,0
auto_off        db "autodial is off",13,10,0
synstr          db "%$",13,10,0
atdial          db 40 dup(0)                      ;dialstring
online          db " minutes remaining.",13,10
		db "Your address is "
ipaddress       db "               ",13,10,0
no_tcp          db "NO SLIP!",0
sysop_only      db "Don't call! (Sysop only)",13,10,0
pwd_dflt        db "sysop 60",13,10
		db "guest 10",13,10
len_pwd_dflt equ $-pwd_dflt

logtxt  db 13,10,"Login: ",0
piep    db 7
crlf    db 13,10,0
newtime db 13,10,"Time set "
lofnew equ $-newtime

;commands recognized in sysopmode:
sysop   db   "help",13,10       ;show all comands
	db   "show",13,10       ;send list of passowrds
	db   "slip",13,10       ;reconnect to slip
	db   "set",13,10        ;set a usertime
	db   "read",13,10       ;reload a passwordfile
	db   "terminal",13,10   ;remote-access
	db   "autodial",13,10   ;dial on demand on/off
	db   "login",13,10      ;new log
	db   "reset",13,10,0    ;boot

;jump table of sysop-commands
syscmd  dw      help
	dw      liste
	dw      log5r
	dw      setuser
	dw      read
	dw      terminal
	dw      autodial
	dw      log80
	dw      reset

boot      dd      0ffff0000h                   ;boot-vector
rate      db      1,2,3,6,0ch,18h,30h,60h      ;list of bauds
ports     dw      3f8h,2f8h,3e8h,2e8h,2f0h     ;list of comports
irql      dw      4,3,4,3,5                    ;list of comirq's
port      dw      2f0h                         ;current comport
comirq    dw      0                            ;current comirq
packetirq dw      0                            ;current (slip)

;Interrupt used
oldint8         equ     this dword             ;Ticker
int8_ofs        dw      0
int8_seg        dw      0
oldint13        equ     this    dword          ;Disk
int13_ofs       dw      0
int13_seg       dw      0
oldint28        equ     this dword
int28_ofs       dw      0
int28_seg       dw      0
oldint29        equ     this dword             ;Console out
int29_ofs       dw      0
int29_seg       dw      0
oldint2f        equ     this dword
int2f_ofs       dw      0
int2f_seg       dw      0
oldcom          equ     this dword             ;Serial
oldcomof        dw      0
oldcomseg       dw      0
oldpack         equ     this dword             ;Packetdriver
oldpackof       dw      0
oldpackseg      dw      0
crtflag         equ     this dword             ;critical error
crtofs          dw      0
crtseg          dw      0

;flags and semaphores
in_pack         db      0             ;pkt-driver call in progress
no_int28        db      0             ;INT-handler is ticker
old_im          db      0             ;pic-interruptmask
debug           db      0             ;debug-switch
log             db      0             ;event id
inlog           db      0             ;event trigger
indisk          db      0             ;reentry-flag, disk
in_slip         db      0             ;slip-event in progress
in_int28        db      0             ;int 28 was started
msr             db      0             ;modem status
ringcount       db      1             ;ring count
logcount        db      3             ;max retrys login
breakf          db      0             ;break received (terminalmode)
ctrl_flag       db      0             ;keyboard.ctrl-code
tfl             db      0             ;midnight flag
dod             db      0             ;dial on demand flag
no_beep         db      0             ;no timeout-beep
show_call       db      0             ;show incoming caller
quiet_mode      db      1             ;no display
slipv_running   db      0             ;running in a dos-box
pkt_running     db      0             ;packetdriver initialized
vmm_running     db      0             ;Win3.1, Virtual mode
handle          dw      0             ;file-handle
vm_id           dw      0             ;current virtual machine
rptr            dw      0             ;readpointer (combuf)
wptr            dw      0             ;writepointer (combuf)
aktuser         dw      0             ;actual user id
temp            dw      0             ;misc
watchdog        dw      9             ;Reboot after watchdog (90 sek)
pause           dw      0             ;reboot after pause (0=off)
sysop_mode      dw      0             ;sysop only
sysop_tout      dw      60            ;tout in sysopmode
tw              dw      18            ;universal timer (tick-counts)
gast            dw      0             ;onlinetime for guests
inactivity      dw      4             ;inactivity timeout (5 minutes)
midnight        dw      0             ;Reload usertimer at this time

;statemachine (triggered by INT8)
;jump to procedures[log]
logtbl  dw      log0    ;set usertimes @ midnight, wait for ring
	dw      log1    ;send logon-message
	dw      log2    ;load passwordfile
	dw      log3    ;wait for enter
	dw      log4    ;send logon-String
	dw      log5    ;check user input
	dw      log6    ;switch to packetmode
	dw      log7    ;session (user is online)
	dw      log8    ;check sysop-command
	dw      log9    ;hangup
	dw      log10   ;terminal-Mode
	dw      log11   ;call back: hangup
	dw      log12   ;call back: dial
	dw      log13   ;call back: wait for connect
	dw      log14   ;call back: switch to slip
	dw      log15   ;authentification
;keyboard scancodes used in remote-mode (terminalmode)
scancodes:
dw 3000h,1E01h,3002h,2E03h,2004h,1205h,2106h,2207h,2308h,1709h,240Ah
dw 250Bh,260Ch,320Dh,310Eh,180Fh,1910h,1011h,1312h,1F13h,1414h,1615h
dw 2F16h,1117h,2D18h,1519h,2C1Ah,1A1Bh,2B1Ch,1B1Dh,071Eh,0C1fh
dw 3920h,0221h,2822h,0423h,0524h,0625h,0826h,2827h,0a28h,0b29h,092ah
dw 0d2bh,332ch,0c2dh,342eh,352fh,0b30h,0231h,0332h,0433h,0534h,0635h
dw 0736h,0837h,0938h,0a39h,273ah,273bh,333ch,0d3dh,343eh,353fh
dw 0340h,1E41h,3042h,2E42h,2044h,1245h,2146h,2247h,2348h,1749h,244Ah
dw 254Bh,264Ch,324Dh,314Eh,184Fh,1950h,1051h,1352h,1F53h,1454h,1655h
dw 2F56h,1157h,2D58h,1559h,2C5Ah,1A5Bh,2B5Ch,1B5Dh,075Eh,0C5Fh
dw 2960h,1E61h,3062h,2E63h,2064h,1265h,2166h,2267h,2368h,1769h,246Ah
dw 256Bh,266Ch,326Dh,316Eh,186Fh,1970h,1071h,1372h,1F73h,1474h,1675h
dw 2F76h,1177h,2D78h,1579h,2C7Ah,1A7Bh,2B7Ch,1B7Dh,297Eh,0E7Fh

;System-Boot
reset:  mov     cs:[pause],6
	mov     cs:[in_int28],-1
	mov     ah,0dh        ;Flush all Buffer
	int     21h
	mov     dx,cs:[port]
	add     dx,4
	mov     al,0bh
	out     dx,al        ;hangup
	mov     cx,18
	call    delay
	mov     al,0ah
	out     dx,al
	mov     cx,45
	call    delay
	sub     cx,cx
@@:     in      al,64h       ;try hardreset
	test    al,2
	jz      @f
	loop    @b
@@:     mov     al,0feh
	out     64h,al
	mov     cx,45
	call    delay
	sub     ax,ax
	mov     es,ax
	mov     es:[72h],1234h
	jmp     cs:[boot]    ;If fails, try softreset

delay:  push    dx
	push    bx
	call    dly_set
@@:     call    dly_test
	jc      @b
	pop     bx
	pop     dx
	ret

dly_set:
	sti
	mov     ah,0
	push    cx
	int     1ah
	mov     bx,dx
	pop     cx
	ret

dly_test:
	push    cx
	mov     ah,0
	int     1ah
	pop     cx
	mov     ax,bx
	sub     ax,dx
	jnc     @f
	neg     ax
@@:     cmp     ax,cx
	ret

;Check if Disk-INT running
newint13 proc   far
	 mov     cs:[indisk],-1
	 pushf
	 call    cs:[oldint13]
	 mov     cs:[indisk],0
	 retf    2
newint13 endp

;INT 29 redirected to Serial Output
our_int29: test cs:[quiet_mode],-1
	   jz   @f
	   cmp  cs:[log],10
	   jz   @f
	   ret
@@:        pushf
	   push cs
	   call near ptr newint29
	   ret
newint29 proc   far
	 test   cs:[vmm_running],-1
	 jz     @f
	 test   cs:[vm_id],2
	 jnc    @f
	 iret
@@:      cmp    cs:[log],10
	 jz     @f
	 jmp    cs:[oldint29]
@@:      test   cs:[quiet_mode],-1
	 jnz    @f
	 pushf
	 call   cs:[oldint29]
@@:      call   tx
quit_int29:
	 iret
newint29 endp

;Multiplex-INT
;Checks startup or stop of Windows
newint2f proc far
	cmp     ax,1608h
	jnz     @f
	mov     cs:[vmm_running],-1
	jmp     cs:[oldint2f]
@@:     cmp     ax,1609h
	jnz     @f
	mov     cs:[vmm_running],0
@@:     jmp     cs:[oldint2f]
newint2f  endp


;INT8 triggers all SLIPLOG-Events by simply
;incrmenting the 'INLOG'-Flag.
;The work is done later on if INT 28 is called
;by DOS. If in Windows, inlog is only incremented, if
;a Virtual machine is running, which initialized the PD.
;pause or watchdog reboot the pc after a certain time
;of inactivity (if INT28 is'nt executed)
int8    proc    far
	pushf
	call    cs:[oldint8]
	cmp     cs:[debug],255
	jnz     @f
	mov     cs:[inlog],0
	iret
@@:     inc     cs:[inlog]
	cmp     cs:[inlog],182    ;10 sec interval
	jc      int8_done
	mov     cs:[inlog],1      ;error or pause
	test    cs:[pause],-1     ;pause programmed?
	jz      no_pause
	test    cs:[no_beep],-1
	jnz     @f
	push    ax
	mov     al,7
	pushf
	call    cs:[oldint29]
	pop     ax
@@:     dec     cs:[pause]        ;reboot after pause*10 sek
	jnz     int8_done
	jmp     reset
no_pause:
	test    cs:[watchdog],-1  ;Someone is blocking our programm
	jz      int8_done
	test    cs:[no_beep],-1
	jnz      @f
	push    ax
	mov     al,7
	pushf
	call    cs:[oldint29]
	pop     ax
@@:     dec     cs:[watchdog]     ;reboot after watchdog*10 sek
	jnz     int8_done
	jmp     reset
int8_done:
	test    cs:[debug],-1
	jz      @f
	jmp     slipevent
@@:     test    cs:[no_int28],-1
	jz      @f
	jmp     slipevent
@@:     iret
int8    endp

;All sliplog-events are executed when
;INT 28h is called by DOS
newint28 proc   far
	pushf
	call    cs:[oldint28]
	test    cs:[no_int28],-1
	jz      slipevent
	iret
slipevent:
	test cs:[in_int28],-1
	jz      @f
	iret
@@:     test    cs:[pause],-1
	jz      @f
	iret
@@:     test    cs:[inlog],-1
	jnz     @f
	iret
@@:     cmp     cs:[debug],255
	jnz     @f
	iret
@@:     mov     cs:[in_int28],-1
	test    cs:[vmm_running],-1
	jz     slip_call
;virtual-mode-handler
@@:     push    ax
	push    bx
	push    cx
	push    dx
	push    si
	push    di
	push    es
	push    ds
	push    bp
	push    cs
	pop     ds
	mov     ax,1683h       ;Which VM is runnung?
	int     2fh
	cmp     bx,[vm_id]
	jz      sliploop       ;ok, is our machine
	mov     bx,[vm_id]     ;get our vm_id
	mov     ax,1685h       ;tell WINDOWS to switch to our VM
	xor     cx,cx
	mov     dx,40h
	xor     si,si
	push    cs
	pop     es
	mov     di,offset slip_call ;WINDOWS calls this after switching
	int     2fh
@@:     pop     bp
	pop     ds
	pop     es
	pop     di
	pop     si
	pop     dx
	pop     cx
	pop     bx
	pop     ax
	jc      @f
	mov     cs:[in_int28],0
	iret
@@:     mov     cs:[vm_id],1
;All SLIPLOG-Events are handled here
slip_call:
	push    ax
	push    bx
	push    cx
	push    dx
	push    si
	push    di
	push    es
	push    ds
	push    bp
	push    cs
	pop     ds
sliploop:
;ring and carrier are checked in EVERY tick
	mov     dx,[port]  ;Modem-Status-register
	add     dx,6
	in      al,dx
	sub     dx,2
	test    [debug],-1
	jz      @f
	mov     al,[debug]
@@:     and     al,0c0h    ;Test Carrier (Bit7) and Ring (Bit6)
	mov     ah,[msr]
	mov     [msr],al
	xor     al,ah
	jz      logon         ;no carrier no ring
	js      cdet          ;Carrier
	xor     al,ah         ;Ring?
	jz      logon         ;Ring off
	call    ring          ;Ring on
	jmp     @f
cdet:   xor     al,ah
	js      cdon          ;Carrier=on
	call    cdoff         ;Carrier=off
	jmp     @f
cdon:   mov     [tw],18       ;1 sec wait (garbage)
	mov     [ringcount],0
	cmp     [log],12      ;waiting for call back?
	jnc     @f
	mov     [log],1       ;Logstate=1 (Sync)
	jmp     @f
;The more time-consuming calls now...
logon:  les     bx,[crtflag]
	mov     al,es:[bx]
	or      al,[indisk]
	or      al,[in_slip]
	jnz     slipquit
	mov     [in_slip],-1
	sub     bx,bx
	mov     bl,[log]
	add     bx,bx
	call    logtbl[bx]    ;call event
	mov     [in_slip],0
@@:     dec     [inlog]
	jz      slipquit
	jmp     sliploop
slipquit:
	mov     [in_int28],0
	pop     bp
	pop     ds
	pop     es
	pop     di
	pop     si
	pop     dx
	pop     cx
	pop     bx
	pop     ax
noevent: iret
newint28  endp

;new packetdriver for slip. captures 'send packet' and returns error
;condition, if no carrier. If dial on demand (dod true) and no carrier,
;then dialout is started.
newpack proc    far
pktjmp: jmp     near ptr @f
db "PKT DRVR",0
db "WINPKT",0
@@:     cmp     ah,4
	jnz     pktold
	cmp     cs:[log],7
	jz      pktold
;dial on demand
	cmp     cs:[log],0
	jnz     @f
	test    cs:[dod],64
	jz      @f
	test    cs:[msr],128
	jnz     @f
	or      cs:[dod],32
	mov     cs:[log],11
	mov     cs:[aktuser],0
	mov     cs:[tw],45

@@:     cli
	mov     dh,12
	add     sp,4
	popf
	stc
	pushf
	sub     sp,4
	iret
pktold: cmp     ah,4
	jnz     pktold2
	test    cs:[dod],16
	jz      @f
	push    ax
	mov     ax,cs:[inactivity]
	mov     cs:[timertab],ax
	pop     ax
	jmp     pktold2
@@:     test    cs:[aktuser],-1
	jnz     pktold2
	push    ax
	mov     ax,cs:[sysop_tout]
	mov     cs:[timertab],ax
	pop     ax
pktold2:
	cmp     ah,2
	jnz     @f
	mov     cs:[pkt_running],-1
	test    cs:[vmm_running],-1
	jz      @f
;if we are in WINDOWS, then get the ID of our currently
;running virtual machine which initialized the Packetdriver
	call    get_vm
@@:     cmp     ah,3
	jnz     @f
	mov     cs:[pkt_running],0
@@:     cmp     ah,5
	jnz     @f
	mov     cs:[pkt_running],0
@@:     inc     cs:[in_pack]
	pushf
	call     cs:[oldpack]
	dec      cs:[in_pack]
	iret
newpack endp

get_vm:
	push    ax
	push    bx
	push    cx
	push    dx
	push    si
	push    di
	push    es
	push    ds
	push    bp
	mov     ax,1683h
	int     2fh
	mov     cs:[vm_id],bx   ;Get curent vm
	pop     bp
	pop     ds
	pop     es
	pop     di
	pop     si
	pop     dx
	pop     cx
	pop     bx
	pop     ax
	ret

;new receive procedure for slip.
;captures break-condition
packcom proc far
	push    ax
	push    dx
	push    ds
	push    cs
	pop     ds
	mov     dx,[port]
	add     dx,5
	cmp     [log],7
	jnz     newcom
	in      al,dx
	and     al,90h
	or      al,[breakf]
	jz      @f
	mov     [logcount],-1
@@:     pop     ds
	pop     dx
	pop     ax
	jmp     cs:[oldcom]
packcom endp

;receive prodedure if not in packetmode
newcom  proc    far
ncom:   push    bx
	mov     bx,[wptr]
	mov     dx,[port]
	sti
nextchar:
	add     dx,5
	in     al,dx
	sub    dx,5
	and    al,9fh
	cmp    al,1
	jnz    irx2
	in     al,dx
	mov    combuf[bx],al
	inc    bx
	and    bx,255
	jmp    nextchar
irx2:   test    al,90h
	jz      @f
	mov     [breakf],-1
@@:     test    al,1
	jz      @f
	in      al,dx
	jmp     nextchar
@@:     mov     [wptr],bx
	mov     al,20h
	out     20h,al
	pop     bx
	pop     ds
	pop     dx
	pop     ax
	iret
newcom  endp

;modem is ringing
ring:   cmp     [log],12
	jnc     ringq
	inc     [ringcount]
	cmp     [ringcount],3
	jnc     ringerr
	cmp     [ringcount],1
	jnz     ringq
	mov     [tw],1638    ;max. 90 Sek. bis zum Connect
	mov     al,0bh       ;Auto-Answer aktivieren
	out     dx,al
	sub     dx,3         ;point to interruptmask
	mov     al,1         ;and enable rxready
	out     dx,al
ringq:  ret

ringerr: mov    cs:[inlog],0
cdoff:  mov     [breakf],0
	mov     [ringcount],0
	and     [dod],128+64
	cmp     [log],11      ;call back
	jc      @f
	ret
@@:     mov     [tw],0
	cmp     [log],10
	jnz     @f
@@:     mov     [log],9       ;Logbuch-Eintrag
	ret

;waiting for login
;Alle 24 Stunden Online-Zeiten neu setzen und Ring-berwachung
log0:   test    [ringcount],-1
	jz      @f
	dec     [tw]
	jns     @f
	mov     al,0ah
	out     dx,al
	mov     [ringcount],0
@@:     mov     ah,0          ;Read Time
	int     1ah
	mov     ax,dx
	mov     dx,cx
	mov     cx,1092
	div     cx
	and     ax,ax         ;= Minuten nach Mitternacht
	jnz     @f
	mov     [tfl],0       ;Loadflag Reset um Mitternacht
@@:     cmp     [midnight],ax
	jnz     @f
	test    [tfl],-1
	mov     [tfl],-1
	jnz     @f
	call    LoadTime
@@:     ret

;send welcome message
log1:   dec     [tw]            ;Schrecksekunde
	js      @f
	ret
@@:     mov     ax,"  "
	mov     [buf_ptr],0
	call    logdate
;Begrssungstext senden
	test    [sysop_mode],-1
	jnz     log1_1
	mov     dx,offset welcome
	call    open_file
	jc      log1_2
@@:     call    get_line
	jz      log1_2
	mov     ah,0
	call    sendat
	jmp     @b
log1_1: mov     si,offset sysop_only
	mov     ah,0
	call    sendat
log1_2: mov     [tw],1092    ;hangup after 1 minute of inactivity
	mov     [log],2
	ret


;intermediate state. send synstring
log2:   call    sendsyn
	mov     [rptr],0
	mov     [wptr],0
	mov     [log],3
	ret

;wait for return-character
log3:   dec     [tw]
	jns     @f
	mov     [log],9
	ret
@@:     call    rxc
	jnc     log30        ;no character is waiting
	cmp     al,0dh       ;character is return?
	jnz     @b           ;no, try next character
	mov     [logcount],3
	mov     [tw],2184    ;3 Minuten Zeit f. Login
	mov     [log],4
log30:  ret

;send login-text
log4:   mov     si,offset logtxt
	mov     ah,0
	call    sendat
	mov     [log],5
	mov     [rptr],0
	mov     [wptr],0
@@:     ret

;check user-input
log5:   dec     [tw]       ;Login-Timeout
	jns     @f
	mov     [log],9
	ret
@@:     call    rxc
	jc      @f
	ret
@@:     mov     [breakf],0
	cmp     al,0dh
	jnz     log5
	mov     si, offset combuf
	call    loginput
	mov     si, offset combuf
	mov     dx, offset pwdf
	call    In_File
	jnc     @f
	jmp     logfail
@@:     add     cx,cx
	mov     [aktuser],cx
	cmp     cx,0
	jnz     @f            ;Sysop-Mode?
	call    piepe
	mov     al,'>'
	call    tx
	mov     [rptr],0
	mov     [wptr],0
	mov     [log],8
	mov     ax,[sysop_tout]
	mov     [timertab],ax  ;Sysop-Timeout
	jmp     log5q
@@:     call    lf
	call    phone
	pushf
	cmp     [aktuser],2    ;special 'guest'
	jnz     @f
	mov     si,bx
	call    readdez
	mov     [timertab+2],cx
@@:     popf
	jnc     log5r
	mov     si,offset plzwait
	mov     ah,0
	call    sendat
	call    sendsyn
	mov     [log],11
	mov     [tw],45
	jmp     log5q
log5r:
	test    [pkt_running],-1
	jnz     @f
	mov     si,offset no_tcp
	mov     ah,0
	call    sendat
	jmp     logneu

@@:     mov     si,[aktuser]
	test    [sysop_mode],-1
	jz      @f
	or      si,si
	jnz     logneu

@@:     mov     ax,timertab[si]
	inc     ax
	call    sendasc
	mov     si, offset online
	mov     ah,0
	call    sendat
	call    sendsyn
	mov     [tw],9
	mov     [log],6
	jmp     log5q
logfail:dec     [logcount]
	jnz     logneu
	mov     dx,[port]
	add     dx,4
	mov     [log],9
	jmp     log5q
logneu: call    piepe
	mov     [log],4
log5q:  ret



;switch to Slip
log6:   call    rxc
	jnc     @f
	call    our_int29
	jmp     log6
@@:     dec     [tw]
	jns     @f
;from now on we count minutes with tw (1092 ticks=1 minute)
;the slip-connection is established
	mov     [rptr],0
	mov     [wptr],0
	mov     [tw],1091
	mov     [log],7
@@:     ret

;user succesfully logged, slip established
;now waiting for hangup (no carrier) or time over
log7:   test    [logcount],-1
	jns     @f
	test    [in_pack],-1
	jnz     @f
	jmp     log80
@@:     dec     [tw]
	jns     @f
	mov     [tw],1091
	mov     si,[aktuser]
	dec     TimerTab[si]
	jns     @f
	inc     TimerTab[si]
	mov     [log],9
@@:     call    log0
	ret

;sysop-mode: command-parser
log8:   call    rxc
	jc      @f
	ret
@@:     call    tx
	cmp     al,13
	jnz     log8
	mov     bx,offset sysop
	mov     si,offset combuf
	call    get_command
	jnc     @f
log80:  mov     [logcount],3
	mov     [tw],2184    ;2 Minuten Zeit f. Login
	mov     [log],4
	ret
@@:     mov     bx,cx
	add     bx,bx
	call    syscmd[bx]
	jc      log80
log800: cmp     [log],8
	jnz     @f
	call    piepe
	mov     al,'>'
	call    tx
	mov     [rptr],0
	mov     [wptr],0
	jmp     log8
@@:     ret
Terminal:
	mov     [breakf],0
	mov     [ctrl_flag],0
	mov     [log],10
	ret

log9:   mov     al,0ah
	out     dx,al
	test    [msr],80h
	jnz     @f
	mov     ax,[buf_ptr]
	push    ax
	call    offtime
	call    put_log
	pop     si
	mov     cx,[buf_ptr]
	sub     cx,si
	call    show_caller
	mov     [log],0
@@:     ret

log10:  test    [breakf],-1
	mov     [breakf],0
	jz      @f
	mov     [log],8
	jmp     log800
@@:     mov     si,[rptr]
	cmp     si,[wptr]
	jnz     @f
	ret
@@:     mov     al,combuf[si]
	inc     [rptr]
	and     [rptr],255
	test    [ctrl_flag],-1
	jnz     log10a
	sub     ah,ah
	add     ax,ax
	jnz     @f
	mov     [ctrl_flag],-1
	jmp     log10
;Funktionstaste auswerten:
log10a: mov     [ctrl_flag],0
	mov     ch,al
	sub     cl,cl
	mov     ah,5
	int     16h
	and     al,al
	jnz     log10c
	jmp     log10
@@:     mov     si,ax
	mov     cx,word ptr scancodes[si]
	mov     ah,5
	int     16h
	and     al,al
	jz      log10
log10c: dec     [rptr]
	and     [rptr],255
	ret

;Callback/dial on Demand: Hangup/Pause
log11:  mov     al,0ah
	out     dx,al
	dec     [tw]
	jns     log110
@@:     test    [msr],80h
	jnz     log110
	mov     al,0bh
	out     dx,al
	mov     [tw],45
	mov     [log],12
log110: ret

;Callback/dial on demand: dialout
log12:  dec     [tw]
	jns     log12q
	test    [dod],32           ;dod started?
	jz      log12cb
;dial on demand is handled here
	mov     dx,offset pwdf
	call    open_file
	call    get_line
	call    close_file
	mov     bx,si
	call    phone
	jc      @f
	mov     [log],9
	ret
@@:     mov     [buf_ptr],0        ;create new logstring
	mov     ax,"  "
	call    logdate
	mov     ax,"- "
	call    logtime
;callback ist started
log12cb:
	mov     si,offset atdial
	mov     ah,0
	call    sendat
	mov     [tw],2184
	mov     [log],13
log12q: ret

;wait for carrier. If not detected within 2 minutes then giveup
log13:  dec     [tw]
	jns     @f
;dirty trick: force a hangup-sequence (modem is cleared)
;and an entry is made in the logfile
	mov     [tw],9
	mov     [ringcount],1
	mov     [log],0
	ret
@@:     call    rxc
	jnc     @f
	call    our_int29
	jmp     @b
@@:     test    [msr],80h
	jz      @f
;carrier detected. DTR is high now,so we can hangup at any time
;by pulling dtr low if we want
	mov     [tw],90
	mov     [log],14
@@:     ret

log14:  call    rxc
	jnc     @f
	call    our_int29
	mov     [tw],90
	jmp     log14
	ret
@@:     dec     [tw]
	js      @f
	ret
@@:     mov     ax,"- "
	call    logtime
	test    [dod],32
	jnz     @f
	call    lf
	jmp     log5r
;Dial on Demand: authentification
@@:
	mov     [tw],90
	mov     [log],15
	mov     al,0dh
	call    tx
	ret

log15:  call    rxc
	jnc     @f
	call    our_int29
	mov     [tw],90       ;wait for 5 sec silence
	jmp     log15
@@:     dec     [tw]
	js      @f
	ret
@@:     mov     si,offset line_buf
	mov     ah,"#"
	call    sendat
	mov     al,0dh
	call    tx
	mov     [tw],36
	mov     [log],6
	or      [dod],16
	mov     [aktuser],0
	mov     ax,[inactivity]
	mov     [timertab],ax
	ret

help:   mov     si,offset sysop
	mov     ah,0
	call    sendat
	ret

;sende eine charakteristische Zeichenfolge
sendsyn: mov     ah,0
	mov     si,offset synstr
	jmp     sendat

open_file:
	call    fullname
	mov     ax,3d00h
	int     21h
	mov     bx,ax
	mov     [handle],ax
	ret

close_file:
	push    bx
	mov     bx,[handle]
	mov     ah,3eh
	int     21h
	pop     bx
	ret

get_line:
	push    dx
	push    cx
	push    bx
	mov     bx,[handle]
	mov     dx,offset line_buf
	mov     si,0
@@:     mov     cx,1
	mov     ah,3fh
	int     21h
	jc      @f
	inc     dx
	and     ax,ax
	stc
	jz      @f
	mov     al,line_buf[si]
	inc     si
	cmp     si,127
	stc
	jz      @f
	cmp     al,0ah
	jnz     @b
@@:     mov     line_buf [si],0
	mov     si,offset line_buf
	mov     al,255
	jnc     @f
	call    close_file
	sub     ax,ax
@@:     pop     bx
	pop     cx
	pop     dx
	and     al,al
	ret
;Test ob passwort mit Rueckruf. Dann cy=1 und Waehlstring in 'atdial'
;bx zeigt auf Passwort-Anfang, si dahinter
phone:
@@:     mov     al,[bx]
	inc     bx
	cmp     al,'#'
	jz      @f
	cmp     al,21h
	jnc     @b
	clc
	ret
@@:     mov     si,offset atdial
	mov     al,[bx]
@@:     mov     [si],al
	inc     bx
	inc     si
	mov     al,[bx]
	cmp     al,21h
	jnc     @b
	mov     byte ptr [si],0dh
	inc     si
	mov     byte ptr [si],0
	ret

autodial:
	mov     si,offset auto_off
	test    [dod],128
	jz      @f
	xor     [dod],64
	test    [dod],64
	jz      @f
	mov     si,offset auto_on
@@:     mov     ah,0
	call    sendat
	ret


loginput:
	push    si
	push    di
	mov     di,[buf_ptr]
@@:     mov     al,[si]
	mov     tbuf[di],al
	cmp     al,0dh
	jz      @f
	inc     si
	inc     di
	and     di,255
	jnz     @b
	push    si
	push    di
	mov     [buf_ptr],255
	call    put_log
	mov     [buf_ptr],0
	pop     di
	pop     si
	jmp     @b
@@:     mov     [buf_ptr],di
	mov     ax,"- "
	call    logtime
	mov     cx,[buf_ptr]
	mov     si,0
	call    show_caller
login2: pop     di
	pop     si
	ret

show_caller:
	test    [show_call],-1
	jnz     @f
	ret
@@:     call    lf29
@@:     mov     al,tbuf[si]
	call    our_int29
	inc     si
	loop    @b
	ret
lf29:
	mov     al,0dh
	call    our_int29
	mov     al,0ah
	call    our_int29
	ret

put_log:
	push    dx
	push    cx
	mov     dx,offset logf
	call    fullname
@@:     mov     ax,3d01h
	int     21h
	mov     bx,ax
	jnc     @f
	mov     ah,3ch
	mov     cx,0
	int     21h
	mov     bx,ax
	jc      put_logq
	mov     ah,3eh
	int     21h
	jmp     @b
@@:     mov     cx,0
	mov     dx,cx
	mov     ax,4202h
	int     21h
	mov     dx,offset tbuf
	mov     cx,[buf_ptr]
	mov     ah,40h
	int     21h
	mov     ah,3eh
	int     21h
put_logq:
	pop     cx
	pop     dx
	ret

;Filname=Path+Filename
fullname:
	 push   si
	 push   di
	 mov    si,offset path
	 mov    di,offset fname
@@:      mov    al,[si]
	 mov    [di],al
	 and    al,al
	 jz     @f
	 inc    si
	 inc    di
	 jmp    @b
@@:      mov    si,dx
@@:      mov    al,[si]
	 mov    [di],al
	 inc    si
	 inc    di
	 and    al,al
	 jnz    @b
	 pop    di
	 pop    si
	 mov    dx,offset fname
	 ret

logtime:
	push    ax
	mov     ah,2ch
	int     21h
	mov     si,[buf_ptr]
	mov     tbuf[si],' '
	inc     si
	mov     al,ch
	call    sdigit
	mov     tbuf[si],':'
	inc     si
	mov     al,cl
	call    sdigit
	pop     ax
	mov     word ptr tbuf[si],ax
	add     si,2
	mov     [buf_ptr],si
	ret

logdate:
	push    ax
	mov     ah,2ah
	int     21h         ;Datum
	mov     si,[buf_ptr]
	sub     cx,1900
	mov     al,dl
	call    sdigit
	mov     tbuf[si],'.'
	inc     si
	mov     al,dh
	call    sdigit
	mov     tbuf[si],'.'
	inc     si
	mov     al,cl
	call    sdigit
	pop     ax
	mov     word ptr tbuf[si],ax
	add     si,2
	mov     [buf_ptr],si
	ret

offtime:
	mov     ax,0a0dh
	call    logtime
	ret

sdigit: aam
	or      ax,"00"
	xchg    al,ah
	mov     word ptr tbuf[si],ax
	add     si,2
	ret

;load passwordfile.
;set the users online timer
;This is processed after startup and at once a day
;at the time defined with the first password in comlog.pwd
LoadTime:
	mov     dx,offset pwdf
	call    open_file
	jnc     @f
	mov     ah,3ch
	mov     cx,0
	int     21h
	jc      LoadTerr
	mov     bx,ax
	mov     [handle],bx
	mov     dx,offset pwd_dflt
	mov     cx,len_pwd_dflt
	mov     ah,40h
	int     21h
	call    close_file
	jmp     LoadTime
LoadTerr:
	ret
@@:     mov     di,0
	call    loadT
	mov     bx,offset line_buf
	and     [dod],96
	call    phone
	jnc     @f
	or      [dod],128
@@:     call    LoadT
	jnz     @b
	mov     ax,[timertab]        ;the first time in the table
	mov     [midnight],ax        ;defines reload-time
	mov     di,offset newtime
	mov     cx,lofnew
	mov     si,[buf_ptr]
@@:     mov     al,[di]
	mov     tbuf[si],al
	inc     si
	inc     di
	loop    @b
	mov     [buf_ptr],si
	mov     ax,"  "
	call    logdate
	mov     ax,0a0dh
	call    logtime
	ret

LoadT:  call    get_line
	push    si
@@:     mov     al,byte ptr [si]
	inc     si
	and     al,al
	jz      LoadTq
	cmp     al,0dh
	jz      @f
	cmp     al,20h
	jnz     @b
	call    ReadDez
	mov     Timertab[di],cx
	call    strsp
@@:     add     di,2
LoadTq: and     al,al
	pop     si
	ret


;liste senden
Liste:  call    lf
	mov     dx,offset pwdf
	call    open_file
	mov     di,offset timertab
@@:     call    get_line
	jz      @f
	cmp     byte ptr[si],20h
	jc      @f
	mov     ah,0dh
	call    sendat
	mov     al,20h
	call    tx
	mov     ax,[di]
	call    sendasc
	mov     al,0dh
	call    tx
	mov     al,0ah
	call    tx
	add     di,2
	jmp     @b
@@:     call    close_file
	clc
	ret

;User-zeit setzen
Setuser:
	call    strsp      ;Tab 2 userfield
	cmp     al,21h
	jc      setq
	mov     dx, offset pwdf
	call    In_file
	jc      setq
	mov     di,cx
	add     di,di
	sub     ah,ah
	add     si,ax
	call    readdez
	mov     timertab[di],cx
	call    liste
setq:   ret


;Lese pwd-File
read:   call    strsp      ;Tab 2 userfield
	cmp     al,21h
	mov     dx,offset pwdf
	jc      lddef
	mov     dx,si
@@:     cmp     byte ptr [si],0dh
	jz      @f
	inc     si
	jmp     @b
@@:     mov     byte ptr [si],0
lddef:  call    Loadtime
loadq:  ret

;Open passwordfile, compare entrys with string in [si]
in_file:
	call    open_file
	jc      no_match
	mov     bx,si
	mov     dx,0
in_file1:
	call    get_line
	jz      no_match
	mov     cx,ax
	push    si
	mov     ax,0
@@:     cmp     byte ptr [si],"$"
	jc      @f
	inc     si
	inc     ax
	loop    @b
@@:     pop     si
	and     ax,ax
	jz      no_match
	mov     cx,ax
	push    bx
	push    si
@@:     mov     ah,[si]
	cmp     [bx],ah
	jnz     @f
	inc     bx
	inc     si
	loop    @b
	pop     si
	pop     bx
	jmp     match_found
@@:     pop     si
	pop     bx
	inc     dx
	jmp     in_file1
no_match:
	mov     cx,dx
	call    close_file
	stc
	ret
match_found:
	call    close_file
	mov     cx,dx
	xchg si,bx
	clc
	ret

;Stringvergleich string in Combuf [si] mit Liste [bx]
;stringcounter ist cx
;Nach Aufruf: cy=1 wenn kein match. sonst:
;ah= stringlnge, si= unverndert, cx= String-Nr.
;bx=si
get_command:
	mov     cx,0            ;Stringcount
get_cmd0:
	push    si
@@:     mov     al,[bx]         ;Tabellenende erreicht?
	mov     ah,[si]
	cmp     ah,21h
	jc      get_cmd1
	inc     si
	inc     bx
	cmp     ah,al
	jz      @b
	pop     si
	inc     cx
@@:     mov     al,[bx]
	inc     bx
	cmp     al,0ah
	jnz     @b
	test    byte ptr [bx],-1
	jnz     get_cmd0
	stc
	ret
get_cmd1: pop   ax
	  clc
	  ret

;Binrzahl in ax <9999 umwandeln und senden
sendasc:
	cwd
	mov     cx,100
	div     cx
	aam
	or      ax,'00'
	xchg    ax,dx
	aam
	or      ax,'00'
	push    ax
	push    dx
	mov     al,dh
	call    tx
	pop     ax
	call    tx
	pop     ax
	push    ax
	mov     al,ah
	call    tx
	pop     ax
	call    tx
	ret

rxc:    mov     si,[rptr]
	cmp     si,[wptr]
	mov     al,0
	jz      rxcq
	mov     al,combuf[si]
	cmp     al,1bh
	jnz     @f
	mov     [rptr],0
	mov     [wptr],0
	call    piepe
	xor     al,al
	jmp     rxcq
@@:     inc     [rptr]
	and     [rptr],255
	stc
rxcq:   ret

sendat:
@@:     mov     al,[si]
	cmp     al,ah
	jz      @f
	call    tx
	inc     si
	jmp     @b
@@:     ret

tx:     test    cs:[debug],-1
	jz      old_tx
	pushf
	call    cs:[oldint29]
	ret
old_tx:
	push    dx
	push    ax
	mov     dx,cs:[port]
	add     dx,5
txlp:   in      al,dx
	and     al,20h
	jz      txlp
	pop     ax
	sub     dx,5
	out     dx,al
	pop     dx
	ret

piepe:  mov     si,offset piep
	mov     ah,0
	jmp     sendat

lf:     mov     si,offset crlf
	mov     ah,0
	jmp     sendat

;Dezimalzahl wandeln
ReadDez proc    near
	call    strsp
	jz      nodez
	mov     cx,0
@@:     mov     al,[si]
	call    HexDig
	jc      nodez
	cmp     al,10
	jnc     nodez
	inc     si
	push    ax
	push    dx
	mov     ax,cx
	mov     cx,10
	mul     cx
	mov     cx,ax
	pop     dx
	pop     ax
	sub     ah,ah
	add     cx,ax
	jmp     @b
nodez:  ret
Readdez endp

;Leerzeichen berlesen
strsp   proc   near
	dec    si
@@:     inc     si
	mov    al,[si]
	cmp     al,' '
	jz      @b
@@:     ret
strsp   endp

HexDig  proc   near
	call upcase
	sub  al,'0'
	jc   @f
	cmp  al,0ah
	cmc
	jnc   @f
	sub  al, 7
	cmp  al, 10h
	cmc
@@:     ret
HexDig  Endp

;lower/upper-Case Koverter. Zeichen in al
upcase  proc   near
	cmp     al,'a'
	jb      nocvt
	cmp     al,'z'
	ja      nocvt
	sub     al,32
nocvt:  ret
upcase endp

;Mehrstellige Hexadezimalzahl nach Binr umwandeln
ReadHex Proc    near
	call    strsp
	jc      nohex
	mov     cx,0
@@:     call    Hex
	jnc     @b
	clc
NoHex:  ret
ReadHex Endp

;Hexa-Zahlen-Konverter. Zeichen in al. Zuerst Zwischenergebnis in dx
;mit 16 multiplizieren, dann Binr-Wert des Zeichens addieren
Hex     proc near
	mov  al,[si]
	call HexDig
	jc   HexEx
Hexok:  inc  si
	add  cx,cx
	add  cx,cx
	add  cx,cx
	add  cx,cx
	xor  ah,ah
	add  cx,ax
HexEx:  ret
Hex     Endp


timertab dw      256  dup(60)   ;Onlinezeiten der User
combuf   db      256  dup(0)    ;Receive-Buffer
path     db      64   dup(0)    ;path of helpfiles
fname    db      80   dup(0)    ;path+filename
buf_ptr  dw      0              ;Pointer to tbuf
tbuf     db      256  dup(0)    ;login stored here
line_buf db      128  dup(0)

instend equ $
;*****************   resident part ends here **************************
usage1:
db 13,10,"     SLIPLOG 020894 (c) July 1994 by Karl-Heinz Weiss"
db 13,10,"Please report bugs and comments to khweis@mvmpc9.ciw.uni-karlsruhe.de"
db 13,10,"                      INSTALLING"
db 13,10,"Copy sliplog.com, sliplog.pwd, sliplog.log and sliplog.msg to"
db 13,10,"the same directory. Change to this directory and call sliplog"
db 13,10,"or define the path of the helpfiles on the commandline"
db 13,10,"sliplog <com_irq> <port_adress> <Packet_INT> [<ip-address> [<path>]]"
db 13,10,"or: sliplog <number_of_Comport> <Packet_INT>...."
db 13,10,"Examples: sliplog 4 3f8 60 129.13.118.9 c:\nos\spool"
db 13,10, "sliplog 1 60 129.13.118.9   or   sliplog 1 60"
db 13,10, "if sliplog.pwd and/or sliplog.log not exists, they are created!"
db 13,10,"                        COMMANDS"
db 13,10,"After sliplog is loaded, you may call the tsr, only giving the"
db 13,10,"packet-INT and an option:    sliplog <Packet_INT> -Opt"
db 13,10,"           Options without numeric parameter"
db 13,10,"-U unlolad -R reboot -H hangup -T terminal"
db 13,10,"      Options with boolean parameter (n > 0 means 'ON')"
db 13,10,"-M n monitor calls  -Q n remote-acitivities not shown  -B n beep off"
db 13,10,"-X n Testmode -I n interrupthandler is INT 8 (ticker) instead of INT 28"
db 13,10,"            Options with numeric parameters"
db 13,10,"-W n watchdog timeout -P n pause timeout -S n sysopmode/sysoptime"
db 13,10,"-D n dial on demand/inactivity time      -N n ip-address"
db 13,10,"-A string  send string to the modem"
db 13,10,"-L m,n  set user-timer m to n. If m=0, set timer of current logged user"
db 13,10,"$"
usage2:
db 13,10,"            Terminalmode/Testmode"
db 13,10,"            _____________________"
db 13,10,"Controlcharacters in terminalmode (-T) or Testmode (-X)"
db 13,10,"F1 Help"
db 13,10,"Ctrl-Q quit"
db 13,10,"Ctrl-D toggle DTR / simulate carrier"
db 13,10,"Ctrl-B send/simulate break"
db 13,10,"Ctrl-S show status"
db 13,10,"Testmode only:"
db 13,10,"Ctrl-C simulate carrier"
db 13,10,"Ctrl-R simulate ring"
db 13,10,"Ctrl-A modem-test (all keypresses are sent to modem)"
db 13,10,"$"
installm   db 13,10,"sliplog succesfully installed ",13,10,"$"
lofinstall equ $-installm-3
file_not_found db 13,10,"File not found!",13,10,7,"$"
uninstalled  db 13,10,"Thank's for using SLIPLOG.",13,10
db "You made a small program very happy!",13,10,"$"
wrong_param db 13,10,"wrong or missing parameter!",13,10,7,"$"
wrong_option db 13,10,"wrong option!",13,10,7,"$"
not_removed db 13,10,"sliplog NOT removed!",13,10,7,"$"
not_uninstalled db 13,10,"sliplog NOT terminated!",13,10,7,"$"
not_installed db 13,10,"sliplog NOT installed!",13,10,7,"$"
is_installed db 13,10,"sliplog IS already installed!",13,10,7,"$"
o_k db "OK",13,10,"$"
not_found db "no sliplog"
found_msg db " found",13,10,"$"
l_feed  db 13,10,"$"
no_body db 13,10,"Nobody is logged",13,10,"$"
cr_ison db "Carrier On",13,10,"$"
cr_isoff db "Carrier Off",13,10,"$"
ring_ison db "Ring On",13,10,"$"
ring_isoff db "Ring Off",13,10,"$"
msg1 db "Port=$"
msg2 db "Irq=$"
msg3 db "Pkt=$"
msg4 db "state=$"
msg5 db "P=$"
msg6 db "W=$"
msg7 db "VM=$"
msg8 db "UT=$"
msg9 db 0dh,0ah,"luser=$"
msg10 db "TW=$"
msg11 db 13,10,"ip-address=$"
msg12 db "  Path=$"

;if another copy of sliplog is installed: cy set
already_inst:
	mov     ax,cs:[packetirq]
test_inst:
	push    ax
	mov     ah,35h
	int     21h
	mov     cx,offset pid-offset start
	mov     bx,offset start
	push    si
	mov     si,bx
@@:     mov     ah,cs:[si]
	cmp     ah,es:[bx]
	clc
	jnz     @f
	inc     bx
	inc     si
	loop    @b
	stc
@@:     pop     si
	pop     ax
	ret

;remove sliplog, free ram
uninst: push    ds
	mov     al,2fh
	mov     bx,offset newint2f
	call    test_owner
	jc      @f
	mov     al,08h
	mov     bx,offset int8
	call    test_owner
	jc      @f
	lds     dx,es:[oldint2f]
	mov     ax,ds
	mov     ax,252fh
	int     21h
	lds     dx,es:[oldpack]
	mov     ax,es:[packetirq]
	mov     ah,25h
	int     21h
	lds     dx,es:[oldint8]
	mov     ax,2508h
	int     21h
	lds     dx,es:[oldint13]
	mov     ax,2513h
	int     21h
	lds     dx,es:[oldcom]
	mov     ax,es:[comirq]
	add     ax,8
	mov     ah,25h
	int     21h
	lds     dx,es:[oldint28]
	mov     ax,2528h
	int     21h
	lds     dx,es:[oldint29]
	mov     ax,ds
	and     ax,ax
	jz      @f
	mov     ax,2529h
	int     21h
	clc
@@:     pop     ds
	ret

;test who is the last owner of an interrupt
test_owner:
	push    es
	push    bx
	mov     ah,35h
	int     21h
	pop     ax
	cmp     ax,bx
	mov     ax,es
	pop     es
	mov     bx,es
	stc
	jnz     @f
	cmp     ax,bx
	jz      @f
	stc
@@:     ret

;Dezimalausgabe der Binrzahl im Akku auf console
write_info:
	push    ax
	mov     ah,9
	int     21h
	pop     ax
write_dez:
	push    ax
	push    cx
	cwd
	mov     cx,100
	div     cx
	aam
	or      ax,'00'
	xchg    ax,dx
	aam
	or      ax,'00'
	push    ax
	push    dx
	mov     al,dh
	int     29h
	pop     ax
	int     29h
	pop     ax
	push    ax
	mov     al,ah
	int     29h
	pop     ax
	int     29h
	mov     al," "
	int     29h
	pop     cx
	pop     ax
	ret

;show info about sliplog
show_inst:
	call    test_inst
	jc      @f
	ret
@@:     push    ax
	mov     ax,es:[port]
	mov     dx,offset msg1
	call    write_info
	mov     ax,es:[comirq]
	mov     dx,offset msg2
	call    write_info
	mov     ax,es:[packetirq]
	mov     dx,offset msg3
	call    write_info
	sub     ax,ax
	mov     al,es:[log]
	mov     dx,offset msg4
	call    write_info
	mov     ax,es:[pause]
	mov     dx,offset msg5
	call    write_info
	mov     ax,es:[watchdog]
	mov     dx,offset msg6
	call    write_info
	mov     ax,es:[vm_id]
	mov     dx,offset msg7
	call    write_info
	mov     bx,es:[aktuser]
	mov     ax,es:timertab[bx]
	mov     dx,offset msg8
	call    write_info
	mov     ax,es:[tw]
	cmp     ax,10000
	jc      @f
	mov     ax,0
@@:     mov     dx,offset msg10
	call    write_info
	mov     dx,offset msg11
	mov     ah,9
	int     21h
	mov     di,offset ipaddress
	mov     cx,15
	call    out_txt
	mov     dx,offset msg12
	mov     ah,9
	int     21h
	mov     di,offset path
	mov     cx,64
	call    out_txt
	mov     dx,offset msg9
	mov     ah,9
	int     21h
	mov     di,offset tbuf
	mov     cx,es:[buf_ptr]
	call    out_txt
	pop     ax
	mov     dx,offset o_k
	stc
	ret

out_txt:
	and     cx,cx
	jz      @f
	mov     al,es:[di]
	and     al,al
	jz      @f
	int     29h
	inc     di
	loop    out_txt
;@@:     mov     dx,offset l_feed
;        mov     ah,9
;        int     21h
	ret

;modify usertimer (0=current user)
luser:  call    readdez
	mov     al,[si]
	cmp     al,","
	stc
	jnz     by_user
	inc     si
	push    cx
	call    readdez
	pop     di
	add     di,di
	jz      set_aktuser
	mov     es:[timertab+di],cx
	jmp     by_user
set_aktuser:
	cmp     es:[inlog],7
	jnz     no_aktuser
	mov     di,es:[aktuser]
	mov     es:[timertab+di],cx
	jmp     by_user
no_aktuser:
	mov     dx,offset no_body
	mov     ah,9
	int     21h
	clc
by_user: ret

;switch on dial on demand
set_dod: call    ReadDez
	cmp     cx,1
	jc      @f
	dec     cx
	mov     es:[inactivity],cx
	or      es:[dod],64 ;Switch on dod
	ret
@@:     and     es:[dod],0bfh
	ret

;init hardware-irq
en_comirq:
	mov     cx,[comirq]
	mov     ch,0feh
	rol     ch,cl
	cli
	in      al,21h
	mov     [old_im],al
	and     al,ch
	out     21h,al
	mov     al,20h
	out     20h,al
	mov     dx,[port]
	add     dx,1
	mov     al,1
	out     dx,al
	sti
	ret

dis_comirq:
	cli
	mov     al,es:[old_im]
	out     21h,al
	sti
	ret

;show info about all current loaded sliplogs
show_all:
	mov     ax,5fh
@@:     inc     ax
	cmp     ax,80h
	jnc     @f
	call    show_inst
	jmp     @b
@@:     ret

;send command to modem
at_cmd: call    strsp
	mov     ax,es:[port]
	mov     cs:[port],ax
	mov     ah,0dh
	call    sendat
	mov     al,0dh
	call    tx
	push    ds
	push    es
	pop     ds
	mov     cx,36
	call    dly_set
at_1:   call    rxc
	jnc     at_0
	int     29h
	mov     cx,36
	call    dly_set
	jmp     at_1
at_0:   call    dly_test
	jc      at_1
	pop     ds
	ret

;Interrupt-Handler zu miniterm
mirx     proc   far
	 push    ax
	 push    bx
	 push    dx
	 push   ds
	 push   cs
	 pop    ds
	 mov    bx,[wptr]
	 mov    dx,[port]
mirx1:   add    dx,5
	 in     al,dx
	 sub    dx,5
	 and    al,1fh
	 cmp    al,1
	 jnz    mirx2
	 in     al,dx
@@:      mov    combuf[bx],al
	 inc    bx
	 and    bx,255
	 jmp    mirx1
mirx2:   test   al,1
	 jz     @f
	 in     al,dx
@@:      mov    [wptr],bx
	 mov    al,20h
	 out    20h,al
	 test   [temp],-1
	 jnz    @f
nochm:   call   mrx
	 mov    dx,[wptr]
	 cmp    bx,dx
	 jnz    nochm
@@:      sti
	 pop     ds
	 pop     dx
	 pop     bx
	 pop     ax
	 iret
mirx     endp

mrx     proc   near
	mov     [temp],-1
	mov     bx,[rptr]
	sti
mrx1:   mov     dx,[wptr]
	cmp     bx,dx
	jz      norx
	mov     al,combuf[bx]
	int     29h
	inc     bx
	and     bx,255
	jmp     mrx1
norx:   cli
	mov     [temp],0
	mov     [rptr],bx
	ret
mrx     endp

;terminalmode while sliplog is loaded
miniterm:
	mov     dx,es:[port]
	mov     [port],dx
	mov     es:[debug],255
	mov     es:[in_int28],-1
	mov     es:[log],0
	add     dx,4
	mov     al,0bh
	out     dx,al
	mov     ax,es:[comirq]
	add     ax,8
	mov     dx,offset mirx
	mov     ah,25h
	int     21h
Trm_0:
	mov     ah,1
	int     16h
	jz      Trm_0
	mov     ah,0
	int     16h
@@:     cmp     al,0
	jnz     @f
	cmp     ah,3bh
	jnz     @f
	call    usg2
	jmp     trm_0
@@:     cmp     al,17     ;Ctrl-q
	jz      Trm_e
	cmp     al,2      ;ctrl-b
	jnz     Trm_2
	mov     dx,[port]
	add     dx,3
	mov     al,43h
	out     dx,al
	mov     cx,5
	call    delay
	mov     al,3h
	out     dx,al
	jmp     Trm_0
Trm_2:  cmp     al,4      ;ctrl-d
	jnz     Trm_3
	mov     dx,[port]
	add     dx,4
	in      al,dx
	xor     al,1
	out     dx,al
	jmp     Trm_0
Trm_3:  cmp     al,19    ;ctrl-s
	jnz     Trm_4
	call    show_all
	jmp     Trm_0
Trm_4:  call    old_tx
	jmp     Trm_0
Trm_e:  mov     dx,[port]
	add     dx,6
	in      al,dx
	sub     dx,2
	and     al,0c0h
	mov     es:[msr],al
	and     al,80h
	mov     al,0ah
	mov     es:[log],0
	jns     Trm_q
	mov     es:[tw],1092
	mov     es:[log],7
	mov     es:[aktuser],0
	mov     es:[breakf],0
	mov     al,0bh
Trm_q:  out     dx,al
	mov     es:[debug],0
	mov     es:[in_int28],0
	push    ds
	push    es
	pop     ds
	mov     ax,[comirq]   ;new COM-IRQ
	add     ax,8
	mov     dx,offset packcom
	mov     ah,25h
	int     21h
	pop     ds
	ret

;debug-mode
test_com:
	mov     ax,es:[port]
	mov     cs:[port],ax
	mov     ah,0
	int     16h
@@:     cmp     al,0
	jnz     @f
	cmp     ah,3bh
	jnz     @f
	call    usg2
	jmp     test_com
@@:     cmp     al,19   ;s-tatus
	jnz     @f
	push    es
	call    show_all
	pop     es
	jmp     test_com
@@:     cmp     al,18   ;r-ing
	jnz     @f
	mov     al,64
	xor     es:[debug],al
	test    es:[debug],64
	mov     dx,offset ring_ison
	jnz     tc_01
	mov     dx,offset ring_isoff
tc_01:  mov     ah,9
	int     21h
	jmp     test_com
@@:     cmp     al,4   ;d-ata carrier
	jz      dcd
@@:     cmp     al,3   ;c-arrier
	jnz     @f
dcd:    mov     al,128
	xor     es:[debug],al
	test    es:[debug],128
	mov     dx,offset cr_ison
	jnz     tc_02
	mov     dx,offset cr_isoff
tc_02:  mov     ah,9
	int     21h
	jmp     test_com
@@:     cmp     al,2    ;b-reak
	jnz     @f
	mov     es:[breakf],-1
	call    old_tx
	jmp     test_com
@@:     cmp     al,1    ;at-sequence
	jnz     @f
	call    at_test
	jc      @f
	jmp     test_com
@@:     cmp     al,17   ;ctrl-q (Quit)
	jz      @f
	mov     bx,es:[wptr]
	mov     es:combuf[bx],al
	inc     es:[wptr]
	and     es:[wptr],255
	jmp     test_com
@@:     ret

;sending commands to the modem while debugging
at_test:
	push    ds
	push    es
	pop     ds
at_loop:
	mov     bx,[rptr]
	cmp     bx,[wptr]
	jz      @f
	mov     al,combuf[bx]
	inc     bx
	and     bx,255
	mov     [rptr],bx
	pushf
	call    [oldint29]
@@:     mov     ah,1
	int     16h
	jz      at_loop
@@:     mov     ah,0
	int     16h
	cmp     al,1
	jz      @f
	cmp     al,17   ;ctrl-q
	stc
	jz      @f
	call    old_tx
	cmp     al,2
	jnz     at_loop
@@:     pop     ds
	ret

help_usage:
	mov     dx,offset usage1
	mov     ah,9
	int     21h
	mov     ah,0
	int     16h
usg2:   mov     dx,offset usage2
	mov     ah,9
	int     21h
	ret

read_ip:
	 call    strsp
	 mov     cx,15
	 mov     di,offset ipaddress
	 mov     al,[si]
	 jc      read_ip0
@@:      mov     [di],al
	 inc     si
	 inc     di
	 dec     cx
	 jz      read_ipq
	 mov     al,[si]
	 cmp     al,21h
	 jnc     @b
read_ip0:
	 mov     al," "
@@:      mov     [di],al
	 inc     di
	 loop    @b
read_ipq: ret

;*************** Install program and/or set Options ********************
install proc
	push    cs
	pop     ds
	mov     si,80h     ;PSP
	inc     si
	call    ReadHex    ;number of com or address of port
	jnc     install2
;search sliplog (INT 60 to IN 7f)
	mov     dx,offset not_found
	call    show_all
	jmp     quite
install2:
	cmp     cx,6       ;<6? ---> is number of com
	jnc     isadr
	dec     cx         ;0? ---> error
	jns     @f
	call    help_usage
	jmp     quite
@@:     add     cx,cx      ;get address/irq from table
	mov     bx,cx
	mov     cx,[ports+bx]
	mov     [port],cx
	mov     cx,[irql+bx]
	mov     [comirq],cx
	jmp     pakirq
isadr:  cmp     cx,100h    ;address > 100h? ---> portaddress
	jnc     @f
	mov     [packetirq],cx ;<100h? --->packet-INT
	call    strsp
	jnc     options        ;options following?
	mov     ax,cx
	mov     dx,offset not_found
	call    show_inst      ;show this installation
	jmp     quite
@@:     mov     [port],cx      ;address of comport
	call    readhex        ;com irq follows
	jnc     @f
	mov     dx,offset wrong_param
	jmp     quite
@@:     mov     [comirq],cx
pakirq: call    readhex        ;packet INT
	jnc     @f
	mov     dx,offset wrong_param
	jmp     quite
@@:     cmp     cx,60h
	jnc     @f
	mov     dx,offset wrong_param
	jmp     quite
@@:     mov     [packetirq],cx
	jmp     no_options

options:
	call    strsp
	jc      ok
	mov     dx,offset wrong_param
	cmp     al,"-"
	jz      @f
	jmp     quite
ok:     mov     dx,offset o_k
	jmp     quite
@@:     inc     si
	mov     al,[si]
	inc     si
	call    upcase
	cmp     al,"U"    ;Unload
	jnz     @f
	jmp     remove
@@:     cmp     al,"R"    ;Reset
	jnz     @f
	jmp     reset
@@:     push    ax
	call    already_inst
	pop     ax
	jc      @f
	mov     dx,offset not_installed
	jmp     quite
@@:     mov     dx,offset o_k
	cmp     al,'W'    ;Watchdog
	jnz     @f
	call    readdez
	mov     es:[watchdog],cx
	jmp     options
@@:     cmp     al,'D'      ;Dial on Demand?
	jnz     @f
	call    set_dod
	jmp     options
@@:     cmp     al,'P'      ;pause
	jnz     @f
	call    readdez
	mov     es:[pause],cx
	jmp     options
@@:     cmp     al,'S'       ;Sysop-Mode
	jnz     @f
	call    readdez
	mov     es:[sysop_mode],cx
	and     cx,cx
	jz      s_01
	mov     es:[sysop_tout],cx
s_01:   jmp     options
@@:     cmp     al,"B"       ;Beep On/Off
	jnz     @f
	call    readdez
	mov     es:[no_beep],cl
	jmp     options
@@:     cmp     al,"H"        ;Hangup
	jnz     @f
	mov     dx,es:[port]
	add     dx,4
	mov     al,0bh
	out     dx,al
	mov     cx,18
	call    delay
	mov     al,0ah
	out     dx,al
	mov     cx,36
	call    delay
	jmp     options
@@:     cmp     al,"L"        ;L(ast)user
	jnz     @f
	call    luser
	jc      L_0
	jmp     options
L_0:    jmp     wrong_syntax
@@:     cmp     al,'M'        ;Monitor incoming calls
	jnz     @f
	call    readdez
	mov     es:[show_call],cl
	jmp     options
@@:     cmp     al,'Q'        ;Quiet mode
	jnz     @f
	call    readdez
	mov     es:[quiet_mode],cl
	jmp     options
@@:     cmp     al,'I'        ;Interrupt style
	jnz     @f
	call    readdez
	mov     es:[no_int28],cl
	jmp     options
@@:     cmp     al, "T"       ;terminal mode
	jnz     @f
	call    usg2
	call    miniterm
	jmp     exit
@@:     cmp     al,"A"        ;send command to modem
	jnz     @f
	call    at_cmd
	jmp     exit
@@:     cmp     al,'X'        ;debugmode
	jnz     @f
	call    readdez
	and     cx,cx
	jz      x00
	test    es:[debug],-1
	jnz     x01
	mov     es:[debug],1
x01:    call    usg2
	call    test_com
	jmp     ok
x00:    mov     es:[debug],0
	jmp     ok
@@:     cmp     al,"N"
	jnz     wrong_syntax
	call    read_ip
	mov     cx,15
	mov     di,offset ipaddress
@@:     mov     al,[di]
	mov     es:[di],al
	inc     di
	loop    @b
	jmp     options

wrong_syntax:
@@:     mov     dx,offset wrong_option
	jmp     quite


remove:
	call    already_inst
	jc      @f
	mov     dx,offset not_installed
	jmp     quite
@@:     call    uninst
	jnc     @f
	mov     dx,offset not_uninstalled
	jmp     quite
@@:     mov     ah,49h
	int     21h
	mov     dx,offset not_removed
	jc      @f
	call    dis_comirq
	mov     dx,offset uninstalled
@@:     jmp     quite

no_options:
	 push   es
	 call   already_inst
	 pop    es
	 mov    dx,offset is_installed
	 jnc    @f
	 jmp    quite

;read ip
@@:      call    read_ip

done:    call   strsp
	 jc     done1
	 mov    di,offset path
@@:      mov    al,[si]
	 mov    [di],al
	 inc    si
	 inc    di
	 cmp    al,21h
	 jnc    @b
	 dec    di
	 dec    di
	 cmp    byte ptr [di],"\"
	 jz     @f
	 inc    di
	 mov    byte ptr [di],"\"
@@:      inc    di
	 mov    byte ptr [di],0
	 jmp    path_ok

done1:   push   si
	 mov    si,offset path
	 mov    ah,19h
	 int    21h     ;current drive
	 mov    dl,al
	 inc    dl
	 add    al,"A"
	 mov    [si],al
	 inc    si
	 mov    ax,"\:"
	 mov    [si],ax
	 inc    si
	 inc    si
	 mov    ah,47h
	 int    21h
	 test   byte ptr [si],-1
	 jz     path_ok
@@:      inc    si
	 test   byte ptr [si],-1
	 jnz    @b
	 mov    byte ptr [si],"\"
	 inc    si
	 mov    byte ptr [si],0
	 pop    si
path_ok:
	mov     di,offset installm
	mov     cx,lofinstall
	mov     si,0
@@:     mov     al,[di]
	mov     tbuf[si],al
	inc     di
	inc     si
	loop    @b
	mov     [buf_ptr],si
	mov     ax,"  "
	call    logdate
	mov     ax,"  "
	call    logtime
	call    loadtime
	jc      @f
	call    put_log
	jc      @f
	jmp     installed
@@:     mov     dx,offset file_not_found
	jmp     quite

installed:
	mov     dx,offset copyright
	mov     ah,9
	int     21h
	mov     dx,offset installm
	mov     ah,9
	int     21h
@@:     mov     ah,34h
	int     21h
	mov     [crtseg],es
	dec     bx                  ;>= DOS 3
	mov     [crtofs],bx
	mov     ax,[packetirq]
	mov     ah,35h
	int     21h
	mov     [oldpackseg],es
	mov     [oldpackof],bx
	mov     dx,offset newpack
	mov     ah,25h
	int     21h
	mov     ax,[comirq]   ;new COM-IRQ
	add     ax,8
	mov     ah,35h
	int     21h
	mov     [oldcomseg],es
	mov     [oldcomof],bx
	mov     dx,offset packcom
	mov     ah,25h
	int     21h
	mov     ax,3513h
	int     21h
	mov     [int13_seg],es
	mov     [int13_ofs],bx
	mov     dx,offset newint13
	mov     ax,2513h
	int     21h
	mov     ax,3528h
	int     21h
	mov     [int28_seg],es
	mov     [int28_ofs],bx
	mov     dx,offset newint28
	mov     ax,2528h
	int     21h
	mov     ax,3529h
	int     21h
	mov     [int29_seg],es
	mov     [int29_ofs],bx
	mov     dx,offset newint29
	mov     ax,2529h
	int     21h
	mov     ax,352fh
	int     21h
	mov     [int2f_seg],es
	mov     [int2f_ofs],bx
	mov     dx,offset newint2f
	mov     ax,252fh
	int     21h
	mov     ax,3508h            ;Timer IRQ
	int     21h
	mov     [int8_seg],es
	mov     [int8_ofs],bx
	mov     dx,offset int8
	mov     ax,2508h
	int     21h
	call    en_comirq
@@:     mov     ax,ds:[2ch]
	mov     es,ax
	mov     ah,49h
	int     21h
	mov     dx,offset instend
	add     dx,100h
	mov     cl,4          ;remove the installprogram
	shr     dx,cl
	inc     dx
	mov     ax,3100h      ;sliplog remains resident
	int     21h           ;return to DOS (Uff!)
quite:     mov     ah,9
	   int     21h
exit:      mov     ax,4cffh
	   int     21h
install endp
	end start

