// Contents ---------------------------------------------------------------
//
//   fingerd.h -- Include file for fingerd
//
//   Version 1.00, a Windows Socket Finger Daemon
//
//   Copyright (C) Frederick W. Bent 1994
//   All rights reserved.
//
//
// Description
//
//
// Ends -------------------------------------------------------------------

// History ----------------------------------------------------------------
//
// 6/28/94  1.0  Fred Bent     	Wrote this thing
//
// Ends -------------------------------------------------------------------

#if !defined(_FINGERD_H_)

#define _FINGERD_H_	1

#ifndef STRICT
#define	STRICT	1
#endif

#include <windows.h>
#include <windowsx.h>
#include <winsock.h>
#include <stdarg.h>
#include "dsplist.h"

#define USE_CTL3D	1		// Use the CTL3D.DLL
#define WINSOCK_BUG	1		// We have a broken Winsock
// #define ASYNC_WRITE	1		// Do not use blocking sockets
#define STRING_UNKNOWN	"localhost"	// can't determine local host name

#define WSVERSION_REQ	0x0101       	// windows sockets version 1.1
#define WSVERSION_MAJOR	HIBYTE(WSVERSION_REQ)
#define WSVERSION_MINOR LOBYTE(WSVERSION_REQ)

/* Application and class names */
#define APP_NAME	"Finger Daemon"
#define APP_CLASS	"Fingerd"

#define	CLASS_NETWORK	"Fingerd.Server"
#define CLASS_SIZE	40

#define HELP_FILE	"fingerd.hlp"

/* Stuff for network setup */
#define FINGER_NAME "finger"		// use database lookup first
#define FINGER_PORT IPPORT_FINGER	// server listens on this port
#define SENDBUFLEN  (1024)		// the size of the send buffer
#define MAXCLIENTS  5			// max # of clients in listen queue

/* .INI file stuff **/

#define SECTION_MAIN	"FingerSrv"
#define ENTRY_DIR	"Path"
#define ENTRY_DEFAULTFILE  	"DefaultFile"
#define ENTRY_DEBUG	"Debug"
#define ENTRY_ONLYSNARK	"OnlySnark"
#define INI_FILE	"fingerd.ini"
#define DEFAULTFILE	"default.txt"   // send this file for null queries


#define MAX_DRIVE	(3)		// max drive
#define MAX_DIR		(256)		// max directory
#define MAX_FNAME	(256)		// max file name length
#define MAX_EXT		(256)		// max extension
#define MAX_PATH	(260)		// max full path name length
#define MAXITEMS	(256)		// number strings in list box
#define MAXLINE     	(80)		// max length of a string
#define MAX_DISP_LINES  (200)		// max lines in main window 132 * 200 = 28672 bytes

/* Debugging stuff */
#define DEBUG_OFF	0
#define DEBUG_ON	1
#define DEBUG_HIGH	2

#define	LOG_TIME	8

/* Macros go here... */

#define dim(x) (sizeof(x) / sizeof(x[0]))

// Data strcutures --------------------------------------------------------

//typedef struct                      // associates an error code with text
//{
//   UINT err;
//   char *sztext;
//} ERRENTRY;
//
typedef struct                      // associates messages (or menu ids)
{                                   // with a handler function
   UINT Code;
   LRESULT (*Fxn)(HWND, UINT, WPARAM, LPARAM);
} DECODEWORD;

#ifdef STRICT
DECLARE_HANDLE(HCLIENT);
#else
typedef HGLOBAL HCLIENT;
#endif

enum tagClientState
{
	STATE_WAIT_FOR_USER
      , STATE_SENDING
      , STATE_SEND_TIME
      , STATE_FINISHED
      , STATE_CLOSING
      , STATE_WSERROR
};

typedef enum tagClientState ClientState;

typedef struct tagCLIENT
{
	SOCKET		sSocket;	     // The clients socket
	HCLIENT		hClient;	     // The memory handle

	SOCKADDR_IN	saPeer;		     // The Internet address of peer
	char		szPeer[MAXLINE];

	ClientState	iState;

	int		iExtErr;

	HFILE		hfFile;		     // The MS-DOS file handle


	/* We need buffers to talk with - unique ones at that */

	HANDLE	hOutputBuffer;       // Handle to output FIFO buffer
	LPSTR	lpOutputBuffer;      // FIFO buffer for output
	int	iOutputSize;
	HANDLE 	hInputBuffer;        // Handle to input FIFO buffer
	LPSTR 	lpInputBuffer;       // FIFO buffer for input
	int 	iInputSize;          // Size of FIFO buffer for input

	/* Keep the buffer state information here... */

	int   	fifoOutputStart;
	int   	fifoOutputStop;
	BOOL	fifoOutputFull;
	int	fifoInputStart;
	int 	fifoInputStop;
	BOOL	fifoInputFull;

	struct tagCLIENT FAR *lpPrevClient; // Link to previous client struct
	struct tagCLIENT FAR *lpNextClient; // Link to next client struct

} CLIENT;

typedef CLIENT FAR*	LPCLIENT;

// Ends -------------------------------------------------------------------

/* Function protptypes */

BOOL 	InitApp(HINSTANCE hInstance);
BOOL 	InitInstance(HINSTANCE hInstance, int nCmdShow);
BOOL	InitFinger(HINSTANCE hInstance, PSTR pFilename);

BOOL	netInit(void);
int	netSendData(LPCLIENT lpClient);
int	netReceiveData(LPCLIENT lpClient);
BOOL	netBlocking(LPCLIENT lpClient);
void	netClose(void);
BOOL	netSelectEvents(LPCLIENT lpClient, long lEvent);
BOOL	netGetTimeAndDate(LPSTR szLine, int iLine);

BOOL CALLBACK AboutDlgProc(HWND hWnd, UINT wMsg, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK DlgProc(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
void DlgGetLogStrings(HWND hDlg, UINT nButton, int iMax);

BOOL CALLBACK FindDirDlgProc(HWND hDlg, UINT nMsg, WPARAM wParam, LPARAM lParam);

LRESULT CALLBACK FrameWndProc(HWND hWnd, UINT wMsg, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK NetWndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT DoMenuAbout(HWND hWnd, UINT wMsg, WPARAM wParam, LPARAM lParam);
LRESULT DoMenuOptions(HWND, UINT, WPARAM, LPARAM);
LRESULT DoMenuHelp(HWND, UINT, WPARAM, LPARAM);
LRESULT DoMenuExit(HWND, UINT, WPARAM, LPARAM);
LRESULT DoEdit(HWND, UINT, WPARAM, LPARAM);
LRESULT DoEditCopy(HWND, UINT, WPARAM, LPARAM);
LRESULT DoEditClear(HWND, UINT, WPARAM, LPARAM);
LRESULT DoEditSelall(HWND, UINT, WPARAM, LPARAM);
LRESULT DoFindDirDlg(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);

LRESULT DoSize(HWND hWnd, UINT wMsg, WPARAM wParam, LPARAM lParam);
LRESULT DoInitMenuPopup(HWND hWnd, UINT wMsg, WPARAM wParam, LPARAM lParam);
LRESULT DoPaint(HWND hWnd, UINT wMsg, WPARAM wParam, LPARAM lParam);
LRESULT DoSetFocus(HWND hWnd, UINT wMsg, WPARAM wParam, LPARAM lParam);
LRESULT DoActivate(HWND hWnd, UINT wMsg, WPARAM wParam, LPARAM lParam);
LRESULT DoVScroll(HWND hWnd, UINT wMsg, WPARAM wParam, LPARAM lParam);
LRESULT DoSetFocus(HWND hWnd, UINT wMsg, WPARAM wParam, LPARAM lParam);
LRESULT DoCreate(HWND hWnd, UINT wMsg, WPARAM wParam, LPARAM lParam);
LRESULT DoCommand(HWND hWnd, UINT wMsg, WPARAM wParam, LPARAM lParam);
LRESULT DoClose(HWND hWnd, UINT wMsg, WPARAM wParam, LPARAM lParam);
LRESULT DoDestroy(HWND hWnd, UINT wMsg, WPARAM wParam, LPARAM lParam);
LRESULT DoQueryEndSession(HWND hWnd, UINT wMsg, WPARAM wParam, LPARAM lParam);

BOOL	fingerSendFile(LPCLIENT lpClient);
//int	clientReceiveLine(LPCLIENT lpClient, LPSTR lpLine, int iLine);

void 	UpdateDisplay(LPSTR szString, int iLen);
void 	SizeWindow(HWND hWnd);
void	FingerFinished(void);

void	FileOpen(HWND hWnd);
BOOL	VerifyDir(PSTR szPath);
void 	Whine(HWND hWnd, PSTR szCaption);
void 	MakeHelpPathName(HINSTANCE hInst, LPSTR szHelpFileName);

void 	SendError(LPCLIENT lpClient, PSTR errstr);
void 	DebugOut(LPSTR lps, ...);
void	DisplayWSError(PSTR str, ...);
PSTR	WSErrorString(UINT err);
void	OkMsgBox(PSTR szCaption, PSTR szFormat, ...);

BOOL	fingerServer(LPCLIENT lpClient);
LPCLIENT fingerSocketToClient(SOCKET sSocket);
LPCLIENT fingerAddClient(SOCKET sSocket);
BOOL 	fingerDestroyClient(LPCLIENT lpClient);
void	fingerLog(int iLevel, int ResourceID, ...);

// External definitions

extern LPCLIENT fingerClientsHead;
extern char szLocalFile[MAX_PATH];
extern char szFileDir[MAX_PATH];
extern BOOL bOnlySnark;

/* Windows stuff.... */

#define IDS_BAD_VERSION		    200
#define IDS_INITIALIZE		    201
#define IDS_FILTER		    202
#define IDS_CONNECT_S		    203
#define IDS_RECV_S		    204
#define IDS_SENT_S		    205
#define IDS_DISCONNECT_S	    206
#define IDS_REQUEST_ERR		    207
#define IDS_EXIT_ACTIVE			208
#define IDS_EXITING			209
#define IDS_DAEMON_START		210
#define IDS_FILE_ERR			211

#define IDL_LOG                     101
#define IDE_PATH                    102
#define IDE_DIR			    111
#define IDB_PATH                    103
#define IDB_DIR			    112
#define IDI_ICON                    104
#define IDI_ICONEMPTY               105
#define IDI_ICONFULL                106
#define IDE_HOSTNAME                107
#define IDR_NORMAL                  108
#define IDR_DEBUG                   109
#define IDR_ONLYSNARK		    110
#define IDE_EDIT			113

#define IDM_ABOUT                   120
#define IDM_OPTIONS		    121
#define IDM_HELP		    122
#define IDM_EXIT		    123
#define IDM_COPY		    124
#define IDM_CLEAR		    125
#define IDM_SELALL		    126

#define	IDL_MAIN		    130

#define IDD_FPATH		    140
#define IDD_FNAME		    141
#define IDD_FLIST		    142

#define WM_LISTEN       (WM_USER + 1)  // listen for connections
#define WM_CONNECTION   (WM_USER + 2)  // connection request awaits
#define WM_GETREQUEST   (WM_USER + 3)  // request is waiting
#define WM_REPLY        (WM_USER + 4)  // start reply

#define NET_BASE     	(WM_USER + 5)  // network messages start here...
#define SOCKET_MESSAGE   NET_BASE
#define NET_NAME        (NET_BASE + 1)

#endif // _FINGERD_H_
