// tcpip.c
// (c) harmony 2001

int print_pkt( struct simple_pkt *pkt )
{
  struct in_addr in, out;
  in.s_addr = pkt->saddr;
  out.s_addr = pkt->daddr;
  printf("------------------------------------------\n");
  printf("IP  Saddr %s", inet_ntoa(in));
  printf("    Daddr %s\n",inet_ntoa(out));
  printf("TCP Sport %d\t\t Dport %d\n", ntohs(pkt->th_sport), ntohs(pkt->th_dport));
  printf("TCP Seq   %u\t Ack   %u\n", ntohl(pkt->th_seq), ntohl(pkt->th_ack));
  printf("TCP Flags");
    if( pkt->th_flags & TH_SYN )
    {
      printf(" SYN");
    }
    if( pkt->th_flags & TH_ACK )
    {
      printf(" ACK");
    }
    if( pkt->th_flags & TH_RST )
    {
      printf(" RST");
    }
    if( pkt->th_flags & TH_FIN )
    {
      printf(" FIN");
    }
    if( pkt->th_flags & TH_PUSH )
    {
      printf(" PSH");
    }
    if( pkt->th_flags & TH_URG )
    {
      printf(" URG");
    }
  printf("\n------------------------------------------\n");
  return 0;
}

int build_tcp_pkt(struct simple_pkt *pkt, char *saddr, char *daddr, short sport, short dport, long seq, long ack, u_char flags)
{
  memset( pkt, 0x00, sizeof( struct simple_pkt ) );
    if( saddr != NULL )
    {
      pkt->saddr = inet_addr( saddr );
    }
    if( daddr != NULL )
    {
      pkt->daddr = inet_addr( daddr );
    }  
    if( sport != 0 )
    {
      pkt->th_sport = htons( sport );
    }  
    if( dport != 0 )
    {
      pkt->th_dport = htons( dport );
    }  

  pkt->th_seq = htonl( seq );
  pkt->th_ack = htonl( ack );
  pkt->th_flags = flags;

  return 0;
}

int compare_pkt(struct simple_pkt *pkt_one, struct simple_pkt *pkt_two)
{

  int success = TRUE;
  
    /* WE DONT TEST WILDCARDS */
    if( pkt_one->saddr != 0x00000000 )
    {
      if( pkt_one->saddr != pkt_two->saddr ){ success--; }
    }

    if( pkt_one->daddr != 0x00000000 )
    {
      if( pkt_one->daddr != pkt_two->daddr ){ success--; }
    }
    
    if( pkt_one->th_sport != 0x0000 )
    {
      if( pkt_one->th_sport != pkt_two->th_sport ){ success--; }      
    }

    if( pkt_one->th_dport != 0x0000 )
    { 
      if( pkt_one->th_dport != pkt_two->th_dport ){ success--; }  
    }

    if( pkt_one->set_seq != FALSE )
    { 
      if( pkt_one->th_seq != pkt_two->th_seq ){ success--; }   
    }

    if( pkt_one->set_ack_seq != FALSE )
    {
      if( pkt_one->th_ack != pkt_two->th_ack ){ success--; }  
    }

    if( pkt_one->th_flags != 0x00000000 )
    {
      if( pkt_one->th_flags != pkt_two->th_flags ){ success--; } 
    }

  return success;
}

int wait_for_tcp_pkt( pcap_t *pcap, struct simple_pkt *pkt)
{
  const struct ethhdr *eth_hdr;
  const struct iphdr *ip_pkt;
  const struct tcphdr *tcp_pkt;
  u_char *packet;
  struct pcap_pkthdr pkthdr;
  struct simple_pkt in_pkt;

    if( pcap == NULL )
    {
      printf("pcap null pointer\n");
      return -1;
    }

    while( 1 )
    {

      packet = (u_char *)pcap_next(pcap, &pkthdr);

        if( (packet != NULL) && ((pkthdr.len - eth_size) >= LIBNET_TCP_H) )
        {

          eth_hdr = (struct ethhdr *)(packet);
          ip_pkt = (struct iphdr *)(packet + sizeof(struct ether_header));
          tcp_pkt = (struct tcphdr *)(packet + sizeof(struct ether_header) + sizeof(struct iphdr));

            /* SANITY CHECK */
            if( ntohs(eth_hdr->h_proto) != ETHERTYPE_IP || ip_pkt->protocol != IPPROTO_TCP )
            {
              continue;
            }

          in_pkt.saddr    = ip_pkt->saddr;
          in_pkt.daddr    = ip_pkt->daddr;
          in_pkt.th_sport = tcp_pkt->th_sport; 
          in_pkt.th_dport = tcp_pkt->th_dport; 
          in_pkt.th_seq   = tcp_pkt->th_seq; 
          in_pkt.th_ack   = tcp_pkt->th_ack; 
          in_pkt.th_flags = tcp_pkt->th_flags; 

            if( compare_pkt( pkt, &in_pkt ) == TRUE )
            {
              memcpy( pkt, &in_pkt, sizeof( struct simple_pkt ));
              break;
            } else {
              continue;
            }

        } else {
          printf("null pointer or dud packet :(\n");
        }

    } // while(1)...

  return 0;
}

int send_tcp_pkt( struct simple_pkt *pkt)
{
  u_char *packet;
  int pkt_size = ( LIBNET_ETH_H + LIBNET_IP_H + LIBNET_TCP_H );
  int wrote;
  struct libnet_link_int *network;

  network = libnet_open_link_interface( INTERFACE, err);
    if( network == NULL )
    {
      libnet_error(LIBNET_ERR_FATAL, "libnet_open_link_interface failed.\n");
      return -1;
    }

  libnet_init_packet(pkt_size, &packet); 
    if (packet == NULL) 
    { 
      libnet_error(LIBNET_ERR_FATAL, "libnet_init_packet failed\n");
      return -1; 
    }

  libnet_build_ethernet( pkt->destMAC, pkt->sourceMAC, ETHERTYPE_IP, NULL, 0, packet);
  libnet_build_ip(LIBNET_TCP_H, IPTOS_LOWDELAY, 242, 0, 64, IPPROTO_TCP, pkt->saddr, pkt->daddr, NULL, 0, packet);
  libnet_build_tcp(ntohs(pkt->th_sport), ntohs(pkt->th_dport), ntohl(pkt->th_seq), ntohl(pkt->th_ack), pkt->th_flags, 1024, 0, NULL, 0, packet + LIBNET_IP_H);


    if (libnet_do_checksum(packet, IPPROTO_IP, LIBNET_IP_H) == -1) 
    { 
        libnet_error(LIBNET_ERR_FATAL, "checksum of IP packet failed.\n");
        return -1; 
    } 

    if (libnet_do_checksum(packet, IPPROTO_TCP, LIBNET_TCP_H) == -1) 
    { 
        libnet_error(LIBNET_ERR_FATAL, "checksum of TCP packet failed.\n");
        return -1; 
    } 

  wrote = libnet_write_link_layer( network, INTERFACE, packet, pkt_size);
    if( wrote < pkt_size )
    {
      libnet_error(LN_ERR_WARNING, "libnet_write_link_layer only wrote %d of %d bytes\n", wrote, pkt_size);
    }

  libnet_destroy_packet( &packet ); 

    if (libnet_close_link_interface( network ) == -1)
    {
      libnet_error(LN_ERR_WARNING, "libnet_close_link_interface failed.\n");
      return -1;
    }

  return 0;
}

int send_simple_tcp_pkt( struct simple_pkt *pkt )
{
  u_char *packet;
  int pkt_size = ( LIBNET_IP_H + LIBNET_TCP_H );
  int wrote, s;

  s = libnet_open_raw_sock( IPPROTO_RAW ); 
    if ( s == -1 ) 
    { 
        libnet_error(LIBNET_ERR_FATAL, "Cant open network.\n"); 
        return -1;
    } 


  libnet_init_packet(pkt_size, &packet); 
    if (packet == NULL) 
    { 
      libnet_error(LIBNET_ERR_FATAL, "libnet_init_packet failed\n");
      return -1; 
    }

  libnet_build_ip(LIBNET_TCP_H, IPTOS_LOWDELAY, 242, 0, 64, IPPROTO_TCP, pkt->saddr, pkt->daddr, NULL, 0, packet);
  libnet_build_tcp(ntohs(pkt->th_sport), ntohs(pkt->th_dport), ntohl(pkt->th_seq), ntohl(pkt->th_ack), pkt->th_flags, 1024, 0, NULL, 0, packet + LIBNET_IP_H);

    if( libnet_do_checksum(packet, IPPROTO_TCP, LIBNET_TCP_H) == -1 ) 
    { 
        libnet_error(LIBNET_ERR_FATAL, "libnet_do_checksum failed\n");
        return -1; 
    } 

	
  wrote = libnet_write_ip(s, packet, pkt_size); 
    if( wrote < pkt_size ) 
    { 
        libnet_error(LN_ERR_WARNING, "libnet_write_ip only wrote %d bytes\n", wrote);
    }

  libnet_destroy_packet( &packet ); 

    if( libnet_close_raw_sock( s ) == -1 ) 
    { 
      libnet_error(LN_ERR_WARNING, "libnet_close_raw_sock failed\n");
      return -1;
    } 

  return 0;
}

