// epifiny.h
// (c) harmony 2001

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <netinet/if_ether.h>
#include <netinet/ether.h>
#include <arpa/inet.h>
#include <net/ethernet.h>
#include <net/if_arp.h>
#include <pcap.h>
#include <libnet.h>

#define  INTERFACE       "eth0"

#define  TRUE            1
#define  FALSE           0
#define  ARP_ETHER       1
#define  ARP_REPLY       2
#define  MAC_ADDR_LEN    6
#define  IP_ADDR_LEN     4
#define  DUMMY_MAC       "\x00\x00\x00\x00\x00\x00"
#define  BROADCAST_MAC   "\xFF\xFF\xFF\xFF\xFF\xFF"

int  eth_size;
char err[LIBNET_ERRBUF_SIZE];

struct simple_pkt {
  u_char sourceMAC[6], destMAC[6];
  u_int32_t saddr, daddr;
  u_int16_t th_sport, th_dport;
  u_int32_t th_seq, th_ack;
  u_char th_flags;
  char *data;
  u_int8_t set_seq, set_ack_seq;
};

struct simple_arp_pkt {
  u_char sourceMAC[6], destMAC[6];
  u_int32_t saddr, daddr;
  int arp_type;
};

struct arp_pkt_hdr {
        unsigned short int arp_hw_type;
        unsigned short int arp_proto;
        u_char arp_hw_len;
        u_char arp_proto_len;
        unsigned short int arp_oper;
        u_char arp_hw_src[6];
        u_char arp_ip_src[4];
        u_char arp_hw_dst[6];
        u_char arp_ip_dst[4];
};

// tcpip.c
int print_pkt( struct simple_pkt *pkt );
int build_tcp_pkt( struct simple_pkt *pkt, char *saddr, char *daddr, short sport, short dport, long seq, long ack, u_char flags);
int compare_pkt(struct simple_pkt *pkt_one, struct simple_pkt *pkt_two);
int wait_for_tcp_pkt( pcap_t *pcap, struct simple_pkt *pkt);
int send_tcp_pkt( struct simple_pkt *pkt );
int send_simple_tcp_pkt( struct simple_pkt *pkt );

// arp.c
int spoof_arp_pkt( int ARP_TYPE, u_char destMAC[6], u_char sourceMAC[6], u_long destIP, u_long sourceIP);
int wait_for_arp_pkt( pcap_t *pcap, struct simple_arp_pkt *pkt);
int resolve_ip_to_mac( pcap_t *pcap, char *ip_addr, u_char *mac_addr );
int print_mac( u_char *mac_addr );

