// arp.c
// (c) harmony 2001

int spoof_arp_pkt( int ARP_TYPE, u_char sourceMAC[6], u_char destMAC[6], u_long sourceIP, u_long destIP)
{
  int retval;
  int packet_size = LIBNET_ETH_H + LIBNET_ARP_H;  
  u_char *packet;
  struct libnet_link_int *network;
  char err[LIBNET_ERRBUF_SIZE];

  libnet_init_packet( packet_size, &packet);  
    if( packet == NULL )
    {
      printf("libnet_init_packet: error.\n");
      return -1;;
    }


    if( ARP_TYPE == ARPOP_REQUEST )
    {
      retval = libnet_build_ethernet( BROADCAST_MAC, sourceMAC, ETHERTYPE_ARP, NULL, 0, packet);
    } else {
      retval = libnet_build_ethernet( destMAC, sourceMAC, ETHERTYPE_ARP, NULL, 0, packet);
    }

    if( retval == -1 )
    {
      printf("libnet_build_ethernet failed.\n");
      return -1;
    }



#define ARP_FRAME_TYPE 0x0806
// ARPOP_REPLY
#define IP_PROTO_TYPE 0x0800

  retval = libnet_build_arp( ARP_ETHER, ETHERTYPE_IP, MAC_ADDR_LEN, IP_ADDR_LEN, ARP_TYPE, sourceMAC, (u_char *)&sourceIP, destMAC, (u_char *)&destIP, NULL, 0, (packet + LIBNET_ETH_H));
    if( retval == -1 )
    {
      printf("libnet_build_arp failed.\n");
      return -1;
    }

  network = libnet_open_link_interface( INTERFACE, err);
    if( network == NULL )
    {
      perror("libnet_open_link_interface failed.\n");
      return -1;
    }

  retval = libnet_write_link_layer( network, INTERFACE, packet, packet_size);
    if( retval < packet_size )
    {
      printf("libnet_write_link_layer only wrote %d of %d bytes\n", retval, packet_size);
    }	

    if (libnet_close_link_interface( network ) == -1)
    {
      perror("libnet_close_link_interface failed.\n");
      return -1;
    }

  libnet_destroy_packet( &packet ); 
  return 0;
}

int wait_for_arp_pkt( pcap_t *pcap, struct simple_arp_pkt *pkt)
{
  const struct ethhdr *eth_hdr;
  const struct arp_pkt_hdr *arp_pkt;
  u_char *packet;
  struct pcap_pkthdr pkthdr;
  char buff[32];
  struct in_addr in;

    if( pcap == NULL )
    {
      printf("pcap null pointer\n");
      return -1;
    }

    while( 1 )
    {

      packet = (u_char *)pcap_next(pcap, &pkthdr);

        if( (packet != NULL) && ((pkthdr.len - eth_size) >= LIBNET_ARP_H) )
        {

          eth_hdr = (struct ethhdr *)(packet);
          arp_pkt = (struct arp_pkt_hdr *)(packet + sizeof(struct ether_header));

            /* SANITY CHECK */
            if( ntohs(eth_hdr->h_proto) != ETHERTYPE_ARP )
            {
              continue;
            }

              switch( ntohs(arp_pkt->arp_oper) )
              {
                case ARPOP_REPLY:
                  sprintf(buff, "%d.%d.%d.%d", arp_pkt->arp_ip_src[0], arp_pkt->arp_ip_src[1], arp_pkt->arp_ip_src[2], arp_pkt->arp_ip_src[3]);
                  in.s_addr = pkt->saddr;
                    if( strcmp( buff, (char*)inet_ntoa( in )) == 0 )
                    {
                      memcpy( pkt->sourceMAC, arp_pkt->arp_hw_src, sizeof(pkt->sourceMAC));
                      return 0;
                    }
                  break;
                case ARPOP_REQUEST:
                  break;
                default:
                  break;
              }

        } else {
          printf("null pointer or dud packet :(\n");
        }

    } // while(1)...

  return -1;
}

int resolve_ip_to_mac( pcap_t *pcap, char *ip_addr, u_char *mac_addr )
{
  struct simple_arp_pkt arppkt;
  char err[LIBNET_ERRBUF_SIZE];
  struct libnet_link_int *network;
  u_long my_ip_addr;
  struct ether_addr *my_eth_addr;

  memset( &arppkt, 0x00, sizeof( struct simple_arp_pkt ) );
  arppkt.saddr = inet_addr( ip_addr );
  arppkt.arp_type = ARPOP_REPLY;

  network = libnet_open_link_interface( INTERFACE, err);
    if( network == NULL )
    {
      perror("libnet_open_link_interface failed.\n");
      return -1;
    }

  my_ip_addr = libnet_get_ipaddr( network, INTERFACE, err);
    if( my_ip_addr == 0 )
    {
      printf("uh oh ...problems but i will try to continue!\n");
    }

  my_eth_addr = libnet_get_hwaddr( network, INTERFACE, err);
    if( my_eth_addr == 0 )
    {
      printf("uh oh ...problems but i will try to continue!\n");
    }

    if (libnet_close_link_interface( network ) == -1)
    {
      perror("libnet_close_link_interface failed.\n");
      return -1;
    }

    if( spoof_arp_pkt( ARPOP_REQUEST, (u_char*)my_eth_addr, DUMMY_MAC, htonl(my_ip_addr), inet_addr( ip_addr )) != 0 )
    {
      printf("failed to spoof an arp packet :(\n");
      return -1;
    }

    if( wait_for_arp_pkt( pcap, &arppkt) != 0 )
    {
      printf("failed to wait for an arp packet :(\n");
      return -1;
    }
  memcpy( mac_addr, arppkt.sourceMAC, sizeof(arppkt.sourceMAC));
  return 0;
}

int print_mac( u_char *mac_addr )
{
  printf("%2.2X",  mac_addr[0]);
  printf(":%2.2X", mac_addr[1]);
  printf(":%2.2X", mac_addr[2]);
  printf(":%2.2X", mac_addr[3]);
  printf(":%2.2X", mac_addr[4]);
  printf(":%2.2X", mac_addr[5]);
  return 0;
}


