unit StrHlp;
{$I DEF.INC}
interface
uses
  Classes,
  WinProcs,
  SysUtils;
const
  BegChar=1;
  {$ifndef WIN32}
  MaxStrLen=255;
  {$else}
  MaxStrLen=65535;
  {$endif}
  separator: char = ' ';
  SPACE = ' ';
  CR = #13;
  LF = #10;
  CRLF = #13+#10;

type
  TNickList = class (TStringList)
    function NickIndexOf(const name: String): Integer;
    function WildIndexOf(const name: String): Integer;
    function IRCWildIndexOf(const name: String): Integer;
    function ChangeNick(const name1, name2: String): Integer;
  end;

function SafeIntToStr(s: LongInt): String;
function SafeStrToInt(const s: String): LongInt;
function UpCaseStr(const s:string):string;
function IRCUpCase(const s:string):string;
function RandomString(len: Word):string;
function RandomLenString(len: Word):string;
function ExpandString(const s: String; nl: Integer; ch: Char): String;
function MakeListString(sl: TStringList; ndx: Integer): String;
function WildMatch(const str1, wild:string): Boolean;
function NumChars(const s: String; ch: Char): Word;
function FindChar(const s: String; ch: Char): Integer;
procedure ShortenLen(var s:string; num:word);
{$IFNDEF WIN32}
procedure SetLength(var s: String; num:word);
{$ENDIF}
function Word2Bool (const s:string):boolean;
function OnOffWord(b: boolean):string;
function YesNoWord(b: boolean):string;
procedure Break2Words(const s:string; SL:tStringList);
function ClearStatusChar(const nick:string):string;
function GetWord(const s:string; n:integer):string;
function DelTrailing(const s:string; ch:char):string;
procedure WriteLogEntry(const fname, s:string);
function GetLastWord(const s: String): String;
function GetNumWords(const s: String): Integer;
procedure DeleteWord(const s1: String; var s2: String);
function WildStringMatch(const s1, s2: String): Boolean;
function MakeString(ch: Char; nm: Word): String;
procedure TrimTrailingSpaces(var s: String);
procedure TrimLeadingSpaces(var s: String);
function HasNameExt(const s: String): Boolean;

var
  ply: LongInt;
  UpArray: array [0..255] of Char;
  UpNormArray: array [0..255] of Char;
  WordParse, WordParse2: TStringList;

implementation

function HasNameExt(const s: String): Boolean;
begin
  result:=(ExtractFileExt(s)='');
end;

procedure TrimLeadingSpaces(var s: String);
var
  n, i: Word;
begin
  i:=0;
  for n:=BegChar downto length(s) do
  if s[n]=SPACE then Inc(i) else Break;
  Inc(n);
  if i>0 then
    System.Delete(s, n, i);
end;

procedure TrimTrailingSpaces(var s: String);
var
  n, i: Word;
begin
  i:=0;
  for n:=length(s) downto BegChar do
  if s[n]=SPACE then Inc(i) else Break;
  if i>0 then
    ShortenLen(s, i);
end;

function MakeString(ch: Char; nm: Word): String;
var
  n: Integer;
begin
  for n:=BegChar to BegChar+nm do
    result[n]:=ch;
  SetLength(result, nm);
end;

function StrPCopy(Dest: PChar; Source: String): PChar;
begin
  result:=lstrcpyn(Dest, @Source[BegChar], length(Source));
  if result=nil then Exit;
  result[length(Source)+1]:=#0;
end;

function StrPas(p: PChar): String;
var
  n: Word;
begin
  lstrcpyn(@result[BegChar], p, SizeOf(result));
  n:=lstrlen(p);
  if n>SizeOf(result) then n:=SizeOf(result);
  SetLength(result, n);
end;

procedure WriteLogEntry(const fname, s:string);
var
  f:text;
begin
  Assign(f, fname);
  Reset(f);
  if IOResult<>0 then ReWrite(f);
  Append(f);
  Writeln(f, s);
  Close(f);
end;

function DelTrailing(const s: String; ch: Char): String;
begin
  result:=s;
  if result[BegChar]=ch then Delete(result, BegChar, 1);
  if result[length(result)]=ch then ShortenLen(result, 1);
end;

function GetWord(const s: String; n: Integer): String;
begin
  result:='';
  Break2Words(s, WordParse);
  if n>WordParse.Count-1 then Exit;
  result:=WordParse[n];
end;

function GetNumWords(const s: String): Integer;
begin
  Break2Words(s, WordParse);
  result:=WordParse.Count;
end;

procedure DeleteWord(const s1: String; var s2: String);
var
  n: Integer;
begin
  n:=Pos(s1, s2);
  if n=0 then exit;
  Delete(s2, n, length(s1));
end;

function GetLastWord(const s:string):string;
begin
  result:='';
  Break2Words(s, WordParse);
  result:=WordParse[WordParse.Count-1];
end;

function ClearStatusChar(const nick:string):string;
begin
  result:=nick;
  if (result[BegChar]='@') or (result[BegChar]='+') then
    delete(result, BegChar, 1);
end;

procedure Break2Words(const s:string; SL:tStringList);
var
  n, m:byte;
begin
  m:=0;
  with SL do
    begin
      Clear;
      Add('');
      for n:=1 to length(s) do
        begin
          if (s[n]=separator) and (s[n+1]<>separator) then begin Inc(m); Add(''); continue; end;
          Strings[m] := Strings[m] + s[n];
        end;
    end;
end;

function OnOffWord(b: boolean):string;
begin
  Result:='ON';
  if not b then Result:='OFF';
end;

function YesNoWord(b: boolean):string;
begin
  Result:='YES';
  if not b then Result:='NO';
end;

function Word2Bool (const s:string):boolean;
begin
  result:=(UpCaseStr(s)='YES') or (UpCaseStr(s)='ON');
end;

{$IFNDEF WIN32}
procedure SetLength(var s: String; num: Word);
begin
  s[0]:=Char(num);
end;
{$ENDIF}

procedure ShortenLen(var s: String; num: Word);
begin
{$IFNDEF WIN32}
  if ord(s[0])>0 then
    dec(s[0], byte(num));
{$ELSE}
  SetLength(s, length(s)-num);
{$ENDIF}
end;

function MakeListString(sl:TStringList; ndx:integer):string;
var
  n:integer;
begin
  result:='';
  with sl do
    begin
      if ndx>count-1 then exit;
      for n:=ndx to count-1 do
        result:=result+strings[n]+' ';
      ShortenLen(result, 1);
    end;
end;

function ExpandString(const s:string; nl:integer; ch:char):string;
var
  n:integer;
begin
  result:=s;
  for n:=length(s) to nl-1 do
    result:=result + ch;
end;

function tNickList.NickIndexOf(const name:string):integer;
var
  s: String;
begin
  if name='' then Exit;
  s:=ClearStatusChar(name);
  result:=IndexOf(s);
  if result<>-1 then exit;

  result:=IndexOf('@'+s);
  if result<>-1 then exit;

  result:=IndexOf('+'+s);
end;

function tNickList.WildIndexOf(const name:string):integer;
var
  n:integer;
begin
  result:=-1;
  for n:=0 to count-1 do
    if WildMatch(name, strings[n]) then
    begin
      result:=n;
      exit;
    end;

  if (result=-1) and (NumChars(name, '*')<>0) then
  for n:=0 to count-1 do
    if WildMatch(strings[n], name) then
    begin
      result:=n;
      exit;
    end;
end;

function tNickList.IRCWildIndexOf(const name:string):integer;
var
  n:integer;
begin
  result:=-1;
  for n:=0 to count-1 do
    if WildMatch(IRCUpCase(name), IRCUpCase(strings[n])) then
    begin
      result:=n;
      exit;
    end;

  if (result=-1) and (NumChars(name, '*')<>0) then
  for n:=0 to count-1 do
    if WildMatch(IRCUpCase(strings[n]), IRCUpCase(name)) then
    begin
      result:=n;
      exit;
    end;
end;

function tNickList.ChangeNick(const name1, name2:string):integer;
var
  n: Integer;
  n2, n1:string;
begin
  n:=NickIndexOf(name1);
  if n=-1 then exit;
  n1:=Strings[n];
  n2:=name2;
  case n1[1] of
    '@': System.Insert('@', n2, 1);
    '+': System.Insert('+', n2, 1);
  end;
  Strings[n]:=n2;
end;

function UpCaseStr(const s:string):string;
var
  n: Word;
begin
SetLength(result, length(s));
for n:=BegChar to length(s) do
  result[n]:=UpNormArray[Byte(s[n])];
end;

function IRCUpCase(const s:string):string;
var
  n: Word;
begin
SetLength(result, length(s));
  for n:=BegChar to length(s) do
    result[n]:=UpArray[Byte(s[n])];
end;

function SafeIntToStr(s: LongInt): String;
begin
  Str(s, result);
end;

function SafeStrToInt(const s: String): LongInt;
var
  code: Integer;
begin
  Val(s, result, code);
  if code<>0 then result:=-1;
end;

function RandomString(len: Word): String;
var
  n: Byte;
begin
  for n:=1 to len do
    result[n]:=Chr(Random(25) + ord('a'));
  SetLength(result, len);
end;

function RandomLenString(len: Word): String;
var
  n:byte;
begin
  len:=Random(len-4)+4;
  for n:=1 to len do
    result[n]:=Chr(Random(25) + ord('a'));
  SetLength(result, len);
end;

function NumChars(const s: String; ch: Char): Word;
var
  n: Integer;
begin
result:=0;
  for n:=BegChar to length(s) do
    if s[n]=ch then Inc(result);
end;

function VprMatch(const str1, str2:string):boolean;
var
  n:integer;
begin
  result:=false;
  if length(str1)<>length(str2) then exit;
  for n:=1 to length(str1) do
    if (str1[n]<>str2[n]) and ((str1[n]<>'?') and (str2[n]<>'?')) then
      exit;
  result:=true;
end;

function WildStringMatch(const s1, s2: String): Boolean;
var
  fi, se: String;
  n: Integer;
begin
  result:=False;
  if length(s1)>length(s2) then
  begin
    fi:=s1;
    se:=s2;
  end
  else
  begin
    fi:=s2;
    se:=s1;
  end;

  Break2Words(fi, WordParse);
  Break2Words(se, WordParse2);

  for n:=0 to WordParse.Count-1 do
  begin
    if not WildMatch(WordParse[n], WordParse2[n]) then Break;
  end;
  result:=True;
end;

function WildMatch(const str1, wild:string):boolean;
var
  num, n:integer;
  s, s2:string;
begin
  result:=false;
  s:=wild;
  if wild='*' then begin result:=true; exit; end;
  num:=NumChars(wild, '*');
  if num>=3 then exit;
  if num=0 then result:=(wild=str1);
  if (num=2) and (s[BegChar]<>'*') and (s[length(s)]<>'*') then exit;
  if num=2 then
  begin
    delete(s, BegChar, 1);
    ShortenLen(s, 1);
    result:=(pos(s, wild)<>0);
    exit;
  end;

  if (num=1) and (s[BegChar]='*') then
  begin
    delete(s, BegChar, 1);
    if length(str1)>length(s) then
    begin
      s2:=ExpandString('', length(str1)-length(s), '?');
      s:=s2+s;
    end;
    result:=VprMatch(str1, s);
    exit;
  end;

  if (num=1) and (s[length(s)]='*') then
  begin
    delete(s, length(s), 1);
    if length(str1)>length(s) then
    s:=ExpandString(s, length(str1), '?');
    result:=VprMatch(str1, s);
    exit;
  end;

  if (num=1) and (s[BegChar]<>'*') and (s[length(s)]<>'*') and
     (length(str1)=length(wild)) then
  begin
    n:=Pos('*', wild);
    result:=(Pos(Copy(str1, BegChar, n), str1)<>0) and
            (Pos(Copy(str1, n+1, length(str1)), str1)<>0);
  end;

end;

function FindChar(const s: String; ch: Char): Integer;
var
  n: Integer;
begin
  result:=-1;
  for n:=length(s) downto BegChar do
  if s[n]=ch then
  begin
    result:=n;
    Break;
  end;
end;

var
  StrExitProc:Pointer;

procedure FreeMyList; far;
begin
  ExitProc:=StrExitProc;
  WordParse.Free;
  WordParse2.Free;
end;

var
  n:Integer;

begin
  StrExitProc:=ExitProc;
  ExitProc:=@FreeMyList;

  WordParse:=TStringList.Create;
  WordParse2:=TStringList.Create;

  for n:=0 to 255 do
  begin
    UpArray[n]:=UpCase(chr(n));
    UpNormArray[n]:=UpCase(chr(n));
  end;

  UpArray[Ord('{')]:='[';
  UpArray[Ord('}')]:=']';
  UpArray[Ord('|')]:='\';

  Randomize;
end.
