unit RTimer;

interface
uses
  WinTypes, WinProcs, Messages, Classes;

const
  WName: PChar = 'BeeRCTimerWindow';
  TimerRes : Word = 500;

type
  TTimerMethod = procedure(Identifier: Word) of object;
  PTimerRecord = ^TTimerRecord;
  TTimerRecord = record
    Identifier, TimeRest: Integer;
    TimerMethod: TTimerMethod;
    TimeOut: Integer;
  end;

  function AllocateTimer(Ident, TOut: Word; Method: TTimerMethod): Integer;
  procedure DeAllocateTimer(Ident: Word);
  procedure Delay(Time: Word);
  procedure Yield;

const
  MaxTimers = 20;

var
  Wait: Boolean;
  KillHandle: Word;

implementation

function RegisterProcedure(CallBack: Pointer): Boolean; far; external 'TIMERSRV' index 1;

var
  TimerList: array [0..MaxTimers-1] of TTimerRecord;
  Wnd: HWND;
  NumTimers: Integer;
  InTimer: Boolean;

function FindTimerIdent(Ident: Word): Integer;
var
  n: Integer;
begin
  result:=-1;
  for n:=0 to NumTimers-1 do
  if TimerList[n].Identifier=Ident then
  begin
    result:=n;
    break;
  end;
end;

procedure WindowTimerProc(Wnd: HWND; Msg, idTimer: Word;
                          dwTime: LongInt); export;
var
  n: Integer;
begin
  if Msg<>WM_TIMER then Exit;
  for n:=0 to NumTimers-1 do
  with TimerList[n] do
  begin
    if TimeRest>0 then
       Dec(TimeRest, TimerRes);
    if TimeRest<=0 then
    begin
      if not InTimer then
      begin
        InTimer:=True;
        if Assigned(TimerMethod) then
          TimerMethod(Identifier);
        TimeRest:=TimeOut;
        InTimer:=False;
      end;
    end;
  end;
end;

procedure Delay(Time: Word);
var
  M: TMsg;
  MsgRcvd: Boolean;
  WinClass: TWndClass;
begin
  if Time=0 then Exit;
  Wait:=True;
  if not GetClassInfo(hInstance, WName, WinClass) then
  begin
    FillChar(WinClass, SizeOf(WinClass), 0);
    with WinClass do
    begin
      lpfnWndProc:=@WindowTimerProc;
      lpszClassName:=WName;
      hInstance:=System.hInstance;
    end;

    WinProcs.RegisterClass(WinClass);
    Wnd:=CreateWindow(WName, 'YOYOYO!', WS_POPUP,
                    0, 0, 0,
                    0, 0, 0,
                    hInstance, nil);
  end;

  SetTimer(Wnd, 0, Time, nil);
  MsgRcvd := False;
  repeat
    GetMessage(M, Wnd, 0, 0);
    if M.Message = wm_Timer then
      MsgRcvd := True
    else
    begin
      TranslateMessage(M);
      DispatchMessage(M);
    end;
  until MsgRcvd or (Wait=False);
  KillTimer(Wnd, 0);
  Wait:=False;
end; { Delay }

procedure Yield;
var
  msg: TMsg;
begin
  if InSendMessage then Exit;
  while True do
  begin
    if not GetMessage(msg, 0, 0, 0) then Break;
    TranslateMessage(msg);
    DispatchMessage(msg);
    if not(PeekMessage(msg, 0, 0, 0, PM_REMOVE)) then Break;
  end;
end;

function AllocateTimer(Ident, TOut: Word; Method: TTimerMethod): Integer;
var
  NRec: TTimerRecord;
  WinClass: TWndClass;
begin
  result:=0;
  with NRec do
  begin
    TimerMethod:=Method;
    Identifier:=Ident;
    TimeOut:=TOut;
    TimeRest:=TOut;
  end;
  TimerRes:=200;
  TimerList[NumTimers]:=NRec;
  result:=Ident;
  Inc(NumTimers);
end;

procedure DeAllocateTimer(Ident: Word);
var
  n: Integer;
begin
  n:=FindTimerIdent(Ident);
  if n=-1 then Exit;
  if NumTimers>0 then Dec(NumTimers);
  TimerList[n]:=TimerList[NumTimers];
  TimerList[n].TimerMethod:=nil;
end;

var
  WinExitProc: Pointer;

procedure WindowExitProc; far;
var
  WinClass: TWndClass;
begin
  ExitProc:=WinExitProc;
  KillTimer(KillHandle, $666);
end;

begin
  FillChar(TimerList, SizeOf(TimerList), 0);
  InTimer:=False;
  KillHandle:=SetTimer(0, $666, TimerRes, @WindowTimerProc);
  WinExitProc:=ExitProc;
  ExitProc:=@WindowExitProc;
end.

