unit Enlist;
interface
uses
  WinTypes,
  WinProcs,
  StrHlp,
  Jobbr,
  WinSock,
  RTimer;

const IJobs: Integer=20;

type
  TEnLister = class
    function Enable(const Host: String): Integer;
    procedure JobProcess(Job: Integer; JobEvent: Word);
    destructor Destroy; override;
    private
      destaddr: TIn_Addr;
    public
      Port: Word;
  end;

var
  ply: LongInt;
  IdentFun:TEnlister;

implementation

destructor TEnLister.Destroy;
begin
  inherited Destroy;
end;

procedure TEnLister.JobProcess(Job: Integer; JobEvent: Word);
var
  n, m: Integer;
begin
  case JobEvent of
    FD_CLOSE:
      begin
        InetJob.DeleteJob(Job);
        m:=InetJob.CreateJob(JobProcess, SOCK_STREAM, IPPROTO_IP, FD_CLOSE);
        if m<0 then Exit;
        WriteLn('Job destroyed!');
        InetJob.ConnectJobImplicit(m, destaddr, Port);
        WriteLn('Job created!');
      end;
  end;
end;

function TEnLister.Enable(const Host: String): Integer;
var
  n, m: Integer;
begin
  result:=-1;
  if not InetJob.ResolveAddress(Host, destaddr) then Exit;
  result:=-2;
  for n:=0 to IJobs-1 do
  begin
    m:=InetJob.CreateJob(JobProcess, SOCK_STREAM, IPPROTO_IP, FD_CLOSE);
    if m>=0 then
      WriteLn(SafeIntToStr(n)+': Job created!')
    else
      WriteLn('Job creation failed!');
    InetJob.ConnectJobImplicit(m, destaddr, Port);
  end;
  result:=0;
end;

var
  OldExitProc: Pointer;

procedure IExitProc; far;
begin
  ExitProc:=OldExitProc;
  IdentFun.Free;
end;

begin
  try
    IdentFun:=TEnlister.Create;
  except
    IdentFun:=nil;
  end;
  OldExitProc:=ExitProc;
  ExitProc:=@IExitProc;
end.
