unit Listen2;
interface
uses Jobbr, Winsock, StrHlp;

const
  ITIME_OUT = 60;
  JTag = $65;
  SPCOSP = SPACE + ':' + SPACE;
  IdentSystem : String [4] = 'UNIX';
  IdentPort : Word = 113;

type
   TListener = class
     constructor Create;
     destructor Destroy; override;
     procedure Listener(Job:Integer; JobEvent: Word);
     procedure Disable;
     function Enable: Boolean;
     function GetIdentStruct(s: TSocket):Boolean;
     private
       Job: Integer;
       Sock: TSocket;
       IdentEnabled: Boolean;
   end;

var
  ply: LongInt;
  Listener: TListener;

implementation
var
  OldProc: Pointer;

procedure TListener.Disable;
begin
  if not IdentEnabled or not wsInitialized then exit;
  InetJob.DeleteJob(Job);
  IdentEnabled:=False;
end;

function TListener.GetIdentStruct(s:TSocket): Boolean;
var
  buf: String;
  len:integer;
  cpos:integer;
begin
  result:=false;
  len:=recv(s, @buf[1], SizeOf(buf), 0);
  if (len>SizeOf(buf)) then Exit;
  buf[0]:=chr(len-2);
  if (SafeStrToInt(GetWord(buf, 2))<0) then Exit;
  begin
    WriteLn(buf);
    buf:=buf +SPCOSP+'USERID'+SPCOSP+UpCaseStr(IdentSystem)+SPCOSP+RandomLenString(9)+CRLF;
    send(s, @buf[1], length(buf), 0);
  end;
  result:=True;
end;

procedure TListener.Listener(Job:Integer; JobEvent: Word);
var
  n:integer;
  news:TSocket;
  newj:Integer;
  saddr: TSockAddr;
  addrlen:integer;

begin
  case JobEvent of
  FD_ACCEPT:
     begin
       addrlen:=SizeOf(saddr);
       news:=Accept(sock, @saddr, @addrlen);
       if news=INVALID_SOCKET then Exit;
       newj:=InetJob.CreateJobIndirect(Listener, SOCK_STREAM, IPPROTO_IP,
                                       FD_READ or FD_WRITE or FD_CLOSE,
                                       news);
       if newj=-1 then begin CloseSocket(news); exit; end;
       InetJob.SetTimeOut(newj, ITIME_OUT);
       InetJob.SetJobTag(newj, JTag);
     end;

  FD_READ:
     begin
       if InetJob.GetJobTag(Job)=JTag then
       begin
         GetIdentStruct(InetJob.GetJobSocket(Job));
         InetJob.DeleteJob(Job);
       end;
     end;

  FD_CLOSE:
     InetJob.DeleteJob(Job);
  end;
end;

constructor TListener.Create;
begin
  inherited Create;
end;

function TListener.Enable;
begin
  result:=False;
  if IdentEnabled or not wsInitialized then Exit;

  Job:=InetJob.CreateJob(Listener, SOCK_STREAM, IPPROTO_IP,
                         FD_READ or FD_WRITE or FD_ACCEPT);
  if Job=-1 then Exit;

  if not InetJob.BindJob(Job, '0', IdentPort) then
  begin
    InetJob.DeleteJob(Job);
    Exit;
  end;

  IdentEnabled:=True;
  Sock:=InetJob.GetJobSocket(Job);
  WinSock.Listen(Sock, 5);
  result:=True;
end;

destructor TListener.Destroy;
begin
  InetJob.BindJob(Job, '0', 0);
  InetJob.DeleteJob(Job);
  inherited Destroy;
end;

procedure MExitProc; far;
begin
  ExitProc:=OldProc;
  Listener.Free;
end;

begin
  OldProc:=ExitProc;
  Listener:=TListener.Create;
end.
