Attribute VB_Name = "modRijnDaelAlgorithm"
Option Explicit
Option Base 0
' Please read the Readme.rtf file which should have been
' included in the zip file.

' note on C bitwise operators here and VB equivalents
' & = Bitwise AND = And
' | = Bitwise Inclusive OR = Or
' ^ = Bitwise Exclusive OR = Xor
' << = Left Shift = {No equivalent}
' >> = Right Shift = {No equivalent}
' ~ = One's complement = Not
'
' I am reliably informed that in VB 7 new operators will be
' introduced for the above operations:
' & = BitAnd
' | = BitOr
' ^ = BitXor
'
' etc.
' Please bear this in mind if compiling using VB7 (or it won't work)!
' Additionally, if those lovely people at Microsoft ever
' allow VB to do bit shifting, please change all the calls
' to the LshL and LshR functions.  Sigh.
'   - Jonathan Daniel.   bigcalm@hotmail.com

Private Initialised As Boolean
Private Te0(256) As Long
Private Te1(256) As Long
Private Te2(256) As Long
Private Te3(256) As Long
Private Te4(256) As Long
Private Td0(256) As Long
Private Td1(256) As Long
Private Td2(256) As Long
Private Td3(256) As Long
Private Td4(256) As Long
Private Rcon(10) As Long

' Original C Source for header...
'
'/**
' * rijndael-alg-fst.c
' *
' * @version 3.0 (December 2000)
' *
' * Optimised ANSI C code for the Rijndael cipher (now AES)
' *
' * @author Vincent Rijmen
' * @author Antoon Bosselaers
' * @author Paulo Barreto
' *
' * This code is hereby placed in the public domain.
' *
' * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY EXPRESS
' * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
' * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
' * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE
' * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
' * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
' * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
' * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
' * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
' * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
' * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
' */
'#include <assert.h>
'#include <stdlib.h>
'
'#include "rijndael-alg-fst.h"
'
'/*
'Te0[x] = S [x].[02, 01, 01, 03];
'Te1[x] = S [x].[03, 02, 01, 01];
'Te2[x] = S [x].[01, 03, 02, 01];
'Te3[x] = S [x].[01, 01, 03, 02];
'Te4[x] = S [x].[01, 01, 01, 01];
'
'Td0[x] = Si[x].[0e, 09, 0d, 0b];
'Td1[x] = Si[x].[0b, 0e, 09, 0d];
'Td2[x] = Si[x].[0d, 0b, 0e, 09];
'Td3[x] = Si[x].[09, 0d, 0b, 0e];
'Td4[x] = Si[x].[01, 01, 01, 01];
'*/
'
'
'#define SWAP(x) (_lrotl(x, 8) & 0x00ff00ff | _lrotr(x, 8) & 0xff00ff00)
'
'#ifdef _MSC_VER
'#define GETU32(p) SWAP(*((u32 *)(p)))
'#define PUTU32(ct, st) { *((u32 *)(ct)) = SWAP((st)); }
'#Else
'#define GETU32(pt) (((u32)(pt)[0] << 24) ^ ((u32)(pt)[1] << 16) ^ ((u32)(pt)[2] <<  8) ^ ((u32)(pt)[3]))
'#define PUTU32(ct, st) { (ct)[0] = (u8)((st) >> 24); (ct)[1] = (u8)((st) >> 16); (ct)[2] = (u8)((st) >>  8); (ct)[3] = (u8)(st); }
'#End If
'
'/**
' * Expand the cipher key into the encryption key schedule.
' *
' * @return  the number of rounds for the given cipher key size.
' */


Public Sub InitialiseRijnDaelArrays()
If Initialised = True Then
    Exit Sub
End If
Initialised = True
Te0(0) = &HC66363A5
Te0(1) = &HF87C7C84
Te0(2) = &HEE777799
Te0(3) = &HF67B7B8D
Te0(4) = &HFFF2F20D
Te0(5) = &HD66B6BBD
Te0(6) = &HDE6F6FB1
Te0(7) = &H91C5C554
Te0(8) = &H60303050
Te0(9) = &H2010103
Te0(10) = &HCE6767A9
Te0(11) = &H562B2B7D
Te0(12) = &HE7FEFE19
Te0(13) = &HB5D7D762
Te0(14) = &H4DABABE6
Te0(15) = &HEC76769A
Te0(16) = &H8FCACA45
Te0(17) = &H1F82829D
Te0(18) = &H89C9C940
Te0(19) = &HFA7D7D87
Te0(20) = &HEFFAFA15
Te0(21) = &HB25959EB
Te0(22) = &H8E4747C9
Te0(23) = &HFBF0F00B
Te0(24) = &H41ADADEC
Te0(25) = &HB3D4D467
Te0(26) = &H5FA2A2FD
Te0(27) = &H45AFAFEA
Te0(28) = &H239C9CBF
Te0(29) = &H53A4A4F7
Te0(30) = &HE4727296
Te0(31) = &H9BC0C05B
Te0(32) = &H75B7B7C2
Te0(33) = &HE1FDFD1C
Te0(34) = &H3D9393AE
Te0(35) = &H4C26266A
Te0(36) = &H6C36365A
Te0(37) = &H7E3F3F41
Te0(38) = &HF5F7F702
Te0(39) = &H83CCCC4F
Te0(40) = &H6834345C
Te0(41) = &H51A5A5F4
Te0(42) = &HD1E5E534
Te0(43) = &HF9F1F108
Te0(44) = &HE2717193
Te0(45) = &HABD8D873
Te0(46) = &H62313153
Te0(47) = &H2A15153F
Te0(48) = &H804040C
Te0(49) = &H95C7C752
Te0(50) = &H46232365
Te0(51) = &H9DC3C35E
Te0(52) = &H30181828
Te0(53) = &H379696A1
Te0(54) = &HA05050F
Te0(55) = &H2F9A9AB5
Te0(56) = &HE070709
Te0(57) = &H24121236
Te0(58) = &H1B80809B
Te0(59) = &HDFE2E23D
Te0(60) = &HCDEBEB26
Te0(61) = &H4E272769
Te0(62) = &H7FB2B2CD
Te0(63) = &HEA75759F
Te0(64) = &H1209091B
Te0(65) = &H1D83839E
Te0(66) = &H582C2C74
Te0(67) = &H341A1A2E
Te0(68) = &H361B1B2D
Te0(69) = &HDC6E6EB2
Te0(70) = &HB45A5AEE
Te0(71) = &H5BA0A0FB
Te0(72) = &HA45252F6
Te0(73) = &H763B3B4D
Te0(74) = &HB7D6D661
Te0(75) = &H7DB3B3CE
Te0(76) = &H5229297B
Te0(77) = &HDDE3E33E
Te0(78) = &H5E2F2F71
Te0(79) = &H13848497
Te0(80) = &HA65353F5
Te0(81) = &HB9D1D168
Te0(82) = &H0
Te0(83) = &HC1EDED2C
Te0(84) = &H40202060
Te0(85) = &HE3FCFC1F
Te0(86) = &H79B1B1C8
Te0(87) = &HB65B5BED
Te0(88) = &HD46A6ABE
Te0(89) = &H8DCBCB46
Te0(90) = &H67BEBED9
Te0(91) = &H7239394B
Te0(92) = &H944A4ADE
Te0(93) = &H984C4CD4
Te0(94) = &HB05858E8
Te0(95) = &H85CFCF4A
Te0(96) = &HBBD0D06B
Te0(97) = &HC5EFEF2A
Te0(98) = &H4FAAAAE5
Te0(99) = &HEDFBFB16
Te0(100) = &H864343C5
Te0(101) = &H9A4D4DD7
Te0(102) = &H66333355
Te0(103) = &H11858594
Te0(104) = &H8A4545CF
Te0(105) = &HE9F9F910
Te0(106) = &H4020206
Te0(107) = &HFE7F7F81
Te0(108) = &HA05050F0
Te0(109) = &H783C3C44
Te0(110) = &H259F9FBA
Te0(111) = &H4BA8A8E3
Te0(112) = &HA25151F3
Te0(113) = &H5DA3A3FE
Te0(114) = &H804040C0
Te0(115) = &H58F8F8A
Te0(116) = &H3F9292AD
Te0(117) = &H219D9DBC
Te0(118) = &H70383848
Te0(119) = &HF1F5F504
Te0(120) = &H63BCBCDF
Te0(121) = &H77B6B6C1
Te0(122) = &HAFDADA75
Te0(123) = &H42212163
Te0(124) = &H20101030
Te0(125) = &HE5FFFF1A
Te0(126) = &HFDF3F30E
Te0(127) = &HBFD2D26D
Te0(128) = &H81CDCD4C
Te0(129) = &H180C0C14
Te0(130) = &H26131335
Te0(131) = &HC3ECEC2F
Te0(132) = &HBE5F5FE1
Te0(133) = &H359797A2
Te0(134) = &H884444CC
Te0(135) = &H2E171739
Te0(136) = &H93C4C457
Te0(137) = &H55A7A7F2
Te0(138) = &HFC7E7E82
Te0(139) = &H7A3D3D47
Te0(140) = &HC86464AC
Te0(141) = &HBA5D5DE7
Te0(142) = &H3219192B
Te0(143) = &HE6737395
Te0(144) = &HC06060A0
Te0(145) = &H19818198
Te0(146) = &H9E4F4FD1
Te0(147) = &HA3DCDC7F
Te0(148) = &H44222266
Te0(149) = &H542A2A7E
Te0(150) = &H3B9090AB
Te0(151) = &HB888883
Te0(152) = &H8C4646CA
Te0(153) = &HC7EEEE29
Te0(154) = &H6BB8B8D3
Te0(155) = &H2814143C
Te0(156) = &HA7DEDE79
Te0(157) = &HBC5E5EE2
Te0(158) = &H160B0B1D
Te0(159) = &HADDBDB76
Te0(160) = &HDBE0E03B
Te0(161) = &H64323256
Te0(162) = &H743A3A4E
Te0(163) = &H140A0A1E
Te0(164) = &H924949DB
Te0(165) = &HC06060A
Te0(166) = &H4824246C
Te0(167) = &HB85C5CE4
Te0(168) = &H9FC2C25D
Te0(169) = &HBDD3D36E
Te0(170) = &H43ACACEF
Te0(171) = &HC46262A6
Te0(172) = &H399191A8
Te0(173) = &H319595A4
Te0(174) = &HD3E4E437
Te0(175) = &HF279798B
Te0(176) = &HD5E7E732
Te0(177) = &H8BC8C843
Te0(178) = &H6E373759
Te0(179) = &HDA6D6DB7
Te0(180) = &H18D8D8C
Te0(181) = &HB1D5D564
Te0(182) = &H9C4E4ED2
Te0(183) = &H49A9A9E0
Te0(184) = &HD86C6CB4
Te0(185) = &HAC5656FA
Te0(186) = &HF3F4F407
Te0(187) = &HCFEAEA25
Te0(188) = &HCA6565AF
Te0(189) = &HF47A7A8E
Te0(190) = &H47AEAEE9
Te0(191) = &H10080818
Te0(192) = &H6FBABAD5
Te0(193) = &HF0787888
Te0(194) = &H4A25256F
Te0(195) = &H5C2E2E72
Te0(196) = &H381C1C24
Te0(197) = &H57A6A6F1
Te0(198) = &H73B4B4C7
Te0(199) = &H97C6C651
Te0(200) = &HCBE8E823
Te0(201) = &HA1DDDD7C
Te0(202) = &HE874749C
Te0(203) = &H3E1F1F21
Te0(204) = &H964B4BDD
Te0(205) = &H61BDBDDC
Te0(206) = &HD8B8B86
Te0(207) = &HF8A8A85
Te0(208) = &HE0707090
Te0(209) = &H7C3E3E42
Te0(210) = &H71B5B5C4
Te0(211) = &HCC6666AA
Te0(212) = &H904848D8
Te0(213) = &H6030305
Te0(214) = &HF7F6F601
Te0(215) = &H1C0E0E12
Te0(216) = &HC26161A3
Te0(217) = &H6A35355F
Te0(218) = &HAE5757F9
Te0(219) = &H69B9B9D0
Te0(220) = &H17868691
Te0(221) = &H99C1C158
Te0(222) = &H3A1D1D27
Te0(223) = &H279E9EB9
Te0(224) = &HD9E1E138
Te0(225) = &HEBF8F813
Te0(226) = &H2B9898B3
Te0(227) = &H22111133
Te0(228) = &HD26969BB
Te0(229) = &HA9D9D970
Te0(230) = &H78E8E89
Te0(231) = &H339494A7
Te0(232) = &H2D9B9BB6
Te0(233) = &H3C1E1E22
Te0(234) = &H15878792
Te0(235) = &HC9E9E920
Te0(236) = &H87CECE49
Te0(237) = &HAA5555FF
Te0(238) = &H50282878
Te0(239) = &HA5DFDF7A
Te0(240) = &H38C8C8F
Te0(241) = &H59A1A1F8
Te0(242) = &H9898980
Te0(243) = &H1A0D0D17
Te0(244) = &H65BFBFDA
Te0(245) = &HD7E6E631
Te0(246) = &H844242C6
Te0(247) = &HD06868B8
Te0(248) = &H824141C3
Te0(249) = &H299999B0
Te0(250) = &H5A2D2D77
Te0(251) = &H1E0F0F11
Te0(252) = &H7BB0B0CB
Te0(253) = &HA85454FC
Te0(254) = &H6DBBBBD6
Te0(255) = &H2C16163A
Te1(0) = &HA5C66363
Te1(1) = &H84F87C7C
Te1(2) = &H99EE7777
Te1(3) = &H8DF67B7B
Te1(4) = &HDFFF2F2
Te1(5) = &HBDD66B6B
Te1(6) = &HB1DE6F6F
Te1(7) = &H5491C5C5
Te1(8) = &H50603030
Te1(9) = &H3020101
Te1(10) = &HA9CE6767
Te1(11) = &H7D562B2B
Te1(12) = &H19E7FEFE
Te1(13) = &H62B5D7D7
Te1(14) = &HE64DABAB
Te1(15) = &H9AEC7676
Te1(16) = &H458FCACA
Te1(17) = &H9D1F8282
Te1(18) = &H4089C9C9
Te1(19) = &H87FA7D7D
Te1(20) = &H15EFFAFA
Te1(21) = &HEBB25959
Te1(22) = &HC98E4747
Te1(23) = &HBFBF0F0
Te1(24) = &HEC41ADAD
Te1(25) = &H67B3D4D4
Te1(26) = &HFD5FA2A2
Te1(27) = &HEA45AFAF
Te1(28) = &HBF239C9C
Te1(29) = &HF753A4A4
Te1(30) = &H96E47272
Te1(31) = &H5B9BC0C0
Te1(32) = &HC275B7B7
Te1(33) = &H1CE1FDFD
Te1(34) = &HAE3D9393
Te1(35) = &H6A4C2626
Te1(36) = &H5A6C3636
Te1(37) = &H417E3F3F
Te1(38) = &H2F5F7F7
Te1(39) = &H4F83CCCC
Te1(40) = &H5C683434
Te1(41) = &HF451A5A5
Te1(42) = &H34D1E5E5
Te1(43) = &H8F9F1F1
Te1(44) = &H93E27171
Te1(45) = &H73ABD8D8
Te1(46) = &H53623131
Te1(47) = &H3F2A1515
Te1(48) = &HC080404
Te1(49) = &H5295C7C7
Te1(50) = &H65462323
Te1(51) = &H5E9DC3C3
Te1(52) = &H28301818
Te1(53) = &HA1379696
Te1(54) = &HF0A0505
Te1(55) = &HB52F9A9A
Te1(56) = &H90E0707
Te1(57) = &H36241212
Te1(58) = &H9B1B8080
Te1(59) = &H3DDFE2E2
Te1(60) = &H26CDEBEB
Te1(61) = &H694E2727
Te1(62) = &HCD7FB2B2
Te1(63) = &H9FEA7575
Te1(64) = &H1B120909
Te1(65) = &H9E1D8383
Te1(66) = &H74582C2C
Te1(67) = &H2E341A1A
Te1(68) = &H2D361B1B
Te1(69) = &HB2DC6E6E
Te1(70) = &HEEB45A5A
Te1(71) = &HFB5BA0A0
Te1(72) = &HF6A45252
Te1(73) = &H4D763B3B
Te1(74) = &H61B7D6D6
Te1(75) = &HCE7DB3B3
Te1(76) = &H7B522929
Te1(77) = &H3EDDE3E3
Te1(78) = &H715E2F2F
Te1(79) = &H97138484
Te1(80) = &HF5A65353
Te1(81) = &H68B9D1D1
Te1(82) = &H0
Te1(83) = &H2CC1EDED
Te1(84) = &H60402020
Te1(85) = &H1FE3FCFC
Te1(86) = &HC879B1B1
Te1(87) = &HEDB65B5B
Te1(88) = &HBED46A6A
Te1(89) = &H468DCBCB
Te1(90) = &HD967BEBE
Te1(91) = &H4B723939
Te1(92) = &HDE944A4A
Te1(93) = &HD4984C4C
Te1(94) = &HE8B05858
Te1(95) = &H4A85CFCF
Te1(96) = &H6BBBD0D0
Te1(97) = &H2AC5EFEF
Te1(98) = &HE54FAAAA
Te1(99) = &H16EDFBFB
Te1(100) = &HC5864343
Te1(101) = &HD79A4D4D
Te1(102) = &H55663333
Te1(103) = &H94118585
Te1(104) = &HCF8A4545
Te1(105) = &H10E9F9F9
Te1(106) = &H6040202
Te1(107) = &H81FE7F7F
Te1(108) = &HF0A05050
Te1(109) = &H44783C3C
Te1(110) = &HBA259F9F
Te1(111) = &HE34BA8A8
Te1(112) = &HF3A25151
Te1(113) = &HFE5DA3A3
Te1(114) = &HC0804040
Te1(115) = &H8A058F8F
Te1(116) = &HAD3F9292
Te1(117) = &HBC219D9D
Te1(118) = &H48703838
Te1(119) = &H4F1F5F5
Te1(120) = &HDF63BCBC
Te1(121) = &HC177B6B6
Te1(122) = &H75AFDADA
Te1(123) = &H63422121
Te1(124) = &H30201010
Te1(125) = &H1AE5FFFF
Te1(126) = &HEFDF3F3
Te1(127) = &H6DBFD2D2
Te1(128) = &H4C81CDCD
Te1(129) = &H14180C0C
Te1(130) = &H35261313
Te1(131) = &H2FC3ECEC
Te1(132) = &HE1BE5F5F
Te1(133) = &HA2359797
Te1(134) = &HCC884444
Te1(135) = &H392E1717
Te1(136) = &H5793C4C4
Te1(137) = &HF255A7A7
Te1(138) = &H82FC7E7E
Te1(139) = &H477A3D3D
Te1(140) = &HACC86464
Te1(141) = &HE7BA5D5D
Te1(142) = &H2B321919
Te1(143) = &H95E67373
Te1(144) = &HA0C06060
Te1(145) = &H98198181
Te1(146) = &HD19E4F4F
Te1(147) = &H7FA3DCDC
Te1(148) = &H66442222
Te1(149) = &H7E542A2A
Te1(150) = &HAB3B9090
Te1(151) = &H830B8888
Te1(152) = &HCA8C4646
Te1(153) = &H29C7EEEE
Te1(154) = &HD36BB8B8
Te1(155) = &H3C281414
Te1(156) = &H79A7DEDE
Te1(157) = &HE2BC5E5E
Te1(158) = &H1D160B0B
Te1(159) = &H76ADDBDB
Te1(160) = &H3BDBE0E0
Te1(161) = &H56643232
Te1(162) = &H4E743A3A
Te1(163) = &H1E140A0A
Te1(164) = &HDB924949
Te1(165) = &HA0C0606
Te1(166) = &H6C482424
Te1(167) = &HE4B85C5C
Te1(168) = &H5D9FC2C2
Te1(169) = &H6EBDD3D3
Te1(170) = &HEF43ACAC
Te1(171) = &HA6C46262
Te1(172) = &HA8399191
Te1(173) = &HA4319595
Te1(174) = &H37D3E4E4
Te1(175) = &H8BF27979
Te1(176) = &H32D5E7E7
Te1(177) = &H438BC8C8
Te1(178) = &H596E3737
Te1(179) = &HB7DA6D6D
Te1(180) = &H8C018D8D
Te1(181) = &H64B1D5D5
Te1(182) = &HD29C4E4E
Te1(183) = &HE049A9A9
Te1(184) = &HB4D86C6C
Te1(185) = &HFAAC5656
Te1(186) = &H7F3F4F4
Te1(187) = &H25CFEAEA
Te1(188) = &HAFCA6565
Te1(189) = &H8EF47A7A
Te1(190) = &HE947AEAE
Te1(191) = &H18100808
Te1(192) = &HD56FBABA
Te1(193) = &H88F07878
Te1(194) = &H6F4A2525
Te1(195) = &H725C2E2E
Te1(196) = &H24381C1C
Te1(197) = &HF157A6A6
Te1(198) = &HC773B4B4
Te1(199) = &H5197C6C6
Te1(200) = &H23CBE8E8
Te1(201) = &H7CA1DDDD
Te1(202) = &H9CE87474
Te1(203) = &H213E1F1F
Te1(204) = &HDD964B4B
Te1(205) = &HDC61BDBD
Te1(206) = &H860D8B8B
Te1(207) = &H850F8A8A
Te1(208) = &H90E07070
Te1(209) = &H427C3E3E
Te1(210) = &HC471B5B5
Te1(211) = &HAACC6666
Te1(212) = &HD8904848
Te1(213) = &H5060303
Te1(214) = &H1F7F6F6
Te1(215) = &H121C0E0E
Te1(216) = &HA3C26161
Te1(217) = &H5F6A3535
Te1(218) = &HF9AE5757
Te1(219) = &HD069B9B9
Te1(220) = &H91178686
Te1(221) = &H5899C1C1
Te1(222) = &H273A1D1D
Te1(223) = &HB9279E9E
Te1(224) = &H38D9E1E1
Te1(225) = &H13EBF8F8
Te1(226) = &HB32B9898
Te1(227) = &H33221111
Te1(228) = &HBBD26969
Te1(229) = &H70A9D9D9
Te1(230) = &H89078E8E
Te1(231) = &HA7339494
Te1(232) = &HB62D9B9B
Te1(233) = &H223C1E1E
Te1(234) = &H92158787
Te1(235) = &H20C9E9E9
Te1(236) = &H4987CECE
Te1(237) = &HFFAA5555
Te1(238) = &H78502828
Te1(239) = &H7AA5DFDF
Te1(240) = &H8F038C8C
Te1(241) = &HF859A1A1
Te1(242) = &H80098989
Te1(243) = &H171A0D0D
Te1(244) = &HDA65BFBF
Te1(245) = &H31D7E6E6
Te1(246) = &HC6844242
Te1(247) = &HB8D06868
Te1(248) = &HC3824141
Te1(249) = &HB0299999
Te1(250) = &H775A2D2D
Te1(251) = &H111E0F0F
Te1(252) = &HCB7BB0B0
Te1(253) = &HFCA85454
Te1(254) = &HD66DBBBB
Te1(255) = &H3A2C1616
Te2(0) = &H63A5C663
Te2(1) = &H7C84F87C
Te2(2) = &H7799EE77
Te2(3) = &H7B8DF67B
Te2(4) = &HF20DFFF2
Te2(5) = &H6BBDD66B
Te2(6) = &H6FB1DE6F
Te2(7) = &HC55491C5
Te2(8) = &H30506030
Te2(9) = &H1030201
Te2(10) = &H67A9CE67
Te2(11) = &H2B7D562B
Te2(12) = &HFE19E7FE
Te2(13) = &HD762B5D7
Te2(14) = &HABE64DAB
Te2(15) = &H769AEC76
Te2(16) = &HCA458FCA
Te2(17) = &H829D1F82
Te2(18) = &HC94089C9
Te2(19) = &H7D87FA7D
Te2(20) = &HFA15EFFA
Te2(21) = &H59EBB259
Te2(22) = &H47C98E47
Te2(23) = &HF00BFBF0
Te2(24) = &HADEC41AD
Te2(25) = &HD467B3D4
Te2(26) = &HA2FD5FA2
Te2(27) = &HAFEA45AF
Te2(28) = &H9CBF239C
Te2(29) = &HA4F753A4
Te2(30) = &H7296E472
Te2(31) = &HC05B9BC0
Te2(32) = &HB7C275B7
Te2(33) = &HFD1CE1FD
Te2(34) = &H93AE3D93
Te2(35) = &H266A4C26
Te2(36) = &H365A6C36
Te2(37) = &H3F417E3F
Te2(38) = &HF702F5F7
Te2(39) = &HCC4F83CC
Te2(40) = &H345C6834
Te2(41) = &HA5F451A5
Te2(42) = &HE534D1E5
Te2(43) = &HF108F9F1
Te2(44) = &H7193E271
Te2(45) = &HD873ABD8
Te2(46) = &H31536231
Te2(47) = &H153F2A15
Te2(48) = &H40C0804
Te2(49) = &HC75295C7
Te2(50) = &H23654623
Te2(51) = &HC35E9DC3
Te2(52) = &H18283018
Te2(53) = &H96A13796
Te2(54) = &H50F0A05
Te2(55) = &H9AB52F9A
Te2(56) = &H7090E07
Te2(57) = &H12362412
Te2(58) = &H809B1B80
Te2(59) = &HE23DDFE2
Te2(60) = &HEB26CDEB
Te2(61) = &H27694E27
Te2(62) = &HB2CD7FB2
Te2(63) = &H759FEA75
Te2(64) = &H91B1209
Te2(65) = &H839E1D83
Te2(66) = &H2C74582C
Te2(67) = &H1A2E341A
Te2(68) = &H1B2D361B
Te2(69) = &H6EB2DC6E
Te2(70) = &H5AEEB45A
Te2(71) = &HA0FB5BA0
Te2(72) = &H52F6A452
Te2(73) = &H3B4D763B
Te2(74) = &HD661B7D6
Te2(75) = &HB3CE7DB3
Te2(76) = &H297B5229
Te2(77) = &HE33EDDE3
Te2(78) = &H2F715E2F
Te2(79) = &H84971384
Te2(80) = &H53F5A653
Te2(81) = &HD168B9D1
Te2(82) = &H0
Te2(83) = &HED2CC1ED
Te2(84) = &H20604020
Te2(85) = &HFC1FE3FC
Te2(86) = &HB1C879B1
Te2(87) = &H5BEDB65B
Te2(88) = &H6ABED46A
Te2(89) = &HCB468DCB
Te2(90) = &HBED967BE
Te2(91) = &H394B7239
Te2(92) = &H4ADE944A
Te2(93) = &H4CD4984C
Te2(94) = &H58E8B058
Te2(95) = &HCF4A85CF
Te2(96) = &HD06BBBD0
Te2(97) = &HEF2AC5EF
Te2(98) = &HAAE54FAA
Te2(99) = &HFB16EDFB
Te2(100) = &H43C58643
Te2(101) = &H4DD79A4D
Te2(102) = &H33556633
Te2(103) = &H85941185
Te2(104) = &H45CF8A45
Te2(105) = &HF910E9F9
Te2(106) = &H2060402
Te2(107) = &H7F81FE7F
Te2(108) = &H50F0A050
Te2(109) = &H3C44783C
Te2(110) = &H9FBA259F
Te2(111) = &HA8E34BA8
Te2(112) = &H51F3A251
Te2(113) = &HA3FE5DA3
Te2(114) = &H40C08040
Te2(115) = &H8F8A058F
Te2(116) = &H92AD3F92
Te2(117) = &H9DBC219D
Te2(118) = &H38487038
Te2(119) = &HF504F1F5
Te2(120) = &HBCDF63BC
Te2(121) = &HB6C177B6
Te2(122) = &HDA75AFDA
Te2(123) = &H21634221
Te2(124) = &H10302010
Te2(125) = &HFF1AE5FF
Te2(126) = &HF30EFDF3
Te2(127) = &HD26DBFD2
Te2(128) = &HCD4C81CD
Te2(129) = &HC14180C
Te2(130) = &H13352613
Te2(131) = &HEC2FC3EC
Te2(132) = &H5FE1BE5F
Te2(133) = &H97A23597
Te2(134) = &H44CC8844
Te2(135) = &H17392E17
Te2(136) = &HC45793C4
Te2(137) = &HA7F255A7
Te2(138) = &H7E82FC7E
Te2(139) = &H3D477A3D
Te2(140) = &H64ACC864
Te2(141) = &H5DE7BA5D
Te2(142) = &H192B3219
Te2(143) = &H7395E673
Te2(144) = &H60A0C060
Te2(145) = &H81981981
Te2(146) = &H4FD19E4F
Te2(147) = &HDC7FA3DC
Te2(148) = &H22664422
Te2(149) = &H2A7E542A
Te2(150) = &H90AB3B90
Te2(151) = &H88830B88
Te2(152) = &H46CA8C46
Te2(153) = &HEE29C7EE
Te2(154) = &HB8D36BB8
Te2(155) = &H143C2814
Te2(156) = &HDE79A7DE
Te2(157) = &H5EE2BC5E
Te2(158) = &HB1D160B
Te2(159) = &HDB76ADDB
Te2(160) = &HE03BDBE0
Te2(161) = &H32566432
Te2(162) = &H3A4E743A
Te2(163) = &HA1E140A
Te2(164) = &H49DB9249
Te2(165) = &H60A0C06
Te2(166) = &H246C4824
Te2(167) = &H5CE4B85C
Te2(168) = &HC25D9FC2
Te2(169) = &HD36EBDD3
Te2(170) = &HACEF43AC
Te2(171) = &H62A6C462
Te2(172) = &H91A83991
Te2(173) = &H95A43195
Te2(174) = &HE437D3E4
Te2(175) = &H798BF279
Te2(176) = &HE732D5E7
Te2(177) = &HC8438BC8
Te2(178) = &H37596E37
Te2(179) = &H6DB7DA6D
Te2(180) = &H8D8C018D
Te2(181) = &HD564B1D5
Te2(182) = &H4ED29C4E
Te2(183) = &HA9E049A9
Te2(184) = &H6CB4D86C
Te2(185) = &H56FAAC56
Te2(186) = &HF407F3F4
Te2(187) = &HEA25CFEA
Te2(188) = &H65AFCA65
Te2(189) = &H7A8EF47A
Te2(190) = &HAEE947AE
Te2(191) = &H8181008
Te2(192) = &HBAD56FBA
Te2(193) = &H7888F078
Te2(194) = &H256F4A25
Te2(195) = &H2E725C2E
Te2(196) = &H1C24381C
Te2(197) = &HA6F157A6
Te2(198) = &HB4C773B4
Te2(199) = &HC65197C6
Te2(200) = &HE823CBE8
Te2(201) = &HDD7CA1DD
Te2(202) = &H749CE874
Te2(203) = &H1F213E1F
Te2(204) = &H4BDD964B
Te2(205) = &HBDDC61BD
Te2(206) = &H8B860D8B
Te2(207) = &H8A850F8A
Te2(208) = &H7090E070
Te2(209) = &H3E427C3E
Te2(210) = &HB5C471B5
Te2(211) = &H66AACC66
Te2(212) = &H48D89048
Te2(213) = &H3050603
Te2(214) = &HF601F7F6
Te2(215) = &HE121C0E
Te2(216) = &H61A3C261
Te2(217) = &H355F6A35
Te2(218) = &H57F9AE57
Te2(219) = &HB9D069B9
Te2(220) = &H86911786
Te2(221) = &HC15899C1
Te2(222) = &H1D273A1D
Te2(223) = &H9EB9279E
Te2(224) = &HE138D9E1
Te2(225) = &HF813EBF8
Te2(226) = &H98B32B98
Te2(227) = &H11332211
Te2(228) = &H69BBD269
Te2(229) = &HD970A9D9
Te2(230) = &H8E89078E
Te2(231) = &H94A73394
Te2(232) = &H9BB62D9B
Te2(233) = &H1E223C1E
Te2(234) = &H87921587
Te2(235) = &HE920C9E9
Te2(236) = &HCE4987CE
Te2(237) = &H55FFAA55
Te2(238) = &H28785028
Te2(239) = &HDF7AA5DF
Te2(240) = &H8C8F038C
Te2(241) = &HA1F859A1
Te2(242) = &H89800989
Te2(243) = &HD171A0D
Te2(244) = &HBFDA65BF
Te2(245) = &HE631D7E6
Te2(246) = &H42C68442
Te2(247) = &H68B8D068
Te2(248) = &H41C38241
Te2(249) = &H99B02999
Te2(250) = &H2D775A2D
Te2(251) = &HF111E0F
Te2(252) = &HB0CB7BB0
Te2(253) = &H54FCA854
Te2(254) = &HBBD66DBB
Te2(255) = &H163A2C16
Te3(0) = &H6363A5C6
Te3(1) = &H7C7C84F8
Te3(2) = &H777799EE
Te3(3) = &H7B7B8DF6
Te3(4) = &HF2F20DFF
Te3(5) = &H6B6BBDD6
Te3(6) = &H6F6FB1DE
Te3(7) = &HC5C55491
Te3(8) = &H30305060
Te3(9) = &H1010302
Te3(10) = &H6767A9CE
Te3(11) = &H2B2B7D56
Te3(12) = &HFEFE19E7
Te3(13) = &HD7D762B5
Te3(14) = &HABABE64D
Te3(15) = &H76769AEC
Te3(16) = &HCACA458F
Te3(17) = &H82829D1F
Te3(18) = &HC9C94089
Te3(19) = &H7D7D87FA
Te3(20) = &HFAFA15EF
Te3(21) = &H5959EBB2
Te3(22) = &H4747C98E
Te3(23) = &HF0F00BFB
Te3(24) = &HADADEC41
Te3(25) = &HD4D467B3
Te3(26) = &HA2A2FD5F
Te3(27) = &HAFAFEA45
Te3(28) = &H9C9CBF23
Te3(29) = &HA4A4F753
Te3(30) = &H727296E4
Te3(31) = &HC0C05B9B
Te3(32) = &HB7B7C275
Te3(33) = &HFDFD1CE1
Te3(34) = &H9393AE3D
Te3(35) = &H26266A4C
Te3(36) = &H36365A6C
Te3(37) = &H3F3F417E
Te3(38) = &HF7F702F5
Te3(39) = &HCCCC4F83
Te3(40) = &H34345C68
Te3(41) = &HA5A5F451
Te3(42) = &HE5E534D1
Te3(43) = &HF1F108F9
Te3(44) = &H717193E2
Te3(45) = &HD8D873AB
Te3(46) = &H31315362
Te3(47) = &H15153F2A
Te3(48) = &H4040C08
Te3(49) = &HC7C75295
Te3(50) = &H23236546
Te3(51) = &HC3C35E9D
Te3(52) = &H18182830
Te3(53) = &H9696A137
Te3(54) = &H5050F0A
Te3(55) = &H9A9AB52F
Te3(56) = &H707090E
Te3(57) = &H12123624
Te3(58) = &H80809B1B
Te3(59) = &HE2E23DDF
Te3(60) = &HEBEB26CD
Te3(61) = &H2727694E
Te3(62) = &HB2B2CD7F
Te3(63) = &H75759FEA
Te3(64) = &H9091B12
Te3(65) = &H83839E1D
Te3(66) = &H2C2C7458
Te3(67) = &H1A1A2E34
Te3(68) = &H1B1B2D36
Te3(69) = &H6E6EB2DC
Te3(70) = &H5A5AEEB4
Te3(71) = &HA0A0FB5B
Te3(72) = &H5252F6A4
Te3(73) = &H3B3B4D76
Te3(74) = &HD6D661B7
Te3(75) = &HB3B3CE7D
Te3(76) = &H29297B52
Te3(77) = &HE3E33EDD
Te3(78) = &H2F2F715E
Te3(79) = &H84849713
Te3(80) = &H5353F5A6
Te3(81) = &HD1D168B9
Te3(82) = &H0
Te3(83) = &HEDED2CC1
Te3(84) = &H20206040
Te3(85) = &HFCFC1FE3
Te3(86) = &HB1B1C879
Te3(87) = &H5B5BEDB6
Te3(88) = &H6A6ABED4
Te3(89) = &HCBCB468D
Te3(90) = &HBEBED967
Te3(91) = &H39394B72
Te3(92) = &H4A4ADE94
Te3(93) = &H4C4CD498
Te3(94) = &H5858E8B0
Te3(95) = &HCFCF4A85
Te3(96) = &HD0D06BBB
Te3(97) = &HEFEF2AC5
Te3(98) = &HAAAAE54F
Te3(99) = &HFBFB16ED
Te3(100) = &H4343C586
Te3(101) = &H4D4DD79A
Te3(102) = &H33335566
Te3(103) = &H85859411
Te3(104) = &H4545CF8A
Te3(105) = &HF9F910E9
Te3(106) = &H2020604
Te3(107) = &H7F7F81FE
Te3(108) = &H5050F0A0
Te3(109) = &H3C3C4478
Te3(110) = &H9F9FBA25
Te3(111) = &HA8A8E34B
Te3(112) = &H5151F3A2
Te3(113) = &HA3A3FE5D
Te3(114) = &H4040C080
Te3(115) = &H8F8F8A05
Te3(116) = &H9292AD3F
Te3(117) = &H9D9DBC21
Te3(118) = &H38384870
Te3(119) = &HF5F504F1
Te3(120) = &HBCBCDF63
Te3(121) = &HB6B6C177
Te3(122) = &HDADA75AF
Te3(123) = &H21216342
Te3(124) = &H10103020
Te3(125) = &HFFFF1AE5
Te3(126) = &HF3F30EFD
Te3(127) = &HD2D26DBF
Te3(128) = &HCDCD4C81
Te3(129) = &HC0C1418
Te3(130) = &H13133526
Te3(131) = &HECEC2FC3
Te3(132) = &H5F5FE1BE
Te3(133) = &H9797A235
Te3(134) = &H4444CC88
Te3(135) = &H1717392E
Te3(136) = &HC4C45793
Te3(137) = &HA7A7F255
Te3(138) = &H7E7E82FC
Te3(139) = &H3D3D477A
Te3(140) = &H6464ACC8
Te3(141) = &H5D5DE7BA
Te3(142) = &H19192B32
Te3(143) = &H737395E6
Te3(144) = &H6060A0C0
Te3(145) = &H81819819
Te3(146) = &H4F4FD19E
Te3(147) = &HDCDC7FA3
Te3(148) = &H22226644
Te3(149) = &H2A2A7E54
Te3(150) = &H9090AB3B
Te3(151) = &H8888830B
Te3(152) = &H4646CA8C
Te3(153) = &HEEEE29C7
Te3(154) = &HB8B8D36B
Te3(155) = &H14143C28
Te3(156) = &HDEDE79A7
Te3(157) = &H5E5EE2BC
Te3(158) = &HB0B1D16
Te3(159) = &HDBDB76AD
Te3(160) = &HE0E03BDB
Te3(161) = &H32325664
Te3(162) = &H3A3A4E74
Te3(163) = &HA0A1E14
Te3(164) = &H4949DB92
Te3(165) = &H6060A0C
Te3(166) = &H24246C48
Te3(167) = &H5C5CE4B8
Te3(168) = &HC2C25D9F
Te3(169) = &HD3D36EBD
Te3(170) = &HACACEF43
Te3(171) = &H6262A6C4
Te3(172) = &H9191A839
Te3(173) = &H9595A431
Te3(174) = &HE4E437D3
Te3(175) = &H79798BF2
Te3(176) = &HE7E732D5
Te3(177) = &HC8C8438B
Te3(178) = &H3737596E
Te3(179) = &H6D6DB7DA
Te3(180) = &H8D8D8C01
Te3(181) = &HD5D564B1
Te3(182) = &H4E4ED29C
Te3(183) = &HA9A9E049
Te3(184) = &H6C6CB4D8
Te3(185) = &H5656FAAC
Te3(186) = &HF4F407F3
Te3(187) = &HEAEA25CF
Te3(188) = &H6565AFCA
Te3(189) = &H7A7A8EF4
Te3(190) = &HAEAEE947
Te3(191) = &H8081810
Te3(192) = &HBABAD56F
Te3(193) = &H787888F0
Te3(194) = &H25256F4A
Te3(195) = &H2E2E725C
Te3(196) = &H1C1C2438
Te3(197) = &HA6A6F157
Te3(198) = &HB4B4C773
Te3(199) = &HC6C65197
Te3(200) = &HE8E823CB
Te3(201) = &HDDDD7CA1
Te3(202) = &H74749CE8
Te3(203) = &H1F1F213E
Te3(204) = &H4B4BDD96
Te3(205) = &HBDBDDC61
Te3(206) = &H8B8B860D
Te3(207) = &H8A8A850F
Te3(208) = &H707090E0
Te3(209) = &H3E3E427C
Te3(210) = &HB5B5C471
Te3(211) = &H6666AACC
Te3(212) = &H4848D890
Te3(213) = &H3030506
Te3(214) = &HF6F601F7
Te3(215) = &HE0E121C
Te3(216) = &H6161A3C2
Te3(217) = &H35355F6A
Te3(218) = &H5757F9AE
Te3(219) = &HB9B9D069
Te3(220) = &H86869117
Te3(221) = &HC1C15899
Te3(222) = &H1D1D273A
Te3(223) = &H9E9EB927
Te3(224) = &HE1E138D9
Te3(225) = &HF8F813EB
Te3(226) = &H9898B32B
Te3(227) = &H11113322
Te3(228) = &H6969BBD2
Te3(229) = &HD9D970A9
Te3(230) = &H8E8E8907
Te3(231) = &H9494A733
Te3(232) = &H9B9BB62D
Te3(233) = &H1E1E223C
Te3(234) = &H87879215
Te3(235) = &HE9E920C9
Te3(236) = &HCECE4987
Te3(237) = &H5555FFAA
Te3(238) = &H28287850
Te3(239) = &HDFDF7AA5
Te3(240) = &H8C8C8F03
Te3(241) = &HA1A1F859
Te3(242) = &H89898009
Te3(243) = &HD0D171A
Te3(244) = &HBFBFDA65
Te3(245) = &HE6E631D7
Te3(246) = &H4242C684
Te3(247) = &H6868B8D0
Te3(248) = &H4141C382
Te3(249) = &H9999B029
Te3(250) = &H2D2D775A
Te3(251) = &HF0F111E
Te3(252) = &HB0B0CB7B
Te3(253) = &H5454FCA8
Te3(254) = &HBBBBD66D
Te3(255) = &H16163A2C
Te4(0) = &H63636363
Te4(1) = &H7C7C7C7C
Te4(2) = &H77777777
Te4(3) = &H7B7B7B7B
Te4(4) = &HF2F2F2F2
Te4(5) = &H6B6B6B6B
Te4(6) = &H6F6F6F6F
Te4(7) = &HC5C5C5C5
Te4(8) = &H30303030
Te4(9) = &H1010101
Te4(10) = &H67676767
Te4(11) = &H2B2B2B2B
Te4(12) = &HFEFEFEFE
Te4(13) = &HD7D7D7D7
Te4(14) = &HABABABAB
Te4(15) = &H76767676
Te4(16) = &HCACACACA
Te4(17) = &H82828282
Te4(18) = &HC9C9C9C9
Te4(19) = &H7D7D7D7D
Te4(20) = &HFAFAFAFA
Te4(21) = &H59595959
Te4(22) = &H47474747
Te4(23) = &HF0F0F0F0
Te4(24) = &HADADADAD
Te4(25) = &HD4D4D4D4
Te4(26) = &HA2A2A2A2
Te4(27) = &HAFAFAFAF
Te4(28) = &H9C9C9C9C
Te4(29) = &HA4A4A4A4
Te4(30) = &H72727272
Te4(31) = &HC0C0C0C0
Te4(32) = &HB7B7B7B7
Te4(33) = &HFDFDFDFD
Te4(34) = &H93939393
Te4(35) = &H26262626
Te4(36) = &H36363636
Te4(37) = &H3F3F3F3F
Te4(38) = &HF7F7F7F7
Te4(39) = &HCCCCCCCC
Te4(40) = &H34343434
Te4(41) = &HA5A5A5A5
Te4(42) = &HE5E5E5E5
Te4(43) = &HF1F1F1F1
Te4(44) = &H71717171
Te4(45) = &HD8D8D8D8
Te4(46) = &H31313131
Te4(47) = &H15151515
Te4(48) = &H4040404
Te4(49) = &HC7C7C7C7
Te4(50) = &H23232323
Te4(51) = &HC3C3C3C3
Te4(52) = &H18181818
Te4(53) = &H96969696
Te4(54) = &H5050505
Te4(55) = &H9A9A9A9A
Te4(56) = &H7070707
Te4(57) = &H12121212
Te4(58) = &H80808080
Te4(59) = &HE2E2E2E2
Te4(60) = &HEBEBEBEB
Te4(61) = &H27272727
Te4(62) = &HB2B2B2B2
Te4(63) = &H75757575
Te4(64) = &H9090909
Te4(65) = &H83838383
Te4(66) = &H2C2C2C2C
Te4(67) = &H1A1A1A1A
Te4(68) = &H1B1B1B1B
Te4(69) = &H6E6E6E6E
Te4(70) = &H5A5A5A5A
Te4(71) = &HA0A0A0A0
Te4(72) = &H52525252
Te4(73) = &H3B3B3B3B
Te4(74) = &HD6D6D6D6
Te4(75) = &HB3B3B3B3
Te4(76) = &H29292929
Te4(77) = &HE3E3E3E3
Te4(78) = &H2F2F2F2F
Te4(79) = &H84848484
Te4(80) = &H53535353
Te4(81) = &HD1D1D1D1
Te4(82) = &H0
Te4(83) = &HEDEDEDED
Te4(84) = &H20202020
Te4(85) = &HFCFCFCFC
Te4(86) = &HB1B1B1B1
Te4(87) = &H5B5B5B5B
Te4(88) = &H6A6A6A6A
Te4(89) = &HCBCBCBCB
Te4(90) = &HBEBEBEBE
Te4(91) = &H39393939
Te4(92) = &H4A4A4A4A
Te4(93) = &H4C4C4C4C
Te4(94) = &H58585858
Te4(95) = &HCFCFCFCF
Te4(96) = &HD0D0D0D0
Te4(97) = &HEFEFEFEF
Te4(98) = &HAAAAAAAA
Te4(99) = &HFBFBFBFB
Te4(100) = &H43434343
Te4(101) = &H4D4D4D4D
Te4(102) = &H33333333
Te4(103) = &H85858585
Te4(104) = &H45454545
Te4(105) = &HF9F9F9F9
Te4(106) = &H2020202
Te4(107) = &H7F7F7F7F
Te4(108) = &H50505050
Te4(109) = &H3C3C3C3C
Te4(110) = &H9F9F9F9F
Te4(111) = &HA8A8A8A8
Te4(112) = &H51515151
Te4(113) = &HA3A3A3A3
Te4(114) = &H40404040
Te4(115) = &H8F8F8F8F
Te4(116) = &H92929292
Te4(117) = &H9D9D9D9D
Te4(118) = &H38383838
Te4(119) = &HF5F5F5F5
Te4(120) = &HBCBCBCBC
Te4(121) = &HB6B6B6B6
Te4(122) = &HDADADADA
Te4(123) = &H21212121
Te4(124) = &H10101010
Te4(125) = &HFFFFFFFF
Te4(126) = &HF3F3F3F3
Te4(127) = &HD2D2D2D2
Te4(128) = &HCDCDCDCD
Te4(129) = &HC0C0C0C
Te4(130) = &H13131313
Te4(131) = &HECECECEC
Te4(132) = &H5F5F5F5F
Te4(133) = &H97979797
Te4(134) = &H44444444
Te4(135) = &H17171717
Te4(136) = &HC4C4C4C4
Te4(137) = &HA7A7A7A7
Te4(138) = &H7E7E7E7E
Te4(139) = &H3D3D3D3D
Te4(140) = &H64646464
Te4(141) = &H5D5D5D5D
Te4(142) = &H19191919
Te4(143) = &H73737373
Te4(144) = &H60606060
Te4(145) = &H81818181
Te4(146) = &H4F4F4F4F
Te4(147) = &HDCDCDCDC
Te4(148) = &H22222222
Te4(149) = &H2A2A2A2A
Te4(150) = &H90909090
Te4(151) = &H88888888
Te4(152) = &H46464646
Te4(153) = &HEEEEEEEE
Te4(154) = &HB8B8B8B8
Te4(155) = &H14141414
Te4(156) = &HDEDEDEDE
Te4(157) = &H5E5E5E5E
Te4(158) = &HB0B0B0B
Te4(159) = &HDBDBDBDB
Te4(160) = &HE0E0E0E0
Te4(161) = &H32323232
Te4(162) = &H3A3A3A3A
Te4(163) = &HA0A0A0A
Te4(164) = &H49494949
Te4(165) = &H6060606
Te4(166) = &H24242424
Te4(167) = &H5C5C5C5C
Te4(168) = &HC2C2C2C2
Te4(169) = &HD3D3D3D3
Te4(170) = &HACACACAC
Te4(171) = &H62626262
Te4(172) = &H91919191
Te4(173) = &H95959595
Te4(174) = &HE4E4E4E4
Te4(175) = &H79797979
Te4(176) = &HE7E7E7E7
Te4(177) = &HC8C8C8C8
Te4(178) = &H37373737
Te4(179) = &H6D6D6D6D
Te4(180) = &H8D8D8D8D
Te4(181) = &HD5D5D5D5
Te4(182) = &H4E4E4E4E
Te4(183) = &HA9A9A9A9
Te4(184) = &H6C6C6C6C
Te4(185) = &H56565656
Te4(186) = &HF4F4F4F4
Te4(187) = &HEAEAEAEA
Te4(188) = &H65656565
Te4(189) = &H7A7A7A7A
Te4(190) = &HAEAEAEAE
Te4(191) = &H8080808
Te4(192) = &HBABABABA
Te4(193) = &H78787878
Te4(194) = &H25252525
Te4(195) = &H2E2E2E2E
Te4(196) = &H1C1C1C1C
Te4(197) = &HA6A6A6A6
Te4(198) = &HB4B4B4B4
Te4(199) = &HC6C6C6C6
Te4(200) = &HE8E8E8E8
Te4(201) = &HDDDDDDDD
Te4(202) = &H74747474
Te4(203) = &H1F1F1F1F
Te4(204) = &H4B4B4B4B
Te4(205) = &HBDBDBDBD
Te4(206) = &H8B8B8B8B
Te4(207) = &H8A8A8A8A
Te4(208) = &H70707070
Te4(209) = &H3E3E3E3E
Te4(210) = &HB5B5B5B5
Te4(211) = &H66666666
Te4(212) = &H48484848
Te4(213) = &H3030303
Te4(214) = &HF6F6F6F6
Te4(215) = &HE0E0E0E
Te4(216) = &H61616161
Te4(217) = &H35353535
Te4(218) = &H57575757
Te4(219) = &HB9B9B9B9
Te4(220) = &H86868686
Te4(221) = &HC1C1C1C1
Te4(222) = &H1D1D1D1D
Te4(223) = &H9E9E9E9E
Te4(224) = &HE1E1E1E1
Te4(225) = &HF8F8F8F8
Te4(226) = &H98989898
Te4(227) = &H11111111
Te4(228) = &H69696969
Te4(229) = &HD9D9D9D9
Te4(230) = &H8E8E8E8E
Te4(231) = &H94949494
Te4(232) = &H9B9B9B9B
Te4(233) = &H1E1E1E1E
Te4(234) = &H87878787
Te4(235) = &HE9E9E9E9
Te4(236) = &HCECECECE
Te4(237) = &H55555555
Te4(238) = &H28282828
Te4(239) = &HDFDFDFDF
Te4(240) = &H8C8C8C8C
Te4(241) = &HA1A1A1A1
Te4(242) = &H89898989
Te4(243) = &HD0D0D0D
Te4(244) = &HBFBFBFBF
Te4(245) = &HE6E6E6E6
Te4(246) = &H42424242
Te4(247) = &H68686868
Te4(248) = &H41414141
Te4(249) = &H99999999
Te4(250) = &H2D2D2D2D
Te4(251) = &HF0F0F0F
Te4(252) = &HB0B0B0B0
Te4(253) = &H54545454
Te4(254) = &HBBBBBBBB
Te4(255) = &H16161616
Td0(0) = &H51F4A750
Td0(1) = &H7E416553
Td0(2) = &H1A17A4C3
Td0(3) = &H3A275E96
Td0(4) = &H3BAB6BCB
Td0(5) = &H1F9D45F1
Td0(6) = &HACFA58AB
Td0(7) = &H4BE30393
Td0(8) = &H2030FA55
Td0(9) = &HAD766DF6
Td0(10) = &H88CC7691
Td0(11) = &HF5024C25
Td0(12) = &H4FE5D7FC
Td0(13) = &HC52ACBD7
Td0(14) = &H26354480
Td0(15) = &HB562A38F
Td0(16) = &HDEB15A49
Td0(17) = &H25BA1B67
Td0(18) = &H45EA0E98
Td0(19) = &H5DFEC0E1
Td0(20) = &HC32F7502
Td0(21) = &H814CF012
Td0(22) = &H8D4697A3
Td0(23) = &H6BD3F9C6
Td0(24) = &H38F5FE7
Td0(25) = &H15929C95
Td0(26) = &HBF6D7AEB
Td0(27) = &H955259DA
Td0(28) = &HD4BE832D
Td0(29) = &H587421D3
Td0(30) = &H49E06929
Td0(31) = &H8EC9C844
Td0(32) = &H75C2896A
Td0(33) = &HF48E7978
Td0(34) = &H99583E6B
Td0(35) = &H27B971DD
Td0(36) = &HBEE14FB6
Td0(37) = &HF088AD17
Td0(38) = &HC920AC66
Td0(39) = &H7DCE3AB4
Td0(40) = &H63DF4A18
Td0(41) = &HE51A3182
Td0(42) = &H97513360
Td0(43) = &H62537F45
Td0(44) = &HB16477E0
Td0(45) = &HBB6BAE84
Td0(46) = &HFE81A01C
Td0(47) = &HF9082B94
Td0(48) = &H70486858
Td0(49) = &H8F45FD19
Td0(50) = &H94DE6C87
Td0(51) = &H527BF8B7
Td0(52) = &HAB73D323
Td0(53) = &H724B02E2
Td0(54) = &HE31F8F57
Td0(55) = &H6655AB2A
Td0(56) = &HB2EB2807
Td0(57) = &H2FB5C203
Td0(58) = &H86C57B9A
Td0(59) = &HD33708A5
Td0(60) = &H302887F2
Td0(61) = &H23BFA5B2
Td0(62) = &H2036ABA
Td0(63) = &HED16825C
Td0(64) = &H8ACF1C2B
Td0(65) = &HA779B492
Td0(66) = &HF307F2F0
Td0(67) = &H4E69E2A1
Td0(68) = &H65DAF4CD
Td0(69) = &H605BED5
Td0(70) = &HD134621F
Td0(71) = &HC4A6FE8A
Td0(72) = &H342E539D
Td0(73) = &HA2F355A0
Td0(74) = &H58AE132
Td0(75) = &HA4F6EB75
Td0(76) = &HB83EC39
Td0(77) = &H4060EFAA
Td0(78) = &H5E719F06
Td0(79) = &HBD6E1051
Td0(80) = &H3E218AF9
Td0(81) = &H96DD063D
Td0(82) = &HDD3E05AE
Td0(83) = &H4DE6BD46
Td0(84) = &H91548DB5
Td0(85) = &H71C45D05
Td0(86) = &H406D46F
Td0(87) = &H605015FF
Td0(88) = &H1998FB24
Td0(89) = &HD6BDE997
Td0(90) = &H894043CC
Td0(91) = &H67D99E77
Td0(92) = &HB0E842BD
Td0(93) = &H7898B88
Td0(94) = &HE7195B38
Td0(95) = &H79C8EEDB
Td0(96) = &HA17C0A47
Td0(97) = &H7C420FE9
Td0(98) = &HF8841EC9
Td0(99) = &H0
Td0(100) = &H9808683
Td0(101) = &H322BED48
Td0(102) = &H1E1170AC
Td0(103) = &H6C5A724E
Td0(104) = &HFD0EFFFB
Td0(105) = &HF853856
Td0(106) = &H3DAED51E
Td0(107) = &H362D3927
Td0(108) = &HA0FD964
Td0(109) = &H685CA621
Td0(110) = &H9B5B54D1
Td0(111) = &H24362E3A
Td0(112) = &HC0A67B1
Td0(113) = &H9357E70F
Td0(114) = &HB4EE96D2
Td0(115) = &H1B9B919E
Td0(116) = &H80C0C54F
Td0(117) = &H61DC20A2
Td0(118) = &H5A774B69
Td0(119) = &H1C121A16
Td0(120) = &HE293BA0A
Td0(121) = &HC0A02AE5
Td0(122) = &H3C22E043
Td0(123) = &H121B171D
Td0(124) = &HE090D0B
Td0(125) = &HF28BC7AD
Td0(126) = &H2DB6A8B9
Td0(127) = &H141EA9C8
Td0(128) = &H57F11985
Td0(129) = &HAF75074C
Td0(130) = &HEE99DDBB
Td0(131) = &HA37F60FD
Td0(132) = &HF701269F
Td0(133) = &H5C72F5BC
Td0(134) = &H44663BC5
Td0(135) = &H5BFB7E34
Td0(136) = &H8B432976
Td0(137) = &HCB23C6DC
Td0(138) = &HB6EDFC68
Td0(139) = &HB8E4F163
Td0(140) = &HD731DCCA
Td0(141) = &H42638510
Td0(142) = &H13972240
Td0(143) = &H84C61120
Td0(144) = &H854A247D
Td0(145) = &HD2BB3DF8
Td0(146) = &HAEF93211
Td0(147) = &HC729A16D
Td0(148) = &H1D9E2F4B
Td0(149) = &HDCB230F3
Td0(150) = &HD8652EC
Td0(151) = &H77C1E3D0
Td0(152) = &H2BB3166C
Td0(153) = &HA970B999
Td0(154) = &H119448FA
Td0(155) = &H47E96422
Td0(156) = &HA8FC8CC4
Td0(157) = &HA0F03F1A
Td0(158) = &H567D2CD8
Td0(159) = &H223390EF
Td0(160) = &H87494EC7
Td0(161) = &HD938D1C1
Td0(162) = &H8CCAA2FE
Td0(163) = &H98D40B36
Td0(164) = &HA6F581CF
Td0(165) = &HA57ADE28
Td0(166) = &HDAB78E26
Td0(167) = &H3FADBFA4
Td0(168) = &H2C3A9DE4
Td0(169) = &H5078920D
Td0(170) = &H6A5FCC9B
Td0(171) = &H547E4662
Td0(172) = &HF68D13C2
Td0(173) = &H90D8B8E8
Td0(174) = &H2E39F75E
Td0(175) = &H82C3AFF5
Td0(176) = &H9F5D80BE
Td0(177) = &H69D0937C
Td0(178) = &H6FD52DA9
Td0(179) = &HCF2512B3
Td0(180) = &HC8AC993B
Td0(181) = &H10187DA7
Td0(182) = &HE89C636E
Td0(183) = &HDB3BBB7B
Td0(184) = &HCD267809
Td0(185) = &H6E5918F4
Td0(186) = &HEC9AB701
Td0(187) = &H834F9AA8
Td0(188) = &HE6956E65
Td0(189) = &HAAFFE67E
Td0(190) = &H21BCCF08
Td0(191) = &HEF15E8E6
Td0(192) = &HBAE79BD9
Td0(193) = &H4A6F36CE
Td0(194) = &HEA9F09D4
Td0(195) = &H29B07CD6
Td0(196) = &H31A4B2AF
Td0(197) = &H2A3F2331
Td0(198) = &HC6A59430
Td0(199) = &H35A266C0
Td0(200) = &H744EBC37
Td0(201) = &HFC82CAA6
Td0(202) = &HE090D0B0
Td0(203) = &H33A7D815
Td0(204) = &HF104984A
Td0(205) = &H41ECDAF7
Td0(206) = &H7FCD500E
Td0(207) = &H1791F62F
Td0(208) = &H764DD68D
Td0(209) = &H43EFB04D
Td0(210) = &HCCAA4D54
Td0(211) = &HE49604DF
Td0(212) = &H9ED1B5E3
Td0(213) = &H4C6A881B
Td0(214) = &HC12C1FB8
Td0(215) = &H4665517F
Td0(216) = &H9D5EEA04
Td0(217) = &H18C355D
Td0(218) = &HFA877473
Td0(219) = &HFB0B412E
Td0(220) = &HB3671D5A
Td0(221) = &H92DBD252
Td0(222) = &HE9105633
Td0(223) = &H6DD64713
Td0(224) = &H9AD7618C
Td0(225) = &H37A10C7A
Td0(226) = &H59F8148E
Td0(227) = &HEB133C89
Td0(228) = &HCEA927EE
Td0(229) = &HB761C935
Td0(230) = &HE11CE5ED
Td0(231) = &H7A47B13C
Td0(232) = &H9CD2DF59
Td0(233) = &H55F2733F
Td0(234) = &H1814CE79
Td0(235) = &H73C737BF
Td0(236) = &H53F7CDEA
Td0(237) = &H5FFDAA5B
Td0(238) = &HDF3D6F14
Td0(239) = &H7844DB86
Td0(240) = &HCAAFF381
Td0(241) = &HB968C43E
Td0(242) = &H3824342C
Td0(243) = &HC2A3405F
Td0(244) = &H161DC372
Td0(245) = &HBCE2250C
Td0(246) = &H283C498B
Td0(247) = &HFF0D9541
Td0(248) = &H39A80171
Td0(249) = &H80CB3DE
Td0(250) = &HD8B4E49C
Td0(251) = &H6456C190
Td0(252) = &H7BCB8461
Td0(253) = &HD532B670
Td0(254) = &H486C5C74
Td0(255) = &HD0B85742
Td1(0) = &H5051F4A7
Td1(1) = &H537E4165
Td1(2) = &HC31A17A4
Td1(3) = &H963A275E
Td1(4) = &HCB3BAB6B
Td1(5) = &HF11F9D45
Td1(6) = &HABACFA58
Td1(7) = &H934BE303
Td1(8) = &H552030FA
Td1(9) = &HF6AD766D
Td1(10) = &H9188CC76
Td1(11) = &H25F5024C
Td1(12) = &HFC4FE5D7
Td1(13) = &HD7C52ACB
Td1(14) = &H80263544
Td1(15) = &H8FB562A3
Td1(16) = &H49DEB15A
Td1(17) = &H6725BA1B
Td1(18) = &H9845EA0E
Td1(19) = &HE15DFEC0
Td1(20) = &H2C32F75
Td1(21) = &H12814CF0
Td1(22) = &HA38D4697
Td1(23) = &HC66BD3F9
Td1(24) = &HE7038F5F
Td1(25) = &H9515929C
Td1(26) = &HEBBF6D7A
Td1(27) = &HDA955259
Td1(28) = &H2DD4BE83
Td1(29) = &HD3587421
Td1(30) = &H2949E069
Td1(31) = &H448EC9C8
Td1(32) = &H6A75C289
Td1(33) = &H78F48E79
Td1(34) = &H6B99583E
Td1(35) = &HDD27B971
Td1(36) = &HB6BEE14F
Td1(37) = &H17F088AD
Td1(38) = &H66C920AC
Td1(39) = &HB47DCE3A
Td1(40) = &H1863DF4A
Td1(41) = &H82E51A31
Td1(42) = &H60975133
Td1(43) = &H4562537F
Td1(44) = &HE0B16477
Td1(45) = &H84BB6BAE
Td1(46) = &H1CFE81A0
Td1(47) = &H94F9082B
Td1(48) = &H58704868
Td1(49) = &H198F45FD
Td1(50) = &H8794DE6C
Td1(51) = &HB7527BF8
Td1(52) = &H23AB73D3
Td1(53) = &HE2724B02
Td1(54) = &H57E31F8F
Td1(55) = &H2A6655AB
Td1(56) = &H7B2EB28
Td1(57) = &H32FB5C2
Td1(58) = &H9A86C57B
Td1(59) = &HA5D33708
Td1(60) = &HF2302887
Td1(61) = &HB223BFA5
Td1(62) = &HBA02036A
Td1(63) = &H5CED1682
Td1(64) = &H2B8ACF1C
Td1(65) = &H92A779B4
Td1(66) = &HF0F307F2
Td1(67) = &HA14E69E2
Td1(68) = &HCD65DAF4
Td1(69) = &HD50605BE
Td1(70) = &H1FD13462
Td1(71) = &H8AC4A6FE
Td1(72) = &H9D342E53
Td1(73) = &HA0A2F355
Td1(74) = &H32058AE1
Td1(75) = &H75A4F6EB
Td1(76) = &H390B83EC
Td1(77) = &HAA4060EF
Td1(78) = &H65E719F
Td1(79) = &H51BD6E10
Td1(80) = &HF93E218A
Td1(81) = &H3D96DD06
Td1(82) = &HAEDD3E05
Td1(83) = &H464DE6BD
Td1(84) = &HB591548D
Td1(85) = &H571C45D
Td1(86) = &H6F0406D4
Td1(87) = &HFF605015
Td1(88) = &H241998FB
Td1(89) = &H97D6BDE9
Td1(90) = &HCC894043
Td1(91) = &H7767D99E
Td1(92) = &HBDB0E842
Td1(93) = &H8807898B
Td1(94) = &H38E7195B
Td1(95) = &HDB79C8EE
Td1(96) = &H47A17C0A
Td1(97) = &HE97C420F
Td1(98) = &HC9F8841E
Td1(99) = &H0
Td1(100) = &H83098086
Td1(101) = &H48322BED
Td1(102) = &HAC1E1170
Td1(103) = &H4E6C5A72
Td1(104) = &HFBFD0EFF
Td1(105) = &H560F8538
Td1(106) = &H1E3DAED5
Td1(107) = &H27362D39
Td1(108) = &H640A0FD9
Td1(109) = &H21685CA6
Td1(110) = &HD19B5B54
Td1(111) = &H3A24362E
Td1(112) = &HB10C0A67
Td1(113) = &HF9357E7
Td1(114) = &HD2B4EE96
Td1(115) = &H9E1B9B91
Td1(116) = &H4F80C0C5
Td1(117) = &HA261DC20
Td1(118) = &H695A774B
Td1(119) = &H161C121A
Td1(120) = &HAE293BA
Td1(121) = &HE5C0A02A
Td1(122) = &H433C22E0
Td1(123) = &H1D121B17
Td1(124) = &HB0E090D
Td1(125) = &HADF28BC7
Td1(126) = &HB92DB6A8
Td1(127) = &HC8141EA9
Td1(128) = &H8557F119
Td1(129) = &H4CAF7507
Td1(130) = &HBBEE99DD
Td1(131) = &HFDA37F60
Td1(132) = &H9FF70126
Td1(133) = &HBC5C72F5
Td1(134) = &HC544663B
Td1(135) = &H345BFB7E
Td1(136) = &H768B4329
Td1(137) = &HDCCB23C6
Td1(138) = &H68B6EDFC
Td1(139) = &H63B8E4F1
Td1(140) = &HCAD731DC
Td1(141) = &H10426385
Td1(142) = &H40139722
Td1(143) = &H2084C611
Td1(144) = &H7D854A24
Td1(145) = &HF8D2BB3D
Td1(146) = &H11AEF932
Td1(147) = &H6DC729A1
Td1(148) = &H4B1D9E2F
Td1(149) = &HF3DCB230
Td1(150) = &HEC0D8652
Td1(151) = &HD077C1E3
Td1(152) = &H6C2BB316
Td1(153) = &H99A970B9
Td1(154) = &HFA119448
Td1(155) = &H2247E964
Td1(156) = &HC4A8FC8C
Td1(157) = &H1AA0F03F
Td1(158) = &HD8567D2C
Td1(159) = &HEF223390
Td1(160) = &HC787494E
Td1(161) = &HC1D938D1
Td1(162) = &HFE8CCAA2
Td1(163) = &H3698D40B
Td1(164) = &HCFA6F581
Td1(165) = &H28A57ADE
Td1(166) = &H26DAB78E
Td1(167) = &HA43FADBF
Td1(168) = &HE42C3A9D
Td1(169) = &HD507892
Td1(170) = &H9B6A5FCC
Td1(171) = &H62547E46
Td1(172) = &HC2F68D13
Td1(173) = &HE890D8B8
Td1(174) = &H5E2E39F7
Td1(175) = &HF582C3AF
Td1(176) = &HBE9F5D80
Td1(177) = &H7C69D093
Td1(178) = &HA96FD52D
Td1(179) = &HB3CF2512
Td1(180) = &H3BC8AC99
Td1(181) = &HA710187D
Td1(182) = &H6EE89C63
Td1(183) = &H7BDB3BBB
Td1(184) = &H9CD2678
Td1(185) = &HF46E5918
Td1(186) = &H1EC9AB7
Td1(187) = &HA8834F9A
Td1(188) = &H65E6956E
Td1(189) = &H7EAAFFE6
Td1(190) = &H821BCCF
Td1(191) = &HE6EF15E8
Td1(192) = &HD9BAE79B
Td1(193) = &HCE4A6F36
Td1(194) = &HD4EA9F09
Td1(195) = &HD629B07C
Td1(196) = &HAF31A4B2
Td1(197) = &H312A3F23
Td1(198) = &H30C6A594
Td1(199) = &HC035A266
Td1(200) = &H37744EBC
Td1(201) = &HA6FC82CA
Td1(202) = &HB0E090D0
Td1(203) = &H1533A7D8
Td1(204) = &H4AF10498
Td1(205) = &HF741ECDA
Td1(206) = &HE7FCD50
Td1(207) = &H2F1791F6
Td1(208) = &H8D764DD6
Td1(209) = &H4D43EFB0
Td1(210) = &H54CCAA4D
Td1(211) = &HDFE49604
Td1(212) = &HE39ED1B5
Td1(213) = &H1B4C6A88
Td1(214) = &HB8C12C1F
Td1(215) = &H7F466551
Td1(216) = &H49D5EEA
Td1(217) = &H5D018C35
Td1(218) = &H73FA8774
Td1(219) = &H2EFB0B41
Td1(220) = &H5AB3671D
Td1(221) = &H5292DBD2
Td1(222) = &H33E91056
Td1(223) = &H136DD647
Td1(224) = &H8C9AD761
Td1(225) = &H7A37A10C
Td1(226) = &H8E59F814
Td1(227) = &H89EB133C
Td1(228) = &HEECEA927
Td1(229) = &H35B761C9
Td1(230) = &HEDE11CE5
Td1(231) = &H3C7A47B1
Td1(232) = &H599CD2DF
Td1(233) = &H3F55F273
Td1(234) = &H791814CE
Td1(235) = &HBF73C737
Td1(236) = &HEA53F7CD
Td1(237) = &H5B5FFDAA
Td1(238) = &H14DF3D6F
Td1(239) = &H867844DB
Td1(240) = &H81CAAFF3
Td1(241) = &H3EB968C4
Td1(242) = &H2C382434
Td1(243) = &H5FC2A340
Td1(244) = &H72161DC3
Td1(245) = &HCBCE225
Td1(246) = &H8B283C49
Td1(247) = &H41FF0D95
Td1(248) = &H7139A801
Td1(249) = &HDE080CB3
Td1(250) = &H9CD8B4E4
Td1(251) = &H906456C1
Td1(252) = &H617BCB84
Td1(253) = &H70D532B6
Td1(254) = &H74486C5C
Td1(255) = &H42D0B857
Td2(0) = &HA75051F4
Td2(1) = &H65537E41
Td2(2) = &HA4C31A17
Td2(3) = &H5E963A27
Td2(4) = &H6BCB3BAB
Td2(5) = &H45F11F9D
Td2(6) = &H58ABACFA
Td2(7) = &H3934BE3
Td2(8) = &HFA552030
Td2(9) = &H6DF6AD76
Td2(10) = &H769188CC
Td2(11) = &H4C25F502
Td2(12) = &HD7FC4FE5
Td2(13) = &HCBD7C52A
Td2(14) = &H44802635
Td2(15) = &HA38FB562
Td2(16) = &H5A49DEB1
Td2(17) = &H1B6725BA
Td2(18) = &HE9845EA
Td2(19) = &HC0E15DFE
Td2(20) = &H7502C32F
Td2(21) = &HF012814C
Td2(22) = &H97A38D46
Td2(23) = &HF9C66BD3
Td2(24) = &H5FE7038F
Td2(25) = &H9C951592
Td2(26) = &H7AEBBF6D
Td2(27) = &H59DA9552
Td2(28) = &H832DD4BE
Td2(29) = &H21D35874
Td2(30) = &H692949E0
Td2(31) = &HC8448EC9
Td2(32) = &H896A75C2
Td2(33) = &H7978F48E
Td2(34) = &H3E6B9958
Td2(35) = &H71DD27B9
Td2(36) = &H4FB6BEE1
Td2(37) = &HAD17F088
Td2(38) = &HAC66C920
Td2(39) = &H3AB47DCE
Td2(40) = &H4A1863DF
Td2(41) = &H3182E51A
Td2(42) = &H33609751
Td2(43) = &H7F456253
Td2(44) = &H77E0B164
Td2(45) = &HAE84BB6B
Td2(46) = &HA01CFE81
Td2(47) = &H2B94F908
Td2(48) = &H68587048
Td2(49) = &HFD198F45
Td2(50) = &H6C8794DE
Td2(51) = &HF8B7527B
Td2(52) = &HD323AB73
Td2(53) = &H2E2724B
Td2(54) = &H8F57E31F
Td2(55) = &HAB2A6655
Td2(56) = &H2807B2EB
Td2(57) = &HC2032FB5
Td2(58) = &H7B9A86C5
Td2(59) = &H8A5D337
Td2(60) = &H87F23028
Td2(61) = &HA5B223BF
Td2(62) = &H6ABA0203
Td2(63) = &H825CED16
Td2(64) = &H1C2B8ACF
Td2(65) = &HB492A779
Td2(66) = &HF2F0F307
Td2(67) = &HE2A14E69
Td2(68) = &HF4CD65DA
Td2(69) = &HBED50605
Td2(70) = &H621FD134
Td2(71) = &HFE8AC4A6
Td2(72) = &H539D342E
Td2(73) = &H55A0A2F3
Td2(74) = &HE132058A
Td2(75) = &HEB75A4F6
Td2(76) = &HEC390B83
Td2(77) = &HEFAA4060
Td2(78) = &H9F065E71
Td2(79) = &H1051BD6E
Td2(80) = &H8AF93E21
Td2(81) = &H63D96DD
Td2(82) = &H5AEDD3E
Td2(83) = &HBD464DE6
Td2(84) = &H8DB59154
Td2(85) = &H5D0571C4
Td2(86) = &HD46F0406
Td2(87) = &H15FF6050
Td2(88) = &HFB241998
Td2(89) = &HE997D6BD
Td2(90) = &H43CC8940
Td2(91) = &H9E7767D9
Td2(92) = &H42BDB0E8
Td2(93) = &H8B880789
Td2(94) = &H5B38E719
Td2(95) = &HEEDB79C8
Td2(96) = &HA47A17C
Td2(97) = &HFE97C42
Td2(98) = &H1EC9F884
Td2(99) = &H0
Td2(100) = &H86830980
Td2(101) = &HED48322B
Td2(102) = &H70AC1E11
Td2(103) = &H724E6C5A
Td2(104) = &HFFFBFD0E
Td2(105) = &H38560F85
Td2(106) = &HD51E3DAE
Td2(107) = &H3927362D
Td2(108) = &HD9640A0F
Td2(109) = &HA621685C
Td2(110) = &H54D19B5B
Td2(111) = &H2E3A2436
Td2(112) = &H67B10C0A
Td2(113) = &HE70F9357
Td2(114) = &H96D2B4EE
Td2(115) = &H919E1B9B
Td2(116) = &HC54F80C0
Td2(117) = &H20A261DC
Td2(118) = &H4B695A77
Td2(119) = &H1A161C12
Td2(120) = &HBA0AE293
Td2(121) = &H2AE5C0A0
Td2(122) = &HE0433C22
Td2(123) = &H171D121B
Td2(124) = &HD0B0E09
Td2(125) = &HC7ADF28B
Td2(126) = &HA8B92DB6
Td2(127) = &HA9C8141E
Td2(128) = &H198557F1
Td2(129) = &H74CAF75
Td2(130) = &HDDBBEE99
Td2(131) = &H60FDA37F
Td2(132) = &H269FF701
Td2(133) = &HF5BC5C72
Td2(134) = &H3BC54466
Td2(135) = &H7E345BFB
Td2(136) = &H29768B43
Td2(137) = &HC6DCCB23
Td2(138) = &HFC68B6ED
Td2(139) = &HF163B8E4
Td2(140) = &HDCCAD731
Td2(141) = &H85104263
Td2(142) = &H22401397
Td2(143) = &H112084C6
Td2(144) = &H247D854A
Td2(145) = &H3DF8D2BB
Td2(146) = &H3211AEF9
Td2(147) = &HA16DC729
Td2(148) = &H2F4B1D9E
Td2(149) = &H30F3DCB2
Td2(150) = &H52EC0D86
Td2(151) = &HE3D077C1
Td2(152) = &H166C2BB3
Td2(153) = &HB999A970
Td2(154) = &H48FA1194
Td2(155) = &H642247E9
Td2(156) = &H8CC4A8FC
Td2(157) = &H3F1AA0F0
Td2(158) = &H2CD8567D
Td2(159) = &H90EF2233
Td2(160) = &H4EC78749
Td2(161) = &HD1C1D938
Td2(162) = &HA2FE8CCA
Td2(163) = &HB3698D4
Td2(164) = &H81CFA6F5
Td2(165) = &HDE28A57A
Td2(166) = &H8E26DAB7
Td2(167) = &HBFA43FAD
Td2(168) = &H9DE42C3A
Td2(169) = &H920D5078
Td2(170) = &HCC9B6A5F
Td2(171) = &H4662547E
Td2(172) = &H13C2F68D
Td2(173) = &HB8E890D8
Td2(174) = &HF75E2E39
Td2(175) = &HAFF582C3
Td2(176) = &H80BE9F5D
Td2(177) = &H937C69D0
Td2(178) = &H2DA96FD5
Td2(179) = &H12B3CF25
Td2(180) = &H993BC8AC
Td2(181) = &H7DA71018
Td2(182) = &H636EE89C
Td2(183) = &HBB7BDB3B
Td2(184) = &H7809CD26
Td2(185) = &H18F46E59
Td2(186) = &HB701EC9A
Td2(187) = &H9AA8834F
Td2(188) = &H6E65E695
Td2(189) = &HE67EAAFF
Td2(190) = &HCF0821BC
Td2(191) = &HE8E6EF15
Td2(192) = &H9BD9BAE7
Td2(193) = &H36CE4A6F
Td2(194) = &H9D4EA9F
Td2(195) = &H7CD629B0
Td2(196) = &HB2AF31A4
Td2(197) = &H23312A3F
Td2(198) = &H9430C6A5
Td2(199) = &H66C035A2
Td2(200) = &HBC37744E
Td2(201) = &HCAA6FC82
Td2(202) = &HD0B0E090
Td2(203) = &HD81533A7
Td2(204) = &H984AF104
Td2(205) = &HDAF741EC
Td2(206) = &H500E7FCD
Td2(207) = &HF62F1791
Td2(208) = &HD68D764D
Td2(209) = &HB04D43EF
Td2(210) = &H4D54CCAA
Td2(211) = &H4DFE496
Td2(212) = &HB5E39ED1
Td2(213) = &H881B4C6A
Td2(214) = &H1FB8C12C
Td2(215) = &H517F4665
Td2(216) = &HEA049D5E
Td2(217) = &H355D018C
Td2(218) = &H7473FA87
Td2(219) = &H412EFB0B
Td2(220) = &H1D5AB367
Td2(221) = &HD25292DB
Td2(222) = &H5633E910
Td2(223) = &H47136DD6
Td2(224) = &H618C9AD7
Td2(225) = &HC7A37A1
Td2(226) = &H148E59F8
Td2(227) = &H3C89EB13
Td2(228) = &H27EECEA9
Td2(229) = &HC935B761
Td2(230) = &HE5EDE11C
Td2(231) = &HB13C7A47
Td2(232) = &HDF599CD2
Td2(233) = &H733F55F2
Td2(234) = &HCE791814
Td2(235) = &H37BF73C7
Td2(236) = &HCDEA53F7
Td2(237) = &HAA5B5FFD
Td2(238) = &H6F14DF3D
Td2(239) = &HDB867844
Td2(240) = &HF381CAAF
Td2(241) = &HC43EB968
Td2(242) = &H342C3824
Td2(243) = &H405FC2A3
Td2(244) = &HC372161D
Td2(245) = &H250CBCE2
Td2(246) = &H498B283C
Td2(247) = &H9541FF0D
Td2(248) = &H17139A8
Td2(249) = &HB3DE080C
Td2(250) = &HE49CD8B4
Td2(251) = &HC1906456
Td2(252) = &H84617BCB
Td2(253) = &HB670D532
Td2(254) = &H5C74486C
Td2(255) = &H5742D0B8
Td3(0) = &HF4A75051
Td3(1) = &H4165537E
Td3(2) = &H17A4C31A
Td3(3) = &H275E963A
Td3(4) = &HAB6BCB3B
Td3(5) = &H9D45F11F
Td3(6) = &HFA58ABAC
Td3(7) = &HE303934B
Td3(8) = &H30FA5520
Td3(9) = &H766DF6AD
Td3(10) = &HCC769188
Td3(11) = &H24C25F5
Td3(12) = &HE5D7FC4F
Td3(13) = &H2ACBD7C5
Td3(14) = &H35448026
Td3(15) = &H62A38FB5
Td3(16) = &HB15A49DE
Td3(17) = &HBA1B6725
Td3(18) = &HEA0E9845
Td3(19) = &HFEC0E15D
Td3(20) = &H2F7502C3
Td3(21) = &H4CF01281
Td3(22) = &H4697A38D
Td3(23) = &HD3F9C66B
Td3(24) = &H8F5FE703
Td3(25) = &H929C9515
Td3(26) = &H6D7AEBBF
Td3(27) = &H5259DA95
Td3(28) = &HBE832DD4
Td3(29) = &H7421D358
Td3(30) = &HE0692949
Td3(31) = &HC9C8448E
Td3(32) = &HC2896A75
Td3(33) = &H8E7978F4
Td3(34) = &H583E6B99
Td3(35) = &HB971DD27
Td3(36) = &HE14FB6BE
Td3(37) = &H88AD17F0
Td3(38) = &H20AC66C9
Td3(39) = &HCE3AB47D
Td3(40) = &HDF4A1863
Td3(41) = &H1A3182E5
Td3(42) = &H51336097
Td3(43) = &H537F4562
Td3(44) = &H6477E0B1
Td3(45) = &H6BAE84BB
Td3(46) = &H81A01CFE
Td3(47) = &H82B94F9
Td3(48) = &H48685870
Td3(49) = &H45FD198F
Td3(50) = &HDE6C8794
Td3(51) = &H7BF8B752
Td3(52) = &H73D323AB
Td3(53) = &H4B02E272
Td3(54) = &H1F8F57E3
Td3(55) = &H55AB2A66
Td3(56) = &HEB2807B2
Td3(57) = &HB5C2032F
Td3(58) = &HC57B9A86
Td3(59) = &H3708A5D3
Td3(60) = &H2887F230
Td3(61) = &HBFA5B223
Td3(62) = &H36ABA02
Td3(63) = &H16825CED
Td3(64) = &HCF1C2B8A
Td3(65) = &H79B492A7
Td3(66) = &H7F2F0F3
Td3(67) = &H69E2A14E
Td3(68) = &HDAF4CD65
Td3(69) = &H5BED506
Td3(70) = &H34621FD1
Td3(71) = &HA6FE8AC4
Td3(72) = &H2E539D34
Td3(73) = &HF355A0A2
Td3(74) = &H8AE13205
Td3(75) = &HF6EB75A4
Td3(76) = &H83EC390B
Td3(77) = &H60EFAA40
Td3(78) = &H719F065E
Td3(79) = &H6E1051BD
Td3(80) = &H218AF93E
Td3(81) = &HDD063D96
Td3(82) = &H3E05AEDD
Td3(83) = &HE6BD464D
Td3(84) = &H548DB591
Td3(85) = &HC45D0571
Td3(86) = &H6D46F04
Td3(87) = &H5015FF60
Td3(88) = &H98FB2419
Td3(89) = &HBDE997D6
Td3(90) = &H4043CC89
Td3(91) = &HD99E7767
Td3(92) = &HE842BDB0
Td3(93) = &H898B8807
Td3(94) = &H195B38E7
Td3(95) = &HC8EEDB79
Td3(96) = &H7C0A47A1
Td3(97) = &H420FE97C
Td3(98) = &H841EC9F8
Td3(99) = &H0
Td3(100) = &H80868309
Td3(101) = &H2BED4832
Td3(102) = &H1170AC1E
Td3(103) = &H5A724E6C
Td3(104) = &HEFFFBFD
Td3(105) = &H8538560F
Td3(106) = &HAED51E3D
Td3(107) = &H2D392736
Td3(108) = &HFD9640A
Td3(109) = &H5CA62168
Td3(110) = &H5B54D19B
Td3(111) = &H362E3A24
Td3(112) = &HA67B10C
Td3(113) = &H57E70F93
Td3(114) = &HEE96D2B4
Td3(115) = &H9B919E1B
Td3(116) = &HC0C54F80
Td3(117) = &HDC20A261
Td3(118) = &H774B695A
Td3(119) = &H121A161C
Td3(120) = &H93BA0AE2
Td3(121) = &HA02AE5C0
Td3(122) = &H22E0433C
Td3(123) = &H1B171D12
Td3(124) = &H90D0B0E
Td3(125) = &H8BC7ADF2
Td3(126) = &HB6A8B92D
Td3(127) = &H1EA9C814
Td3(128) = &HF1198557
Td3(129) = &H75074CAF
Td3(130) = &H99DDBBEE
Td3(131) = &H7F60FDA3
Td3(132) = &H1269FF7
Td3(133) = &H72F5BC5C
Td3(134) = &H663BC544
Td3(135) = &HFB7E345B
Td3(136) = &H4329768B
Td3(137) = &H23C6DCCB
Td3(138) = &HEDFC68B6
Td3(139) = &HE4F163B8
Td3(140) = &H31DCCAD7
Td3(141) = &H63851042
Td3(142) = &H97224013
Td3(143) = &HC6112084
Td3(144) = &H4A247D85
Td3(145) = &HBB3DF8D2
Td3(146) = &HF93211AE
Td3(147) = &H29A16DC7
Td3(148) = &H9E2F4B1D
Td3(149) = &HB230F3DC
Td3(150) = &H8652EC0D
Td3(151) = &HC1E3D077
Td3(152) = &HB3166C2B
Td3(153) = &H70B999A9
Td3(154) = &H9448FA11
Td3(155) = &HE9642247
Td3(156) = &HFC8CC4A8
Td3(157) = &HF03F1AA0
Td3(158) = &H7D2CD856
Td3(159) = &H3390EF22
Td3(160) = &H494EC787
Td3(161) = &H38D1C1D9
Td3(162) = &HCAA2FE8C
Td3(163) = &HD40B3698
Td3(164) = &HF581CFA6
Td3(165) = &H7ADE28A5
Td3(166) = &HB78E26DA
Td3(167) = &HADBFA43F
Td3(168) = &H3A9DE42C
Td3(169) = &H78920D50
Td3(170) = &H5FCC9B6A
Td3(171) = &H7E466254
Td3(172) = &H8D13C2F6
Td3(173) = &HD8B8E890
Td3(174) = &H39F75E2E
Td3(175) = &HC3AFF582
Td3(176) = &H5D80BE9F
Td3(177) = &HD0937C69
Td3(178) = &HD52DA96F
Td3(179) = &H2512B3CF
Td3(180) = &HAC993BC8
Td3(181) = &H187DA710
Td3(182) = &H9C636EE8
Td3(183) = &H3BBB7BDB
Td3(184) = &H267809CD
Td3(185) = &H5918F46E
Td3(186) = &H9AB701EC
Td3(187) = &H4F9AA883
Td3(188) = &H956E65E6
Td3(189) = &HFFE67EAA
Td3(190) = &HBCCF0821
Td3(191) = &H15E8E6EF
Td3(192) = &HE79BD9BA
Td3(193) = &H6F36CE4A
Td3(194) = &H9F09D4EA
Td3(195) = &HB07CD629
Td3(196) = &HA4B2AF31
Td3(197) = &H3F23312A
Td3(198) = &HA59430C6
Td3(199) = &HA266C035
Td3(200) = &H4EBC3774
Td3(201) = &H82CAA6FC
Td3(202) = &H90D0B0E0
Td3(203) = &HA7D81533
Td3(204) = &H4984AF1
Td3(205) = &HECDAF741
Td3(206) = &HCD500E7F
Td3(207) = &H91F62F17
Td3(208) = &H4DD68D76
Td3(209) = &HEFB04D43
Td3(210) = &HAA4D54CC
Td3(211) = &H9604DFE4
Td3(212) = &HD1B5E39E
Td3(213) = &H6A881B4C
Td3(214) = &H2C1FB8C1
Td3(215) = &H65517F46
Td3(216) = &H5EEA049D
Td3(217) = &H8C355D01
Td3(218) = &H877473FA
Td3(219) = &HB412EFB
Td3(220) = &H671D5AB3
Td3(221) = &HDBD25292
Td3(222) = &H105633E9
Td3(223) = &HD647136D
Td3(224) = &HD7618C9A
Td3(225) = &HA10C7A37
Td3(226) = &HF8148E59
Td3(227) = &H133C89EB
Td3(228) = &HA927EECE
Td3(229) = &H61C935B7
Td3(230) = &H1CE5EDE1
Td3(231) = &H47B13C7A
Td3(232) = &HD2DF599C
Td3(233) = &HF2733F55
Td3(234) = &H14CE7918
Td3(235) = &HC737BF73
Td3(236) = &HF7CDEA53
Td3(237) = &HFDAA5B5F
Td3(238) = &H3D6F14DF
Td3(239) = &H44DB8678
Td3(240) = &HAFF381CA
Td3(241) = &H68C43EB9
Td3(242) = &H24342C38
Td3(243) = &HA3405FC2
Td3(244) = &H1DC37216
Td3(245) = &HE2250CBC
Td3(246) = &H3C498B28
Td3(247) = &HD9541FF
Td3(248) = &HA8017139
Td3(249) = &HCB3DE08
Td3(250) = &HB4E49CD8
Td3(251) = &H56C19064
Td3(252) = &HCB84617B
Td3(253) = &H32B670D5
Td3(254) = &H6C5C7448
Td3(255) = &HB85742D0
Td4(0) = &H52525252
Td4(1) = &H9090909
Td4(2) = &H6A6A6A6A
Td4(3) = &HD5D5D5D5
Td4(4) = &H30303030
Td4(5) = &H36363636
Td4(6) = &HA5A5A5A5
Td4(7) = &H38383838
Td4(8) = &HBFBFBFBF
Td4(9) = &H40404040
Td4(10) = &HA3A3A3A3
Td4(11) = &H9E9E9E9E
Td4(12) = &H81818181
Td4(13) = &HF3F3F3F3
Td4(14) = &HD7D7D7D7
Td4(15) = &HFBFBFBFB
Td4(16) = &H7C7C7C7C
Td4(17) = &HE3E3E3E3
Td4(18) = &H39393939
Td4(19) = &H82828282
Td4(20) = &H9B9B9B9B
Td4(21) = &H2F2F2F2F
Td4(22) = &HFFFFFFFF
Td4(23) = &H87878787
Td4(24) = &H34343434
Td4(25) = &H8E8E8E8E
Td4(26) = &H43434343
Td4(27) = &H44444444
Td4(28) = &HC4C4C4C4
Td4(29) = &HDEDEDEDE
Td4(30) = &HE9E9E9E9
Td4(31) = &HCBCBCBCB
Td4(32) = &H54545454
Td4(33) = &H7B7B7B7B
Td4(34) = &H94949494
Td4(35) = &H32323232
Td4(36) = &HA6A6A6A6
Td4(37) = &HC2C2C2C2
Td4(38) = &H23232323
Td4(39) = &H3D3D3D3D
Td4(40) = &HEEEEEEEE
Td4(41) = &H4C4C4C4C
Td4(42) = &H95959595
Td4(43) = &HB0B0B0B
Td4(44) = &H42424242
Td4(45) = &HFAFAFAFA
Td4(46) = &HC3C3C3C3
Td4(47) = &H4E4E4E4E
Td4(48) = &H8080808
Td4(49) = &H2E2E2E2E
Td4(50) = &HA1A1A1A1
Td4(51) = &H66666666
Td4(52) = &H28282828
Td4(53) = &HD9D9D9D9
Td4(54) = &H24242424
Td4(55) = &HB2B2B2B2
Td4(56) = &H76767676
Td4(57) = &H5B5B5B5B
Td4(58) = &HA2A2A2A2
Td4(59) = &H49494949
Td4(60) = &H6D6D6D6D
Td4(61) = &H8B8B8B8B
Td4(62) = &HD1D1D1D1
Td4(63) = &H25252525
Td4(64) = &H72727272
Td4(65) = &HF8F8F8F8
Td4(66) = &HF6F6F6F6
Td4(67) = &H64646464
Td4(68) = &H86868686
Td4(69) = &H68686868
Td4(70) = &H98989898
Td4(71) = &H16161616
Td4(72) = &HD4D4D4D4
Td4(73) = &HA4A4A4A4
Td4(74) = &H5C5C5C5C
Td4(75) = &HCCCCCCCC
Td4(76) = &H5D5D5D5D
Td4(77) = &H65656565
Td4(78) = &HB6B6B6B6
Td4(79) = &H92929292
Td4(80) = &H6C6C6C6C
Td4(81) = &H70707070
Td4(82) = &H48484848
Td4(83) = &H50505050
Td4(84) = &HFDFDFDFD
Td4(85) = &HEDEDEDED
Td4(86) = &HB9B9B9B9
Td4(87) = &HDADADADA
Td4(88) = &H5E5E5E5E
Td4(89) = &H15151515
Td4(90) = &H46464646
Td4(91) = &H57575757
Td4(92) = &HA7A7A7A7
Td4(93) = &H8D8D8D8D
Td4(94) = &H9D9D9D9D
Td4(95) = &H84848484
Td4(96) = &H90909090
Td4(97) = &HD8D8D8D8
Td4(98) = &HABABABAB
Td4(99) = &H0
Td4(100) = &H8C8C8C8C
Td4(101) = &HBCBCBCBC
Td4(102) = &HD3D3D3D3
Td4(103) = &HA0A0A0A
Td4(104) = &HF7F7F7F7
Td4(105) = &HE4E4E4E4
Td4(106) = &H58585858
Td4(107) = &H5050505
Td4(108) = &HB8B8B8B8
Td4(109) = &HB3B3B3B3
Td4(110) = &H45454545
Td4(111) = &H6060606
Td4(112) = &HD0D0D0D0
Td4(113) = &H2C2C2C2C
Td4(114) = &H1E1E1E1E
Td4(115) = &H8F8F8F8F
Td4(116) = &HCACACACA
Td4(117) = &H3F3F3F3F
Td4(118) = &HF0F0F0F
Td4(119) = &H2020202
Td4(120) = &HC1C1C1C1
Td4(121) = &HAFAFAFAF
Td4(122) = &HBDBDBDBD
Td4(123) = &H3030303
Td4(124) = &H1010101
Td4(125) = &H13131313
Td4(126) = &H8A8A8A8A
Td4(127) = &H6B6B6B6B
Td4(128) = &H3A3A3A3A
Td4(129) = &H91919191
Td4(130) = &H11111111
Td4(131) = &H41414141
Td4(132) = &H4F4F4F4F
Td4(133) = &H67676767
Td4(134) = &HDCDCDCDC
Td4(135) = &HEAEAEAEA
Td4(136) = &H97979797
Td4(137) = &HF2F2F2F2
Td4(138) = &HCFCFCFCF
Td4(139) = &HCECECECE
Td4(140) = &HF0F0F0F0
Td4(141) = &HB4B4B4B4
Td4(142) = &HE6E6E6E6
Td4(143) = &H73737373
Td4(144) = &H96969696
Td4(145) = &HACACACAC
Td4(146) = &H74747474
Td4(147) = &H22222222
Td4(148) = &HE7E7E7E7
Td4(149) = &HADADADAD
Td4(150) = &H35353535
Td4(151) = &H85858585
Td4(152) = &HE2E2E2E2
Td4(153) = &HF9F9F9F9
Td4(154) = &H37373737
Td4(155) = &HE8E8E8E8
Td4(156) = &H1C1C1C1C
Td4(157) = &H75757575
Td4(158) = &HDFDFDFDF
Td4(159) = &H6E6E6E6E
Td4(160) = &H47474747
Td4(161) = &HF1F1F1F1
Td4(162) = &H1A1A1A1A
Td4(163) = &H71717171
Td4(164) = &H1D1D1D1D
Td4(165) = &H29292929
Td4(166) = &HC5C5C5C5
Td4(167) = &H89898989
Td4(168) = &H6F6F6F6F
Td4(169) = &HB7B7B7B7
Td4(170) = &H62626262
Td4(171) = &HE0E0E0E
Td4(172) = &HAAAAAAAA
Td4(173) = &H18181818
Td4(174) = &HBEBEBEBE
Td4(175) = &H1B1B1B1B
Td4(176) = &HFCFCFCFC
Td4(177) = &H56565656
Td4(178) = &H3E3E3E3E
Td4(179) = &H4B4B4B4B
Td4(180) = &HC6C6C6C6
Td4(181) = &HD2D2D2D2
Td4(182) = &H79797979
Td4(183) = &H20202020
Td4(184) = &H9A9A9A9A
Td4(185) = &HDBDBDBDB
Td4(186) = &HC0C0C0C0
Td4(187) = &HFEFEFEFE
Td4(188) = &H78787878
Td4(189) = &HCDCDCDCD
Td4(190) = &H5A5A5A5A
Td4(191) = &HF4F4F4F4
Td4(192) = &H1F1F1F1F
Td4(193) = &HDDDDDDDD
Td4(194) = &HA8A8A8A8
Td4(195) = &H33333333
Td4(196) = &H88888888
Td4(197) = &H7070707
Td4(198) = &HC7C7C7C7
Td4(199) = &H31313131
Td4(200) = &HB1B1B1B1
Td4(201) = &H12121212
Td4(202) = &H10101010
Td4(203) = &H59595959
Td4(204) = &H27272727
Td4(205) = &H80808080
Td4(206) = &HECECECEC
Td4(207) = &H5F5F5F5F
Td4(208) = &H60606060
Td4(209) = &H51515151
Td4(210) = &H7F7F7F7F
Td4(211) = &HA9A9A9A9
Td4(212) = &H19191919
Td4(213) = &HB5B5B5B5
Td4(214) = &H4A4A4A4A
Td4(215) = &HD0D0D0D
Td4(216) = &H2D2D2D2D
Td4(217) = &HE5E5E5E5
Td4(218) = &H7A7A7A7A
Td4(219) = &H9F9F9F9F
Td4(220) = &H93939393
Td4(221) = &HC9C9C9C9
Td4(222) = &H9C9C9C9C
Td4(223) = &HEFEFEFEF
Td4(224) = &HA0A0A0A0
Td4(225) = &HE0E0E0E0
Td4(226) = &H3B3B3B3B
Td4(227) = &H4D4D4D4D
Td4(228) = &HAEAEAEAE
Td4(229) = &H2A2A2A2A
Td4(230) = &HF5F5F5F5
Td4(231) = &HB0B0B0B0
Td4(232) = &HC8C8C8C8
Td4(233) = &HEBEBEBEB
Td4(234) = &HBBBBBBBB
Td4(235) = &H3C3C3C3C
Td4(236) = &H83838383
Td4(237) = &H53535353
Td4(238) = &H99999999
Td4(239) = &H61616161
Td4(240) = &H17171717
Td4(241) = &H2B2B2B2B
Td4(242) = &H4040404
Td4(243) = &H7E7E7E7E
Td4(244) = &HBABABABA
Td4(245) = &H77777777
Td4(246) = &HD6D6D6D6
Td4(247) = &H26262626
Td4(248) = &HE1E1E1E1
Td4(249) = &H69696969
Td4(250) = &H14141414
Td4(251) = &H63636363
Td4(252) = &H55555555
Td4(253) = &H21212121
Td4(254) = &HC0C0C0C
Td4(255) = &H7D7D7D7D
Rcon(0) = &H1000000
Rcon(1) = &H2000000
Rcon(2) = &H4000000
Rcon(3) = &H8000000
Rcon(4) = &H10000000
Rcon(5) = &H20000000
Rcon(6) = &H40000000
Rcon(7) = &H80000000
Rcon(8) = &H1B000000
Rcon(9) = &H36000000
End Sub

' Original C Declares for above arrays.
'static const u32 Te0[256] = {
'    0xc66363a5U, 0xf87c7c84U, 0xee777799U, 0xf67b7b8dU,
'    0xfff2f20dU, 0xd66b6bbdU, 0xde6f6fb1U, 0x91c5c554U,
'    0x60303050U, 0x02010103U, 0xce6767a9U, 0x562b2b7dU,
'    0xe7fefe19U, 0xb5d7d762U, 0x4dababe6U, 0xec76769aU,
'    0x8fcaca45U, 0x1f82829dU, 0x89c9c940U, 0xfa7d7d87U,
'    0xeffafa15U, 0xb25959ebU, 0x8e4747c9U, 0xfbf0f00bU,
'    0x41adadecU, 0xb3d4d467U, 0x5fa2a2fdU, 0x45afafeaU,
'    0x239c9cbfU, 0x53a4a4f7U, 0xe4727296U, 0x9bc0c05bU,
'    0x75b7b7c2U, 0xe1fdfd1cU, 0x3d9393aeU, 0x4c26266aU,
'    0x6c36365aU, 0x7e3f3f41U, 0xf5f7f702U, 0x83cccc4fU,
'    0x6834345cU, 0x51a5a5f4U, 0xd1e5e534U, 0xf9f1f108U,
'    0xe2717193U, 0xabd8d873U, 0x62313153U, 0x2a15153fU,
'    0x0804040cU, 0x95c7c752U, 0x46232365U, 0x9dc3c35eU,
'    0x30181828U, 0x379696a1U, 0x0a05050fU, 0x2f9a9ab5U,
'    0x0e070709U, 0x24121236U, 0x1b80809bU, 0xdfe2e23dU,
'    0xcdebeb26U, 0x4e272769U, 0x7fb2b2cdU, 0xea75759fU,
'    0x1209091bU, 0x1d83839eU, 0x582c2c74U, 0x341a1a2eU,
'    0x361b1b2dU, 0xdc6e6eb2U, 0xb45a5aeeU, 0x5ba0a0fbU,
'    0xa45252f6U, 0x763b3b4dU, 0xb7d6d661U, 0x7db3b3ceU,
'    0x5229297bU, 0xdde3e33eU, 0x5e2f2f71U, 0x13848497U,
'    0xa65353f5U, 0xb9d1d168U, 0x00000000U, 0xc1eded2cU,
'    0x40202060U, 0xe3fcfc1fU, 0x79b1b1c8U, 0xb65b5bedU,
'    0xd46a6abeU, 0x8dcbcb46U, 0x67bebed9U, 0x7239394bU,
'    0x944a4adeU, 0x984c4cd4U, 0xb05858e8U, 0x85cfcf4aU,
'    0xbbd0d06bU, 0xc5efef2aU, 0x4faaaae5U, 0xedfbfb16U,
'    0x864343c5U, 0x9a4d4dd7U, 0x66333355U, 0x11858594U,
'    0x8a4545cfU, 0xe9f9f910U, 0x04020206U, 0xfe7f7f81U,
'    0xa05050f0U, 0x783c3c44U, 0x259f9fbaU, 0x4ba8a8e3U,
'    0xa25151f3U, 0x5da3a3feU, 0x804040c0U, 0x058f8f8aU,
'    0x3f9292adU, 0x219d9dbcU, 0x70383848U, 0xf1f5f504U,
'    0x63bcbcdfU, 0x77b6b6c1U, 0xafdada75U, 0x42212163U,
'    0x20101030U, 0xe5ffff1aU, 0xfdf3f30eU, 0xbfd2d26dU,
'    0x81cdcd4cU, 0x180c0c14U, 0x26131335U, 0xc3ecec2fU,
'    0xbe5f5fe1U, 0x359797a2U, 0x884444ccU, 0x2e171739U,
'    0x93c4c457U, 0x55a7a7f2U, 0xfc7e7e82U, 0x7a3d3d47U,
'    0xc86464acU, 0xba5d5de7U, 0x3219192bU, 0xe6737395U,
'    0xc06060a0U, 0x19818198U, 0x9e4f4fd1U, 0xa3dcdc7fU,
'    0x44222266U, 0x542a2a7eU, 0x3b9090abU, 0x0b888883U,
'    0x8c4646caU, 0xc7eeee29U, 0x6bb8b8d3U, 0x2814143cU,
'    0xa7dede79U, 0xbc5e5ee2U, 0x160b0b1dU, 0xaddbdb76U,
'    0xdbe0e03bU, 0x64323256U, 0x743a3a4eU, 0x140a0a1eU,
'    0x924949dbU, 0x0c06060aU, 0x4824246cU, 0xb85c5ce4U,
'    0x9fc2c25dU, 0xbdd3d36eU, 0x43acacefU, 0xc46262a6U,
'    0x399191a8U, 0x319595a4U, 0xd3e4e437U, 0xf279798bU,
'    0xd5e7e732U, 0x8bc8c843U, 0x6e373759U, 0xda6d6db7U,
'    0x018d8d8cU, 0xb1d5d564U, 0x9c4e4ed2U, 0x49a9a9e0U,
'    0xd86c6cb4U, 0xac5656faU, 0xf3f4f407U, 0xcfeaea25U,
'    0xca6565afU, 0xf47a7a8eU, 0x47aeaee9U, 0x10080818U,
'    0x6fbabad5U, 0xf0787888U, 0x4a25256fU, 0x5c2e2e72U,
'    0x381c1c24U, 0x57a6a6f1U, 0x73b4b4c7U, 0x97c6c651U,
'    0xcbe8e823U, 0xa1dddd7cU, 0xe874749cU, 0x3e1f1f21U,
'    0x964b4bddU, 0x61bdbddcU, 0x0d8b8b86U, 0x0f8a8a85U,
'    0xe0707090U, 0x7c3e3e42U, 0x71b5b5c4U, 0xcc6666aaU,
'    0x904848d8U, 0x06030305U, 0xf7f6f601U, 0x1c0e0e12U,
'    0xc26161a3U, 0x6a35355fU, 0xae5757f9U, 0x69b9b9d0U,
'    0x17868691U, 0x99c1c158U, 0x3a1d1d27U, 0x279e9eb9U,
'    0xd9e1e138U, 0xebf8f813U, 0x2b9898b3U, 0x22111133U,
'    0xd26969bbU, 0xa9d9d970U, 0x078e8e89U, 0x339494a7U,
'    0x2d9b9bb6U, 0x3c1e1e22U, 0x15878792U, 0xc9e9e920U,
'    0x87cece49U, 0xaa5555ffU, 0x50282878U, 0xa5dfdf7aU,
'    0x038c8c8fU, 0x59a1a1f8U, 0x09898980U, 0x1a0d0d17U,
'    0x65bfbfdaU, 0xd7e6e631U, 0x844242c6U, 0xd06868b8U,
'    0x824141c3U, 0x299999b0U, 0x5a2d2d77U, 0x1e0f0f11U,
'    0x7bb0b0cbU, 0xa85454fcU, 0x6dbbbbd6U, 0x2c16163aU,
'};
'static const u32 Te1[256] = {
'    0xa5c66363U, 0x84f87c7cU, 0x99ee7777U, 0x8df67b7bU,
'    0x0dfff2f2U, 0xbdd66b6bU, 0xb1de6f6fU, 0x5491c5c5U,
'    0x50603030U, 0x03020101U, 0xa9ce6767U, 0x7d562b2bU,
'    0x19e7fefeU, 0x62b5d7d7U, 0xe64dababU, 0x9aec7676U,
'    0x458fcacaU, 0x9d1f8282U, 0x4089c9c9U, 0x87fa7d7dU,
'    0x15effafaU, 0xebb25959U, 0xc98e4747U, 0x0bfbf0f0U,
'    0xec41adadU, 0x67b3d4d4U, 0xfd5fa2a2U, 0xea45afafU,
'    0xbf239c9cU, 0xf753a4a4U, 0x96e47272U, 0x5b9bc0c0U,
'    0xc275b7b7U, 0x1ce1fdfdU, 0xae3d9393U, 0x6a4c2626U,
'    0x5a6c3636U, 0x417e3f3fU, 0x02f5f7f7U, 0x4f83ccccU,
'    0x5c683434U, 0xf451a5a5U, 0x34d1e5e5U, 0x08f9f1f1U,
'    0x93e27171U, 0x73abd8d8U, 0x53623131U, 0x3f2a1515U,
'    0x0c080404U, 0x5295c7c7U, 0x65462323U, 0x5e9dc3c3U,
'    0x28301818U, 0xa1379696U, 0x0f0a0505U, 0xb52f9a9aU,
'    0x090e0707U, 0x36241212U, 0x9b1b8080U, 0x3ddfe2e2U,
'    0x26cdebebU, 0x694e2727U, 0xcd7fb2b2U, 0x9fea7575U,
'    0x1b120909U, 0x9e1d8383U, 0x74582c2cU, 0x2e341a1aU,
'    0x2d361b1bU, 0xb2dc6e6eU, 0xeeb45a5aU, 0xfb5ba0a0U,
'    0xf6a45252U, 0x4d763b3bU, 0x61b7d6d6U, 0xce7db3b3U,
'    0x7b522929U, 0x3edde3e3U, 0x715e2f2fU, 0x97138484U,
'    0xf5a65353U, 0x68b9d1d1U, 0x00000000U, 0x2cc1ededU,
'    0x60402020U, 0x1fe3fcfcU, 0xc879b1b1U, 0xedb65b5bU,
'    0xbed46a6aU, 0x468dcbcbU, 0xd967bebeU, 0x4b723939U,
'    0xde944a4aU, 0xd4984c4cU, 0xe8b05858U, 0x4a85cfcfU,
'    0x6bbbd0d0U, 0x2ac5efefU, 0xe54faaaaU, 0x16edfbfbU,
'    0xc5864343U, 0xd79a4d4dU, 0x55663333U, 0x94118585U,
'    0xcf8a4545U, 0x10e9f9f9U, 0x06040202U, 0x81fe7f7fU,
'    0xf0a05050U, 0x44783c3cU, 0xba259f9fU, 0xe34ba8a8U,
'    0xf3a25151U, 0xfe5da3a3U, 0xc0804040U, 0x8a058f8fU,
'    0xad3f9292U, 0xbc219d9dU, 0x48703838U, 0x04f1f5f5U,
'    0xdf63bcbcU, 0xc177b6b6U, 0x75afdadaU, 0x63422121U,
'    0x30201010U, 0x1ae5ffffU, 0x0efdf3f3U, 0x6dbfd2d2U,
'    0x4c81cdcdU, 0x14180c0cU, 0x35261313U, 0x2fc3ececU,
'    0xe1be5f5fU, 0xa2359797U, 0xcc884444U, 0x392e1717U,
'    0x5793c4c4U, 0xf255a7a7U, 0x82fc7e7eU, 0x477a3d3dU,
'    0xacc86464U, 0xe7ba5d5dU, 0x2b321919U, 0x95e67373U,
'    0xa0c06060U, 0x98198181U, 0xd19e4f4fU, 0x7fa3dcdcU,
'    0x66442222U, 0x7e542a2aU, 0xab3b9090U, 0x830b8888U,
'    0xca8c4646U, 0x29c7eeeeU, 0xd36bb8b8U, 0x3c281414U,
'    0x79a7dedeU, 0xe2bc5e5eU, 0x1d160b0bU, 0x76addbdbU,
'    0x3bdbe0e0U, 0x56643232U, 0x4e743a3aU, 0x1e140a0aU,
'    0xdb924949U, 0x0a0c0606U, 0x6c482424U, 0xe4b85c5cU,
'    0x5d9fc2c2U, 0x6ebdd3d3U, 0xef43acacU, 0xa6c46262U,
'    0xa8399191U, 0xa4319595U, 0x37d3e4e4U, 0x8bf27979U,
'    0x32d5e7e7U, 0x438bc8c8U, 0x596e3737U, 0xb7da6d6dU,
'    0x8c018d8dU, 0x64b1d5d5U, 0xd29c4e4eU, 0xe049a9a9U,
'    0xb4d86c6cU, 0xfaac5656U, 0x07f3f4f4U, 0x25cfeaeaU,
'    0xafca6565U, 0x8ef47a7aU, 0xe947aeaeU, 0x18100808U,
'    0xd56fbabaU, 0x88f07878U, 0x6f4a2525U, 0x725c2e2eU,
'    0x24381c1cU, 0xf157a6a6U, 0xc773b4b4U, 0x5197c6c6U,
'    0x23cbe8e8U, 0x7ca1ddddU, 0x9ce87474U, 0x213e1f1fU,
'    0xdd964b4bU, 0xdc61bdbdU, 0x860d8b8bU, 0x850f8a8aU,
'    0x90e07070U, 0x427c3e3eU, 0xc471b5b5U, 0xaacc6666U,
'    0xd8904848U, 0x05060303U, 0x01f7f6f6U, 0x121c0e0eU,
'    0xa3c26161U, 0x5f6a3535U, 0xf9ae5757U, 0xd069b9b9U,
'    0x91178686U, 0x5899c1c1U, 0x273a1d1dU, 0xb9279e9eU,
'    0x38d9e1e1U, 0x13ebf8f8U, 0xb32b9898U, 0x33221111U,
'    0xbbd26969U, 0x70a9d9d9U, 0x89078e8eU, 0xa7339494U,
'    0xb62d9b9bU, 0x223c1e1eU, 0x92158787U, 0x20c9e9e9U,
'    0x4987ceceU, 0xffaa5555U, 0x78502828U, 0x7aa5dfdfU,
'    0x8f038c8cU, 0xf859a1a1U, 0x80098989U, 0x171a0d0dU,
'    0xda65bfbfU, 0x31d7e6e6U, 0xc6844242U, 0xb8d06868U,
'    0xc3824141U, 0xb0299999U, 0x775a2d2dU, 0x111e0f0fU,
'    0xcb7bb0b0U, 0xfca85454U, 0xd66dbbbbU, 0x3a2c1616U,
'};
'static const u32 Te2[256] = {
'    0x63a5c663U, 0x7c84f87cU, 0x7799ee77U, 0x7b8df67bU,
'    0xf20dfff2U, 0x6bbdd66bU, 0x6fb1de6fU, 0xc55491c5U,
'    0x30506030U, 0x01030201U, 0x67a9ce67U, 0x2b7d562bU,
'    0xfe19e7feU, 0xd762b5d7U, 0xabe64dabU, 0x769aec76U,
'    0xca458fcaU, 0x829d1f82U, 0xc94089c9U, 0x7d87fa7dU,
'    0xfa15effaU, 0x59ebb259U, 0x47c98e47U, 0xf00bfbf0U,
'    0xadec41adU, 0xd467b3d4U, 0xa2fd5fa2U, 0xafea45afU,
'    0x9cbf239cU, 0xa4f753a4U, 0x7296e472U, 0xc05b9bc0U,
'    0xb7c275b7U, 0xfd1ce1fdU, 0x93ae3d93U, 0x266a4c26U,
'    0x365a6c36U, 0x3f417e3fU, 0xf702f5f7U, 0xcc4f83ccU,
'    0x345c6834U, 0xa5f451a5U, 0xe534d1e5U, 0xf108f9f1U,
'    0x7193e271U, 0xd873abd8U, 0x31536231U, 0x153f2a15U,
'    0x040c0804U, 0xc75295c7U, 0x23654623U, 0xc35e9dc3U,
'    0x18283018U, 0x96a13796U, 0x050f0a05U, 0x9ab52f9aU,
'    0x07090e07U, 0x12362412U, 0x809b1b80U, 0xe23ddfe2U,
'    0xeb26cdebU, 0x27694e27U, 0xb2cd7fb2U, 0x759fea75U,
'    0x091b1209U, 0x839e1d83U, 0x2c74582cU, 0x1a2e341aU,
'    0x1b2d361bU, 0x6eb2dc6eU, 0x5aeeb45aU, 0xa0fb5ba0U,
'    0x52f6a452U, 0x3b4d763bU, 0xd661b7d6U, 0xb3ce7db3U,
'    0x297b5229U, 0xe33edde3U, 0x2f715e2fU, 0x84971384U,
'    0x53f5a653U, 0xd168b9d1U, 0x00000000U, 0xed2cc1edU,
'    0x20604020U, 0xfc1fe3fcU, 0xb1c879b1U, 0x5bedb65bU,
'    0x6abed46aU, 0xcb468dcbU, 0xbed967beU, 0x394b7239U,
'    0x4ade944aU, 0x4cd4984cU, 0x58e8b058U, 0xcf4a85cfU,
'    0xd06bbbd0U, 0xef2ac5efU, 0xaae54faaU, 0xfb16edfbU,
'    0x43c58643U, 0x4dd79a4dU, 0x33556633U, 0x85941185U,
'    0x45cf8a45U, 0xf910e9f9U, 0x02060402U, 0x7f81fe7fU,
'    0x50f0a050U, 0x3c44783cU, 0x9fba259fU, 0xa8e34ba8U,
'    0x51f3a251U, 0xa3fe5da3U, 0x40c08040U, 0x8f8a058fU,
'    0x92ad3f92U, 0x9dbc219dU, 0x38487038U, 0xf504f1f5U,
'    0xbcdf63bcU, 0xb6c177b6U, 0xda75afdaU, 0x21634221U,
'    0x10302010U, 0xff1ae5ffU, 0xf30efdf3U, 0xd26dbfd2U,
'    0xcd4c81cdU, 0x0c14180cU, 0x13352613U, 0xec2fc3ecU,
'    0x5fe1be5fU, 0x97a23597U, 0x44cc8844U, 0x17392e17U,
'    0xc45793c4U, 0xa7f255a7U, 0x7e82fc7eU, 0x3d477a3dU,
'    0x64acc864U, 0x5de7ba5dU, 0x192b3219U, 0x7395e673U,
'    0x60a0c060U, 0x81981981U, 0x4fd19e4fU, 0xdc7fa3dcU,
'    0x22664422U, 0x2a7e542aU, 0x90ab3b90U, 0x88830b88U,
'    0x46ca8c46U, 0xee29c7eeU, 0xb8d36bb8U, 0x143c2814U,
'    0xde79a7deU, 0x5ee2bc5eU, 0x0b1d160bU, 0xdb76addbU,
'    0xe03bdbe0U, 0x32566432U, 0x3a4e743aU, 0x0a1e140aU,
'    0x49db9249U, 0x060a0c06U, 0x246c4824U, 0x5ce4b85cU,
'    0xc25d9fc2U, 0xd36ebdd3U, 0xacef43acU, 0x62a6c462U,
'    0x91a83991U, 0x95a43195U, 0xe437d3e4U, 0x798bf279U,
'    0xe732d5e7U, 0xc8438bc8U, 0x37596e37U, 0x6db7da6dU,
'    0x8d8c018dU, 0xd564b1d5U, 0x4ed29c4eU, 0xa9e049a9U,
'    0x6cb4d86cU, 0x56faac56U, 0xf407f3f4U, 0xea25cfeaU,
'    0x65afca65U, 0x7a8ef47aU, 0xaee947aeU, 0x08181008U,
'    0xbad56fbaU, 0x7888f078U, 0x256f4a25U, 0x2e725c2eU,
'    0x1c24381cU, 0xa6f157a6U, 0xb4c773b4U, 0xc65197c6U,
'    0xe823cbe8U, 0xdd7ca1ddU, 0x749ce874U, 0x1f213e1fU,
'    0x4bdd964bU, 0xbddc61bdU, 0x8b860d8bU, 0x8a850f8aU,
'    0x7090e070U, 0x3e427c3eU, 0xb5c471b5U, 0x66aacc66U,
'    0x48d89048U, 0x03050603U, 0xf601f7f6U, 0x0e121c0eU,
'    0x61a3c261U, 0x355f6a35U, 0x57f9ae57U, 0xb9d069b9U,
'    0x86911786U, 0xc15899c1U, 0x1d273a1dU, 0x9eb9279eU,
'    0xe138d9e1U, 0xf813ebf8U, 0x98b32b98U, 0x11332211U,
'    0x69bbd269U, 0xd970a9d9U, 0x8e89078eU, 0x94a73394U,
'    0x9bb62d9bU, 0x1e223c1eU, 0x87921587U, 0xe920c9e9U,
'    0xce4987ceU, 0x55ffaa55U, 0x28785028U, 0xdf7aa5dfU,
'    0x8c8f038cU, 0xa1f859a1U, 0x89800989U, 0x0d171a0dU,
'    0xbfda65bfU, 0xe631d7e6U, 0x42c68442U, 0x68b8d068U,
'    0x41c38241U, 0x99b02999U, 0x2d775a2dU, 0x0f111e0fU,
'    0xb0cb7bb0U, 0x54fca854U, 0xbbd66dbbU, 0x163a2c16U,
'};
'static const u32 Te3[256] = {
'
'    0x6363a5c6U, 0x7c7c84f8U, 0x777799eeU, 0x7b7b8df6U,
'    0xf2f20dffU, 0x6b6bbdd6U, 0x6f6fb1deU, 0xc5c55491U,
'    0x30305060U, 0x01010302U, 0x6767a9ceU, 0x2b2b7d56U,
'    0xfefe19e7U, 0xd7d762b5U, 0xababe64dU, 0x76769aecU,
'    0xcaca458fU, 0x82829d1fU, 0xc9c94089U, 0x7d7d87faU,
'    0xfafa15efU, 0x5959ebb2U, 0x4747c98eU, 0xf0f00bfbU,
'    0xadadec41U, 0xd4d467b3U, 0xa2a2fd5fU, 0xafafea45U,
'    0x9c9cbf23U, 0xa4a4f753U, 0x727296e4U, 0xc0c05b9bU,
'    0xb7b7c275U, 0xfdfd1ce1U, 0x9393ae3dU, 0x26266a4cU,
'    0x36365a6cU, 0x3f3f417eU, 0xf7f702f5U, 0xcccc4f83U,
'    0x34345c68U, 0xa5a5f451U, 0xe5e534d1U, 0xf1f108f9U,
'    0x717193e2U, 0xd8d873abU, 0x31315362U, 0x15153f2aU,
'    0x04040c08U, 0xc7c75295U, 0x23236546U, 0xc3c35e9dU,
'    0x18182830U, 0x9696a137U, 0x05050f0aU, 0x9a9ab52fU,
'    0x0707090eU, 0x12123624U, 0x80809b1bU, 0xe2e23ddfU,
'    0xebeb26cdU, 0x2727694eU, 0xb2b2cd7fU, 0x75759feaU,
'    0x09091b12U, 0x83839e1dU, 0x2c2c7458U, 0x1a1a2e34U,
'    0x1b1b2d36U, 0x6e6eb2dcU, 0x5a5aeeb4U, 0xa0a0fb5bU,
'    0x5252f6a4U, 0x3b3b4d76U, 0xd6d661b7U, 0xb3b3ce7dU,
'    0x29297b52U, 0xe3e33eddU, 0x2f2f715eU, 0x84849713U,
'    0x5353f5a6U, 0xd1d168b9U, 0x00000000U, 0xeded2cc1U,
'    0x20206040U, 0xfcfc1fe3U, 0xb1b1c879U, 0x5b5bedb6U,
'    0x6a6abed4U, 0xcbcb468dU, 0xbebed967U, 0x39394b72U,
'    0x4a4ade94U, 0x4c4cd498U, 0x5858e8b0U, 0xcfcf4a85U,
'    0xd0d06bbbU, 0xefef2ac5U, 0xaaaae54fU, 0xfbfb16edU,
'    0x4343c586U, 0x4d4dd79aU, 0x33335566U, 0x85859411U,
'    0x4545cf8aU, 0xf9f910e9U, 0x02020604U, 0x7f7f81feU,
'    0x5050f0a0U, 0x3c3c4478U, 0x9f9fba25U, 0xa8a8e34bU,
'    0x5151f3a2U, 0xa3a3fe5dU, 0x4040c080U, 0x8f8f8a05U,
'    0x9292ad3fU, 0x9d9dbc21U, 0x38384870U, 0xf5f504f1U,
'    0xbcbcdf63U, 0xb6b6c177U, 0xdada75afU, 0x21216342U,
'    0x10103020U, 0xffff1ae5U, 0xf3f30efdU, 0xd2d26dbfU,
'    0xcdcd4c81U, 0x0c0c1418U, 0x13133526U, 0xecec2fc3U,
'    0x5f5fe1beU, 0x9797a235U, 0x4444cc88U, 0x1717392eU,
'    0xc4c45793U, 0xa7a7f255U, 0x7e7e82fcU, 0x3d3d477aU,
'    0x6464acc8U, 0x5d5de7baU, 0x19192b32U, 0x737395e6U,
'    0x6060a0c0U, 0x81819819U, 0x4f4fd19eU, 0xdcdc7fa3U,
'    0x22226644U, 0x2a2a7e54U, 0x9090ab3bU, 0x8888830bU,
'    0x4646ca8cU, 0xeeee29c7U, 0xb8b8d36bU, 0x14143c28U,
'    0xdede79a7U, 0x5e5ee2bcU, 0x0b0b1d16U, 0xdbdb76adU,
'    0xe0e03bdbU, 0x32325664U, 0x3a3a4e74U, 0x0a0a1e14U,
'    0x4949db92U, 0x06060a0cU, 0x24246c48U, 0x5c5ce4b8U,
'    0xc2c25d9fU, 0xd3d36ebdU, 0xacacef43U, 0x6262a6c4U,
'    0x9191a839U, 0x9595a431U, 0xe4e437d3U, 0x79798bf2U,
'    0xe7e732d5U, 0xc8c8438bU, 0x3737596eU, 0x6d6db7daU,
'    0x8d8d8c01U, 0xd5d564b1U, 0x4e4ed29cU, 0xa9a9e049U,
'    0x6c6cb4d8U, 0x5656faacU, 0xf4f407f3U, 0xeaea25cfU,
'    0x6565afcaU, 0x7a7a8ef4U, 0xaeaee947U, 0x08081810U,
'    0xbabad56fU, 0x787888f0U, 0x25256f4aU, 0x2e2e725cU,
'    0x1c1c2438U, 0xa6a6f157U, 0xb4b4c773U, 0xc6c65197U,
'    0xe8e823cbU, 0xdddd7ca1U, 0x74749ce8U, 0x1f1f213eU,
'    0x4b4bdd96U, 0xbdbddc61U, 0x8b8b860dU, 0x8a8a850fU,
'    0x707090e0U, 0x3e3e427cU, 0xb5b5c471U, 0x6666aaccU,
'    0x4848d890U, 0x03030506U, 0xf6f601f7U, 0x0e0e121cU,
'    0x6161a3c2U, 0x35355f6aU, 0x5757f9aeU, 0xb9b9d069U,
'    0x86869117U, 0xc1c15899U, 0x1d1d273aU, 0x9e9eb927U,
'    0xe1e138d9U, 0xf8f813ebU, 0x9898b32bU, 0x11113322U,
'    0x6969bbd2U, 0xd9d970a9U, 0x8e8e8907U, 0x9494a733U,
'    0x9b9bb62dU, 0x1e1e223cU, 0x87879215U, 0xe9e920c9U,
'    0xcece4987U, 0x5555ffaaU, 0x28287850U, 0xdfdf7aa5U,
'    0x8c8c8f03U, 0xa1a1f859U, 0x89898009U, 0x0d0d171aU,
'    0xbfbfda65U, 0xe6e631d7U, 0x4242c684U, 0x6868b8d0U,
'    0x4141c382U, 0x9999b029U, 0x2d2d775aU, 0x0f0f111eU,
'    0xb0b0cb7bU, 0x5454fca8U, 0xbbbbd66dU, 0x16163a2cU,
'};
'static const u32 Te4[256] = {
'    0x63636363U, 0x7c7c7c7cU, 0x77777777U, 0x7b7b7b7bU,
'    0xf2f2f2f2U, 0x6b6b6b6bU, 0x6f6f6f6fU, 0xc5c5c5c5U,
'    0x30303030U, 0x01010101U, 0x67676767U, 0x2b2b2b2bU,
'    0xfefefefeU, 0xd7d7d7d7U, 0xababababU, 0x76767676U,
'    0xcacacacaU, 0x82828282U, 0xc9c9c9c9U, 0x7d7d7d7dU,
'    0xfafafafaU, 0x59595959U, 0x47474747U, 0xf0f0f0f0U,
'    0xadadadadU, 0xd4d4d4d4U, 0xa2a2a2a2U, 0xafafafafU,
'    0x9c9c9c9cU, 0xa4a4a4a4U, 0x72727272U, 0xc0c0c0c0U,
'    0xb7b7b7b7U, 0xfdfdfdfdU, 0x93939393U, 0x26262626U,
'    0x36363636U, 0x3f3f3f3fU, 0xf7f7f7f7U, 0xccccccccU,
'    0x34343434U, 0xa5a5a5a5U, 0xe5e5e5e5U, 0xf1f1f1f1U,
'    0x71717171U, 0xd8d8d8d8U, 0x31313131U, 0x15151515U,
'    0x04040404U, 0xc7c7c7c7U, 0x23232323U, 0xc3c3c3c3U,
'    0x18181818U, 0x96969696U, 0x05050505U, 0x9a9a9a9aU,
'    0x07070707U, 0x12121212U, 0x80808080U, 0xe2e2e2e2U,
'    0xebebebebU, 0x27272727U, 0xb2b2b2b2U, 0x75757575U,
'    0x09090909U, 0x83838383U, 0x2c2c2c2cU, 0x1a1a1a1aU,
'    0x1b1b1b1bU, 0x6e6e6e6eU, 0x5a5a5a5aU, 0xa0a0a0a0U,
'    0x52525252U, 0x3b3b3b3bU, 0xd6d6d6d6U, 0xb3b3b3b3U,
'    0x29292929U, 0xe3e3e3e3U, 0x2f2f2f2fU, 0x84848484U,
'    0x53535353U, 0xd1d1d1d1U, 0x00000000U, 0xededededU,
'    0x20202020U, 0xfcfcfcfcU, 0xb1b1b1b1U, 0x5b5b5b5bU,
'    0x6a6a6a6aU, 0xcbcbcbcbU, 0xbebebebeU, 0x39393939U,
'    0x4a4a4a4aU, 0x4c4c4c4cU, 0x58585858U, 0xcfcfcfcfU,
'    0xd0d0d0d0U, 0xefefefefU, 0xaaaaaaaaU, 0xfbfbfbfbU,
'    0x43434343U, 0x4d4d4d4dU, 0x33333333U, 0x85858585U,
'    0x45454545U, 0xf9f9f9f9U, 0x02020202U, 0x7f7f7f7fU,
'    0x50505050U, 0x3c3c3c3cU, 0x9f9f9f9fU, 0xa8a8a8a8U,
'    0x51515151U, 0xa3a3a3a3U, 0x40404040U, 0x8f8f8f8fU,
'    0x92929292U, 0x9d9d9d9dU, 0x38383838U, 0xf5f5f5f5U,
'    0xbcbcbcbcU, 0xb6b6b6b6U, 0xdadadadaU, 0x21212121U,
'    0x10101010U, 0xffffffffU, 0xf3f3f3f3U, 0xd2d2d2d2U,
'    0xcdcdcdcdU, 0x0c0c0c0cU, 0x13131313U, 0xececececU,
'    0x5f5f5f5fU, 0x97979797U, 0x44444444U, 0x17171717U,
'    0xc4c4c4c4U, 0xa7a7a7a7U, 0x7e7e7e7eU, 0x3d3d3d3dU,
'    0x64646464U, 0x5d5d5d5dU, 0x19191919U, 0x73737373U,
'    0x60606060U, 0x81818181U, 0x4f4f4f4fU, 0xdcdcdcdcU,
'    0x22222222U, 0x2a2a2a2aU, 0x90909090U, 0x88888888U,
'    0x46464646U, 0xeeeeeeeeU, 0xb8b8b8b8U, 0x14141414U,
'    0xdedededeU, 0x5e5e5e5eU, 0x0b0b0b0bU, 0xdbdbdbdbU,
'    0xe0e0e0e0U, 0x32323232U, 0x3a3a3a3aU, 0x0a0a0a0aU,
'    0x49494949U, 0x06060606U, 0x24242424U, 0x5c5c5c5cU,
'    0xc2c2c2c2U, 0xd3d3d3d3U, 0xacacacacU, 0x62626262U,
'    0x91919191U, 0x95959595U, 0xe4e4e4e4U, 0x79797979U,
'    0xe7e7e7e7U, 0xc8c8c8c8U, 0x37373737U, 0x6d6d6d6dU,
'    0x8d8d8d8dU, 0xd5d5d5d5U, 0x4e4e4e4eU, 0xa9a9a9a9U,
'    0x6c6c6c6cU, 0x56565656U, 0xf4f4f4f4U, 0xeaeaeaeaU,
'    0x65656565U, 0x7a7a7a7aU, 0xaeaeaeaeU, 0x08080808U,
'    0xbabababaU, 0x78787878U, 0x25252525U, 0x2e2e2e2eU,
'    0x1c1c1c1cU, 0xa6a6a6a6U, 0xb4b4b4b4U, 0xc6c6c6c6U,
'    0xe8e8e8e8U, 0xddddddddU, 0x74747474U, 0x1f1f1f1fU,
'    0x4b4b4b4bU, 0xbdbdbdbdU, 0x8b8b8b8bU, 0x8a8a8a8aU,
'    0x70707070U, 0x3e3e3e3eU, 0xb5b5b5b5U, 0x66666666U,
'    0x48484848U, 0x03030303U, 0xf6f6f6f6U, 0x0e0e0e0eU,
'    0x61616161U, 0x35353535U, 0x57575757U, 0xb9b9b9b9U,
'    0x86868686U, 0xc1c1c1c1U, 0x1d1d1d1dU, 0x9e9e9e9eU,
'    0xe1e1e1e1U, 0xf8f8f8f8U, 0x98989898U, 0x11111111U,
'    0x69696969U, 0xd9d9d9d9U, 0x8e8e8e8eU, 0x94949494U,
'    0x9b9b9b9bU, 0x1e1e1e1eU, 0x87878787U, 0xe9e9e9e9U,
'    0xcecececeU, 0x55555555U, 0x28282828U, 0xdfdfdfdfU,
'    0x8c8c8c8cU, 0xa1a1a1a1U, 0x89898989U, 0x0d0d0d0dU,
'    0xbfbfbfbfU, 0xe6e6e6e6U, 0x42424242U, 0x68686868U,
'    0x41414141U, 0x99999999U, 0x2d2d2d2dU, 0x0f0f0f0fU,
'    0xb0b0b0b0U, 0x54545454U, 0xbbbbbbbbU, 0x16161616U,
'};
'static const u32 Td0[256] = {
'    0x51f4a750U, 0x7e416553U, 0x1a17a4c3U, 0x3a275e96U,
'    0x3bab6bcbU, 0x1f9d45f1U, 0xacfa58abU, 0x4be30393U,
'    0x2030fa55U, 0xad766df6U, 0x88cc7691U, 0xf5024c25U,
'    0x4fe5d7fcU, 0xc52acbd7U, 0x26354480U, 0xb562a38fU,
'    0xdeb15a49U, 0x25ba1b67U, 0x45ea0e98U, 0x5dfec0e1U,
'    0xc32f7502U, 0x814cf012U, 0x8d4697a3U, 0x6bd3f9c6U,
'    0x038f5fe7U, 0x15929c95U, 0xbf6d7aebU, 0x955259daU,
'    0xd4be832dU, 0x587421d3U, 0x49e06929U, 0x8ec9c844U,
'    0x75c2896aU, 0xf48e7978U, 0x99583e6bU, 0x27b971ddU,
'    0xbee14fb6U, 0xf088ad17U, 0xc920ac66U, 0x7dce3ab4U,
'    0x63df4a18U, 0xe51a3182U, 0x97513360U, 0x62537f45U,
'    0xb16477e0U, 0xbb6bae84U, 0xfe81a01cU, 0xf9082b94U,
'    0x70486858U, 0x8f45fd19U, 0x94de6c87U, 0x527bf8b7U,
'    0xab73d323U, 0x724b02e2U, 0xe31f8f57U, 0x6655ab2aU,
'    0xb2eb2807U, 0x2fb5c203U, 0x86c57b9aU, 0xd33708a5U,
'    0x302887f2U, 0x23bfa5b2U, 0x02036abaU, 0xed16825cU,
'    0x8acf1c2bU, 0xa779b492U, 0xf307f2f0U, 0x4e69e2a1U,
'    0x65daf4cdU, 0x0605bed5U, 0xd134621fU, 0xc4a6fe8aU,
'    0x342e539dU, 0xa2f355a0U, 0x058ae132U, 0xa4f6eb75U,
'    0x0b83ec39U, 0x4060efaaU, 0x5e719f06U, 0xbd6e1051U,
'    0x3e218af9U, 0x96dd063dU, 0xdd3e05aeU, 0x4de6bd46U,
'    0x91548db5U, 0x71c45d05U, 0x0406d46fU, 0x605015ffU,
'    0x1998fb24U, 0xd6bde997U, 0x894043ccU, 0x67d99e77U,
'    0xb0e842bdU, 0x07898b88U, 0xe7195b38U, 0x79c8eedbU,
'    0xa17c0a47U, 0x7c420fe9U, 0xf8841ec9U, 0x00000000U,
'    0x09808683U, 0x322bed48U, 0x1e1170acU, 0x6c5a724eU,
'    0xfd0efffbU, 0x0f853856U, 0x3daed51eU, 0x362d3927U,
'    0x0a0fd964U, 0x685ca621U, 0x9b5b54d1U, 0x24362e3aU,
'    0x0c0a67b1U, 0x9357e70fU, 0xb4ee96d2U, 0x1b9b919eU,
'    0x80c0c54fU, 0x61dc20a2U, 0x5a774b69U, 0x1c121a16U,
'    0xe293ba0aU, 0xc0a02ae5U, 0x3c22e043U, 0x121b171dU,
'    0x0e090d0bU, 0xf28bc7adU, 0x2db6a8b9U, 0x141ea9c8U,
'    0x57f11985U, 0xaf75074cU, 0xee99ddbbU, 0xa37f60fdU,
'    0xf701269fU, 0x5c72f5bcU, 0x44663bc5U, 0x5bfb7e34U,
'    0x8b432976U, 0xcb23c6dcU, 0xb6edfc68U, 0xb8e4f163U,
'    0xd731dccaU, 0x42638510U, 0x13972240U, 0x84c61120U,
'    0x854a247dU, 0xd2bb3df8U, 0xaef93211U, 0xc729a16dU,
'    0x1d9e2f4bU, 0xdcb230f3U, 0x0d8652ecU, 0x77c1e3d0U,
'    0x2bb3166cU, 0xa970b999U, 0x119448faU, 0x47e96422U,
'    0xa8fc8cc4U, 0xa0f03f1aU, 0x567d2cd8U, 0x223390efU,
'    0x87494ec7U, 0xd938d1c1U, 0x8ccaa2feU, 0x98d40b36U,
'    0xa6f581cfU, 0xa57ade28U, 0xdab78e26U, 0x3fadbfa4U,
'    0x2c3a9de4U, 0x5078920dU, 0x6a5fcc9bU, 0x547e4662U,
'    0xf68d13c2U, 0x90d8b8e8U, 0x2e39f75eU, 0x82c3aff5U,
'    0x9f5d80beU, 0x69d0937cU, 0x6fd52da9U, 0xcf2512b3U,
'    0xc8ac993bU, 0x10187da7U, 0xe89c636eU, 0xdb3bbb7bU,
'    0xcd267809U, 0x6e5918f4U, 0xec9ab701U, 0x834f9aa8U,
'    0xe6956e65U, 0xaaffe67eU, 0x21bccf08U, 0xef15e8e6U,
'    0xbae79bd9U, 0x4a6f36ceU, 0xea9f09d4U, 0x29b07cd6U,
'    0x31a4b2afU, 0x2a3f2331U, 0xc6a59430U, 0x35a266c0U,
'    0x744ebc37U, 0xfc82caa6U, 0xe090d0b0U, 0x33a7d815U,
'    0xf104984aU, 0x41ecdaf7U, 0x7fcd500eU, 0x1791f62fU,
'    0x764dd68dU, 0x43efb04dU, 0xccaa4d54U, 0xe49604dfU,
'    0x9ed1b5e3U, 0x4c6a881bU, 0xc12c1fb8U, 0x4665517fU,
'    0x9d5eea04U, 0x018c355dU, 0xfa877473U, 0xfb0b412eU,
'    0xb3671d5aU, 0x92dbd252U, 0xe9105633U, 0x6dd64713U,
'    0x9ad7618cU, 0x37a10c7aU, 0x59f8148eU, 0xeb133c89U,
'    0xcea927eeU, 0xb761c935U, 0xe11ce5edU, 0x7a47b13cU,
'    0x9cd2df59U, 0x55f2733fU, 0x1814ce79U, 0x73c737bfU,
'    0x53f7cdeaU, 0x5ffdaa5bU, 0xdf3d6f14U, 0x7844db86U,
'    0xcaaff381U, 0xb968c43eU, 0x3824342cU, 0xc2a3405fU,
'    0x161dc372U, 0xbce2250cU, 0x283c498bU, 0xff0d9541U,
'    0x39a80171U, 0x080cb3deU, 0xd8b4e49cU, 0x6456c190U,
'    0x7bcb8461U, 0xd532b670U, 0x486c5c74U, 0xd0b85742U,
'};
'static const u32 Td1[256] = {
'    0x5051f4a7U, 0x537e4165U, 0xc31a17a4U, 0x963a275eU,
'    0xcb3bab6bU, 0xf11f9d45U, 0xabacfa58U, 0x934be303U,
'    0x552030faU, 0xf6ad766dU, 0x9188cc76U, 0x25f5024cU,
'    0xfc4fe5d7U, 0xd7c52acbU, 0x80263544U, 0x8fb562a3U,
'    0x49deb15aU, 0x6725ba1bU, 0x9845ea0eU, 0xe15dfec0U,
'    0x02c32f75U, 0x12814cf0U, 0xa38d4697U, 0xc66bd3f9U,
'    0xe7038f5fU, 0x9515929cU, 0xebbf6d7aU, 0xda955259U,
'    0x2dd4be83U, 0xd3587421U, 0x2949e069U, 0x448ec9c8U,
'    0x6a75c289U, 0x78f48e79U, 0x6b99583eU, 0xdd27b971U,
'    0xb6bee14fU, 0x17f088adU, 0x66c920acU, 0xb47dce3aU,
'    0x1863df4aU, 0x82e51a31U, 0x60975133U, 0x4562537fU,
'    0xe0b16477U, 0x84bb6baeU, 0x1cfe81a0U, 0x94f9082bU,
'    0x58704868U, 0x198f45fdU, 0x8794de6cU, 0xb7527bf8U,
'    0x23ab73d3U, 0xe2724b02U, 0x57e31f8fU, 0x2a6655abU,
'    0x07b2eb28U, 0x032fb5c2U, 0x9a86c57bU, 0xa5d33708U,
'    0xf2302887U, 0xb223bfa5U, 0xba02036aU, 0x5ced1682U,
'    0x2b8acf1cU, 0x92a779b4U, 0xf0f307f2U, 0xa14e69e2U,
'    0xcd65daf4U, 0xd50605beU, 0x1fd13462U, 0x8ac4a6feU,
'    0x9d342e53U, 0xa0a2f355U, 0x32058ae1U, 0x75a4f6ebU,
'    0x390b83ecU, 0xaa4060efU, 0x065e719fU, 0x51bd6e10U,
'    0xf93e218aU, 0x3d96dd06U, 0xaedd3e05U, 0x464de6bdU,
'    0xb591548dU, 0x0571c45dU, 0x6f0406d4U, 0xff605015U,
'    0x241998fbU, 0x97d6bde9U, 0xcc894043U, 0x7767d99eU,
'    0xbdb0e842U, 0x8807898bU, 0x38e7195bU, 0xdb79c8eeU,
'    0x47a17c0aU, 0xe97c420fU, 0xc9f8841eU, 0x00000000U,
'    0x83098086U, 0x48322bedU, 0xac1e1170U, 0x4e6c5a72U,
'    0xfbfd0effU, 0x560f8538U, 0x1e3daed5U, 0x27362d39U,
'    0x640a0fd9U, 0x21685ca6U, 0xd19b5b54U, 0x3a24362eU,
'    0xb10c0a67U, 0x0f9357e7U, 0xd2b4ee96U, 0x9e1b9b91U,
'    0x4f80c0c5U, 0xa261dc20U, 0x695a774bU, 0x161c121aU,
'    0x0ae293baU, 0xe5c0a02aU, 0x433c22e0U, 0x1d121b17U,
'    0x0b0e090dU, 0xadf28bc7U, 0xb92db6a8U, 0xc8141ea9U,
'    0x8557f119U, 0x4caf7507U, 0xbbee99ddU, 0xfda37f60U,
'    0x9ff70126U, 0xbc5c72f5U, 0xc544663bU, 0x345bfb7eU,
'    0x768b4329U, 0xdccb23c6U, 0x68b6edfcU, 0x63b8e4f1U,
'    0xcad731dcU, 0x10426385U, 0x40139722U, 0x2084c611U,
'    0x7d854a24U, 0xf8d2bb3dU, 0x11aef932U, 0x6dc729a1U,
'    0x4b1d9e2fU, 0xf3dcb230U, 0xec0d8652U, 0xd077c1e3U,
'    0x6c2bb316U, 0x99a970b9U, 0xfa119448U, 0x2247e964U,
'    0xc4a8fc8cU, 0x1aa0f03fU, 0xd8567d2cU, 0xef223390U,
'    0xc787494eU, 0xc1d938d1U, 0xfe8ccaa2U, 0x3698d40bU,
'    0xcfa6f581U, 0x28a57adeU, 0x26dab78eU, 0xa43fadbfU,
'    0xe42c3a9dU, 0x0d507892U, 0x9b6a5fccU, 0x62547e46U,
'    0xc2f68d13U, 0xe890d8b8U, 0x5e2e39f7U, 0xf582c3afU,
'    0xbe9f5d80U, 0x7c69d093U, 0xa96fd52dU, 0xb3cf2512U,
'    0x3bc8ac99U, 0xa710187dU, 0x6ee89c63U, 0x7bdb3bbbU,
'    0x09cd2678U, 0xf46e5918U, 0x01ec9ab7U, 0xa8834f9aU,
'    0x65e6956eU, 0x7eaaffe6U, 0x0821bccfU, 0xe6ef15e8U,
'    0xd9bae79bU, 0xce4a6f36U, 0xd4ea9f09U, 0xd629b07cU,
'    0xaf31a4b2U, 0x312a3f23U, 0x30c6a594U, 0xc035a266U,
'    0x37744ebcU, 0xa6fc82caU, 0xb0e090d0U, 0x1533a7d8U,
'    0x4af10498U, 0xf741ecdaU, 0x0e7fcd50U, 0x2f1791f6U,
'    0x8d764dd6U, 0x4d43efb0U, 0x54ccaa4dU, 0xdfe49604U,
'    0xe39ed1b5U, 0x1b4c6a88U, 0xb8c12c1fU, 0x7f466551U,
'    0x049d5eeaU, 0x5d018c35U, 0x73fa8774U, 0x2efb0b41U,
'    0x5ab3671dU, 0x5292dbd2U, 0x33e91056U, 0x136dd647U,
'    0x8c9ad761U, 0x7a37a10cU, 0x8e59f814U, 0x89eb133cU,
'    0xeecea927U, 0x35b761c9U, 0xede11ce5U, 0x3c7a47b1U,
'    0x599cd2dfU, 0x3f55f273U, 0x791814ceU, 0xbf73c737U,
'    0xea53f7cdU, 0x5b5ffdaaU, 0x14df3d6fU, 0x867844dbU,
'    0x81caaff3U, 0x3eb968c4U, 0x2c382434U, 0x5fc2a340U,
'    0x72161dc3U, 0x0cbce225U, 0x8b283c49U, 0x41ff0d95U,
'    0x7139a801U, 0xde080cb3U, 0x9cd8b4e4U, 0x906456c1U,
'    0x617bcb84U, 0x70d532b6U, 0x74486c5cU, 0x42d0b857U,
'};
'static const u32 Td2[256] = {
'    0xa75051f4U, 0x65537e41U, 0xa4c31a17U, 0x5e963a27U,
'    0x6bcb3babU, 0x45f11f9dU, 0x58abacfaU, 0x03934be3U,
'    0xfa552030U, 0x6df6ad76U, 0x769188ccU, 0x4c25f502U,
'    0xd7fc4fe5U, 0xcbd7c52aU, 0x44802635U, 0xa38fb562U,
'    0x5a49deb1U, 0x1b6725baU, 0x0e9845eaU, 0xc0e15dfeU,
'    0x7502c32fU, 0xf012814cU, 0x97a38d46U, 0xf9c66bd3U,
'    0x5fe7038fU, 0x9c951592U, 0x7aebbf6dU, 0x59da9552U,
'    0x832dd4beU, 0x21d35874U, 0x692949e0U, 0xc8448ec9U,
'    0x896a75c2U, 0x7978f48eU, 0x3e6b9958U, 0x71dd27b9U,
'    0x4fb6bee1U, 0xad17f088U, 0xac66c920U, 0x3ab47dceU,
'    0x4a1863dfU, 0x3182e51aU, 0x33609751U, 0x7f456253U,
'    0x77e0b164U, 0xae84bb6bU, 0xa01cfe81U, 0x2b94f908U,
'    0x68587048U, 0xfd198f45U, 0x6c8794deU, 0xf8b7527bU,
'    0xd323ab73U, 0x02e2724bU, 0x8f57e31fU, 0xab2a6655U,
'    0x2807b2ebU, 0xc2032fb5U, 0x7b9a86c5U, 0x08a5d337U,
'    0x87f23028U, 0xa5b223bfU, 0x6aba0203U, 0x825ced16U,
'    0x1c2b8acfU, 0xb492a779U, 0xf2f0f307U, 0xe2a14e69U,
'    0xf4cd65daU, 0xbed50605U, 0x621fd134U, 0xfe8ac4a6U,
'    0x539d342eU, 0x55a0a2f3U, 0xe132058aU, 0xeb75a4f6U,
'    0xec390b83U, 0xefaa4060U, 0x9f065e71U, 0x1051bd6eU,
'
'    0x8af93e21U, 0x063d96ddU, 0x05aedd3eU, 0xbd464de6U,
'    0x8db59154U, 0x5d0571c4U, 0xd46f0406U, 0x15ff6050U,
'    0xfb241998U, 0xe997d6bdU, 0x43cc8940U, 0x9e7767d9U,
'    0x42bdb0e8U, 0x8b880789U, 0x5b38e719U, 0xeedb79c8U,
'    0x0a47a17cU, 0x0fe97c42U, 0x1ec9f884U, 0x00000000U,
'    0x86830980U, 0xed48322bU, 0x70ac1e11U, 0x724e6c5aU,
'    0xfffbfd0eU, 0x38560f85U, 0xd51e3daeU, 0x3927362dU,
'    0xd9640a0fU, 0xa621685cU, 0x54d19b5bU, 0x2e3a2436U,
'    0x67b10c0aU, 0xe70f9357U, 0x96d2b4eeU, 0x919e1b9bU,
'    0xc54f80c0U, 0x20a261dcU, 0x4b695a77U, 0x1a161c12U,
'    0xba0ae293U, 0x2ae5c0a0U, 0xe0433c22U, 0x171d121bU,
'    0x0d0b0e09U, 0xc7adf28bU, 0xa8b92db6U, 0xa9c8141eU,
'    0x198557f1U, 0x074caf75U, 0xddbbee99U, 0x60fda37fU,
'    0x269ff701U, 0xf5bc5c72U, 0x3bc54466U, 0x7e345bfbU,
'    0x29768b43U, 0xc6dccb23U, 0xfc68b6edU, 0xf163b8e4U,
'    0xdccad731U, 0x85104263U, 0x22401397U, 0x112084c6U,
'    0x247d854aU, 0x3df8d2bbU, 0x3211aef9U, 0xa16dc729U,
'    0x2f4b1d9eU, 0x30f3dcb2U, 0x52ec0d86U, 0xe3d077c1U,
'    0x166c2bb3U, 0xb999a970U, 0x48fa1194U, 0x642247e9U,
'    0x8cc4a8fcU, 0x3f1aa0f0U, 0x2cd8567dU, 0x90ef2233U,
'    0x4ec78749U, 0xd1c1d938U, 0xa2fe8ccaU, 0x0b3698d4U,
'    0x81cfa6f5U, 0xde28a57aU, 0x8e26dab7U, 0xbfa43fadU,
'    0x9de42c3aU, 0x920d5078U, 0xcc9b6a5fU, 0x4662547eU,
'    0x13c2f68dU, 0xb8e890d8U, 0xf75e2e39U, 0xaff582c3U,
'    0x80be9f5dU, 0x937c69d0U, 0x2da96fd5U, 0x12b3cf25U,
'    0x993bc8acU, 0x7da71018U, 0x636ee89cU, 0xbb7bdb3bU,
'    0x7809cd26U, 0x18f46e59U, 0xb701ec9aU, 0x9aa8834fU,
'    0x6e65e695U, 0xe67eaaffU, 0xcf0821bcU, 0xe8e6ef15U,
'    0x9bd9bae7U, 0x36ce4a6fU, 0x09d4ea9fU, 0x7cd629b0U,
'    0xb2af31a4U, 0x23312a3fU, 0x9430c6a5U, 0x66c035a2U,
'    0xbc37744eU, 0xcaa6fc82U, 0xd0b0e090U, 0xd81533a7U,
'    0x984af104U, 0xdaf741ecU, 0x500e7fcdU, 0xf62f1791U,
'    0xd68d764dU, 0xb04d43efU, 0x4d54ccaaU, 0x04dfe496U,
'    0xb5e39ed1U, 0x881b4c6aU, 0x1fb8c12cU, 0x517f4665U,
'    0xea049d5eU, 0x355d018cU, 0x7473fa87U, 0x412efb0bU,
'    0x1d5ab367U, 0xd25292dbU, 0x5633e910U, 0x47136dd6U,
'    0x618c9ad7U, 0x0c7a37a1U, 0x148e59f8U, 0x3c89eb13U,
'    0x27eecea9U, 0xc935b761U, 0xe5ede11cU, 0xb13c7a47U,
'    0xdf599cd2U, 0x733f55f2U, 0xce791814U, 0x37bf73c7U,
'    0xcdea53f7U, 0xaa5b5ffdU, 0x6f14df3dU, 0xdb867844U,
'    0xf381caafU, 0xc43eb968U, 0x342c3824U, 0x405fc2a3U,
'    0xc372161dU, 0x250cbce2U, 0x498b283cU, 0x9541ff0dU,
'    0x017139a8U, 0xb3de080cU, 0xe49cd8b4U, 0xc1906456U,
'    0x84617bcbU, 0xb670d532U, 0x5c74486cU, 0x5742d0b8U,
'};
'static const u32 Td3[256] = {
'    0xf4a75051U, 0x4165537eU, 0x17a4c31aU, 0x275e963aU,
'    0xab6bcb3bU, 0x9d45f11fU, 0xfa58abacU, 0xe303934bU,
'    0x30fa5520U, 0x766df6adU, 0xcc769188U, 0x024c25f5U,
'    0xe5d7fc4fU, 0x2acbd7c5U, 0x35448026U, 0x62a38fb5U,
'    0xb15a49deU, 0xba1b6725U, 0xea0e9845U, 0xfec0e15dU,
'    0x2f7502c3U, 0x4cf01281U, 0x4697a38dU, 0xd3f9c66bU,
'    0x8f5fe703U, 0x929c9515U, 0x6d7aebbfU, 0x5259da95U,
'    0xbe832dd4U, 0x7421d358U, 0xe0692949U, 0xc9c8448eU,
'    0xc2896a75U, 0x8e7978f4U, 0x583e6b99U, 0xb971dd27U,
'    0xe14fb6beU, 0x88ad17f0U, 0x20ac66c9U, 0xce3ab47dU,
'    0xdf4a1863U, 0x1a3182e5U, 0x51336097U, 0x537f4562U,
'    0x6477e0b1U, 0x6bae84bbU, 0x81a01cfeU, 0x082b94f9U,
'    0x48685870U, 0x45fd198fU, 0xde6c8794U, 0x7bf8b752U,
'    0x73d323abU, 0x4b02e272U, 0x1f8f57e3U, 0x55ab2a66U,
'    0xeb2807b2U, 0xb5c2032fU, 0xc57b9a86U, 0x3708a5d3U,
'    0x2887f230U, 0xbfa5b223U, 0x036aba02U, 0x16825cedU,
'    0xcf1c2b8aU, 0x79b492a7U, 0x07f2f0f3U, 0x69e2a14eU,
'    0xdaf4cd65U, 0x05bed506U, 0x34621fd1U, 0xa6fe8ac4U,
'    0x2e539d34U, 0xf355a0a2U, 0x8ae13205U, 0xf6eb75a4U,
'    0x83ec390bU, 0x60efaa40U, 0x719f065eU, 0x6e1051bdU,
'    0x218af93eU, 0xdd063d96U, 0x3e05aeddU, 0xe6bd464dU,
'    0x548db591U, 0xc45d0571U, 0x06d46f04U, 0x5015ff60U,
'    0x98fb2419U, 0xbde997d6U, 0x4043cc89U, 0xd99e7767U,
'    0xe842bdb0U, 0x898b8807U, 0x195b38e7U, 0xc8eedb79U,
'    0x7c0a47a1U, 0x420fe97cU, 0x841ec9f8U, 0x00000000U,
'    0x80868309U, 0x2bed4832U, 0x1170ac1eU, 0x5a724e6cU,
'    0x0efffbfdU, 0x8538560fU, 0xaed51e3dU, 0x2d392736U,
'    0x0fd9640aU, 0x5ca62168U, 0x5b54d19bU, 0x362e3a24U,
'    0x0a67b10cU, 0x57e70f93U, 0xee96d2b4U, 0x9b919e1bU,
'    0xc0c54f80U, 0xdc20a261U, 0x774b695aU, 0x121a161cU,
'    0x93ba0ae2U, 0xa02ae5c0U, 0x22e0433cU, 0x1b171d12U,
'    0x090d0b0eU, 0x8bc7adf2U, 0xb6a8b92dU, 0x1ea9c814U,
'    0xf1198557U, 0x75074cafU, 0x99ddbbeeU, 0x7f60fda3U,
'    0x01269ff7U, 0x72f5bc5cU, 0x663bc544U, 0xfb7e345bU,
'    0x4329768bU, 0x23c6dccbU, 0xedfc68b6U, 0xe4f163b8U,
'    0x31dccad7U, 0x63851042U, 0x97224013U, 0xc6112084U,
'    0x4a247d85U, 0xbb3df8d2U, 0xf93211aeU, 0x29a16dc7U,
'    0x9e2f4b1dU, 0xb230f3dcU, 0x8652ec0dU, 0xc1e3d077U,
'    0xb3166c2bU, 0x70b999a9U, 0x9448fa11U, 0xe9642247U,
'    0xfc8cc4a8U, 0xf03f1aa0U, 0x7d2cd856U, 0x3390ef22U,
'    0x494ec787U, 0x38d1c1d9U, 0xcaa2fe8cU, 0xd40b3698U,
'    0xf581cfa6U, 0x7ade28a5U, 0xb78e26daU, 0xadbfa43fU,
'    0x3a9de42cU, 0x78920d50U, 0x5fcc9b6aU, 0x7e466254U,
'    0x8d13c2f6U, 0xd8b8e890U, 0x39f75e2eU, 0xc3aff582U,
'    0x5d80be9fU, 0xd0937c69U, 0xd52da96fU, 0x2512b3cfU,
'    0xac993bc8U, 0x187da710U, 0x9c636ee8U, 0x3bbb7bdbU,
'    0x267809cdU, 0x5918f46eU, 0x9ab701ecU, 0x4f9aa883U,
'    0x956e65e6U, 0xffe67eaaU, 0xbccf0821U, 0x15e8e6efU,
'    0xe79bd9baU, 0x6f36ce4aU, 0x9f09d4eaU, 0xb07cd629U,
'    0xa4b2af31U, 0x3f23312aU, 0xa59430c6U, 0xa266c035U,
'    0x4ebc3774U, 0x82caa6fcU, 0x90d0b0e0U, 0xa7d81533U,
'    0x04984af1U, 0xecdaf741U, 0xcd500e7fU, 0x91f62f17U,
'    0x4dd68d76U, 0xefb04d43U, 0xaa4d54ccU, 0x9604dfe4U,
'    0xd1b5e39eU, 0x6a881b4cU, 0x2c1fb8c1U, 0x65517f46U,
'    0x5eea049dU, 0x8c355d01U, 0x877473faU, 0x0b412efbU,
'    0x671d5ab3U, 0xdbd25292U, 0x105633e9U, 0xd647136dU,
'    0xd7618c9aU, 0xa10c7a37U, 0xf8148e59U, 0x133c89ebU,
'    0xa927eeceU, 0x61c935b7U, 0x1ce5ede1U, 0x47b13c7aU,
'    0xd2df599cU, 0xf2733f55U, 0x14ce7918U, 0xc737bf73U,
'    0xf7cdea53U, 0xfdaa5b5fU, 0x3d6f14dfU, 0x44db8678U,
'    0xaff381caU, 0x68c43eb9U, 0x24342c38U, 0xa3405fc2U,
'    0x1dc37216U, 0xe2250cbcU, 0x3c498b28U, 0x0d9541ffU,
'    0xa8017139U, 0x0cb3de08U, 0xb4e49cd8U, 0x56c19064U,
'    0xcb84617bU, 0x32b670d5U, 0x6c5c7448U, 0xb85742d0U,
'};
'static const u32 Td4[256] = {
'    0x52525252U, 0x09090909U, 0x6a6a6a6aU, 0xd5d5d5d5U,
'    0x30303030U, 0x36363636U, 0xa5a5a5a5U, 0x38383838U,
'    0xbfbfbfbfU, 0x40404040U, 0xa3a3a3a3U, 0x9e9e9e9eU,
'    0x81818181U, 0xf3f3f3f3U, 0xd7d7d7d7U, 0xfbfbfbfbU,
'    0x7c7c7c7cU, 0xe3e3e3e3U, 0x39393939U, 0x82828282U,
'    0x9b9b9b9bU, 0x2f2f2f2fU, 0xffffffffU, 0x87878787U,
'    0x34343434U, 0x8e8e8e8eU, 0x43434343U, 0x44444444U,
'    0xc4c4c4c4U, 0xdedededeU, 0xe9e9e9e9U, 0xcbcbcbcbU,
'    0x54545454U, 0x7b7b7b7bU, 0x94949494U, 0x32323232U,
'    0xa6a6a6a6U, 0xc2c2c2c2U, 0x23232323U, 0x3d3d3d3dU,
'    0xeeeeeeeeU, 0x4c4c4c4cU, 0x95959595U, 0x0b0b0b0bU,
'    0x42424242U, 0xfafafafaU, 0xc3c3c3c3U, 0x4e4e4e4eU,
'    0x08080808U, 0x2e2e2e2eU, 0xa1a1a1a1U, 0x66666666U,
'    0x28282828U, 0xd9d9d9d9U, 0x24242424U, 0xb2b2b2b2U,
'    0x76767676U, 0x5b5b5b5bU, 0xa2a2a2a2U, 0x49494949U,
'    0x6d6d6d6dU, 0x8b8b8b8bU, 0xd1d1d1d1U, 0x25252525U,
'    0x72727272U, 0xf8f8f8f8U, 0xf6f6f6f6U, 0x64646464U,
'    0x86868686U, 0x68686868U, 0x98989898U, 0x16161616U,
'    0xd4d4d4d4U, 0xa4a4a4a4U, 0x5c5c5c5cU, 0xccccccccU,
'    0x5d5d5d5dU, 0x65656565U, 0xb6b6b6b6U, 0x92929292U,
'    0x6c6c6c6cU, 0x70707070U, 0x48484848U, 0x50505050U,
'    0xfdfdfdfdU, 0xededededU, 0xb9b9b9b9U, 0xdadadadaU,
'    0x5e5e5e5eU, 0x15151515U, 0x46464646U, 0x57575757U,
'    0xa7a7a7a7U, 0x8d8d8d8dU, 0x9d9d9d9dU, 0x84848484U,
'    0x90909090U, 0xd8d8d8d8U, 0xababababU, 0x00000000U,
'    0x8c8c8c8cU, 0xbcbcbcbcU, 0xd3d3d3d3U, 0x0a0a0a0aU,
'    0xf7f7f7f7U, 0xe4e4e4e4U, 0x58585858U, 0x05050505U,
'    0xb8b8b8b8U, 0xb3b3b3b3U, 0x45454545U, 0x06060606U,
'    0xd0d0d0d0U, 0x2c2c2c2cU, 0x1e1e1e1eU, 0x8f8f8f8fU,
'    0xcacacacaU, 0x3f3f3f3fU, 0x0f0f0f0fU, 0x02020202U,
'    0xc1c1c1c1U, 0xafafafafU, 0xbdbdbdbdU, 0x03030303U,
'    0x01010101U, 0x13131313U, 0x8a8a8a8aU, 0x6b6b6b6bU,
'    0x3a3a3a3aU, 0x91919191U, 0x11111111U, 0x41414141U,
'    0x4f4f4f4fU, 0x67676767U, 0xdcdcdcdcU, 0xeaeaeaeaU,
'    0x97979797U, 0xf2f2f2f2U, 0xcfcfcfcfU, 0xcecececeU,
'    0xf0f0f0f0U, 0xb4b4b4b4U, 0xe6e6e6e6U, 0x73737373U,
'    0x96969696U, 0xacacacacU, 0x74747474U, 0x22222222U,
'    0xe7e7e7e7U, 0xadadadadU, 0x35353535U, 0x85858585U,
'    0xe2e2e2e2U, 0xf9f9f9f9U, 0x37373737U, 0xe8e8e8e8U,
'    0x1c1c1c1cU, 0x75757575U, 0xdfdfdfdfU, 0x6e6e6e6eU,
'    0x47474747U, 0xf1f1f1f1U, 0x1a1a1a1aU, 0x71717171U,
'    0x1d1d1d1dU, 0x29292929U, 0xc5c5c5c5U, 0x89898989U,
'    0x6f6f6f6fU, 0xb7b7b7b7U, 0x62626262U, 0x0e0e0e0eU,
'    0xaaaaaaaaU, 0x18181818U, 0xbebebebeU, 0x1b1b1b1bU,
'    0xfcfcfcfcU, 0x56565656U, 0x3e3e3e3eU, 0x4b4b4b4bU,
'    0xc6c6c6c6U, 0xd2d2d2d2U, 0x79797979U, 0x20202020U,
'    0x9a9a9a9aU, 0xdbdbdbdbU, 0xc0c0c0c0U, 0xfefefefeU,
'    0x78787878U, 0xcdcdcdcdU, 0x5a5a5a5aU, 0xf4f4f4f4U,
'    0x1f1f1f1fU, 0xddddddddU, 0xa8a8a8a8U, 0x33333333U,
'    0x88888888U, 0x07070707U, 0xc7c7c7c7U, 0x31313131U,
'    0xb1b1b1b1U, 0x12121212U, 0x10101010U, 0x59595959U,
'    0x27272727U, 0x80808080U, 0xececececU, 0x5f5f5f5fU,
'    0x60606060U, 0x51515151U, 0x7f7f7f7fU, 0xa9a9a9a9U,
'    0x19191919U, 0xb5b5b5b5U, 0x4a4a4a4aU, 0x0d0d0d0dU,
'    0x2d2d2d2dU, 0xe5e5e5e5U, 0x7a7a7a7aU, 0x9f9f9f9fU,
'    0x93939393U, 0xc9c9c9c9U, 0x9c9c9c9cU, 0xefefefefU,
'    0xa0a0a0a0U, 0xe0e0e0e0U, 0x3b3b3b3bU, 0x4d4d4d4dU,
'    0xaeaeaeaeU, 0x2a2a2a2aU, 0xf5f5f5f5U, 0xb0b0b0b0U,
'    0xc8c8c8c8U, 0xebebebebU, 0xbbbbbbbbU, 0x3c3c3c3cU,
'    0x83838383U, 0x53535353U, 0x99999999U, 0x61616161U,
'    0x17171717U, 0x2b2b2b2bU, 0x04040404U, 0x7e7e7e7eU,
'    0xbabababaU, 0x77777777U, 0xd6d6d6d6U, 0x26262626U,
'    0xe1e1e1e1U, 0x69696969U, 0x14141414U, 0x63636363U,
'    0x55555555U, 0x21212121U, 0x0c0c0c0cU, 0x7d7d7d7dU,
'};
'static const u32 rcon[] = {
'    0x01000000, 0x02000000, 0x04000000, 0x08000000,
'    0x10000000, 0x20000000, 0x40000000, 0x80000000,
'    0x1B000000, 0x36000000, /* for 128-bit blocks, Rijndael never uses more than 10 rcon values */
'};

Public Function RijnDaelKeySetupEnc(ByRef rk() As Long, cipherKey() As Long, keyBits As Long) As Long
Dim i, j As Long
Dim Temp As Long
    i = 0
    j = 0
    rk(0) = cipherKey(0)
    rk(1) = cipherKey(1)
    rk(2) = cipherKey(2)
    rk(3) = cipherKey(3)
    If keyBits = 128 Then
        Do
            Temp = rk(3 + j)
            rk(4 + j) = rk(0 + j) Xor _
                    (Te4((LshR(Temp, 16) And &HFF&)) And &HFF000000) Xor _
                    (Te4((LshR(Temp, 8) And &HFF&)) And &HFF0000) Xor _
                    (Te4((Temp And &HFF&)) And &HFF00&) Xor _
                    (Te4((LshR(Temp, 24))) And &HFF&) Xor _
                    Rcon(i)
            rk(5 + j) = rk(1 + j) Xor rk(4 + j)
            rk(6 + j) = rk(2 + j) Xor rk(5 + j)
            rk(7 + j) = rk(3 + j) Xor rk(6 + j)
            i = i + 1
            If i = 10 Then
                RijnDaelKeySetupEnc = 10
                Exit Function
            End If
            j = j + 4
        Loop
    End If
    rk(4) = cipherKey(4)
    rk(5) = cipherKey(5)
    If keyBits = 192 Then
        Do
            Temp = rk(5 + j)
            rk(6 + j) = rk(0 + j) Xor _
                    (Te4((LshR(Temp, 16) And &HFF&)) And &HFF000000) Xor _
                    (Te4((LshR(Temp, 8) And &HFF&)) And &HFF0000) Xor _
                    (Te4((Temp And &HFF&)) And &HFF00&) Xor _
                    (Te4((LshR(Temp, 24))) And &HFF&) Xor _
                    Rcon(i)
            rk(7 + j) = rk(1 + j) Xor rk(6 + j)
            rk(8 + j) = rk(2 + j) Xor rk(7 + j)
            rk(9 + j) = rk(3 + j) Xor rk(8 + j)
            i = i + 1
            If i = 8 Then
                RijnDaelKeySetupEnc = 12
                Exit Function
            End If
            rk(10 + j) = rk(4 + j) Xor rk(9 + j)
            rk(11 + j) = rk(5 + j) Xor rk(10 + j)
            j = j + 6
        Loop
    End If
    rk(6) = cipherKey(6)
    rk(7) = cipherKey(7)
    If keyBits = 256 Then
        Do
            Temp = rk(7 + j)
            rk(8 + j) = rk(0 + j) Xor _
                    (Te4((LshR(Temp, 16) And &HFF&)) And &HFF000000) Xor _
                    (Te4((LshR(Temp, 8) And &HFF)) And &HFF0000) Xor _
                    (Te4((Temp And &HFF&)) And &HFF00&) Xor _
                    (Te4((LshR(Temp, 24))) And &HFF&) Xor _
                    Rcon(i)
            rk(9 + j) = rk(1 + j) Xor rk(8 + j)
            rk(10 + j) = rk(2 + j) Xor rk(9 + j)
            rk(11 + j) = rk(3 + j) Xor rk(10 + j)
            i = i + 1
            If i = 7 Then
                RijnDaelKeySetupEnc = 14
                Exit Function
            End If
            Temp = rk(11 + j)
            rk(12 + j) = rk(4 + j) Xor _
                (Te4((LshR(Temp, 24))) And &HFF000000) Xor _
                (Te4((LshR(Temp, 16) And &HFF&)) And &HFF0000) Xor _
                (Te4((LshR(Temp, 8) And &HFF&)) And &HFF00&) Xor _
                (Te4((Temp And &HFF&)) And &HFF&)
            rk(13 + j) = rk(5 + j) Xor rk(12 + j)
            rk(14 + j) = rk(6 + j) Xor rk(13 + j)
            rk(15 + j) = rk(7 + j) Xor rk(14 + j)
            j = j + 8
        Loop
    End If
    RijnDaelKeySetupEnc = 0
End Function

' Original C-source of above function.
'int rijndaelKeySetupEnc(u32 rk[/*4*(Nr + 1)*/], const u8 cipherKey[], int keyBits) {
'    int i = 0;
'    u32 temp;
'
'    rk[0] = GETU32(cipherKey     );
'    rk[1] = GETU32(cipherKey +  4);
'    rk[2] = GETU32(cipherKey +  8);
'    rk[3] = GETU32(cipherKey + 12);
'    if (keyBits == 128) {
'        for (;;) {
'            temp  = rk[3];
'            rk[4] = rk[0] ^
'                (Te4[(temp >> 16) & 0xff] & 0xff000000) ^
'                (Te4[(temp >>  8) & 0xff] & 0x00ff0000) ^
'                (Te4[(temp      ) & 0xff] & 0x0000ff00) ^
'                (Te4[(temp >> 24)       ] & 0x000000ff) ^
'                rcon[i];
'            rk[5] = rk[1] ^ rk[4];
'            rk[6] = rk[2] ^ rk[5];
'            rk[7] = rk[3] ^ rk[6];
'            if (++i == 10) {
'                return 10;
'            }
'            rk += 4;
'        }
'    }
'    rk[4] = GETU32(cipherKey + 16);
'    rk[5] = GETU32(cipherKey + 20);
'    if (keyBits == 192) {
'        for (;;) {
'            temp = rk[ 5];
'            rk[ 6] = rk[ 0] ^
'                (Te4[(temp >> 16) & 0xff] & 0xff000000) ^
'                (Te4[(temp >>  8) & 0xff] & 0x00ff0000) ^
'                (Te4[(temp      ) & 0xff] & 0x0000ff00) ^
'                (Te4[(temp >> 24)       ] & 0x000000ff) ^
'                rcon[i];
'            rk[ 7] = rk[ 1] ^ rk[ 6];
'            rk[ 8] = rk[ 2] ^ rk[ 7];
'            rk[ 9] = rk[ 3] ^ rk[ 8];
'            if (++i == 8) {
'                return 12;
'            }
'            rk[10] = rk[ 4] ^ rk[ 9];
'            rk[11] = rk[ 5] ^ rk[10];
'            rk += 6;
'        }
'    }
'    rk[6] = GETU32(cipherKey + 24);
'    rk[7] = GETU32(cipherKey + 28);
'    if (keyBits == 256) {
'        for (;;) {
'            temp = rk[ 7];
'            rk[ 8] = rk[ 0] ^
'                (Te4[(temp >> 16) & 0xff] & 0xff000000) ^
'                (Te4[(temp >>  8) & 0xff] & 0x00ff0000) ^
'                (Te4[(temp      ) & 0xff] & 0x0000ff00) ^
'                (Te4[(temp >> 24)       ] & 0x000000ff) ^
'                rcon[i];
'            rk[ 9] = rk[ 1] ^ rk[ 8];
'            rk[10] = rk[ 2] ^ rk[ 9];
'            rk[11] = rk[ 3] ^ rk[10];
'            if (++i == 7) {
'                return 14;
'            }
'            temp = rk[11];
'            rk[12] = rk[ 4] ^
'                (Te4[(temp >> 24)       ] & 0xff000000) ^
'                (Te4[(temp >> 16) & 0xff] & 0x00ff0000) ^
'                (Te4[(temp >>  8) & 0xff] & 0x0000ff00) ^
'                (Te4[(temp      ) & 0xff] & 0x000000ff);
'            rk[13] = rk[ 5] ^ rk[12];
'            rk[14] = rk[ 6] ^ rk[13];
'            rk[15] = rk[ 7] ^ rk[14];
'
'            rk += 8;
'        }
'    }
'    return 0;
'}

Public Function rijndaelKeySetupDec(ByRef rk() As Long, cipherKey() As Long, keyBits As Long) As Long
Dim i, j As Long
Dim Temp As Long
Dim Nr As Long
    
    '    /* expand the cipher key: */
    Nr = RijnDaelKeySetupEnc(rk, cipherKey, keyBits)
    '    /* invert the order of the round keys: */
    j = 4 * Nr
    For i = 0 To (2 * Nr) Step 4
        Temp = rk(i)
        rk(i) = rk(j)
        rk(j) = Temp
        Temp = rk(i + 1)
        rk(i + 1) = rk(j + 1)
        rk(j + 1) = Temp
        Temp = rk(i + 2)
        rk(i + 2) = rk(j + 2)
        rk(j + 2) = Temp
        Temp = rk(i + 3)
        rk(i + 3) = rk(j + 3)
        rk(j + 3) = Temp
        j = j - 4
    Next
    '    /* apply the inverse MixColumn transform to all round keys but the first and the last: */
    j = 4
    For i = 1 To Nr - 1
        rk(0 + j) = Td0(Te4((LshR(rk(0 + j), 24))) And &HFF&) Xor _
            Td1(Te4((LshR(rk(0 + j), 16) And &HFF&)) And &HFF&) Xor _
            Td2(Te4((LshR(rk(0 + j), 8) And &HFF&)) And &HFF&) Xor _
            Td3(Te4((rk(0 + j) And &HFF&)) And &HFF&)
        rk(1 + j) = Td0(Te4((LshR(rk(1 + j), 24))) And &HFF&) Xor _
            Td1(Te4((LshR(rk(1 + j), 16) And &HFF&)) And &HFF&) Xor _
            Td2(Te4((LshR(rk(1 + j), 8) And &HFF&)) And &HFF&) Xor _
            Td3(Te4((rk(1 + j) And &HFF&)) And &HFF&)
        rk(2 + j) = Td0(Te4((LshR(rk(2 + j), 24))) And &HFF&) Xor _
            Td1(Te4((LshR(rk(2 + j), 16) And &HFF&)) And &HFF&) Xor _
            Td2(Te4((LshR(rk(2 + j), 8) And &HFF&)) And &HFF&) Xor _
            Td3(Te4((rk(2 + j) And &HFF&)) And &HFF&)
        rk(3 + j) = Td0(Te4((LshR(rk(3 + j), 24))) And &HFF&) Xor _
            Td1(Te4((LshR(rk(3 + j), 16) And &HFF&)) And &HFF&) Xor _
            Td2(Te4((LshR(rk(3 + j), 8) And &HFF&)) And &HFF&) Xor _
            Td3(Te4((rk(3 + j) And &HFF&)) And &HFF&)
        j = j + 4
    Next
    rijndaelKeySetupDec = Nr
End Function

' Original C-Source for rijndaelKeySetupDec()
'int rijndaelKeySetupDec(u32 rk[/*4*(Nr + 1)*/], const u8 cipherKey[], int keyBits) {
'    int Nr, i, j;
'    u32 temp;
'
'    /* expand the cipher key: */
'    Nr = rijndaelKeySetupEnc(rk, cipherKey, keyBits);
'    /* invert the order of the round keys: */
'    for (i = 0, j = 4*Nr; i < j; i += 4, j -= 4) {
'        temp = rk[i    ]; rk[i    ] = rk[j    ]; rk[j    ] = temp;
'        temp = rk[i + 1]; rk[i + 1] = rk[j + 1]; rk[j + 1] = temp;
'        temp = rk[i + 2]; rk[i + 2] = rk[j + 2]; rk[j + 2] = temp;
'        temp = rk[i + 3]; rk[i + 3] = rk[j + 3]; rk[j + 3] = temp;
'    }
'    /* apply the inverse MixColumn transform to all round keys but the first and the last: */
'    for (i = 1; i < Nr; i++) {
'        rk += 4;
'        rk[0] =
'            Td0[Te4[(rk[0] >> 24)       ] & 0xff] ^
'            Td1[Te4[(rk[0] >> 16) & 0xff] & 0xff] ^
'            Td2[Te4[(rk[0] >>  8) & 0xff] & 0xff] ^
'            Td3[Te4[(rk[0]      ) & 0xff] & 0xff];
'        rk[1] =
'            Td0[Te4[(rk[1] >> 24)       ] & 0xff] ^
'            Td1[Te4[(rk[1] >> 16) & 0xff] & 0xff] ^
'            Td2[Te4[(rk[1] >>  8) & 0xff] & 0xff] ^
'            Td3[Te4[(rk[1]      ) & 0xff] & 0xff];
'        rk[2] =
'            Td0[Te4[(rk[2] >> 24)       ] & 0xff] ^
'            Td1[Te4[(rk[2] >> 16) & 0xff] & 0xff] ^
'            Td2[Te4[(rk[2] >>  8) & 0xff] & 0xff] ^
'            Td3[Te4[(rk[2]      ) & 0xff] & 0xff];
'        rk[3] =
'            Td0[Te4[(rk[3] >> 24)       ] & 0xff] ^
'            Td1[Te4[(rk[3] >> 16) & 0xff] & 0xff] ^
'            Td2[Te4[(rk[3] >>  8) & 0xff] & 0xff] ^
'            Td3[Te4[(rk[3]      ) & 0xff] & 0xff];
'    }
'    return Nr;
'}

Public Sub rijndaelEncrypt(ByRef rk() As Long, Nr As Long, ByRef PT() As Long, ByRef CT() As Long)
Dim s0 As Long, s1 As Long, s2 As Long, s3 As Long, t0 As Long, t1 As Long, t2 As Long, t3 As Long
#If Not FULL_UNROLL Then
Dim r As Long
#End If
Dim j As Long
'    /*
'     * map byte array block to cipher state
'     * and add initial round key:
'     */
    s0 = PT(0) Xor rk(0)
    s1 = PT(1) Xor rk(1)
    s2 = PT(2) Xor rk(2)
    s3 = PT(3) Xor rk(3)
#If FULL_UNROLL Then
'    /* round 1: */
    t0 = Te0((LshR(s0, 24))) Xor Te1((LshR(s1, 16) And &HFF&)) Xor Te2((LshR(s2, 8) And &HFF&)) Xor Te3((s3 And &HFF&)) Xor rk(4)
    t1 = Te0((LshR(s1, 24))) Xor Te1((LshR(s2, 16) And &HFF&)) Xor Te2((LshR(s3, 8) And &HFF&)) Xor Te3((s0 And &HFF&)) Xor rk(5)
    t2 = Te0((LshR(s2, 24))) Xor Te1((LshR(s3, 16) And &HFF&)) Xor Te2((LshR(s0, 8) And &HFF&)) Xor Te3((s1 And &HFF&)) Xor rk(6)
    t3 = Te0((LshR(s3, 24))) Xor Te1((LshR(s0, 16) And &HFF&)) Xor Te2((LshR(s1, 8) And &HFF&)) Xor Te3((s2 And &HFF&)) Xor rk(7)
'    /* round 2: */
    s0 = Te0((LshR(t0, 24))) Xor Te1((LshR(t1, 16) And &HFF&)) Xor Te2((LshR(t2, 8) And &HFF&)) Xor Te3((t3 And &HFF&)) Xor rk(8)
    s1 = Te0((LshR(t1, 24))) Xor Te1((LshR(t2, 16) And &HFF&)) Xor Te2((LshR(t3, 8) And &HFF&)) Xor Te3((t0 And &HFF&)) Xor rk(9)
    s2 = Te0((LshR(t2, 24))) Xor Te1((LshR(t3, 16) And &HFF&)) Xor Te2((LshR(t0, 8) And &HFF&)) Xor Te3((t1 And &HFF&)) Xor rk(10)
    s3 = Te0((LshR(t3, 24))) Xor Te1((LshR(t0, 16) And &HFF&)) Xor Te2((LshR(t1, 8) And &HFF&)) Xor Te3((t2 And &HFF&)) Xor rk(11)
'    /* round 3: */
    t0 = Te0((LshR(s0, 24))) Xor Te1((LshR(s1, 16) And &HFF&)) Xor Te2((LshR(s2, 8) And &HFF&)) Xor Te3((s3 And &HFF&)) Xor rk(12)
    t1 = Te0((LshR(s1, 24))) Xor Te1((LshR(s2, 16) And &HFF&)) Xor Te2((LshR(s3, 8) And &HFF&)) Xor Te3((s0 And &HFF&)) Xor rk(13)
    t2 = Te0((LshR(s2, 24))) Xor Te1((LshR(s3, 16) And &HFF&)) Xor Te2((LshR(s0, 8) And &HFF&)) Xor Te3((s1 And &HFF&)) Xor rk(14)
    t3 = Te0((LshR(s3, 24))) Xor Te1((LshR(s0, 16) And &HFF&)) Xor Te2((LshR(s1, 8) And &HFF&)) Xor Te3((s2 And &HFF&)) Xor rk(15)
'    /* round 4: */
    s0 = Te0((LshR(t0, 24))) Xor Te1((LshR(t1, 16) And &HFF&)) Xor Te2((LshR(t2, 8) And &HFF&)) Xor Te3((t3 And &HFF&)) Xor rk(16)
    s1 = Te0((LshR(t1, 24))) Xor Te1((LshR(t2, 16) And &HFF&)) Xor Te2((LshR(t3, 8) And &HFF&)) Xor Te3((t0 And &HFF&)) Xor rk(17)
    s2 = Te0((LshR(t2, 24))) Xor Te1((LshR(t3, 16) And &HFF&)) Xor Te2((LshR(t0, 8) And &HFF&)) Xor Te3((t1 And &HFF&)) Xor rk(18)
    s3 = Te0((LshR(t3, 24))) Xor Te1((LshR(t0, 16) And &HFF&)) Xor Te2((LshR(t1, 8) And &HFF&)) Xor Te3((t2 And &HFF&)) Xor rk(19)
'    /* round 5: */
    t0 = Te0((LshR(s0, 24))) Xor Te1((LshR(s1, 16) And &HFF&)) Xor Te2((LshR(s2, 8) And &HFF&)) Xor Te3((s3 And &HFF&)) Xor rk(20)
    t1 = Te0((LshR(s1, 24))) Xor Te1((LshR(s2, 16) And &HFF&)) Xor Te2((LshR(s3, 8) And &HFF&)) Xor Te3((s0 And &HFF&)) Xor rk(21)
    t2 = Te0((LshR(s2, 24))) Xor Te1((LshR(s3, 16) And &HFF&)) Xor Te2((LshR(s0, 8) And &HFF&)) Xor Te3((s1 And &HFF&)) Xor rk(22)
    t3 = Te0((LshR(s3, 24))) Xor Te1((LshR(s0, 16) And &HFF&)) Xor Te2((LshR(s1, 8) And &HFF&)) Xor Te3((s2 And &HFF&)) Xor rk(23)
'    /* round 6: */
    s0 = Te0((LshR(t0, 24))) Xor Te1((LshR(t1, 16) And &HFF&)) Xor Te2((LshR(t2, 8) And &HFF&)) Xor Te3((t3 And &HFF&)) Xor rk(24)
    s1 = Te0((LshR(t1, 24))) Xor Te1((LshR(t2, 16) And &HFF&)) Xor Te2((LshR(t3, 8) And &HFF&)) Xor Te3((t0 And &HFF&)) Xor rk(25)
    s2 = Te0((LshR(t2, 24))) Xor Te1((LshR(t3, 16) And &HFF&)) Xor Te2((LshR(t0, 8) And &HFF&)) Xor Te3((t1 And &HFF&)) Xor rk(26)
    s3 = Te0((LshR(t3, 24))) Xor Te1((LshR(t0, 16) And &HFF&)) Xor Te2((LshR(t1, 8) And &HFF&)) Xor Te3((t2 And &HFF&)) Xor rk(27)
'    /* round 7: */
    t0 = Te0((LshR(s0, 24))) Xor Te1((LshR(s1, 16) And &HFF&)) Xor Te2((LshR(s2, 8) And &HFF&)) Xor Te3((s3 And &HFF&)) Xor rk(28)
    t1 = Te0((LshR(s1, 24))) Xor Te1((LshR(s2, 16) And &HFF&)) Xor Te2((LshR(s3, 8) And &HFF&)) Xor Te3((s0 And &HFF&)) Xor rk(29)
    t2 = Te0((LshR(s2, 24))) Xor Te1((LshR(s3, 16) And &HFF&)) Xor Te2((LshR(s0, 8) And &HFF&)) Xor Te3((s1 And &HFF&)) Xor rk(30)
    t3 = Te0((LshR(s3, 24))) Xor Te1((LshR(s0, 16) And &HFF&)) Xor Te2((LshR(s1, 8) And &HFF&)) Xor Te3((s2 And &HFF&)) Xor rk(31)
'    /* round 8: */
    s0 = Te0((LshR(t0, 24))) Xor Te1((LshR(t1, 16) And &HFF&)) Xor Te2((LshR(t2, 8) And &HFF&)) Xor Te3((t3 And &HFF&)) Xor rk(32)
    s1 = Te0((LshR(t1, 24))) Xor Te1((LshR(t2, 16) And &HFF&)) Xor Te2((LshR(t3, 8) And &HFF&)) Xor Te3((t0 And &HFF&)) Xor rk(33)
    s2 = Te0((LshR(t2, 24))) Xor Te1((LshR(t3, 16) And &HFF&)) Xor Te2((LshR(t0, 8) And &HFF&)) Xor Te3((t1 And &HFF&)) Xor rk(34)
    s3 = Te0((LshR(t3, 24))) Xor Te1((LshR(t0, 16) And &HFF&)) Xor Te2((LshR(t1, 8) And &HFF&)) Xor Te3((t2 And &HFF&)) Xor rk(35)
'    /* round 9: */
    t0 = Te0((LshR(s0, 24))) Xor Te1((LshR(s1, 16) And &HFF&)) Xor Te2((LshR(s2, 8) And &HFF&)) Xor Te3((s3 And &HFF&)) Xor rk(36)
    t1 = Te0((LshR(s1, 24))) Xor Te1((LshR(s2, 16) And &HFF&)) Xor Te2((LshR(s3, 8) And &HFF&)) Xor Te3((s0 And &HFF&)) Xor rk(37)
    t2 = Te0((LshR(s2, 24))) Xor Te1((LshR(s3, 16) And &HFF&)) Xor Te2((LshR(s0, 8) And &HFF&)) Xor Te3((s1 And &HFF&)) Xor rk(38)
    t3 = Te0((LshR(s3, 24))) Xor Te1((LshR(s0, 16) And &HFF&)) Xor Te2((LshR(s1, 8) And &HFF&)) Xor Te3((s2 And &HFF&)) Xor rk(39)
    If Nr > 10 Then
    '        /* round 10: */
        s0 = Te0((LshR(t0, 24))) Xor Te1((LshR(t1, 16) And &HFF&)) Xor Te2((LshR(t2, 8) And &HFF&)) Xor Te3((t3 And &HFF&)) Xor rk(40)
        s1 = Te0((LshR(t1, 24))) Xor Te1((LshR(t2, 16) And &HFF&)) Xor Te2((LshR(t3, 8) And &HFF&)) Xor Te3((t0 And &HFF&)) Xor rk(41)
        s2 = Te0((LshR(t2, 24))) Xor Te1((LshR(t3, 16) And &HFF&)) Xor Te2((LshR(t0, 8) And &HFF&)) Xor Te3((t1 And &HFF&)) Xor rk(42)
        s3 = Te0((LshR(t3, 24))) Xor Te1((LshR(t0, 16) And &HFF&)) Xor Te2((LshR(t1, 8) And &HFF&)) Xor Te3((t2 And &HFF&)) Xor rk(43)
    '        /* round 11: */
        t0 = Te0((LshR(s0, 24))) Xor Te1((LshR(s1, 16) And &HFF&)) Xor Te2((LshR(s2, 8) And &HFF&)) Xor Te3((s3 And &HFF&)) Xor rk(44)
        t1 = Te0((LshR(s1, 24))) Xor Te1((LshR(s2, 16) And &HFF&)) Xor Te2((LshR(s3, 8) And &HFF&)) Xor Te3((s0 And &HFF&)) Xor rk(45)
        t2 = Te0((LshR(s2, 24))) Xor Te1((LshR(s3, 16) And &HFF&)) Xor Te2((LshR(s0, 8) And &HFF&)) Xor Te3((s1 And &HFF&)) Xor rk(46)
        t3 = Te0((LshR(s3, 24))) Xor Te1((LshR(s0, 16) And &HFF&)) Xor Te2((LshR(s1, 8) And &HFF&)) Xor Te3((s2 And &HFF&)) Xor rk(47)
        If Nr > 12 Then
        '            /* round 12: */
            s0 = Te0((LshR(t0, 24))) Xor Te1((LshR(t1, 16) And &HFF&)) Xor Te2((LshR(t2, 8) And &HFF&)) Xor Te3((t3 And &HFF&)) Xor rk(48)
            s1 = Te0((LshR(t1, 24))) Xor Te1((LshR(t2, 16) And &HFF&)) Xor Te2((LshR(t3, 8) And &HFF&)) Xor Te3((t0 And &HFF&)) Xor rk(49)
            s2 = Te0((LshR(t2, 24))) Xor Te1((LshR(t3, 16) And &HFF&)) Xor Te2((LshR(t0, 8) And &HFF&)) Xor Te3((t1 And &HFF&)) Xor rk(50)
            s3 = Te0((LshR(t3, 24))) Xor Te1((LshR(t0, 16) And &HFF&)) Xor Te2((LshR(t1, 8) And &HFF&)) Xor Te3((t2 And &HFF&)) Xor rk(51)
        '            /* round 13: */
            t0 = Te0((LshR(s0, 24))) Xor Te1((LshR(s1, 16) And &HFF&)) Xor Te2((LshR(s2, 8) And &HFF&)) Xor Te3((s3 And &HFF&)) Xor rk(52)
            t1 = Te0((LshR(s1, 24))) Xor Te1((LshR(s2, 16) And &HFF&)) Xor Te2((LshR(s3, 8) And &HFF&)) Xor Te3((s0 And &HFF&)) Xor rk(53)
            t2 = Te0((LshR(s2, 24))) Xor Te1((LshR(s3, 16) And &HFF&)) Xor Te2((LshR(s0, 8) And &HFF&)) Xor Te3((s1 And &HFF&)) Xor rk(54)
            t3 = Te0((LshR(s3, 24))) Xor Te1((LshR(s0, 16) And &HFF&)) Xor Te2((LshR(s1, 8) And &HFF&)) Xor Te3((s2 And &HFF&)) Xor rk(55)
        End If
    End If
    j = LshL(Nr, 2)
#Else  ' Not full unroll
    '    /*
    '     * Nr - 1 full rounds:
    '     */
    r = LshR(Nr, 1)
    j = 0
    Do
        t0 = Te0((LshR(s0, 24))) Xor Te1((LshR(s1, 16) And &HFF&)) Xor Te2((LshR(s2, 8) And &HFF&)) Xor Te3((s3 And &HFF&)) Xor rk(4 + j)
        t1 = Te0((LshR(s1, 24))) Xor Te1((LshR(s2, 16) And &HFF&)) Xor Te2((LshR(s3, 8) And &HFF&)) Xor Te3((s0 And &HFF&)) Xor rk(5 + j)
        t2 = Te0((LshR(s2, 24))) Xor Te1((LshR(s3, 16) And &HFF&)) Xor Te2((LshR(s0, 8) And &HFF&)) Xor Te3((s1 And &HFF&)) Xor rk(6 + j)
        t3 = Te0((LshR(s3, 24))) Xor Te1((LshR(s0, 16) And &HFF&)) Xor Te2((LshR(s1, 8) And &HFF&)) Xor Te3((s2 And &HFF&)) Xor rk(7 + j)
        r = r - 1
        j = j + 8
        If r = 0 Then
            Exit Do
        End If
        s0 = Te0((LshR(t0, 24))) Xor Te1((LshR(t1, 16) And &HFF&)) Xor Te2((LshR(t2, 8) And &HFF&)) Xor Te3((t3 And &HFF&)) Xor rk(0 + j)
        s1 = Te0((LshR(t1, 24))) Xor Te1((LshR(t2, 16) And &HFF&)) Xor Te2((LshR(t3, 8) And &HFF&)) Xor Te3((t0 And &HFF&)) Xor rk(1 + j)
        s2 = Te0((LshR(t2, 24))) Xor Te1((LshR(t3, 16) And &HFF&)) Xor Te2((LshR(t0, 8) And &HFF&)) Xor Te3((t1 And &HFF&)) Xor rk(2 + j)
        s3 = Te0((LshR(t3, 24))) Xor Te1((LshR(t0, 16) And &HFF&)) Xor Te2((LshR(t1, 8) And &HFF&)) Xor Te3((t2 And &HFF&)) Xor rk(3 + j)
    Loop
#End If ' full unroll
    '    /*
    '     * apply last round and
    '     * map cipher state to byte array block:
    '     */
    CT(0) = (Te4((LshR(t0, 24))) And &HFF000000) Xor _
        (Te4((LshR(t1, 16) And &HFF&)) And &HFF0000) Xor _
        (Te4((LshR(t2, 8) And &HFF&)) And &HFF00&) Xor _
        (Te4((t3 And &HFF&)) And &HFF&) Xor _
        rk(0 + j)
    CT(1) = (Te4((LshR(t1, 24))) And &HFF000000) Xor _
        (Te4((LshR(t2, 16) And &HFF&)) And &HFF0000) Xor _
        (Te4((LshR(t3, 8) And &HFF&)) And &HFF00&) Xor _
        (Te4((t0 And &HFF&)) And &HFF&) Xor _
        rk(1 + j)
    CT(2) = (Te4((LshR(t2, 24))) And &HFF000000) Xor _
        (Te4((LshR(t3, 16) And &HFF&)) And &HFF0000) Xor _
        (Te4((LshR(t0, 8) And &HFF&)) And &HFF00&) Xor _
        (Te4((t1 And &HFF&)) And &HFF&) Xor _
        rk(2 + j)
    CT(3) = (Te4((LshR(t3, 24))) And &HFF000000) Xor _
        (Te4((LshR(t0, 16) And &HFF&)) And &HFF0000) Xor _
        (Te4((LshR(t1, 8) And &HFF&)) And &HFF00&) Xor _
        (Te4((t2 And &HFF&)) And &HFF&) Xor _
        rk(3 + j)
End Sub

' Original C Source for rijndaelEncrypt
'void rijndaelEncrypt(const u32 rk[/*4*(Nr + 1)*/], int Nr, const u8 pt[16], u8 ct[16]) {
'    u32 s0, s1, s2, s3, t0, t1, t2, t3;
'#ifndef FULL_UNROLL
'    int r;
'#endif /* ?FULL_UNROLL */
'
'    /*
'     * map byte array block to cipher state
'     * and add initial round key:
'     */
'    s0 = GETU32(pt     ) ^ rk[0];
'    s1 = GETU32(pt +  4) ^ rk[1];
'    s2 = GETU32(pt +  8) ^ rk[2];
'    s3 = GETU32(pt + 12) ^ rk[3];
'#ifdef FULL_UNROLL
'    /* round 1: */
'    t0 = Te0[s0 >> 24] ^ Te1[(s1 >> 16) & 0xff] ^ Te2[(s2 >>  8) & 0xff] ^ Te3[s3 & 0xff] ^ rk[ 4];
'    t1 = Te0[s1 >> 24] ^ Te1[(s2 >> 16) & 0xff] ^ Te2[(s3 >>  8) & 0xff] ^ Te3[s0 & 0xff] ^ rk[ 5];
'    t2 = Te0[s2 >> 24] ^ Te1[(s3 >> 16) & 0xff] ^ Te2[(s0 >>  8) & 0xff] ^ Te3[s1 & 0xff] ^ rk[ 6];
'    t3 = Te0[s3 >> 24] ^ Te1[(s0 >> 16) & 0xff] ^ Te2[(s1 >>  8) & 0xff] ^ Te3[s2 & 0xff] ^ rk[ 7];
'    /* round 2: */
'    s0 = Te0[t0 >> 24] ^ Te1[(t1 >> 16) & 0xff] ^ Te2[(t2 >>  8) & 0xff] ^ Te3[t3 & 0xff] ^ rk[ 8];
'    s1 = Te0[t1 >> 24] ^ Te1[(t2 >> 16) & 0xff] ^ Te2[(t3 >>  8) & 0xff] ^ Te3[t0 & 0xff] ^ rk[ 9];
'    s2 = Te0[t2 >> 24] ^ Te1[(t3 >> 16) & 0xff] ^ Te2[(t0 >>  8) & 0xff] ^ Te3[t1 & 0xff] ^ rk[10];
'    s3 = Te0[t3 >> 24] ^ Te1[(t0 >> 16) & 0xff] ^ Te2[(t1 >>  8) & 0xff] ^ Te3[t2 & 0xff] ^ rk[11];
'    /* round 3: */
'    t0 = Te0[s0 >> 24] ^ Te1[(s1 >> 16) & 0xff] ^ Te2[(s2 >>  8) & 0xff] ^ Te3[s3 & 0xff] ^ rk[12];
'    t1 = Te0[s1 >> 24] ^ Te1[(s2 >> 16) & 0xff] ^ Te2[(s3 >>  8) & 0xff] ^ Te3[s0 & 0xff] ^ rk[13];
'    t2 = Te0[s2 >> 24] ^ Te1[(s3 >> 16) & 0xff] ^ Te2[(s0 >>  8) & 0xff] ^ Te3[s1 & 0xff] ^ rk[14];
'    t3 = Te0[s3 >> 24] ^ Te1[(s0 >> 16) & 0xff] ^ Te2[(s1 >>  8) & 0xff] ^ Te3[s2 & 0xff] ^ rk[15];
'    /* round 4: */
'    s0 = Te0[t0 >> 24] ^ Te1[(t1 >> 16) & 0xff] ^ Te2[(t2 >>  8) & 0xff] ^ Te3[t3 & 0xff] ^ rk[16];
'    s1 = Te0[t1 >> 24] ^ Te1[(t2 >> 16) & 0xff] ^ Te2[(t3 >>  8) & 0xff] ^ Te3[t0 & 0xff] ^ rk[17];
'    s2 = Te0[t2 >> 24] ^ Te1[(t3 >> 16) & 0xff] ^ Te2[(t0 >>  8) & 0xff] ^ Te3[t1 & 0xff] ^ rk[18];
'    s3 = Te0[t3 >> 24] ^ Te1[(t0 >> 16) & 0xff] ^ Te2[(t1 >>  8) & 0xff] ^ Te3[t2 & 0xff] ^ rk[19];
'    /* round 5: */
'    t0 = Te0[s0 >> 24] ^ Te1[(s1 >> 16) & 0xff] ^ Te2[(s2 >>  8) & 0xff] ^ Te3[s3 & 0xff] ^ rk[20];
'    t1 = Te0[s1 >> 24] ^ Te1[(s2 >> 16) & 0xff] ^ Te2[(s3 >>  8) & 0xff] ^ Te3[s0 & 0xff] ^ rk[21];
'    t2 = Te0[s2 >> 24] ^ Te1[(s3 >> 16) & 0xff] ^ Te2[(s0 >>  8) & 0xff] ^ Te3[s1 & 0xff] ^ rk[22];
'    t3 = Te0[s3 >> 24] ^ Te1[(s0 >> 16) & 0xff] ^ Te2[(s1 >>  8) & 0xff] ^ Te3[s2 & 0xff] ^ rk[23];
'    /* round 6: */
'    s0 = Te0[t0 >> 24] ^ Te1[(t1 >> 16) & 0xff] ^ Te2[(t2 >>  8) & 0xff] ^ Te3[t3 & 0xff] ^ rk[24];
'    s1 = Te0[t1 >> 24] ^ Te1[(t2 >> 16) & 0xff] ^ Te2[(t3 >>  8) & 0xff] ^ Te3[t0 & 0xff] ^ rk[25];
'    s2 = Te0[t2 >> 24] ^ Te1[(t3 >> 16) & 0xff] ^ Te2[(t0 >>  8) & 0xff] ^ Te3[t1 & 0xff] ^ rk[26];
'    s3 = Te0[t3 >> 24] ^ Te1[(t0 >> 16) & 0xff] ^ Te2[(t1 >>  8) & 0xff] ^ Te3[t2 & 0xff] ^ rk[27];
'    /* round 7: */
'    t0 = Te0[s0 >> 24] ^ Te1[(s1 >> 16) & 0xff] ^ Te2[(s2 >>  8) & 0xff] ^ Te3[s3 & 0xff] ^ rk[28];
'    t1 = Te0[s1 >> 24] ^ Te1[(s2 >> 16) & 0xff] ^ Te2[(s3 >>  8) & 0xff] ^ Te3[s0 & 0xff] ^ rk[29];
'    t2 = Te0[s2 >> 24] ^ Te1[(s3 >> 16) & 0xff] ^ Te2[(s0 >>  8) & 0xff] ^ Te3[s1 & 0xff] ^ rk[30];
'    t3 = Te0[s3 >> 24] ^ Te1[(s0 >> 16) & 0xff] ^ Te2[(s1 >>  8) & 0xff] ^ Te3[s2 & 0xff] ^ rk[31];
'    /* round 8: */
'    s0 = Te0[t0 >> 24] ^ Te1[(t1 >> 16) & 0xff] ^ Te2[(t2 >>  8) & 0xff] ^ Te3[t3 & 0xff] ^ rk[32];
'    s1 = Te0[t1 >> 24] ^ Te1[(t2 >> 16) & 0xff] ^ Te2[(t3 >>  8) & 0xff] ^ Te3[t0 & 0xff] ^ rk[33];
'    s2 = Te0[t2 >> 24] ^ Te1[(t3 >> 16) & 0xff] ^ Te2[(t0 >>  8) & 0xff] ^ Te3[t1 & 0xff] ^ rk[34];
'    s3 = Te0[t3 >> 24] ^ Te1[(t0 >> 16) & 0xff] ^ Te2[(t1 >>  8) & 0xff] ^ Te3[t2 & 0xff] ^ rk[35];
'    /* round 9: */
'    t0 = Te0[s0 >> 24] ^ Te1[(s1 >> 16) & 0xff] ^ Te2[(s2 >>  8) & 0xff] ^ Te3[s3 & 0xff] ^ rk[36];
'    t1 = Te0[s1 >> 24] ^ Te1[(s2 >> 16) & 0xff] ^ Te2[(s3 >>  8) & 0xff] ^ Te3[s0 & 0xff] ^ rk[37];
'    t2 = Te0[s2 >> 24] ^ Te1[(s3 >> 16) & 0xff] ^ Te2[(s0 >>  8) & 0xff] ^ Te3[s1 & 0xff] ^ rk[38];
'    t3 = Te0[s3 >> 24] ^ Te1[(s0 >> 16) & 0xff] ^ Te2[(s1 >>  8) & 0xff] ^ Te3[s2 & 0xff] ^ rk[39];
'    if (Nr > 10) {
'        /* round 10: */
'        s0 = Te0[t0 >> 24] ^ Te1[(t1 >> 16) & 0xff] ^ Te2[(t2 >>  8) & 0xff] ^ Te3[t3 & 0xff] ^ rk[40];
'        s1 = Te0[t1 >> 24] ^ Te1[(t2 >> 16) & 0xff] ^ Te2[(t3 >>  8) & 0xff] ^ Te3[t0 & 0xff] ^ rk[41];
'        s2 = Te0[t2 >> 24] ^ Te1[(t3 >> 16) & 0xff] ^ Te2[(t0 >>  8) & 0xff] ^ Te3[t1 & 0xff] ^ rk[42];
'        s3 = Te0[t3 >> 24] ^ Te1[(t0 >> 16) & 0xff] ^ Te2[(t1 >>  8) & 0xff] ^ Te3[t2 & 0xff] ^ rk[43];
'        /* round 11: */
'        t0 = Te0[s0 >> 24] ^ Te1[(s1 >> 16) & 0xff] ^ Te2[(s2 >>  8) & 0xff] ^ Te3[s3 & 0xff] ^ rk[44];
'        t1 = Te0[s1 >> 24] ^ Te1[(s2 >> 16) & 0xff] ^ Te2[(s3 >>  8) & 0xff] ^ Te3[s0 & 0xff] ^ rk[45];
'        t2 = Te0[s2 >> 24] ^ Te1[(s3 >> 16) & 0xff] ^ Te2[(s0 >>  8) & 0xff] ^ Te3[s1 & 0xff] ^ rk[46];
'        t3 = Te0[s3 >> 24] ^ Te1[(s0 >> 16) & 0xff] ^ Te2[(s1 >>  8) & 0xff] ^ Te3[s2 & 0xff] ^ rk[47];
'        if (Nr > 12) {
'            /* round 12: */
'            s0 = Te0[t0 >> 24] ^ Te1[(t1 >> 16) & 0xff] ^ Te2[(t2 >>  8) & 0xff] ^ Te3[t3 & 0xff] ^ rk[48];
'            s1 = Te0[t1 >> 24] ^ Te1[(t2 >> 16) & 0xff] ^ Te2[(t3 >>  8) & 0xff] ^ Te3[t0 & 0xff] ^ rk[49];
'            s2 = Te0[t2 >> 24] ^ Te1[(t3 >> 16) & 0xff] ^ Te2[(t0 >>  8) & 0xff] ^ Te3[t1 & 0xff] ^ rk[50];
'            s3 = Te0[t3 >> 24] ^ Te1[(t0 >> 16) & 0xff] ^ Te2[(t1 >>  8) & 0xff] ^ Te3[t2 & 0xff] ^ rk[51];
'            /* round 13: */
'            t0 = Te0[s0 >> 24] ^ Te1[(s1 >> 16) & 0xff] ^ Te2[(s2 >>  8) & 0xff] ^ Te3[s3 & 0xff] ^ rk[52];
'            t1 = Te0[s1 >> 24] ^ Te1[(s2 >> 16) & 0xff] ^ Te2[(s3 >>  8) & 0xff] ^ Te3[s0 & 0xff] ^ rk[53];
'            t2 = Te0[s2 >> 24] ^ Te1[(s3 >> 16) & 0xff] ^ Te2[(s0 >>  8) & 0xff] ^ Te3[s1 & 0xff] ^ rk[54];
'            t3 = Te0[s3 >> 24] ^ Te1[(s0 >> 16) & 0xff] ^ Te2[(s1 >>  8) & 0xff] ^ Te3[s2 & 0xff] ^ rk[55];
'        }
'    }
'    rk += Nr << 2;
'#else  /* !FULL_UNROLL */
'    /*
'     * Nr - 1 full rounds:
'     */
'    r = Nr >> 1;
'    for (;;) {
'        t0 =
'            Te0[(s0 >> 24)       ] ^
'            Te1[(s1 >> 16) & 0xff] ^
'            Te2[(s2 >>  8) & 0xff] ^
'            Te3[(s3      ) & 0xff] ^
'            rk[4];
'        t1 =
'            Te0[(s1 >> 24)       ] ^
'            Te1[(s2 >> 16) & 0xff] ^
'            Te2[(s3 >>  8) & 0xff] ^
'            Te3[(s0      ) & 0xff] ^
'            rk[5];
'        t2 =
'            Te0[(s2 >> 24)       ] ^
'            Te1[(s3 >> 16) & 0xff] ^
'            Te2[(s0 >>  8) & 0xff] ^
'            Te3[(s1      ) & 0xff] ^
'            rk[6];
'        t3 =
'            Te0[(s3 >> 24)       ] ^
'            Te1[(s0 >> 16) & 0xff] ^
'            Te2[(s1 >>  8) & 0xff] ^
'            Te3[(s2      ) & 0xff] ^
'            rk[7];
'
'        rk += 8;
'        if (--r == 0) {
'            break;
'        }
'
'        s0 =
'            Te0[(t0 >> 24)       ] ^
'            Te1[(t1 >> 16) & 0xff] ^
'            Te2[(t2 >>  8) & 0xff] ^
'            Te3[(t3      ) & 0xff] ^
'            rk[0];
'        s1 =
'            Te0[(t1 >> 24)       ] ^
'            Te1[(t2 >> 16) & 0xff] ^
'            Te2[(t3 >>  8) & 0xff] ^
'            Te3[(t0      ) & 0xff] ^
'            rk[1];
'        s2 =
'            Te0[(t2 >> 24)       ] ^
'            Te1[(t3 >> 16) & 0xff] ^
'            Te2[(t0 >>  8) & 0xff] ^
'            Te3[(t1      ) & 0xff] ^
'            rk[2];
'        s3 =
'            Te0[(t3 >> 24)       ] ^
'            Te1[(t0 >> 16) & 0xff] ^
'            Te2[(t1 >>  8) & 0xff] ^
'            Te3[(t2      ) & 0xff] ^
'            rk[3];
'    }
'#endif /* ?FULL_UNROLL */
'    /*
'     * apply last round and
'     * map cipher state to byte array block:
'     */
'    s0 =
'        (Te4[(t0 >> 24)       ] & 0xff000000) ^
'        (Te4[(t1 >> 16) & 0xff] & 0x00ff0000) ^
'        (Te4[(t2 >>  8) & 0xff] & 0x0000ff00) ^
'        (Te4[(t3      ) & 0xff] & 0x000000ff) ^
'        rk[0];
'    PUTU32(ct     , s0);
'    s1 =
'        (Te4[(t1 >> 24)       ] & 0xff000000) ^
'        (Te4[(t2 >> 16) & 0xff] & 0x00ff0000) ^
'        (Te4[(t3 >>  8) & 0xff] & 0x0000ff00) ^
'        (Te4[(t0      ) & 0xff] & 0x000000ff) ^
'        rk[1];
'    PUTU32(ct +  4, s1);
'    s2 =
'        (Te4[(t2 >> 24)       ] & 0xff000000) ^
'        (Te4[(t3 >> 16) & 0xff] & 0x00ff0000) ^
'        (Te4[(t0 >>  8) & 0xff] & 0x0000ff00) ^
'        (Te4[(t1      ) & 0xff] & 0x000000ff) ^
'        rk[2];
'    PUTU32(ct +  8, s2);
'    s3 =
'        (Te4[(t3 >> 24)       ] & 0xff000000) ^
'        (Te4[(t0 >> 16) & 0xff] & 0x00ff0000) ^
'        (Te4[(t1 >>  8) & 0xff] & 0x0000ff00) ^
'        (Te4[(t2      ) & 0xff] & 0x000000ff) ^
'        rk[3];
'    PUTU32(ct + 12, s3);
'}
'

Public Sub rijndaelDecrypt(rk() As Long, Nr As Long, ByRef CT() As Long, ByRef PT() As Long)
Dim s0 As Long, s1 As Long, s2 As Long, s3 As Long, t0 As Long, t1 As Long, t2 As Long, t3 As Long
#If Not FULL_UNROLL Then
Dim r As Long
#End If
Dim j As Long
'
'    /*
'     * map byte array block to cipher state
'     * and add initial round key:
'     */
    s0 = CT(0) Xor rk(0)
    s1 = CT(1) Xor rk(1)
    s2 = CT(2) Xor rk(2)
    s3 = CT(3) Xor rk(3)
#If FULL_UNROLL Then
    '    /* round 1: */
    t0 = Td0((LshR(s0, 24))) Xor Td1((LshR(s3, 16) And &HFF&)) Xor Td2((LshR(s2, 8) And &HFF&)) Xor Td3((s1 And &HFF&)) Xor rk(4)
    t1 = Td0((LshR(s1, 24))) Xor Td1((LshR(s0, 16) And &HFF&)) Xor Td2((LshR(s3, 8) And &HFF&)) Xor Td3((s2 And &HFF&)) Xor rk(5)
    t2 = Td0((LshR(s2, 24))) Xor Td1((LshR(s1, 16) And &HFF&)) Xor Td2((LshR(s0, 8) And &HFF&)) Xor Td3((s3 And &HFF&)) Xor rk(6)
    t3 = Td0((LshR(s3, 24))) Xor Td1((LshR(s2, 16) And &HFF&)) Xor Td2((LshR(s1, 8) And &HFF&)) Xor Td3((s0 And &HFF&)) Xor rk(7)
    '    /* round 2: */
    s0 = Td0((LshR(t0, 24))) Xor Td1((LshR(t3, 16) And &HFF&)) Xor Td2((LshR(t2, 8) And &HFF&)) Xor Td3((t1 And &HFF&)) Xor rk(8)
    s1 = Td0((LshR(t1, 24))) Xor Td1((LshR(t0, 16) And &HFF&)) Xor Td2((LshR(t3, 8) And &HFF&)) Xor Td3((t2 And &HFF&)) Xor rk(9)
    s2 = Td0((LshR(t2, 24))) Xor Td1((LshR(t1, 16) And &HFF&)) Xor Td2((LshR(t0, 8) And &HFF&)) Xor Td3((t3 And &HFF&)) Xor rk(10)
    s3 = Td0((LshR(t3, 24))) Xor Td1((LshR(t2, 16) And &HFF&)) Xor Td2((LshR(t1, 8) And &HFF&)) Xor Td3((t0 And &HFF&)) Xor rk(11)
    '    /* round 3: */
    t0 = Td0((LshR(s0, 24))) Xor Td1((LshR(s3, 16) And &HFF&)) Xor Td2((LshR(s2, 8) And &HFF&)) Xor Td3((s1 And &HFF&)) Xor rk(12)
    t1 = Td0((LshR(s1, 24))) Xor Td1((LshR(s0, 16) And &HFF&)) Xor Td2((LshR(s3, 8) And &HFF&)) Xor Td3((s2 And &HFF&)) Xor rk(13)
    t2 = Td0((LshR(s2, 24))) Xor Td1((LshR(s1, 16) And &HFF&)) Xor Td2((LshR(s0, 8) And &HFF&)) Xor Td3((s3 And &HFF&)) Xor rk(14)
    t3 = Td0((LshR(s3, 24))) Xor Td1((LshR(s2, 16) And &HFF&)) Xor Td2((LshR(s1, 8) And &HFF&)) Xor Td3((s0 And &HFF&)) Xor rk(15)
    '    /* round 4: */
    s0 = Td0((LshR(t0, 24))) Xor Td1((LshR(t3, 16) And &HFF&)) Xor Td2((LshR(t2, 8) And &HFF&)) Xor Td3((t1 And &HFF&)) Xor rk(16)
    s1 = Td0((LshR(t1, 24))) Xor Td1((LshR(t0, 16) And &HFF&)) Xor Td2((LshR(t3, 8) And &HFF&)) Xor Td3((t2 And &HFF&)) Xor rk(17)
    s2 = Td0((LshR(t2, 24))) Xor Td1((LshR(t1, 16) And &HFF&)) Xor Td2((LshR(t0, 8) And &HFF&)) Xor Td3((t3 And &HFF&)) Xor rk(18)
    s3 = Td0((LshR(t3, 24))) Xor Td1((LshR(t2, 16) And &HFF&)) Xor Td2((LshR(t1, 8) And &HFF&)) Xor Td3((t0 And &HFF&)) Xor rk(19)
    '    /* round 5: */
    t0 = Td0((LshR(s0, 24))) Xor Td1((LshR(s3, 16) And &HFF&)) Xor Td2((LshR(s2, 8) And &HFF&)) Xor Td3((s1 And &HFF&)) Xor rk(20)
    t1 = Td0((LshR(s1, 24))) Xor Td1((LshR(s0, 16) And &HFF&)) Xor Td2((LshR(s3, 8) And &HFF&)) Xor Td3((s2 And &HFF&)) Xor rk(21)
    t2 = Td0((LshR(s2, 24))) Xor Td1((LshR(s1, 16) And &HFF&)) Xor Td2((LshR(s0, 8) And &HFF&)) Xor Td3((s3 And &HFF&)) Xor rk(22)
    t3 = Td0((LshR(s3, 24))) Xor Td1((LshR(s2, 16) And &HFF&)) Xor Td2((LshR(s1, 8) And &HFF&)) Xor Td3((s0 And &HFF&)) Xor rk(23)
    '    /* round 6: */
    s0 = Td0((LshR(t0, 24))) Xor Td1((LshR(t3, 16) And &HFF&)) Xor Td2((LshR(t2, 8) And &HFF&)) Xor Td3((t1 And &HFF&)) Xor rk(24)
    s1 = Td0((LshR(t1, 24))) Xor Td1((LshR(t0, 16) And &HFF&)) Xor Td2((LshR(t3, 8) And &HFF&)) Xor Td3((t2 And &HFF&)) Xor rk(25)
    s2 = Td0((LshR(t2, 24))) Xor Td1((LshR(t1, 16) And &HFF&)) Xor Td2((LshR(t0, 8) And &HFF&)) Xor Td3((t3 And &HFF&)) Xor rk(26)
    s3 = Td0((LshR(t3, 24))) Xor Td1((LshR(t2, 16) And &HFF&)) Xor Td2((LshR(t1, 8) And &HFF&)) Xor Td3((t0 And &HFF&)) Xor rk(27)
    '    /* round 7: */
    t0 = Td0((LshR(s0, 24))) Xor Td1((LshR(s3, 16) And &HFF&)) Xor Td2((LshR(s2, 8) And &HFF&)) Xor Td3((s1 And &HFF&)) Xor rk(28)
    t1 = Td0((LshR(s1, 24))) Xor Td1((LshR(s0, 16) And &HFF&)) Xor Td2((LshR(s3, 8) And &HFF&)) Xor Td3((s2 And &HFF&)) Xor rk(29)
    t2 = Td0((LshR(s2, 24))) Xor Td1((LshR(s1, 16) And &HFF&)) Xor Td2((LshR(s0, 8) And &HFF&)) Xor Td3((s3 And &HFF&)) Xor rk(30)
    t3 = Td0((LshR(s3, 24))) Xor Td1((LshR(s2, 16) And &HFF&)) Xor Td2((LshR(s1, 8) And &HFF&)) Xor Td3((s0 And &HFF&)) Xor rk(31)
    '    /* round 8: */
    s0 = Td0((LshR(t0, 24))) Xor Td1((LshR(t3, 16) And &HFF&)) Xor Td2((LshR(t2, 8) And &HFF&)) Xor Td3((t1 And &HFF&)) Xor rk(32)
    s1 = Td0((LshR(t1, 24))) Xor Td1((LshR(t0, 16) And &HFF&)) Xor Td2((LshR(t3, 8) And &HFF&)) Xor Td3((t2 And &HFF&)) Xor rk(33)
    s2 = Td0((LshR(t2, 24))) Xor Td1((LshR(t1, 16) And &HFF&)) Xor Td2((LshR(t0, 8) And &HFF&)) Xor Td3((t3 And &HFF&)) Xor rk(34)
    s3 = Td0((LshR(t3, 24))) Xor Td1((LshR(t2, 16) And &HFF&)) Xor Td2((LshR(t1, 8) And &HFF&)) Xor Td3((t0 And &HFF&)) Xor rk(35)
    '    /* round 9: */
    t0 = Td0((LshR(s0, 24))) Xor Td1((LshR(s3, 16) And &HFF&)) Xor Td2((LshR(s2, 8) And &HFF&)) Xor Td3((s1 And &HFF&)) Xor rk(36)
    t1 = Td0((LshR(s1, 24))) Xor Td1((LshR(s0, 16) And &HFF&)) Xor Td2((LshR(s3, 8) And &HFF&)) Xor Td3((s2 And &HFF&)) Xor rk(37)
    t2 = Td0((LshR(s2, 24))) Xor Td1((LshR(s1, 16) And &HFF&)) Xor Td2((LshR(s0, 8) And &HFF&)) Xor Td3((s3 And &HFF&)) Xor rk(38)
    t3 = Td0((LshR(s3, 24))) Xor Td1((LshR(s2, 16) And &HFF&)) Xor Td2((LshR(s1, 8) And &HFF&)) Xor Td3((s0 And &HFF&)) Xor rk(39)
    If Nr > 10 Then
        '        /* round 10: */
        s0 = Td0((LshR(t0, 24))) Xor Td1((LshR(t3, 16) And &HFF&)) Xor Td2((LshR(t2, 8) And &HFF&)) Xor Td3((t1 And &HFF&)) Xor rk(40)
        s1 = Td0((LshR(t1, 24))) Xor Td1((LshR(t0, 16) And &HFF&)) Xor Td2((LshR(t3, 8) And &HFF&)) Xor Td3((t2 And &HFF&)) Xor rk(41)
        s2 = Td0((LshR(t2, 24))) Xor Td1((LshR(t1, 16) And &HFF&)) Xor Td2((LshR(t0, 8) And &HFF&)) Xor Td3((t3 And &HFF&)) Xor rk(42)
        s3 = Td0((LshR(t3, 24))) Xor Td1((LshR(t2, 16) And &HFF&)) Xor Td2((LshR(t1, 8) And &HFF&)) Xor Td3((t0 And &HFF&)) Xor rk(43)
        '        /* round 11: */
        t0 = Td0((LshR(s0, 24))) Xor Td1((LshR(s3, 16) And &HFF&)) Xor Td2((LshR(s2, 8) And &HFF&)) Xor Td3((s1 And &HFF&)) Xor rk(44)
        t1 = Td0((LshR(s1, 24))) Xor Td1((LshR(s0, 16) And &HFF&)) Xor Td2((LshR(s3, 8) And &HFF&)) Xor Td3((s2 And &HFF&)) Xor rk(45)
        t2 = Td0((LshR(s2, 24))) Xor Td1((LshR(s1, 16) And &HFF&)) Xor Td2((LshR(s0, 8) And &HFF&)) Xor Td3((s3 And &HFF&)) Xor rk(46)
        t3 = Td0((LshR(s3, 24))) Xor Td1((LshR(s2, 16) And &HFF&)) Xor Td2((LshR(s1, 8) And &HFF&)) Xor Td3((s0 And &HFF&)) Xor rk(47)
        If Nr > 12 Then
            '            /* round 12: */
            s0 = Td0((LshR(t0, 24))) Xor Td1((LshR(t3, 16) And &HFF&)) Xor Td2((LshR(t2, 8) And &HFF&)) Xor Td3((t1 And &HFF&)) Xor rk(48)
            s1 = Td0((LshR(t1, 24))) Xor Td1((LshR(t0, 16) And &HFF&)) Xor Td2((LshR(t3, 8) And &HFF&)) Xor Td3((t2 And &HFF&)) Xor rk(49)
            s2 = Td0((LshR(t2, 24))) Xor Td1((LshR(t1, 16) And &HFF&)) Xor Td2((LshR(t0, 8) And &HFF&)) Xor Td3((t3 And &HFF&)) Xor rk(50)
            s3 = Td0((LshR(t3, 24))) Xor Td1((LshR(t2, 16) And &HFF&)) Xor Td2((LshR(t1, 8) And &HFF&)) Xor Td3((t0 And &HFF&)) Xor rk(51)
            '            /* round 13: */
            t0 = Td0((LshR(s0, 24))) Xor Td1((LshR(s3, 16) And &HFF&)) Xor Td2((LshR(s2, 8) And &HFF&)) Xor Td3((s1 And &HFF&)) Xor rk(52)
            t1 = Td0((LshR(s1, 24))) Xor Td1((LshR(s0, 16) And &HFF&)) Xor Td2((LshR(s3, 8) And &HFF&)) Xor Td3((s2 And &HFF&)) Xor rk(53)
            t2 = Td0((LshR(s2, 24))) Xor Td1((LshR(s1, 16) And &HFF&)) Xor Td2((LshR(s0, 8) And &HFF&)) Xor Td3((s3 And &HFF&)) Xor rk(54)
            t3 = Td0((LshR(s3, 24))) Xor Td1((LshR(s2, 16) And &HFF&)) Xor Td2((LshR(s1, 8) And &HFF&)) Xor Td3((s0 And &HFF&)) Xor rk(55)
        End If
    End If
    j = LshL(Nr, 2)
#Else ' not full unroll
    '    /*
    '     * Nr - 1 full rounds:
    '     */
    r = LshR(Nr, 1)
    j = 0
    Do
        t0 = Td0((LshR(s0, 24))) Xor Td1((LshR(s3, 16) And &HFF&)) Xor Td2((LshR(s2, 8) And &HFF&)) Xor Td3((s1 And &HFF&)) Xor rk(4 + j)
        t1 = Td0((LshR(s1, 24))) Xor Td1((LshR(s0, 16) And &HFF&)) Xor Td2((LshR(s3, 8) And &HFF&)) Xor Td3((s2 And &HFF&)) Xor rk(5 + j)
        t2 = Td0((LshR(s2, 24))) Xor Td1((LshR(s1, 16) And &HFF&)) Xor Td2((LshR(s0, 8) And &HFF&)) Xor Td3((s3 And &HFF&)) Xor rk(6 + j)
        t3 = Td0((LshR(s3, 24))) Xor Td1((LshR(s2, 16) And &HFF&)) Xor Td2((LshR(s1, 8) And &HFF&)) Xor Td3((s0 And &HFF&)) Xor rk(7 + j)
        j = j + 8
        r = r - 1
        If r = 0 Then
            Exit Do
        End If
        s0 = Td0((LshR(t0, 24))) Xor Td1((LshR(t3, 16) And &HFF&)) Xor Td2((LshR(t2, 8) And &HFF&)) Xor Td3((t1 And &HFF&)) Xor rk(0 + j)
        s1 = Td0((LshR(t1, 24))) Xor Td1((LshR(t0, 16) And &HFF&)) Xor Td2((LshR(t3, 8) And &HFF&)) Xor Td3((t2 And &HFF&)) Xor rk(1 + j)
        s2 = Td0((LshR(t2, 24))) Xor Td1((LshR(t1, 16) And &HFF&)) Xor Td2((LshR(t0, 8) And &HFF&)) Xor Td3((t3 And &HFF&)) Xor rk(2 + j)
        s3 = Td0((LshR(t3, 24))) Xor Td1((LshR(t2, 16) And &HFF&)) Xor Td2((LshR(t1, 8) And &HFF&)) Xor Td3((t0 And &HFF&)) Xor rk(3 + j)
    Loop
#End If ' full unroll
    '    /*
    '     * apply last round and
    '     * map cipher state to byte array block:
    '     */
    PT(0) = (Td4((LshR(t0, 24))) And &HFF000000) Xor _
        (Td4((LshR(t3, 16) And &HFF&)) And &HFF0000) Xor _
        (Td4((LshR(t2, 8) And &HFF&)) And &HFF00&) Xor _
        (Td4((t1 And &HFF&)) And &HFF&) Xor rk(0 + j)
    PT(1) = (Td4((LshR(t1, 24))) And &HFF000000) Xor _
        (Td4((LshR(t0, 16) And &HFF&)) And &HFF0000) Xor _
        (Td4((LshR(t3, 8) And &HFF&)) And &HFF00&) Xor _
        (Td4((t2 And &HFF&)) And &HFF&) Xor rk(1 + j)
    PT(2) = (Td4((LshR(t2, 24))) And &HFF000000) Xor _
        (Td4((LshR(t1, 16) And &HFF&)) And &HFF0000) Xor _
        (Td4((LshR(t0, 8) And &HFF&)) And &HFF00&) Xor _
        (Td4((t3 And &HFF&)) And &HFF&) Xor rk(2 + j)
    PT(3) = (Td4((LshR(t3, 24))) And &HFF000000) Xor _
        (Td4((LshR(t2, 16) And &HFF&)) And &HFF0000) Xor _
        (Td4((LshR(t1, 8) And &HFF&)) And &HFF00&) Xor _
        (Td4((t0 And &HFF&)) And &HFF&) Xor rk(3 + j)
End Sub

'
'#ifdef INTERMEDIATE_VALUE_KAT
'
Public Sub rijndaelEncryptRound(ByRef rk() As Long, Nr As Long, ByRef Block() As Long, Rounds As Long)
Dim r As Long, q As Long
Dim s0 As Long, s1 As Long, s2 As Long, s3 As Long, t0 As Long, t1 As Long, t2 As Long, t3 As Long
Dim j As Long

'    /*
'     * map byte array block to cipher state
'     * and add initial round key:
'     */
    s0 = Block(0) Xor rk(0)
    s1 = Block(1) Xor rk(1)
    s2 = Block(2) Xor rk(2)
    s3 = Block(3) Xor rk(3)
    j = 4
    '    /*
    '     * Nr - 1 full rounds:
    '     */
    If Rounds < Nr Then
        q = Rounds
    Else
        q = Nr - 1
    End If
    For r = q To 1 Step -1
        t0 = Te0((LshR(s0, 24))) Xor _
            Te1((LshR(s1, 16) And &HFF&)) Xor _
            Te2((LshR(s2, 8) And &HFF&)) Xor _
            Te3((s3 And &HFF&)) Xor _
            rk(0 + j)
        t1 = Te0((LshR(s1, 24))) Xor _
            Te1((LshR(s2, 16) And &HFF&)) Xor _
            Te2((LshR(s3, 8) And &HFF&)) Xor _
            Te3((s0 And &HFF&)) Xor _
            rk(1 + j)
        t2 = Te0((LshR(s2, 24))) Xor _
            Te1((LshR(s3, 16) And &HFF&)) Xor _
            Te2((LshR(s0, 8) And &HFF&)) Xor _
            Te3((s1 And &HFF&)) Xor _
            rk(2 + j)
        t3 = Te0((LshR(s3, 24))) Xor _
            Te1((LshR(s0, 16) And &HFF&)) Xor _
            Te2((LshR(s1, 8) And &HFF&)) Xor _
            Te3((s2 And &HFF&)) Xor _
            rk(3 + j)
        s0 = t0
        s1 = t1
        s2 = t2
        s3 = t3
        j = j + 4
    Next
    '    /*
    '     * apply last round and
    '     * map cipher state to byte array block:
    '     */
    If Rounds = Nr Then
        t0 = (Te4((LshR(s0, 24))) And &HFF000000) Xor _
            (Te4((LshR(s1, 16) And &HFF&)) And &HFF0000) Xor _
            (Te4((LshR(s2, 8) And &HFF&)) And &HFF00&) Xor _
            (Te4((s3 And &HFF&)) And &HFF&) Xor _
            rk(0 + j)
        t1 = (Te4((LshR(s1, 24))) And &HFF000000) Xor _
            (Te4((LshR(s2, 16) And &HFF&)) And &HFF0000) Xor _
            (Te4((LshR(s3, 8) And &HFF&)) And &HFF00&) Xor _
            (Te4((s0 And &HFF&)) And &HFF&) Xor _
            rk(1 + j)
        t2 = (Te4((LshR(s2, 24))) And &HFF000000) Xor _
            (Te4((LshR(s3, 16) And &HFF&)) And &HFF0000) Xor _
            (Te4((LshR(s0, 8) And &HFF&)) And &HFF00&) Xor _
            (Te4((s1 And &HFF&)) And &HFF&) Xor _
            rk(2 + j)
        t3 = (Te4((LshR(s3, 24))) And &HFF000000) Xor _
            (Te4((LshR(s0, 16) And &HFF&)) And &HFF0000) Xor _
            (Te4((LshR(s1, 8) And &HFF&)) And &HFF00&) Xor _
            (Te4((s2 And &HFF&)) And &HFF&) Xor _
            rk(3 + j)
        s0 = t0
        s1 = t1
        s2 = t2
        s3 = t3
    End If
    Block(0) = s0
    Block(1) = s1
    Block(2) = s2
    Block(3) = s3
End Sub

' Original C Source for rijndaelEncryptRound
'void rijndaelEncryptRound(const u32 rk[/*4*(Nr + 1)*/], int Nr, u8 block[16], int rounds) {
'    int r;
'    u32 s0, s1, s2, s3, t0, t1, t2, t3;
'
'    /*
'     * map byte array block to cipher state
'     * and add initial round key:
'     */
'    s0 = GETU32(block     ) ^ rk[0];
'    s1 = GETU32(block +  4) ^ rk[1];
'    s2 = GETU32(block +  8) ^ rk[2];
'    s3 = GETU32(block + 12) ^ rk[3];
'    rk += 4;
'
'    /*
'     * Nr - 1 full rounds:
'     */
'    for (r = (rounds < Nr ? rounds : Nr - 1); r > 0; r--) {
'        t0 =
'            Te0[(s0 >> 24)       ] ^
'            Te1[(s1 >> 16) & 0xff] ^
'            Te2[(s2 >>  8) & 0xff] ^
'            Te3[(s3      ) & 0xff] ^
'            rk[0];
'        t1 =
'            Te0[(s1 >> 24)       ] ^
'            Te1[(s2 >> 16) & 0xff] ^
'            Te2[(s3 >>  8) & 0xff] ^
'            Te3[(s0      ) & 0xff] ^
'            rk[1];
'        t2 =
'            Te0[(s2 >> 24)       ] ^
'            Te1[(s3 >> 16) & 0xff] ^
'            Te2[(s0 >>  8) & 0xff] ^
'            Te3[(s1      ) & 0xff] ^
'            rk[2];
'        t3 =
'            Te0[(s3 >> 24)       ] ^
'            Te1[(s0 >> 16) & 0xff] ^
'            Te2[(s1 >>  8) & 0xff] ^
'            Te3[(s2      ) & 0xff] ^
'            rk[3];
'
'        s0 = t0;
'        s1 = t1;
'        s2 = t2;
'        s3 = t3;
'        rk += 4;
'
'    }
'
'    /*
'     * apply last round and
'     * map cipher state to byte array block:
'     */
'    if (rounds == Nr) {
'        t0 =
'            (Te4[(s0 >> 24)       ] & 0xff000000) ^
'            (Te4[(s1 >> 16) & 0xff] & 0x00ff0000) ^
'            (Te4[(s2 >>  8) & 0xff] & 0x0000ff00) ^
'            (Te4[(s3      ) & 0xff] & 0x000000ff) ^
'            rk[0];
'        t1 =
'            (Te4[(s1 >> 24)       ] & 0xff000000) ^
'            (Te4[(s2 >> 16) & 0xff] & 0x00ff0000) ^
'            (Te4[(s3 >>  8) & 0xff] & 0x0000ff00) ^
'            (Te4[(s0      ) & 0xff] & 0x000000ff) ^
'            rk[1];
'        t2 =
'            (Te4[(s2 >> 24)       ] & 0xff000000) ^
'            (Te4[(s3 >> 16) & 0xff] & 0x00ff0000) ^
'            (Te4[(s0 >>  8) & 0xff] & 0x0000ff00) ^
'            (Te4[(s1      ) & 0xff] & 0x000000ff) ^
'            rk[2];
'        t3 =
'            (Te4[(s3 >> 24)       ] & 0xff000000) ^
'            (Te4[(s0 >> 16) & 0xff] & 0x00ff0000) ^
'            (Te4[(s1 >>  8) & 0xff] & 0x0000ff00) ^
'            (Te4[(s2      ) & 0xff] & 0x000000ff) ^
'            rk[3];
'
'        s0 = t0;
'        s1 = t1;
'        s2 = t2;
'        s3 = t3;
'    }
'
'    PUTU32(block     , s0);
'    PUTU32(block +  4, s1);
'    PUTU32(block +  8, s2);
'    PUTU32(block + 12, s3);
'}

Public Sub rijndaelDecryptRound(rk() As Long, Nr As Long, ByRef Block() As Long, Rounds As Long)
Dim r As Long, q As Long
Dim s0 As Long, s1 As Long, s2 As Long, s3 As Long, s4 As Long, t0 As Long, t1 As Long, t2 As Long, t3 As Long
Dim j As Long

    s0 = Block(0) Xor rk(0)
    s1 = Block(1) Xor rk(1)
    s2 = Block(2) Xor rk(2)
    s3 = Block(3) Xor rk(3)
    j = 4
    '    /*
    '     * Nr - 1 full rounds:
    '     */
    If Rounds < Nr Then
        q = Rounds - 2
    Else
        q = Nr - 2
    End If
    For r = q To 0 Step -1
        t0 = Td0((LshR(s0, 24))) Xor _
            Td1((LshR(s3, 16) And &HFF&)) Xor _
            Td2((LshR(s2, 8) And &HFF&)) Xor _
            Td3((s1 And &HFF&)) Xor _
            rk(0 + j)
        t1 = Td0((LshR(s1, 24))) Xor _
            Td1((LshR(s0, 16) And &HFF&)) Xor _
            Td2((LshR(s3, 8) And &HFF&)) Xor _
            Td3((s2 And &HFF&)) Xor _
            rk(1 + j)
        t2 = Td0((LshR(s2, 24))) Xor _
            Td1((LshR(s1, 16) And &HFF&)) Xor _
            Td2((LshR(s0, 8) And &HFF&)) Xor _
            Td3((s3 And &HFF&)) Xor _
            rk(2 + j)
        t3 = Td0((LshR(s3, 24))) Xor _
            Td1((LshR(s2, 16) And &HFF&)) Xor _
            Td2((LshR(s1, 8) And &HFF&)) Xor _
            Td3((s0 And &HFF&)) Xor _
            rk(3 + j)
        s0 = t0
        s1 = t1
        s2 = t2
        s3 = t3
        j = j + 4
    Next
    '
    '    /*
    '     * complete the last round and
    '     * map cipher state to byte array block:
    '     */
    t0 = (Td4((LshR(s0, 24))) And &HFF000000) Xor _
        (Td4((LshR(s3, 16) And &HFF&)) And &HFF0000) Xor _
        (Td4((LshR(s2, 8) And &HFF&)) And &HFF00&) Xor _
        (Td4((s1 And &HFF&)) And &HFF&)
    t1 = (Td4((LshR(s1, 24))) And &HFF000000) Xor _
        (Td4((LshR(s0, 16) And &HFF&)) And &HFF0000) Xor _
        (Td4((LshR(s3, 8) And &HFF&)) And &HFF00&) Xor _
        (Td4((s2 And &HFF&)) And &HFF&)
    t2 = (Td4((LshR(s2, 24))) And &HFF000000) Xor _
        (Td4((LshR(s1, 16) And &HFF&)) And &HFF0000) Xor _
        (Td4((LshR(s0, 8) And &HFF&)) And &HFF00&) Xor _
        (Td4((s3 And &HFF&)) And &HFF&)
    t3 = (Td4((LshR(s3, 24))) And &HFF000000) Xor _
        (Td4((LshR(s2, 16) And &HFF&)) And &HFF0000) Xor _
        (Td4((LshR(s1, 8) And &HFF&)) And &HFF00&) Xor _
        (Td4((s0 And &HFF&)) And &HFF&)
        
    If Rounds = Nr Then
        t0 = t0 Xor rk(0 + j)
        t1 = t1 Xor rk(1 + j)
        t2 = t2 Xor rk(2 + j)
        t3 = t3 Xor rk(3 + j)
    End If
    Block(0) = t0
    Block(1) = t1
    Block(2) = t2
    Block(3) = t3
End Sub

' Original C-Source for rijndaelDecryptRound
'void rijndaelDecryptRound(const u32 rk[/*4*(Nr + 1)*/], int Nr, u8 block[16], int rounds) {
'    int r;
'    u32 s0, s1, s2, s3, t0, t1, t2, t3;
'
'    /*
'     * map byte array block to cipher state
'     * and add initial round key:
'     */
'    s0 = GETU32(block     ) ^ rk[0];
'    s1 = GETU32(block +  4) ^ rk[1];
'    s2 = GETU32(block +  8) ^ rk[2];
'    s3 = GETU32(block + 12) ^ rk[3];
'    rk += 4;
'
'    /*
'     * Nr - 1 full rounds:
'     */
'    for (r = (rounds < Nr ? rounds : Nr) - 1; r > 0; r--) {
'        t0 =
'            Td0[(s0 >> 24)       ] ^
'            Td1[(s3 >> 16) & 0xff] ^
'            Td2[(s2 >>  8) & 0xff] ^
'            Td3[(s1      ) & 0xff] ^
'            rk[0];
'        t1 =
'            Td0[(s1 >> 24)       ] ^
'            Td1[(s0 >> 16) & 0xff] ^
'            Td2[(s3 >>  8) & 0xff] ^
'            Td3[(s2      ) & 0xff] ^
'            rk[1];
'        t2 =
'            Td0[(s2 >> 24)       ] ^
'            Td1[(s1 >> 16) & 0xff] ^
'            Td2[(s0 >>  8) & 0xff] ^
'            Td3[(s3      ) & 0xff] ^
'            rk[2];
'        t3 =
'            Td0[(s3 >> 24)       ] ^
'            Td1[(s2 >> 16) & 0xff] ^
'            Td2[(s1 >>  8) & 0xff] ^
'            Td3[(s0      ) & 0xff] ^
'            rk[3];
'
'        s0 = t0;
'        s1 = t1;
'        s2 = t2;
'        s3 = t3;
'        rk += 4;
'
'    }
'
'    /*
'     * complete the last round and
'     * map cipher state to byte array block:
'     */
'    t0 =
'        (Td4[(s0 >> 24)       ] & 0xff000000) ^
'        (Td4[(s3 >> 16) & 0xff] & 0x00ff0000) ^
'        (Td4[(s2 >>  8) & 0xff] & 0x0000ff00) ^
'        (Td4[(s1      ) & 0xff] & 0x000000ff);
'    t1 =
'        (Td4[(s1 >> 24)       ] & 0xff000000) ^
'        (Td4[(s0 >> 16) & 0xff] & 0x00ff0000) ^
'        (Td4[(s3 >>  8) & 0xff] & 0x0000ff00) ^
'        (Td4[(s2      ) & 0xff] & 0x000000ff);
'    t2 =
'        (Td4[(s2 >> 24)       ] & 0xff000000) ^
'        (Td4[(s1 >> 16) & 0xff] & 0x00ff0000) ^
'        (Td4[(s0 >>  8) & 0xff] & 0x0000ff00) ^
'        (Td4[(s3      ) & 0xff] & 0x000000ff);
'    t3 =
'        (Td4[(s3 >> 24)       ] & 0xff000000) ^
'        (Td4[(s2 >> 16) & 0xff] & 0x00ff0000) ^
'        (Td4[(s1 >>  8) & 0xff] & 0x0000ff00) ^
'        (Td4[(s0      ) & 0xff] & 0x000000ff);
'
'    if (rounds == Nr) {
'        t0 ^= rk[0];
'        t1 ^= rk[1];
'        t2 ^= rk[2];
'        t3 ^= rk[3];
'    }
'
'    PUTU32(block     , t0);
'    PUTU32(block +  4, t1);
'    PUTU32(block +  8, t2);
'    PUTU32(block + 12, t3);
'}
'
'#endif /* INTERMEDIATE_VALUE_KAT */
