VERSION 5.00
Object = "{248DD890-BB45-11CF-9ABC-0080C7E7B78D}#1.0#0"; "MSWINSCK.OCX"
Object = "{3B7C8863-D78F-101B-B9B5-04021C009402}#1.2#0"; "richtx32.ocx"
Begin VB.Form frmTelnetClient 
   BackColor       =   &H00C0E0FF&
   Caption         =   "BugMaster Telnet Client"
   ClientHeight    =   5640
   ClientLeft      =   165
   ClientTop       =   450
   ClientWidth     =   11160
   LinkTopic       =   "Form1"
   ScaleHeight     =   5640
   ScaleWidth      =   11160
   StartUpPosition =   3  'Windows Default
   Begin MSWinsockLib.Winsock Winsock1 
      Left            =   6480
      Top             =   0
      _ExtentX        =   741
      _ExtentY        =   741
      _Version        =   393216
   End
   Begin RichTextLib.RichTextBox rtfTerminalScreen 
      Height          =   3975
      Left            =   0
      TabIndex        =   7
      Top             =   1680
      Width           =   11175
      _ExtentX        =   19711
      _ExtentY        =   7011
      _Version        =   393217
      BackColor       =   0
      Enabled         =   0   'False
      ScrollBars      =   2
      DisableNoScroll =   -1  'True
      TextRTF         =   $"frmTelnetClient.frx":0000
   End
   Begin VB.TextBox txtMessages 
      Height          =   1455
      Left            =   3000
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   6
      Top             =   120
      Width           =   8175
   End
   Begin VB.CommandButton cmdConnect 
      Caption         =   "Connect"
      Height          =   375
      Left            =   360
      TabIndex        =   3
      Top             =   1200
      Width           =   1095
   End
   Begin VB.CommandButton cmdDisconnect 
      Caption         =   "Disconnect"
      Height          =   375
      Left            =   1680
      TabIndex        =   2
      Top             =   1200
      Width           =   1095
   End
   Begin VB.TextBox txtHostName 
      Height          =   375
      Left            =   1200
      TabIndex        =   1
      Text            =   "127.0.0.1"
      Top             =   120
      Width           =   1695
   End
   Begin VB.TextBox txtPort 
      Height          =   375
      Left            =   1200
      TabIndex        =   0
      Text            =   "23"
      Top             =   600
      Width           =   1695
   End
   Begin VB.Label lblHostName 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "HostName"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   162
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   240
      TabIndex        =   5
      Top             =   200
      Width           =   900
   End
   Begin VB.Label lblPort 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Port"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   162
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   240
      TabIndex        =   4
      Top             =   650
      Width           =   900
   End
End
Attribute VB_Name = "frmTelnetClient"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim SendCharacter As Integer

Private Sub Form_Load()
   'Returns or sets a value that determines whether keyboard events for forms are invoked
   'before keyboard events for controls.
   Me.KeyPreview = True
   
   'turns selected text color to white
   rtfTerminalScreen.SelColor = vbWhite
   
   'disables disconnect button because you are not connected anywhere in this state
   cmdDisconnect.Enabled = False
End Sub

Private Sub Form_KeyPress(KeyAscii As Integer)
    'If winsock connected then send your text to server
    If Winsock1.State = 7 Then
        SendCharacter = KeyAscii
        Winsock1.SendData Chr(SendCharacter)
    End If
End Sub

Private Sub cmdConnect_Click()
   'check if port numeric or not. if it is not numeric then warn user and exit sub.
   If IsNumeric(txtPort.Text) = False Then
      MsgBox ("default telnet port is 23. Don't write text in that area.")
      Exit Sub
   End If
   
   'Changes mouse pointer to hourglass to show; data in progress
   MousePointer = vbHourglass
   
   'Disables buttons and text boxes
   cmdConnect.Enabled = False
   txtHostName.Enabled = False
   txtPort.Enabled = False
   
   'clears the data messages
   rtfTerminalScreen.Text = ""
   
   'write connecting status
   Write2StatusBox "Connecting to: " & txtHostName.Text & " Port " & txtPort.Text & vbCrLf
   
   'Connects to the server with the port given by user
   Winsock1.Connect CStr(txtHostName.Text), CStr(txtPort.Text)
End Sub

Private Sub Winsock1_Connect()
   'write connecting status
   Write2StatusBox "Connection to the server is successful" & vbCrLf
   
   'Enables disconnection button
   cmdDisconnect.Enabled = True
End Sub

Private Sub Winsock1_DataArrival(ByVal bytesTotal As Long)
   Dim strData As String
   
   On Error Resume Next
   
   'gets data from server you connected
   Winsock1.GetData strData
   strData = Replace(strData, Chr$(10), vbCrLf)
   
   'write data to the screen
   rtfTerminalScreen.Text = rtfTerminalScreen.Text & strData
   
   'selects all text in richtext box. This is for going end of text everytime. A little trick :)
   rtfTerminalScreen.SelStart = 0
   rtfTerminalScreen.SelLength = Len(rtfTerminalScreen.Text)
   
   'Changes mouse pointer to default
   MousePointer = vbDefault
End Sub

Private Sub Winsock1_Error(ByVal Number As Integer, Description As String, ByVal Scode As Long, ByVal Source As String, ByVal HelpFile As String, ByVal HelpContext As Long, CancelDisplay As Boolean)
   'Write Winsock Error
   Write2StatusBox "A Winsock Error has occurred.  Error No. " & Number & " " & Description & vbCrLf
   
   'Changes mouse pointer to default
   MousePointer = vbDefault
   
   'Enables buttons and text boxes
   cmdConnect.Enabled = True
   txtHostName.Enabled = True
   txtPort.Enabled = True
   
   'Disables disconnection button
   cmdDisconnect.Enabled = False
   
   'Close winsock connection
   Winsock1.Close
End Sub

Private Sub Winsock1_Close()
   Call cmdDisconnect_Click
End Sub

Private Sub cmdDisconnect_Click()
   'Write Winsock Error
   Write2StatusBox "Disconnected from server" & vbCrLf
   
   'Changes mouse pointer to default
   MousePointer = vbDefault
   
   'Enables buttons and text boxes
   cmdConnect.Enabled = True
   txtHostName.Enabled = True
   txtPort.Enabled = True
   
   'Disables disconnection button
   cmdDisconnect.Enabled = False
   
   'Close winsock connection
   Winsock1.Close
End Sub

Sub Write2StatusBox(MessageEntry As String)
   'Add a line to Server Messages List
   With txtMessages
      .Text = .Text + MessageEntry
      .SelStart = Len(.Text)
   End With
   Me.Refresh
End Sub
