VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsTwofish"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
' Notes on this implementation of Twofish.
'
'This project contains a version of Twofish, that only works when the
'library is compiled. This is because Visual Basic generates exceptions
'when two large long values are added. To avoid that you have to check
'"Remove Integer Overflow Checks" in the "Advanced Optimizations" on the
'compile tab.
'
'This control contains one property and two functions. The property is used
'to set the key to be used for encryption and decryption. The two functions
'perform the encryption and decryption.
'
'Any questions on this implementation should be directed to:
'Jesper Soederberg - jesper@wiaweb.com
'http://www.wiaweb.com
'
'For more information about the Twofish algorithm check out:
'http://www.counterpane.com/twofish.html


Option Explicit

Public Enum KeyLengths
    b256 = 256
    b196 = 196
    b128 = 128
    b64 = 64
End Enum

Private Const BLOCK_SIZE = 16
Private Const ROUNDS = 16
Private Const MAX_ROUNDS = 16
   
Private Const INPUT_WHITEN = 0
Private Const OUTPUT_WHITEN = INPUT_WHITEN + BLOCK_SIZE / 4
Private Const ROUND_SUBKEYS = OUTPUT_WHITEN + BLOCK_SIZE / 4
Private Const TOTAL_SUBKEYS = ROUND_SUBKEYS + 2 * MAX_ROUNDS

Private Const SK_STEP = &H2020202
Private Const SK_BUMP = &H1010101
Private Const SK_ROTL = 9

Private Const P_00 = 1
Private Const P_01 = 0
Private Const P_02 = 0
Private Const P_03 = P_01 Xor 1
Private Const P_04 = 1

Private Const P_10 = 0
Private Const P_11 = 0
Private Const P_12 = 1
Private Const P_13 = P_11 Xor 1
Private Const P_14 = 0

Private Const P_20 = 1
Private Const P_21 = 1
Private Const P_22 = 0
Private Const P_23 = P_21 Xor 1
Private Const P_24 = 0

Private Const P_30 = 0
Private Const P_31 = 1
Private Const P_32 = 1
Private Const P_33 = P_31 Xor 1
Private Const P_34 = 1

Private Const GF256_FDBK = &H169
Private Const GF256_FDBK_2 = &H169 / 2
Private Const GF256_FDBK_4 = &H169 / 4

Private Const RS_GF_FDBK = &H14D

Private MDS(3, 255) As Long
Private P(1, 255) As Byte

Private Type SessionKeyDef
    sBox() As Long
    subKeys() As Long
End Type

Private tSessionKey As SessionKeyDef


Private Function LFSR1(ByRef x As Long) As Long
    
    On Error GoTo ErrorHandle
    
    LFSR1 = lBSR(x, 1) Xor ((x And &H1) * GF256_FDBK_2)
Exit Function

ErrorHandle:
End Function


Private Function LFSR2(ByRef x As Long) As Long
    
    On Error GoTo ErrorHandle
    
    LFSR2 = lBSR(x, 2) Xor ((x And &H2) / &H2 * GF256_FDBK_2) Xor ((x And &H1) * GF256_FDBK_4)
Exit Function

ErrorHandle:
End Function


Private Function Mx_1(ByRef x As Long) As Long
    
    On Error GoTo ErrorHandle
    
    Mx_1 = x
Exit Function

ErrorHandle:
End Function


Private Function Mx_X(ByRef x As Long) As Long
    
    On Error GoTo ErrorHandle
    
    Mx_X = x Xor LFSR2(x)
Exit Function

ErrorHandle:
End Function


Private Function Mx_Y(ByRef x As Long) As Long
    
    On Error GoTo ErrorHandle
    
    Mx_Y = x Xor LFSR1(x) Xor LFSR2(x)
Exit Function

ErrorHandle:
End Function


Private Function b0(ByRef x As Long) As Byte
    
    On Error GoTo ErrorHandle
    
    b0 = x And &HFF
Exit Function

ErrorHandle:
End Function


Private Function b1(ByRef x As Long) As Long
    
    On Error GoTo ErrorHandle
    
    b1 = ((x And &HFFFFFF00) \ &H100) And &HFF
Exit Function

ErrorHandle:
End Function


Private Function b2(ByRef x As Long) As Long
    
    On Error GoTo ErrorHandle
    
    b2 = ((x And &HFFFF0000) \ &H10000) And &HFF
Exit Function

ErrorHandle:
End Function


Private Function b3(ByRef x As Long) As Long
    
    On Error GoTo ErrorHandle
    
    b3 = ((x And &HFF000000) \ &H1000000) And &HFF
Exit Function

ErrorHandle:
End Function


Private Function RS_MDS_Encode(ByRef k0 As Long, ByRef k1 As Long) As Long
    Dim i As Long
        
    On Error GoTo ErrorHandle
    
    RS_MDS_Encode = k1
    For i = 0 To 3
        RS_MDS_Encode = RS_Rem(RS_MDS_Encode)
    Next
    RS_MDS_Encode = (RS_MDS_Encode Xor k0)
    For i = 0 To 3
        RS_MDS_Encode = RS_Rem(RS_MDS_Encode)
    Next
Exit Function

ErrorHandle:
End Function


Private Function RS_Rem(ByRef x As Long) As Long
    Dim b As Long
    Dim g2 As Long
    Dim g3 As Long
    
    On Error GoTo ErrorHandle
    
    b = (lBSRU(x, 24) And &HFF)
    g2 = ((lBSL(b, 1) Xor (b And &H80) / &H80 * RS_GF_FDBK) And &HFF)
    g3 = (lBSRU(b, 1) Xor ((b And &H1) * lBSRU(RS_GF_FDBK, 1)) Xor g2)
    RS_Rem = lBSL(x, 8) Xor lBSL(g3, 24) Xor lBSL(g2, 16) Xor lBSL(g3, 8) Xor b
Exit Function

ErrorHandle:
End Function


Private Function F32(ByRef k64Cnt As Long, ByRef x As Long, ByRef k32() As Long) As Long
    Dim b(3) As Byte
    Dim k0 As Long
    Dim k1 As Long
    Dim k2 As Long
    Dim k3 As Long
    Dim exception As Boolean
      
    On Error GoTo ErrorHandle
    
    RtlMoveMemory VarPtr(b(0)), VarPtr(x), 4
    k0 = k32(0)
    k1 = k32(1)
    k2 = k32(2)
    k3 = k32(3)
    
    F32 = 0
    exception = False
    If (k64Cnt And 3) = 1 Or exception = True Then
        F32 = MDS(0, (P(P_01, b(0)) And &HFF) Xor b0(k0)) Xor _
              MDS(1, (P(P_11, b(1)) And &HFF) Xor b1(k0)) Xor _
              MDS(2, (P(P_21, b(2)) And &HFF) Xor b2(k0)) Xor _
              MDS(3, (P(P_31, b(3)) And &HFF) Xor b3(k0))
        exception = False
    End If
    If (k64Cnt And 3) = 0 Or exception = True Then
        b(0) = (P(P_04, b(0)) And &HFF) Xor b0(k3)
        b(1) = (P(P_14, b(1)) And &HFF) Xor b1(k3)
        b(2) = (P(P_24, b(2)) And &HFF) Xor b2(k3)
        b(3) = (P(P_34, b(3)) And &HFF) Xor b3(k3)
        exception = True
    End If
    If (k64Cnt And 3) = 3 Or exception = True Then
        b(0) = (P(P_03, b(0)) And &HFF) Xor b0(k2)
        b(1) = (P(P_13, b(1)) And &HFF) Xor b1(k2)
        b(2) = (P(P_23, b(2)) And &HFF) Xor b2(k2)
        b(3) = (P(P_33, b(3)) And &HFF) Xor b3(k2)
        exception = True
    End If
    If (k64Cnt And 3) = 2 Or exception = True Then
        F32 = MDS(0, (P(P_01, (P(P_02, b(0)) And &HFF) Xor b0(k1)) And &HFF) Xor b0(k0)) Xor _
              MDS(1, (P(P_11, (P(P_12, b(1)) And &HFF) Xor b1(k1)) And &HFF) Xor b1(k0)) Xor _
              MDS(2, (P(P_21, (P(P_22, b(2)) And &HFF) Xor b2(k1)) And &HFF) Xor b2(k0)) Xor _
              MDS(3, (P(P_31, (P(P_32, b(3)) And &HFF) Xor b3(k1)) And &HFF) Xor b3(k0))
        exception = False
    End If
Exit Function

ErrorHandle:
End Function


Private Function Fe32(ByRef sBox() As Long, ByRef x As Long, ByRef R As Long) As Long
    
    On Error GoTo ErrorHandle
    
    Fe32 = sBox(2 * x_b(x, R)) Xor _
           sBox(2 * x_b(x, R + 1) + 1) Xor _
           sBox(&H200 + 2 * x_b(x, R + 2)) Xor _
           sBox(&H200 + 2 * x_b(x, R + 3) + 1)
Exit Function

ErrorHandle:
End Function


Private Function x_b(ByRef x As Long, ByRef N As Long) As Long
    
    On Error GoTo ErrorHandle
    
    x_b = 0
    Select Case (N Mod 4)
        Case 0
            x_b = b0(x)
        Case 1
            x_b = b1(x)
        Case 2
            x_b = b2(x)
        Case 3
            x_b = b3(x)
    End Select
Exit Function

ErrorHandle:
End Function


Private Function makeKey(ByRef k() As Byte) As SessionKeyDef
    Dim k64Cnt As Long
    Dim subkeyCnt As Long
    Dim k32e(3) As Long
    Dim k32o(3) As Long
    Dim sBoxKey(3) As Long
    Dim length As Long
    Dim i As Long
    Dim j As Long
    Dim offset As Long
    Dim lA As Long
    Dim lB As Long
    Dim subKeys() As Long
    Dim b(3) As Byte
    Dim k0 As Long
    Dim k1 As Long
    Dim k2 As Long
    Dim k3 As Long
    Dim sBox(1023) As Long
    Dim exception As Boolean
    
    On Error GoTo ErrorHandle
    
    length = UBound(k) + 1
    k64Cnt = length / 8
    subkeyCnt = ROUND_SUBKEYS + 2 * ROUNDS
    
    i = 0
    j = k64Cnt - 1
    offset = 0
    While i < 4 And offset < length
        RtlMoveMemory VarPtr(k32e(i)), VarPtr(k(offset)), 4
        offset = offset + 4
        RtlMoveMemory VarPtr(k32o(i)), VarPtr(k(offset)), 4
        offset = offset + 4
        sBoxKey(j) = RS_MDS_Encode(k32e(i), k32o(i))
        i = i + 1
        j = j - 1
    Wend
    
    ReDim subKeys(subkeyCnt)
    For i = 0 To (subkeyCnt / 2) - 1
        lA = F32(k64Cnt, i * SK_STEP, k32e)
        lB = F32(k64Cnt, i * SK_STEP + SK_BUMP, k32o)
        lB = lBSL(lB, 8) Or lBSRU(lB, 24)
        lA = (lA + lB)
        subKeys(2 * i) = lA
        lA = (lA + lB)
        subKeys(2 * i + 1) = lBSL(lA, SK_ROTL) Or lBSRU(lA, 32 - SK_ROTL)
    Next
    
    k0 = sBoxKey(0)
    k1 = sBoxKey(1)
    k2 = sBoxKey(2)
    k3 = sBoxKey(3)
    For i = 0 To 255
        b(0) = i
        b(1) = i
        b(2) = i
        b(3) = i
        exception = False
        If (k64Cnt And 3) = 1 Or exception = True Then
            sBox(2 * i) = MDS(0, (P(P_01, b(0)) And &HFF) Xor b0(k0))
            sBox(2 * i + 1) = MDS(1, (P(P_11, b(1)) And &HFF) Xor b1(k0))
            sBox(&H200 + 2 * i) = MDS(2, (P(P_21, b(2)) And &HFF) Xor b2(k0))
            sBox(&H200 + 2 * i + 1) = MDS(3, (P(P_31, b(3)) And &HFF) Xor b3(k0))
            exception = False
        End If
        If (k64Cnt And 3) = 0 Or exception = True Then
            b(0) = (P(P_04, b(0)) And &HFF) Xor b0(k3)
            b(1) = (P(P_14, b(1)) And &HFF) Xor b1(k3)
            b(2) = (P(P_24, b(2)) And &HFF) Xor b2(k3)
            b(3) = (P(P_34, b(3)) And &HFF) Xor b3(k3)
            exception = True
        End If
        If (k64Cnt And 3) = 3 Or exception = True Then
            b(0) = (P(P_03, b(0)) And &HFF) Xor b0(k2)
            b(1) = (P(P_13, b(1)) And &HFF) Xor b1(k2)
            b(2) = (P(P_23, b(2)) And &HFF) Xor b2(k2)
            b(3) = (P(P_33, b(3)) And &HFF) Xor b3(k2)
            exception = True
        End If
        If (k64Cnt And 3) = 2 Or exception = True Then
            sBox(2 * i) = MDS(0, (P(P_01, (P(P_02, b(0)) And &HFF) Xor b0(k1)) And &HFF) Xor b0(k0))
            sBox(2 * i + 1) = MDS(1, (P(P_11, (P(P_12, b(1)) And &HFF) Xor b1(k1)) And &HFF) Xor b1(k0))
            sBox(&H200 + 2 * i) = MDS(2, (P(P_21, (P(P_22, b(2)) And &HFF) Xor b2(k1)) And &HFF) Xor b2(k0))
            sBox(&H200 + 2 * i + 1) = MDS(3, (P(P_31, (P(P_32, b(3)) And &HFF) Xor b3(k1)) And &HFF) Xor b3(k0))
            exception = False
        End If
    Next
    
    makeKey.sBox = sBox
    makeKey.subKeys = subKeys
Exit Function

ErrorHandle:
End Function


Private Function blockEncrypt(ByRef bInput() As Byte, ByRef inOffset As Long, ByRef sessionKey As SessionKeyDef) As Byte()
    Dim bOutput() As Byte
    Dim sBox() As Long
    Dim sKey() As Long
    Dim x(3) As Long
    Dim t0 As Long
    Dim t1 As Long
    Dim k As Long
    Dim R As Long
    
    On Error GoTo ErrorHandle
    
    sBox = sessionKey.sBox
    sKey = sessionKey.subKeys
    
    RtlMoveMemory VarPtr(x(0)), VarPtr(bInput(inOffset)), 16
    
    x(0) = x(0) Xor sKey(INPUT_WHITEN)
    x(1) = x(1) Xor sKey(INPUT_WHITEN + 1)
    x(2) = x(2) Xor sKey(INPUT_WHITEN + 2)
    x(3) = x(3) Xor sKey(INPUT_WHITEN + 3)

    k = ROUND_SUBKEYS
    For R = 0 To ROUNDS - 1 Step 2
        t0 = Fe32(sBox, x(0), 0)
        t1 = Fe32(sBox, x(1), 3)
        x(2) = lBSRRot(x(2) Xor (t0 + t1 + sKey(k)), 1)
        k = k + 1
        x(3) = (lBSRRot(x(3), 31)) Xor (t0 + t1 + t1 + sKey(k))
        k = k + 1

        t0 = Fe32(sBox, x(2), 0)
        t1 = Fe32(sBox, x(3), 3)
        x(0) = lBSRRot(x(0) Xor (t0 + t1 + sKey(k)), 1)
        k = k + 1
        x(1) = (lBSRRot(x(1), 31)) Xor (t0 + t1 + t1 + sKey(k))
        k = k + 1
    Next
      
    x(2) = x(2) Xor sKey(OUTPUT_WHITEN)
    x(3) = x(3) Xor sKey(OUTPUT_WHITEN + 1)
    x(0) = x(0) Xor sKey(OUTPUT_WHITEN + 2)
    x(1) = x(1) Xor sKey(OUTPUT_WHITEN + 3)
      
    ReDim bOutput(15)
    RtlMoveMemory VarPtr(bOutput(0)), VarPtr(x(2)), 8
    RtlMoveMemory VarPtr(bOutput(8)), VarPtr(x(0)), 8
    blockEncrypt = bOutput
Exit Function

ErrorHandle:
End Function


Private Function blockDecrypt(ByRef bInput() As Byte, ByRef inOffset As Long, ByRef sessionKey As SessionKeyDef) As Byte()
    Dim bOutput() As Byte
    Dim sBox() As Long
    Dim sKey() As Long
    Dim x(3) As Long
    Dim k As Long
    Dim t0 As Long
    Dim t1 As Long
    Dim R As Long
    
    On Error GoTo ErrorHandle
    
    sBox = sessionKey.sBox
    sKey = sessionKey.subKeys
    
    RtlMoveMemory VarPtr(x(2)), VarPtr(bInput(inOffset)), 8
    RtlMoveMemory VarPtr(x(0)), VarPtr(bInput(inOffset + 8)), 8

    x(2) = x(2) Xor sKey(OUTPUT_WHITEN)
    x(3) = x(3) Xor sKey(OUTPUT_WHITEN + 1)
    x(0) = x(0) Xor sKey(OUTPUT_WHITEN + 2)
    x(1) = x(1) Xor sKey(OUTPUT_WHITEN + 3)

    k = ROUND_SUBKEYS + 2 * ROUNDS - 1
    For R = 0 To ROUNDS - 1 Step 2
        t0 = Fe32(sBox, x(2), 0)
        t1 = Fe32(sBox, x(3), 3)
        x(1) = lBSRRot(x(1) Xor (t0 + t1 + t1 + sKey(k)), 1)
        k = k - 1
        x(0) = lBSRRot(x(0), 31) Xor (t0 + t1 + sKey(k))
        k = k - 1
        t0 = Fe32(sBox, x(0), 0)
        t1 = Fe32(sBox, x(1), 3)
        x(3) = lBSRRot(x(3) Xor (t0 + t1 + t1 + sKey(k)), 1)
        k = k - 1
        x(2) = lBSRRot(x(2), 31) Xor (t0 + t1 + sKey(k))
        k = k - 1
    Next
      
    x(0) = x(0) Xor sKey(INPUT_WHITEN)
    x(1) = x(1) Xor sKey(INPUT_WHITEN + 1)
    x(2) = x(2) Xor sKey(INPUT_WHITEN + 2)
    x(3) = x(3) Xor sKey(INPUT_WHITEN + 3)
      
    ReDim bOutput(15)
    RtlMoveMemory VarPtr(bOutput(0)), VarPtr(x(0)), 16
    blockDecrypt = bOutput
Exit Function

ErrorHandle:
End Function


Private Sub Class_Initialize()
    Dim m1(1) As Long
    Dim mX(1) As Long
    Dim mY(1) As Long
    Dim i As Long
    Dim j As Long
    Dim bP0() As Byte
    Dim bP1() As Byte
        
    On Error GoTo ErrorHandle
    
    bP0 = CStr(ChrB(&HA9) & ChrB(&H67) & ChrB(&HB3) & ChrB(&HE8) & ChrB(&H4) & ChrB(&HFD) & ChrB(&HA3) & ChrB(&H76))
    bP0 = CStr(bP0) & CStr(ChrB(&H9A) & ChrB(&H92) & ChrB(&H80) & ChrB(&H78) & ChrB(&HE4) & ChrB(&HDD) & ChrB(&HD1) & ChrB(&H38))
    bP0 = CStr(bP0) & CStr(ChrB(&HD) & ChrB(&HC6) & ChrB(&H35) & ChrB(&H98) & ChrB(&H18) & ChrB(&HF7) & ChrB(&HEC) & ChrB(&H6C))
    bP0 = CStr(bP0) & CStr(ChrB(&H43) & ChrB(&H75) & ChrB(&H37) & ChrB(&H26) & ChrB(&HFA) & ChrB(&H13) & ChrB(&H94) & ChrB(&H48))
    bP0 = CStr(bP0) & CStr(ChrB(&HF2) & ChrB(&HD0) & ChrB(&H8B) & ChrB(&H30) & ChrB(&H84) & ChrB(&H54) & ChrB(&HDF) & ChrB(&H23))
    bP0 = CStr(bP0) & CStr(ChrB(&H19) & ChrB(&H5B) & ChrB(&H3D) & ChrB(&H59) & ChrB(&HF3) & ChrB(&HAE) & ChrB(&HA2) & ChrB(&H82))
    bP0 = CStr(bP0) & CStr(ChrB(&H63) & ChrB(&H1) & ChrB(&H83) & ChrB(&H2E) & ChrB(&HD9) & ChrB(&H51) & ChrB(&H9B) & ChrB(&H7C))
    bP0 = CStr(bP0) & CStr(ChrB(&HA6) & ChrB(&HEB) & ChrB(&HA5) & ChrB(&HBE) & ChrB(&H16) & ChrB(&HC) & ChrB(&HE3) & ChrB(&H61))
    bP0 = CStr(bP0) & CStr(ChrB(&HC0) & ChrB(&H8C) & ChrB(&H3A) & ChrB(&HF5) & ChrB(&H73) & ChrB(&H2C) & ChrB(&H25) & ChrB(&HB))
    bP0 = CStr(bP0) & CStr(ChrB(&HBB) & ChrB(&H4E) & ChrB(&H89) & ChrB(&H6B) & ChrB(&H53) & ChrB(&H6A) & ChrB(&HB4) & ChrB(&HF1))
    bP0 = CStr(bP0) & CStr(ChrB(&HE1) & ChrB(&HE6) & ChrB(&HBD) & ChrB(&H45) & ChrB(&HE2) & ChrB(&HF4) & ChrB(&HB6) & ChrB(&H66))
    bP0 = CStr(bP0) & CStr(ChrB(&HCC) & ChrB(&H95) & ChrB(&H3) & ChrB(&H56) & ChrB(&HD4) & ChrB(&H1C) & ChrB(&H1E) & ChrB(&HD7))
    bP0 = CStr(bP0) & CStr(ChrB(&HFB) & ChrB(&HC3) & ChrB(&H8E) & ChrB(&HB5) & ChrB(&HE9) & ChrB(&HCF) & ChrB(&HBF) & ChrB(&HBA))
    bP0 = CStr(bP0) & CStr(ChrB(&HEA) & ChrB(&H77) & ChrB(&H39) & ChrB(&HAF) & ChrB(&H33) & ChrB(&HC9) & ChrB(&H62) & ChrB(&H71))
    bP0 = CStr(bP0) & CStr(ChrB(&H81) & ChrB(&H79) & ChrB(&H9) & ChrB(&HAD) & ChrB(&H24) & ChrB(&HCD) & ChrB(&HF9) & ChrB(&HD8))
    bP0 = CStr(bP0) & CStr(ChrB(&HE5) & ChrB(&HC5) & ChrB(&HB9) & ChrB(&H4D) & ChrB(&H44) & ChrB(&H8) & ChrB(&H86) & ChrB(&HE7))
    bP0 = CStr(bP0) & CStr(ChrB(&HA1) & ChrB(&H1D) & ChrB(&HAA) & ChrB(&HED) & ChrB(&H6) & ChrB(&H70) & ChrB(&HB2) & ChrB(&HD2))
    bP0 = CStr(bP0) & CStr(ChrB(&H41) & ChrB(&H7B) & ChrB(&HA0) & ChrB(&H11) & ChrB(&H31) & ChrB(&HC2) & ChrB(&H27) & ChrB(&H90))
    bP0 = CStr(bP0) & CStr(ChrB(&H20) & ChrB(&HF6) & ChrB(&H60) & ChrB(&HFF) & ChrB(&H96) & ChrB(&H5C) & ChrB(&HB1) & ChrB(&HAB))
    bP0 = CStr(bP0) & CStr(ChrB(&H9E) & ChrB(&H9C) & ChrB(&H52) & ChrB(&H1B) & ChrB(&H5F) & ChrB(&H93) & ChrB(&HA) & ChrB(&HEF))
    bP0 = CStr(bP0) & CStr(ChrB(&H91) & ChrB(&H85) & ChrB(&H49) & ChrB(&HEE) & ChrB(&H2D) & ChrB(&H4F) & ChrB(&H8F) & ChrB(&H3B))
    bP0 = CStr(bP0) & CStr(ChrB(&H47) & ChrB(&H87) & ChrB(&H6D) & ChrB(&H46) & ChrB(&HD6) & ChrB(&H3E) & ChrB(&H69) & ChrB(&H64))
    bP0 = CStr(bP0) & CStr(ChrB(&H2A) & ChrB(&HCE) & ChrB(&HCB) & ChrB(&H2F) & ChrB(&HFC) & ChrB(&H97) & ChrB(&H5) & ChrB(&H7A))
    bP0 = CStr(bP0) & CStr(ChrB(&HAC) & ChrB(&H7F) & ChrB(&HD5) & ChrB(&H1A) & ChrB(&H4B) & ChrB(&HE) & ChrB(&HA7) & ChrB(&H5A))
    bP0 = CStr(bP0) & CStr(ChrB(&H28) & ChrB(&H14) & ChrB(&H3F) & ChrB(&H29) & ChrB(&H88) & ChrB(&H3C) & ChrB(&H4C) & ChrB(&H2))
    bP0 = CStr(bP0) & CStr(ChrB(&HB8) & ChrB(&HDA) & ChrB(&HB0) & ChrB(&H17) & ChrB(&H55) & ChrB(&H1F) & ChrB(&H8A) & ChrB(&H7D))
    bP0 = CStr(bP0) & CStr(ChrB(&H57) & ChrB(&HC7) & ChrB(&H8D) & ChrB(&H74) & ChrB(&HB7) & ChrB(&HC4) & ChrB(&H9F) & ChrB(&H72))
    bP0 = CStr(bP0) & CStr(ChrB(&H7E) & ChrB(&H15) & ChrB(&H22) & ChrB(&H12) & ChrB(&H58) & ChrB(&H7) & ChrB(&H99) & ChrB(&H34))
    bP0 = CStr(bP0) & CStr(ChrB(&H6E) & ChrB(&H50) & ChrB(&HDE) & ChrB(&H68) & ChrB(&H65) & ChrB(&HBC) & ChrB(&HDB) & ChrB(&HF8))
    bP0 = CStr(bP0) & CStr(ChrB(&HC8) & ChrB(&HA8) & ChrB(&H2B) & ChrB(&H40) & ChrB(&HDC) & ChrB(&HFE) & ChrB(&H32) & ChrB(&HA4))
    bP0 = CStr(bP0) & CStr(ChrB(&HCA) & ChrB(&H10) & ChrB(&H21) & ChrB(&HF0) & ChrB(&HD3) & ChrB(&H5D) & ChrB(&HF) & ChrB(&H0))
    bP0 = CStr(bP0) & CStr(ChrB(&H6F) & ChrB(&H9D) & ChrB(&H36) & ChrB(&H42) & ChrB(&H4A) & ChrB(&H5E) & ChrB(&HC1) & ChrB(&HE0))
    
    bP1 = CStr(ChrB(&H75) & ChrB(&HF3) & ChrB(&HC6) & ChrB(&HF4) & ChrB(&HDB) & ChrB(&H7B) & ChrB(&HFB) & ChrB(&HC8))
    bP1 = CStr(bP1) & CStr(ChrB(&H4A) & ChrB(&HD3) & ChrB(&HE6) & ChrB(&H6B) & ChrB(&H45) & ChrB(&H7D) & ChrB(&HE8) & ChrB(&H4B))
    bP1 = CStr(bP1) & CStr(ChrB(&HD6) & ChrB(&H32) & ChrB(&HD8) & ChrB(&HFD) & ChrB(&H37) & ChrB(&H71) & ChrB(&HF1) & ChrB(&HE1))
    bP1 = CStr(bP1) & CStr(ChrB(&H30) & ChrB(&HF) & ChrB(&HF8) & ChrB(&H1B) & ChrB(&H87) & ChrB(&HFA) & ChrB(&H6) & ChrB(&H3F))
    bP1 = CStr(bP1) & CStr(ChrB(&H5E) & ChrB(&HBA) & ChrB(&HAE) & ChrB(&H5B) & ChrB(&H8A) & ChrB(&H0) & ChrB(&HBC) & ChrB(&H9D))
    bP1 = CStr(bP1) & CStr(ChrB(&H6D) & ChrB(&HC1) & ChrB(&HB1) & ChrB(&HE) & ChrB(&H80) & ChrB(&H5D) & ChrB(&HD2) & ChrB(&HD5))
    bP1 = CStr(bP1) & CStr(ChrB(&HA0) & ChrB(&H84) & ChrB(&H7) & ChrB(&H14) & ChrB(&HB5) & ChrB(&H90) & ChrB(&H2C) & ChrB(&HA3))
    bP1 = CStr(bP1) & CStr(ChrB(&HB2) & ChrB(&H73) & ChrB(&H4C) & ChrB(&H54) & ChrB(&H92) & ChrB(&H74) & ChrB(&H36) & ChrB(&H51))
    bP1 = CStr(bP1) & CStr(ChrB(&H38) & ChrB(&HB0) & ChrB(&HBD) & ChrB(&H5A) & ChrB(&HFC) & ChrB(&H60) & ChrB(&H62) & ChrB(&H96))
    bP1 = CStr(bP1) & CStr(ChrB(&H6C) & ChrB(&H42) & ChrB(&HF7) & ChrB(&H10) & ChrB(&H7C) & ChrB(&H28) & ChrB(&H27) & ChrB(&H8C))
    bP1 = CStr(bP1) & CStr(ChrB(&H13) & ChrB(&H95) & ChrB(&H9C) & ChrB(&HC7) & ChrB(&H24) & ChrB(&H46) & ChrB(&H3B) & ChrB(&H70))
    bP1 = CStr(bP1) & CStr(ChrB(&HCA) & ChrB(&HE3) & ChrB(&H85) & ChrB(&HCB) & ChrB(&H11) & ChrB(&HD0) & ChrB(&H93) & ChrB(&HB8))
    bP1 = CStr(bP1) & CStr(ChrB(&HA6) & ChrB(&H83) & ChrB(&H20) & ChrB(&HFF) & ChrB(&H9F) & ChrB(&H77) & ChrB(&HC3) & ChrB(&HCC))
    bP1 = CStr(bP1) & CStr(ChrB(&H3) & ChrB(&H6F) & ChrB(&H8) & ChrB(&HBF) & ChrB(&H40) & ChrB(&HE7) & ChrB(&H2B) & ChrB(&HE2))
    bP1 = CStr(bP1) & CStr(ChrB(&H79) & ChrB(&HC) & ChrB(&HAA) & ChrB(&H82) & ChrB(&H41) & ChrB(&H3A) & ChrB(&HEA) & ChrB(&HB9))
    bP1 = CStr(bP1) & CStr(ChrB(&HE4) & ChrB(&H9A) & ChrB(&HA4) & ChrB(&H97) & ChrB(&H7E) & ChrB(&HDA) & ChrB(&H7A) & ChrB(&H17))
    bP1 = CStr(bP1) & CStr(ChrB(&H66) & ChrB(&H94) & ChrB(&HA1) & ChrB(&H1D) & ChrB(&H3D) & ChrB(&HF0) & ChrB(&HDE) & ChrB(&HB3))
    bP1 = CStr(bP1) & CStr(ChrB(&HB) & ChrB(&H72) & ChrB(&HA7) & ChrB(&H1C) & ChrB(&HEF) & ChrB(&HD1) & ChrB(&H53) & ChrB(&H3E))
    bP1 = CStr(bP1) & CStr(ChrB(&H8F) & ChrB(&H33) & ChrB(&H26) & ChrB(&H5F) & ChrB(&HEC) & ChrB(&H76) & ChrB(&H2A) & ChrB(&H49))
    bP1 = CStr(bP1) & CStr(ChrB(&H81) & ChrB(&H88) & ChrB(&HEE) & ChrB(&H21) & ChrB(&HC4) & ChrB(&H1A) & ChrB(&HEB) & ChrB(&HD9))
    bP1 = CStr(bP1) & CStr(ChrB(&HC5) & ChrB(&H39) & ChrB(&H99) & ChrB(&HCD) & ChrB(&HAD) & ChrB(&H31) & ChrB(&H8B) & ChrB(&H1))
    bP1 = CStr(bP1) & CStr(ChrB(&H18) & ChrB(&H23) & ChrB(&HDD) & ChrB(&H1F) & ChrB(&H4E) & ChrB(&H2D) & ChrB(&HF9) & ChrB(&H48))
    bP1 = CStr(bP1) & CStr(ChrB(&H4F) & ChrB(&HF2) & ChrB(&H65) & ChrB(&H8E) & ChrB(&H78) & ChrB(&H5C) & ChrB(&H58) & ChrB(&H19))
    bP1 = CStr(bP1) & CStr(ChrB(&H8D) & ChrB(&HE5) & ChrB(&H98) & ChrB(&H57) & ChrB(&H67) & ChrB(&H7F) & ChrB(&H5) & ChrB(&H64))
    bP1 = CStr(bP1) & CStr(ChrB(&HAF) & ChrB(&H63) & ChrB(&HB6) & ChrB(&HFE) & ChrB(&HF5) & ChrB(&HB7) & ChrB(&H3C) & ChrB(&HA5))
    bP1 = CStr(bP1) & CStr(ChrB(&HCE) & ChrB(&HE9) & ChrB(&H68) & ChrB(&H44) & ChrB(&HE0) & ChrB(&H4D) & ChrB(&H43) & ChrB(&H69))
    bP1 = CStr(bP1) & CStr(ChrB(&H29) & ChrB(&H2E) & ChrB(&HAC) & ChrB(&H15) & ChrB(&H59) & ChrB(&HA8) & ChrB(&HA) & ChrB(&H9E))
    bP1 = CStr(bP1) & CStr(ChrB(&H6E) & ChrB(&H47) & ChrB(&HDF) & ChrB(&H34) & ChrB(&H35) & ChrB(&H6A) & ChrB(&HCF) & ChrB(&HDC))
    bP1 = CStr(bP1) & CStr(ChrB(&H22) & ChrB(&HC9) & ChrB(&HC0) & ChrB(&H9B) & ChrB(&H89) & ChrB(&HD4) & ChrB(&HED) & ChrB(&HAB))
    bP1 = CStr(bP1) & CStr(ChrB(&H12) & ChrB(&HA2) & ChrB(&HD) & ChrB(&H52) & ChrB(&HBB) & ChrB(&H2) & ChrB(&H2F) & ChrB(&HA9))
    bP1 = CStr(bP1) & CStr(ChrB(&HD7) & ChrB(&H61) & ChrB(&H1E) & ChrB(&HB4) & ChrB(&H50) & ChrB(&H4) & ChrB(&HF6) & ChrB(&HC2))
    bP1 = CStr(bP1) & CStr(ChrB(&H16) & ChrB(&H25) & ChrB(&H86) & ChrB(&H56) & ChrB(&H55) & ChrB(&H9) & ChrB(&HBE) & ChrB(&H91))
    
    For i = 0 To 255
        P(0, i) = bP0(i)
        P(1, i) = bP1(i)
    Next
    
    For i = 0 To 255
        j = (P(0, i) And &HFF)
        m1(0) = j
        mX(0) = (Mx_X(j) And &HFF)
        mY(0) = (Mx_Y(j) And &HFF)
        
        j = (P(1, i) And &HFF)
        m1(1) = j
        mX(1) = (Mx_X(j) And &HFF)
        mY(1) = (Mx_Y(j) And &HFF)
        
        MDS(0, i) = (m1(P_00) Or lBSL(mX(P_00), 8) Or lBSL(mY(P_00), 16) Or lBSL(mY(P_00), 24))
        MDS(1, i) = (mY(P_10) Or lBSL(mY(P_10), 8) Or lBSL(mX(P_10), 16) Or lBSL(m1(P_10), 24))
        MDS(2, i) = (mX(P_20) Or lBSL(mY(P_20), 8) Or lBSL(m1(P_20), 16) Or lBSL(mY(P_20), 24))
        MDS(3, i) = (mX(P_30) Or lBSL(m1(P_30), 8) Or lBSL(mY(P_30), 16) Or lBSL(mX(P_30), 24))
    Next
Exit Sub

ErrorHandle:
End Sub


Public Property Let bKey(Optional ByVal lMinKeyLength As KeyLengths, ByRef bKey() As Byte)
    Dim lKeyLength As Long
    
    On Error GoTo ErrorHandle
    
    If boolIsArrayInit(bKey) = False Then Exit Property
    lKeyLength = (UBound(bKey) + 1) * 8
    If lKeyLength < lMinKeyLength Then ReDim Preserve bKey((lMinKeyLength \ 8) - 1)
    If lKeyLength > 256 Then ReDim Preserve bKey(31)
    If lKeyLength > 192 And lKeyLength < 256 Then ReDim Preserve bKey(23)
    If lKeyLength > 128 And lKeyLength < 192 Then ReDim Preserve bKey(15)
    If lKeyLength > 64 And lKeyLength < 128 Then ReDim Preserve bKey(7)
    tSessionKey = makeKey(bKey)
Exit Property

ErrorHandle:
End Property


Public Function bEncrypt(ByRef bInput() As Byte) As Byte()
    Dim bBlockInput() As Byte
    Dim bTemp() As Byte
    Dim lCount As Long
    Dim lEncodeLength As Long
    Dim lInputLength As Long
    Dim bOutput() As Byte
    
    On Error GoTo ErrorHandle
    
    If boolIsArrayInit(bInput) = False Then Exit Function
    If boolIsArrayInit(tSessionKey.sBox) = False Then
        ReDim bTemp(15)
        tSessionKey = makeKey(bTemp)
    End If
    lInputLength = UBound(bInput) + 1
    lEncodeLength = lInputLength + 4
    If lEncodeLength Mod 16 <> 0 Then lEncodeLength = lEncodeLength + 16 - (lEncodeLength Mod 16)
    ReDim bBlockInput(lEncodeLength - 1)
    ReDim bOutput(lEncodeLength - 1)
    RtlMoveMemory VarPtr(bBlockInput(0)), VarPtr(lInputLength), 4
    RtlMoveMemory VarPtr(bBlockInput(4)), VarPtr(bInput(0)), lInputLength
    For lCount = 0 To lEncodeLength - 1 Step 16
        bTemp = blockEncrypt(bBlockInput, lCount, tSessionKey)
        RtlMoveMemory VarPtr(bOutput(lCount)), VarPtr(bTemp(0)), 16
    Next
    bEncrypt = bOutput
Exit Function

ErrorHandle:
End Function


Public Function bDecrypt(ByRef bInput() As Byte) As Byte()
    Dim lTemp As Long
    Dim bBlockOutput() As Byte
    Dim bOutput() As Byte
    Dim bTemp() As Byte
    Dim lCount As Long
    
    On Error GoTo ErrorHandle
    
    If boolIsArrayInit(bInput) = False Then Exit Function
    If (UBound(bInput) + 1) Mod 16 <> 0 And UBound(bInput) > 0 Then Exit Function
    If boolIsArrayInit(tSessionKey.sBox) = False Then
        ReDim bTemp(15)
        tSessionKey = makeKey(bTemp)
    End If
    ReDim bBlockOutput(UBound(bInput))
    For lCount = 0 To UBound(bInput) Step 16
        bTemp = blockDecrypt(bInput, lCount, tSessionKey)
        RtlMoveMemory VarPtr(bBlockOutput(lCount)), VarPtr(bTemp(0)), 16
    Next

    RtlMoveMemory VarPtr(lTemp), VarPtr(bBlockOutput(0)), 4
    If lTemp > UBound(bInput) - 3 Then Exit Function
    ReDim bOutput(lTemp - 1)
    RtlMoveMemory VarPtr(bOutput(0)), VarPtr(bBlockOutput(4)), lTemp
    bDecrypt = bOutput
Exit Function

ErrorHandle:
End Function


Private Function boolIsArrayInit(ByRef vArray As Variant) As Boolean
    
    On Error Resume Next
    
    boolIsArrayInit = IsNumeric(UBound(vArray))
End Function




