// IDSLog.h: interface for the CIDSLog class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_IDSLOG_H__029E36C7_CA74_4DEA_8962_4D85C6D4D945__INCLUDED_)
#define AFX_IDSLOG_H__029E36C7_CA74_4DEA_8962_4D85C6D4D945__INCLUDED_

#include <time.h>

// the descendents of this class will have to keep state so successive
// ReadIncident() calls will read successive incidents correctly.

#define LOG_STRLEN 1024

// started hitting the end of the portscan string
// triple the size
//#define PORTSCAN_STRLEN 8192
#define PORTSCAN_STRLEN 24576

// protocol defines
#define PROTO_ICMP	1
#define PROTO_IGMP	2
#define PROTO_TCP	6
#define PROTO_UDP	17


class CIDSAddlInfo
{
public:
	CIDSAddlInfo (const char *sAddlType, const char *sAddlString);
	~CIDSAddlInfo ();
	char *AddlType () const;
	char *AddlString () const;
	CIDSAddlInfo *m_pNext;

private:
	char m_sAddlType[LOG_STRLEN + 1];
	char m_sAddlString[LOG_STRLEN + 1];

};


class CIDSLog  
{
public:
	bool SkippedRecords () const;
	int GetNumRecords () const;
	CIDSLog();
	virtual ~CIDSLog();

	bool Output (const char *sSerial, double nDate, const char *infile, const char *outfile, double& nLastDate);

	bool SetIPMasks (char *masklist);
	void FreeIPMasks ();

	double GetDate (int yr, int mt, int dy, int hr, int mn, int sc, int ms);
	static double GetDate (int yr, int mt, int dy, int hr, int mn, int sc, int ms, int convertToGMT);
	static void GetDate (double nDate, int& yr, int& mt, int& dy, int& hr, int& mn, int& sc, int& ms);

	int m_nLoggingInGMT;
	// needed from the profile for writing in the header
	unsigned long m_nNetMask;
	double m_nLastTimestamp;
	double m_nCurrentTime;

protected:
	bool m_bSkippedRecords;
	virtual void IDSVersion (char *sIDSProduct, int& nIDSID, int& nIDSMajor, int& nIDSMinor, char *sIDSRev) const = 0;

	virtual bool OpenLog (const char *filename) = 0;
	virtual void SeekLog (double nDate) = 0;
	virtual bool LastIncident () = 0;
	virtual bool ReadIncident () = 0;
	virtual void CloseLog () = 0;
	virtual double GetLastDate () = 0;

	void ClearAddl ();
	void AddAddl (const char *sAddlType, const char *sAddlString);
	
	// an individual incident
	
	char m_sID[LOG_STRLEN + 1];
	char m_sPortScan[PORTSCAN_STRLEN + 1];
	double m_nDateTime;

	int m_nProtocol;
	int unsigned m_nFromIP;
	int unsigned m_nToIP;
	int m_nFromPort;
	int m_nToPort;
	int m_nCount;
	CIDSAddlInfo *m_pAddlInfoHead;

private:
	bool OpenOutput (const char *filename);
	bool WriteHeader ();
	bool WriteFooter ();
	bool WriteIncident ();
	void CloseOutput ();
	FILE *m_pOutputFile;

	int m_nEntry;

	struct tm m_now;
	struct tm m_localnow;
	static const char *m_sStripperVersion;
	static const char *m_sXMLHeader;
	char m_sSerial[LOG_STRLEN + 1];

	int **m_pIPMasks;
	bool StripIP (char *stripped, int ip) const;

	static void calc_date (int y, int d, int& mt, int& dy);
	static int calc_dayofyear (int y, int m, int d);
	static void add_days (int y, int d, int& y2, int& d2);
	static int sub_year (int y1, int y2);
};

#endif // 
