// KeyObject.h: interface for the CKeyObject class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_KEYOBJECT_H__4AA4C313_4822_484F_A618_F47294643B76__INCLUDED_)
#define AFX_KEYOBJECT_H__4AA4C313_4822_484F_A618_F47294643B76__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CKeyObject
{
public:

	CKeyObject();
	virtual ~CKeyObject();

	void Create (PGPContextRef *pPGPContext, PGPKeySetRef *pKeySet, PGPKeyRef keyRef);
	//void Create (PGPContextRef *pPGPContext, PGPKeySetRef *pKeySet, PGPKeyID *pgpKeyID);
	void Delete();

	BOOL SetAsDefault();

	PGPKeyID * GetKeyID();
	PGPKeyRef GetKeyRef();

	void GetDescription(CString &str);
	void GetKeyRef (PGPKeyRef *pKeyRef);
		void GetAlgID(CString &str);
	void GetSize(CString &str);
	void GetKeyID (CString &str);
	void GetUserID(CString &str);
	void GetExpirationDate(CString &str);
	void GetCreationDate(CString &str);
	
	BOOL IsPrivate();
	BOOL IsDefault();		

protected:

	PGPContextRef  *m_pContext;
	PGPKeySetRef   *m_pKeySet;
	PGPKeyID		m_keyID;
};


typedef vector<CKeyObject> KeyObjectListT;
typedef vector<long> KeyPointerListT;


#endif // !defined(AFX_KEYOBJECT_H__4AA4C313_4822_484F_A618_F47294643B76__INCLUDED_)
