///////////////////////////////////////////////////////////////////////////
//                                                                       //
// KeyObject.cpp : implementation file                                   //
//                                                                       //
// Copyright (c) 2000 Samopal Corporation.                               //
// All right are all right (tm)                                          //
//                                                                       //
// For news and updates visit http://www.samopal.com/soft/pgpicq/        //
// Email your comments to pgpicq@samopal.com                             //
//                                                                       //
// Free use and distribution of this source code allowed                 //
// under the condition of keeping this header intact.                    //
//                                                                       //
///////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "pgpKeys.h"
#include "KeyObject.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CKeyObject::CKeyObject()
{
	m_pContext = NULL;
	m_pKeySet = NULL;
}


void CKeyObject::Create ( PGPContextRef *pPGPContext, 
			PGPKeySetRef *pKeySet, PGPKeyRef keyRef )
{
	PGPError nErr;

	m_pContext = pPGPContext;
	m_pKeySet = pKeySet;
	
	nErr = PGPGetKeyIDFromKey (keyRef, &m_keyID );
}


/*
void CKeyObject::Create ( PGPContextRef	*pPGPContext, 
			PGPKeySetRef *pKeySet, PGPKeyID *keyID )
{
	m_pContext = pPGPContext;
	m_pKeySet = pKeySet;
	// m_keyID = keyID;
	memcpy ( &m_keyID, &keyID, sizeof(PGPKeyID) );
}
*/


CKeyObject::~CKeyObject()
{

}


BOOL CKeyObject::IsPrivate()
{
	PGPBoolean	bIsPrivate;
	PGPKeyRef	keyRef;
	PGPError	nErr;

	ASSERT( m_pContext != NULL );
	ASSERT( m_pKeySet != NULL );

	GetKeyRef (&keyRef);

	nErr = PGPGetKeyBoolean (keyRef, kPGPKeyPropCanDecrypt, &bIsPrivate);
	return bIsPrivate;
}

BOOL CKeyObject::IsDefault()
{
	PGPKeyRef	keyRef;
	PGPKeyRef	defPrivateKey;

	ASSERT( m_pContext != NULL );
	ASSERT( m_pKeySet != NULL );

	GetKeyRef (&keyRef);
	PGPGetDefaultPrivateKey (*m_pKeySet, &defPrivateKey);
	
	if ( defPrivateKey == keyRef )
		return true;
	else
		return false;
}


void CKeyObject::GetKeyRef (PGPKeyRef *pKeyRef)
{
	PGPError nErr = PGPGetKeyByKeyID (*m_pKeySet, &m_keyID, 
		kPGPPublicKeyAlgorithm_Invalid, pKeyRef);
}

PGPKeyRef CKeyObject::GetKeyRef()
{
	PGPKeyRef keyRef;
	PGPError nErr = PGPGetKeyByKeyID (*m_pKeySet, &m_keyID, 
		kPGPPublicKeyAlgorithm_Invalid, &keyRef);
	return keyRef;
}

void CKeyObject::GetCreationDate(CString &str)
{
	PGPKeyRef	keyRef;
	PGPTime		keyTimeData;
	PGPError	nErr;

	ASSERT( m_pContext != NULL );
	ASSERT( m_pKeySet != NULL );

	GetKeyRef (&keyRef);
	
	nErr = PGPGetKeyTime (keyRef, kPGPKeyPropCreation, &keyTimeData);
	CTime t ( PGPGetStdTimeFromPGPTime(keyTimeData) );
	str = t.Format ("%m.%d.%Y");
}

void CKeyObject::GetExpirationDate(CString &str)
{
	PGPKeyRef		keyRef;
	PGPTime			keyTimeData;
	PGPError	nErr;

	ASSERT( m_pContext != NULL );
	ASSERT( m_pKeySet != NULL );

	GetKeyRef (&keyRef);
	
	nErr = PGPGetKeyTime (keyRef, kPGPKeyPropExpiration, &keyTimeData);
	if ( keyTimeData != 0 )
	{
		CTime t ( PGPGetStdTimeFromPGPTime(keyTimeData) );
		str = t.Format ("%m.%d.%Y");
	}
	else
		str = _T(kStrKeyTypeNever);
}

void CKeyObject::GetUserID(CString &str)
{
	PGPKeyRef		keyRef;
	PGPUserIDRef	keyUserID;
	char			chName[kPGPMaxKeyIDStringSize];
	PGPSize			nLen;
	PGPError		nErr;

	ASSERT( m_pContext != NULL );
	ASSERT( m_pKeySet != NULL );

	GetKeyRef (&keyRef);

	nErr = PGPGetPrimaryUserID (keyRef, &keyUserID);
	nErr = PGPGetPrimaryUserIDNameBuffer (keyRef, kPGPMaxKeyIDStringSize, chName, &nLen);
	str.Format(chName);
}

PGPKeyID * CKeyObject::GetKeyID()
{
	return &m_keyID;
}

void CKeyObject::GetKeyID(CString &str)
{
	char		outString[kPGPMaxKeyIDStringSize];
	PGPError	nErr;

	ASSERT( m_pContext != NULL );
	ASSERT( m_pKeySet != NULL );

	nErr = PGPGetKeyIDString (&m_keyID, kPGPKeyIDString_Abbreviated, outString);
	if ( !nErr )
		str = _T(outString);
	else
		str = _T(kStrKeyTypeUnknown);
}

void CKeyObject::GetSize(CString &str)
{
	PGPKeyRef		keyRef;
	PGPInt32		nKeyBits, nSubKeyBits, nKeyAlg;
	PGPSubKeyRef	subkeyRef;
	PGPKeyListRef	keyList;
	PGPKeyIterRef	keyIter;
	PGPError		nErr;
	
	ASSERT( m_pContext != NULL );
	ASSERT( m_pKeySet != NULL );

	GetKeyRef (&keyRef);

	PGPGetKeyNumber (keyRef, kPGPKeyPropAlgID, &nKeyAlg);
	
	switch (nKeyAlg)
	{
		case kPGPPublicKeyAlgorithm_RSA :

			PGPGetKeyNumber (keyRef, kPGPKeyPropBits, &nKeyBits);
			str.Format ("%d", nKeyBits);
			break;

		case kPGPPublicKeyAlgorithm_DSA :
			// key key bits
			nErr = PGPGetKeyNumber (keyRef, kPGPKeyPropBits, &nKeyBits);
			str.Format ("%d", nKeyBits);
			
			// now try to get subkey bits
			nErr = PGPOrderKeySet (*m_pKeySet, kPGPAnyOrdering, &keyList);
			nErr = PGPNewKeyIter (keyList, &keyIter);
			nErr = PGPKeyIterSeek (keyIter, keyRef);

			if ( PGPKeyIterNextSubKey (keyIter, &subkeyRef) == 0 )
			{
				nErr = PGPGetSubKeyNumber (subkeyRef, kPGPKeyPropBits, &nSubKeyBits);
				str.Format ("%d/%d", nSubKeyBits, nKeyBits);
			}

			PGPFreeKeyIter (keyIter);
			PGPFreeKeyList (keyList);
			break;

		default :
			str = _T(kStrKeyTypeUnknown);
			break;
	}
}

void CKeyObject::GetAlgID(CString &str)
{
	PGPKeyRef		keyRef;
	PGPInt32		nKeyAlg;
	PGPError		nErr;

	ASSERT( m_pContext != NULL );
	ASSERT( m_pKeySet != NULL );
	
	GetKeyRef(&keyRef);
	nErr = PGPGetKeyNumber (keyRef, kPGPKeyPropAlgID, &nKeyAlg);

	switch ( nKeyAlg )
	{
		case kPGPPublicKeyAlgorithm_RSA:
			str = _T(kStrKeyTypeRSA);
			break;
		case kPGPPublicKeyAlgorithm_DSA:
			str = _T(kStrKeyTypeDSA);
			break;
		default:
			str = _T(kStrKeyTypeUnknown);
	}
}



BOOL CKeyObject::SetAsDefault()
{
	PGPKeyRef	keyRef;
	PGPError	nErr;

	ASSERT( m_pContext != NULL );
	ASSERT( m_pKeySet != NULL );
	
	GetKeyRef(&keyRef);

	/*
	CString str;
	GetDescription(str);
	GetUserID(str);
	*/

	nErr = PGPSetDefaultPrivateKey(keyRef);
	nErr = PGPsdkSavePrefs(*m_pContext);

	if ( nErr )
		return false;
	else
		return true;
}

void CKeyObject::GetDescription(CString &str)
{
	if ( IsPrivate() )
	{
		if ( IsDefault() )
			str = _T(kStrKeyTypeDefpair);
		else
			str = _T(kStrKeyTypePair);
	}
	else
		str = _T(kStrKeyTypePublic);
}



void CKeyObject::Delete()
{
	PGPFilterRef	keyFilter = kInvalidPGPFilterRef;
	PGPKeySetRef	singleKeySet = kInvalidPGPKeySetRef;
	PGPError		nErr;

	ASSERT( m_pContext != NULL );
	ASSERT( m_pKeySet != NULL );

	nErr = PGPNewKeyIDFilter (*m_pContext, &m_keyID, &keyFilter);
	nErr = PGPFilterKeySet (*m_pKeySet, keyFilter, &singleKeySet);
	nErr = PGPRemoveKeys (singleKeySet, *m_pKeySet);

	PGPFreeFilter (keyFilter);
	PGPFreeKeySet (singleKeySet);

	nErr = PGPCommitKeyRingChanges (*m_pKeySet);
}


