///////////////////////////////////////////////////////////////////////////
//                                                                       //
// SpyEdit.cpp : implementation file                                     //
//                                                                       //
// Copyright (c) 2000 Samopal Corporation.                               //
// All right are all right (tm)                                          //
//                                                                       //
// For news and updates visit http://www.samopal.com/soft/pgpicq/        //
// Email your comments to pgpicq@samopal.com                             //
//                                                                       //
// Free use and distribution of this source code allowed                 //
// under the condition of keeping this header intact.                    //
//                                                                       //
///////////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "PGPICQ.h"
#include "SpyEdit.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSpyEdit

CSpyEdit::CSpyEdit()
{
}

CSpyEdit::~CSpyEdit()
{
}


BEGIN_MESSAGE_MAP(CSpyEdit, CEdit)
	//{{AFX_MSG_MAP(CSpyEdit)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSpyEdit message handlers


void CSpyEdit::SetContent(char *chContent, long nLength)
{
	SetSel(0, GetLimitText());
	ReplaceSel(chContent);
}


void CSpyEdit::GetContent(char *chContent)
{
	char chLine[MAX_PATH];
	int nLines = GetLineCount();

	chContent[0] = 0;

	for ( int i=0; i<nLines; i++ ) {
		int nChars = GetLine(i, chLine, sizeof(chLine));
		sprintf (chContent, "%s%s%s", chContent, strlen(chContent)?"\r\n":"", chLine);
		
		//chLine[nChars] = 0;
		//if ( chLine[nChars-1] != '\n' )
		//	sprintf (chContent, "%s%s%s", chContent, strlen(chContent)?"\n":"", chLine);
		//else
		//	sprintf (chContent, "%s%s", chContent, chLine);
	}
}


void CSpyEdit::GetArmoredContent(char *chContent)
{
	char chLine[MAX_PATH];
	long nLines = GetLineCount();
	long nTotalCh = 0;
	long nMsgLen;

	chContent[0] = 0;

	for ( int i=0; i<nLines; i++ ) {
		//int nChars = GetLine(i, chLine, sizeof(chLine));
		int nChars = CEdit::GetLine(i, chLine, sizeof(chLine));


		if ( nChars > 0 )
		{
			chLine[nChars] = 0;

			/*if ( chLine[nChars-1] == '\n' )	{
				chLine[nChars-1] = 0;
				nChars--;
			}*/

			if ( chLine[nChars-1] == '\r' ) {
				chLine[nChars-1] = 0;
				nChars--;	
			}
		}


		nTotalCh += nChars;
		sprintf (chContent, "%s%s", chContent, chLine);
	}

	nMsgLen = strlen(chContent);
}

/*
void CSpyEdit::GetEncryptedContent(char *chContent)
{
	char chLine1[MAX_PATH];
	char chLine2[MAX_PATH];
	int  nDel;
	int  nLines = GetLineCount();

	chContent[0] = 0;
	int i=0;
	
	while ( i < nLines ) {

		int nChars1 = GetLine(i, chLine1, sizeof(chLine1));
		if ( chLine1[nChars1-1] == '\n' )
			chLine1[nChars1-1] = 0;
		else
			chLine1[nChars1] = 0;

		int nChars2 = GetLine(i+1, chLine2, sizeof(chLine2));
		chLine2[nChars2] = 0;
		nDel = 0;
		if ( chLine2[nChars2-1] == '\n' ) {
			chLine2[nChars2-1] = 0;
			nDel = 1;
		}
		if ( chLine2[nChars2-2] == '\r' ) {
			chLine2[nChars2-2] = 0;
			nDel = 2;
		}
		nChars2 -= nDel;
						

		if ( nChars1 + nChars2 == kPGPLineLength ) {
			sprintf (chContent, "%s%s%s%s", chContent, strlen(chContent)?"\r\n":"", chLine1, chLine2);
			i += 2;
		}
		else {
			sprintf (chContent, "%s%s%s", chContent, strlen(chContent)?"\r\n":"", chLine1);
			i += 1;
		}
			
	}

}

*/



int CSpyEdit::GetFirstLast(int *pnFirst, int *pnLast)
{
	char chLine[MAX_PATH];

	*pnFirst = -1;
	*pnLast = -1;
	int nLines = GetLineCount();

	for ( int i=0; i<nLines; i++ )
	{
		if ( GetLine(i, chLine, sizeof(chLine)) )
		{
			if ( !strcmp(chLine, kStrBeginPGP) )
				*pnFirst = i;

			if ( !strcmp(chLine, kStrEndPGP) )
				*pnLast = i;
		}
	}


	return nLines;
}



void CSpyEdit::GetEncryptedContent(char *chContent)
{
	char chLine1[MAX_PATH];
	char chLine2[MAX_PATH];
	int  nLine1, nLine2;
	int	 nFirstLine, nLastLine;

	chContent[0] = 0;
		
	GetFirstLast(&nFirstLine, &nLastLine);

	// not a PGP message
	if ( nFirstLine < 0 || nLastLine < 0 )
	{
		chContent[0] = 0;
		return;
	}

	int i = nFirstLine;
	
	// get header
	sprintf (chContent, "%s%s\n", chContent, kStrBeginPGP);

	// get version and copyright info
	while (i < nLastLine)
	{
		if ( GetLine(++i, chLine1, sizeof(chLine1)) > 0 )
			sprintf (chContent, "%s%s", chContent, chLine1);
		else
			break;
	}
	
	// empty line
	sprintf (chContent, "%s\n\n", chContent);


	while (i < nLastLine-1)
	{
		nLine1 = GetLine(++i, chLine1, sizeof(chLine1));
		if ( nLine1 == kPGPLineLength )
		{
			sprintf (chContent, "%s%s\n", chContent, chLine1);
			continue;
		}

		nLine2 = GetLine(i+1, chLine2, sizeof(chLine2));
		if ( nLine1 + nLine2 == kPGPLineLength )
		{
			sprintf (chContent, "%s%s%s\n", chContent, chLine1, chLine2);
			i++;
			continue;
		}

		break;
	}

	// at this point we know we only have one or two lines left
	for ( ; i < nLastLine-1; i++ )
	{
		GetLine (i, chLine1, sizeof(chLine1));
		sprintf (chContent, "%s%s", chContent, chLine1);
	}

	// footer
	GetLine(nLastLine-1, chLine1, sizeof(chLine1));
	sprintf (chContent, "%s\n%s\n%s", chContent, chLine1, kStrEndPGP);

	//FILE *f = fopen("c:/test111.txt", "w");
	//fprintf (f, chContent);
	//fclose(f);

	return;
}



int CSpyEdit::GetLine(int nIndex, char *chLine, int nSize)
{
	int nChars = CEdit::GetLine(nIndex, chLine, nSize);

	if ( nChars > 0 )
	{
		chLine[nChars] = 0;

		if ( chLine[nChars-1] == '\n' )
		{
			chLine[nChars-1] = 0;
			nChars--;
		}

		if ( chLine[nChars-1] == '\r' ) {
			chLine[nChars-1] = 0;
			nChars--;	
		}
	}

	return nChars;
}


int CSpyEdit::CopyContent()
{
	int nStartChar, nEndChar;

	SetSel(0, -1, true);
	GetSel(nStartChar, nEndChar);
	if ( nStartChar == 0 && nEndChar == 0 )
		return 0;

	Copy();
	SetSel(-1, -1, true);
	return 1;
}

void CSpyEdit::PasteContent()
{
	SetSel(0, -1, true);
	Paste();
}
