///////////////////////////////////////////////////////////////////////////
//                                                                       //
// SplashWnd.cpp : implementation file                                   //
//                                                                       //
// Copyright (c) 2000 Samopal Corporation.                               //
// All right are all right (tm)                                          //
//                                                                       //
// For news and updates visit http://www.samopal.com/soft/pgpicq/        //
// Email your comments to pgpicq@samopal.com                             //
//                                                                       //
// Free use and distribution of this source code allowed                 //
// under the condition of keeping this header intact.                    //
//                                                                       //
///////////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "pgpicq.h"
#include "SplashWnd.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CSplashWnd

CSplashWnd::CSplashWnd()
{
}

CSplashWnd::~CSplashWnd()
{
}


BEGIN_MESSAGE_MAP(CSplashWnd, CWnd)
	//{{AFX_MSG_MAP(CSplashWnd)
	ON_WM_TIMER()
	ON_WM_LBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CSplashWnd message handlers

int CSplashWnd::Init(int nWidth, int nHeight, int nBitmapId, int nTTL)
{
	m_nTimerId = 1;
	m_nTTL	= nTTL;

	DWORD dwExStyle = 0;
	DWORD dwStyle = WS_POPUP;

	int x	= (::GetSystemMetrics(SM_CXSCREEN) - nWidth)/2;
	int y	= (::GetSystemMetrics(SM_CYSCREEN) - nHeight)/2;
    CRect rect(x, y, x+nWidth, y+nHeight);

	LPCTSTR lpstrClass = AfxRegisterWndClass (NULL, 0, 0, 0); 

	if ( lpstrClass == NULL )
		return false;

	if ( !CreateEx (dwExStyle, lpstrClass,"Spalsh Window", 
		dwStyle, rect, NULL, 0) )
		return false;

	HBITMAP hBitmap = ::LoadBitmap (AfxGetInstanceHandle(), MAKEINTRESOURCE(nBitmapId));
	CRect rectBmp(0, 0, nWidth, nHeight);
	m_Bitmap.Create("", WS_CHILD|WS_VISIBLE|SS_BITMAP, rectBmp, this);
 	m_Bitmap.SetBitmap(hBitmap);

	UpdateWindow();

	if ( IsVisible() )
		ShowWindow(SW_SHOWNORMAL);
	else
		ShowWindow(SW_HIDE);

	SetTimer(m_nTimerId, m_nTTL, NULL);

	return true;
}


void CSplashWnd::Finish()
{
	ShowWindow(SW_HIDE);
	KillTimer(m_nTimerId);
}

void CSplashWnd::OnTimer(UINT nIDEvent) 
{
	if ( nIDEvent == m_nTimerId )
		Finish();		

	CWnd::OnTimer(nIDEvent);
}

void CSplashWnd::OnLButtonDown(UINT nFlags, CPoint point) 
{
	Finish();	
	//CWnd::OnLButtonDown(nFlags, point);
}

BOOL CSplashWnd::IsVisible()
{
	HKEY  hKey;
	BOOL  bShowSplash;
	DWORD dwDataLen, dwType;

	if ( RegOpenKeyEx (HKEY_CURRENT_USER, _T(kRegPathPgpIcq),
	     0, KEY_ALL_ACCESS, &hKey) == ERROR_SUCCESS )
	{
		dwDataLen = sizeof(BOOL);
		RegQueryValueEx (hKey, _T("ShowSplashScreen"), NULL, &dwType,
			(unsigned char*)&bShowSplash, &dwDataLen);
		RegCloseKey(hKey);
	}

	return bShowSplash;
}
