///////////////////////////////////////////////////////////////////////////
//                                                                       //
// pgpManager.h                                                          //
//                                                                       //
// Copyright (c) 2000 Samopal Corporation.                               //
// All right are all right (tm)                                          //
//                                                                       //
// For news and updates visit http://www.samopal.com/soft/pgpicq/        //
// Email your comments to pgpicq@samopal.com                             //
//                                                                       //
// Free use and distribution of this source code allowed                 //
// under the condition of keeping this header intact.                    //
//                                                                       //
///////////////////////////////////////////////////////////////////////////


#if !defined(AFX_PGPMANAGER_H__1AA08097_2817_11D4_9309_0001023AC381__INCLUDED_)
#define AFX_PGPMANAGER_H__1AA08097_2817_11D4_9309_0001023AC381__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif

#include "pgpUtilities.h"
#include "pgpKeys.h"
#include "pgpEncode.h"
#include "pgpErrors.h"
#include "pgpPFLErrors.h"



/////////////////////////////////////////////////////////////////////////////
//
// CPgpManager class
//
// Provides access to all the PGP functionality.
//
////////////////////////////////////////////////////////////////////////////


class CPgpManager
{
public:

	CPgpManager();
	virtual ~CPgpManager();
	BOOL OpenKeyrings(CString strPublicKeyring, CString strSecretKeyring);
	BOOL ReleaseKeyrings();
	BOOL Initialize(CString strPublicKeyring, CString strSecretKeyring);

	void GetAllKeys (KeyObjectListT *vecKeyList, int nCol, BOOL bDesc);

	void UploadToKeyServer (CString strServerURL, CString strKeyID);
	void SearchKeyServer ( CString strServerURL );
	int  GenerateKeyPair ( CString strUserID, CString strPass, long nSize = 1024, long nExpDays = 0);
	
	void ImportKeys ( CString strFile = "" );
	void ExportKeys ( KeyPointerListT *pKeys, CString strFile = "");
	
	
	/*
	void SetDefaultKey ( CString strUserID );
	void DeleteKeys ( StringListT *pKeys );
	BOOL IsPair(CString strKey);

	void GetKeyRef ( CString strKey, PGPKeyRef *keyRef);
	void GetKeyCreationDate ( const PGPKeyRef &keyRef, CString strKey, CString &strKeyDate );
	void GetKeyExpirationDate ( const PGPKeyRef &inKeyRef, CString strKey, CString &strKeyDate );
	void GetKeySize ( const PGPKeyRef &inKeyRef, const PGPKeySetRef &inKeySet, CString strKey, CString &strKeySize );
	void GetKeyType ( const PGPKeyRef &inKeyRef, CString strKey, CString &strKeyType );
	void GetKeyID ( const PGPKeyRef &inKeyRef, CString strKey, CString &strKeyID );
	void GetKeyMethod ( const PGPKeyRef &inKeyRef, CString strKey, CString &strKeyMethod );
	BOOL GetKeyList ( KeyObjectListT *vecKeyList, int nCol, BOOL bDesc );
	*/
	
	CString m_strPGPPath;

protected:

	BOOL ObtainPassphrase();
	BOOL IsPGPInstalled();

	PGPContextRef m_pgpContext;
	PGPKeySetRef m_defKeySet;
	CString m_strPassphrase;
};

#endif // !defined(AFX_PGPMANAGER_H__1AA08097_2817_11D4_9309_0001023AC381__INCLUDED_)
