///////////////////////////////////////////////////////////////////////////
//                                                                       //
// pgpKeysView.cpp : implementation file                                 //
//                                                                       //
// Copyright (c) 2000 Samopal Corporation.                               //
// All right are all right (tm)                                          //
//                                                                       //
// For news and updates visit http://www.samopal.com/soft/pgpicq/        //
// Email your comments to pgpicq@samopal.com                             //
//                                                                       //
// Free use and distribution of this source code allowed                 //
// under the condition of keeping this header intact.                    //
//                                                                       //
///////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "pgpKeys.h"

#include "pgpKeysDoc.h"
#include "pgpKeysView.h"
#include "resource.h"
#include "KeypropDlg.h"
#include "NewpairDlg.h"
#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPgpKeysView

IMPLEMENT_DYNCREATE(CPgpKeysView, CListView)

BEGIN_MESSAGE_MAP(CPgpKeysView, CListView)
	//{{AFX_MSG_MAP(CPgpKeysView)
	ON_COMMAND(ID_FILE_NEWKEYPAIR, OnFileNewKeypair)
	ON_WM_CONTEXTMENU()
	ON_COMMAND(ID_EDIT_SELECTALL, OnEditSelectall)
	ON_COMMAND(ID_KEY_DELETEKEY, OnKeyDelete)
	ON_COMMAND(ID_KEY_EXPORTTOFILE, OnKeyExport)
	ON_COMMAND(ID_KEY_IMPORTFROMFILE, OnKeyImport)
	ON_COMMAND(ID_KEY_KEYPROPERTIES, OnKeyProperties)
	ON_COMMAND(ID_KEY_SEARCH, OnKeySearch)
	ON_COMMAND(ID_KEY_SENDTOSRV, OnKeySendToServer)
	ON_COMMAND(ID_HELP_ONLINEMANUAL, OnHelpOnline)
	ON_UPDATE_COMMAND_UI(ID_KEY_KEYPROPERTIES, OnUpdateKeyProperties)
	ON_UPDATE_COMMAND_UI(ID_KEY_DELETEKEY, OnUpdateKeyDelete)
	ON_UPDATE_COMMAND_UI(ID_KEY_EXPORTTOFILE, OnUpdateKeyExport)
	ON_UPDATE_COMMAND_UI(ID_KEY_SENDTOSRV, OnUpdateKeySend)
	ON_NOTIFY_REFLECT(NM_DBLCLK, OnDblclick)
	ON_COMMAND(ID_KEY_SETASDEFAULT, OnKeySetDefault)
	ON_UPDATE_COMMAND_UI(ID_KEY_SETASDEFAULT, OnUpdateKeySetDefault)
	ON_COMMAND(ID_EDIT_OPTIONS, OnEditOptions)
	ON_UPDATE_COMMAND_UI(ID_EDIT_SELECTALL, OnUpdateEditSelectall)
	ON_COMMAND(ID_START_PGPICQ, OnStartPgpicq)
	ON_COMMAND(ID_KEY_COPY, OnKeyCopy)
	ON_UPDATE_COMMAND_UI(ID_KEY_COPY, OnUpdateKeyCopy)
	ON_COMMAND(ID_KEY_PASTE, OnKeyPaste)
	ON_UPDATE_COMMAND_UI(ID_KEY_PASTE, OnUpdateKeyPaste)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPgpKeysView construction/destruction

CPgpKeysView::CPgpKeysView()
{
	m_pSmallImageList = NULL;
}

CPgpKeysView::~CPgpKeysView()
{
}

void CPgpKeysView::OnInitialUpdate()
{
	CListView::OnInitialUpdate();
	UpdateKeyList();
}


/////////////////////////////////////////////////////////////////////////////
// CPgpKeysView diagnostics

#ifdef _DEBUG
void CPgpKeysView::AssertValid() const
{
	CListView::AssertValid();
}

void CPgpKeysView::Dump(CDumpContext& dc) const
{
	CListView::Dump(dc);
}

CPgpKeysDoc* CPgpKeysView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CPgpKeysDoc)));
	return (CPgpKeysDoc*)m_pDocument;
}
#endif //_DEBUG




/////////////////////////////////////////////////////////////////////////////
// CPgpKeysView message handlers

void CPgpKeysView::OnFileNewKeypair() 
{
	CNewpairDlg	newDlg;
	CString		strUserID;

	CPgpKeysDoc *pDoc = GetDocument();

	newDlg.m_strName  = _T(""); //"Vasya Pupkin"; //_T("");
	newDlg.m_strEmail = _T(""); //"pupkin@samopal.com"; //_T("");
	newDlg.m_strPass1 = _T(""); //_T("1234567890"); //_T("");
	newDlg.m_strPass2 = _T(""); //_T("1234567890"); //_T("");
	newDlg.m_nSize = 1024;
	newDlg.m_bExpires = false;

	CTime curt = CTime::GetCurrentTime();
	CTime t ( curt.GetYear()+1, curt.GetMonth(), curt.GetDay(), curt.GetHour(), curt.GetMinute(), curt.GetSecond());
	newDlg.m_strExpdate  = t.Format("%m/%d/%Y");
	

	newDlg.m_pPGPMan = (void*)&(pDoc->m_PGPMan);

	if ( newDlg.DoModal() != IDOK )
		return;

	// Calculate number of days till the key epiration
	int nYear, nMonth, nDay;
	sscanf(newDlg.m_strExpdate.Right(4), "%d", &nYear);
	sscanf(newDlg.m_strExpdate.Left(2), "%d", &nMonth);
	sscanf(newDlg.m_strExpdate.Mid(3, 2), "%d", &nDay);
	CTime expt (nYear, nMonth, nDay, 0, 0, 0);
	CTimeSpan span = expt - curt;
	nDay = span.GetDays() + 1;


	CMainFrame *pMainWnd = (CMainFrame*)AfxGetMainWnd();
	pMainWnd->SetWaitCursor(true);
	
	strUserID.Format ("%s <%s>", newDlg.m_strName, newDlg.m_strEmail);
	
	if ( pDoc->m_PGPMan.GenerateKeyPair (strUserID, newDlg.m_strPass1, newDlg.m_nSize, nDay) )
	{	
		pDoc->OnNewDocument();
		UpdateKeyList();
		pMainWnd->SetWaitCursor(false);

		// select the new key
		CListCtrl &list = GetListCtrl();
		int nItem = list.GetNextItem(-1, LVNI_ALL);
		while ( nItem != -1 )
		{
			CString strItem = list.GetItemText(nItem, 0);
			if ( strItem == strUserID )
				break;
			nItem = list.GetNextItem (nItem, LVNI_ALL);
		}

		list.SetItemState (nItem, LVIS_DROPHILITED|LVIS_SELECTED, LVIS_SELECTED);
		list.EnsureVisible (nItem, false);


		// ask if they want to send the key to server
		CString strMsg;
		strMsg.Format(kStrKeyTypePromptUploadNow, strUserID);
		if ( ::MessageBox ( m_hWnd, strMsg, _T(kStrTitleConfirmation), 
			MB_OKCANCEL|MB_APPLMODAL|MB_ICONEXCLAMATION) == IDOK )
			OnKeySendToServer();
	}
	else
		pMainWnd->SetWaitCursor(false);
}


void CPgpKeysView::UpdateKeyList()
{
	CString	str;

	CListCtrl &list = GetListCtrl();
	list.DeleteAllItems();

	
	// create, initialize, and hook up image list
	if ( !m_pSmallImageList )
	{
		DWORD dwStyle = GetWindowLong(list.m_hWnd, GWL_STYLE); 
		SetWindowLong(list.m_hWnd, GWL_STYLE, (dwStyle & ~LVS_TYPEMASK) | LVS_REPORT); 

		m_pSmallImageList = new CImageList;
		ASSERT(m_pSmallImageList != NULL);
		m_pSmallImageList->Create(16, 16, ILC_COLOR32, 2, 1);
		m_pSmallImageList->Add(AfxGetApp()->LoadIcon(IDI_PUBKEY));
		m_pSmallImageList->Add(AfxGetApp()->LoadIcon(IDI_PRIVKEY));

		list.SetImageList(m_pSmallImageList, LVSIL_SMALL);
		list.SetTextColor(RGB(0,0,0));

		RECT rect;
		list.GetWindowRect(&rect);
		int nWidth = rect.right - rect.left;

		list.InsertColumn(0, kStrHeaderKeys, LVCFMT_LEFT, nWidth/2, 0);
		list.InsertColumn(1, kStrHeaderType, LVCFMT_LEFT, nWidth/5, 1);
		list.InsertColumn(2, kStrHeaderSize, LVCFMT_LEFT, nWidth/7, 2);
		list.InsertColumn(3, kStrHeaderCreated, LVCFMT_LEFT, nWidth/7+5, 2);
	}
	

	LV_ITEM	listItem;
	listItem.mask = LVIF_TEXT | LVIF_IMAGE | LVIF_PARAM;
	int nIndex = 0;

	CPgpKeysDoc *pDoc = GetDocument();

	KeyObjectListT::iterator first = pDoc->m_KeyList.begin();
	KeyObjectListT::iterator last = pDoc->m_KeyList.end();

	while ( first != last )
	{
		listItem.iItem = 0;
		listItem.iSubItem = 0;
		
		first->GetUserID(str);
		listItem.pszText = str.GetBuffer(str.GetLength());
		
		if ( first->IsPrivate() )
			listItem.iImage = 1;
		else
			listItem.iImage = 0;

		list.InsertItem (&listItem);
		
		first->GetDescription(str);
		list.SetItemText(0, 1, str);

		first->GetSize(str);
		list.SetItemText(0, 2, str);

		first->GetCreationDate(str);
		list.SetItemText(0, 3, str);

		// attach a pointer to CKeyObject in CDocument::m_KeyList 
		// to according list item
		list.SetItemData(0, (DWORD)first );

		first++;
	}

	if ( list.GetItemCount() == 0 )
		OnFileNewKeypair();
}


int CPgpKeysView::GetSelected(StringListT *vecSelected)
{
	int nTotal = 0;
	CListCtrl &list = GetListCtrl();

	for ( int i=0; i<list.GetItemCount(); i++ )
		if ( list.GetItemState(i, LVIS_SELECTED) )
		{
			nTotal++;
			vecSelected->push_back( list.GetItemText(i, 0) );
			CString s = list.GetItemText(i, 0);
		}

	return nTotal;
}


int CPgpKeysView::GetSelected(KeyPointerListT *vecSelected)
{
	int nTotal = 0;
	CListCtrl &list = GetListCtrl();

	for ( int i=0; i<list.GetItemCount(); i++ )
		if ( list.GetItemState(i, LVIS_SELECTED) )
		{
			nTotal++;
			vecSelected->push_back( list.GetItemData(i) );

			CKeyObject*pKey = (CKeyObject*)list.GetItemData(i);
			CString str;
			pKey->GetUserID(str);
		}

	return nTotal;
}



void CPgpKeysView::OnContextMenu(CWnd* pWnd, CPoint point) 
{
	StringListT vecSelected;
	if ( !GetSelected(&vecSelected) )
		return;

	CMenu menu;
	VERIFY( menu.LoadMenu(IDR_KEY_MENU) );
	CMenu* pPopup = menu.GetSubMenu(0);
	ASSERT(pPopup != NULL);

	pPopup->TrackPopupMenu (
		TPM_LEFTALIGN | TPM_RIGHTBUTTON, 
		point.x, point.y,
		GetParent() );	
}




BOOL CPgpKeysView::OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult) 
{
	HD_NOTIFY	*pHDN = (HD_NOTIFY*)lParam;

	LPNMHDR pNH = (LPNMHDR) lParam;

	// wParam is zero for Header ctrl

	if ( wParam == 0 && ( pNH->code==4294966974 || pNH->code==4294966994 ) ) // 4294966994 4294967280
	{
		POINT Point;
		GetCursorPos (&Point);
		ScreenToClient(&Point);
		HDHITTESTINFO HitTest;

		HitTest.pt.x = Point.x;
		HitTest.pt.y = Point.y;

		// Send the Hit Test Message
		CListCtrl &list = GetListCtrl();
		list.GetHeaderCtrl()->SendMessage(HDM_HITTEST,0,(LPARAM)&HitTest);

		if ( HitTest.iItem == 1 )
			return CListView::OnNotify(wParam, lParam, pResult);

		CPgpKeysDoc* pDoc = GetDocument();

		if( HitTest.iItem == pDoc->m_nSortCol )
			pDoc->m_bDesc = !pDoc->m_bDesc;
		else
			pDoc->m_bDesc = true;

		pDoc->m_nSortCol = HitTest.iItem;
		pDoc->OnNewDocument();
		UpdateKeyList();
	}
	
	return CListView::OnNotify(wParam, lParam, pResult);
}


void CPgpKeysView::OnEditSelectall() 
{
	CListCtrl &list = GetListCtrl();
	for ( int i=0; i<list.GetItemCount(); i++ )
		list.SetItemState (i, LVIS_SELECTED, LVIS_SELECTED);	
}
void CPgpKeysView::OnUpdateEditSelectall(CCmdUI* pCmdUI) 
{
	if ( GetListCtrl().GetItemCount() > 0 )
		pCmdUI->Enable(true);
	else
		pCmdUI->Enable(false);	
}


void CPgpKeysView::OnKeyDelete() 
{
	KeyPointerListT vecSelected;
	GetSelected(&vecSelected);
	
	CString str, strMsg (kStrKeyTypePromptDeleteKeys);

	vector<long>::iterator first = vecSelected.begin();
	vector<long>::iterator last = vecSelected.end();
	while ( first != last )
	{
		CKeyObject *pKey = (CKeyObject*)(*first);
		pKey->GetUserID(str);
		strMsg += _T("\n") + str;
		first++;
	}

	if ( ::MessageBox ( m_hWnd, strMsg, _T(kStrTitleConfirmation), 
		  MB_OKCANCEL|MB_APPLMODAL|MB_ICONEXCLAMATION) == IDOK )
	{
		CPgpKeysDoc* pDoc = GetDocument();
		pDoc->DeleteFromList (&vecSelected);
		pDoc->OnNewDocument();
		UpdateKeyList();
	}
}
void CPgpKeysView::OnUpdateKeyDelete(CCmdUI* pCmdUI) 
{
	KeyPointerListT vecSelected;
	if ( GetSelected(&vecSelected) )
		pCmdUI->Enable(true);
	else
		pCmdUI->Enable(false);
}


void CPgpKeysView::OnKeyExport() 
{
	static char BASED_CODE szFilter[] = kStrFileFilterAscii;
	char szName[255];

	KeyPointerListT vecSelected;
	if ( GetSelected(&vecSelected) > 1 )
		strcpy ( szName, kStrFileNameAscii );
	else
	{
		CKeyObject*pKey = (CKeyObject*)vecSelected[0];
		CString str;
		pKey->GetUserID(str);
		int nPos = str.Find("<");
		strcpy ( szName, str.Left(nPos) );
	}

 
	CFileDialog expFile (false, kStrFileExtAscii, szName, 
		OFN_OVERWRITEPROMPT, szFilter, this);
	if ( expFile.DoModal() == IDOK )
	{
		CPgpKeysDoc* pDoc = GetDocument();
		pDoc->m_PGPMan.ExportKeys (&vecSelected, expFile.GetPathName());
	}
}
void CPgpKeysView::OnUpdateKeyExport(CCmdUI* pCmdUI) 
{
	KeyPointerListT vecSelected;
	if ( GetSelected(&vecSelected) )
		pCmdUI->Enable(true);
	else
		pCmdUI->Enable(false);	
}



void CPgpKeysView::OnKeyImport() 
{
	static char BASED_CODE szFilter[] = kStrFileFilterText;

	CFileDialog impFile (true, NULL, NULL, OFN_HIDEREADONLY, szFilter, this);

	if ( impFile.DoModal() == IDOK )
	{
		CPgpKeysDoc* pDoc = GetDocument();
		pDoc->m_PGPMan.ImportKeys ( impFile.GetPathName() );
		pDoc->OnNewDocument();
		UpdateKeyList();
	}
}




void CPgpKeysView::OnDblclick(NMHDR* pNMHDR, LRESULT* pResult) 
{
	*pResult = 0;

	KeyPointerListT vecSelected;
	if ( GetSelected(&vecSelected) == 1 )
		OnKeyProperties();	
}

void CPgpKeysView::OnKeyProperties()
{
	CKeypropDlg keypropDlg;
	KeyPointerListT vecSelected;
	
	GetSelected(&vecSelected);
	CKeyObject *pKey = (CKeyObject *)vecSelected[0];

	pKey->GetUserID (keypropDlg.m_strUserID);
	pKey->GetDescription (keypropDlg.m_strType);
	pKey->GetKeyID (keypropDlg.m_strID);
	pKey->GetSize (keypropDlg.m_strSize);
	pKey->GetAlgID (keypropDlg.m_strMethod);
	pKey->GetCreationDate (keypropDlg.m_strCreated);
	pKey->GetExpirationDate(keypropDlg.m_strExpires);
		
	keypropDlg.DoModal();
}
void CPgpKeysView::OnUpdateKeyProperties(CCmdUI* pCmdUI) 
{
	KeyPointerListT vecSelected;
	if ( GetSelected(&vecSelected) == 1 )
		pCmdUI->Enable(true);
	else
		pCmdUI->Enable(false);
}



void CPgpKeysView::OnKeySearch() 
{
	CPgpKeysDoc* pDoc = GetDocument();
	pDoc->m_PGPMan.SearchKeyServer( pDoc->m_strServerURL );

	pDoc->OnNewDocument();
	UpdateKeyList();
}


void CPgpKeysView::OnKeySendToServer() 
{
	StringListT vecSelected;
	GetSelected(&vecSelected);
	CPgpKeysDoc* pDoc = GetDocument();

	CMainFrame *pMainWnd = (CMainFrame*)AfxGetMainWnd();
	pMainWnd->SetWaitCursor(true);
	pDoc->m_PGPMan.UploadToKeyServer(pDoc->m_strServerURL, vecSelected[0]);
	pMainWnd->SetWaitCursor(false);
}
void CPgpKeysView::OnUpdateKeySend(CCmdUI* pCmdUI) 
{
	KeyPointerListT vecSelected;
	if ( GetSelected(&vecSelected) == 1 )
	{
		CKeyObject *pKey = (CKeyObject *)vecSelected[0];
		if ( pKey->IsPrivate() )
		{
			pCmdUI->Enable(true);
			return;
		}
	}
	pCmdUI->Enable(false);
}



void CPgpKeysView::OnKeySetDefault() 
{
	KeyPointerListT vecSelected;
	GetSelected(&vecSelected);

	CKeyObject *pKey = (CKeyObject *)vecSelected[0];
	if ( !pKey->SetAsDefault() )
		::MessageBox ( NULL, _T(kStrErrorDefaultKey), _T(kStrTitleError), MB_OK|MB_APPLMODAL|MB_ICONEXCLAMATION);
	else
	{	
		GetDocument()->OnNewDocument();
		UpdateKeyList();
	}
}
void CPgpKeysView::OnUpdateKeySetDefault(CCmdUI* pCmdUI) 
{
	KeyPointerListT vecSelected;
	if ( GetSelected(&vecSelected) == 1 )
	{
		CKeyObject *pKey = (CKeyObject *)vecSelected[0];
		if ( pKey->IsPrivate() )
		{
			pCmdUI->Enable(true);
			return;
		}
	}
	pCmdUI->Enable(false);
}




void CPgpKeysView::OnHelpOnline() 
{
	// TODO: Add your command handler code here
	
}




void CPgpKeysView::OnEditOptions() 
{
	CPgpKeysDoc *pDoc = GetDocument();
	if ( pDoc->EditOptions() )
	{
		pDoc->Init();
		pDoc->OnNewDocument();
		UpdateKeyList();
	}
}



void CPgpKeysView::OnStartPgpicq() 
{
	char  chInstPath[MAX_PATH];
	HKEY  hKey;

	if ( RegOpenKeyEx (HKEY_CURRENT_USER, _T(kRegPathPgpIcq), 0, 
						KEY_ALL_ACCESS, &hKey) == ERROR_SUCCESS )
	{

		DWORD dwType, dwDataLen;
		dwDataLen = MAX_PATH;
				
		if ( RegQueryValueEx (hKey, _T(kStrInstPath), NULL, &dwType, 
			(unsigned char*)chInstPath, &dwDataLen) == ERROR_SUCCESS )

		RegCloseKey(hKey);
	}
	else
	{
		::MessageBox (NULL, _T(kMsgReinstall), _T(kTitleError), MB_APPLMODAL|MB_ICONEXCLAMATION);
		return;
	}

	CString m_strPath;
	m_strPath.Format ("%s\\%s", chInstPath, kStrPathPgpIcq);

	if ( int(::ShellExecute ( NULL, "open", m_strPath, NULL, "", SW_SHOWNORMAL)) < 32 )
		::MessageBox (NULL, _T(kMsgPgpICQFailed), 
			_T(kTitleError), MB_APPLMODAL|MB_ICONEXCLAMATION);	
}



void CPgpKeysView::OnKeyCopy() 
{
	static char BASED_CODE szFilter[] = kStrFileFilterAscii;
	char szName[255];

	KeyPointerListT vecSelected;
	if ( GetSelected(&vecSelected) > 1 )
		strcpy ( szName, kStrFileNameAscii );
	else
	{
		CKeyObject*pKey = (CKeyObject*)vecSelected[0];
		CString str;
		pKey->GetUserID(str);
		int nPos = str.Find("<");
		strcpy ( szName, str.Left(nPos) );
	}
 
	CPgpKeysDoc* pDoc = GetDocument();
	pDoc->m_PGPMan.ExportKeys (&vecSelected);
}
void CPgpKeysView::OnUpdateKeyCopy(CCmdUI* pCmdUI) 
{
	KeyPointerListT vecSelected;
	if ( GetSelected(&vecSelected) > 0 )
		pCmdUI->Enable(true);
	else
		pCmdUI->Enable(false);	
}



void CPgpKeysView::OnKeyPaste() 
{
	CPgpKeysDoc* pDoc = GetDocument();
	pDoc->m_PGPMan.ImportKeys ();
	pDoc->OnNewDocument();
	UpdateKeyList();	
}
void CPgpKeysView::OnUpdateKeyPaste(CCmdUI* pCmdUI) 
{
	if ( IsClipboardFormatAvailable(CF_TEXT) )
		pCmdUI->Enable(true);
	else
		pCmdUI->Enable(false);
}
