///////////////////////////////////////////////////////////////////////////
//                                                                       //
// SearchDlg.cpp : implementation file                                   //
//                                                                       //
// Copyright (c) 2000 Samopal Corporation.                               //
// All right are all right (tm)                                          //
//                                                                       //
// For news and updates visit http://www.samopal.com/soft/pgpicq/        //
// Email your comments to pgpicq@samopal.com                             //
//                                                                       //
// Free use and distribution of this source code allowed                 //
// under the condition of keeping this header intact.                    //
//                                                                       //
///////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "pgpKeys.h"
#include "SearchDlg.h"
#include "pgpManager.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSearchDlg dialog


CSearchDlg::CSearchDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSearchDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSearchDlg)
	m_strSearch = _T("");
	m_strServer = _T("");
	m_strNumKeys = _T("");
	//}}AFX_DATA_INIT

	m_pSmallImageList = NULL;
	m_strNumKeys = "";

	m_foundKeySet = kInvalidPGPKeySetRef;
	m_returnKeySet = kInvalidPGPKeySetRef;
}


void CSearchDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSearchDlg)
	DDX_Control(pDX, IDC_CLEAR_BTN, m_btnClear);
	DDX_Control(pDX, IDC_LIST, m_List);
	DDX_Control(pDX, ID_SEARCH_BTN, m_btnSearch);
	DDX_Control(pDX, ID_IMPORT_BTN, m_btnImport);
	DDX_Text(pDX, IDC_EDIT_SEARCH, m_strSearch);
	DDX_Text(pDX, IDC_EDIT_SERVER, m_strServer);
	DDX_Text(pDX, IDC_STATIC_NUM, m_strNumKeys);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSearchDlg, CDialog)
	//{{AFX_MSG_MAP(CSearchDlg)
	ON_EN_CHANGE(IDC_EDIT_SEARCH, OnChangeEditSearch)
	ON_BN_CLICKED(ID_SEARCH_BTN, OnDoSearch)
	ON_WM_SETCURSOR()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_CLEAR_BTN, OnDoClearResults)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_LIST, OnListItemChanged)
	ON_BN_CLICKED(ID_IMPORT_BTN, OnImport)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSearchDlg message handlers

BOOL CSearchDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	m_btnImport.EnableWindow(false);
	m_btnSearch.EnableWindow(false);
	m_btnClear.EnableWindow(false);

	m_bWait = false;
	m_hCurWait = AfxGetApp()->LoadStandardCursor (MAKEINTRESOURCE(IDC_WAIT));

	m_foundKeySet = kInvalidPGPKeySetRef;


	if ( !m_pSmallImageList )
	{
		m_pSmallImageList = new CImageList;
		ASSERT(m_pSmallImageList != NULL);
		m_pSmallImageList->Create(16, 16, ILC_COLOR32, 2, 1);
		m_pSmallImageList->Add(AfxGetApp()->LoadIcon(IDI_PUBKEY));
		
		m_List.SetImageList(m_pSmallImageList, LVSIL_SMALL);
		
		RECT rect;
		m_List.GetWindowRect(&rect);
		int nWidth = rect.right - rect.left;
		m_List.InsertColumn(0, kStrHeaderUserID, LVCFMT_LEFT, nWidth/3-5, 0);
		m_List.InsertColumn(1, kStrHeaderKeyID, LVCFMT_LEFT, nWidth/6, 1);
		m_List.InsertColumn(2, kStrHeaderSize, LVCFMT_LEFT, nWidth/8, 2);
		m_List.InsertColumn(3, kStrHeaderType, LVCFMT_LEFT, nWidth/8, 3);
		m_List.InsertColumn(4, kStrHeaderCreated, LVCFMT_LEFT, nWidth/8, 4);
		m_List.InsertColumn(5, kStrHeaderExpires, LVCFMT_LEFT, nWidth/8, 5);
		m_List.SetTextColor(RGB(0,0,80));
	}

	return TRUE;
}

void CSearchDlg::OnChangeEditSearch() 
{
	UpdateData();
	if ( m_strSearch.GetLength() )
		m_btnSearch.EnableWindow(true);
	else
		m_btnSearch.EnableWindow(false);

}

void CSearchDlg::OnDoSearch() 
{
	int					nErr;
	PGPKeyServerRef		keyServer;
	PGPFilterRef		keyFilter = kInvalidPGPFilterRef;
	PGPtlsSessionRef	tlsSession;
	PGPKeyListRef		keyList;
	PGPKeyIterRef		keyIter;
	PGPKeyRef			key;


	m_vecKeyList.clear();
	m_List.DeleteAllItems();

	m_btnSearch.EnableWindow(false);
	::SetCursor( m_hCurWait );
	m_bWait = true;
	UpdateData();

	if ( m_foundKeySet != kInvalidPGPKeySetRef )
	{
		PGPFreeKeySet (m_foundKeySet);
		m_foundKeySet = kInvalidPGPKeySetRef;
	}

	nErr = PGPKeyServerInit();

	nErr = PGPNewUserIDStringFilter (m_pgpContext, 
		LPCSTR(m_strSearch), kPGPMatchSubString, &keyFilter);
	
	nErr = PGPNewKeyServer (m_pgpContext, kPGPKeyServerClass_PGP,
			&keyServer, PGPONetURL(m_pgpContext, m_strServer),
			PGPOLastOption(m_pgpContext) );

	nErr = PGPGetKeyServerTLSSession (keyServer, &tlsSession);

	nErr = PGPKeyServerOpen (keyServer, tlsSession);
	if ( nErr )
	{
		::MessageBox (this->m_hWnd, _T(kStrErrorServerConnect), _T(kStrTitleError),
			MB_OK|MB_APPLMODAL|MB_ICONEXCLAMATION);
		m_bWait = false;
		m_btnSearch.EnableWindow(true);
		return;
	}

	nErr = PGPQueryKeyServer (keyServer, keyFilter, &m_foundKeySet);
	if ( nErr )
	{
		::MessageBox (this->m_hWnd, _T(kStrErrorServerQuery), _T(kStrTitleError), 
			MB_OK|MB_APPLMODAL|MB_ICONEXCLAMATION);
		m_bWait = false;
		m_btnSearch.EnableWindow(true);
		return;
	}

	nErr = PGPFreeTLSSession (tlsSession);
	nErr = PGPFreeKeyServer(keyServer);
	nErr = PGPFreeFilter(keyFilter);


	/*
	PGPUInt32 numKeys;
	PGPCountKeys (foundKeySet, &numKeys);
	CString strMsg;
	strMsg.Format("Found %d keys!", numKeys);
	AfxMessageBox(strMsg);
	*/

	
	// Create a keylist from keyset
	nErr = PGPOrderKeySet (m_foundKeySet, kPGPReverseUserIDOrdering/*kPGPAnyOrdering*/, &keyList);
	nErr = PGPNewKeyIter (keyList, &keyIter);
	nErr = PGPKeyIterNext ( keyIter, &key);

	while ( key )
	{
		CKeyObject	keyObject;
		CString		str;
		LV_ITEM		listItem;

		keyObject.Create(&m_pgpContext, &m_foundKeySet, key);
		
		listItem.mask = LVIF_TEXT | LVIF_IMAGE | LVIF_PARAM;
		listItem.lParam	= 0;
		int nIndex = 0;

		listItem.iItem = 0;
		listItem.iSubItem = 0;
		listItem.iImage = 0;
		
		
		keyObject.GetUserID(str);
		listItem.pszText = str.GetBuffer(str.GetLength());
		m_List.InsertItem (&listItem);

		keyObject.GetKeyID(str);
		m_List.SetItemText(0, 1, str);

		keyObject.GetSize(str);
		m_List.SetItemText(0, 2, str);

		keyObject.GetAlgID(str);
		m_List.SetItemText(0, 3, str);

		keyObject.GetCreationDate(str);
		m_List.SetItemText(0, 4, str);

		keyObject.GetExpirationDate(str);
		m_List.SetItemText(0, 5, str);

		m_vecKeyList.push_back(keyObject);
		m_List.SetItemData( 0, (long)keyObject.GetKeyRef() );
		
		nErr = PGPKeyIterNext ( keyIter, &key);
	}

	if ( m_List.GetItemCount() > 0 )
	{
		m_btnClear.EnableWindow(true);
	}
	else
		m_btnClear.EnableWindow(false);

	m_bWait = false;
	m_btnSearch.EnableWindow(true);

	m_strNumKeys.Format (kStrKeyTypePromptFound,  m_List.GetItemCount());
	((CStatic*)GetDlgItem(IDC_STATIC_NUM))->SetWindowText(m_strNumKeys);
	UpdateData();
}


void CSearchDlg::OnImport() 
{
	int		nErr;

	PGPNewKeySet(m_pgpContext, &m_returnKeySet);
	
	KeyObjectListT::iterator first = m_vecKeyList.begin();
	KeyObjectListT::iterator last = m_vecKeyList.end();

	while ( first != last )
	{
		POSITION pos = m_List.GetFirstSelectedItemPosition();
		while (pos)
		{
			int nItem = m_List.GetNextSelectedItem(pos);
			//TRACE1("Item %d was selected!\n", nItem);

			PGPKeyRef thisKey = (PGPKeyRef) m_List.GetItemData(nItem);
			PGPKeyRef keyRef;
			first->GetKeyRef(&keyRef);
			
			if ( thisKey == keyRef )
			{
				PGPFilterRef	keyFilter;
				PGPKeySetRef	keySet;

				nErr = PGPNewKeyIDFilter (m_pgpContext, first->GetKeyID(), &keyFilter);
				nErr = PGPFilterKeySet (m_foundKeySet, keyFilter, &keySet);
				nErr = PGPAddKeys (keySet, m_returnKeySet);

				PGPFreeFilter (keyFilter);
				PGPFreeKeySet (keySet);

				//ASSERT ( !nErr );				
			}
		}

		first++;
	}

	OnOK();
}


BOOL CSearchDlg::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message) 
{
	if ( m_bWait ) 
	{
		::SetCursor( m_hCurWait );
		return true;
	}
	else
		return CDialog::OnSetCursor(pWnd, nHitTest, message);
}


void CSearchDlg::OnDestroy() 
{
	CDialog::OnDestroy();

	if ( m_foundKeySet != kInvalidPGPKeySetRef )
	{
		PGPFreeKeySet (m_foundKeySet);
		m_foundKeySet = kInvalidPGPKeySetRef;
	}
}


void CSearchDlg::OnDoClearResults() 
{
	m_List.DeleteAllItems();
	m_strNumKeys = _T("");
	((CStatic*)GetDlgItem(IDC_STATIC_NUM))->SetWindowText(m_strNumKeys);
	m_btnClear.EnableWindow(false);
}

void CSearchDlg::OnListItemChanged(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

	if ( m_List.GetSelectedCount() )
		m_btnImport.EnableWindow(true);
	else
		m_btnImport.EnableWindow(false);
	
	*pResult = 0;
}