///////////////////////////////////////////////////////////////////////////
//                                                                       //
// NewpairDlg.cpp : implementation file                                  //
//                                                                       //
// Copyright (c) 2000 Samopal Corporation.                               //
// All right are all right (tm)                                          //
//                                                                       //
// For news and updates visit http://www.samopal.com/soft/pgpicq/        //
// Email your comments to pgpicq@samopal.com                             //
//                                                                       //
// Free use and distribution of this source code allowed                 //
// under the condition of keeping this header intact.                    //
//                                                                       //
///////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "pgpKeys.h"
#include "NewpairDlg.h"
#include "pgpManager.h"
#include "keyServer.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CNewpairDlg dialog


CNewpairDlg::CNewpairDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CNewpairDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CNewpairDlg)
	m_strEmail = _T("");
	m_strName = _T("");
	m_strPass1 = _T("");
	m_strPass2 = _T("");
	m_nSize = 0;
	m_strExpdate = _T("");
	//}}AFX_DATA_INIT
}


void CNewpairDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNewpairDlg)
	DDX_Text(pDX, IDC_EDIT_EMAIL, m_strEmail);
	DDX_Text(pDX, IDC_EDIT_NAME, m_strName);
	DDX_Text(pDX, IDC_EDIT_PASS1, m_strPass1);
	DDX_Text(pDX, IDC_EDIT_PASS2, m_strPass2);
	DDX_Text(pDX, IDC_EDIT_KEYSIZE, m_nSize);
	DDX_Text(pDX, IDC_EDIT_EXPDATE, m_strExpdate);
	DDV_MaxChars(pDX, m_strExpdate, 10);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CNewpairDlg, CDialog)
	//{{AFX_MSG_MAP(CNewpairDlg)
	ON_BN_CLICKED(IDC_RADIO_EXPDATE, OnRadioExpdate)
	ON_BN_CLICKED(IDC_RADIO_EXPNEVER, OnRadioExpnever)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CNewpairDlg message handlers


BOOL CNewpairDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	CButton *pRad1 = (CButton*)GetDlgItem(IDC_RADIO_EXPNEVER);
	CButton *pRad2 = (CButton*)GetDlgItem(IDC_RADIO_EXPDATE);
	CEdit   *pEdit = (CEdit*)GetDlgItem(IDC_EDIT_EXPDATE);
	if ( !m_bExpires )
	{		
		pRad1->SetCheck(1);
		pRad2->SetCheck(0);
		pEdit->SetReadOnly(1);
	}
	else
	{
		pRad1->SetCheck(0);
		pRad2->SetCheck(1);
		pEdit->SetReadOnly(0);
	}
	
	return true;
}



void CNewpairDlg::OnOK() 
{
	UpdateData();

	if ( m_bExpires )
	{
		if ( m_strExpdate.GetLength()!=10 || m_strExpdate[2]!='/' || m_strExpdate[5]!='/' )
		{
			AfxMessageBox(_T(kStrKeyTypePromptExpdate));
			return;
		}
	}

	if ( !m_strName.GetLength() )
	{
		AfxMessageBox(_T(kStrKeyTypePromptName));
		return;
	}

	if ( !m_strEmail.GetLength() )
	{
		AfxMessageBox(_T(kStrKeyTypePromptEmail));
		return;
	}

	if ( m_strPass1.GetLength() < 5 )
	{
		AfxMessageBox(_T(kStrKeyTypePromptPassShort));
		return;
	}

	if ( m_strPass1 != m_strPass2 )
	{
		AfxMessageBox(_T(kStrKeyTypePromptPassMissmatch));
		return;
	}

	if ( m_nSize < 512 || m_nSize > 4096 )
	{
		AfxMessageBox(_T(kStrBadKeySize));
		return;
	}
	
	CDialog::OnOK();
}


void CNewpairDlg::OnRadioExpdate() 
{
	CButton *pRad1 = (CButton*)GetDlgItem(IDC_RADIO_EXPNEVER);
	CButton *pRad2 = (CButton*)GetDlgItem(IDC_RADIO_EXPDATE);
	CEdit   *pEdit = (CEdit*)GetDlgItem(IDC_EDIT_EXPDATE);
	
	pRad1->SetCheck(0);
	pRad2->SetCheck(1);
	pEdit->SetReadOnly(0);

	m_bExpires = true;
}

void CNewpairDlg::OnRadioExpnever() 
{
	CButton *pRad1 = (CButton*)GetDlgItem(IDC_RADIO_EXPNEVER);
	CButton *pRad2 = (CButton*)GetDlgItem(IDC_RADIO_EXPDATE);
	CEdit   *pEdit = (CEdit*)GetDlgItem(IDC_EDIT_EXPDATE);

	pRad1->SetCheck(1);
	pRad2->SetCheck(0);
	pEdit->SetReadOnly(1);

	m_bExpires = false;
}
