///////////////////////////////////////////////////////////////////////////
//                                                                       //
// PGPICQDlg.cpp : implementation file                                   //
//                                                                       //
// Copyright (c) 2000 Samopal Corporation.                               //
// All right are all right (tm)                                          //
//                                                                       //
// For news and updates visit http://www.samopal.com/soft/pgpicq/        //
// Email your comments to pgpicq@samopal.com                             //
//                                                                       //
// Free use and distribution of this source code allowed                 //
// under the condition of keeping this header intact.                    //
//                                                                       //
///////////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "PGPICQ.h"
#include "PGPICQDlg.h"
#include "AboutDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


const char* kpcTrayNotificationMsg = kTrayNotificationMsg;
static BOOL CALLBACK EnumWindowsProc (HWND hwnd, LPARAM lParam);


/////////////////////////////////////////////////////////////////////////////
// CPGPICQDlg dialog

CPGPICQDlg::CPGPICQDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPGPICQDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPGPICQDlg)
	//}}AFX_DATA_INIT

	// LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_pTrayIcon = NULL;

	// Create modeless dialog
	Create (IDD, pParent);
}

void CPGPICQDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPGPICQDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPGPICQDlg, CDialog)
	//{{AFX_MSG_MAP(CPGPICQDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_QUERYDRAGICON()
	ON_WM_TIMER()
	ON_COMMAND(ID_ICQPGP_OPTIONS, OnShow)
	ON_COMMAND(IDM_ABOUTBOX, OnAbout)
	ON_COMMAND(ID_ICQPGP_PGPKEYS, OnPGPKeys)
	ON_COMMAND(ID_ICQPGP_EXIT, OnExit)
	ON_COMMAND(ID_ICQPGP_HELP, OnHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



// delete modeless dialog
void CPGPICQDlg::PostNcDestroy() 
{
	delete this;	
	CDialog::PostNcDestroy();
}


BOOL CPGPICQDlg::DestroyWindow() 
{
	UnhookWindowsHookEx (m_hHook);
 
	if ( m_pTrayIcon )
		delete m_pTrayIcon;
	KillTimer(kRefreshTimerId);	

	return CDialog::DestroyWindow();
}



/////////////////////////////////////////////////////////////////////////////
// CPGPICQDlg command handlers


// system tray icon command: show options
void CPGPICQDlg::OnShow() 
{
	ShowWindow(SW_SHOWNORMAL);
}

// system tray icon command: launch PGPKeys
void CPGPICQDlg::OnPGPKeys() 
{
	char  chInstPath[MAX_PATH];
	HKEY  hKey;

	if ( RegOpenKeyEx (HKEY_CURRENT_USER, _T(kRegPathPgpIcq), 0, 
						KEY_ALL_ACCESS, &hKey) == ERROR_SUCCESS )
	{
		DWORD dwType, dwDataLen;
		dwDataLen = MAX_PATH;
				
		if ( RegQueryValueEx (hKey, _T(kStrInstPath), NULL, &dwType, 
			(unsigned char*)chInstPath, &dwDataLen) == ERROR_SUCCESS )

		RegCloseKey(hKey);
	}
	else
	{
		::MessageBox (NULL, _T(kMsgReinstall), _T(kTitleError), MB_APPLMODAL|MB_ICONEXCLAMATION);
		exit(0);
		return;
	}

	CString m_strPath;
	m_strPath.Format ("%s\\%s", chInstPath, kStrPathPgpKeys);

	if ( int(::ShellExecute ( NULL, "open", m_strPath, 
				NULL, "", SW_SHOWNORMAL)) < 32 )
		::MessageBox (NULL, _T(kMsgPgpKeysFailed), 
			_T(kTitleError), MB_APPLMODAL|MB_ICONEXCLAMATION);
}


void CPGPICQDlg::OnHelp() 
{
	char  chInstPath[MAX_PATH];
	HKEY  hKey;

	if ( RegOpenKeyEx (HKEY_CURRENT_USER, _T(kRegPathPgpIcq), 0, 
						KEY_ALL_ACCESS, &hKey) == ERROR_SUCCESS )
	{
		DWORD dwType, dwDataLen;
		dwDataLen = MAX_PATH;
				
		if ( RegQueryValueEx (hKey, _T(kStrInstPath), NULL, &dwType, 
			(unsigned char*)chInstPath, &dwDataLen) == ERROR_SUCCESS )

		RegCloseKey(hKey);
	}
	else
	{
		::MessageBox (NULL, _T(kMsgReinstall), _T(kTitleError), MB_APPLMODAL|MB_ICONEXCLAMATION);
		exit(0);
		return;
	}

	CString m_strPath;
	m_strPath.Format ("%s\\%s", chInstPath, kStrPathPgpHelp);

	if ( int(::ShellExecute ( NULL, "open", m_strPath, 
				NULL, "", SW_SHOWNORMAL)) < 32 )
		::MessageBox (NULL, _T(kMsgHelpFailed), 
			_T(kTitleError), MB_APPLMODAL|MB_ICONEXCLAMATION);	
}


// system tray icon command: about
void CPGPICQDlg::OnAbout() 
{
	CAboutDlg dlgAbout;
	dlgAbout.DoModal();	
}


// system tray icon command: close program
void CPGPICQDlg::OnExit() 
{
	DestroyWindow();	
}


// hide options dialog
void CPGPICQDlg::OnOK()
{
	SaveOptions();
	ShowWindow(SW_HIDE);

	// might need to reset the timer for they 
	// could have changed the cache time
	ResetCacheTimer();
}


void CPGPICQDlg::OnCancel() 
{
	ShowWindow(SW_HIDE);
}


void CPGPICQDlg::ResetCacheTimer()
{
	SetTimer (kPassTimerId, m_pTheApp->m_Options.nPassphraseCacheTime*60000, NULL);
}


BOOL CPGPICQDlg::OnInitDialog()
{
	// get the frequently used application object
	m_pTheApp = (CPGPICQApp*)AfxGetApp();

	CDialog::OnInitDialog();
	LoadOptions();
	
	
	// Add the system tray icon
	m_nTrayNotificationMsg = RegisterWindowMessage(kpcTrayNotificationMsg);
	m_pTrayIcon = new CSystemTray;
	m_pTrayIcon->Create (0, m_nTrayNotificationMsg, kStrTrayIconTip,
			m_hIcon, IDR_SYSTRAY_MENU);

	// Add "About..." menu item to system menu.
	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	

	// check how many owners this ICQ has
	//m_pTheApp->GetICQOwners();


	// start a timer for searching icq windows
	SetTimer (kRefreshTimerId, kRefreshTimerTick, NULL);

	// start timer for redrawing spy buttons
	SetTimer (kRedrawTimerId, kRedrawTimerTick, NULL);

	// return true unless the focus is set to a control
	return true; 
}

void CPGPICQDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
		CDialog::OnSysCommand(nID, lParam);
}


// the system calls this to obtain the cursor to display 
// while the user drags the minimized window.
HCURSOR CPGPICQDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


void CPGPICQDlg::OnTimer(UINT nIDEvent) 
{
	if ( nIDEvent == kRefreshTimerId )
		FindICQWindows();

	if ( nIDEvent == kRedrawTimerId )
		m_pTheApp->RefreshButtons();

	if ( nIDEvent == kPassTimerId )
	{
		if ( m_pTheApp->m_Options.bForgetPassphrase )
			m_pTheApp->m_PGPMan.ForgetPassphrase();
	}

	CDialog::OnTimer(nIDEvent);
}


void CPGPICQDlg::FindICQWindows()
{
	DWORD	dwPID;
		
	// get main ICQ window's PID
	GetWindowThreadProcessId (m_pTheApp->GetMainICQWnd(), &dwPID);
 
	if ( !EnumWindows ( &EnumWindowsProc, (LPARAM)dwPID ) )
		::MessageBox (NULL, _T(kMsgWinWenumFailed), 
			_T(kTitleError), MB_APPLMODAL|MB_ICONEXCLAMATION);
}


void CPGPICQDlg::SaveOptions()
{
	HKEY		hRunKey, hKey;
	CButton    *pCheckBox;
	CEdit      *pEditBox;
	char		chInstPath[MAX_PATH];

	
	// Save encryption/decryption options 

	if ( RegOpenKeyEx (HKEY_CURRENT_USER, _T(kRegPathPgpIcq),
			0, KEY_ALL_ACCESS, &hKey) != ERROR_SUCCESS )
		if ( RegCreateKey (HKEY_CURRENT_USER, kRegPathPgpIcq, 
			&hKey) != ERROR_SUCCESS )
			return;

	// get the install path
	DWORD dwType, dwDataLen;
	dwDataLen = MAX_PATH;
	if ( RegQueryValueEx (hKey, _T(kStrInstPath), NULL, &dwType, 
		(unsigned char*)chInstPath, &dwDataLen) == ERROR_SUCCESS )

	pCheckBox = (CButton*)GetDlgItem(IDC_CHECK_AUTOENCRYPT);
	m_pTheApp->m_Options.bAutoEncrypt = pCheckBox->GetCheck();
	RegSetValueEx (hKey, (char*)_T("AutoEncrypt"), 0, REG_DWORD, 
		(unsigned char *)&m_pTheApp->m_Options.bAutoEncrypt, sizeof(BOOL));

	pCheckBox = (CButton*)GetDlgItem(IDC_CHECK_CANTENCRYPT);
	m_pTheApp->m_Options.bCannotEncryptWarning = pCheckBox->GetCheck();
	RegSetValueEx (hKey, (char*)_T("CantEncryptWarning"), 0, REG_DWORD, 
		(unsigned char *)&m_pTheApp->m_Options.bCannotEncryptWarning, sizeof(BOOL));

	pCheckBox = (CButton*)GetDlgItem(IDC_CHECK_AUTODECRYPT);
	m_pTheApp->m_Options.bAutoDecrypt = pCheckBox->GetCheck();
	RegSetValueEx (hKey, (char*)_T("AutoDecrypt"), 0, REG_DWORD, 
		(unsigned char *)&m_pTheApp->m_Options.bAutoDecrypt, sizeof(BOOL));

	pCheckBox = (CButton*)GetDlgItem(IDC_CHECK_CANTDECRYPT);
	m_pTheApp->m_Options.bCannotDecryptWarning = pCheckBox->GetCheck();
	RegSetValueEx (hKey, (char*)_T("CantDecryptWarning"), 0, REG_DWORD, 
		(unsigned char *)&m_pTheApp->m_Options.bCannotDecryptWarning, sizeof(BOOL));

	pCheckBox = (CButton*)GetDlgItem(IDC_CHECK_SPLASH);
	m_pTheApp->m_Options.bShowSplash = pCheckBox->GetCheck();
	RegSetValueEx (hKey, (char*)_T("ShowSplashScreen"), 0, REG_DWORD, 
		(unsigned char *)&m_pTheApp->m_Options.bShowSplash, sizeof(BOOL));

	pCheckBox = (CButton*)GetDlgItem(IDC_CHECK_FORGETPASS);
	m_pTheApp->m_Options.bForgetPassphrase = pCheckBox->GetCheck();
	RegSetValueEx (hKey, (char*)_T("ForgetPassphrase"), 0, REG_DWORD, 
		(unsigned char *)&m_pTheApp->m_Options.bForgetPassphrase, sizeof(BOOL));


	pEditBox = (CEdit*)GetDlgItem(IDC_EDIT_CACHETIME);
	char chStr[MAX_PATH]; pEditBox->GetWindowText(chStr, MAX_PATH);
	sscanf (chStr, "%d", &m_pTheApp->m_Options.nPassphraseCacheTime);
	RegSetValueEx (hKey, (char*)_T("PassphraseCacheTime"), 0, REG_DWORD, 
		(unsigned char *)&m_pTheApp->m_Options.nPassphraseCacheTime, sizeof(int));
	
	RegCloseKey(hKey);


	// Save the Start with ICQ option

	if ( RegOpenKeyEx (HKEY_CURRENT_USER, _T(kRegPathRun),
			0, KEY_ALL_ACCESS, &hRunKey) == ERROR_SUCCESS )
	{
		pCheckBox = (CButton*)GetDlgItem(IDC_CHECK_STARTWITHICQ);

		if ( pCheckBox->GetCheck() ) {

			char chStartPath[MAX_PATH];
			sprintf (chStartPath, "%s\\%s.exe", chInstPath, m_pTheApp->m_pszExeName);

			RegSetValueEx (hRunKey, (char*)_T(kTitleNeutral), 0, 
				REG_SZ, (unsigned char *)chStartPath, strlen(chStartPath));
		}
		else
			RegDeleteValue (hRunKey, _T(kTitleNeutral));

		RegCloseKey(hRunKey);
	}
}



void CPGPICQDlg::LoadOptions()
{

	// Load the "Start with ICQ" option
	HKEY		hKey;
	CButton    *pCheckBox;
	CEdit      *pEditBox;
	DWORD		dwType, dwDataLen;
	char		chPath[MAX_PATH];

	if ( RegOpenKeyEx (HKEY_CURRENT_USER, _T(kRegPathRun),
			0, KEY_ALL_ACCESS, &hKey) == ERROR_SUCCESS )
	{
		dwDataLen = MAX_PATH;
		pCheckBox = (CButton*)GetDlgItem(IDC_CHECK_STARTWITHICQ);

		if ( RegQueryValueEx (hKey, _T(kTitleNeutral), NULL, &dwType, 
			(unsigned char*)chPath, &dwDataLen) == ERROR_SUCCESS )
			pCheckBox->SetCheck(1);

		RegCloseKey(hKey);

	}


	// Load encryption/decryption options

	if ( RegOpenKeyEx (HKEY_CURRENT_USER, _T(kRegPathPgpIcq),
			0, KEY_ALL_ACCESS, &hKey) == ERROR_SUCCESS )
	{

		dwDataLen = sizeof(BOOL);
		RegQueryValueEx (hKey, _T("AutoEncrypt"), NULL, &dwType,
			(unsigned char*)&m_pTheApp->m_Options.bAutoEncrypt, &dwDataLen);
		
		dwDataLen = sizeof(BOOL);
		RegQueryValueEx (hKey, _T("CantEncryptWarning"), NULL, &dwType,
			(unsigned char*)&m_pTheApp->m_Options.bCannotEncryptWarning, &dwDataLen);
		
		dwDataLen = sizeof(BOOL);
		RegQueryValueEx (hKey, _T("AutoDecrypt"), NULL, &dwType,
			(unsigned char*)&m_pTheApp->m_Options.bAutoDecrypt, &dwDataLen);
		 
		dwDataLen = sizeof(BOOL);
		RegQueryValueEx (hKey, _T("CantDecryptWarning"), NULL, &dwType,
			(unsigned char*)&m_pTheApp->m_Options.bCannotDecryptWarning, &dwDataLen);

		dwDataLen = sizeof(BOOL);
		RegQueryValueEx (hKey, _T("FirstTime"), NULL, &dwType,
			(unsigned char*)&m_pTheApp->m_Options.bIsFirstTime, &dwDataLen);

		dwDataLen = sizeof(BOOL);
		if ( RegQueryValueEx (hKey, _T("ShowSplashScreen"), NULL, &dwType,
			(unsigned char*)&m_pTheApp->m_Options.bShowSplash, &dwDataLen)
			!= ERROR_SUCCESS )
			m_pTheApp->m_Options.bShowSplash = true;

		dwDataLen = sizeof(BOOL);
		RegQueryValueEx (hKey, _T("ForgetPassphrase"), NULL, &dwType,
			(unsigned char*)&m_pTheApp->m_Options.bForgetPassphrase, &dwDataLen);

		dwDataLen = sizeof(int);
		RegQueryValueEx (hKey, _T("PassphraseCacheTime"), NULL, &dwType,
			(unsigned char*)&m_pTheApp->m_Options.nPassphraseCacheTime, &dwDataLen);
				

		if ( m_pTheApp->m_Options.bIsFirstTime )
		{
			::MessageBox (NULL, _T(kMsgWarning), _T(kTitleWarning),
			MB_APPLMODAL|MB_ICONEXCLAMATION);

			m_pTheApp->m_Options.bIsFirstTime = false;
			RegSetValueEx (hKey, (char*)_T("FirstTime"), 0, REG_DWORD, 
				(unsigned char *)&m_pTheApp->m_Options.bIsFirstTime, sizeof(BOOL));
		}


		dwDataLen = MAX_PATH;
		
		if ( RegQueryValueEx (hKey, _T("InstallPath"), NULL, &dwType, 
			(unsigned char*)chPath, &dwDataLen) != ERROR_SUCCESS )
		{
			GetCurrentDirectory(MAX_PATH, chPath);
			RegSetValueEx (hKey, (char*)_T("InstallPath"), 0, 
				REG_SZ, (unsigned char *)chPath, strlen(chPath));
		}
		 
		RegCloseKey(hKey);
	}


	pCheckBox = (CButton*)GetDlgItem(IDC_CHECK_AUTOENCRYPT);
	pCheckBox->SetCheck (m_pTheApp->m_Options.bAutoEncrypt);

	pCheckBox = (CButton*)GetDlgItem(IDC_CHECK_CANTENCRYPT);
	pCheckBox->SetCheck (m_pTheApp->m_Options.bCannotEncryptWarning);

	pCheckBox = (CButton*)GetDlgItem(IDC_CHECK_AUTODECRYPT);
	pCheckBox->SetCheck (m_pTheApp->m_Options.bAutoDecrypt);

	pCheckBox = (CButton*)GetDlgItem(IDC_CHECK_CANTDECRYPT);
	pCheckBox->SetCheck (m_pTheApp->m_Options.bCannotDecryptWarning);

	pCheckBox = (CButton*)GetDlgItem(IDC_CHECK_SPLASH);
	pCheckBox->SetCheck (m_pTheApp->m_Options.bShowSplash);

	pCheckBox = (CButton*)GetDlgItem(IDC_CHECK_FORGETPASS);
	pCheckBox->SetCheck (m_pTheApp->m_Options.bForgetPassphrase);

	pEditBox = (CEdit*)GetDlgItem(IDC_EDIT_CACHETIME);
	CString str; str.Format ("%d", m_pTheApp->m_Options.nPassphraseCacheTime);
	pEditBox->SetWindowText(str);
}



static BOOL CALLBACK EnumWindowsProc ( HWND hCurrentWnd, LPARAM lParam )
{
	DWORD		dwPID;
	CString		strTitle, strClass;
	char		chText[MAX_PATH];
			
	// only ICQ's child windows pass through
	GetWindowThreadProcessId (hCurrentWnd, &dwPID);
	if ( dwPID != (DWORD)lParam )
		return true;

	// skip spooky windows
	if ( !IsWindowVisible(hCurrentWnd) )
		return true;

	// get window title
	GetWindowText (hCurrentWnd, chText, MAX_PATH);
	strTitle = chText;
	if ( strTitle.IsEmpty() )
		return true;

	// get class name
	GetClassName (hCurrentWnd, chText, MAX_PATH);
	strClass = chText;
	if ( strClass != kICQWndClass )
		return true;
	
	// skip wrong windows
	if ( strTitle.Find("URL") != -1 || 
		 strTitle.Find("Can't") != -1 ||
		 strTitle.Find("Multiple") != -1 ||
		 strTitle.Find("Voice") != -1 )
		return true;

	// skip if it already has pgp button
	CPGPICQApp *pTheApp = (CPGPICQApp*)AfxGetApp();
	if ( pTheApp->IsICQWindow(hCurrentWnd) )
		return true;


	int nType;
	if ( strTitle.Find("Incoming Message") != -1 )
		nType = kMessageTypeIn;
	else
	{
		if ( strTitle.Find("Send") != -1 &&
			strTitle.Find("Message") != -1)
			nType = kMessageTypeOut;
		else
		{
			if ( strTitle.Find("Event Details") != -1 )
				nType = kMessageTypeHist;
			else
				return true;
		}
	}

	
	pTheApp->AddICQWindow(hCurrentWnd, nType);		
	
	return true;
}




