///////////////////////////////////////////////////////////////////////////
//                                                                       //
// PGPICQ.cpp : implementation file                                      //
//                                                                       //
// Copyright (c) 2000 Samopal Corporation.                               //
// All right are all right (tm)                                          //
//                                                                       //
// For news and updates visit http://www.samopal.com/soft/pgpicq/        //
// Email your comments to pgpicq@samopal.com                             //
//                                                                       //
// Free use and distribution of this source code allowed                 //
// under the condition of keeping this header intact.                    //
//                                                                       //
///////////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "PGPICQ.h"
#include "PGPICQDlg.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#include <winreg.h>


HANDLE g_hInst;


/////////////////////////////////////////////////////////////////////////////
// CPGPICQApp

BEGIN_MESSAGE_MAP(CPGPICQApp, CWinApp)
	//{{AFX_MSG_MAP(CPGPICQApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()


CPGPICQApp::CPGPICQApp()
{
}


/////////////////////////////////////////////////////////////////////////////
// The one and only CPGPICQApp object

CPGPICQApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CPGPICQApp initialization

BOOL CPGPICQApp::InitInstance()
{
	// allow only one instance
	if ( FindWindow ("#32770", "PGP-ICQ Options") )
		return false;


	// show splash window
	m_splashWnd.Init (250, 200, IDB_SPLASH, 4000);


	// set deafult options
	m_Options.bAutoDecrypt = true;
	m_Options.bAutoEncrypt = false;
	m_Options.bCannotDecryptWarning = true;
	m_Options.bCannotEncryptWarning = true;
	m_Options.bIsFirstTime = true;
	m_Options.bShowSplash = true;
	m_Options.bForgetPassphrase = true;
	m_Options.nPassphraseCacheTime = 10;


	// init PGP manager
	if ( !m_PGPMan.Initialize() ) {
		MessageBox (NULL, _T(kMsgPgpInitFailed),
			_T(kTitleStartupError), MB_APPLMODAL|MB_ICONEXCLAMATION);
		return false;
	}

	// check how many owners this ICQ has
	GetICQOwners();

	DWORD dwPID, dwThread;
	dwThread = GetWindowThreadProcessId (GetMainICQWnd(), &dwPID);
	


	// create the hook
	/*
	g_hInst = m_hInstance;
	m_hDll = LoadLibrary("pgpicq.dll");

	
	HHOOK (__cdecl *pCreateHook) (CPGPICQApp*, int ) = 
		(HHOOK (__cdecl *) (CPGPICQApp*, int))
		GetProcAddress(m_hDll,"CreateHook");

	m_hHook = pCreateHook(this, dwThread); 
	*/
	
	/* */
	//FARPROC pMouseProc = GetProcAddress (m_hDll, "MouseProc");
	//m_hHook = SetWindowsHookEx (WH_MOUSE, (HOOKPROC)pMouseProc, m_hDll, 0);
	//FARPROC pGetMsgProc = GetProcAddress (m_hDll, "GetMsgProc");
	//m_hHook = SetWindowsHookEx (WH_GETMESSAGE, (HOOKPROC)pGetMsgProc, m_hDll, 0);
	//int err = GetLastError();
	/* */
	

	// create the options dialog
	m_pMainWnd = new CPGPICQDlg;
	return m_pMainWnd ? true:false;
}




int CPGPICQApp::ExitInstance() 
{
	//UnhookWindowsHookEx(m_hHook);

	if ( m_hDll != NULL )
	{
		BOOL (__cdecl *pReleaseHook) ( ) = 
			(BOOL (__cdecl *) ())
			GetProcAddress(m_hDll,"ReleaseHook");
		pReleaseHook();
	}


	return CWinApp::ExitInstance();
}



// Since ICQ can have multiple owners, we need to query
// the registry and find 'em all in order to figure out
// what the main ICQ window title might be

BOOL CPGPICQApp::GetICQOwners()
{
	HKEY	hMainKey;
	char	chBuffer[MAX_PATH];
	int		nIndex = 0;

	m_vecICQOwners.clear();

	// "normal" ICQ owners
	if ( (RegOpenKeyEx ( HKEY_CURRENT_USER, _T(kRegPathIcqOwners),
			0, KEY_ENUMERATE_SUB_KEYS, &hMainKey) != ERROR_SUCCESS) )
	{
		MessageBox(NULL, _T(kMsgIcqInitFailed),
			_T(kTitleStartupError), MB_APPLMODAL|MB_ICONEXCLAMATION);

		return false;
	}
	
	while ( RegEnumKey (hMainKey, nIndex++, chBuffer, MAX_PATH) == ERROR_SUCCESS ) 
	{
		CString strOwner(chBuffer);
		m_vecICQOwners.push_back(strOwner);
	}

	RegCloseKey(hMainKey);


	// Groupware ICQ owners
	nIndex = 0;
	if ( (RegOpenKeyEx ( HKEY_CURRENT_USER, _T(kRegPathGIcqOwners),
			0, KEY_ENUMERATE_SUB_KEYS, &hMainKey) == ERROR_SUCCESS) )
	{
		while ( RegEnumKey (hMainKey, nIndex++, chBuffer, MAX_PATH) == ERROR_SUCCESS ) 
		{
			CString strOwner(chBuffer);
			m_vecICQOwners.push_back(strOwner);
		}

		RegCloseKey(hMainKey);
	}

	return true;
}



// Knowing all possible ICQ owners, find the main ICQ window

HWND CPGPICQApp::GetMainICQWnd()
{
	HWND hWnd = NULL;
	vector<CString>::iterator first = m_vecICQOwners.begin();
	vector<CString>::iterator last = m_vecICQOwners.end();

	while ( first != last ) {
		hWnd = FindWindow (kICQWndClass, first->GetBuffer(first->GetLength()));
		if ( hWnd != NULL )
			break;
		first++;
	}

	return hWnd;
}


// Add a spy button to the given ICQ window

void CPGPICQApp::AddICQWindow(HWND hIcqWnd, int nType)
{
	CSpyButton *pSpyButton = new CSpyButton;

	if ( pSpyButton->Initialize(hIcqWnd, nType) )
		m_vecSpyButtons.push_back(pSpyButton);
	else
		delete pSpyButton;
}


// Check if the given window already has a spy button attached to it

BOOL CPGPICQApp::IsICQWindow(HWND hIcqWnd)
{
	vector<CSpyButton*>::iterator first = m_vecSpyButtons.begin();
	vector<CSpyButton*>::iterator last = m_vecSpyButtons.end();

	BOOL bFound = false;
	while ( first != last ) {
		if ( hIcqWnd == (*first)->m_pAttachedWnd->m_hWnd ) {
			bFound = true;
		}
		first++;
	}

	return bFound;
}


// Recaclculate the new position of every spy button
// and redraw. Delete a spy button if its corresponding
// ICQ window doesn't exist anymore.

void CPGPICQApp::RefreshButtons()
{
	vector<CSpyButton*>::iterator first = m_vecSpyButtons.begin();
	vector<CSpyButton*>::iterator last = m_vecSpyButtons.end();
	
	while ( first != last && m_vecSpyButtons.size() )
	{
		if ( ::IsWindow((*first)->m_hWnd) )
		{
			(*first)->Refresh();
			first++;
		}
		else
		{
			CSpyButton* p = *first;
			m_vecSpyButtons.erase(first);
			first = m_vecSpyButtons.begin();
			last = m_vecSpyButtons.end();
			delete p;
		}
	}
}



