///////////////////////////////////////////////////////////////////////////
//                                                                       //
// AssociateDlg.cpp : implementation file                                //
//                                                                       //
// Copyright (c) 2000 Samopal Corporation.                               //
// All right are all right (tm)                                          //
//                                                                       //
// For news and updates visit http://www.samopal.com/soft/pgpicq/        //
// Email your comments to pgpicq@samopal.com                             //
//                                                                       //
// Free use and distribution of this source code allowed                 //
// under the condition of keeping this header intact.                    //
//                                                                       //
///////////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "pgpicq.h"
#include "AssociateDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CAssociateDlg dialog


CAssociateDlg::CAssociateDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAssociateDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAssociateDlg)
	m_strLabel = _T("");
	//}}AFX_DATA_INIT
}


void CAssociateDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAssociateDlg)
	DDX_Control(pDX, IDC_KEY_COMBO, m_UserCombo);
	DDX_Control(pDX, IDC_KEY_LIST, m_UserList);
	DDX_Text(pDX, IDC_STATIC_RECIPIENT, m_strLabel);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAssociateDlg, CDialog)
	//{{AFX_MSG_MAP(CAssociateDlg)
	ON_BN_CLICKED(IDC_REMOVE, OnRemove)
	ON_LBN_SELCHANGE(IDC_KEY_LIST, OnSelectionChange)
	ON_LBN_DBLCLK(IDC_KEY_LIST, OnSelectionDblclk)
	ON_CBN_SELCHANGE(IDC_KEY_COMBO, OnSelectionChange)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CAssociateDlg message handlers

BOOL CAssociateDlg::OnInitDialog() 
{

	// see if this uin already has a public key assigned to it

	CPGPICQApp *pTheApp = (CPGPICQApp*)AfxGetApp();
	UinKeyPairStruct *pExistingPair = pTheApp->m_PGPMan.HasPair(m_strUin);

	// if so,
	if ( !pExistingPair ) {
		m_strLabel.Format("%s %s (%s):", kMsgSelectPublicKey, m_strName, m_strUin);
	}
	else {
		m_strLabel.Format("%s (%s) %s", m_strName, m_strUin, kMsgUsesPublicKey);
	}

	CDialog::OnInitDialog();


	// get a list of available public keys

	StringListT vecUserList;
	pTheApp->m_PGPMan.GetUserList(&vecUserList);
	
	vector<CString>::iterator first = vecUserList.begin();
	vector<CString>::iterator last = vecUserList.end();

	while ( first != last )
	{
		//m_UserList.AddString(*first);
		m_UserCombo.AddString(*first++);
	}


	if ( !pExistingPair )
	{
		GetDlgItem(IDC_REMOVE)->EnableWindow(false);
		GetDlgItem(IDOK)->EnableWindow(false);
	}
	else
	{
		//m_UserList.SelectString (0, pExistingPair->keyId);
		m_UserCombo.SelectString (0, pExistingPair->keyId);
	}


	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CAssociateDlg::OnOK()
{
	//int nIndex = m_UserList.GetCurSel();
	//m_UserList.GetText (nIndex, m_KeyId);

	int nIndex = m_UserCombo.GetCurSel();
	m_UserCombo.GetLBText(nIndex, m_KeyId);	

	CPGPICQApp *pTheApp = (CPGPICQApp*) AfxGetApp();
	pTheApp->m_PGPMan.AddPair (m_strUin, m_KeyId);
		
	CDialog::OnOK();
}

void CAssociateDlg::OnRemove() 
{
	if ( ::MessageBox (NULL, _T(kRemoveAssociationWarning), _T(kTitleWarning),
		MB_APPLMODAL|MB_ICONEXCLAMATION|MB_OKCANCEL) == IDOK ) {
	//if ( AfxMessageBox (_T(kRemoveAssociationWarning), MB_OKCANCEL) == IDOK ) {
		CPGPICQApp *pTheApp = (CPGPICQApp*) AfxGetApp();
		pTheApp->m_PGPMan.RemovePair(m_strUin);
		CDialog::OnOK();
	}
}

void CAssociateDlg::OnSelectionChange() 
{
	GetDlgItem(IDOK)->EnableWindow();	
}

void CAssociateDlg::OnSelectionDblclk() 
{
	OnOK();	
}
