///////////////////////////////////////////////////////////////////////////
//                                                                       //
// pgpKeysDoc.cpp : implementation file                                  //
//                                                                       //
// Copyright (c) 2000 Samopal Corporation.                               //
// All right are all right (tm)                                          //
//                                                                       //
// For news and updates visit http://www.samopal.com/soft/pgpicq/        //
// Email your comments to pgpicq@samopal.com                             //
//                                                                       //
// Free use and distribution of this source code allowed                 //
// under the condition of keeping this header intact.                    //
//                                                                       //
///////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "pgpKeys.h"

#include "pgpKeysDoc.h"
#include "OptionsDlg.h"
#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPgpKeysDoc

IMPLEMENT_DYNCREATE(CPgpKeysDoc, CDocument)

BEGIN_MESSAGE_MAP(CPgpKeysDoc, CDocument)
	//{{AFX_MSG_MAP(CPgpKeysDoc)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(CPgpKeysDoc, CDocument)
	//{{AFX_DISPATCH_MAP(CPgpKeysDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//      DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_DISPATCH_MAP
END_DISPATCH_MAP()

// Note: we add support for IID_IPgpKeys to support typesafe binding
//  from VBA.  This IID must match the GUID that is attached to the 
//  dispinterface in the .ODL file.

// {A2B43089-E8BC-49E4-A683-3F30AA0A61EC}
static const IID IID_IPgpKeys =
{ 0xa2b43089, 0xe8bc, 0x49e4, { 0xa6, 0x83, 0x3f, 0x30, 0xaa, 0xa, 0x61, 0xec } };

BEGIN_INTERFACE_MAP(CPgpKeysDoc, CDocument)
	INTERFACE_PART(CPgpKeysDoc, IID_IPgpKeys, Dispatch)
END_INTERFACE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPgpKeysDoc construction/destruction

CPgpKeysDoc::CPgpKeysDoc()
{
	m_nSortCol = 0;
	m_bDesc = false;

	EnableAutomation();
	AfxOleLockApp();

	if ( !Init() )
		exit(0);
}

CPgpKeysDoc::~CPgpKeysDoc()
{
	AfxOleUnlockApp();
}


BOOL CPgpKeysDoc::Init()
{
	LoadOptions();

	if ( !m_PGPMan.Initialize(m_strPublicKeyring, m_strSecretKeyring) )
	{
		CString strMsg = _T(kStrKeyTypePromptLocateFile);
		if ( MessageBox ( NULL, strMsg, _T(kStrTitleError), 
			MB_OKCANCEL|MB_APPLMODAL|MB_ICONEXCLAMATION) == IDCANCEL )
			return false;

		EditOptions();
	}

	return true;
}


BOOL CPgpKeysDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return false;

	m_KeyList.clear();
	m_PGPMan.GetAllKeys (&m_KeyList, m_nSortCol, m_bDesc);

	SetTitle(kTitleNeutral);
	
	return true;
}



/////////////////////////////////////////////////////////////////////////////
// CPgpKeysDoc serialization

void CPgpKeysDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}

/////////////////////////////////////////////////////////////////////////////
// CPgpKeysDoc diagnostics

#ifdef _DEBUG
void CPgpKeysDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CPgpKeysDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CPgpKeysDoc commands

void CPgpKeysDoc::DeleteFromList(KeyPointerListT *pDelList)
{
	KeyPointerListT::iterator first = pDelList->begin();
	KeyPointerListT::iterator last = pDelList->end();

	while ( first != last )
	{
		((CKeyObject *)*first)->Delete();
		first++;
	}
}


void CPgpKeysDoc::LoadOptions()
{
	HKEY			hKey;
	DWORD			dwType, dwDataLen;
	unsigned char  *chStr;
	long			nErr;


	//m_strServerURL = "http://pgpkeys.mit.edu:11371";
	m_strServerURL = "ldap://certserver.pgp.com";
	m_strPublicKeyring = "";
	m_strSecretKeyring = "";	

	if ( RegOpenKeyEx (HKEY_CURRENT_USER, _T(kRegPathPgpKeys),
			0, KEY_ALL_ACCESS, &hKey) == ERROR_SUCCESS )
	{
		dwDataLen = 512;
		chStr = (unsigned char *) malloc(dwDataLen);

		nErr = RegQueryValueEx (hKey, "KeyServer", NULL, &dwType, chStr, &dwDataLen);
		if ( nErr == ERROR_SUCCESS )
			m_strServerURL = CString((LPCTSTR)chStr, dwDataLen);

		dwDataLen = 512;
		nErr = RegQueryValueEx (hKey, "PublicPath", NULL, &dwType, chStr, &dwDataLen);
		if ( nErr == ERROR_SUCCESS )
			m_strPublicKeyring = CString((LPCTSTR )chStr, dwDataLen);

		dwDataLen = 512;
		nErr = RegQueryValueEx (hKey, "PrivatePath", NULL, &dwType, chStr, &dwDataLen);
		if ( nErr == ERROR_SUCCESS )
			m_strSecretKeyring = CString((LPCTSTR )chStr, dwDataLen);

		RegCloseKey(hKey);
		free(chStr);
	}

	while ( !m_strPublicKeyring.GetLength() || !m_strSecretKeyring.GetLength() )
	{
		//CString strMsg = _T("You need to provide information about\nPublic and Private Keyring files.\n\nIn the dialog window that will appear next\nplease locate existing files or specify new ones.");
		//if ( MessageBox ( NULL, strMsg, _T("Keyring Files"), 
		//	MB_OKCANCEL|MB_APPLMODAL|MB_ICONEXCLAMATION) == IDCANCEL )
		//	exit(0);

		if ( !EditOptions() )
			exit(0);
	}

}


void CPgpKeysDoc::SaveOptions()
{
	HKEY	hKey;
	char	chStr[MAX_PATH];
	
	if ( RegOpenKeyEx (HKEY_CURRENT_USER, _T(kRegPathPgpKeys),
			0, KEY_ALL_ACCESS, &hKey) != ERROR_SUCCESS )
		if ( RegCreateKey (HKEY_CURRENT_USER, kRegPathPgpKeys, &hKey) != ERROR_SUCCESS )
			return;
	
	strcpy(chStr, m_strServerURL);
	RegSetValueEx (hKey, "KeyServer", 0, 
		REG_SZ, (unsigned char *)chStr, strlen(chStr));

	strcpy(chStr, m_strPublicKeyring);
	RegSetValueEx (hKey, "PublicPath", 0, 
		REG_EXPAND_SZ, (unsigned char *)chStr, strlen(chStr));

	strcpy(chStr, m_strSecretKeyring);
	RegSetValueEx (hKey, "PrivatePath", 0, 
		REG_EXPAND_SZ, (unsigned char *)chStr, strlen(chStr));

	RegCloseKey(hKey);
}



BOOL CPgpKeysDoc::EditOptions()
{
	COptionsDlg	optDlg;

	optDlg.m_strKeysrv = m_strServerURL;
	optDlg.m_strPrivkeyFile = m_strSecretKeyring;
	optDlg.m_strPubkeyFile = m_strPublicKeyring;

	if ( optDlg.DoModal() == IDOK )
	{
		m_strServerURL = optDlg.m_strKeysrv;
		m_strSecretKeyring = optDlg.m_strPrivkeyFile;
		m_strPublicKeyring = optDlg.m_strPubkeyFile;

		SaveOptions();
		return true;
	}
	
	return false;
}

