///////////////////////////////////////////////////////////////////////////
//                                                                       //
// OptionsDlg.cpp : implementation file                                  //
//                                                                       //
// Copyright (c) 2000 Samopal Corporation.                               //
// All right are all right (tm)                                          //
//                                                                       //
// For news and updates visit http://www.samopal.com/soft/pgpicq/        //
// Email your comments to pgpicq@samopal.com                             //
//                                                                       //
// Free use and distribution of this source code allowed                 //
// under the condition of keeping this header intact.                    //
//                                                                       //
///////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "pgpKeys.h"
#include "OptionsDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COptionsDlg dialog


COptionsDlg::COptionsDlg(CWnd* pParent /*=NULL*/)
	: CDialog(COptionsDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(COptionsDlg)
	m_strKeysrv = _T("");
	m_strPrivkeyFile = _T("");
	m_strPubkeyFile = _T("");
	//}}AFX_DATA_INIT
}


void COptionsDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COptionsDlg)
	DDX_Text(pDX, IDC_EDIT_KEYSRV, m_strKeysrv);
	DDX_Text(pDX, IDC_EDIT_PRIVKEYFILE, m_strPrivkeyFile);
	DDX_Text(pDX, IDC_EDIT_PUBKEYFILE, m_strPubkeyFile);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COptionsDlg, CDialog)
	//{{AFX_MSG_MAP(COptionsDlg)
	ON_BN_CLICKED(IDC_BTN_BROWSE_PUB, OnBrowsePublicFile)
	ON_BN_CLICKED(IDC_BTN_BROWSE_PRIV, OnBrowsePrivateFile)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COptionsDlg message handlers

void COptionsDlg::OnBrowsePublicFile() 
{
	OFSTRUCT fileInfo;
	static char BASED_CODE szFilter[] = kStrFileFilterPublic;

	CFileDialog pubFile (true, kStrFileExtPublic, m_strPubkeyFile, OFN_HIDEREADONLY, szFilter, this);

	if ( !m_strPubkeyFile.GetLength() )
		strcpy (pubFile.m_ofn.lpstrFile, kStrFileNamePublic);

	pubFile.m_ofn.lpstrTitle = (char*)malloc(64);
	strcpy((char*)pubFile.m_ofn.lpstrTitle, kStrFileTitlePublic);

	if ( pubFile.DoModal() == IDOK )
	{
		if ( OpenFile(pubFile.GetPathName(), &fileInfo, OF_EXIST) == HFILE_ERROR )
		{
			CString strMsg;
			strMsg.Format(kStrKeyTypePromptCreateFile, pubFile.GetPathName());

			if ( MessageBox ( strMsg, _T(kStrTitleConfirmation), 
				 MB_YESNO|MB_APPLMODAL|MB_ICONEXCLAMATION) == IDNO )
				 return;
			else
			{
				m_strPubkeyFile = pubFile.GetPathName();
				GetDlgItem(IDC_EDIT_PUBKEYFILE)->SetWindowText(m_strPubkeyFile);
			}
		}
		else
		{
			m_strPubkeyFile = pubFile.GetPathName();
			GetDlgItem(IDC_EDIT_PUBKEYFILE)->SetWindowText(m_strPubkeyFile);
		}
	}
}

void COptionsDlg::OnBrowsePrivateFile() 
{
	OFSTRUCT fileInfo;
	static char BASED_CODE szFilter[] = kStrFileFilterPrivate;

	CFileDialog secFile (true, kStrFileExtPrivate, m_strPrivkeyFile, OFN_HIDEREADONLY, szFilter, this);

	if ( !m_strPrivkeyFile.GetLength() )
		strcpy (secFile.m_ofn.lpstrFile, kStrFileNamePrivate);

	secFile.m_ofn.lpstrTitle = (char*)malloc(64);
	strcpy((char*)secFile.m_ofn.lpstrTitle, kStrFileTitlePrivate);

	if ( secFile.DoModal() == IDOK )
	{
		if ( OpenFile(secFile.GetPathName(), &fileInfo, OF_EXIST) == HFILE_ERROR )
		{
			CString strMsg;
			strMsg.Format(kStrKeyTypePromptCreateFile, secFile.GetPathName());

			if ( MessageBox ( strMsg, _T(kStrTitleConfirmation), 
				 MB_YESNO|MB_APPLMODAL|MB_ICONEXCLAMATION) == IDNO )
				 return;
			else
			{
				m_strPrivkeyFile = secFile.GetPathName();
				GetDlgItem(IDC_EDIT_PRIVKEYFILE)->SetWindowText(m_strPrivkeyFile);
			}
		}
		else
		{
			m_strPrivkeyFile = secFile.GetPathName();
			GetDlgItem(IDC_EDIT_PRIVKEYFILE)->SetWindowText(m_strPrivkeyFile);
		}
	}
}
