// ListCtrlEx.cpp : implementation file
//

#include "stdafx.h"
#include "hider.h"
#include "ListCtrlEx.h"
#include "HiderDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CListCtrlEx

CListCtrlEx::CListCtrlEx()
{
	m_nContextMenuID = 0;
	m_nSortedCol = 0;
	m_bSortAscending = TRUE;
}

CListCtrlEx::~CListCtrlEx()
{
}


BEGIN_MESSAGE_MAP(CListCtrlEx, CListCtrl)
	//{{AFX_MSG_MAP(CListCtrlEx)
	ON_WM_CONTEXTMENU()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CListCtrlEx message handlers



int CListCtrlEx::GetSelection()
{
	int		nSelection = -1;

	for (int i=0; i<GetItemCount(); i++)
	{
		if ( GetItemState (i, LVIS_SELECTED) )
			return i;
	}

	return nSelection;
}

void CListCtrlEx::SetSelection(int nIndex, BOOL bEnsureVisible)
{
	/*
	int nItem = GetNextItem(-1, LVNI_ALL);
	while ( nItem != -1 )
	{
		if ( nItem == nIndex )
		{
			if ( !SetItemState (nIndex, LVIS_DROPHILITED|LVIS_SELECTED, LVIS_SELECTED ) )
				SetItemState (0, LVIS_DROPHILITED|LVIS_SELECTED, LVIS_SELECTED );

			if ( bEnsureVisible )
				EnsureVisible (nIndex, FALSE );

			break;
		}


		nItem = GetNextItem (nItem, LVNI_ALL);
	}
	*/

	
	if ( !SetItemState (nIndex, LVIS_DROPHILITED|LVIS_SELECTED, LVIS_SELECTED ) )
		SetItemState (0, LVIS_DROPHILITED|LVIS_SELECTED, LVIS_SELECTED );
	else
		if ( bEnsureVisible )
			EnsureVisible (nIndex, FALSE );


	//else EnsureVisible (nIndex, FALSE );
}



BOOL CListCtrlEx::OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult) 
{
	HD_NOTIFY	*pHDN = (HD_NOTIFY*)lParam;

	LPNMHDR pNH = (LPNMHDR) lParam;

	// wParam is zero for Header ctrl

	if( wParam == 0 && ( pNH->code == 4294966974 || pNH->code == 4294966994 ) ) // 4294966994 4294967280
	{
		POINT Point;
		GetCursorPos (&Point);
		ScreenToClient(&Point);
		HDHITTESTINFO HitTest;

		HitTest.pt.x = Point.x;
		HitTest.pt.y = Point.y;

		// Send the Hit Test Message
		GetHeaderCtrl()->SendMessage(HDM_HITTEST,0,(LPARAM)&HitTest);
 
		if( HitTest.iItem == m_nSortedCol )
			m_bSortAscending = !m_bSortAscending;
		else
			m_bSortAscending = TRUE;

		m_nSortedCol = HitTest.iItem;

		SortList();
	}

	
	return CListCtrl::OnNotify(wParam, lParam, pResult);
}


BOOL CListCtrlEx::SortList()
{
	switch (m_nSortedCol)
	{
		case 0:
			SortTextItems (m_nSortedCol, m_bSortAscending);
			break;
		default:
			SortNumericItems (m_nSortedCol, m_bSortAscending);
	}

	return TRUE;
}



void CListCtrlEx::EnsureVisible(int nItem, BOOL bPartialOK)
{
	/*
	RECT Rect;

	// get single item's height
	GetItemRect (nItem, &Rect, LVIR_BOUNDS) ;
	int nItemHeight = Rect.bottom - Rect.top;

	// get whole list height
	GetWindowRect(&Rect);
	int nListHeight = Rect.bottom - Rect.top;

	int nItemRelativePos = 
		*/

	CListCtrl::EnsureVisible(nItem, bPartialOK);
}



// case sensative
// SortTextItems	- Sort the list based on column text
// Returns			- Returns true for success
// nCol				- column that contains the text to be sorted
// bAscending		- indicate sort order
// low				- row to start scanning from - default row is 0
// high				- row to end scan. -1 indicates last row
BOOL CListCtrlEx::SortTextItemsCase(int nCol, BOOL bAscending, int low, int high)
{
	if( nCol >= ((CHeaderCtrl*)GetDlgItem(0))->GetItemCount() )
		return FALSE;

	if( high == -1 ) high = GetItemCount() - 1;

	int lo = low;
	int hi = high;
	CString midItem;

	if( hi <= lo ) return FALSE;

	midItem = GetItemText( (lo+hi)/2, nCol );

	// loop through the list until indices cross
	while( lo <= hi )
	{
		// rowText will hold all column text for one row
		CStringArray rowText;

		// find the first element that is greater than or equal to 
		// the partition element starting from the left Index.
		if( bAscending )
			while( ( lo < high ) && ( GetItemText(lo, nCol) < midItem ) )
				++lo;
		else
			while( ( lo < high ) && ( GetItemText(lo, nCol) > midItem ) )
				++lo;

		// find an element that is smaller than or equal to 
		// the partition element starting from the right Index.
		if( bAscending )
			while( ( hi > low ) && ( GetItemText(hi, nCol) > midItem ) )
				--hi;
		else
			while( ( hi > low ) && ( GetItemText(hi, nCol) < midItem ) )
				--hi;

		// if the indexes have not crossed, swap
		// and if the items are not equal
		if( lo <= hi )
		{
			// swap only if the items are not equal
			if( GetItemText(lo, nCol) != GetItemText(hi, nCol))
			{
				// swap the rows
				LV_ITEM lvitemlo, lvitemhi;
				int nColCount = 
					((CHeaderCtrl*)GetDlgItem(0))->GetItemCount();
				rowText.SetSize( nColCount );
				int i;
				for( i=0; i<nColCount; i++)
					rowText[i] = GetItemText(lo, i);
				lvitemlo.mask = LVIF_IMAGE | LVIF_PARAM | LVIF_STATE;
				lvitemlo.iItem = lo;
				lvitemlo.iSubItem = 0;
				lvitemlo.stateMask = LVIS_CUT | LVIS_DROPHILITED | 
						LVIS_FOCUSED |  LVIS_SELECTED | 
						LVIS_OVERLAYMASK | LVIS_STATEIMAGEMASK;

				lvitemhi = lvitemlo;
				lvitemhi.iItem = hi;

				GetItem( &lvitemlo );
				GetItem( &lvitemhi );

				for( i=0; i<nColCount; i++)
					SetItemText(lo, i, GetItemText(hi, i));

				lvitemhi.iItem = lo;
				SetItem( &lvitemhi );

				for( i=0; i<nColCount; i++)
					SetItemText(hi, i, rowText[i]);

				lvitemlo.iItem = hi;
				SetItem( &lvitemlo );
			}

			++lo;
			--hi;
		}
	}

	// If the right index has not reached the left side of array
	// must now sort the left partition.
	if( low < hi )
		SortTextItems( nCol, bAscending , low, hi);

	// If the left index has not reached the right side of array
	// must now sort the right partition.
	if( lo < high )
		SortTextItems( nCol, bAscending , lo, high );

	return TRUE;
}





BOOL CListCtrlEx::SortNumericItems(int nCol, BOOL bAscending, int low, int high)
{
	if( nCol >= ((CHeaderCtrl*)GetDlgItem(0))->GetItemCount() )
		return FALSE;
	
	if( high == -1 ) high = GetItemCount() - 1;
	int lo = low;   
	int hi = high;
	
	int midItem;
	
	if( hi <= lo ) return FALSE;
	
	midItem = atoi(GetItemText( (lo+hi)/2, nCol ));
	
	// loop through the list until indices cross
	while( lo <= hi )
	{
		// rowText will hold all column text for one row
		CStringArray rowText;
		
		// find the first element that is greater than or equal to 
		// the partition element starting from the left Index.
		if( bAscending )
			while( ( lo < high ) && (atoi(GetItemText(lo, nCol)) < midItem ) )
				++lo;           
		else
			while( ( lo < high ) && (atoi(GetItemText(lo, nCol)) > midItem ) )
				++lo;
                
		// find an element that is smaller than or equal to 
		// the partition element starting from the right Index.
		if( bAscending )
			while( ( hi > low ) && (atoi(GetItemText(hi, nCol)) > midItem ) )
				--hi;           
		else
			while( ( hi > low ) && (atoi(GetItemText(hi, nCol)) < midItem ) )
				--hi;
				
		// if the indexes have not crossed, swap                
		// and if the items are not equal
		if( lo <= hi )
		{
			// swap only if the items are not equal
			if(atoi(GetItemText(lo, nCol)) != atoi(GetItemText(hi, nCol)) )
			{                               
				// swap the rows
				LV_ITEM lvitemlo, lvitemhi;
                
				int nColCount =
							((CHeaderCtrl*)GetDlgItem(0))->GetItemCount();
				rowText.SetSize( nColCount );
                
				int i;
				for( i=0; i < nColCount; i++)
							rowText[i] = GetItemText(lo, i);
                
				lvitemlo.mask = LVIF_IMAGE | LVIF_PARAM | LVIF_STATE;
				lvitemlo.iItem = lo;
				lvitemlo.iSubItem = 0;
				lvitemlo.stateMask = LVIS_CUT | LVIS_DROPHILITED |
							LVIS_FOCUSED |  LVIS_SELECTED |
							LVIS_OVERLAYMASK | LVIS_STATEIMAGEMASK;
				lvitemhi = lvitemlo;
				lvitemhi.iItem = hi;
                
				GetItem( &lvitemlo );
				GetItem( &lvitemhi );
                
				for( i=0; i< nColCount; i++)
							SetItemText(lo, i, GetItemText(hi, i) );
                
				lvitemhi.iItem = lo;
				SetItem( &lvitemhi );
                
				for( i=0; i< nColCount; i++)
							SetItemText(hi, i, rowText[i]);
                
				lvitemlo.iItem = hi;
				SetItem( &lvitemlo );
			}
			
			++lo;
			--hi;
		}
	}
	
	// If the right index has not reached the left side of array
	// must now sort the left partition.
	if( low < hi )
		SortNumericItems( nCol, bAscending , low, hi);
	
	// If the left index has not reached the right side of array
	// must now sort the right partition.
	if( lo < high )
		SortNumericItems( nCol, bAscending , lo, high );
	
	return TRUE;

}





BOOL CListCtrlEx::SortTextItems(int nCol, BOOL bAscending, int low, int high)
{

	if( nCol >= ((CHeaderCtrl*)GetDlgItem(0))->GetItemCount() )
		return false;

	if( high == -1 ) high = GetItemCount() - 1;

	int lo = low;
	int hi = high;
	CString midItem;

	if( hi <= lo ) return false;

	midItem = GetItemText( (lo+hi)/2, nCol );

	// loop through the list until indices cross
	while( lo <= hi )
	{
		// rowText will hold all column text for one row
		CStringArray rowText;

		// find the first element that is greater than or equal to 
		// the partition element starting from the left Index.
		if( bAscending )
			//                        GetItemText(lo, nCol) < midItem
			while( ( lo < high ) && ( GetItemText(lo, nCol).CompareNoCase( midItem ) < 0 ) )
				++lo;
		else
			//                        GetItemText(lo, nCol) > midItem
			while( ( lo < high ) && ( GetItemText(lo, nCol).CompareNoCase( midItem ) > 0 ) )
				++lo;

		// find an element that is smaller than or equal to 
		// the partition element starting from the right Index.
		if( bAscending )
			//                       GetItemText(hi, nCol) > midItem
			while( ( hi > low ) && ( GetItemText(hi, nCol).CompareNoCase( midItem ) > 0 ) )
				--hi;
		else
			//                       GetItemText(hi, nCol) < midItem 
			while( ( hi > low ) && ( GetItemText(hi, nCol).CompareNoCase( midItem ) < 0 ) )
				--hi;

		// if the indexes have not crossed, swap
		// and if the items are not equal
		if( lo <= hi )
		{
			// swap only if the items are not equal
			if( GetItemText(lo, nCol).CompareNoCase( GetItemText(hi, nCol) ) != 0 )
			{
				// swap the rows
				LV_ITEM lvitemlo, lvitemhi;
				int nColCount = 
					((CHeaderCtrl*)GetDlgItem(0))->GetItemCount();
				rowText.SetSize( nColCount );
				int i;
				for( i=0; i<nColCount; i++)
					rowText[i] = GetItemText(lo, i);
				lvitemlo.mask = LVIF_IMAGE | LVIF_PARAM | LVIF_STATE;
				lvitemlo.iItem = lo;
				lvitemlo.iSubItem = 0;
				lvitemlo.stateMask = LVIS_CUT | LVIS_DROPHILITED | 
						LVIS_FOCUSED |  LVIS_SELECTED | 
						LVIS_OVERLAYMASK | LVIS_STATEIMAGEMASK;

				lvitemhi = lvitemlo;
				lvitemhi.iItem = hi;

				GetItem( &lvitemlo );
				GetItem( &lvitemhi );

				for( i=0; i<nColCount; i++)
					SetItemText(lo, i, GetItemText(hi, i));

				lvitemhi.iItem = lo;
				SetItem( &lvitemhi );

				for( i=0; i<nColCount; i++)
					SetItemText(hi, i, rowText[i]);

				lvitemlo.iItem = hi;
				SetItem( &lvitemlo );
			}

			++lo;
			--hi;
		}
	}

	// If the right index has not reached the left side of array
	// must now sort the left partition.
	if( low < hi )
		SortTextItems( nCol, bAscending , low, hi);

	// If the left index has not reached the right side of array
	// must now sort the right partition.
	if( lo < high )
		SortTextItems( nCol, bAscending , lo, high );

	return true;
}


void CListCtrlEx::OnContextMenu(CWnd* pWnd, CPoint point) 
{
	CMenu menu;
	VERIFY(menu.LoadMenu(m_nContextMenuID));
	CMenu* pPopup = menu.GetSubMenu(0);
	ASSERT(pPopup != NULL);

	/*
	if ( GetID() == IDC_PNTOOL_NORMAL_SELECT )
		menu.DeleteMenu (ID_TOOLMENU_PROPERTIES, MF_BYCOMMAND);

	if ( GetID() == IDC_PNTOOL_VIEW && GetMethod() == 1 )
		menu.DeleteMenu (ID_TOOLMENU_PROPERTIES, MF_BYCOMMAND);
	*/
	 
	pPopup->TrackPopupMenu (
		TPM_LEFTALIGN | TPM_RIGHTBUTTON, 
		point.x, point.y,
		GetParent() );
}



BOOL CListCtrlEx::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo) 
{
	/*
	switch ( nID )
	{
		case IDC_TASK_INFO:
		case IDC_TASK_HIDE:
		case IDC_TASK_SHOW:
	*/

	//::SendMessage(GetParent()->m_hWnd, WM_COMMAND, nID, 0);

	/*
			break;
		default:
			;
	}
	*/

	return CListCtrl::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}

void CListCtrlEx::SetContextMenu(int nContextMenuID)
{
	m_nContextMenuID = nContextMenuID;
}
