///////////////////////////////////////////////////////////////////////////
//                                                                       //
// SpyButton.h                                                           //
//                                                                       //
// Copyright (c) 2000 Samopal Corporation.                               //
// All right are all right (tm)                                          //
//                                                                       //
// For news and updates visit http://www.samopal.com/soft/pgpicq/        //
// Email your comments to pgpicq@samopal.com                             //
//                                                                       //
// Free use and distribution of this source code allowed                 //
// under the condition of keeping this header intact.                    //
//                                                                       //
///////////////////////////////////////////////////////////////////////////


#if !defined(AFX_SPYBUTTON_H__D0904DF0_F667_4F4D_BE41_CC6A96CA9063__INCLUDED_)
#define AFX_SPYBUTTON_H__D0904DF0_F667_4F4D_BE41_CC6A96CA9063__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif
	
class CPGPICQApp;	

/////////////////////////////////////////////////////////////////////////////
//
// CSpyButton class
//
// This is the so-called spy button that is created in every ICQ message
// window. It brings up the PGP-ICQ menu and handles all of its commands.
//
////////////////////////////////////////////////////////////////////////////


class CSpyButton : public CButton
{
public:
	BOOL IsTalkButton();
	void Refresh();
	CSpyButton();
	virtual ~CSpyButton();

	BOOL Initialize (HWND hIcqWnd, int nType);
	BOOL CalculateExtents (CRect icqRect, CRect *buttonRect);

	CWnd * m_pAttachedWnd;
	
protected:
	HANDLE hClipData;
	void RestoreClipboard();
	void SaveClipboard();
	int			m_nType;
	CFont      *m_pFont;
	CString		m_strName;
	CString		m_strUin;
	BOOL		m_bAssocDlgOn;
	BOOL		m_bSelKeyDlgOn;
	BOOL		m_bEncrypted;
	BOOL		m_bDecrypted;
	CPGPICQApp *m_pTheApp;

	
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSpyButton)
	protected:
	//}}AFX_VIRTUAL


	//{{AFX_MSG(CSpyButton)
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg int  OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnAccosiateRecipient();
	afx_msg void OnEncryptAndSend();
	afx_msg void OnOptions();
	afx_msg void OnEncrypt();
	afx_msg void OnDecrypt();
	afx_msg void OnManageKeys();
	afx_msg void OnSendMyPublicKey();
	afx_msg void OnSelectPublicKeyToSend();
	afx_msg void OnHelp();
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SPYBUTTON_H__D0904DF0_F667_4F4D_BE41_CC6A96CA9063__INCLUDED_)
