///////////////////////////////////////////////////////////////////////////
//                                                                       //
// SpyButton.cpp : implementation file                                   //
//                                                                       //
// Copyright (c) 2000 Samopal Corporation.                               //
// All right are all right (tm)                                          //
//                                                                       //
// For news and updates visit http://www.samopal.com/soft/pgpicq/        //
// Email your comments to pgpicq@samopal.com                             //
//                                                                       //
// Free use and distribution of this source code allowed                 //
// under the condition of keeping this header intact.                    //
//                                                                       //
///////////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "PGPICQ.h"
#include "SpyButton.h"
#include "AssociateDlg.h"
#include "SelectKeyDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CSpyButton

CSpyButton::CSpyButton()
{
	m_bAssocDlgOn = false;
	m_bSelKeyDlgOn = false;
	m_bDecrypted = false;

	m_pFont = NULL;
}

CSpyButton::~CSpyButton()
{
	if ( m_pFont )
		delete m_pFont;
}


BEGIN_MESSAGE_MAP(CSpyButton, CButton)
	//{{AFX_MSG_MAP(CSpyButton)
	ON_WM_LBUTTONUP()
	ON_WM_CREATE()
	ON_COMMAND(ID_PGPMENU_ACCOSIATE, OnAccosiateRecipient)
	ON_COMMAND(ID_PGPMENU_ENCRYPTSEND, OnEncryptAndSend)
	ON_COMMAND(ID_PGPMENU_OPTIONS, OnOptions)
	ON_COMMAND(ID_PGPMENU_ENCRYPT, OnEncrypt)
	ON_COMMAND(ID_PGPMENU_DECRYPT, OnDecrypt)
	ON_COMMAND(ID_ICQPGP_PGPKEYS, OnManageKeys)
	ON_COMMAND(ID_PGPMENU_SENDPUBKEY, OnSendMyPublicKey)
	ON_COMMAND(ID_PGPMENU_SELECTPUBKEYTOSEND, OnSelectPublicKeyToSend)
	ON_COMMAND(ID_ICQPGP_HELP, OnHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CSpyButton message handlers




BOOL CSpyButton::Initialize(HWND hIcqWnd, int nType)
{
	CWnd *pName, *pUin;

	m_nType = nType;

	m_strUin = "";
	m_strName = "";

	m_pTheApp = (CPGPICQApp*)AfxGetApp();

	m_pAttachedWnd = new CWnd;
	m_pAttachedWnd->Attach(hIcqWnd);

	CRect icqRect;
	m_pAttachedWnd->GetWindowRect(&icqRect);
	CRect rect;
	if ( !CalculateExtents (icqRect, &rect) )
		return false;

	// get Name and UIN
	
	switch ( m_nType )
	{
		case kMessageTypeOut:
			pName = m_pAttachedWnd->GetDlgItem(kCtrlID_Out_Username);
			pUin = m_pAttachedWnd->GetDlgItem(kCtrlID_Out_Uin);
			break;

		case kMessageTypeIn:
			pName = m_pAttachedWnd->GetDlgItem(kCtrlID_In_Username);
			pUin = m_pAttachedWnd->GetDlgItem(kCtrlID_In_Uin);
			break;

		case kMessageTypeHist:
			pName = m_pAttachedWnd->GetDlgItem(kCtrlID_Hist_Username);
			pUin = m_pAttachedWnd->GetDlgItem(kCtrlID_Hist_Uin);
			break;
	}
	
	if ( pName )
		pName->GetWindowText(m_strName);
	if ( pUin )
		pUin->GetWindowText(m_strUin);

	if ( m_strName == "" || m_strUin == "" )
		return false;
		
	Create(_T(kSpyButtonText), BS_PUSHBUTTON|WS_CHILD|WS_VISIBLE, rect, m_pAttachedWnd, 1000);

	SetWindowPos(&wndTop, 0,0,0,0, SWP_NOMOVE|SWP_NOSIZE|SWP_NOACTIVATE);
	UpdateWindow();

	return true;
}



int CSpyButton::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	// put the button on the very top

	lpCreateStruct->dwExStyle |= WS_EX_TOPMOST;

	if (CButton::OnCreate(lpCreateStruct) == -1)
		return -1;
	

	// change font

	m_pFont = new CFont;
	CString strFontName(kStrFont);

	m_pFont->CreateFont ( 12, 0, 0, 0, FW_NORMAL, 0, 0, 0,
			  ANSI_CHARSET, OUT_TT_PRECIS, CLIP_DEFAULT_PRECIS,
			  DEFAULT_QUALITY, DEFAULT_PITCH|FF_DONTCARE, strFontName);

	SetFont (m_pFont, true);
	
	return 0;
}


void CSpyButton::Refresh()
{
	// recalculate and redisplay button
	// as its owning ICQ window could have changed
	CRect icqRect, rect;

	m_pAttachedWnd->GetWindowRect(&icqRect);
	CalculateExtents (icqRect, &rect);
	SetWindowPos (NULL, rect.left, rect.top, 
		rect.right-rect.left, rect.bottom-rect.top, 0);
	RedrawWindow();


	// if it's a new incoming non-decrypted message, 
	// attempt to decrypt it, if the corresponding option is on
	
	if ( !m_bDecrypted &&
		  m_nType != kMessageTypeOut && 
		  m_pTheApp->m_Options.bAutoDecrypt &&
		  m_pTheApp->m_PGPMan.HasPair(m_strUin) != NULL )
	{
		// only make ONE attempt to auto-decrypt
		m_bDecrypted = true;
		OnDecrypt();
	}
}



void CSpyButton::OnLButtonUp(UINT nFlags, CPoint point) 
{
	// Load the PGP-ICQ menu (Encrypt, Decrypt, Assign keys etc.)

	CMenu menu;
	VERIFY (menu.LoadMenu(IDR_PGP_MENU));
	CMenu* pPopup = menu.GetSubMenu(0);
	ASSERT(pPopup != NULL);

	
	// Depending on the message type, disable certain commands

	BOOL bAssociated = (m_pTheApp->m_PGPMan.HasPair(m_strUin) != NULL) ? true:false;

	
	if ( m_nType == kMessageTypeOut ) {
		menu.EnableMenuItem(ID_PGPMENU_DECRYPT, MF_BYCOMMAND|MF_GRAYED);
		if (!bAssociated) {
			menu.EnableMenuItem(ID_PGPMENU_ENCRYPT, MF_BYCOMMAND|MF_GRAYED);
			menu.EnableMenuItem(ID_PGPMENU_ENCRYPTSEND, MF_BYCOMMAND|MF_GRAYED);
		}
	}
	else {
		menu.EnableMenuItem(ID_PGPMENU_ENCRYPT, MF_BYCOMMAND|MF_GRAYED);
		menu.EnableMenuItem(ID_PGPMENU_ENCRYPTSEND, MF_BYCOMMAND|MF_GRAYED);
		//if (!bAssociated)
		//	menu.EnableMenuItem(ID_PGPMENU_DECRYPT, MF_BYCOMMAND|MF_GRAYED);
	}
	

	if ( m_bAssocDlgOn )
		menu.EnableMenuItem(ID_PGPMENU_ACCOSIATE, MF_BYCOMMAND|MF_GRAYED);

	if ( m_bSelKeyDlgOn )
		menu.EnableMenuItem(ID_PGPMENU_SELECTPUBKEYTOSEND, MF_BYCOMMAND|MF_GRAYED);


	// Show menu

	CRect rect;
	GetWindowRect (&rect);
	 
	pPopup->TrackPopupMenu (
		TPM_LEFTALIGN | TPM_RIGHTBUTTON, 
		rect.left + point.x, rect.top + point.y,
		this );


	CButton::OnLButtonUp(nFlags, point);
}



BOOL CSpyButton::CalculateExtents(CRect icqRect, CRect *buttonRect)
{
	CRect	neigRect;
	int		nDX, nDY, nX, nY;

	ASSERT (buttonRect != NULL);

	// Depending on the message type, find "Cancel" or "Close" button
	// and use its position for calculating the spy button's coords.

	CWnd *pButton;
	switch ( m_nType )
	{
		case kMessageTypeOut:
			pButton = m_pAttachedWnd->GetDlgItem (kCtrlID_Out_Cancel);
			break;
		case kMessageTypeIn:
			pButton = m_pAttachedWnd->GetDlgItem (kCtrlID_In_Close);
			break;
		case kMessageTypeHist:
			pButton = m_pAttachedWnd->GetDlgItem (kCtrlID_Hist_Forward);
			break;
	}

	if ( !pButton )
		return false;

	pButton->GetWindowRect(&neigRect);
	
	nDX = 35;
	nDY = neigRect.bottom - neigRect.top;
	nX  = neigRect.right + 5; 


	// Don't mind a little math to place the button nicely

	switch ( m_nType )
	{
		case kMessageTypeOut:
			//nX = (icqRect.right - icqRect.left)/2 - nDX - 10;
			nY = neigRect.top - icqRect.top - nDY + 1;
			nX = neigRect.right - icqRect.left + 5;
			if ( IsTalkButton() )
			{
				nX += 70;
				nDX = 30;
			}
			break;
		case kMessageTypeIn:
			//nX = neigRect.right - icqRect.left + 5;
			nX = (icqRect.right - icqRect.left)/2 - nDX;
			nY = neigRect.top - icqRect.top - nDY + 3;
			break;
		case kMessageTypeHist:
			nX = neigRect.right - icqRect.left + 4;
			nY = neigRect.top - icqRect.top - nDY + 2;
			break;
	}

	buttonRect->left = nX;
	buttonRect->top = nY;
	buttonRect->right = nX + nDX;
	buttonRect->bottom = nY + nDY;

	return true;
}


void CSpyButton::OnAccosiateRecipient() 
{
	CAssociateDlg	assocDlg;

	// this flag disables the "Assign key" menu command
	// while the CAssociateDlg is on
	m_bAssocDlgOn = true;

	assocDlg.m_strName = m_strName;
	assocDlg.m_strUin = m_strUin;
	assocDlg.DoModal();

	m_bAssocDlgOn = false;
}


void CSpyButton::OnEncryptAndSend() 
{
	// Encrypt
	OnEncrypt();
	if ( !m_bEncrypted )
		return;

	// Tell icq to send message or die
	::SendMessage(m_pAttachedWnd->m_hWnd, WM_COMMAND, kCtrlID_Out_Send, 0);
}


void CSpyButton::OnOptions() 
{
	m_pTheApp->m_pMainWnd->ShowWindow(SW_SHOWNORMAL);
}


void CSpyButton::OnEncrypt() 
{
	CString		strContent = "";
	long		nMsgLength;

	m_bEncrypted = false;

	// get user's public key id
	UinKeyPairStruct *pPair = m_pTheApp->m_PGPMan.HasPair(m_strUin);


	// normally, user should have a uin-key pair 
	// at this point but who knows
	if ( pPair == NULL ) {
		if ( m_pTheApp->m_Options.bCannotEncryptWarning )
			::MessageBox (NULL, _T(kMsgEncryptFailed), 
				_T(kTitleError), MB_APPLMODAL|MB_ICONEXCLAMATION);
		return;
	}

	
	// get the edit control window
	CSpyEdit *pEdit = (CSpyEdit*) m_pAttachedWnd->GetDlgItem(kCtrlID_Out_Edit);
	if ( !pEdit )
		return;
	
	// get the message text, encrypt and put it back

	char chEncMessage[kMaxBufferLength];
	char chMessage[kMaxBufferLength];

	//pEdit->GetContent(chMessage);
	if ( !pEdit->CopyContent() )
		return;

	CClipString clipStrMessage;
	clipStrMessage.InitFromClipboard();
	strcpy(chMessage, clipStrMessage);
	
		
	if ( !strlen(chMessage) )
		return;

	nMsgLength = m_pTheApp->m_PGPMan.EncryptMessage(pPair->keyId, chMessage, chEncMessage);

	if ( nMsgLength == 0 ) 	{
		if ( m_pTheApp->m_Options.bCannotEncryptWarning )
		::MessageBox (NULL, _T(kMsgEncryptFailed), 
			_T(kTitleError), MB_APPLMODAL|MB_ICONEXCLAMATION);
		return;
	}
	else
	{
		pEdit->SetContent(chEncMessage, nMsgLength);
		pEdit->CopyContent();
	}

	m_bEncrypted = true;

}


void CSpyButton::OnDecrypt() 
{
	char		chText[MAX_PATH];
	CString		strClass;
	long		nMsgLength;

	CWnd *pIcqWnd = this->m_pAttachedWnd;
	
	// get user's public key id
	UinKeyPairStruct *pPair = m_pTheApp->m_PGPMan.HasPair(m_strUin);

	// normally, user should have a uin-key pair 
	// at this point but again - shit happens
	if ( pPair == NULL ) {
		if ( m_pTheApp->m_Options.bCannotDecryptWarning )
			::MessageBox (NULL, _T(kMsgDecryptFailed), 
				_T(kTitleError), MB_APPLMODAL|MB_ICONEXCLAMATION);
		return;
	}
	
	// find the edit control window
	// here it's a bit trickier than with an outgoing message since 
	// the edit control is a "grandchild" of the icq message window

	CWnd	 *pSubdlg;
	CSpyEdit *pEdit;

	if ( m_nType == kMessageTypeIn )
	{
		pSubdlg = pIcqWnd->GetTopWindow();
		while ( pSubdlg ) {

			GetClassName (pSubdlg->m_hWnd, chText, MAX_PATH);
			if ( !strcmp(chText, kICQWndClass) )
				break;
			pSubdlg = pSubdlg->GetNextWindow();
		}

		if ( !pSubdlg )
			return;

		// get the edit control window
		pEdit = (CSpyEdit*) pSubdlg->GetDlgItem(kCtrlID_In_Edit);
	}
	else
		pEdit = (CSpyEdit*) pIcqWnd->GetDlgItem(kCtrlID_Hist_Edit);


	if ( !pEdit )
		return;


	// get the message text
	char chDecMessage[kMaxBufferLength];
	char chMessage[kMaxBufferLength];
	//char *chMessage = (char*)malloc(kMaxBufferLength);
	//pEdit->GetEncryptedContent(chMessage);
	//pEdit->GetArmoredContent(chMessage);

	if ( !pEdit->CopyContent() )
		return;

	CClipString clipStrMessage;
	clipStrMessage.InitFromClipboard();
	

	// see if it's a public key they may have sent us
	if ( clipStrMessage.Find (kStrBeginPubKey, 0) != -1 &&
		 clipStrMessage.Find (kStrEndPubKey) != -1 )
	{
		strcpy(chMessage, clipStrMessage);
		m_pTheApp->m_PGPMan.ImportPublicKey(chMessage);
		return;
	}


	// well then, make sure it's a PGP message
	if ( clipStrMessage.Find(kStrBeginPGP) < 0 )
		return;
	strcpy(chMessage, clipStrMessage);

	// decrypt and put it back

	

	nMsgLength = m_pTheApp->m_PGPMan.DecryptMessage(pPair->keyId, chMessage, chDecMessage);

	if ( nMsgLength > 0 )
		pEdit->SetContent(chDecMessage, nMsgLength);
	else  // if <=0, it contains the error code
		switch ( nMsgLength )
		{
			case kPGPError_BadPassphrase:
				::MessageBox (NULL, _T(kMsgBadPass),
					_T(kTitleError), MB_APPLMODAL|MB_ICONEXCLAMATION);
				break;

			case kPGPError_MissingPassphrase:
				::MessageBox (NULL, _T(kMsgPassRequired),
					_T(kTitleError), MB_APPLMODAL|MB_ICONEXCLAMATION);
				break;

			default:
				if ( m_pTheApp->m_Options.bCannotDecryptWarning )
					::MessageBox (NULL, _T(kMsgNotValidMessage), 
					_T(kTitleError), MB_APPLMODAL|MB_ICONEXCLAMATION);
		}

}


void CSpyButton::OnManageKeys() 
{
	::SendMessage(AfxGetMainWnd()->m_hWnd, WM_COMMAND, ID_ICQPGP_PGPKEYS, 0);
}

void CSpyButton::OnHelp() 
{
	::SendMessage(AfxGetMainWnd()->m_hWnd, WM_COMMAND, ID_ICQPGP_HELP, 0);	
}

void CSpyButton::SaveClipboard()
{

}

void CSpyButton::RestoreClipboard()
{

}

BOOL CSpyButton::IsTalkButton()
{
	// stupid Talk button which came with ICQ2000b is messing with
	// our PGP button, so we got to detect its presence
	CWnd *p = m_pAttachedWnd->GetDlgItem(kCtrlID_Out_Talk);
	return  p ? true : false;
}


void CSpyButton::OnSendMyPublicKey() 
{
	char chPubkey[kMaxBufferLength];

	// get the edit control window
	CSpyEdit *pEdit = (CSpyEdit*) m_pAttachedWnd->GetDlgItem(kCtrlID_Out_Edit);
	if ( !pEdit )
		return;

	// get the key
	if ( m_pTheApp->m_PGPMan.GetPublicKey("", chPubkey) != 0 )
	{
		::MessageBox (NULL, _T(kMsgFailedGetOwnerKey), _T(kTitleError), MB_APPLMODAL|MB_ICONEXCLAMATION);
		return;
	}

	pEdit->SetContent(chPubkey, strlen(chPubkey));
}


void CSpyButton::OnSelectPublicKeyToSend() 
{
	CSelectKeyDlg	selDlg;
	char			chPubkey[kMaxBufferLength];

	// this flag disables the "Send a Public Key" menu command
	// while the CSelectKeyDlg is on
	m_bSelKeyDlgOn = true;
	
	if ( selDlg.DoModal() == IDOK )
	{
		// get the edit control window
		CSpyEdit *pEdit = (CSpyEdit*) m_pAttachedWnd->GetDlgItem(kCtrlID_Out_Edit);
		if ( !pEdit )
			return;

		// get the key
		if ( m_pTheApp->m_PGPMan.GetPublicKey(selDlg.m_strSelection, chPubkey) != 0 )
		{
			::MessageBox (NULL, _T(kMsgFailedGetPubKey), _T(kTitleError), MB_APPLMODAL|MB_ICONEXCLAMATION);
			return;
		}

		pEdit->SetContent(chPubkey, strlen(chPubkey));
	}

	m_bSelKeyDlgOn = false;	
}


