///////////////////////////////////////////////////////////////////////////
//                                                                       //
// PGPManager.h                                                          //
//                                                                       //
// Copyright (c) 2000 Samopal Corporation.                               //
// All right are all right (tm)                                          //
//                                                                       //
// For news and updates visit http://www.samopal.com/soft/pgpicq/        //
// Email your comments to pgpicq@samopal.com                             //
//                                                                       //
// Free use and distribution of this source code allowed                 //
// under the condition of keeping this header intact.                    //
//                                                                       //
///////////////////////////////////////////////////////////////////////////


#if !defined(AFX_PGPMANAGER_H__1AA08097_2817_11D4_9309_0001023AC381__INCLUDED_)
#define AFX_PGPMANAGER_H__1AA08097_2817_11D4_9309_0001023AC381__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif

#include "pgpUtilities.h"
#include "pgpKeys.h"
#include "pgpEncode.h"
#include "pgpErrors.h"
#include "pgpPFLErrors.h"



/////////////////////////////////////////////////////////////////////////////
//
// CPGPManager class
//
// Provides access to all the PGP functionality.
//
////////////////////////////////////////////////////////////////////////////


class CPGPManager
{
public:
	long ImportPublicKey (char *chKey);
	long GetPublicKey (CString keyId, char *chKey);
	void ForgetPassphrase();
	
	CPGPManager();
	virtual ~CPGPManager();
	BOOL Initialize();

	BOOL GetUserList ( StringListT *vecUserList );
	BOOL SavePairs();
	BOOL LoadPairs();
	UinKeyPairStruct* HasPair ( CString strUin );
	BOOL RemovePair ( CString strUin );
	BOOL AddPair ( CString strUin, PGPKeyIdT keyId );

	long DecryptMessage(CString keyId, char* chMessage, char* chDecMessage);
	long EncryptMessage (CString keyId, char* chMessage, char* chEncMessage);
	long MakeArmoredMessage (char* chMessage, long nMessageLength);
	long MakeDearmoredMessage (char* chMessage);
	
	CString m_strPGPPath;


protected:
	
	BOOL ObtainPassphrase();
	BOOL IsPGPInstalled();
	BOOL OpenKeyrings();
	BOOL ReleaseKeyrings();

	vector<UinKeyPairStruct>	m_UinKeyPairs;

	PGPContextRef				m_pgpContext;
	PGPKeySetRef				m_defKeySet;

	CString						m_strPassphrase;
};

#endif // !defined(AFX_PGPMANAGER_H__1AA08097_2817_11D4_9309_0001023AC381__INCLUDED_)
