///////////////////////////////////////////////////////////////////////////
//                                                                       //
// PGPICQdefs.h : constant definitions                                   //
//                                                                       //
// Copyright (c) 2000 Samopal Corporation.                               //
// All right are all right (tm)                                          //
//                                                                       //
// For news and updates visit http://www.samopal.com/soft/pgpicq/        //
// Email your comments to pgpicq@samopal.com                             //
//                                                                       //
// Free use and distribution of this source code allowed                 //
// under the condition of keeping this header intact.                    //
//                                                                       //
///////////////////////////////////////////////////////////////////////////



#ifndef	__PGPICQDEFS_H_INCLUDED__
#define __PGPICQDEFS_H_INCLUDED__


#include <vector>

#ifdef _MSC_VER
	using namespace std;
#endif


///////////////////////////////////////////////////////////////////////////
// Base types

typedef	CString PGPKeyIdT;

typedef struct UinKeyPairStruct {
	CString		strUin;
	PGPKeyIdT	keyId;
} _UinKeyPairStruct;

typedef vector<CString> StringListT;

typedef struct OptionsStruct {
	BOOL	bAutoEncrypt;
	BOOL	bAutoDecrypt;
	BOOL	bCannotEncryptWarning;
	BOOL	bCannotDecryptWarning;
	BOOL	bShowSplash;
	BOOL	bIsFirstTime;
	BOOL	bForgetPassphrase;
	int		nPassphraseCacheTime;
} OptionsStruct;


///////////////////////////////////////////////////////////////////////////
// Base constants

#define MAX_BUFFER_LENGTH				65535
#define	kMaxBufferLength				10000
#define PGP_WIN32						1

#define	kPopupMenuCommandId				10000

#define	kMessageTypeOut					1
#define	kMessageTypeIn					2
#define	kMessageTypeHist				3

#define	kPGPLineLength					64

///////////////////////////////////////////////////////////////////////////
// Timer ids and refresh rates:

#define	kRefreshTimerId					1
#define	kRefreshTimerTick				200

#define	kRedrawTimerId					2
#define	kRedrawTimerTick				500	

#define	kPassTimerId					3


///////////////////////////////////////////////////////////////////////////
// ICQ control IDs

#define	kCtrlID_In_Username		0x425
#define	kCtrlID_In_Uin			0x424
#define	kCtrlID_In_Edit			0x401
#define	kCtrlID_In_Close		0x002

#define	kCtrlID_Out_Username	0x44B
#define	kCtrlID_Out_Uin			0x44A
#define	kCtrlID_Out_Edit		0x401
#define	kCtrlID_Out_Send		0x44E
#define	kCtrlID_Out_Cancel		0x002
#define	kCtrlID_Out_Talk		0x19CE

#define	kCtrlID_Hist_Username	0x41F
#define	kCtrlID_Hist_Uin		0x421
#define	kCtrlID_Hist_Edit		0x3E9
#define	kCtrlID_Hist_Forward	0x4F5
#define	kCtrlID_Hist_Prev		0x3EB
#define	kCtrlID_Hist_Close		0x002



//////////////////////////////////////////////////////////////////////////
// Strings


#define kTrayNotificationMsg		"PGP-ICQ tray notification";
#define kStrFont					"MS Sans Serif"

#define kStrBeginPGP				"-----BEGIN PGP MESSAGE-----"
#define kStrEndPGP					"-----END PGP MESSAGE-----"
#define kStrBeginPubKey				"-----BEGIN PGP PUBLIC KEY BLOCK-----"
#define kStrEndPubKey				"-----END PGP PUBLIC KEY BLOCK-----"


// Information messages

#define	kTitleStartupError			"PGP-ICQ Startup Error"
#define	kTitleError					"PGP-ICQ Error"
#define	kTitleWarning				"PGP-ICQ Warning"
#define	kTitleNeutral				"PGP-ICQ"

#define kMsgPgpInitFailed			"Failed to initialize the PGP environment!"
#define kMsgPgpInitNeeded			"First, you have to initialize the PGP environment.\nClick OK to run PGPKeys, click Cancel to quit.\n\nWhen you are done with PGP keys,\nstart PGP-ICQ again."
#define kMsgIcqInitFailed			"Could not find ICQ information in registry."
#define kMsgPgpKeysFailed			"Failed to start PGPKeys."
#define kMsgHelpFailed				"Failed to display PGP-ICQ Help."
#define kMsgPgpICQFailed			"Failed to start PGP-ICQ."
#define kMsgSaveAssocFailed			"Could not save key associations."
#define kMsgPassRequired			"Messages cannot be decrypted\nunless you provide a valid passphrase."
#define kMsgBadPass					"You entered a wrong passphrase.\nPlease try again."
#define kMsgEncryptFailed			"Failed to encrypt the message."
#define kMsgDecryptFailed			"Failed to decrypt the message."
#define kMsgNotValidMessage			"Unable to decrypt this message due to 2 possible reasons:\n\n1. This is not a valid PGP message.\n2. This message cannot be decrypted using current default private key\n(i.e. it was encrypted using someone else's public key."
#define kMsgWinWenumFailed			"Failed to enumerate windows!"
#define kMsgReinstall				"Failed to obtain data from the registry.\nPlease reinstall PGP-ICQ."

#define	kRemoveAssociationWarning	"This command will not delete the recipient's\npublic PGP key from your computer.\nIt will only remove association between\none's ICQ number and the public PGP key.\n\nYou will not be able to exchange\nencrypted messages whith this person\nuntill you assign a public PGP key again.\n\nDo you wish to continue?"
#define kMsgSelectPublicKey			"Select a public key to use with"
#define kMsgUsesPublicKey			"uses the following public key:"
#define kMsgFailedGetOwnerKey		"Failed to get the default public key."
#define kMsgFailedGetPubKey			"Failed to get the selected public key."

#define kMsgGotPublicKeys			"This message contains the following public key(s):\n\n"
#define kMsgImportPublicKeys		"\nDo you want to import these keys into your public keyring?"
#define kMsgErrorImport				"Failed to import key(s)!\n\nMake sure that the key files\nare not used by another application."

#define kMsgWarning					"PLEASE READ CAREFULLY\n\nPGP-ICQ is an open source software, so anyone\ncan examine its source code and see for yourself\nthat it does not contain security leaks or\ncompromise  your privacy.\n\nRemember that anyone can modify the program\ncode and redistribute it.\n\nWe DO NOT GARANTEE that a copy of PGP-ICQ\ndownloaded from a website other than\nhttp://www.samopal.com does not contain\nviruses (including trojans) and security backdoors.         "


// Substrings

#define kSpyButtonText				"PGP"
#define kStrPathPgpKeys				"pgpkeys.exe"
#define kStrPathPgpHelp				"pgpicq.chm"
#define kStrPathPgpIcq				"pgpicq.exe"

#define kStrTrayIconTip				"PGP-ICQ"
#define	kICQWndClass				"#32770"


// Registry paths

#define kRegPathIcqOwners			"Software\\Mirabilis\\ICQ\\Owners"
#define kRegPathGIcqOwners			"Software\\Mirabilis\\ICQCorp\\Owners"
#define kRegPathRun					"Software\\Microsoft\\Windows\\CurrentVersion\\Run"
#define kRegPathPGP					"Software\\Network Associates\\PGP"
#define kRegPathPgpIcq				"Software\\Samopal Corporation\\PGP-ICQ"
#define kRegPathAssociations		"Software\\Samopal Corporation\\PGP-ICQ\\Associations"
#define kRegPathPgpKeys				"Software\\Samopal Corporation\\PGP-ICQ\\PGPKeys"
#define kStrInstPath				"InstallPath"


#define kPGPICQArmorBlock			"PGPICQ_ARMOR_BLOCK"

#define kErr

#endif
