//***********************************************************************
//
//  HexDoc.h
//
//***********************************************************************
#ifndef __HexDoc
#define __HexDoc


#include "..\inc\ntddndis.h"
#include "..\inc\packet32.h"

#define  UNICODE 1
//#define  KEY 10000
#define  MAX_PACKET_LENGTH 1514  // (MAC ethernet/802.3)


typedef struct block
{
    BYTE*   p;			   // punta ai dati
    UINT    packetLength;  // lunghezza 
    block*  next;          // prossimo pacchetto
} *PBLOCK,BLOCK;


class CHexDoc : public CDocument
{
    DECLARE_DYNCREATE (CHexDoc)

private:
    UINT    m_nDocLength;   // lunghezza totale documento 
    PBLOCK  m_pFileData;    // punta al primo BLOCK del documento
	LPPACKET pHeadList;         // 
	UINT    NumberOfPacket; // numero di pacchetti catturati
	BOOL    fileOrNet;  // mi dice se il documento
						// e' un file (True) oppure se 
	                    // e' una cattura da rete (False)	
public:
	BYTE * BigBuffer;  // buffer per il file o i pacchetti
	LPADAPTER Adapter; // puntatore alla struttura ADAPTER

    CHexDoc ();
    ~CHexDoc ();
    virtual void DeleteContents ();
    virtual void Serialize (CArchive&);
    
	UINT GetBytes (UINT, UINT, PVOID);
    UINT GetDocumentLength ();
    void SetDocumentLength ();

	void DumpPacket();  // scrive su file i pacchetti catturati
	void OpenAdapter(); 
	int  readPackets(UINT n); // cattura N pacchetti
	int  readPacket();        // cattura un pacchetto  
	int  writePacket();       // invia un pacchetto
};

#endif