//***********************************************************************
//
//  HexDoc.cpp
//
//***********************************************************************

#include <afxwin.h>
#include "HexDoc.h"

// -----------------------------------------------
IMPLEMENT_DYNCREATE (CHexDoc, CDocument)

// -----------------------------------------------
CHexDoc::~CHexDoc ()
{
	if (BigBuffer != NULL)
		delete[] BigBuffer;
}
// -----------------------------------------------
CHexDoc::CHexDoc ()
{
    m_nDocLength = 0;
    m_pFileData = NULL;
	pHeadList = NULL;
	BigBuffer = NULL;
	Adapter = NULL;
}

// -----------------------------------------------
void CHexDoc::DeleteContents ()
{
 PBLOCK  next;
 
    while (m_pFileData != NULL)    
		{
            next = m_pFileData->next;
			m_pFileData->next = NULL;
		    delete[] m_pFileData;
			m_pFileData = next;
		}
	// libero il buffer;
	if (BigBuffer != NULL)
		delete[] BigBuffer;
	BigBuffer = NULL;
	pHeadList = NULL;
    m_nDocLength = 0;
}

// -----------------------------------------------
void CHexDoc::Serialize (CArchive& ar)
{
	DeleteContents();
    if (ar.IsLoading ()) {
        CFile* pFile = ar.GetFile ();
        m_nDocLength = (UINT) pFile->GetLength ();

        // Allocate a buffer for the file data

        try {
			m_pFileData = new BLOCK;
			BigBuffer = new BYTE[m_nDocLength];
			m_pFileData->p = BigBuffer;
			m_pFileData->next = NULL;
		}
        catch (CMemoryException* e) {
            m_nDocLength = 0;
            throw e;
        }

        fileOrNet = TRUE;
		// Read the file data into the buffer
        try {
            pFile->Read (m_pFileData->p, m_nDocLength);
        }
        catch (CFileException* e) {
            delete[] m_pFileData->p;
            m_pFileData->p = NULL;
			delete[] m_pFileData;
            m_nDocLength = 0;
            throw e;
        }
    }
}

// -----------------------------------------------

void CHexDoc::DumpPacket ()
{
 BYTE *p;
 PBLOCK pb = m_pFileData;

 UINT n;  
 char* pFileName = "dump.hex";
 CFile f( pFileName, CFile::modeCreate | CFile::modeWrite );

 while (pb != NULL)
 {
	p = pb->p;
    n = pb->packetLength;

	f.Write(p,n);
	pb = pb->next;
 }

 f.Close();
}

// -----------------------------------------------
int CHexDoc::readPackets (UINT n)
{
	if (Adapter == NULL)
		return 0;

    fileOrNet = FALSE;
	DeleteContents(); // butto i vecchi dati

	NumberOfPacket = 0;
    PBLOCK pb,prev;
	LPPACKET Packet,packetprev;
    
    // alloco il buffer per i pacchetti
    BigBuffer = new BYTE[MAX_PACKET_LENGTH * n];

	pb = prev = NULL;

	// programmo la cattura di N pacchetti
	Packet = PacketAllocateNPacket(n);
    // catturo gli N pacchetti
    PacketReceiveNPacket(Adapter,Packet,n,MAX_PACKET_LENGTH,BigBuffer,TRUE);     
    

    // organizzo i pacchetti per maneggiarli con l'applicazione
	pHeadList = Packet;
    if (Packet != NULL)
	{
		pb = new BLOCK;
		m_pFileData = prev = pb;
		pb->next = NULL;
		pb->p = (BYTE*)Packet->Buffer;
		pb->packetLength = Packet->ulBytesReceived;
	    packetprev = Packet;
        Packet = PacketGetNextPacket(Packet);
		NumberOfPacket ++;
	}
		
    while (Packet != NULL)
	{
		pb = new BLOCK;
		prev->next = pb;
		prev = pb;
		pb->next = NULL;
		pb->p = (BYTE*)Packet->Buffer;
		pb->packetLength = Packet->ulBytesReceived;
        packetprev = Packet;
		Packet = PacketGetNextPacket(Packet);
		NumberOfPacket ++;
	}
	SetDocumentLength();
	return NumberOfPacket;
}

// -----------------------------------------------
int CHexDoc::readPacket()
{
	if (Adapter == NULL)
		return 0;

    fileOrNet = FALSE;
	DeleteContents(); // butto i vecchi dati

	NumberOfPacket = 0;
    PBLOCK pb;
	LPPACKET Packet;
    
    // alloco il buffer per il pacchetto
    BigBuffer = new BYTE[MAX_PACKET_LENGTH];

	pb = NULL;

	// programmo la cattura del pacchetto
	Packet = PacketAllocatePacket();
	PacketInitPacket(Packet,BigBuffer,MAX_PACKET_LENGTH);
    // catturo il pacchetto
    PacketReceivePacket(Adapter,Packet,TRUE);     
    

	pHeadList = Packet;
    if (Packet != NULL)
	{
		pb = new BLOCK;
		m_pFileData = pb;
		pb->next = NULL;
		pb->p = (BYTE*)Packet->Buffer;
		pb->packetLength = Packet->ulBytesReceived;
		NumberOfPacket ++;
	}
		
	SetDocumentLength();
	return 1;
}

// -----------------------------------------------
int CHexDoc::writePacket()
{
	if (Adapter == NULL || pHeadList == NULL)
		return 0;

    // invio il primo pacchetto della lista di pacchetti catturati
	BOOL Result = PacketSendPacket(Adapter,pHeadList,TRUE);
	return Result;
}

// -----------------------------------------------

UINT CHexDoc::GetBytes (UINT nIndex, UINT nCount, PVOID pBuffer)
{

if (nIndex >= m_nDocLength)
    return 0;
if (fileOrNet)
 {
    UINT nLength = nCount;
    if ((nIndex + nCount) > m_nDocLength)
        nLength = m_nDocLength - nIndex;

    ::CopyMemory (pBuffer, m_pFileData->p + nIndex, nLength);
    return nLength;
 }
 else
 { 
	PBLOCK pb = m_pFileData;
    UINT offset,i,index;
    UINT nLength;

	offset = 0;
	index = 0;
	nLength = nCount;

    index += pb->packetLength;
	i = 1;
	while (i < NumberOfPacket && index < nIndex)
	{
		index += 16 - pb->packetLength % 16;
		index += 16;
		pb = pb->next;
	    index += pb->packetLength;
		i ++;
	}
	if (index > nIndex)
	{
	    if ((nIndex + nCount) > index)
			nLength = nCount - (16 - pb->packetLength % 16);

		offset = pb->packetLength - (index - nIndex);
		::CopyMemory (pBuffer, (pb->p) + offset, nLength);
		return nLength;
	}
	return 100;
 }
}

// -----------------------------------------------
void CHexDoc::SetDocumentLength()
{
	if (!fileOrNet)
	{
		PBLOCK pb = m_pFileData;
		UINT totLen = 0;
		UINT i;

		for (i = 0; i < NumberOfPacket; i ++)
		{
			totLen += pb->packetLength + (16 - pb->packetLength % 16);
			totLen += 16; // linea di separazione tra i pacchetti
			pb = pb->next;
		}
		m_nDocLength = totLen;
	}
}

// -----------------------------------------------
UINT CHexDoc::GetDocumentLength ()
{
	return m_nDocLength;
}
//***********************************************************************
