; 
;      ASPackunpackerv1.0-(c)[bane//DTG][dope@mailandnews.com]
; 
;  unpacks: aspack 1.02b, 1.07b, 1.08.00/1/2/3.
; 
;  cannot:  restore section flags
;           restore .reloc section (only EXEs packed with aspack 1.08.03)
;
;  compile: tasm32 unaspack.asm /m9 /z /ml
;           tlink32 unaspack.obj /c /x 
;           stubit unaspack.exe [wdosx, www.wuschel.demon.co.uk]
;
;  mail:    dope@mailandnews.com
;           when you have found a bug or have a version of aspack
;           i don't have, please send it to me.
; 
.386
.MODEL FLAT, STDCALL
.DATA
hello  db  0dh, 0ah, 'Ŀ' 
       db  0dh, 0ah, '[unASPackv1.0]-[bane//DTG]ĳ'
       db  0dh, 0ah, '' 
       db  0dh, 0ah, ' Usage:  unASPack.exe file.exe'
       db  0dh, 0ah, '$'
canop  db  'Cannot open input file.','$'
unperr db  'Decompression error, aborting.', 0dh, 0ah, '$'
notpe  db  'not a PE file or bad header.', '$'
notap  db  'nothing found.', '$'
mepom  db  ' - ', '$'
crlf   db  0dh, 0ah, 0 

signature struc
chksum    dd  ?                 ; checksum of first 200 bytes
aname     db  10h dup (?)       ; name, must be 16 bytes long
versiona  dd  ?                 ; aspack version, 102h=1.02, 1083h=1.08.03 etc.
atable    dd  ?                 ; offset of objtbl of packed objects in .aspack
idata     dd  ?                 ; offset of original import RVA in .aspack
reloc     dd  ?                 ; offset of original fixups RVA in .aspack
entry     dd  ?                 ; offset of original epoint RVA in .aspack
signature ends      
sisize    equ 4+10h+4+4+4+4+4 ; size of signature struct

signatures:
; ASPack1.02b
          dd     444CEFE5h
          db     'ASPack 1.02b',0,0,0,0 
          dd     102h                   
          dd     401h                   
          dd     4EBh                   
          dd     3F5h                   
          dd     3E5h                   
; ASPack1.07b                      
          dd     3B5C4508h
          db     'ASPack 1.07b',0,0,0,0  
          dd     107h                   
          dd     4E7h                   
          dd     6E9h                   
          dd     4DBh                   
          dd     4CBh
; ASPack1.08.00
          dd     0A36E9934h
          db     'ASPack 1.08.00',0,0 
          dd     1080h
          dd     57Ah
          dd     781h
          dd     56Ah
          dd     55Ah
; ASPack1.08.01                      
          dd     1FED17B4h
          db     'ASPack 1.08.01',0,0  
          dd     1081h                 
          dd     57Ah                  
          dd     781h                  
          dd     56Ah                  
          dd     55Ah                  
; ASPack1.08.02                      
          dd     6771E180h
          db     'ASPack 1.08.02',0,0
          dd     1082h
          dd     54Eh
          dd     68Dh
          dd     53Eh
          dd     52Eh
; ASPack1.08.03                      
          dd     0FB30BA9Dh
          db     'ASPack 1.08.03',0,0    
          dd     1083h          
          dd     0F3h           
          dd     0E7h           
          dd     0E3h           
          dd     0EBh           
; end            
          dd     0, 0                           ; end of signatures

.DATA?
handle    dd  ?                                 ; file handle
base      dd  ?                                 ; base address
signa     dd  ?                                 ; ofs of signature
inmem     dd  ?                                 ; ofs of aspack in memory
objectbl  dd  ?                                 ; ofs of object table in memory
realnum   dd  ?                                 ; real number of objs in file
numobj    dd  ?                                 ; new number of objs in file
lastobj   dd  ?                                 ; ofs of last entry in mem
peimage   dd  ?                                 ; addr of pe header in mem
newphys   dd  ?                                 ; new physical ofs
astart    dd  ?                                 ; .aspack start rva
aend      dd  ?                                 ; .aspack end rva
tlsflag   dd  ?                                 ; tls restored  flag
filename  dd  ?                                 ; argv[1]
asections dd  ?                                 ; number of added sections
realunp   dd  ?                                 ; unpacked size of section
mptr      dd  ?                                 ; ptr to mem handle
mhandles  dd  10h dup (?)                       ; handles for 0501h/31h    
.CODE
Start:  push ds                                 ; 
        pop  es                                 ; es = ds

        mov  edx, offset hello                  ; write something
        mov  ah, 09h                            ; to the screen
        int  21h                                ; 

        dec  esi                                ; argc
        jz   quit                               ; =1?, quit

        mov  edx, [edi + 4]                     ; argv[1]
        mov  filename, edx

reload:
        mov  edx, filename
        mov  ax, 3D02h                          ; open input file 
        int  21h                                ; read/write
        jnc  fileok                             ;

        mov  ah, 09h                            ; write error message
        mov  edx, offset canop                  ; 'cannot open infile'
        int  21h                                ;
        jmp  quit                               ; and quit

fileok: and  eax, 0FFFFh                        ; just to be sure
        mov  [handle], eax                      ; save file handle
        xchg eax, ebx                           ; handle into ebx

        mov  esi, filename                      ; write filename argv[1]
        call w0                                 ; write asciiz string
        mov  tlsflag, 0                         ; set TLS restored flag = 0
        mov  decRVA, 0
        mov  asections, 1
   
        mov  ah, 09                             ; write ' - '
        mov  edx, offset mepom                  ; -
        int  21h                                ; 

        mov  ax, 4202h                          ; move file pointer to eof
        xor  ecx, ecx                           ; to get file size
        xor  edx, edx                           ;
        int  21h                                ;

        shld edx, edx, 10h                      ; calculate file size
        and  eax, 0FFFFh                        ; 
        or   eax, edx                           ;
        xchg eax,ebp                            ; save filesize to ebp

        mov  ax, 4200h                          ; move file pointer 
        xor  ecx, ecx                           ; to file_begin
        xor  edx, edx                           ;
        int  21h                                ;

        mov  eax, ebp                           ; file size into eax
        call getmem                             ; alloc mem for "file-mapping"
        mov  base, eax                          ; save base address

        xchg eax, edx                           ; buffer
        mov  ah, 3Fh                            ; read file
        mov  ecx, ebp                           ; filesize
        int  21h                                ; read entire file into memory

        mov  esi, base                          ; mapped file
        cmp  word ptr [esi], 'ZM'               ; check for MZ signature
        je   itismz                             ;
        cmp  word ptr [esi], 'MZ'               ; ZM - very rare
        je   itismz                             ;

itsnpe: mov  edx, offset notpe                  ; write 'not a pe' message
        mov  ah, 09h                            ;
        int  21h                                ;
        jmp  close                              ; close file + quit program

itismz: mov  eax, [esi+3Ch]                     ; offset of PE header
        cmp  eax, ebp                           ; >= filesize ?
        jae  itsnpe                             ; yes, quit

        add  esi, eax                           ; PE header ofs
        mov  peimage, esi                       ; save it

        cmp  dword ptr [esi], 00004550h         ; check PE signature (P,E,0,0)
        jne  itsnpe                             ; not a pe :(

        movzx ecx, word ptr [esi+6]             ; get number of sections
        mov  realnum, ecx                       ; save real number of sections

        add  si, [esi+14h]                      ; add NT header size
        add  esi, 18h                           ; calc object table offset
        mov  [objectbl], esi                    ; save offset of object table
        dec  ecx                                ; number of sections -1
        imul ecx, 28h                           ;
        add  esi, ecx                           ; go to last section

        mov  eax, [esi+10h]                     ; physical size
        add  eax, [esi+14h]                     ; physical offset
        sub  ebp, eax                           ; file_size - last_obj_end
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
; 1083: when a setup-file needs overlay at special offset, this 
; >>>>  will probably not work, because aspack 1.08.03 destroys
; >>>>  the reloc section if image_base != 400000,
; >>>>  file after unpacking will be a bit smaller than the original
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        mov  ovlsize, ebp                       ; save overlay size
        add  eax, base
        mov  overlay, eax                       ; save overlay address

flowzp: cmp  dword ptr [esi+10h], 0             ; physical size=0 (.udata)
        jnz  lphofs                             ; 
        inc  asections                          ; added_sections++
        sub  esi, 28h                           ; go back one object
        jmp  flowzp                             ; repeat

lphofs: mov  lastobj, esi                       ; save ofs of last obj entry
        cmp  dword ptr [esi+10h], 200           ; physical size < 200
        jb   itsnpe                             ; cant continue, its not aspack

        mov  eax, [esi+0Ch]                     ; RVA of .aspack
        mov  astart, eax                        ; save it
        add  eax, [esi+08h]                     ; virtual size of .aspack
        mov  aend, eax                          ; save it

        mov  esi, [esi+14h]                     ; physical offset of .aspack
        add  esi, base                          ; + base address
        mov  [inmem], esi                       ; .aspack addr in memory
; ->>>> calculate checksum
        xor  eax, eax                           ; calculate checksum
        xor  ebx, ebx                           ; from the first 200 bytes
        mov  ecx, 200/8                         ;
chksumx:
        lodsd                                   ; 
        add  ebx, eax                           ; simple checksum
        lodsd                                   ; 
        add  ebx, eax                           ; 
        loop chksumx                            ; 
        xchg eax, ebx                           ;

        mov  edi, offset signatures             ; 
ftfs:   cmp  dword ptr [edi], 0                 ; end of signatures?
        je   naspk                              ; 
        cmp  eax, [edi.signature.chksum]        ; compare checksum
        je   sfound                             ; the checksums match
        add  edi, sisize                        ; check next signature
        jmp  ftfs                               ; 

naspk:  mov  ah, 09h                            ;
        mov  edx, offset notap                  ; write msg 
        int  21h                                ; 'not packed with aspack'

close:  mov  ebx, [handle]                      ; close file
        mov  ah, 3Eh                            ;
        int  21h                                ;
        call freemem
quit:   mov  ax, 4C00h                          ; quit
        int  21h                                ;

sfound: mov  signa, edi                         ; save offset of signature
        lea  esi, [edi.signature.aname]         ; write aspack version
        call w0                                 ; 
        mov  esi, offset crlf                   ; write cr lf
        call w0                                 ;

        mov  eax, [realnum]                     ; real number of objects
        sub  eax, [asections]                   ; substract .aspack's sections
        mov  [numobj], eax                      ; new number of objects

; [ unpack code of aspack 1.08.03 ]

        cmp  [edi.signature.versiona], 1083h    ; code of aspack 1.08.03 
        jne  dndc                               ; is compressed
        mov  esi, [inmem]                       ;
        add  esi, 0CBh                          ; offset = 0CBh
        mov  eax, 49Ah                          ; unpacked size
        call getmem                             ; allocate memory

        push esi                                ; unpack to
        push eax                                ; unpack from
        mov  edi, eax                           ; ptr allocated memory
        mov  ecx, 49Ah                          ; size
        repe movsb                              ; copy into allocated memory
        call decompress                         ; from memory -to-> aspacks section
        add  esp, 8                             ; adj stack
        
dndc:   mov  esi, peimage                       ; fun begins

; ->>>> get tls physical ofs, size
        mov  eax, [esi+0C0h]                    ; tls rva
        call RVAtoPA                            ; RVA -> physical address
        mov  tlsdata, eax                       ; tls section physical ofs

        push dword ptr [esi+0C4h]               ; tls size
        pop  dword ptr [tlssize]                ; save it
; ->>>> restore some values

        mov  edi, inmem                         ; .aspack in mem
        mov  ebx, signa                         ; signature
        mov  eax, [ebx.signature.entry]         ; get ofs of entry point
        push dword ptr [edi+eax]                ; get original entry point
        pop  dword ptr [esi+28h]                ; 

        mov  eax, [ebx.signature.idata]         ; import rva
        mov  eax, [edi+eax]                     ; get original import RVA
        mov  [esi+80h], eax                     ; 
        mov  [import], eax                      ;

        mov  eax, [ebx.signature.reloc]         ; reloc rva
        mov  eax, [edi+eax]                     ;
        mov  [esi+0A0h], eax                    ; get original reloc RVA
        mov  [fixups], eax                      ;

        push dword ptr [esi+88h]                ; resource rva
        pop  dword ptr [rsrc]                   ; 

        and  byte ptr [esi+0F6h], NOT 10h       ; zero aspack's flag

        mov  ecx, dword ptr [asections]
        mov  eax, lastobj                       ;
ssize:  mov  ebx, [eax+8]                       ; virtual size of aspack's objs
        sub  [esi+50h], ebx                     ; substract
        add  eax, 28h                           ; restore old image size
        loop ssize                              ;

        mov  eax, [numobj]                      ; number of objects
        mov  [esi+06h], ax                      ; set it in PE header

        mov  edi, [objectbl]                    ; edi - object table

        push dword ptr [edi+14h]                ; physical offset of 1.object
        pop  dword ptr [newphys]                ; new phys ofs

        mov  ecx, [numobj]                      ; number of sections
        inc  ecx                                ;
nexobj: dec  ecx                                ;
        jz   writefile                          ; all sections written?

        mov  esi, signa                         ;
        mov  esi, [esi.signature.atable]        ;
        add  esi, inmem                         ; esi - aspack's object table 
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
; aspack's object table format:
;
; dd  RVA (of compressed section)
; dd  Unpacked_size
; ...
; dd  0
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        push ecx                                ;
nlk:    mov  eax, [esi]                         ; get RVA of compressed section
        or   eax, eax                           ; null = end of table
        jz   not_packed                         ;
        cmp  eax, [edi+0Ch]                     ; RVA
        jb   next                               ;
        sub  eax, [edi+0Ch]                     ;
        cmp  eax, [edi+08h]                     ; Virtual Size
        jb   found                              ;
next:   add  esi, 8                             ; next entry in aspacks obj tbl
        jmp  nlk                                ;

found:  cmp  decRVA, 0                          ; decrypt_e8e9  RVA=0
        jne  nodec                              ; set decrypt_e8e9 RVA      
        push dword ptr [edi+0Ch]                ; to RVA of first compressed
        pop  dword ptr [decRVA]                 ; section
         
nodec:  mov  ecx, eax                           ; save difference in ecx
        add  eax, [esi+4]                       ; difference + unpacked size
        mov  [edi+10h], eax                     ; physical size = unpacked size
        call getmem                             ; allocate memory
        mov  [edi+18h], eax                     ; save addr of unpacked data

        mov  eax, [esi+4]                       ; get unpacked size
        mov  realunp, eax                       ;
        push esi                                ;
        push edi                                ;

        mov  esi, [edi+14h]                     ; physical offset
        add  esi, base                          ;
        mov  edi, [edi+18h]                     ; allocated memory
        repe movsb                              ; copy uncompressed data first
        push edi                                ; unpack from
        push esi                                ; unpack to
        call decompress                         ; decompress 
        add  esp, 8                             ; adjust stack

        cmp  eax, realunp                       ; compare size
        je   usizeok                            ; 
        mov  ah, 09h                            ; write error message
        mov  edx, offset unperr                 ;
        int  21h                                ;
        jmp  close                              ; quit

usizeok:pop  edi                                ;
        pop  esi                                ;

        push dword ptr [newphys]                ; 
        pop  dword ptr [edi+14h]                ; set new physical offset
        mov  eax, [edi+10h]                     ; 
        add  [newphys], eax                     ; update new physical ofs

        jmp  short nec                          ; 

not_packed:
        mov  eax, [edi+14h]                     ; physical ofs
        or   eax, eax                           ;
        jz   wzero                              ;
        add  eax, base                          ;
wzero:  mov  dword ptr [edi+18h], eax           ; ptr to relocs 

        cmp  dword ptr [edi+14h], 0             ;
        jz   dnst                               ;
        push dword ptr [newphys]                ; set new physical ofs
        pop  dword ptr [edi+14h]                ; 
dnst:   mov  eax, [edi+10h]                     ; 
        add  [newphys], eax                     ; update new physical ofs

nec:    call fix_section                        ;
        add  edi, 28h                           ; next entry in real object tbl
        pop  ecx                                ;
        jmp  nexobj                             ;
;  write file 
writefile:

; ->>>> remove aspack's objects from object table

        mov  edi, [objectbl]                    ; object table
        mov  ecx, [numobj]                      ; new number of objects
        imul eax, ecx, 28h                      ; eax = ecx * 28
        add  edi, eax                           ;

        push edi                                ; save ofs for new .tls

        mov  ecx, realnum                       ; real number of objects -
        sub  ecx, numobj                        ; new number of objects
        imul ecx, 28h                           ; * 28
        xor  eax, eax                           ; 
        repe stosb                              ; zero aspack's entries

        pop  edi                                ; restore ofs for new .tls
        cmp  tlsflag, 1                         ; tls restored?
        jz   dnrt                               ; yes, skip
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
; unaspack recognizes the .tls by name, if it was renamed, it cannot
; guess which section is .tls, so it creates a new .tls at end
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        mov  tlsflag, 9                         ; flag = create new .tls at EDI
        call fix_tls                            ;

dnrt:   mov  ebx, handle                        ;
        mov  ax, 4200h                          ; move file pointer to start
        xor  ecx, ecx                           ;
        xor  edx, edx                           ;
        int  21h                                ;

        xor  ecx, ecx                           ; make file size = 0
        mov  ah, 40h                            ;
        int  21h                                ;

        mov  esi, [objectbl]                    ; object table
wrs:    mov  ebx, [handle]                      ;

        mov  edx, [esi+14h]                     ; physical offset
        mov  ax, 4200h                          ;
        mov  ecx, edx                           ; move file pointer
        shr  ecx, 10h                           ;
        and  edx, 0FFFFh                        ; to physical offset
        int  21h                                ;
                                                
        mov  ecx, [esi+10h]                     ; physical size
        or   ecx, ecx                           ; do not write .bss
        jz   skipw                              ; if bss, ecx = 0 = set EOF

        mov  edx, [esi+18h]                     ; addr of unpacked data

        mov  dword ptr [esi+18h], 0             ; zero addr of unpacked data
        or   edx, edx                           ; addr = 0
        jz   skipw                              ; skip
        mov  ah, 40h                            ; write section to file
        int  21h                                ;
skipw:
        add  esi, 28h                           ; next entry 

        dec  [numobj]                           ; decrease number of objects
        jnz  wrs                                ; 
; write dos, pe header, object table
        mov  ax, 4200h                          ; move file pointer to start
        xor  ecx, ecx                           ;
        xor  edx, edx                           ;
        int  21h                                ;

        mov  esi, objectbl                      ; get physical offset 
        mov  ecx, [esi+14h]                     ; of first section
        mov  edx, base                          ; write dos header,
        mov  ah, 40h                            ;       pe header  
        int  21h                                ;       object table

; ->>>> write extra data (overlay)

        mov  ax, 4202h                          ; move file pointer to EOF
        xor  ecx, ecx                           ;
        xor  edx, edx                           ;
        int  21h                                ;
        mov  edx, overlay                       ; overlay address in memory
        mov  ecx, ovlsize                       ; overlay size
; ->>>> this can set EOF with ecx=0, but it doesn't matter, because we are at EOF
        mov  ah, 40h                            ;
        int  21h                                ; write overlay

        mov  ah, 3Eh                            ; close file
        int  21h                                ;

        call freemem                            ; free allocated memory

        jmp  reload                             ; next layer
; 
.DATA?
ovlsize dd ?                                    ; overlay size
overlay dd ?                                    ; overlay address
tlsdata dd ?                                    ; tls address
tlssize dd ?                                    ; tls size
decRVA  dd ?                                    ; decrypt RVA
.DATA
import  dd ?                                    ; import RVA
        dd offset fix_import                    ;
fixups  dd ?                                    ; fixups RVA
        dd offset fix_fixups                    ;
rsrc    dd ?                                    ; rsrc RVA
        dd offset fix_rsrc                      ;
        dd 0,0                                  ;
tlsnm  db  '.tls',0,0,0,0                       ; name for new tls section

.CODE
fix_section  proc                               
        pushad                                  ; 
     
        mov  esi, offset import                 ;
fixloop:mov  edx, [edi+18h]                     ; addr of unpacked section

        lodsd                                   ; get rva (import, reloc, rsrc)
        cmp  eax, [edi+0Ch]                     ; fix_rva < rva
        jb   fixnext                            ;
        sub  eax, [edi+0Ch]                     ; - rva
        cmp  eax, [edi+08h]                     ;
        jae  fixnext                            ;

        add  edx, eax                           ;
                                                 
        call [esi]                              ; call fix_ routine
                                                 
fixnext:add  esi, 4                             ;
        cmp  dword ptr [esi+4], 0               ;
        jnz  fixloop                            ;


        mov  eax, [edi+0Ch]                     ; RVA
        cmp  eax, decRVA                        ; RVA = decrypt_e8e9_RVA
        jne  f4                                 ;
        call fix_crypte8e9                      ; decrypt first packed object

f4:     cmp  dword ptr [edi], 'slt.'            ; lame
        jne  f5                                 ;
        call fix_tls                            ; fix tls
                                                ;
f5:     cmp  dword ptr [edi], 'SLT.'            ; lame 
        jne  f6                                 ;
        call fix_tls                            ; fix tls

f6:     popad                                   ;
        ret                                     ;
fix_section endp                                ;
; [fix_import]
fix_import:                                      
        push esi                                ;
        xor  ecx, ecx                           ; never guesses exactly the size
        add  edx, 4                             ;
fiximp: cmp  dword ptr [ecx+edx+0ch], 0         ; module (dll) name=0 ?
        je   fixend                             ;
        add  ecx, 14h                           ; next entry
        jmp  fiximp                             ;
fixend: add  ecx, 14h                           ; 

        mov  esi, peimage                       ;
        mov  [esi+84h], ecx                     ; IAT size
        pop  esi                                ;
        ret                                     ;
; [fix_relocs]
fix_fixups:
        push esi                                ;
        mov  ecx, [edi+10h]                     ; physical size
        or   ecx, ecx                           ; = 0?
        jz   killfix                            ; zero entries in image_data_dir
        xor  ecx, ecx                           ;
ffix:   add  ecx, 4                             ;
        cmp  dword ptr [ecx+edx], 0             ; 
        jne  ffix                               ;

        mov  esi, peimage                       ;
        mov  [esi+0A4h], ecx                    ; IAT size
        pop  esi                                ;
        ret                                     ;
killfix: 
        mov  esi, peimage                       ;
        mov  dword ptr [esi+0A0h], 0            ; set fixups RVA = 0
        mov  dword ptr [esi+0A4h], 0            ; set fixups size = 0
        pop  esi                                ;
        ret                                     ;
; 
; -> restore resources
; -> moves _everything_ from .aspack to .rsrc
; -> works only because aspack leaves the original resources in .rsrc section
; 
fix_rsrc proc uses esi                                  
LOCAL rsrc_base:dword, rsrc_start:dword, rsrc_end:dword, level:byte

        mov  [level], 0                         ;
        mov  [rsrc_base], edx                   ;
        mov  [rsrc_start], edx                  ;
        mov  esi, edx                           ;
        add  edx, [edi+10h]                     ; physical size
        mov  [rsrc_end], edx                    ;
dodir:                                          ; skip:
        lodsd                                   ; Characteristics 
        lodsd                                   ; TimeDateStamp 
        lodsd                                   ; MajorMinorVersion 
        xor     eax,eax                         ;
        lodsw                                   ; NumberOfNamedEntries
        mov     ecx, eax                        ;
        lodsw                                   ; NumberOfIdEntries
        add     ecx, eax                        ; Number of entries
        inc     ecx                             ;

doentry:dec     ecx                             ;
        jz      downdir                         ; number of entries left=0 ?
        lodsd                                   ; skip type
        lodsd                                   ; get rsrc address
        test     eax, 80000000h                 ; is it a directory?
        jz       notdir                         ; not a directory

        push     esi                            ; save esi - pointer 
        push     ecx                            ;          - entries counter
        and      eax, 7FFFFFFFh                 ; address - only bits 0..31
        xchg     eax, esi                       ;
        add      esi, [rsrc_base]               ; calc new address

        inc      byte ptr [level]               ; number of dirs +1
        jmp      dodir                          ; check directory

notdir: push     esi                            ; save pointer
        mov      esi, eax                       ;
        add      esi, [rsrc_base]               ; calc address

        lodsd                                   ; rva of rsrc data
        cmp      eax, [astart]                  ; check if rsrc data points to
        jb       rsrcOK                         ; .aspack
        cmp      eax, [aend]                    ;
        jae      rsrcOK                         ;
;  move it back 
        pushad                                  ; save all regs
        push esi                                ;
        mov  ecx, [esi]                         ; size of rsrc data
                                                
        call RVAtoPA                            ; rva -> physical address
        add  eax, base                          ;
        mov  edi, eax                           ; edi - rsrc to search for

        mov  esi, [rsrc_start]                  ; esi - ptr to original .rsrc
        dec  esi                                ;
look4:  inc  esi                                ;
        cmp  esi, [rsrc_end]                    ; not found?
        jae  nf                                 ; shouldn't happed

        push edi esi ecx                        ;
        repe cmpsb                              ; compare
        pop  ecx esi edi                        ;
        jnz  look4                              ; don't match

        mov  eax, esi                           ; offset in .rsrc
        sub  eax, [rsrc_start]                  ;
        pop  esi                                ;
        add  eax, [rsrc]                        ; add RVA
        mov  [esi-4], eax                       ; store new address 
nf:     popad

rsrcOK: pop  esi                                ;
        jmp  doentry                            ;

downdir:cmp  byte ptr [level], 0                ; 
        jz   frexit                             ;
        dec  byte ptr [level]                   ;
        pop  ecx                                ;
        pop  esi                                ;
        jmp  doentry                            ;
                                                
frexit: ret                                     ;
fix_rsrc endp                                   
; 
fix_crypte8e9:
        push esi                                ;
; ->>>> no e8e9 encryption in aspack 1.02b 
        mov  esi, signa                         ;
        cmp  word ptr [esi.signature.versiona], 102h
        je   noe8e9                             ;

        mov  ecx, [edi+10h]                     ; physical size
        xor  ebx, ebx                           ;
        mov  esi, edx                           ; edx - section data
fcc:    lodsb                                   ;
        cmp  al, 0E8h                           ; e8? - call near
        je   decr                               ;
        cmp  al, 0E9h                           ; e9? - jmp near
        je   decr                               ;
        inc  ebx                                ;
        dec  ecx                                ;
        jnz  fcc                                ;
noe8e9: jmp  fcx                                ;

decr:   sub  [esi], ebx                         ;
        add  ebx, 5                             ;
        sub  ecx, 5                             ;
        js   fcx                                ;
        add  esi,4                              ;
        jmp  fcc                                ;
fcx:    pop  esi                                ;
        ret                                     ;
; 
fix_tls:
        pushad                                  ;
        cmp  tlsflag, 1                         ; tls was restored?
        je   ftexit                             ; go away

        mov  esi, [peimage]                     ;
        cmp  dword ptr [esi+0C0h], 0            ; no .tls?
        je   ftexit                             ; go away

        mov  eax, [esi+0C4h]                    ; tls size

        cmp  tlsflag, 9                         ; create new tls section?
        jnz  skip1                              ;

        mov  ecx, [esi+38h]                     ; section align
        call _align                             ;
        mov  [edi+08h], eax                     ; new virtual size of tls obj
skip1:
        mov  eax, [esi+0C4h]                    ; tls size
        mov  ecx, [esi+3Ch]                     ; file align
        call _align                             ;
        mov  [edi+10h], eax                     ; new physical size of tls obj
        add  newphys, eax                       ;

        call getmem                             ; alloc memory

        mov  [edi+18h], eax                     ; save address

        push edi                                ;
        push esi                                ;

        mov  edi, eax                           ; for repe movsb
        mov  ecx, tlssize                       ; .tls size
        mov  esi, tlsdata                       ; esi - physical offset
        add  esi, base                          ;
        repe movsb                              ; copy it into allocated memory
                                           
        pop  esi                                ;
        pop  edi                                ;

        cmp  tlsflag, 9                         ; create new tls section?
        jnz  skip0                              ;

        mov  ecx, [esi+3Ch]                     ; file align
        mov  eax, [edi+10h-28h]                 ; previous physical size
        call _align                             ;
        add  eax, [edi+14h-28h]                 ; previous physical ofs
        mov  [edi+14h], eax                     ; next physical ofs

        mov  ecx, [esi+38h]                     ; file align
        mov  eax, [edi+08h-28h]                 ; previous virtual size
        call _align                             ;
        add  eax, [edi+0Ch-28h]                 ; previous rva
        mov  [edi+0Ch], eax                     ; next rva

        mov  [edi+24h], 0C0000040h              ; set tls flags

        push dword ptr [tlsnm]                  ; set tls name
        pop  dword ptr [edi]                    ;
        push dword ptr [tlsnm+4]                ;
        pop  dword ptr [edi+4]                  ;

        mov  esi, peimage                       ;
        inc  word ptr [esi+06h]                 ; number of sections + 1
        inc  numobj                             ;
skip0:
        mov  eax, [edi+0Ch]                     ; section RVA
        mov  esi, [peimage]                     ;
        mov  [esi+0C0h], eax                    ; set new tls RVA

        mov  tlsflag, 1                         ; set tls restored flag
ftexit: popad                                   ;
        ret                                     ;
; [sub]
; ->>>> ; write asciiz string in esi            ;
w0:     lodsb                                   ; load char
        or   al, al                             ; zero = end
        jz   w4                                 ; 
        mov  dl, al                             ;
        mov  ah, 02h                            ; write char, char = DL
        int  21h                                ;
        jmp  w0                                 ; repeat
w4:     ret                                     ;
; ->>>> align eax  
_align  proc                                    ;
        xor  edx, edx                           ;
        div  ecx                                ;
        or   eax, eax                           ;
        jnz  @@1                                ;
        inc  eax                                ;
@@1:    xor  edx, edx                           ;
        mul  ecx                                ;
        ret                                     ;
_align  endp
; ->>>> allocate memory
getmem  proc uses ecx esi edi ebx               ; in: eax
        push eax                                ;
        mov  ecx, eax                           ;
        mov  ebx, ecx                           ; ecx -> bx:cx
        shr  ebx, 10h                           ;
        and  ecx, 0FFFFh                        ; !

        mov  ax, 0501h                          ; DPMI - Allocate Memory Block
        int  31h                                ;
        shl  ebx, 10h                           ;
        or   ecx, ebx                           ; bx:cx -> ecx
        xchg eax, ecx                           ;

        mov  edx, mptr                          ;
        mov  word ptr [mhandles+edx*4], si      ;
        mov  word ptr [mhandles+edx*4]+2, di    ;
        inc  [mptr]                             ;
        pop  ecx                                ;
        push eax                                ;
        mov  edi, eax                           ;
        xor  al,al                              ;
        repe stosb                              ; zero allocated memory     
        pop  eax                                ;
        ret                                     ;
getmem  endp                                    
; ->>>> free memory
freemem proc
        mov  ecx, mptr                          ;
freeit: dec  ecx                                ;
        js   freexit                            ;
        mov  ax, 0502h                          ; DPMI - free mem block
        mov  si, word ptr [mhandles+ecx*4]      ;
        mov  di, word ptr [mhandles+ecx*4]+2    ;
        int  31h                                ;
        jmp  freeit
freexit:
        mov  mptr, 0                            ;
        ret                                     ;
freemem endp
; 
RVAtoPA proc uses ecx ebx esi                   ; in: eax - rva
                                                ; out: eax - physical offset
                                                ;          - 0 - if error
        mov  ebx, eax                           ; RVA into EBX
        mov  esi, [objectbl]                    ; offset of object table
        mov  ecx, [realnum]                     ; real number of object in file
        jmp  short @@4                          ;
@@8:    add  esi, 28h                           ; next object
        dec  ecx                                ; dec Number of objects
        mov  eax, ecx                           ; eax = ecx (0 - error)
        jz   @@3                                ; zero -> eax-0-error
        mov  eax, ebx                           ; restore eax - rva
@@4:    cmp  eax, [esi+0Ch]                     ; RVA 
        jb   @@8                                ; EAX < RVA
        sub  eax, [esi+0Ch]                     ; RVA 
        cmp  eax, [esi+08h]                     ; Virtual size
        jae  @@8                                ; EAX >= RVA+Virtual Size
        add  eax, [esi+14h]                     ; Physical ofs
@@3:    ret                                     ;
RVAtoPA endp      
; 
; -> decompression code, taken from ASPack 1.08.01
; -> must end with RET (C3) not RET 08! (e.g. ASPack 1.08.03 has retn 8)
; 
decompress proc
 db 055h,08bh,0ech,060h,055h,08bh,075h,008h,08bh,07dh,00ch,0fch,0b2h,080h,08ah,006h
 db 046h,088h,007h,047h,002h,0d2h,075h,005h,08ah,016h,046h,012h,0d2h,073h,0efh,002h
 db 0d2h,075h,005h,08ah,016h,046h,012h,0d2h,073h,04ah,033h,0c0h,002h,0d2h,075h,005h
 db 08ah,016h,046h,012h,0d2h,00fh,083h,0d6h,000h,000h,000h,002h,0d2h,075h,005h,08ah
 db 016h,046h,012h,0d2h,013h,0c0h,002h,0d2h,075h,005h,08ah,016h,046h,012h,0d2h,013h
 db 0c0h,002h,0d2h,075h,005h,08ah,016h,046h,012h,0d2h,013h,0c0h,002h,0d2h,075h,005h
 db 08ah,016h,046h,012h,0d2h,013h,0c0h,074h,006h,057h,02bh,0f8h,08ah,007h,05fh,088h
 db 007h,047h,0ebh,0a0h,0b8h,001h,000h,000h,000h,002h,0d2h,075h,005h,08ah,016h,046h
 db 012h,0d2h,013h,0c0h,002h,0d2h,075h,005h,08ah,016h,046h,012h,0d2h,072h,0eah,083h
 db 0e8h,002h,075h,028h,0b9h,001h,000h,000h,000h,002h,0d2h,075h,005h,08ah,016h,046h
 db 012h,0d2h,013h,0c9h,002h,0d2h,075h,005h,08ah,016h,046h,012h,0d2h,072h,0eah,056h
 db 08bh,0f7h,02bh,0f5h,0f3h,0a4h,05eh,0e9h,058h,0ffh,0ffh,0ffh,048h,0c1h,0e0h,008h
 db 08ah,006h,046h,08bh,0e8h,0b9h,001h,000h,000h,000h,002h,0d2h,075h,005h,08ah,016h
 db 046h,012h,0d2h,013h,0c9h,002h,0d2h,075h,005h,08ah,016h,046h,012h,0d2h,072h,0eah
 db 03dh,000h,07dh,000h,000h,073h,01ah,03dh,000h,005h,000h,000h,072h,00eh,041h,056h
 db 08bh,0f7h,02bh,0f0h,0f3h,0a4h,05eh,0e9h,018h,0ffh,0ffh,0ffh,083h,0f8h,07fh,077h
 db 003h,083h,0c1h,002h,056h,08bh,0f7h,02bh,0f0h,0f3h,0a4h,05eh,0e9h,003h,0ffh,0ffh
 db 0ffh,08ah,006h,046h,033h,0c9h,0c0h,0e8h,001h,074h,012h,083h,0d1h,002h,08bh,0e8h
 db 056h,08bh,0f7h,02bh,0f0h,0f3h,0a4h,05eh,0e9h,0e7h,0feh,0ffh,0ffh,05dh,02bh,07dh
 db 00ch,089h,07dh,0fch,061h,05dh,0c3h
decompress endp

End Start

                        