/************************************************************
MODULO: Read.c
	In questo modulo sono contenute le funzioni per la lettura
	di un pacchetto, le routine per il completamento asincrono
	e le funzioni di allocazioni di memoria per tenere un 
	pacchetto.
************************************************************/
#include <basedef.h>
#include <vmm.h>
#include <vwin32.h>
#include <winerror.h>
#include <ndis.h>
#include "debug.h"
#include "packet.h"
#include "..\Inc\ntddpack.h"
#pragma VxD_LOCKED_CODE_SEG
#pragma VxD_LOCKED_DATA_SEG
DWORD _stdcall MyPageLock(DWORD, DWORD);
void  _stdcall MyPageUnlock(DWORD, DWORD);

/************************************************************
Alloca spazio per un pacchetto in ricezione o trasmissione, 
estraendolo dal buffer riservato per il driver.
************************************************************/
VOID
PacketAllocatePacketBuffer(	PNDIS_STATUS	pStatus,
							POPEN_INSTANCE	pOpen,
							PNDIS_PACKET	*lplpPacket,
							PDIOCPARAMETERS	pDiocParms,
							DWORD			FunctionCode )
{
	PNDIS_BUFFER		pNdisBuffer;
	PPACKET_RESERVED	pReserved;
	TRACE_ENTER( "PacketAllocatePacket" );
	NdisAllocatePacket( pStatus, lplpPacket, pOpen->PacketPool );
	if ( *pStatus != NDIS_STATUS_SUCCESS ) 
	{
		IF_VERY_LOUD( "Read- No free packets" );
		*(DWORD *)(pDiocParms->lpcbBytesReturned) = 0;
		return;
	}
	InitializeListHead( &(RESERVED(*lplpPacket)->ListElement) );
	pReserved = RESERVED(*lplpPacket);
	/*Occorre conoscere il tipo di funzione da eseguire al
	fine di vedere quale dei due buffer (quello in ric. o
	quello in tras.) deve essere bloccato*/
	switch ( FunctionCode )
	{
	case IOCTL_PROTOCOL_READ:
		pReserved->lpBuffer = (PVOID)PacketPageLock( (PVOID)pDiocParms->lpvOutBuffer, 
									 				 pDiocParms->cbOutBuffer );
		pReserved->cbBuffer = pDiocParms->cbOutBuffer;
		break;
	case IOCTL_PROTOCOL_WRITE:
		pReserved->lpBuffer = (PVOID)PacketPageLock( pDiocParms->lpvInBuffer, 
									 				 pDiocParms->cbInBuffer );
		pReserved->cbBuffer = pDiocParms->cbInBuffer;
		break;
	default:
		/*Funzione non valida, dunque restituisco le risorse*/
		IF_TRACE_MSG( "Allocate- Invalid FunctionCode %x", FunctionCode );
		NdisReinitializePacket( *lplpPacket );
		NdisFreePacket( *lplpPacket );
		*(DWORD *)(pDiocParms->lpcbBytesReturned) = 0;
		*pStatus = NDIS_STATUS_NOT_ACCEPTED;
		return;
	}
	/*Blocca in memoria anche le strutture di supporto*/
	pReserved->lpcbBytesReturned	= 
			(PVOID)PacketPageLock( (PVOID)pDiocParms->lpcbBytesReturned, sizeof(DWORD) );
	pReserved->lpoOverlapped		= 
	
			(PVOID)PacketPageLock( (PVOID)pDiocParms->lpoOverlapped, sizeof(OVERLAPPED) );
	pReserved->hDevice 				= pDiocParms->hDevice;
	pReserved->tagProcess			= pDiocParms->tagProcess;
	
	NdisAllocateBuffer(	pStatus, 
						&pNdisBuffer, 
						pOpen->BufferPool, 
						(PVOID)pReserved->lpBuffer,
						pDiocParms->cbOutBuffer );
	if ( *pStatus != NDIS_STATUS_SUCCESS )
	{
		IF_TRACE( "Read- No free buffers" );
		NdisReinitializePacket(*lplpPacket);
		NdisFreePacket(*lplpPacket);
		*(DWORD *)(pDiocParms->lpcbBytesReturned) = 0;
		return;
	}
	NdisChainBufferAtFront( *lplpPacket, pNdisBuffer );
	IF_PACKETDEBUG( PACKET_DEBUG_VERY_LOUD ) 
	{
		IF_TRACE_MSG( " lplpPacket : %lx", lplpPacket );		
		IF_TRACE_MSG( "   lpPacket : %lx", *lplpPacket );		
		IF_TRACE_MSG3( "pNdisBuffer : %lx  %lx  %lx", pNdisBuffer, (*lplpPacket)->Private.Head, (*lplpPacket)->Private.Tail );
		IF_TRACE_MSG( "   Reserved : %lx", pReserved );		
		IF_TRACE_MSG4( "   lpBuffer : %lx  %lx  %lx  %lx", pReserved->lpBuffer, pNdisBuffer->VirtualAddress, pDiocParms->lpvOutBuffer, pDiocParms->lpvInBuffer );
		IF_TRACE_MSG3( "   cbBuffer : %lx  %lx  %lx", pReserved->cbBuffer, pDiocParms->cbOutBuffer, pDiocParms->cbInBuffer );
		IF_TRACE_MSG2( " lpcbBytes  : %lx  %lx", pReserved->lpcbBytesReturned, pDiocParms->lpcbBytesReturned );
		IF_TRACE_MSG2( " lpoOverlap : %lx  %lx", pReserved->lpoOverlapped, pDiocParms->lpoOverlapped );
		IF_TRACE_MSG2( "    hDevice : %lx  %lx", pReserved->hDevice, pDiocParms->hDevice );
		IF_TRACE_MSG2( " tagProcess : %lx  %lx", pReserved->tagProcess, pDiocParms->tagProcess );
	}
	PACKETASSERT( pReserved->lpBuffer );
	PACKETASSERT( pReserved->cbBuffer );
	PACKETASSERT( pReserved->lpcbBytesReturned );
	PACKETASSERT( pReserved->lpoOverlapped );
	PACKETASSERT( pReserved->hDevice == pDiocParms->hDevice );
	PACKETASSERT( pReserved->tagProcess == pDiocParms->tagProcess );
	PACKETASSERT( pNdisBuffer == (*lplpPacket)->Private.Head );
	PACKETASSERT( pNdisBuffer->VirtualAddress == pReserved->lpBuffer );
	TRACE_LEAVE( "PacketAllocatePacket" );
	return;
}

/************************************************************
Avvia la lettura di un pacchetto poi completata asincronamente
quando il livello MAC comunica l'arrivo di un pacchetto.
I parametri ricevuti da questa sono quelli passati dalla 
PacketDeviceIOControl.
************************************************************/
DWORD
PacketRead( POPEN_INSTANCE	Open,
			DWORD  			dwDDB,
            DWORD  			hDevice,
		  	PDIOCPARAMETERS pDiocParms
	)
{
	NDIS_STATUS		Status;
	PNDIS_PACKET	pPacket;
	TRACE_ENTER( "PacketRead" );
	if ( pDiocParms->cbOutBuffer < ETHERNET_HEADER_LENGTH ) 
	{
		/*Comunica l'impossibilit a leggere se il buffer  
		troppo piccolo*/
		*(DWORD *)(pDiocParms->lpcbBytesReturned) = 0;
		IF_VERY_LOUD( "Read- Buffer too small" );
		TRACE_LEAVE( "ReadPacket" );
		return NDIS_STATUS_SUCCESS;
	}
	PacketAllocatePacketBuffer( &Status, Open, &pPacket, pDiocParms, IOCTL_PROTOCOL_READ );
	if ( Status == NDIS_STATUS_SUCCESS )
	{
		/*Una volta che il  stata riservata la memoria per il
		pacchetto allora questo viene messo nella lista di 
		quelli che potranno essere riempiti quando il livello
		MAC ne riceve uno.*/
		PACKETASSERT( Open != NULL );
		PACKETASSERT( pPacket != NULL );
		NdisAcquireSpinLock( &Open->RcvQSpinLock );
		InsertTailList( &Open->RcvList, &RESERVED(pPacket)->ListElement );
		NdisReleaseSpinLock( &Open->RcvQSpinLock );
		IF_TRACE_MSG2( "RcvList Link : %lx  %lx", Open->RcvList.Blink, &RESERVED(pPacket)->ListElement );
		PACKETASSERT( Open->RcvList.Blink == &RESERVED(pPacket)->ListElement );
		PACKETASSERT( &(Open->RcvList) == RESERVED(pPacket)->ListElement.Flink );
	}
	TRACE_LEAVE( "PacketRead" );
	return(-1);	/*Comunica che l'operazione  asincrona*/	
}

/************************************************************
Questa  la routine di callback richiamata dall'NDIS quando 
il livello MAC riceve un pacchetto.
************************************************************/
NDIS_STATUS NDIS_API
PacketReceiveIndicate (	IN NDIS_HANDLE ProtocolBindingContext,
						IN NDIS_HANDLE MacReceiveContext,
						IN PVOID       pvHeaderBuffer,
						IN UINT        uiHeaderBufferSize,
						IN PVOID       pvLookAheadBuffer,
						IN UINT        uiLookaheadBufferSize,
						IN UINT        uiPacketSize
	)
#define pOpen	((POPEN_INSTANCE)ProtocolBindingContext)
{
	PLIST_ENTRY			PacketListEntry;
	PNDIS_PACKET   		pPacket;
	ULONG          		ulSizeToTransfer;
	NDIS_STATUS    		Status;
	UINT           		uiBytesTransferred;
	PPACKET_RESERVED	pReserved;
	PNDIS_BUFFER		pNdisBuffer;
	PVOID				pvActualVirtualAddress;
	UINT				uiActualLength;
	
	PACKETASSERT( (pOpen != NULL) );
	/*Se ci sono richieste pendenti di lettura allora estraggo
	un buffer dalla lista di ricezione per poi riempirlo.*/
	NdisAcquireSpinLock( &pOpen->RcvQSpinLock );
	PacketListEntry = PacketRemoveHeadList( &pOpen->RcvList );
	NdisReleaseSpinLock( &pOpen->RcvQSpinLock );
	if ( PacketListEntry == NULL )
	{
		/*Se la lista  vuota non passo alcun pacchetto
		dunque perdo quello che  arrivato*/
		return NDIS_STATUS_SUCCESS;
	}
	TRACE_ENTER( "IndicateReceive" );
	pReserved = CONTAINING_RECORD( PacketListEntry, PACKET_RESERVED, ListElement );
	pPacket   = CONTAINING_RECORD( pReserved, NDIS_PACKET, ProtocolReserved );
	IF_PACKETDEBUG( PACKET_DEBUG_VERY_LOUD ) 
	{
		IF_TRACE_MSG( "   Reserved : %lx", pReserved );
		IF_TRACE_MSG( "    pPacket : %lx", pPacket );
		IF_TRACE_MSG2( "     Header : %lx  %lx", pvHeaderBuffer, uiHeaderBufferSize );
		IF_TRACE_MSG2( "  LookAhead : %lx  %lx", pvLookAheadBuffer, uiLookaheadBufferSize );
		IF_TRACE_MSG( " PacketSize : %lx", uiPacketSize );
	}
	PACKETASSERT( (pReserved != NULL) );
	PACKETASSERT( (pPacket != NULL) );
	uiBytesTransferred = 0;
	/*Puntatore al buffer estratto dalla coda*/
	pNdisBuffer = pPacket->Private.Head;
	/*Indirizzo virtuale del buffer che ospiter il pacchetto*/
	pvActualVirtualAddress	= pNdisBuffer->VirtualAddress;
	uiActualLength			= pNdisBuffer->Length;
	
	/*Se l'header del pacchetto ha una lunghezza valida*/
	if ( uiHeaderBufferSize > 0 ) 
	{
		/*Controllo se i dati possono essere memorizzati*/
		if ( uiHeaderBufferSize > pNdisBuffer->Length )
			uiHeaderBufferSize = pNdisBuffer->Length;
		/*Comincio a copiare l'header direttamente nel buffer
		utente*/
		NdisMoveMemory( pNdisBuffer->VirtualAddress, pvHeaderBuffer, uiHeaderBufferSize );		
		uiBytesTransferred += uiHeaderBufferSize;
		(BYTE *)(pNdisBuffer->VirtualAddress) += uiHeaderBufferSize;
		pNdisBuffer->Length -= uiHeaderBufferSize;
	}
	/*Se i dati hanno lunghezza valida li trasferisco.*/	
	if ( uiLookaheadBufferSize > 0 )
	{
		if ( uiLookaheadBufferSize > pNdisBuffer->Length )
			uiLookaheadBufferSize = pNdisBuffer->Length;
	
		NdisMoveMemory( pNdisBuffer->VirtualAddress, pvLookAheadBuffer, uiLookaheadBufferSize );
		uiBytesTransferred += uiLookaheadBufferSize;
		(BYTE *)(pNdisBuffer->VirtualAddress) += uiLookaheadBufferSize;
		pNdisBuffer->Length -= uiLookaheadBufferSize;
	}
	
	/*Indico che il pacchetto  lungo tanto quanto l'NDIS ha 
	comunicato invocando questa routine.*/
	*(pReserved->lpcbBytesReturned) = uiBytesTransferred;
	/*Se il pacchetto  pi lungo di quanto memorizzato*/
	if ( uiLookaheadBufferSize < uiPacketSize )
	{
		if ( uiPacketSize >= 1500 )
		{
			_asm { int 3 }
		}
		ulSizeToTransfer = uiPacketSize - uiLookaheadBufferSize;
		if ( ulSizeToTransfer > pNdisBuffer->Length )
				ulSizeToTransfer = pNdisBuffer->Length;
		/*Chiede all'NDIS di trasferire il resto*/
		NdisTransferData(	&Status,					
							pOpen->AdapterHandle,		
							MacReceiveContext,			
							uiLookaheadBufferSize,		
							ulSizeToTransfer,			
							pPacket,					
							&uiBytesTransferred );		
		pNdisBuffer->VirtualAddress = pvActualVirtualAddress;
		pNdisBuffer->Length			= uiActualLength;
		if ( Status != NDIS_STATUS_PENDING ) 
		{
			/*Completa sincronamente un trasf. gi finito*/
			PacketTransferDataComplete(	pOpen,				
										pPacket,			
										Status,				
										uiBytesTransferred );
		}
	}
	else
	{
		/*Se il pacchetto sta tutto nel buffer predisposto
		allora viene solo terminato il trasferimento*/
		Status = NDIS_STATUS_SUCCESS;
		pNdisBuffer->VirtualAddress = pvActualVirtualAddress;
		pNdisBuffer->Length			= uiActualLength;
		PacketTransferDataComplete(	pOpen,			
									pPacket,		
									Status,			
									0 );			
	}
	TRACE_LEAVE( "IndicateReceive" );
	return NDIS_STATUS_SUCCESS;
}

/*Termina il trasferimento iniziato con la PacketReceiveIndicate*/
VOID NDIS_API
PacketTransferDataComplete (	IN NDIS_HANDLE   ProtocolBindingContext,
								IN PNDIS_PACKET  pPacket,
								IN NDIS_STATUS   Status,
								IN UINT          uiBytesTransferred
   )
{
	PPACKET_RESERVED	pReserved;
	OVERLAPPED*			pOverlap;
	PNDIS_BUFFER		pNdisBuffer;
	TRACE_ENTER( "TransferDataComplete" );
	pReserved = (PPACKET_RESERVED) pPacket->ProtocolReserved;
	pOverlap  = (OVERLAPPED *) pReserved->lpoOverlapped;
	PACKETASSERT( (pOpen != NULL) );
	PACKETASSERT( (pReserved != NULL) );
	PACKETASSERT( (pOverlap != NULL) );
	
	IF_PACKETDEBUG( PACKET_DEBUG_VERY_LOUD ) 
	{
		IF_TRACE_MSG( "     Status : %lx", Status );
		IF_TRACE_MSG( "BytesXfered : %lx", uiBytesTransferred );
		IF_TRACE_MSG( "Byte Offset : %lx", *(pReserved->lpcbBytesReturned) );
	}
	
	NdisUnchainBufferAtFront( pPacket, &pNdisBuffer );
	PACKETASSERT( (pNdisBuffer != NULL) );
	if ( pNdisBuffer )
		NdisFreeBuffer( pNdisBuffer );
	
	*(pReserved->lpcbBytesReturned) += uiBytesTransferred;
	pOverlap->O_InternalHigh         = *(pReserved->lpcbBytesReturned);
	/*Segnala il semaforo per sbloccare i processi in attesa
	dell'avento trsferimento.*/
	VWIN32_DIOCCompletionRoutine( pOverlap->O_Internal );
	
	PacketPageUnlock( pReserved->lpBuffer, pReserved->cbBuffer );
	PacketPageUnlock( pReserved->lpcbBytesReturned, sizeof(DWORD) );
	PacketPageUnlock( pReserved->lpoOverlapped, sizeof(OVERLAPPED) );
	
	NdisReinitializePacket( pPacket );
	
	NdisFreePacket( pPacket );
	TRACE_LEAVE( "TransferDataComplete" );
	return;
}

/*Termine della operazione di Receive, questa  segnalata
dall'NDIS.*/
VOID NDIS_API
PacketReceiveComplete( IN NDIS_HANDLE  ProtocolBindingContext )
{
	IF_PACKETDEBUG( PACKET_DEBUG_VERY_LOUD ) 
	{
		TRACE_ENTER( "ReceiveComplete" );
		TRACE_LEAVE( "ReceiveComplete" );
	}
	return;
}
