/************************************************************
MODULO: Packet.c
	In questo modulo viene inizializzato il driver. Sono 
	inoltre contenute le funzioni di manutenzione delle 
	varie istanze e la routine di dispatch dei messaggi 
	provenienti dalla DeviceIOControl.
************************************************************/
#include <basedef.h>
#include <vmm.h>
#include <ndis.h>
#include <vwin32.h>
#include "debug.h"
#include "packet.h"
#include "..\inc\ntddpack.h"
#pragma VxD_LOCKED_CODE_SEG
#pragma VxD_LOCKED_DATA_SEG

/*Definizione della testa della lista delle istanze aperte*/

PDEVICE_EXTENSION GlobalDeviceExtension = 0;

/************************************************************
Funzione che valuta la lunghezza di una stringa, utile per 
evitare le funzioni di libreria che a questo livello non sono
definite.
************************************************************/
ULONG
strlen( BYTE *s )
{
	ULONG len = 0;
	while ( *s++ ) len++;
	return len;
}

/************************************************************
Punto di ingresso del driver richiamato in seguito al 
messaggio di caricamento dinamico del driver spedito da WIN95
INPUT:	DriverObject - Puntatore all'oggetto driver creato 
			dal sistema.
		RegistryPath - Puntatore al percorso del driver nel 
			file di registro.
OUTPUT: Ci che ritorna questa funzione  lo stato della 
		inizializzazione
************************************************************/
NTSTATUS
DriverEntry( IN PDRIVER_OBJECT	DriverObject,
				 IN PUNICODE_STRING	RegistryPath
	)
{
	NDIS_PROTOCOL_CHARACTERISTICS	ProtocolChar;
	NDIS_STRING	ProtoName = NDIS_STRING_CONST("VPACKET");
   	NDIS_HANDLE NdisProtocolHandle;
	NDIS_STATUS	Status;
	INIT_ENTER( "DriverEntry" );

	NdisAllocateMemory( (PVOID *)&GlobalDeviceExtension, sizeof( DEVICE_EXTENSION ), 0, -1 );
	if ( GlobalDeviceExtension != NULL )
	{
		/*Lista delle funzioni da registrare presso NDIS */
		NdisZeroMemory( (UCHAR*)GlobalDeviceExtension, sizeof(DEVICE_EXTENSION) );
		NdisZeroMemory( (UCHAR*)&ProtocolChar, sizeof(NDIS_PROTOCOL_CHARACTERISTICS) );
   		ProtocolChar.MajorNdisVersion            = 0x03;
		ProtocolChar.MinorNdisVersion            = 0x0A;
   		ProtocolChar.Reserved                    = 0;
		ProtocolChar.OpenAdapterCompleteHandler  = PacketBindAdapterComplete;
   		ProtocolChar.CloseAdapterCompleteHandler = PacketUnbindAdapterComplete;
		ProtocolChar.SendCompleteHandler         = PacketSendComplete;
   		ProtocolChar.TransferDataCompleteHandler = PacketTransferDataComplete;
		ProtocolChar.ResetCompleteHandler        = PacketResetComplete;
   		ProtocolChar.RequestCompleteHandler      = PacketRequestComplete;
		ProtocolChar.ReceiveHandler              = PacketReceiveIndicate;
   		ProtocolChar.ReceiveCompleteHandler      = PacketReceiveComplete;
		ProtocolChar.StatusHandler               = PacketStatus;
   		ProtocolChar.StatusCompleteHandler       = PacketStatusComplete;
   		ProtocolChar.BindAdapterHandler			 = PacketBindAdapter;
   		ProtocolChar.UnbindAdapterHandler        = PacketUnbindAdapter;
   		ProtocolChar.UnloadProtocolHandler       = PacketUnload;
		ProtocolChar.Name                        = ProtoName;
		NdisRegisterProtocol( &Status,
									 &GlobalDeviceExtension->NdisProtocolHandle,
									 &ProtocolChar,
									 sizeof(NDIS_PROTOCOL_CHARACTERISTICS) );
		if (Status != NDIS_STATUS_SUCCESS) 
   		{
			NdisFreeMemory( GlobalDeviceExtension, sizeof( DEVICE_EXTENSION ) ,  0 );
	   		IF_TRACE( "Failed to register protocol with NDIS" );
			INIT_LEAVE( "DriverEntry" );
			return Status;
   		}
		/*Inizializza la lista delle istanze aperte*/
		InitializeListHead( &GlobalDeviceExtension->OpenList );
		GlobalDeviceExtension->DriverObject = DriverObject;
  	
  		IF_TRACE( "protocol registered with NDIS!!! :-)" );
		INIT_LEAVE( "DriverEntry" );
		return Status;
	}
	IF_TRACE( "Memory Failure" );
	INIT_LEAVE( "DriverEntry" );
	return NDIS_STATUS_RESOURCES;
}

/************************************************************
Callback richiamat da NDIS quando occorre deregistrare il 
driver di protocollo.
INPUT:
OUTPUT:
************************************************************/
VOID NDIS_API PacketUnload()
{
	NDIS_STATUS		Status;
	TRACE_ENTER( "Unload" );
	if ( GlobalDeviceExtension )
	{
		NdisDeregisterProtocol( &Status, GlobalDeviceExtension->NdisProtocolHandle );
		if ( Status == NDIS_STATUS_SUCCESS )
		{
			NdisFreeMemory( GlobalDeviceExtension, sizeof( DEVICE_EXTENSION ) ,  0 );
			GlobalDeviceExtension = 0;
		}
	}
	TRACE_LEAVE( "Unload" );
	return;
}

/************************************************************
Ritorna il descrittore del primo adattatore nella lista di 
quelli cui  stato fatto il bind.
INPUT:
OUTPUT:	Prima istanza del driver aperta.
************************************************************/
POPEN_INSTANCE GetFirstAdapter( VOID )
{
	PLIST_ENTRY		pEntry = GlobalDeviceExtension->OpenList.Flink;
	POPEN_INSTANCE	pOpen  = CONTAINING_RECORD( pEntry, OPEN_INSTANCE, ListElement );
	return pOpen;
}

/************************************************************
Ritorna il descrittore dell'adattatore il cui nome e` 
specificato dalla stringa in input.
INPUT: Nome dell'adattatore da aprire, fornito da lpzAdapterName
OUTPUT:	Istanza del driver aperta.
************************************************************/
POPEN_INSTANCE GetAdapterByName(BYTE *lpzAdapterName )
{
	DWORD                           dwBytes = 0;
      BYTE                            *lpzName;
      POPEN_INSTANCE                  pOpen;
	PWRAPPER_MAC_BLOCK	        pWMBlock;
	PNDIS_MAC_CHARACTERISTICS	  pNMChar;


      
	PLIST_ENTRY pHead = &(GlobalDeviceExtension->OpenList);
	PLIST_ENTRY pEntry;

	TRACE_ENTER( "GetAdapterByName" );
	IF_TRACE_MSG( " Passato %s", lpzAdapterName );	
	pOpen = 0;
	
	pEntry=pHead->Flink; 
	do {    
	pOpen = CONTAINING_RECORD( pEntry, OPEN_INSTANCE, ListElement );
 	pWMBlock = ((PWRAPPER_OPEN_BLOCK)(pOpen->AdapterHandle))->MacHandle;
	pNMChar  = &pWMBlock->MacCharacteristics;
	lpzName  = pNMChar->Name.Buffer;
	pEntry=pEntry->Flink;
	}while ((pEntry != pHead) && !(confronta(lpzName,lpzAdapterName))); 
 	  
	IF_TRACE_MSG( " Attuale %s", lpzName ); 
	if(!(confronta(lpzName,lpzAdapterName))) pOpen=NULL;
	
	TRACE_LEAVE( "GetAdapterByName" );
	
	return pOpen;
}

/************************************************************
Funzione che confronta due stringhe 
 
************************************************************/
BYTE confronta(BYTE *s1,BYTE *s2)
{
	TRACE_ENTER( "Confronta!" );	
	IF_TRACE_MSG2( " Attuale:  %s  Passato %s", s1, s2 );

	while (*s1 && *s2)
	{
		if (*s1!=*s2)  return (BYTE) 0;
					
		s1++;
		s2++;
			
	}

	if ((*s1==0) && (*s2==0)) return (BYTE) 1;	
	else return (BYTE) 0;
} 


/************************************************************
Ritorna i nomi di tutti i driver MAC su cui il driver  
attaccato.
INPUT:	dwDDB e hDevice - sono parametri provenienti dalla
			DeviceIOControl, qui non usati.
OUTPUT:	pDiocParms - struttura nel quale  contenuto il buffer 
			di ritorno.
************************************************************/
DWORD
PacketGetMacNameList( DWORD  				dwDDB,
                      DWORD  				hDevice,
                      PDIOCPARAMETERS	pDiocParms ) 
{
        DWORD                                   dwBytes = 0;
        BYTE                                    *lpzName;
        ULONG                                   uLength;
        POPEN_INSTANCE                           pOpen;
	PWRAPPER_MAC_BLOCK			pWMBlock;
	PNDIS_MAC_CHARACTERISTICS	pNMChar;

	
	PLIST_ENTRY	pHead = &(GlobalDeviceExtension->OpenList);
	PLIST_ENTRY pEntry;
	TRACE_ENTER( "GetMacNameList" );
	for ( pEntry=pHead->Flink; pEntry != pHead; pEntry=pEntry->Flink )
	{
		pOpen = CONTAINING_RECORD( pEntry, OPEN_INSTANCE, ListElement );
		pWMBlock = ((PWRAPPER_OPEN_BLOCK)(pOpen->AdapterHandle))->MacHandle;
		pNMChar  = &pWMBlock->MacCharacteristics;
		lpzName  = pNMChar->Name.Buffer;
		uLength  = strlen( lpzName );
	
		IF_TRACE_MSG2( "     %s  %lu",  lpzName, uLength );
	
		if ( uLength < pDiocParms->cbOutBuffer - dwBytes - 1 )
		{
			strcat( (BYTE*)(pDiocParms->lpvOutBuffer), lpzName );
			strcat( (BYTE*)(pDiocParms->lpvOutBuffer), " " );
			dwBytes += (uLength + 1);
		}
		else
			break;
	}
	*(ULONG*)(pDiocParms->lpcbBytesReturned) = dwBytes;
	IF_TRACE_MSG( "     Bytes Returned: %lu", *(ULONG*)(pDiocParms->lpcbBytesReturned) );
	TRACE_LEAVE( "GetMacNameList" );
	return NDIS_STATUS_SUCCESS;
}


/************************************************************
Routine di dispatch dei messaggi inviati mediante la 
DeviceIOCOntrol.
INPUT:	dwDDB e hDevice - parametri inviati dalla DeviceIOControl
		dwService - Servizio richiesto al driver dal chiamante.
		pDiocParms - Struttura che ingloba tutti i par. passati
			alle varie routine di gestione.
OUTPUT:	pDiocParms
		La funzione ritorna inoltre, un risultato che indica 
		l'esito dell'operazione.
************************************************************/
 
DWORD _stdcall PacketIOControl( DWORD  			dwService,
                                DWORD  			dwDDB,
                                DWORD  			hDevice,
                                PDIOCPARAMETERS pDiocParms ) 
{
	
	NDIS_STATUS     	Status;
	TRACE_ENTER( "DeviceIoControl" );
	//BUGBUG
	 
	switch ( dwService )
	{
	case IOCTL_OPEN:
		/*Messaggio di apertura del canale di comunicazione*/
		Open = GetAdapterByName((BYTE*) pDiocParms->lpvInBuffer);
		
		IF_TRACE_MSG3( "    Function code is %08lx  buff size=%08lx  %08lx",
						dwService,
						pDiocParms->cbInBuffer,
						pDiocParms->cbOutBuffer );
		
		if (Open==NULL) ((BYTE*) pDiocParms->lpvInBuffer)[0]='\0';
		/*Open = GetFirstAdapter();*/
		 
		break;
	case DIOC_CLOSEHANDLE:
		/*Messaggio di chiusura del canale;
			in seguito a questo vengono chiuse le istanze
			aperte.*/
		Status = NDIS_STATUS_SUCCESS;
		PacketCleanUp( &Status, GetFirstAdapter() );
		break;
	case IOCTL_PROTOCOL_RESET:
		PacketReset( &Status, Open );
		break;
	case IOCTL_PROTOCOL_SET_OID:
	case IOCTL_PROTOCOL_QUERY_OID:
	case IOCTL_PROTOCOL_STATISTICS:
		return PacketRequest( Open, dwService, dwDDB, hDevice, pDiocParms );
	case IOCTL_PROTOCOL_READ:
		return PacketRead( Open, dwDDB, hDevice, pDiocParms );
	case IOCTL_PROTOCOL_WRITE:
		return PacketWrite( Open, dwDDB, hDevice, pDiocParms );
	case IOCTL_PROTOCOL_MACNAME:
		PacketGetMacNameList( dwDDB, hDevice, pDiocParms );
		break;
      
	default: 
		/*Funzione richiesta non conosciuta.*/
		*(DWORD *)(pDiocParms->lpcbBytesReturned) = 0;
		break;
	}
   TRACE_LEAVE( "DeviceIoControl" );
   
   return NDIS_STATUS_SUCCESS;
}



/************************************************************
Richiamata dall'NDIS quando c' qualcosa da notificare a 
livello superiore da parte dei driver MAC.
************************************************************/
VOID
PacketStatus(
    IN NDIS_HANDLE   ProtocolBindingContext,
    IN NDIS_STATUS   Status,
    IN PVOID         StatusBuffer,
    IN UINT          StatusBufferSize
    )
{
   TRACE_ENTER( "Status Indication" );
   TRACE_LEAVE( "Status Indication" );
   return;
}

/************************************************************
Richiamata dall'NDIS quando c' qualcosa da notificare a 
livello superiore e completa la chiamata precedente,
************************************************************/
VOID NDIS_API
PacketStatusComplete(
    IN NDIS_HANDLE  ProtocolBindingContext
    )
{
   TRACE_ENTER( "StatusIndicationComplete" );
   TRACE_LEAVE( "StatusIndicationComplete" );
   return;
}

/************************************************************
Funzione di wrapper alla RemoveHeadList il quale prima di 
rimuovere un lemento dalla lista controlla se la lista 
vuota.
************************************************************/
PLIST_ENTRY
PacketRemoveHeadList(
    IN PLIST_ENTRY pListHead
    )
{
	if ( !IsListEmpty( pListHead ) )
	{
		PLIST_ENTRY pLE = RemoveHeadList( pListHead );
		return pLE;
	}
	return NULL;
}
