
#ifndef __PACKET32
#define __PACKET32
#define        DOSNAMEPREFIX   TEXT("VPACKET")
#define        MAX_LINK_NAME_LENGTH   64
struct _ADAPTER {
    HANDLE hFile;
    TCHAR SymbolicLink[MAX_LINK_NAME_LENGTH];
};

struct _PACKET 
{
    HANDLE       hEvent;
    OVERLAPPED   OverLapped;
    PVOID        Buffer;
    UINT         Length;
	ULONG		 ulBytesReceived;
	BOOLEAN		 bIoComplete;
}; 
 

 
typedef struct _PACKET PACKET, *LPPACKET;
typedef struct _ADAPTER ADAPTER,*LPADAPTER;

#ifdef __cplusplus
extern "C" {
#endif

LPADAPTER PacketOpenAdapter(LPTSTR AdapterName);

BOOLEAN PacketSendPacket(LPADAPTER AdapterObject,
		    LPPACKET lpPacket,
		    BOOLEAN Sync);

LPPACKET PacketAllocatePacket(void);

VOID PacketInitPacket(LPPACKET lpPacket,
		    PVOID Buffer,
		    UINT Length);

VOID PacketFreePacket(LPPACKET lpPacket);

BOOLEAN PacketResetAdapter(LPADAPTER AdapterObject);

BOOLEAN PacketWaitPacket(LPADAPTER AdapterObject,
		    LPPACKET lpPacket);

BOOLEAN PacketReceivePacket(LPADAPTER AdapterObject,
		       LPPACKET lpPacket,
		       BOOLEAN Sync);

VOID PacketCloseAdapter(LPADAPTER lpAdapter);

BOOLEAN PacketSetFilter(LPADAPTER AdapterObject,
		   ULONG Filter);

ULONG PacketGetAdapterNames(PTSTR pStr,
			 PULONG BufferSize);

BOOLEAN PacketRequest (LPADAPTER AdapterObject,
		    BOOLEAN Set,
		    PPACKET_OID_DATA OidData);

#ifdef __cplusplus
}
#endif

#endif
