#include "../common/pangui.h"
/* packet library from Peter Viano */
#include "../packet32/include/packet32.h"

/* the two variables below are declared localy, because they are */
/* used to call specific driver functions, and due to code optimization */
/* they need to be in the imediate memory space of this code */
LPADAPTER Pan_Adapter;
LPPACKET  Pan_Packet;

int GUI_Pan_NCP_connect(int ServerNumber)
{
 FILE *fPan_send;
 FILE *fPan_recv;
 int ncp_function=ServerNumber;
 int size_send=0;
 int size_recv=0;
 int repeat_time=1;
 char send_file[MAXPATHLEN+MAXFNAMELEN];
 char recv_file[MAXPATHLEN+MAXFNAMELEN];
 int err;
 uint32 r;

 strcpy(send_file,start_path);
 strcat(send_file,"send.pan");
 strcpy(recv_file,start_path);
 r=rand();
 sprintf(recv_file+strlen(recv_file),"%08lx",r);
 strcat(recv_file,".rcv");

 fPan_send=fopen(send_file,"wb");
 while(!fPan_send) fPan_send=fopen(send_file,"wb");

 /*write packet to send*/
 fwrite(&ncp_function,sizeof(ncp_function),1,fPan_send);
 fwrite(&size_send,sizeof(size_send),1,fPan_send);
 fwrite(&size_recv,sizeof(size_recv),1,fPan_send);
 fwrite(&repeat_time,sizeof(repeat_time),1,fPan_send);
 fwrite(recv_file,sizeof(char),MAXPATHLEN+MAXFNAMELEN,fPan_send);
 fclose(fPan_send);

 /* read result */
 fPan_recv=fopen(recv_file,"rb");
 while(!fPan_recv) fPan_recv=fopen(recv_file,"rb");
 
 fread(&err,sizeof(err),1,fPan_recv);
 fclose(fPan_recv);
 remove(recv_file);

 return(err);
}

int GUI_Pan_NCP_transmit(int func,uint8 *req,int rlengh,uint8 *ans,int alengh)
{
 FILE *fPan_send;
 FILE *fPan_recv;
 int ncp_function=func;
 int size_send=rlengh;
 int size_recv=alengh;
 int repeat_time=1;
 uint8 *send_packet=req;
 uint8 *recv_packet=ans;
 char send_file[MAXPATHLEN+MAXFNAMELEN];
 char recv_file[MAXPATHLEN+MAXFNAMELEN];
 int err;
 uint32 r;

 strcpy(send_file,start_path);
 strcat(send_file,"send.pan");
 strcpy(recv_file,start_path);
 r=rand();
 sprintf(recv_file+strlen(recv_file),"%08lx",r);
 strcat(recv_file,".rcv");

 fPan_send=fopen(send_file,"wb");
 while(!fPan_send) fPan_send=fopen(send_file,"wb");

 /*write packet to send*/
 fwrite(&ncp_function,sizeof(ncp_function),1,fPan_send);
 fwrite(&size_send,sizeof(size_send),1,fPan_send);
 fwrite(&size_recv,sizeof(size_recv),1,fPan_send);
 fwrite(&repeat_time,sizeof(repeat_time),1,fPan_send);
 if (size_send)
  fwrite(send_packet,sizeof(uint8),size_send,fPan_send);
 fwrite(recv_file,sizeof(char),MAXPATHLEN+MAXFNAMELEN,fPan_send);
 fclose(fPan_send);

 /* read result */
 fPan_recv=fopen(recv_file,"rb");
 while(!fPan_recv) fPan_recv=fopen(recv_file,"rb");
 
 fread(&err,sizeof(err),1,fPan_recv);
 fread(recv_packet,sizeof(uint8),size_recv,fPan_recv);
 fclose(fPan_recv);
 remove(recv_file);

 return(err);
}

int GUI_Pan_NCP_DoS(int func,uint8 *req,int rlengh,uint8 *ans,int alengh,
                    int rtime)
{
 FILE *fPan_send;
 int ncp_function=func;
 int size_send=rlengh;
 int size_recv=alengh;
 int repeat_time=rtime;
 uint8 *send_packet=req;
 char send_file[MAXPATHLEN+MAXFNAMELEN];

 strcpy(send_file,start_path);
 strcat(send_file,"send.pan");

 fPan_send=fopen(send_file,"wb");
 while(!fPan_send) fPan_send=fopen(send_file,"wb");

 /*write packet to send*/
 fwrite(&ncp_function,sizeof(ncp_function),1,fPan_send);
 fwrite(&size_send,sizeof(size_send),1,fPan_send);
 fwrite(&size_recv,sizeof(size_recv),1,fPan_send);
 fwrite(&repeat_time,sizeof(repeat_time),1,fPan_send);
 if (size_send)
  fwrite(send_packet,sizeof(uint8),size_send,fPan_send);
 fwrite("\0",sizeof(char),1,fPan_send);
 fclose(fPan_send);

 return(0);
}

void GUI_Pan_Adapter_Names(char names[4][132])
{
 /* this will retreive up to four possible adapter names in your PC */
 /* if you have more than that, WELL FUCK, get a PC, not a server */
 ULONG NameLength = 128;
 char AdaptersName[128],*pointer;
 #ifdef PAN_NT
 char string[128];
 #endif
 int i=0;

 PacketGetAdapterNames (AdaptersName,&NameLength);

 #ifdef PAN_NT
 sprintUnicodeName(string,AdaptersName,128);
 strcpy(AdaptersName,string);
 #endif

 names[0][0]= names[1][0]= names[2][0]= names[3][0]= '\0';
 pointer=strtok(AdaptersName," ");

 while (pointer&&(i<4))
  {
   strcpy(names[i],pointer);
   pointer=strtok(NULL," ");
   i++;
  };
}

int GUI_Pan_Open_Adapter(char *AdapterName)
{
 Pan_Adapter=NULL;

 #ifdef PAN_NT
 MakeUnicodeName(AdapterName);
 #endif
 
 Pan_Adapter=PacketOpenAdapter(AdapterName);
 if (Pan_Adapter)
  {
   PacketSetFilter(Pan_Adapter,NDIS_PACKET_TYPE_PROMISCUOUS);
   Pan_Packet=PacketAllocatePacket();
  }
 else return(-206);
 return(0);
}

void GUI_Pan_Close_Adapter()
{
 if (Pan_Adapter)
  {
   PacketFreePacket(Pan_Packet);
   PacketResetAdapter(Pan_Adapter);
   PacketCloseAdapter(Pan_Adapter);
  }
}

void GUI_Pan_Spoof_One(uint8 *Pan_buffer, uint32 length)
{
 PacketInitPacket(Pan_Packet,(BYTE*)Pan_buffer,(unicode)length);
 PacketSendPacket(Pan_Adapter,Pan_Packet,TRUE);
}

void GUI_Pan_Sniff_One(uint8 Pan_buffer[MAX_PACKET_LENGTH], uint32 *length)
{
 PacketInitPacket(Pan_Packet,(BYTE*)Pan_buffer,MAX_PACKET_LENGTH);
 PacketReceivePacket(Pan_Adapter,Pan_Packet,TRUE); /* will hold until received */
 *length=Pan_Packet->ulBytesReceived;
}

void GUI_Pan_Prepare_Sniff_Multi(uint8 Pan_buffer[MAX_PACKET_LENGTH])
{
 PacketInitPacket(Pan_Packet,(BYTE*)Pan_buffer,MAX_PACKET_LENGTH);
}

void GUI_Pan_Sniff_Multi(uint32 *length)
{
 PacketReceivePacket(Pan_Adapter,Pan_Packet,TRUE); /* will hold until received */
 *length=Pan_Packet->ulBytesReceived;
}

void StartPanServ()
{
 char file[MAXPATHLEN+MAXFNAMELEN];
 char path[MAXPATHLEN];

 strcpy(start_path,"");
 strcpy(file,start_path);
 strcpy(path,start_path);
 strcat(file,"pan_serv.exe");

 #ifdef PAN_NT
 _spawnl(P_SESSION|P_MINIMIZE,file,file,path,0);
 #else
 spawnlp(P_DETACH|P_MINIMIZE,file,file,path,0);
 #endif
}
