/*************************************************************************
 *                                                                       *
 * Project Pandora Password Hash and Hack Functions                      *
 *************************************************************************/

#ifndef PAN_FILE_H
#define PAN_FILE_H

#include "pan_glob.h"

#ifdef __cplusplus
extern "C" {
#endif

/** API functions **/

 /* Read/Write the NDS related information */

  /*Usage : err=Pan_Convert_Auto("f:\system\",0)*/
   /* convert Backup.DS */
   /* return an error if a problem occured, NDS files in specified dir */
   /* ext == "ds" -> .DS file (before SP5 on Nw4) */
   /* ext == "dib" -> .DIB file (after SP5 on Nw4 and used on Nw5 */
 #define Pan_Convert_DS(a) Pan_Convert_Auto(a, "backup.ds", NULL)
 #define Pan_Convert_DIB(a) Pan_Convert_Auto(a, "dsrepair.dib", NULL)

 int Pan_Convert_Auto(char *path,char *file, char *ext);

  /*Usage : err=Pan_Extract(&pPassList,"f:\nds\")*/
   /* return an error if a problem occured, NDS files in current dir */
   /* chained records in pPassList,last record if : last->next=NULL */
   /* ext == "NDS" -> convert entry.nds, ... */
   /* ext == "DSD" -> convert 1.dsd, ... */
 #define Pan_Extract(a, b) Pan_Extract_Auto(a, b, "NDS")

 int Pan_Extract_Auto(Pan_PassList *pPassList, char *path, char *ext);

 int Pan_GetNDSInfo(Pan_NDSBrowse *pNDSBrowse, char *path, char *ext);

 int Pan_GetValueInfo(uint8 **out, uint32 *out_lengh, uint32 *data_lengh,
                      uint32 search_object, uint32 search_attribute,
                      char *path, char *ext);

  /*Usage : err=Pan_PassList_read("PASSNAME.NDS",&pPassList)*/
   /* return an error if a problem occured */
   /* chained list of records in pPassList */
 int Pan_PassList_read(char *readfile,Pan_PassList *pPassList);

  /*Usage : err=Pan_PassList_write("PASSNAME.NDS",pPassList)*/
   /* return an error if a problem occured */
   /* The last Password record in the list MUST have last->next=NULL */
 int Pan_PassList_write(char *writefile,Pan_PassList pPassList);

  /*Usage : err=Pan_PassHack_read("WHATEVER.EXT",&pPassHack)*/
   /* return an error if a problem occured */
 int Pan_PassHack_read(char *readfile,Pan_PassHack *pPassHack);

  /*Usage : err=Pan_PassHack_write("WHATEVER.EXT",&pPassHack)*/
   /* return an error if a problem occured */
 int Pan_PassHack_write(char *writefile,Pan_PassHack *pPassHack);

#ifdef __cplusplus
}
#endif

#endif /* PAN_FILE_H */
